/********************************************************************************//*!
 * @file  mem_util.c
 * @brief  Memory utility C source code file
 * 
 * @details  Memory utility C source code file
 * 
 * @note  nothing. 
 * 
 * @attention 
 * Copyright (C) 2013-2019 MACNICA,Inc. All Rights Reserved.\n
 *   This software is licensed "AS IS". 
 *   Please perform use of this software by a user's own responsibility and expense.
 *   It cannot guarantee in the maker side about the damage which occurred by the ab-
 *   ility not to use or use this software, and all damage that occurred secondarily.
 **//*******************************************************************************/
#include <stdio.h>
#include "hwlib.h"
#include "mem_util.h"

void sample_memset_address32(uint32_t* start, size_t size)
{
	uint32_t* endnext = (uint32_t*)((uint32_t)start + size);

	while(start < endnext){
		*start = (uint32_t)start;
		start++;
		if(start < (uint32_t*)0x00000004)	break;
	}

	return;
}

void sample_memset_incrementdata(uint32_t* start, uint32_t testdata, size_t size)
{
	uint32_t* endnext = (uint32_t*)((uint32_t)start + size);

	while(start < endnext){
		*start = testdata++;
		start++;
		if(start < (uint32_t*)0x00000004)	break;
	}

	return;
}

void sample_memset_incrementdata_4byte(uint32_t* start, uint32_t testdata, size_t size)
{
	uint32_t* endnext = (void*)((uint32_t)start + size);

	while(start < endnext){
		*start++ = testdata;
		testdata += sizeof(uint32_t);
		if(start < (uint32_t*)0x00000004)	break;
	}

	return;
}

void sample_memdmp_word(const uint32_t* start, size_t size)
{
	const uint32_t*	start_for_dump = start;
	uint32_t*	end;

	if((int)start & 0xF){
		size += ((int)start & 0xF);
		start = (uint32_t*)((int)start & 0xFFFFFFF0);
	}
	if(size & 0xF){
		size += 16;
		size = size & 0xFFFFFFF0;
	}

	end = (uint32_t*)((int)start + size);

	printf("\n");
	printf("Dump Target = %p \n",start_for_dump);
	printf("ADDRESS:  +0       +4       +8       +C      \r\n");
	printf("---------+--------+--------+--------+--------\r\n");
	while(start < end){
		printf("%08X:", (int)start);
		for(int i=0; i<4; i++, start++){
			printf(" %08X", (int)*start);
		}
		printf("\r\n");
	}

	return;
}

void sample_memdmp_halfword(const uint16_t* start, size_t size)
{
	const uint16_t*	start_for_dump = start;
	uint16_t*	end;

	if((int)start & 0xF){
		size += ((int)start & 0xF);
		start = (uint16_t*)((int)start & 0xFFFFFFF0);
	}
	if(size & 0xF){
		size += 16;
		size = size & 0xFFFFFFF0;
	}

	end = (uint16_t*)((int)start + size);

	printf("\n");
	printf("Dump Target = %p \n",start_for_dump);
	printf("ADDRESS:  +0   +2   +4   +6   +8   +A   +C   +E  \r\n");
	printf("---------+----+----+----+----+----+----+----+----\r\n");
	while(start < end){
		printf("%08X:", (int)start);
		for(int i=0; i<8; i++, start++){
			printf(" %04X", (int)*start);
		}
		printf("\r\n");
	}

	return;
}

void sample_memdmp_byte(const uint8_t* start, size_t size)
{
	const uint8_t*	start_for_dump = start;
	uint8_t*	end;
	uint8_t		ascii[17];

	if((int)start & 0xF){
		size += ((int)start & 0xF);
		start = (uint8_t*)((int)start & 0xFFFFFFF0);
	}
	if(size & 0xF){
		size += 16;
		size = size & 0xFFFFFFF0;
	}

	end = (uint8_t*)((int)start + size);

	printf("\n");
	printf("Dump Target = %p \n",start_for_dump);
	printf("ADDRESS:  +0 +1 +2 +3 +4 +5 +6 +7 +8 +9 +A +B +C +D +E +F | 1BYTE-CHAR     \r\n");
	printf("---------+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+---+----------------\r\n");
	while(start < end){
		printf("%08X:", (int)start);
		for(int i=0; i<16; i++, start++){
			printf(" %02X", (int)*start);

			if((*start < ' ') || ('~' < *start)){
				ascii[i] = '.';
			} else {
				ascii[i] = *start;
			}
		}
		ascii[16] = '\0';
		printf(" |%s\r\n", ascii);
	}

	return;
}
