/***********************************************************************************
*                                                                                  *
* Copyright 2013-2015 Altera Corporation. All Rights Reserved.                     *
*                                                                                  *
* Redistribution and use in source and binary forms, with or without               *
* modification, are permitted provided that the following conditions are met:      *
*                                                                                  *
* 1. Redistributions of source code must retain the above copyright notice,        *
*    this list of conditions and the following disclaimer.                         *
*                                                                                  *
* 2. Redistributions in binary form must reproduce the above copyright notice,     *
*    this list of conditions and the following disclaimer in the documentation     *
*    and/or other materials provided with the distribution.                        *
*                                                                                  *
* 3. Neither the name of the copyright holder nor the names of its contributors    *
*    may be used to endorse or promote products derived from this software without *
*    specific prior written permission.                                            *
*                                                                                  *
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"      *
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE        *
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE        *
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR              *
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF             *
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN          *
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)          *
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE       *
* POSSIBILITY OF SUCH DAMAGE.                                                      *
*                                                                                  *
***********************************************************************************/

/* Altera - ALT_EMAC */

#ifndef __ALT_SOCAL_EMAC_H__
#define __ALT_SOCAL_EMAC_H__

#ifndef __ASSEMBLY__
#ifdef __cplusplus
#include <cstdint>
extern "C"
{
#else   /* __cplusplus */
#include <stdint.h>
#endif  /* __cplusplus */
#endif  /* __ASSEMBLY__ */

/*
 * Component : ALT_EMAC
 * 
 */
/*
 * Register : gmacgrp_mac_configuration
 * 
 * <b> Register 0 (MAC Configuration Register)  </b>
 * 
 * The MAC Configuration register establishes receive and transmit operating modes.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                  
 * :--------|:-------|:------|:------------------------------
 *  [1:0]   | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_PRELEN 
 *  [2]     | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_RE     
 *  [3]     | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_TE     
 *  [4]     | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_DC     
 *  [6:5]   | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_BL     
 *  [7]     | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_ACS    
 *  [8]     | R      | 0x0   | ALT_EMAC_GMAC_MAC_CFG_LUD    
 *  [9]     | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_DR     
 *  [10]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_IPC    
 *  [11]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_DM     
 *  [12]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_LM     
 *  [13]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_DO     
 *  [14]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_FES    
 *  [15]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_PS     
 *  [16]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_DCRS   
 *  [19:17] | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_IFG    
 *  [20]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_JE     
 *  [21]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_BE     
 *  [22]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_JD     
 *  [23]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_WD     
 *  [24]    | R      | 0x0   | ALT_EMAC_GMAC_MAC_CFG_TC     
 *  [25]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_CST    
 *  [26]    | R      | 0x0   | ALT_EMAC_GMAC_MAC_CFG_SFTERR 
 *  [27]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_TWOKPE 
 *  [30:28] | RW     | 0x0   | ALT_EMAC_GMAC_MAC_CFG_SARC   
 *  [31]    | R      | 0x0   | ALT_EMAC_GMAC_MAC_CFG_RSVD_31
 * 
 */
/*
 * Field : prelen
 * 
 * Preamble Length for Transmit Frames
 * 
 * These bits control the number of preamble bytes that are added to the beginning
 * of every Transmit frame. The preamble reduction occurs only when the MAC is
 * operating in the full-duplex mode.
 * 
 * * 2'b00: 7 bytes of preamble
 * 
 * * 2'b01: 5 byte of preamble
 * 
 * * 2'b10: 3 bytes of preamble
 * 
 * * 2'b11: 1 byte of preamble
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description
 * :-------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_PRELEN_E_PREAM7BYTES | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_PRELEN_E_PREAM5BYTES | 0x1   |            
 *  ALT_EMAC_GMAC_MAC_CFG_PRELEN_E_PREAM3BYTES | 0x2   |            
 *  ALT_EMAC_GMAC_MAC_CFG_PRELEN_E_PREAM1BYTE  | 0x3   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_PRELEN
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_E_PREAM7BYTES  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_PRELEN
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_E_PREAM5BYTES  0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_PRELEN
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_E_PREAM3BYTES  0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_PRELEN
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_E_PREAM1BYTE   0x3

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_PRELEN register field. */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_PRELEN register field. */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_PRELEN register field. */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_PRELEN register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_SET_MSK    0x00000003
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_PRELEN register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_CLR_MSK    0xfffffffc
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_PRELEN register field. */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_PRELEN field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_PRELEN register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_SET(value) (((value) << 0) & 0x00000003)

/*
 * Field : re
 * 
 * Receiver Enable
 * 
 * When this bit is set, the receiver state machine of the MAC is enabled for
 * receiving frames from the GMII or MII. When this bit is reset, the MAC receive
 * state machine is disabled after the completion of the reception of the current
 * frame, and does not receive any further frames from the GMII or MII.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description
 * :--------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_RE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_RE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_RE
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_RE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_RE
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_RE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_RE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_RE_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_RE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_RE_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_RE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_RE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_RE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_RE_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_RE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_RE_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_RE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_RE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_RE field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_RE_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_RE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_RE_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : te
 * 
 * Transmitter Enable
 * 
 * When this bit is set, the transmit state machine of the MAC is enabled for
 * transmission on the GMII or MII. When this bit is reset, the MAC transmit state
 * machine is disabled after the completion of the transmission of the current
 * frame, and does not transmit any further frames.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description
 * :--------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_TE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_TE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_TE
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_TE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_TE
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_TE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_TE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TE_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_TE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TE_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_TE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_TE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_TE_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_TE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_TE_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_TE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_TE field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_TE_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_TE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_TE_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : dc
 * 
 * Deferral Check
 * 
 * When this bit is set, the deferral check function is enabled in the MAC. The MAC
 * issues a Frame Abort status, along with the excessive deferral error bit set in
 * the transmit frame status, when the transmit state machine is deferred for more
 * than 24,288 bit times in the 10 or 100 Mbps mode.
 * 
 * If the MAC is configured for 1000 Mbps operation or if the Jumbo frame mode is
 * enabled in the 10 or 100 Mbps mode, the threshold for deferral is 155,680 bits
 * times. Deferral begins when the transmitter is ready to transmit, but it is
 * prevented because of an active carrier sense signal (CRS) on GMII or MII.
 * 
 * The defer time is not cumulative. For example, if the transmitter defers for
 * 10,000 bit times because the CRS signal is active and then the CRS signal
 * becomes inactive, the transmitter transmits and collision happens. Because of
 * collision, the transmitter needs to back off and then defer again after back off
 * completion. In such a scenario, the deferral timer is reset to 0 and it is
 * restarted.
 * 
 * When this bit is reset, the deferral check function is disabled and the MAC
 * defers until the CRS signal goes inactive. This bit is applicable only in the
 * half-duplex mode and is reserved (RO) in the full-duplex-only configuration.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description
 * :--------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_DC_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_DC_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DC
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_DC_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DC
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_DC_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_DC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DC_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_DC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DC_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_DC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DC_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_DC register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DC_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_DC register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DC_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_DC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DC_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_DC field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_DC_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_DC register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_DC_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : bl
 * 
 * Back-Off Limit
 * 
 * The Back-Off limit determines the random integer number (r) of slot time delays
 * (4,096 bit times for 1000 Mbps and 512 bit times for 10/100 Mbps) for which the
 * MAC waits before rescheduling a transmission attempt during retries after a
 * collision. This bit is applicable only in the half-duplex mode and is reserved
 * (RO) in the full-duplex-only configuration.
 * 
 * * 00: k = min (n, 10)
 * 
 * * 01: k = min (n, 8)
 * 
 * * 10: k = min (n, 4)
 * 
 * * 11: k = min (n, 1)
 * 
 * where <i> n </i> = retransmission attempt. The random integer <i> r </i> takes
 * the value in the
 * 
 * range 0 <= r < kth power of 2
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_BL_E_BACKLIMTR10 | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_BL_E_BACKLIMIRT8 | 0x1   |            
 *  ALT_EMAC_GMAC_MAC_CFG_BL_E_BACKLIMITR4 | 0x2   |            
 *  ALT_EMAC_GMAC_MAC_CFG_BL_E_BACKLIMITR1 | 0x3   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_BL
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_BL_E_BACKLIMTR10  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_BL
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_BL_E_BACKLIMIRT8  0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_BL
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_BL_E_BACKLIMITR4  0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_BL
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_BL_E_BACKLIMITR1  0x3

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_BL register field. */
#define ALT_EMAC_GMAC_MAC_CFG_BL_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_BL register field. */
#define ALT_EMAC_GMAC_MAC_CFG_BL_MSB        6
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_BL register field. */
#define ALT_EMAC_GMAC_MAC_CFG_BL_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_BL register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_BL_SET_MSK    0x00000060
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_BL register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_BL_CLR_MSK    0xffffff9f
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_BL register field. */
#define ALT_EMAC_GMAC_MAC_CFG_BL_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_BL field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_BL_GET(value) (((value) & 0x00000060) >> 5)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_BL register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_BL_SET(value) (((value) << 5) & 0x00000060)

/*
 * Field : acs
 * 
 * Automatic Pad or CRC Stripping
 * 
 * When this bit is set, the MAC strips the Pad or FCS field on the incoming frames
 * only if the value of the length field is less than 1,536 bytes. All received
 * frames with length field greater than or equal to 1,536 bytes are passed to the
 * application without stripping the Pad or FCS field.
 * 
 * When this bit is reset, the MAC passes all incoming frames, without modifying
 * them, to the Host.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description
 * :---------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_ACS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_ACS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_ACS
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_ACS
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_ACS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_ACS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_ACS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_ACS register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_SET_MSK    0x00000080
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_ACS register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_CLR_MSK    0xffffff7f
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_ACS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_ACS field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_ACS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : lud
 * 
 * Link Up or Down
 * 
 * This bit indicates whether the link is up or down during the transmission of
 * configuration in the RGMII, SGMII, or SMII interface:
 * 
 * * 0: Link Down
 * 
 * * 1: Link Up
 * 
 * This bit is reserved (RO with default value) and is enabled when the RGMII,
 * SGMII, or SMII interface is enabled during core configuration.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description
 * :---------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_LUD_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_LUD_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_LUD
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_LUD
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_LUD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_LUD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_LUD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_LUD register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_LUD register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_LUD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_LUD field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_LUD register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : dr
 * 
 * Disable Retry
 * 
 * When this bit is set, the MAC attempts only one transmission. When a collision
 * occurs on the GMII or MII interface, the MAC ignores the current frame
 * transmission and reports a Frame Abort with excessive collision error in the
 * transmit frame status.
 * 
 * When this bit is reset, the MAC attempts retries based on the settings of the BL
 * field (Bits [6:5]). This bit is applicable only in the half-duplex mode and is
 * reserved (RO with default value) in the full-duplex-only configuration.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description
 * :--------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_DR_E_END  | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_DR_E_DISD | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DR
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_DR_E_END  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DR
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_DR_E_DISD 0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_DR register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DR_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_DR register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DR_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_DR register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DR_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_DR register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DR_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_DR register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DR_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_DR register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DR_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_DR field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_DR_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_DR register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_DR_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : ipc
 * 
 * Checksum Offload
 * 
 * When this bit is set, the MAC calculates the 16-bit one's complement of the
 * one's complement sum of all received Ethernet frame payloads. It also checks
 * whether the IPv4 Header checksum (assumed to be bytes 2526 or 2930 (VLAN-tagged)
 * of the received Ethernet frame) is correct for the received frame and gives the
 * status in the receive status word. The MAC also appends the 16-bit checksum
 * calculated for the IP header datagram payload (bytes after the IPv4 header) and
 * appends it to the Ethernet frame transferred to the application (when Type 2 COE
 * is deselected).
 * 
 * When this bit is reset, this function is disabled.
 * 
 * When Type 2 COE is selected, this bit, when set, enables the IPv4 header
 * checksum checking and IPv4 or IPv6 TCP, UDP, or ICMP payload checksum checking.
 * When this bit is reset, the COE function in the receiver is disabled and the
 * corresponding PCE and IP HCE status bits are always cleared.
 * 
 * If the IP Checksum Offload feature is not enabled during core configuration,
 * this bit is reserved (RO with default value).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description
 * :---------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_IPC_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_IPC_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IPC
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IPC
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_IPC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_IPC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_IPC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_IPC register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_SET_MSK    0x00000400
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_IPC register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_CLR_MSK    0xfffffbff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_IPC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_IPC field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_IPC register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : dm
 * 
 * Duplex Mode
 * 
 * When this bit is set, the MAC operates in the full-duplex mode where it can
 * transmit and receive simultaneously. This bit is RO with default value of 1'b1
 * in the full-duplex-only configuration.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description
 * :--------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_DM_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_DM_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DM
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_DM_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DM
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_DM_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_DM register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DM_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_DM register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DM_MSB        11
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_DM register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_DM register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DM_SET_MSK    0x00000800
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_DM register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DM_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_DM register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_DM field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_DM_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_DM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_DM_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : lm
 * 
 * Loopback Mode
 * 
 * When this bit is set, the MAC operates in the loopback mode at GMII or MII. The
 * (G)MII Receive clock input (clk_rx_i) is required for the loopback to work
 * properly, because the Transmit clock is not looped-back internally.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description
 * :--------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_LM_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_LM_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_LM
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_LM_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_LM
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_LM_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_LM register field. */
#define ALT_EMAC_GMAC_MAC_CFG_LM_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_LM register field. */
#define ALT_EMAC_GMAC_MAC_CFG_LM_MSB        12
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_LM register field. */
#define ALT_EMAC_GMAC_MAC_CFG_LM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_LM register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_LM_SET_MSK    0x00001000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_LM register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_LM_CLR_MSK    0xffffefff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_LM register field. */
#define ALT_EMAC_GMAC_MAC_CFG_LM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_LM field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_LM_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_LM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_LM_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : do
 * 
 * Disable Receive Own
 * 
 * When this bit is set, the MAC disables the reception of frames when the
 * phy_txen_o is asserted in the half-duplex mode.
 * 
 * When this bit is reset, the MAC receives all packets that are given by the PHY
 * while transmitting.
 * 
 * This bit is not applicable if the MAC is operating in the full-duplex mode. This
 * bit is reserved (RO with default value) if the MAC is configured for the full-
 * duplex-only operation.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description
 * :--------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_DO_E_END  | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_DO_E_DISD | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DO
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_DO_E_END  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DO
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_DO_E_DISD 0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_DO register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DO_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_DO register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DO_MSB        13
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_DO register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DO_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_DO register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DO_SET_MSK    0x00002000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_DO register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DO_CLR_MSK    0xffffdfff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_DO register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DO_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_DO field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_DO_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_DO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_DO_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : fes
 * 
 * Speed
 * 
 * This bit selects the speed in the MII, RMII, SMII, RGMII, SGMII, or RevMII
 * interface
 * 
 * * 0: 10 Mbps
 * 
 * * 1: 100 Mbps
 * 
 * This bit is reserved (RO) by default and is enabled only when the parameter
 * SPEED_SELECT = Enabled. This bit generates link speed encoding when Bit 24 (TC)
 * is set in the RGMII, SMII, or SGMII mode. This bit is always enabled for RGMII,
 * SGMII, SMII, or RevMII interface.
 * 
 * In configurations with RGMII, SGMII, SMII, or RevMII interface, this bit is
 * driven as an output signal (mac_speed_o[0]) to reflect the value of this bit in
 * the mac_speed_o signal. In configurations with RMII, MII, or GMII interface, you
 * can optionally drive this bit as an output signal (mac_speed_o[0]) to reflect
 * its value in the mac_speed_o signal.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_FES_E_SPEED10  | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_FES_E_SPEED100 | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_FES
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_FES_E_SPEED10     0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_FES
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_FES_E_SPEED100    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_FES register field. */
#define ALT_EMAC_GMAC_MAC_CFG_FES_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_FES register field. */
#define ALT_EMAC_GMAC_MAC_CFG_FES_MSB        14
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_FES register field. */
#define ALT_EMAC_GMAC_MAC_CFG_FES_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_FES register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_FES_SET_MSK    0x00004000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_FES register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_FES_CLR_MSK    0xffffbfff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_FES register field. */
#define ALT_EMAC_GMAC_MAC_CFG_FES_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_FES field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_FES_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_FES register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_FES_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : ps
 * 
 * Port Select
 * 
 * This bit selects the Ethernet line speed:
 * 
 * * 0: For 1000 Mbps operations
 * 
 * * 1: For 10 or 100 Mbps operations
 * 
 * In 10 or 100 Mbps operations, this bit, along with FES bit, selects the exact
 * line speed. In the 10 or 100 Mbps-only (always 1) or 1000 Mbps-only (always 0)
 * configurations, this bit is read-only with the appropriate value. In default 10,
 * 100, or 1000 Mbps configuration, this bit is R_W. The mac_portselect_o signal
 * reflects the value of this bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_PS_E_GMII1000SEL | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_PS_E_MII10100SEL | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_PS
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_PS_E_GMII1000SEL  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_PS
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_PS_E_MII10100SEL  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_PS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_PS_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_PS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_PS_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_PS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_PS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_PS register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_PS_SET_MSK    0x00008000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_PS register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_PS_CLR_MSK    0xffff7fff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_PS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_PS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_PS field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_PS_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_PS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_PS_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : dcrs
 * 
 * Disable Carrier Sense During Transmission
 * 
 * When set high, this bit makes the MAC transmitter ignore the (G)MII CRS signal
 * during frame transmission in the half-duplex mode. This request results in no
 * errors generated because of Loss of Carrier or No Carrier during such
 * transmission. When this bit is low, the MAC transmitter generates such errors
 * because of Carrier Sense and can even abort the transmissions.
 * 
 * This bit is reserved (and RO) in the full-duplex-only configurations.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description
 * :----------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_DCRS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_DCRS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DCRS
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DCRS
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_DCRS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_DCRS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_DCRS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_DCRS register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_DCRS register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_DCRS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_DCRS field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_DCRS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : ifg
 * 
 * Inter-Frame Gap
 * 
 * These bits control the minimum IFG between frames during transmission.
 * 
 * * 000: 96 bit times
 * 
 * * 001: 88 bit times
 * 
 * * 010: 80 bit times
 * 
 * * ...
 * 
 * * 111: 40 bit times
 * 
 * In the half-duplex mode, the minimum IFG can be configured only for 64 bit times
 * (IFG = 100). Lower values are not considered. In the 1000-Mbps mode, the minimum
 * IFG supported is 64 bit times (and above) in the GMAC-CORE configuration and 80
 * bit times (and above) in other configurations.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG96BITTIMES | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG88BITTIMES | 0x1   |            
 *  ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG80BITTIMES | 0x2   |            
 *  ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG72BITTIMES | 0x3   |            
 *  ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG64BITTIMES | 0x4   |            
 *  ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG56BITTIMES | 0x5   |            
 *  ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG48BITTIMES | 0x6   |            
 *  ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG40BITTIMES | 0x7   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IFG
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG96BITTIMES   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IFG
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG88BITTIMES   0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IFG
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG80BITTIMES   0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IFG
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG72BITTIMES   0x3
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IFG
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG64BITTIMES   0x4
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IFG
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG56BITTIMES   0x5
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IFG
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG48BITTIMES   0x6
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IFG
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG40BITTIMES   0x7

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_IFG register field. */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_IFG register field. */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_MSB        19
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_IFG register field. */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_WIDTH      3
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_IFG register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_SET_MSK    0x000e0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_IFG register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_CLR_MSK    0xfff1ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_IFG register field. */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_IFG field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_GET(value) (((value) & 0x000e0000) >> 17)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_IFG register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_SET(value) (((value) << 17) & 0x000e0000)

/*
 * Field : je
 * 
 * Jumbo Frame Enable
 * 
 * When this bit is set, the MAC allows Jumbo frames of 9,018 bytes (9,022 bytes
 * for VLAN tagged frames) without reporting a giant frame error in the receive
 * frame status.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description
 * :--------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_JE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_JE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_JE
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_JE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_JE
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_JE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_JE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_JE_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_JE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_JE_MSB        20
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_JE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_JE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_JE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_JE_SET_MSK    0x00100000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_JE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_JE_CLR_MSK    0xffefffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_JE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_JE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_JE field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_JE_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_JE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_JE_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : be
 * 
 * Frame Burst Enable
 * 
 * When this bit is set, the MAC allows frame bursting during transmission in the
 * GMII half-duplex mode. This bit is reserved (and RO) in the 10/100 Mbps only or
 * full-duplex-only configurations.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description
 * :--------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_BE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_BE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_BE
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_BE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_BE
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_BE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_BE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_BE_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_BE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_BE_MSB        21
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_BE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_BE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_BE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_BE_SET_MSK    0x00200000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_BE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_BE_CLR_MSK    0xffdfffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_BE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_BE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_BE field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_BE_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_BE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_BE_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : jd
 * 
 * Jabber Disable
 * 
 * When this bit is set, the MAC disables the jabber timer on the transmitter. The
 * MAC can transfer frames of up to 16,384 bytes.
 * 
 * When this bit is reset, the MAC cuts off the transmitter if the application
 * sends out more than 2,048 bytes of data (10,240 if JE is set high) during
 * transmission.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description
 * :--------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_JD_E_END  | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_JD_E_DISD | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_JD
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_JD_E_END  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_JD
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_JD_E_DISD 0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_JD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_JD_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_JD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_JD_MSB        22
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_JD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_JD_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_JD register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_JD_SET_MSK    0x00400000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_JD register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_JD_CLR_MSK    0xffbfffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_JD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_JD_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_JD field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_JD_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_JD register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_JD_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : wd
 * 
 * Watchdog Disable
 * 
 * When this bit is set, the MAC disables the watchdog timer on the receiver. The
 * MAC can receive frames of up to 16,384 bytes.
 * 
 * When this bit is reset, the MAC does not allow a receive frame which more than
 * 2,048 bytes (10,240 if JE is set high) or the value programmed in Register 55
 * (Watchdog Timeout Register).
 * 
 * The MAC cuts off any bytes received after the watchdog limit number of bytes.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description
 * :--------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_WD_E_END  | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_WD_E_DISD | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_WD
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_WD_E_END  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_WD
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_WD_E_DISD 0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_WD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_WD_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_WD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_WD_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_WD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_WD_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_WD register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_WD_SET_MSK    0x00800000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_WD register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_WD_CLR_MSK    0xff7fffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_WD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_WD_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_WD field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_WD_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_WD register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_WD_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : tc
 * 
 * Transmit Configuration in RGMII, SGMII, or SMII
 * 
 * When set, this bit enables the transmission of duplex mode, link speed, and link
 * up or down information to the PHY in the RGMII, SMII, or SGMII port. When this
 * bit is reset, no such information is driven to the PHY. This bit is reserved
 * (and RO) if the RGMII, SMII, or SGMII PHY port is not selected during core
 * configuration.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description
 * :--------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_TC_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_TC_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_TC
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_TC_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_TC
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_TC_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_TC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TC_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_TC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TC_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_TC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TC_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_TC register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_TC_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_TC register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_TC_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_TC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TC_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_TC field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_TC_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_TC register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_TC_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : cst
 * 
 * CRC Stripping for Type Frames
 * 
 * When this bit is set, the last 4 bytes (FCS) of all frames of Ether type
 * (Length/Type field greater than or equal to 1,536) are stripped and dropped
 * before forwarding the frame to the application. This function is not valid when
 * the IP Checksum Engine (Type 1) is enabled in the MAC receiver. This function is
 * valid when Type 2 Checksum Offload Engine is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description
 * :---------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_CST_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_CFG_CST_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_CST
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_CST_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_CST
 * 
 */
#define ALT_EMAC_GMAC_MAC_CFG_CST_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_CST register field. */
#define ALT_EMAC_GMAC_MAC_CFG_CST_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_CST register field. */
#define ALT_EMAC_GMAC_MAC_CFG_CST_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_CST register field. */
#define ALT_EMAC_GMAC_MAC_CFG_CST_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_CST register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_CST_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_CST register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_CST_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_CST register field. */
#define ALT_EMAC_GMAC_MAC_CFG_CST_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_CST field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_CST_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_CST register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_CST_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : sfterr
 * 
 * SMII Force Transmit Error
 * 
 * When set, this bit indicates to the PHY to force a transmit error in the SMII
 * frame being transmitted. This bit is reserved if the SMII PHY port is not
 * selected during core configuration.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_SFTERR register field. */
#define ALT_EMAC_GMAC_MAC_CFG_SFTERR_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_SFTERR register field. */
#define ALT_EMAC_GMAC_MAC_CFG_SFTERR_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_SFTERR register field. */
#define ALT_EMAC_GMAC_MAC_CFG_SFTERR_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_SFTERR register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_SFTERR_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_SFTERR register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_SFTERR_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_SFTERR register field. */
#define ALT_EMAC_GMAC_MAC_CFG_SFTERR_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_SFTERR field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_SFTERR_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_SFTERR register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_SFTERR_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : twokpe
 * 
 * IEEE 802.3as Support for 2K Packets
 * 
 * When set, the MAC considers all frames, with up to 2,000 bytes length, as normal
 * packets.
 * 
 * When Bit 20 (JE) is not set, the MAC considers all received frames of size more
 * than 2K bytes as Giant frames. When this bit is reset and Bit 20 (JE) is not
 * set, the MAC considers all received frames of size more than 1,518 bytes (1,522
 * bytes for tagged) as Giant frames. When Bit 20 is set, setting this bit has no
 * effect on Giant Frame status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_TWOKPE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TWOKPE_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_TWOKPE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TWOKPE_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_TWOKPE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TWOKPE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_TWOKPE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_TWOKPE_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_TWOKPE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_TWOKPE_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_TWOKPE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TWOKPE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_TWOKPE field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_TWOKPE_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_TWOKPE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_TWOKPE_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : sarc
 * 
 * Source Address Insertion or Replacement Control
 * 
 * This field controls the source address insertion or replacement for all
 * transmitted frames. Bit 30 specifies which MAC Address register (0 or 1) is used
 * for source address insertion or replacement based on the values of Bits [29:28]:
 * 
 * * 2'b0x: The input signals mti_sa_ctrl_i and ati_sa_ctrl_i control the SA field
 *   generation.
 * 
 * * 2'b10:
 * 
 *     - If Bit 30 is set to 0, the MAC inserts the content of the MAC Address 0
 *       registers (registers 16 and 17) in the SA field of all transmitted frames.
 * 
 *     - If Bit 30 is set to 1 and the Enable MAC Address Register 1 option is
 *       selected during core configuration, the MAC inserts the content of the MAC
 *       Address 1 registers (registers 18 and 19) in the SA field of all
 *       transmitted frames.
 * 
 * * 2'b11:
 * 
 *     - If Bit 30 is set to 0, the MAC replaces the content of the MAC Address 0
 *       registers (registers 16 and 17) in the SA field of all transmitted frames.
 * 
 *     - If Bit 30 is set to 1 and the Enable MAC Address Register 1 option is
 *       selected during core configuration, the MAC replaces the content of the
 *       MAC Address 1 registers (registers 18 and 19) in the SA field of all
 *       transmitted frames.
 * 
 * Note:
 * 
 *     - Changes to this field take effect only on the start of a frame. If you
 *       write this register field when a frame is being transmitted, only the
 *       subsequent frame can use the updated value, that is, the current frame
 *       does not use the updated value.
 * 
 *     - These bits are reserved and RO when the Enable SA, VLAN, and CRC Insertion
 *       on TX feature is not selected during core configuration.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_SARC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_SARC_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_SARC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_SARC_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_SARC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_SARC_WIDTH      3
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_SARC register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_SARC_SET_MSK    0x70000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_SARC register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_SARC_CLR_MSK    0x8fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_SARC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_SARC_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_SARC field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_SARC_GET(value) (((value) & 0x70000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_SARC register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_SARC_SET(value) (((value) << 28) & 0x70000000)

/*
 * Field : reserved_31
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_RSVD_31 register field. */
#define ALT_EMAC_GMAC_MAC_CFG_RSVD_31_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_RSVD_31 register field. */
#define ALT_EMAC_GMAC_MAC_CFG_RSVD_31_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_RSVD_31 register field. */
#define ALT_EMAC_GMAC_MAC_CFG_RSVD_31_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_RSVD_31 register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_RSVD_31_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_RSVD_31 register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_RSVD_31_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_RSVD_31 register field. */
#define ALT_EMAC_GMAC_MAC_CFG_RSVD_31_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_RSVD_31 field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_RSVD_31_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_RSVD_31 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_RSVD_31_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_CFG.
 */
struct ALT_EMAC_GMAC_MAC_CFG_s
{
    uint32_t        prelen      :  2;  /* ALT_EMAC_GMAC_MAC_CFG_PRELEN */
    uint32_t        re          :  1;  /* ALT_EMAC_GMAC_MAC_CFG_RE */
    uint32_t        te          :  1;  /* ALT_EMAC_GMAC_MAC_CFG_TE */
    uint32_t        dc          :  1;  /* ALT_EMAC_GMAC_MAC_CFG_DC */
    uint32_t        bl          :  2;  /* ALT_EMAC_GMAC_MAC_CFG_BL */
    uint32_t        acs         :  1;  /* ALT_EMAC_GMAC_MAC_CFG_ACS */
    const uint32_t  lud         :  1;  /* ALT_EMAC_GMAC_MAC_CFG_LUD */
    uint32_t        dr          :  1;  /* ALT_EMAC_GMAC_MAC_CFG_DR */
    uint32_t        ipc         :  1;  /* ALT_EMAC_GMAC_MAC_CFG_IPC */
    uint32_t        dm          :  1;  /* ALT_EMAC_GMAC_MAC_CFG_DM */
    uint32_t        lm          :  1;  /* ALT_EMAC_GMAC_MAC_CFG_LM */
    uint32_t        do_         :  1;  /* ALT_EMAC_GMAC_MAC_CFG_DO */
    uint32_t        fes         :  1;  /* ALT_EMAC_GMAC_MAC_CFG_FES */
    uint32_t        ps          :  1;  /* ALT_EMAC_GMAC_MAC_CFG_PS */
    uint32_t        dcrs        :  1;  /* ALT_EMAC_GMAC_MAC_CFG_DCRS */
    uint32_t        ifg         :  3;  /* ALT_EMAC_GMAC_MAC_CFG_IFG */
    uint32_t        je          :  1;  /* ALT_EMAC_GMAC_MAC_CFG_JE */
    uint32_t        be          :  1;  /* ALT_EMAC_GMAC_MAC_CFG_BE */
    uint32_t        jd          :  1;  /* ALT_EMAC_GMAC_MAC_CFG_JD */
    uint32_t        wd          :  1;  /* ALT_EMAC_GMAC_MAC_CFG_WD */
    const uint32_t  tc          :  1;  /* ALT_EMAC_GMAC_MAC_CFG_TC */
    uint32_t        cst         :  1;  /* ALT_EMAC_GMAC_MAC_CFG_CST */
    const uint32_t  sfterr      :  1;  /* ALT_EMAC_GMAC_MAC_CFG_SFTERR */
    uint32_t        twokpe      :  1;  /* ALT_EMAC_GMAC_MAC_CFG_TWOKPE */
    uint32_t        sarc        :  3;  /* ALT_EMAC_GMAC_MAC_CFG_SARC */
    const uint32_t  reserved_31 :  1;  /* ALT_EMAC_GMAC_MAC_CFG_RSVD_31 */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_CFG. */
typedef volatile struct ALT_EMAC_GMAC_MAC_CFG_s  ALT_EMAC_GMAC_MAC_CFG_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_CFG register. */
#define ALT_EMAC_GMAC_MAC_CFG_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_MAC_CFG register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_CFG_OFST        0x0
/* The address of the ALT_EMAC_GMAC_MAC_CFG register. */
#define ALT_EMAC_GMAC_MAC_CFG_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_CFG_OFST))

/*
 * Register : gmacgrp_mac_frame_filter
 * 
 * <b> Register 1 (MAC Frame Filter) </b>
 * 
 * The MAC Frame Filter register contains the filter controls for receiving frames.
 * Some of the controls from this register go to the address check block of the
 * MAC, which performs the first level of address filtering. The second level of
 * filtering is performed on the incoming frame, based on other controls such as
 * Pass Bad Frames and Pass Control Frames.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                         
 * :--------|:-------|:------|:-------------------------------------
 *  [0]     | RW     | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_PR        
 *  [1]     | R      | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_HUC       
 *  [2]     | R      | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_HMC       
 *  [3]     | RW     | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF      
 *  [4]     | RW     | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_PM        
 *  [5]     | RW     | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_DBF       
 *  [7:6]   | RW     | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_PCF       
 *  [8]     | RW     | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF      
 *  [9]     | RW     | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_SAF       
 *  [10]    | R      | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_HPF       
 *  [15:11] | R      | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11
 *  [16]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE      
 *  [19:17] | R      | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17
 *  [20]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE      
 *  [21]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU      
 *  [30:22] | R      | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22
 *  [31]    | RW     | 0x0   | ALT_EMAC_GMAC_MAC_FRM_FLT_RA        
 * 
 */
/*
 * Field : pr
 * 
 * Promiscuous Mode
 * 
 * When this bit is set, the Address Filter module passes all incoming frames
 * regardless of its destination or source address. The SA or DA Filter Fails
 * status bits of the Receive Status Word are always cleared when PR is set.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description
 * :------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_PR_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_PR_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_PR
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_PR
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_PR register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_PR register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_PR register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_PR register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_PR register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_PR register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_PR field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_PR register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : huc
 * 
 * Hash Unicast
 * 
 * When set, MAC performs destination address filtering of unicast frames according
 * to the hash table.
 * 
 * When reset, the MAC performs a perfect destination address filtering for unicast
 * frames, that is, it compares the DA field with the values programmed in DA
 * registers.
 * 
 * If Hash Filter is not selected during core configuration, this bit is reserved
 * (and RO).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_HUC
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_HUC
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_HUC register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_HUC register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_HUC register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_HUC register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_HUC register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_HUC register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_HUC field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_HUC register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : hmc
 * 
 * Hash Multicast
 * 
 * When set, MAC performs destination address filtering of received multicast
 * frames according to the hash table.
 * 
 * When reset, the MAC performs a perfect destination address filtering for
 * multicast frames, that is, it compares the DA field with the values programmed
 * in DA registers.
 * 
 * If Hash Filter is not selected during core configuration, this bit is reserved
 * (and RO).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_HMC
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_HMC
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_HMC register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_HMC register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_HMC register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_HMC register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_HMC register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_HMC register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_HMC field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_HMC register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : daif
 * 
 * DA Inverse Filtering
 * 
 * When this bit is set, the Address Check block operates in inverse filtering mode
 * for the DA address comparison for both unicast and multicast frames.
 * 
 * When reset, normal filtering of frames is performed.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description
 * :--------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : pm
 * 
 * Pass All Multicast
 * 
 * When set, this bit indicates that all received frames with a multicast
 * destination address (first bit in the destination address field is '1') are
 * passed.
 * 
 * When reset, filtering of multicast frame depends on HMC bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description
 * :------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_PM_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_PM_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_PM
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_PM
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_PM register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_PM register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_PM register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_PM register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_PM register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_PM register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_PM field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_PM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : dbf
 * 
 * Disable Broadcast Frames
 * 
 * When this bit is set, the AFM module filters all incoming broadcast frames. In
 * addition, it overrides all other filter settings.
 * 
 * When this bit is reset, the AFM module passes all received broadcast frames.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_DBF
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_DBF
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_DBF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_DBF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_DBF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_DBF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_SET_MSK    0x00000020
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_DBF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_CLR_MSK    0xffffffdf
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_DBF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_DBF field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_DBF register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : pcf
 * 
 * Pass Control Frames
 * 
 * These bits control the forwarding of all control frames (including unicast and
 * multicast PAUSE frames).
 * 
 * * 00: MAC filters all control frames from reaching the application.
 * 
 * * 01: MAC forwards all control frames except PAUSE control frames to application
 *   even if they fail the Address filter.
 * 
 * * 10: MAC forwards all control frames to application even if they fail the
 *   Address Filter.
 * 
 * * 11: MAC forwards control frames that pass the Address Filter.
 * 
 * The following conditions should be true for the PAUSE control frames processing:
 * 
 * * Condition 1: The MAC is in the full-duplex mode and flow control is enabled by
 *   setting Bit 2 (RFE) of Register 6 (Flow Control Register) to 1.
 * 
 * * Condition 2: The destination address (DA) of the received frame matches the
 *   special multicast address or the MAC Address 0 when Bit 3 (UP) of the Register
 *   6 (Flow Control Register) is set.
 * 
 * * Condition 3: The Type field of the received frame is 0x8808 and the OPCODE
 *   field is 0x0001.
 * 
 * Note:
 * 
 * This field should be set to 01 only when the Condition 1 is true, that is, the
 * MAC is programmed to operate in the full-duplex mode and the RFE bit is enabled.
 * Otherwise, the PAUSE frame filtering may be inconsistent. When Condition 1 is
 * false, the PAUSE frames are considered as generic control frames. Therefore, to
 * pass all control frames (including PAUSE control frames) when the full-duplex
 * mode and flow control is not enabled, you should set the PCF field to 10 or 11
 * (as required by the application).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_E_MACFLTALLCFR | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_E_MACFWDXPAUSE | 0x1   |            
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_E_MACFWDFAIL   | 0x2   |            
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_E_MACFWDPASS   | 0x3   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_PCF
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_E_MACFLTALLCFR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_PCF
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_E_MACFWDXPAUSE    0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_PCF
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_E_MACFWDFAIL      0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_PCF
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_E_MACFWDPASS      0x3

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_PCF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_PCF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_PCF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_PCF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_SET_MSK    0x000000c0
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_PCF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_CLR_MSK    0xffffff3f
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_PCF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_PCF field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_GET(value) (((value) & 0x000000c0) >> 6)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_PCF register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_SET(value) (((value) << 6) & 0x000000c0)

/*
 * Field : saif
 * 
 * SA Inverse Filtering
 * 
 * When this bit is set, the Address Check block operates in inverse filtering mode
 * for the SA address comparison. The frames whose SA matches the SA registers are
 * marked as failing the SA Address filter.
 * 
 * When this bit is reset, frames whose SA does not match the SA registers are
 * marked as failing the SA Address filter.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description
 * :--------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : saf
 * 
 * Source Address Filter Enable
 * 
 * When this bit is set, the MAC compares the SA field of the received frames with
 * the values programmed in the enabled SA registers. If the comparison fails, the
 * MAC drops the frame.
 * 
 * When this bit is reset, the MAC forwards the received frame to the application
 * with updated SAF bit of the Rx Status depending on the SA address comparison.
 * 
 * Note: According to the IEEE specification, Bit 47 of the SA is reserved and set
 * to 0. However, in DWC_gmac, the MAC compares all 48 bits. The software driver
 * should take this into consideration while programming the MAC address registers
 * for SA.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_SAF
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_SAF
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_SAF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_SAF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_SAF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_SAF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_SAF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_SAF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_SAF field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_SAF register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : hpf
 * 
 * Hash or Perfect Filter
 * 
 * When this bit is set, it configures the address filter to pass a frame if it
 * matches either the perfect filtering or the hash filtering as set by the HMC or
 * HUC bits.
 * 
 * When this bit is low and the HUC or HMC bit is set, the frame is passed only if
 * it matches the Hash filter. This bit is reserved (and RO) if the Hash filter is
 * not selected during core configuration.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_HPF
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_HPF
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_HPF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_HPF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_HPF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_HPF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_SET_MSK    0x00000400
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_HPF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_CLR_MSK    0xfffffbff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_HPF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_HPF field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_HPF register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : reserved_15_11
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11 register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11 register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11 register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11_WIDTH      5
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11 register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11_SET_MSK    0x0000f800
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11 register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11_CLR_MSK    0xffff07ff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11 register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11 field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11_GET(value) (((value) & 0x0000f800) >> 11)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11_SET(value) (((value) << 11) & 0x0000f800)

/*
 * Field : vtfe
 * 
 * VLAN Tag Filter Enable
 * 
 * When set, this bit enables the MAC to drop VLAN tagged frames that do not match
 * the VLAN Tag comparison.
 * 
 * When reset, the MAC forwards all frames irrespective of the match status of the
 * VLAN Tag.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_E_NODROP | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_E_DROP   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_E_NODROP 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_E_DROP   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : reserved_19_17
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17 register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17 register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17_MSB        19
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17 register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17_WIDTH      3
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17 register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17_SET_MSK    0x000e0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17 register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17_CLR_MSK    0xfff1ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17 register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17 field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17_GET(value) (((value) & 0x000e0000) >> 17)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17_SET(value) (((value) << 17) & 0x000e0000)

/*
 * Field : ipfe
 * 
 * Layer 3 and Layer 4 Filter Enable
 * 
 * When set, this bit enables the MAC to drop frames that do not match the enabled
 * Layer 3 and Layer 4 filters. If Layer 3 or Layer 4 filters are not enabled for
 * matching, this bit does not have any effect.
 * 
 * When reset, the MAC forwards all frames irrespective of the match status of the
 * Layer 3 and Layer 4 fields.
 * 
 * If the Layer 3 and Layer 4 Filtering feature is not selected during core
 * configuration, this bit is reserved (RO with default value).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_E_NODROP | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_E_DROP   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_E_NODROP 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_E_DROP   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_MSB        20
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_SET_MSK    0x00100000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_CLR_MSK    0xffefffff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : dntu
 * 
 * Drop non-TCP/UDP over IP Frames
 * 
 * When set, this bit enables the MAC to drop the non-TCP or UDP over IP frames.
 * The MAC forward only those frames that are processed by the Layer 4 filter.
 * 
 * When reset, this bit enables the MAC to forward all non-TCP or UDP over IP
 * frames.
 * 
 * If the Layer 3 and Layer 4 Filtering feature is not selected during core
 * configuration, this bit is reserved (RO with default value).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_E_NODROP | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_E_DROP   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_E_NODROP 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_E_DROP   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_MSB        21
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_SET_MSK    0x00200000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_CLR_MSK    0xffdfffff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : reserved_30_22
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22 register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22 register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22 register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22_WIDTH      9
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22 register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22_SET_MSK    0x7fc00000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22 register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22_CLR_MSK    0x803fffff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22 register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22 field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22_GET(value) (((value) & 0x7fc00000) >> 22)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22_SET(value) (((value) << 22) & 0x7fc00000)

/*
 * Field : ra
 * 
 * Receive All
 * 
 * When this bit is set, the MAC Receiver module passes all received frames,
 * irrespective of whether they pass the address filter or not, to the Application.
 * The result of the SA or DA filtering is updated (pass or fail) in the
 * corresponding bits in the Receive Status Word.
 * 
 * When this bit is reset, the Receiver module passes only those frames to the
 * Application that pass the SA or DA address filter.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description
 * :------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_RA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_RA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_RA
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_RA
 * 
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_RA register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_RA register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_RA register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_RA register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_RA register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_RA register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_RA field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_RA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_FRM_FLT.
 */
struct ALT_EMAC_GMAC_MAC_FRM_FLT_s
{
    uint32_t        pr             :  1;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_PR */
    const uint32_t  huc            :  1;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_HUC */
    const uint32_t  hmc            :  1;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_HMC */
    uint32_t        daif           :  1;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF */
    uint32_t        pm             :  1;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_PM */
    uint32_t        dbf            :  1;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_DBF */
    uint32_t        pcf            :  2;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_PCF */
    uint32_t        saif           :  1;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF */
    uint32_t        saf            :  1;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_SAF */
    const uint32_t  hpf            :  1;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_HPF */
    const uint32_t  reserved_15_11 :  5;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_15_11 */
    uint32_t        vtfe           :  1;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE */
    const uint32_t  reserved_19_17 :  3;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_19_17 */
    uint32_t        ipfe           :  1;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE */
    uint32_t        dntu           :  1;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU */
    const uint32_t  reserved_30_22 :  9;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_RSVD_30_22 */
    uint32_t        ra             :  1;  /* ALT_EMAC_GMAC_MAC_FRM_FLT_RA */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_FRM_FLT. */
typedef volatile struct ALT_EMAC_GMAC_MAC_FRM_FLT_s  ALT_EMAC_GMAC_MAC_FRM_FLT_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_MAC_FRM_FLT register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_OFST        0x4
/* The address of the ALT_EMAC_GMAC_MAC_FRM_FLT register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_FRM_FLT_OFST))

/*
 * Register : gmacgrp_gmii_address
 * 
 * <b> Register 4 (GMII Address Register) </b>
 * 
 * The GMII Address register controls the management cycles to the external PHY
 * through the management interface.
 * 
 * Note: This register is present for all PHY interface when you select the Station
 * Management (MDIO) feature in coreConsultant.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                       
 * :--------|:-------|:------|:-----------------------------------
 *  [0]     | RW     | 0x0   | ALT_EMAC_GMAC_GMII_ADDR_GB        
 *  [1]     | RW     | 0x0   | ALT_EMAC_GMAC_GMII_ADDR_GW        
 *  [5:2]   | RW     | 0x0   | ALT_EMAC_GMAC_GMII_ADDR_CR        
 *  [10:6]  | RW     | 0x0   | ALT_EMAC_GMAC_GMII_ADDR_GR        
 *  [15:11] | RW     | 0x0   | ALT_EMAC_GMAC_GMII_ADDR_PA        
 *  [31:16] | R      | 0x0   | ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16
 * 
 */
/*
 * Field : gb
 * 
 * GMII Busy
 * 
 * This bit should read logic 0 before writing to Register 4 and Register 5. During
 * a PHY or RevMII register access, the software sets this bit to 1'b1 to indicate
 * that a Read or Write access is in progress.
 * 
 * Register 5 is invalid until this bit is cleared by the MAC. Therefore, Register
 * 5 (GMII Data) should be kept valid until the MAC clears this bit during a PHY
 * Write operation. Similarly for a read operation, the contents of Register 5 are
 * not valid until this bit is cleared.
 * 
 * The subsequent read or write operation should happen only after the previous
 * operation is complete. Because there is no acknowledgment from the PHY to MAC
 * after a read or write operation is completed, there is no change in the
 * functionality of this bit even when the PHY is not present.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description
 * :----------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_GMII_ADDR_GB_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_GMII_ADDR_GB_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_GB
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_GB
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GMII_ADDR_GB register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GMII_ADDR_GB register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_GMII_ADDR_GB register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_GMII_ADDR_GB register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_GMII_ADDR_GB register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_GMII_ADDR_GB register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GMII_ADDR_GB field value from a register. */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_GMII_ADDR_GB register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : gw
 * 
 * GMII Write
 * 
 * When set, this bit indicates to the PHY or RevMII that this is a Write operation
 * using the GMII Data register. If this bit is not set, it indicates that this is
 * a Read operation, that is, placing the data in the GMII Data register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description
 * :----------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_GMII_ADDR_GW_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_GMII_ADDR_GW_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_GW
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_GW
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GMII_ADDR_GW register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GMII_ADDR_GW register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_GMII_ADDR_GW register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_GMII_ADDR_GW register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_GMII_ADDR_GW register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_GMII_ADDR_GW register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GMII_ADDR_GW field value from a register. */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_GMII_ADDR_GW register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : cr
 * 
 * CSR Clock Range
 * 
 * The CSR Clock Range selection determines the frequency of the MDC clock
 * according to the CSR clock frequency used in your design.
 * 
 * The suggested range of CSR clock frequency applicable for each value (when
 * Bit[5] = 0) ensures that the MDC clock is approximately between the frequency
 * range 1.0 MHz - 2.5 MHz.
 * 
 * * 0000: The frequency of the CSR clock is 60-100 MHz and the MDC clock is CSR
 *   clock/42.
 * 
 * * 0001: The frequency of the CSR clock is 100-150 MHz and the MDC clock is CSR
 *   clock/62.
 * 
 * * 0010: The frequency of the CSR clock is 20-35 MHz and the MDC clock is CSR
 *   clock/16.
 * 
 * * 0011: The frequency of the CSR clock is 35-60 MHz and the MDC clock is CSR
 *   clock/26.
 * 
 * * 0100: The frequency of the CSR clock is 150-250 MHz and the MDC clock is CSR
 *   clock/102.
 * 
 * * 0100: The frequency of the CSR clock is 250-300 MHz and the MDC clock is CSR
 *   clock/124.
 * 
 * * 0110 and 0111: Reserved
 * 
 * When Bit 5 is set, you can achieve MDC clock of frequency higher than the IEEE
 * 802.3 specified frequency limit of 2.5 MHz and program a clock divider of lower
 * value. For example, when CSR clock is of 100 MHz frequency and you program these
 * bits as 1010, then the resultant MDC clock is of 12.5 MHz which is outside the
 * limit of IEEE 802.3 specified range.
 * 
 * Program the following values only if the interfacing chips support faster MDC
 * clocks:
 * 
 * * 1000: CSR clock/4
 * 
 * * 1001: CSR clock/6
 * 
 * * 1010: CSR clock/8
 * 
 * * 1011: CSR clock/10
 * 
 * * 1100: CSR clock/12
 * 
 * * 1101: CSR clock/14
 * 
 * * 1110: CSR clock/16
 * 
 * * 1111: CSR clock/18
 * 
 * These bits are not used for accessing RevMII. These bits are read-only if the
 * RevMII interface is selected as single PHY interface.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV42      | 0x0   |            
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV62      | 0x1   |            
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV16      | 0x2   |            
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV26      | 0x3   |            
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV102     | 0x4   |            
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV124     | 0x5   |            
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV4       | 0x8   |            
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV6       | 0x9   |            
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV8       | 0xa   |            
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV10      | 0xb   |            
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV12      | 0xc   |            
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV14      | 0xd   |            
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV16AGAIN | 0xe   |            
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV18      | 0xf   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV42      0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV62      0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV16      0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV26      0x3
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV102     0x4
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV124     0x5
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV4       0x8
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV6       0x9
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV8       0xa
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV10      0xb
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV12      0xc
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV14      0xd
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV16AGAIN 0xe
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV18      0xf

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GMII_ADDR_CR register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GMII_ADDR_CR register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_GMII_ADDR_CR register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_WIDTH      4
/* The mask used to set the ALT_EMAC_GMAC_GMII_ADDR_CR register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_SET_MSK    0x0000003c
/* The mask used to clear the ALT_EMAC_GMAC_GMII_ADDR_CR register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_CLR_MSK    0xffffffc3
/* The reset value of the ALT_EMAC_GMAC_GMII_ADDR_CR register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GMII_ADDR_CR field value from a register. */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_GET(value) (((value) & 0x0000003c) >> 2)
/* Produces a ALT_EMAC_GMAC_GMII_ADDR_CR register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_SET(value) (((value) << 2) & 0x0000003c)

/*
 * Field : gr
 * 
 * GMII Register
 * 
 * These bits select the desired GMII register in the selected PHY device.
 * 
 * For RevMII, these bits select the desired CSR register in the RevMII Registers
 * set.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GMII_ADDR_GR register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GR_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GMII_ADDR_GR register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GR_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_GMII_ADDR_GR register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GR_WIDTH      5
/* The mask used to set the ALT_EMAC_GMAC_GMII_ADDR_GR register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_GR_SET_MSK    0x000007c0
/* The mask used to clear the ALT_EMAC_GMAC_GMII_ADDR_GR register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_GR_CLR_MSK    0xfffff83f
/* The reset value of the ALT_EMAC_GMAC_GMII_ADDR_GR register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GR_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GMII_ADDR_GR field value from a register. */
#define ALT_EMAC_GMAC_GMII_ADDR_GR_GET(value) (((value) & 0x000007c0) >> 6)
/* Produces a ALT_EMAC_GMAC_GMII_ADDR_GR register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GMII_ADDR_GR_SET(value) (((value) << 6) & 0x000007c0)

/*
 * Field : pa
 * 
 * Physical Layer Address
 * 
 * This field indicates which of the 32 possible PHY devices are being accessed.
 * 
 * For RevMII, this field gives the PHY Address of the RevMII module.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GMII_ADDR_PA register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_PA_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GMII_ADDR_PA register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_PA_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_GMII_ADDR_PA register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_PA_WIDTH      5
/* The mask used to set the ALT_EMAC_GMAC_GMII_ADDR_PA register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_PA_SET_MSK    0x0000f800
/* The mask used to clear the ALT_EMAC_GMAC_GMII_ADDR_PA register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_PA_CLR_MSK    0xffff07ff
/* The reset value of the ALT_EMAC_GMAC_GMII_ADDR_PA register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_PA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GMII_ADDR_PA field value from a register. */
#define ALT_EMAC_GMAC_GMII_ADDR_PA_GET(value) (((value) & 0x0000f800) >> 11)
/* Produces a ALT_EMAC_GMAC_GMII_ADDR_PA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GMII_ADDR_PA_SET(value) (((value) << 11) & 0x0000f800)

/*
 * Field : reserved_31_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16 register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16 register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16 register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16 register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16_SET_MSK    0xffff0000
/* The mask used to clear the ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16 register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16_CLR_MSK    0x0000ffff
/* The reset value of the ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16 register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16 field value from a register. */
#define ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16_GET(value) (((value) & 0xffff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16_SET(value) (((value) << 16) & 0xffff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_GMII_ADDR.
 */
struct ALT_EMAC_GMAC_GMII_ADDR_s
{
    uint32_t        gb             :  1;  /* ALT_EMAC_GMAC_GMII_ADDR_GB */
    uint32_t        gw             :  1;  /* ALT_EMAC_GMAC_GMII_ADDR_GW */
    uint32_t        cr             :  4;  /* ALT_EMAC_GMAC_GMII_ADDR_CR */
    uint32_t        gr             :  5;  /* ALT_EMAC_GMAC_GMII_ADDR_GR */
    uint32_t        pa             :  5;  /* ALT_EMAC_GMAC_GMII_ADDR_PA */
    const uint32_t  reserved_31_16 : 16;  /* ALT_EMAC_GMAC_GMII_ADDR_RSVD_31_16 */
};

/* The typedef declaration for register ALT_EMAC_GMAC_GMII_ADDR. */
typedef volatile struct ALT_EMAC_GMAC_GMII_ADDR_s  ALT_EMAC_GMAC_GMII_ADDR_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_GMII_ADDR register. */
#define ALT_EMAC_GMAC_GMII_ADDR_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_GMII_ADDR register from the beginning of the component. */
#define ALT_EMAC_GMAC_GMII_ADDR_OFST        0x10
/* The address of the ALT_EMAC_GMAC_GMII_ADDR register. */
#define ALT_EMAC_GMAC_GMII_ADDR_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_GMII_ADDR_OFST))

/*
 * Register : gmacgrp_gmii_data
 * 
 * <b> Register 5 (GMII Data Register) </b>
 * 
 * The GMII Data register stores Write data to be written to the PHY register
 * located at the address specified in Register 4 (GMII Address Register). This
 * register also stores the Read data from the PHY register located at the address
 * specified by Register 4.
 * 
 * Note: This register is present for all PHY interface when you select the Station
 * Management (MDIO) feature in coreConsultant.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                       
 * :--------|:-------|:------|:-----------------------------------
 *  [15:0]  | RW     | 0x0   | ALT_EMAC_GMAC_GMII_DATA_GD        
 *  [31:16] | R      | 0x0   | ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16
 * 
 */
/*
 * Field : gd
 * 
 * GMII Data
 * 
 * This field contains the 16-bit data value read from the PHY or RevMII after a
 * Management Read operation or the 16-bit data value to be written to the PHY or
 * RevMII before a Management Write operation.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GMII_DATA_GD register field. */
#define ALT_EMAC_GMAC_GMII_DATA_GD_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GMII_DATA_GD register field. */
#define ALT_EMAC_GMAC_GMII_DATA_GD_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_GMII_DATA_GD register field. */
#define ALT_EMAC_GMAC_GMII_DATA_GD_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_GMII_DATA_GD register field value. */
#define ALT_EMAC_GMAC_GMII_DATA_GD_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_GMII_DATA_GD register field value. */
#define ALT_EMAC_GMAC_GMII_DATA_GD_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_GMII_DATA_GD register field. */
#define ALT_EMAC_GMAC_GMII_DATA_GD_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GMII_DATA_GD field value from a register. */
#define ALT_EMAC_GMAC_GMII_DATA_GD_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_GMII_DATA_GD register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GMII_DATA_GD_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_31_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16 register field. */
#define ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16 register field. */
#define ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16 register field. */
#define ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16 register field value. */
#define ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16_SET_MSK    0xffff0000
/* The mask used to clear the ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16 register field value. */
#define ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16_CLR_MSK    0x0000ffff
/* The reset value of the ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16 register field. */
#define ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16 field value from a register. */
#define ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16_GET(value) (((value) & 0xffff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16_SET(value) (((value) << 16) & 0xffff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_GMII_DATA.
 */
struct ALT_EMAC_GMAC_GMII_DATA_s
{
    uint32_t        gd             : 16;  /* ALT_EMAC_GMAC_GMII_DATA_GD */
    const uint32_t  reserved_31_16 : 16;  /* ALT_EMAC_GMAC_GMII_DATA_RSVD_31_16 */
};

/* The typedef declaration for register ALT_EMAC_GMAC_GMII_DATA. */
typedef volatile struct ALT_EMAC_GMAC_GMII_DATA_s  ALT_EMAC_GMAC_GMII_DATA_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_GMII_DATA register. */
#define ALT_EMAC_GMAC_GMII_DATA_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_GMII_DATA register from the beginning of the component. */
#define ALT_EMAC_GMAC_GMII_DATA_OFST        0x14
/* The address of the ALT_EMAC_GMAC_GMII_DATA register. */
#define ALT_EMAC_GMAC_GMII_DATA_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_GMII_DATA_OFST))

/*
 * Register : gmacgrp_flow_control
 * 
 * <b> Register 6 (Flow Control Register) </b>
 * 
 * The Flow Control register controls the generation and reception of the Control
 * (Pause Command) frames by the MAC's Flow control module. A Write to a register
 * with the Busy bit set to '1' triggers the Flow Control block to generate a Pause
 * Control frame. The fields of the control frame are selected as specified in the
 * 802.3x specification, and the Pause Time value from this register is used in the
 * Pause Time field of the control frame. The Busy bit remains set until the
 * control frame is transferred onto the cable. The Host must make sure that the
 * Busy bit is cleared before writing to the register.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                     
 * :--------|:-------|:------|:---------------------------------
 *  [0]     | RW     | 0x0   | ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA  
 *  [1]     | RW     | 0x0   | ALT_EMAC_GMAC_FLOW_CTL_TFE      
 *  [2]     | RW     | 0x0   | ALT_EMAC_GMAC_FLOW_CTL_RFE      
 *  [3]     | RW     | 0x0   | ALT_EMAC_GMAC_FLOW_CTL_UP       
 *  [5:4]   | RW     | 0x0   | ALT_EMAC_GMAC_FLOW_CTL_PLT      
 *  [6]     | R      | 0x0   | ALT_EMAC_GMAC_FLOW_CTL_RSVD_6   
 *  [7]     | RW     | 0x0   | ALT_EMAC_GMAC_FLOW_CTL_DZPQ     
 *  [15:8]  | R      | 0x0   | ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8
 *  [31:16] | RW     | 0x0   | ALT_EMAC_GMAC_FLOW_CTL_PT       
 * 
 */
/*
 * Field : fca_bpa
 * 
 * Flow Control Busy or Backpressure Activate
 * 
 * This bit initiates a Pause Control frame in the full-duplex mode and activates
 * the backpressure function in the half-duplex mode if the TFE bit is set.
 * 
 * In the full-duplex mode, this bit should be read as 1'b0 before writing to the
 * Flow Control register. To initiate a Pause control frame, the Application must
 * set this bit to 1'b1. During a transfer of the Control Frame, this bit continues
 * to be set to signify that a frame transmission is in progress. After the
 * completion of Pause control frame transmission, the MAC resets this bit to 1'b0.
 * The Flow Control register should not be written to until this bit is cleared.
 * 
 * In the half-duplex mode, when this bit is set (and TFE is set), then
 * backpressure is asserted by the MAC. During backpressure, when the MAC receives
 * a new frame, the transmitter starts sending a JAM pattern resulting in a
 * collision. This control register bit is logically ORed with the mti_flowctrl_i
 * input signal for the backpressure function. When the MAC is configured for the
 * full-duplex mode, the BPA is automatically disabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description
 * :--------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA
 * 
 */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA
 * 
 */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA field value from a register. */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : tfe
 * 
 * Transmit Flow Control Enable
 * 
 * In the full-duplex mode, when this bit is set, the MAC enables the flow control
 * operation to transmit Pause frames. When this bit is reset, the flow control
 * operation in the MAC is disabled, and the MAC does not transmit any Pause
 * frames.
 * 
 * In half-duplex mode, when this bit is set, the MAC enables the back-pressure
 * operation. When this bit is reset, the back-pressure feature is disabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description
 * :----------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_FLOW_CTL_TFE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_FLOW_CTL_TFE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_TFE
 * 
 */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_TFE
 * 
 */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_FLOW_CTL_TFE register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_FLOW_CTL_TFE register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_FLOW_CTL_TFE register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_FLOW_CTL_TFE register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_FLOW_CTL_TFE register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL_TFE register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_FLOW_CTL_TFE field value from a register. */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_FLOW_CTL_TFE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : rfe
 * 
 * Receive Flow Control Enable
 * 
 * When this bit is set, the MAC decodes the received Pause frame and disables its
 * transmitter for a specified (Pause) time. When this bit is reset, the decode
 * function of the Pause frame is disabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description
 * :----------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_FLOW_CTL_RFE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_FLOW_CTL_RFE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_RFE
 * 
 */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_RFE
 * 
 */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_FLOW_CTL_RFE register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_FLOW_CTL_RFE register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_FLOW_CTL_RFE register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_FLOW_CTL_RFE register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_FLOW_CTL_RFE register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL_RFE register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_FLOW_CTL_RFE field value from a register. */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_FLOW_CTL_RFE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : up
 * 
 * Unicast Pause Frame Detect
 * 
 * A pause frame is processed when it has the unique multicast address specified in
 * the IEEE Std 802.3. When this bit is set, the MAC can also detect Pause frames
 * with unicast address of the station. This unicast address should be as specified
 * in the MAC Address0 High Register and MAC Address0 Low Register.
 * 
 * When this bit is reset, the MAC only detects Pause frames with unique multicast
 * address.
 * 
 * Note: The MAC does not process a Pause frame if the multicast address of
 * received frame is different from the unique multicast address.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description
 * :---------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_FLOW_CTL_UP_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_FLOW_CTL_UP_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_UP
 * 
 */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_UP
 * 
 */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_FLOW_CTL_UP register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_FLOW_CTL_UP register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_FLOW_CTL_UP register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_FLOW_CTL_UP register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_FLOW_CTL_UP register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL_UP register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_FLOW_CTL_UP field value from a register. */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_FLOW_CTL_UP register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : plt
 * 
 * Pause Low Threshold
 * 
 * This field configures the threshold of the PAUSE timer at which the input flow
 * control signal mti_flowctrl_i (or sbd_flowctrl_i) is checked for automatic
 * retransmission of PAUSE Frame.
 * 
 * The threshold values should be always less than the Pause Time configured in
 * Bits[31:16]. For example, if PT = 100H (256 slot-times), and PLT = 01, then a
 * second PAUSE frame is automatically transmitted if the mti_flowctrl_i signal is
 * asserted at 228 (256 - 28) slot times after the first PAUSE frame is
 * transmitted.
 * 
 * The following list provides the threshold values for different values:
 * 
 * * 00: The threshold is Pause time minus 4 slot times (PT - 4 slot times).
 * 
 * * 01: The threshold is Pause time minus 28 slot times (PT - 28 slot times).
 * 
 * * 10: The threshold is Pause time minus 144 slot times (PT - 144 slot times).
 * 
 * * 11: The threshold is Pause time minus 256 slot times (PT - 256 slot times).
 * 
 * The slot time is defined as the time taken to transmit 512 bits (64 bytes) on
 * the GMII or MII interface.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description
 * :-------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_FLOW_CTL_PLT_E_PAUSETIME_4   | 0x0   |            
 *  ALT_EMAC_GMAC_FLOW_CTL_PLT_E_PAUSETIME_28  | 0x1   |            
 *  ALT_EMAC_GMAC_FLOW_CTL_PLT_E_PAUSETIME_144 | 0x2   |            
 *  ALT_EMAC_GMAC_FLOW_CTL_PLT_E_PAUSETIME_256 | 0x3   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_PLT
 * 
 */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_E_PAUSETIME_4    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_PLT
 * 
 */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_E_PAUSETIME_28   0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_PLT
 * 
 */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_E_PAUSETIME_144  0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_PLT
 * 
 */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_E_PAUSETIME_256  0x3

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_FLOW_CTL_PLT register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_FLOW_CTL_PLT register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_FLOW_CTL_PLT register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_FLOW_CTL_PLT register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_SET_MSK    0x00000030
/* The mask used to clear the ALT_EMAC_GMAC_FLOW_CTL_PLT register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_CLR_MSK    0xffffffcf
/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL_PLT register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_FLOW_CTL_PLT field value from a register. */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_GET(value) (((value) & 0x00000030) >> 4)
/* Produces a ALT_EMAC_GMAC_FLOW_CTL_PLT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_SET(value) (((value) << 4) & 0x00000030)

/*
 * Field : reserved_6
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_FLOW_CTL_RSVD_6 register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_RSVD_6_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_FLOW_CTL_RSVD_6 register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_RSVD_6_MSB        6
/* The width in bits of the ALT_EMAC_GMAC_FLOW_CTL_RSVD_6 register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_RSVD_6_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_FLOW_CTL_RSVD_6 register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_RSVD_6_SET_MSK    0x00000040
/* The mask used to clear the ALT_EMAC_GMAC_FLOW_CTL_RSVD_6 register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_RSVD_6_CLR_MSK    0xffffffbf
/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL_RSVD_6 register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_RSVD_6_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_FLOW_CTL_RSVD_6 field value from a register. */
#define ALT_EMAC_GMAC_FLOW_CTL_RSVD_6_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_EMAC_GMAC_FLOW_CTL_RSVD_6 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_FLOW_CTL_RSVD_6_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : dzpq
 * 
 * Disable Zero-Quanta Pause
 * 
 * When this bit is set, it disables the automatic generation of the Zero-Quanta
 * Pause Control frames on the de-assertion of the flow-control signal from the
 * FIFO layer (MTL or external sideband flow control signal
 * sbd_flowctrl_i/mti_flowctrl_i).
 * 
 * When this bit is reset, normal operation with automatic Zero-Quanta Pause
 * Control frame generation is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description
 * :-----------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_FLOW_CTL_DZPQ_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_FLOW_CTL_DZPQ_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_DZPQ
 * 
 */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_DZPQ
 * 
 */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_FLOW_CTL_DZPQ register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_FLOW_CTL_DZPQ register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_FLOW_CTL_DZPQ register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_FLOW_CTL_DZPQ register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_SET_MSK    0x00000080
/* The mask used to clear the ALT_EMAC_GMAC_FLOW_CTL_DZPQ register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_CLR_MSK    0xffffff7f
/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL_DZPQ register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_FLOW_CTL_DZPQ field value from a register. */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_EMAC_GMAC_FLOW_CTL_DZPQ register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : reserved_15_8
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8 register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8 register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8 register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8 register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8_SET_MSK    0x0000ff00
/* The mask used to clear the ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8 register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8_CLR_MSK    0xffff00ff
/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8 register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8 field value from a register. */
#define ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8_GET(value) (((value) & 0x0000ff00) >> 8)
/* Produces a ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8_SET(value) (((value) << 8) & 0x0000ff00)

/*
 * Field : pt
 * 
 * Pause Time
 * 
 * This field holds the value to be used in the Pause Time field in the transmit
 * control frame. If the Pause Time bits is configured to be double-synchronized to
 * the (G)MII clock domain, then consecutive writes to this register should be
 * performed only after at least four clock cycles in the destination clock domain.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_FLOW_CTL_PT register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_PT_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_FLOW_CTL_PT register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_PT_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_FLOW_CTL_PT register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_PT_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_FLOW_CTL_PT register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_PT_SET_MSK    0xffff0000
/* The mask used to clear the ALT_EMAC_GMAC_FLOW_CTL_PT register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_PT_CLR_MSK    0x0000ffff
/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL_PT register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_PT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_FLOW_CTL_PT field value from a register. */
#define ALT_EMAC_GMAC_FLOW_CTL_PT_GET(value) (((value) & 0xffff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_FLOW_CTL_PT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_FLOW_CTL_PT_SET(value) (((value) << 16) & 0xffff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_FLOW_CTL.
 */
struct ALT_EMAC_GMAC_FLOW_CTL_s
{
    uint32_t        fca_bpa       :  1;  /* ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA */
    uint32_t        tfe           :  1;  /* ALT_EMAC_GMAC_FLOW_CTL_TFE */
    uint32_t        rfe           :  1;  /* ALT_EMAC_GMAC_FLOW_CTL_RFE */
    uint32_t        up            :  1;  /* ALT_EMAC_GMAC_FLOW_CTL_UP */
    uint32_t        plt           :  2;  /* ALT_EMAC_GMAC_FLOW_CTL_PLT */
    const uint32_t  reserved_6    :  1;  /* ALT_EMAC_GMAC_FLOW_CTL_RSVD_6 */
    uint32_t        dzpq          :  1;  /* ALT_EMAC_GMAC_FLOW_CTL_DZPQ */
    const uint32_t  reserved_15_8 :  8;  /* ALT_EMAC_GMAC_FLOW_CTL_RSVD_15_8 */
    uint32_t        pt            : 16;  /* ALT_EMAC_GMAC_FLOW_CTL_PT */
};

/* The typedef declaration for register ALT_EMAC_GMAC_FLOW_CTL. */
typedef volatile struct ALT_EMAC_GMAC_FLOW_CTL_s  ALT_EMAC_GMAC_FLOW_CTL_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL register. */
#define ALT_EMAC_GMAC_FLOW_CTL_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_FLOW_CTL register from the beginning of the component. */
#define ALT_EMAC_GMAC_FLOW_CTL_OFST        0x18
/* The address of the ALT_EMAC_GMAC_FLOW_CTL register. */
#define ALT_EMAC_GMAC_FLOW_CTL_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_FLOW_CTL_OFST))

/*
 * Register : gmacgrp_vlan_tag
 * 
 * <b> Register 7 (VLAN Tag Register) </b>
 * 
 * The VLAN Tag register contains the IEEE 802.1Q VLAN Tag to identify the VLAN
 * frames. The MAC compares the 13th and 14th bytes of the receiving frame
 * (Length/Type) with 16'h8100, and the following two bytes are compared with the
 * VLAN tag. If a match occurs, the MAC sets the received VLAN bit in the receive
 * frame status. The legal length of the frame is increased from 1,518 bytes to
 * 1,522 bytes.
 * 
 * If the VLAN Tag register is configured to be double-synchronized to the (G)MII
 * clock domain, then consecutive writes to these register should be performed only
 * after at least four clock cycles in the destination clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                      
 * :--------|:-------|:------|:----------------------------------
 *  [15:0]  | RW     | 0x0   | ALT_EMAC_GMAC_VLAN_TAG_VL        
 *  [16]    | RW     | 0x0   | ALT_EMAC_GMAC_VLAN_TAG_ETV       
 *  [17]    | RW     | 0x0   | ALT_EMAC_GMAC_VLAN_TAG_VTIM      
 *  [18]    | RW     | 0x0   | ALT_EMAC_GMAC_VLAN_TAG_ESVL      
 *  [19]    | R      | 0x0   | ALT_EMAC_GMAC_VLAN_TAG_VTHM      
 *  [31:20] | R      | 0x0   | ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20
 * 
 */
/*
 * Field : vl
 * 
 * VLAN Tag Identifier for Receive Frames
 * 
 * This field contains the 802.1Q VLAN tag to identify the VLAN frames and is
 * compared to the 15th and 16th bytes of the frames being received for VLAN
 * frames. The following list describes the bits of this field:
 * 
 * * Bits [15:13]: User Priority
 * 
 * * Bit 12: Canonical Format Indicator (CFI) or Drop Eligible Indicator (DEI)
 * 
 * * Bits[11:0]: VLAN tag's VLAN Identifier (VID) field
 * 
 * When the ETV bit is set, only the VID (Bits[11:0]) is used for comparison.
 * 
 * If VL (VL[11:0] if ETV is set) is all zeros, the MAC does not check the
 * fifteenth and 16th bytes for VLAN tag comparison, and declares all frames with a
 * Type field value of 0x8100 or 0x88a8 as VLAN frames.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_VLAN_TAG_VL register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_VLAN_TAG_VL register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VL_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_VLAN_TAG_VL register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VL_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_VLAN_TAG_VL register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_VL_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_VLAN_TAG_VL register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_VL_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_VLAN_TAG_VL register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VL_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_VLAN_TAG_VL field value from a register. */
#define ALT_EMAC_GMAC_VLAN_TAG_VL_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_VLAN_TAG_VL register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_VLAN_TAG_VL_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : etv
 * 
 * Enable 12-Bit VLAN Tag Comparison
 * 
 * When this bit is set, a 12-bit VLAN identifier is used for comparing and
 * filtering instead of the complete 16-bit VLAN tag. Bits [11:0] of VLAN tag are
 * compared with the corresponding field in the received VLAN-tagged frame.
 * Similarly, when enabled, only 12 bits of the VLAN tag in the received frame are
 * used for hash-based VLAN filtering.
 * 
 * When this bit is reset, all 16 bits of the 15th and 16th bytes of the received
 * VLAN frame are used for comparison and VLAN hash filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description
 * :----------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_VLAN_TAG_ETV_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_VLAN_TAG_ETV_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_VLAN_TAG_ETV
 * 
 */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_VLAN_TAG_ETV
 * 
 */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_VLAN_TAG_ETV register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_VLAN_TAG_ETV register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_VLAN_TAG_ETV register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_VLAN_TAG_ETV register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_VLAN_TAG_ETV register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_VLAN_TAG_ETV register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_VLAN_TAG_ETV field value from a register. */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_VLAN_TAG_ETV register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : vtim
 * 
 * VLAN Tag Inverse Match Enable
 * 
 * When set, this bit enables the VLAN Tag inverse matching. The frames that do not
 * have matching VLAN Tag are marked as matched.
 * 
 * When reset, this bit enables the VLAN Tag perfect matching. The frames with
 * matched VLAN Tag are marked as matched.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_VLAN_TAG_VTIM register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTIM_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_VLAN_TAG_VTIM register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTIM_MSB        17
/* The width in bits of the ALT_EMAC_GMAC_VLAN_TAG_VTIM register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_VLAN_TAG_VTIM register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTIM_SET_MSK    0x00020000
/* The mask used to clear the ALT_EMAC_GMAC_VLAN_TAG_VTIM register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTIM_CLR_MSK    0xfffdffff
/* The reset value of the ALT_EMAC_GMAC_VLAN_TAG_VTIM register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_VLAN_TAG_VTIM field value from a register. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTIM_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_EMAC_GMAC_VLAN_TAG_VTIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTIM_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : esvl
 * 
 * Enable S-VLAN
 * 
 * When this bit is set, the MAC transmitter and receiver also consider the S-VLAN
 * (Type = 0x88A8) frames as valid VLAN tagged frames.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_VLAN_TAG_ESVL register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_ESVL_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_VLAN_TAG_ESVL register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_ESVL_MSB        18
/* The width in bits of the ALT_EMAC_GMAC_VLAN_TAG_ESVL register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_ESVL_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_VLAN_TAG_ESVL register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_ESVL_SET_MSK    0x00040000
/* The mask used to clear the ALT_EMAC_GMAC_VLAN_TAG_ESVL register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_ESVL_CLR_MSK    0xfffbffff
/* The reset value of the ALT_EMAC_GMAC_VLAN_TAG_ESVL register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_ESVL_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_VLAN_TAG_ESVL field value from a register. */
#define ALT_EMAC_GMAC_VLAN_TAG_ESVL_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_EMAC_GMAC_VLAN_TAG_ESVL register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_VLAN_TAG_ESVL_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : vthm
 * 
 * VLAN Tag Hash Table Match Enable
 * 
 * When set, the most significant four bits of the VLAN tag's CRC are used to index
 * the content of Register 354 (VLAN Hash Table Register). A value of 1 in the VLAN
 * Hash Table register, corresponding to the index, indicates that the frame
 * matched the VLAN hash table.
 * 
 * When Bit 16 (ETV) is set, the CRC of the 12-bit VLAN Identifier (VID) is used
 * for comparison whereas when ETV is reset, the CRC of the 16-bit VLAN tag is used
 * for comparison.
 * 
 * When reset, the VLAN Hash Match operation is not performed. If the VLAN Hash
 * feature is not enabled during core configuration, this bit is reserved (RO with
 * default value).
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_VLAN_TAG_VTHM register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTHM_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_VLAN_TAG_VTHM register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTHM_MSB        19
/* The width in bits of the ALT_EMAC_GMAC_VLAN_TAG_VTHM register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTHM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_VLAN_TAG_VTHM register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTHM_SET_MSK    0x00080000
/* The mask used to clear the ALT_EMAC_GMAC_VLAN_TAG_VTHM register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTHM_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_EMAC_GMAC_VLAN_TAG_VTHM register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTHM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_VLAN_TAG_VTHM field value from a register. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTHM_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_EMAC_GMAC_VLAN_TAG_VTHM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTHM_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : reserved_31_20
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20 register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20 register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20 register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20_WIDTH      12
/* The mask used to set the ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20 register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20_SET_MSK    0xfff00000
/* The mask used to clear the ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20 register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20_CLR_MSK    0x000fffff
/* The reset value of the ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20 register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20 field value from a register. */
#define ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20_GET(value) (((value) & 0xfff00000) >> 20)
/* Produces a ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20_SET(value) (((value) << 20) & 0xfff00000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_VLAN_TAG.
 */
struct ALT_EMAC_GMAC_VLAN_TAG_s
{
    uint32_t        vl             : 16;  /* ALT_EMAC_GMAC_VLAN_TAG_VL */
    uint32_t        etv            :  1;  /* ALT_EMAC_GMAC_VLAN_TAG_ETV */
    uint32_t        vtim           :  1;  /* ALT_EMAC_GMAC_VLAN_TAG_VTIM */
    uint32_t        esvl           :  1;  /* ALT_EMAC_GMAC_VLAN_TAG_ESVL */
    const uint32_t  vthm           :  1;  /* ALT_EMAC_GMAC_VLAN_TAG_VTHM */
    const uint32_t  reserved_31_20 : 12;  /* ALT_EMAC_GMAC_VLAN_TAG_RSVD_31_20 */
};

/* The typedef declaration for register ALT_EMAC_GMAC_VLAN_TAG. */
typedef volatile struct ALT_EMAC_GMAC_VLAN_TAG_s  ALT_EMAC_GMAC_VLAN_TAG_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_VLAN_TAG register. */
#define ALT_EMAC_GMAC_VLAN_TAG_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_VLAN_TAG register from the beginning of the component. */
#define ALT_EMAC_GMAC_VLAN_TAG_OFST        0x1c
/* The address of the ALT_EMAC_GMAC_VLAN_TAG register. */
#define ALT_EMAC_GMAC_VLAN_TAG_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_VLAN_TAG_OFST))

/*
 * Register : gmacgrp_version
 * 
 * <b> Register 8 (Version Register) </b>
 * 
 * The Version registers identifies the version of the DWC_gmac. This register
 * contains two bytes: one that Synopsys uses to identify the core release number,
 * and the other that you set during core configuration.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                 
 * :--------|:-------|:------|:-----------------------------
 *  [7:0]   | R      | 0x37  | ALT_EMAC_GMAC_VER_SNPSVER   
 *  [15:8]  | R      | 0x10  | ALT_EMAC_GMAC_VER_USERVER   
 *  [31:16] | R      | 0x0   | ALT_EMAC_GMAC_VER_RSVD_31_16
 * 
 */
/*
 * Field : snpsver
 * 
 * Synopsys-defined Version (3.7)
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_VER_SNPSVER register field. */
#define ALT_EMAC_GMAC_VER_SNPSVER_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_VER_SNPSVER register field. */
#define ALT_EMAC_GMAC_VER_SNPSVER_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_VER_SNPSVER register field. */
#define ALT_EMAC_GMAC_VER_SNPSVER_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_VER_SNPSVER register field value. */
#define ALT_EMAC_GMAC_VER_SNPSVER_SET_MSK    0x000000ff
/* The mask used to clear the ALT_EMAC_GMAC_VER_SNPSVER register field value. */
#define ALT_EMAC_GMAC_VER_SNPSVER_CLR_MSK    0xffffff00
/* The reset value of the ALT_EMAC_GMAC_VER_SNPSVER register field. */
#define ALT_EMAC_GMAC_VER_SNPSVER_RESET      0x37
/* Extracts the ALT_EMAC_GMAC_VER_SNPSVER field value from a register. */
#define ALT_EMAC_GMAC_VER_SNPSVER_GET(value) (((value) & 0x000000ff) >> 0)
/* Produces a ALT_EMAC_GMAC_VER_SNPSVER register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_VER_SNPSVER_SET(value) (((value) << 0) & 0x000000ff)

/*
 * Field : userver
 * 
 * User-defined Version (Configured with the coreConsultant)
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_VER_USERVER register field. */
#define ALT_EMAC_GMAC_VER_USERVER_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_VER_USERVER register field. */
#define ALT_EMAC_GMAC_VER_USERVER_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_VER_USERVER register field. */
#define ALT_EMAC_GMAC_VER_USERVER_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_VER_USERVER register field value. */
#define ALT_EMAC_GMAC_VER_USERVER_SET_MSK    0x0000ff00
/* The mask used to clear the ALT_EMAC_GMAC_VER_USERVER register field value. */
#define ALT_EMAC_GMAC_VER_USERVER_CLR_MSK    0xffff00ff
/* The reset value of the ALT_EMAC_GMAC_VER_USERVER register field. */
#define ALT_EMAC_GMAC_VER_USERVER_RESET      0x10
/* Extracts the ALT_EMAC_GMAC_VER_USERVER field value from a register. */
#define ALT_EMAC_GMAC_VER_USERVER_GET(value) (((value) & 0x0000ff00) >> 8)
/* Produces a ALT_EMAC_GMAC_VER_USERVER register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_VER_USERVER_SET(value) (((value) << 8) & 0x0000ff00)

/*
 * Field : reserved_31_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_VER_RSVD_31_16 register field. */
#define ALT_EMAC_GMAC_VER_RSVD_31_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_VER_RSVD_31_16 register field. */
#define ALT_EMAC_GMAC_VER_RSVD_31_16_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_VER_RSVD_31_16 register field. */
#define ALT_EMAC_GMAC_VER_RSVD_31_16_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_VER_RSVD_31_16 register field value. */
#define ALT_EMAC_GMAC_VER_RSVD_31_16_SET_MSK    0xffff0000
/* The mask used to clear the ALT_EMAC_GMAC_VER_RSVD_31_16 register field value. */
#define ALT_EMAC_GMAC_VER_RSVD_31_16_CLR_MSK    0x0000ffff
/* The reset value of the ALT_EMAC_GMAC_VER_RSVD_31_16 register field. */
#define ALT_EMAC_GMAC_VER_RSVD_31_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_VER_RSVD_31_16 field value from a register. */
#define ALT_EMAC_GMAC_VER_RSVD_31_16_GET(value) (((value) & 0xffff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_VER_RSVD_31_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_VER_RSVD_31_16_SET(value) (((value) << 16) & 0xffff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_VER.
 */
struct ALT_EMAC_GMAC_VER_s
{
    const uint32_t  snpsver        :  8;  /* ALT_EMAC_GMAC_VER_SNPSVER */
    const uint32_t  userver        :  8;  /* ALT_EMAC_GMAC_VER_USERVER */
    const uint32_t  reserved_31_16 : 16;  /* ALT_EMAC_GMAC_VER_RSVD_31_16 */
};

/* The typedef declaration for register ALT_EMAC_GMAC_VER. */
typedef volatile struct ALT_EMAC_GMAC_VER_s  ALT_EMAC_GMAC_VER_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_VER register. */
#define ALT_EMAC_GMAC_VER_RESET       0x00001037
/* The byte offset of the ALT_EMAC_GMAC_VER register from the beginning of the component. */
#define ALT_EMAC_GMAC_VER_OFST        0x20
/* The address of the ALT_EMAC_GMAC_VER register. */
#define ALT_EMAC_GMAC_VER_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_VER_OFST))

/*
 * Register : gmacgrp_debug
 * 
 * <b> Register 9 (Debug Register) </b>
 * 
 * The Debug register gives the status of all main modules of the transmit and
 * receive data-paths and the FIFOs. An all-zero status indicates that the MAC is
 * in idle state (and FIFOs are empty) and no activity is going on in the data-
 * paths.
 * 
 * Note:
 * 
 * The reset values, given for the Debug register, are valid only if the  following
 * clocks are present during the reset operation:
 * 
 * * clk_csr_i, clk_app_i, hclk_i, or aclk_i
 * 
 * * clk_tx_i
 * 
 * * clk_rx_i
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                 
 * :--------|:-------|:------|:-----------------------------
 *  [0]     | R      | 0x0   | ALT_EMAC_GMAC_DBG_RPESTS    
 *  [2:1]   | R      | 0x0   | ALT_EMAC_GMAC_DBG_RFCFCSTS  
 *  [3]     | R      | 0x0   | ALT_EMAC_GMAC_DBG_RSVD_3    
 *  [4]     | R      | 0x0   | ALT_EMAC_GMAC_DBG_RWCSTS    
 *  [6:5]   | R      | 0x0   | ALT_EMAC_GMAC_DBG_RRCSTS    
 *  [7]     | R      | 0x0   | ALT_EMAC_GMAC_DBG_RSVD_7    
 *  [9:8]   | R      | 0x0   | ALT_EMAC_GMAC_DBG_RXFSTS    
 *  [15:10] | R      | 0x0   | ALT_EMAC_GMAC_DBG_RSVD_15_10
 *  [16]    | R      | 0x0   | ALT_EMAC_GMAC_DBG_TPESTS    
 *  [18:17] | R      | 0x0   | ALT_EMAC_GMAC_DBG_TFCSTS    
 *  [19]    | R      | 0x0   | ALT_EMAC_GMAC_DBG_TXPAUSED  
 *  [21:20] | R      | 0x0   | ALT_EMAC_GMAC_DBG_TRCSTS    
 *  [22]    | R      | 0x0   | ALT_EMAC_GMAC_DBG_TWCSTS    
 *  [23]    | R      | 0x0   | ALT_EMAC_GMAC_DBG_RSVD_23   
 *  [24]    | R      | 0x0   | ALT_EMAC_GMAC_DBG_TXFSTS    
 *  [25]    | R      | 0x0   | ALT_EMAC_GMAC_DBG_TXSTSFSTS 
 *  [31:26] | R      | 0x0   | ALT_EMAC_GMAC_DBG_RSVD_31_26
 * 
 */
/*
 * Field : rpests
 * 
 * MAC GMII or MII Receive Protocol Engine Status
 * 
 * When high, this bit indicates that the MAC GMII or MII receive protocol engine
 * is actively receiving data and not in IDLE state.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description
 * :---------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_DBG_RPESTS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_DBG_RPESTS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RPESTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_RPESTS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RPESTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_RPESTS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_RPESTS register field. */
#define ALT_EMAC_GMAC_DBG_RPESTS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_RPESTS register field. */
#define ALT_EMAC_GMAC_DBG_RPESTS_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_DBG_RPESTS register field. */
#define ALT_EMAC_GMAC_DBG_RPESTS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_RPESTS register field value. */
#define ALT_EMAC_GMAC_DBG_RPESTS_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_DBG_RPESTS register field value. */
#define ALT_EMAC_GMAC_DBG_RPESTS_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_DBG_RPESTS register field. */
#define ALT_EMAC_GMAC_DBG_RPESTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_RPESTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_RPESTS_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_DBG_RPESTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_RPESTS_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : rfcfcsts
 * 
 * MAC Receive Frame Controller FIFO Status
 * 
 * When high, this field indicates the active state of the small FIFO Read and
 * Write controllers of the MAC Receive Frame Controller Module.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description
 * :-----------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_DBG_RFCFCSTS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_DBG_RFCFCSTS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RFCFCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RFCFCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_RFCFCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_RFCFCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_DBG_RFCFCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_DBG_RFCFCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_SET_MSK    0x00000006
/* The mask used to clear the ALT_EMAC_GMAC_DBG_RFCFCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_CLR_MSK    0xfffffff9
/* The reset value of the ALT_EMAC_GMAC_DBG_RFCFCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_RFCFCSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_GET(value) (((value) & 0x00000006) >> 1)
/* Produces a ALT_EMAC_GMAC_DBG_RFCFCSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_SET(value) (((value) << 1) & 0x00000006)

/*
 * Field : reserved_3
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_RSVD_3 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_3_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_RSVD_3 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_3_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_DBG_RSVD_3 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_RSVD_3 register field value. */
#define ALT_EMAC_GMAC_DBG_RSVD_3_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_DBG_RSVD_3 register field value. */
#define ALT_EMAC_GMAC_DBG_RSVD_3_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_DBG_RSVD_3 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_RSVD_3 field value from a register. */
#define ALT_EMAC_GMAC_DBG_RSVD_3_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_DBG_RSVD_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_RSVD_3_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : rwcsts
 * 
 * MTL Rx FIFO Write Controller Active Status
 * 
 * When high, this bit indicates that the MTL Rx FIFO Write Controller is active
 * and is transferring a received frame to the FIFO.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description
 * :---------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_DBG_RWCSTS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_DBG_RWCSTS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RWCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_RWCSTS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RWCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_RWCSTS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_RWCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RWCSTS_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_RWCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RWCSTS_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_DBG_RWCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RWCSTS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_RWCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_RWCSTS_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_DBG_RWCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_RWCSTS_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_DBG_RWCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RWCSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_RWCSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_RWCSTS_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_DBG_RWCSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_RWCSTS_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : rrcsts
 * 
 * MTL Rx FIFO Read Controller State
 * 
 * This field gives the state of the Rx FIFO read Controller:
 * 
 * * 00: IDLE state
 * 
 * * 01: Reading frame data
 * 
 * * 10: Reading frame status (or timestamp)
 * 
 * * 11: Flushing the frame data and status
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_DBG_RRCSTS_E_IDLE      | 0x0   |            
 *  ALT_EMAC_GMAC_DBG_RRCSTS_E_RDFRMDATA | 0x1   |            
 *  ALT_EMAC_GMAC_DBG_RRCSTS_E_RDFRMSTAT | 0x2   |            
 *  ALT_EMAC_GMAC_DBG_RRCSTS_E_FLUSHFRDS | 0x3   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RRCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_RRCSTS_E_IDLE         0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RRCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_RRCSTS_E_RDFRMDATA    0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RRCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_RRCSTS_E_RDFRMSTAT    0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RRCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_RRCSTS_E_FLUSHFRDS    0x3

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_RRCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RRCSTS_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_RRCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RRCSTS_MSB        6
/* The width in bits of the ALT_EMAC_GMAC_DBG_RRCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RRCSTS_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_DBG_RRCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_RRCSTS_SET_MSK    0x00000060
/* The mask used to clear the ALT_EMAC_GMAC_DBG_RRCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_RRCSTS_CLR_MSK    0xffffff9f
/* The reset value of the ALT_EMAC_GMAC_DBG_RRCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RRCSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_RRCSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_RRCSTS_GET(value) (((value) & 0x00000060) >> 5)
/* Produces a ALT_EMAC_GMAC_DBG_RRCSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_RRCSTS_SET(value) (((value) << 5) & 0x00000060)

/*
 * Field : reserved_7
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_RSVD_7 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_7_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_RSVD_7 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_7_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_DBG_RSVD_7 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_7_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_RSVD_7 register field value. */
#define ALT_EMAC_GMAC_DBG_RSVD_7_SET_MSK    0x00000080
/* The mask used to clear the ALT_EMAC_GMAC_DBG_RSVD_7 register field value. */
#define ALT_EMAC_GMAC_DBG_RSVD_7_CLR_MSK    0xffffff7f
/* The reset value of the ALT_EMAC_GMAC_DBG_RSVD_7 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_7_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_RSVD_7 field value from a register. */
#define ALT_EMAC_GMAC_DBG_RSVD_7_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_EMAC_GMAC_DBG_RSVD_7 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_RSVD_7_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : rxfsts
 * 
 * MTL Rx FIFO Fill-level Status
 * 
 * This field gives the status of the fill-level of the Rx FIFO:
 * 
 * * 00: Rx FIFO Empty
 * 
 * * 01: Rx FIFO fill level is below the flow-control deactivate threshold
 * 
 * * 10: Rx FIFO fill level is above the flow-control activate threshold
 * 
 * * 11: Rx FIFO Full
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_DBG_RXFSTS_E_RXFIFOEMPTY  | 0x0   |            
 *  ALT_EMAC_GMAC_DBG_RXFSTS_E_RXFIFOBELLVL | 0x1   |            
 *  ALT_EMAC_GMAC_DBG_RXFSTS_E_RXFIFOABLVL  | 0x2   |            
 *  ALT_EMAC_GMAC_DBG_RXFSTS_E_RXFIFOFULL   | 0x3   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RXFSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_RXFSTS_E_RXFIFOEMPTY  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RXFSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_RXFSTS_E_RXFIFOBELLVL 0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RXFSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_RXFSTS_E_RXFIFOABLVL  0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RXFSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_RXFSTS_E_RXFIFOFULL   0x3

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_RXFSTS register field. */
#define ALT_EMAC_GMAC_DBG_RXFSTS_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_RXFSTS register field. */
#define ALT_EMAC_GMAC_DBG_RXFSTS_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_DBG_RXFSTS register field. */
#define ALT_EMAC_GMAC_DBG_RXFSTS_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_DBG_RXFSTS register field value. */
#define ALT_EMAC_GMAC_DBG_RXFSTS_SET_MSK    0x00000300
/* The mask used to clear the ALT_EMAC_GMAC_DBG_RXFSTS register field value. */
#define ALT_EMAC_GMAC_DBG_RXFSTS_CLR_MSK    0xfffffcff
/* The reset value of the ALT_EMAC_GMAC_DBG_RXFSTS register field. */
#define ALT_EMAC_GMAC_DBG_RXFSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_RXFSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_RXFSTS_GET(value) (((value) & 0x00000300) >> 8)
/* Produces a ALT_EMAC_GMAC_DBG_RXFSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_RXFSTS_SET(value) (((value) << 8) & 0x00000300)

/*
 * Field : reserved_15_10
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_RSVD_15_10 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_15_10_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_RSVD_15_10 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_15_10_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_DBG_RSVD_15_10 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_15_10_WIDTH      6
/* The mask used to set the ALT_EMAC_GMAC_DBG_RSVD_15_10 register field value. */
#define ALT_EMAC_GMAC_DBG_RSVD_15_10_SET_MSK    0x0000fc00
/* The mask used to clear the ALT_EMAC_GMAC_DBG_RSVD_15_10 register field value. */
#define ALT_EMAC_GMAC_DBG_RSVD_15_10_CLR_MSK    0xffff03ff
/* The reset value of the ALT_EMAC_GMAC_DBG_RSVD_15_10 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_15_10_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_RSVD_15_10 field value from a register. */
#define ALT_EMAC_GMAC_DBG_RSVD_15_10_GET(value) (((value) & 0x0000fc00) >> 10)
/* Produces a ALT_EMAC_GMAC_DBG_RSVD_15_10 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_RSVD_15_10_SET(value) (((value) << 10) & 0x0000fc00)

/*
 * Field : tpests
 * 
 * MAC GMII or MII Transmit Protocol Engine Status
 * 
 * When high, this bit indicates that the MAC GMII or MII transmit protocol engine
 * is actively transmitting data and is not in the IDLE state.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description
 * :--------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_DBG_TPESTS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_DBG_TPESTS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TPESTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_TPESTS_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TPESTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_TPESTS_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_TPESTS register field. */
#define ALT_EMAC_GMAC_DBG_TPESTS_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_TPESTS register field. */
#define ALT_EMAC_GMAC_DBG_TPESTS_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_DBG_TPESTS register field. */
#define ALT_EMAC_GMAC_DBG_TPESTS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_TPESTS register field value. */
#define ALT_EMAC_GMAC_DBG_TPESTS_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_DBG_TPESTS register field value. */
#define ALT_EMAC_GMAC_DBG_TPESTS_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_DBG_TPESTS register field. */
#define ALT_EMAC_GMAC_DBG_TPESTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_TPESTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_TPESTS_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_DBG_TPESTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_TPESTS_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : tfcsts
 * 
 * MAC Transmit Frame Controller Status
 * 
 * This field indicates the state of the MAC Transmit Frame Controller module:
 * 
 * * 00: IDLE state
 * 
 * * 01: Waiting for Status of previous frame or IFG or backoff period to be over
 * 
 * * 10: Generating and transmitting a PAUSE control frame (in the full-duplex
 *   mode)
 * 
 * * 11: Transferring input frame for transmission
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description
 * :-----------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_DBG_TFCSTS_E_IDLE    | 0x0   |            
 *  ALT_EMAC_GMAC_DBG_TFCSTS_E_WAITIFG | 0x1   |            
 *  ALT_EMAC_GMAC_DBG_TFCSTS_E_XTPAUSE | 0x2   |            
 *  ALT_EMAC_GMAC_DBG_TFCSTS_E_XTINFRM | 0x3   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TFCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_TFCSTS_E_IDLE     0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TFCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_TFCSTS_E_WAITIFG  0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TFCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_TFCSTS_E_XTPAUSE  0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TFCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_TFCSTS_E_XTINFRM  0x3

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_TFCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TFCSTS_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_TFCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TFCSTS_MSB        18
/* The width in bits of the ALT_EMAC_GMAC_DBG_TFCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TFCSTS_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_DBG_TFCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TFCSTS_SET_MSK    0x00060000
/* The mask used to clear the ALT_EMAC_GMAC_DBG_TFCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TFCSTS_CLR_MSK    0xfff9ffff
/* The reset value of the ALT_EMAC_GMAC_DBG_TFCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TFCSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_TFCSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_TFCSTS_GET(value) (((value) & 0x00060000) >> 17)
/* Produces a ALT_EMAC_GMAC_DBG_TFCSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_TFCSTS_SET(value) (((value) << 17) & 0x00060000)

/*
 * Field : txpaused
 * 
 * MAC transmitter in PAUSE
 * 
 * When high, this bit indicates that the MAC transmitter is in the PAUSE condition
 * (in the full-duplex only mode) and hence does not schedule any frame for
 * transmission.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description
 * :---------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_DBG_TXPAUSED_E_DIS | 0x0   |            
 *  ALT_EMAC_GMAC_DBG_TXPAUSED_E_END | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TXPAUSED
 * 
 */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_E_DIS    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TXPAUSED
 * 
 */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_TXPAUSED register field. */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_TXPAUSED register field. */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_MSB        19
/* The width in bits of the ALT_EMAC_GMAC_DBG_TXPAUSED register field. */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_TXPAUSED register field value. */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_SET_MSK    0x00080000
/* The mask used to clear the ALT_EMAC_GMAC_DBG_TXPAUSED register field value. */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_EMAC_GMAC_DBG_TXPAUSED register field. */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_TXPAUSED field value from a register. */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_EMAC_GMAC_DBG_TXPAUSED register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : trcsts
 * 
 * MTL Tx FIFO Read Controller Status
 * 
 * This field indicates the state of the Tx FIFO Read Controller:
 * 
 * * 00: IDLE state
 * 
 * * 01: READ state (transferring data to MAC transmitter)
 * 
 * * 10: Waiting for TxStatus from MAC transmitter
 * 
 * * 11: Writing the received TxStatus or flushing the Tx FIFO
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description
 * :--------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_DBG_TRCSTS_E_IDLE       | 0x0   |            
 *  ALT_EMAC_GMAC_DBG_TRCSTS_E_RDSTATE    | 0x1   |            
 *  ALT_EMAC_GMAC_DBG_TRCSTS_E_WAITTXSTAT | 0x2   |            
 *  ALT_EMAC_GMAC_DBG_TRCSTS_E_WRTXSTAT   | 0x3   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TRCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_TRCSTS_E_IDLE         0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TRCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_TRCSTS_E_RDSTATE      0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TRCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_TRCSTS_E_WAITTXSTAT   0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TRCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_TRCSTS_E_WRTXSTAT     0x3

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_TRCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TRCSTS_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_TRCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TRCSTS_MSB        21
/* The width in bits of the ALT_EMAC_GMAC_DBG_TRCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TRCSTS_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_DBG_TRCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TRCSTS_SET_MSK    0x00300000
/* The mask used to clear the ALT_EMAC_GMAC_DBG_TRCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TRCSTS_CLR_MSK    0xffcfffff
/* The reset value of the ALT_EMAC_GMAC_DBG_TRCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TRCSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_TRCSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_TRCSTS_GET(value) (((value) & 0x00300000) >> 20)
/* Produces a ALT_EMAC_GMAC_DBG_TRCSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_TRCSTS_SET(value) (((value) << 20) & 0x00300000)

/*
 * Field : twcsts
 * 
 * MTL Tx FIFO Write Controller Active Status
 * 
 * When high, this bit indicates that the MTL Tx FIFO Write Controller is active
 * and transferring data to the Tx FIFO.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description
 * :---------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_DBG_TWCSTS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_DBG_TWCSTS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TWCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_TWCSTS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TWCSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_TWCSTS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_TWCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TWCSTS_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_TWCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TWCSTS_MSB        22
/* The width in bits of the ALT_EMAC_GMAC_DBG_TWCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TWCSTS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_TWCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TWCSTS_SET_MSK    0x00400000
/* The mask used to clear the ALT_EMAC_GMAC_DBG_TWCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TWCSTS_CLR_MSK    0xffbfffff
/* The reset value of the ALT_EMAC_GMAC_DBG_TWCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TWCSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_TWCSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_TWCSTS_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_EMAC_GMAC_DBG_TWCSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_TWCSTS_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : reserved_23
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_RSVD_23 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_23_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_RSVD_23 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_23_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_DBG_RSVD_23 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_23_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_RSVD_23 register field value. */
#define ALT_EMAC_GMAC_DBG_RSVD_23_SET_MSK    0x00800000
/* The mask used to clear the ALT_EMAC_GMAC_DBG_RSVD_23 register field value. */
#define ALT_EMAC_GMAC_DBG_RSVD_23_CLR_MSK    0xff7fffff
/* The reset value of the ALT_EMAC_GMAC_DBG_RSVD_23 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_23_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_RSVD_23 field value from a register. */
#define ALT_EMAC_GMAC_DBG_RSVD_23_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_EMAC_GMAC_DBG_RSVD_23 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_RSVD_23_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : txfsts
 * 
 * MTL Tx FIFO Not Empty Status
 * 
 * When high, this bit indicates that the MTL Tx FIFO is not empty and some data is
 * left for transmission.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description
 * :---------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_DBG_TXFSTS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_DBG_TXFSTS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TXFSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_TXFSTS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TXFSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_TXFSTS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_TXFSTS register field. */
#define ALT_EMAC_GMAC_DBG_TXFSTS_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_TXFSTS register field. */
#define ALT_EMAC_GMAC_DBG_TXFSTS_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_DBG_TXFSTS register field. */
#define ALT_EMAC_GMAC_DBG_TXFSTS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_TXFSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TXFSTS_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_DBG_TXFSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TXFSTS_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_DBG_TXFSTS register field. */
#define ALT_EMAC_GMAC_DBG_TXFSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_TXFSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_TXFSTS_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_DBG_TXFSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_TXFSTS_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : txstsfsts
 * 
 * MTL TxStatus FIFO Full Status
 * 
 * When high, this bit indicates that the MTL TxStatus FIFO is full. Therefore, the
 * MTL cannot accept any more frames for transmission. This bit is reserved in the
 * GMAC-AHB and GMAC-DMA configurations.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description
 * :------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_DBG_TXSTSFSTS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_DBG_TXSTSFSTS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TXSTSFSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TXSTSFSTS
 * 
 */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_TXSTSFSTS register field. */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_TXSTSFSTS register field. */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_DBG_TXSTSFSTS register field. */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_TXSTSFSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_DBG_TXSTSFSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_DBG_TXSTSFSTS register field. */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_TXSTSFSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_DBG_TXSTSFSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : reserved_31_26
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_31_26_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_31_26_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_DBG_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_31_26_WIDTH      6
/* The mask used to set the ALT_EMAC_GMAC_DBG_RSVD_31_26 register field value. */
#define ALT_EMAC_GMAC_DBG_RSVD_31_26_SET_MSK    0xfc000000
/* The mask used to clear the ALT_EMAC_GMAC_DBG_RSVD_31_26 register field value. */
#define ALT_EMAC_GMAC_DBG_RSVD_31_26_CLR_MSK    0x03ffffff
/* The reset value of the ALT_EMAC_GMAC_DBG_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_DBG_RSVD_31_26_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_RSVD_31_26 field value from a register. */
#define ALT_EMAC_GMAC_DBG_RSVD_31_26_GET(value) (((value) & 0xfc000000) >> 26)
/* Produces a ALT_EMAC_GMAC_DBG_RSVD_31_26 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_RSVD_31_26_SET(value) (((value) << 26) & 0xfc000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_DBG.
 */
struct ALT_EMAC_GMAC_DBG_s
{
    const uint32_t  rpests         :  1;  /* ALT_EMAC_GMAC_DBG_RPESTS */
    const uint32_t  rfcfcsts       :  2;  /* ALT_EMAC_GMAC_DBG_RFCFCSTS */
    const uint32_t  reserved_3     :  1;  /* ALT_EMAC_GMAC_DBG_RSVD_3 */
    const uint32_t  rwcsts         :  1;  /* ALT_EMAC_GMAC_DBG_RWCSTS */
    const uint32_t  rrcsts         :  2;  /* ALT_EMAC_GMAC_DBG_RRCSTS */
    const uint32_t  reserved_7     :  1;  /* ALT_EMAC_GMAC_DBG_RSVD_7 */
    const uint32_t  rxfsts         :  2;  /* ALT_EMAC_GMAC_DBG_RXFSTS */
    const uint32_t  reserved_15_10 :  6;  /* ALT_EMAC_GMAC_DBG_RSVD_15_10 */
    const uint32_t  tpests         :  1;  /* ALT_EMAC_GMAC_DBG_TPESTS */
    const uint32_t  tfcsts         :  2;  /* ALT_EMAC_GMAC_DBG_TFCSTS */
    const uint32_t  txpaused       :  1;  /* ALT_EMAC_GMAC_DBG_TXPAUSED */
    const uint32_t  trcsts         :  2;  /* ALT_EMAC_GMAC_DBG_TRCSTS */
    const uint32_t  twcsts         :  1;  /* ALT_EMAC_GMAC_DBG_TWCSTS */
    const uint32_t  reserved_23    :  1;  /* ALT_EMAC_GMAC_DBG_RSVD_23 */
    const uint32_t  txfsts         :  1;  /* ALT_EMAC_GMAC_DBG_TXFSTS */
    const uint32_t  txstsfsts      :  1;  /* ALT_EMAC_GMAC_DBG_TXSTSFSTS */
    const uint32_t  reserved_31_26 :  6;  /* ALT_EMAC_GMAC_DBG_RSVD_31_26 */
};

/* The typedef declaration for register ALT_EMAC_GMAC_DBG. */
typedef volatile struct ALT_EMAC_GMAC_DBG_s  ALT_EMAC_GMAC_DBG_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_DBG register. */
#define ALT_EMAC_GMAC_DBG_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_DBG register from the beginning of the component. */
#define ALT_EMAC_GMAC_DBG_OFST        0x24
/* The address of the ALT_EMAC_GMAC_DBG register. */
#define ALT_EMAC_GMAC_DBG_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_DBG_OFST))

/*
 * Register : gmacgrp_lpi_control_status
 * 
 * <b> Register 12 (LPI Control and Status Register) </b>
 * 
 * The LPI Control and Status Register controls the LPI functions and provides the
 * LPI interrupt status. The status bits are cleared when this register is read.
 * This register is present only when you select the Energy Efficient Ethernet
 * feature during core configuration.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                          
 * :--------|:-------|:------|:--------------------------------------
 *  [0]     | R      | 0x0   | ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN    
 *  [1]     | R      | 0x0   | ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX    
 *  [2]     | R      | 0x0   | ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN    
 *  [3]     | R      | 0x0   | ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX    
 *  [7:4]   | R      | 0x0   | ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4  
 *  [8]     | R      | 0x0   | ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST    
 *  [9]     | R      | 0x0   | ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST    
 *  [15:10] | R      | 0x0   | ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10
 *  [16]    | RW     | 0x0   | ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN     
 *  [17]    | RW     | 0x0   | ALT_EMAC_GMAC_LPI_CTL_STAT_PLS       
 *  [18]    | R      | 0x0   | ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN     
 *  [19]    | RW     | 0x0   | ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA    
 *  [31:20] | R      | 0x0   | ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20
 * 
 */
/*
 * Field : tlpien
 * 
 * Transmit LPI Entry
 * 
 * When set, this bit indicates that the MAC Transmitter has entered the LPI state
 * because of the setting of the LPIEN bit. This bit is cleared by a read into this
 * register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : tlpiex
 * 
 * Transmit LPI Exit
 * 
 * When set, this bit indicates that the MAC transmitter has exited the LPI state
 * after the user has cleared the LPIEN bit and the LPI TW Timer has expired. This
 * bit is cleared by a read into this register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : rlpien
 * 
 * Receive LPI Entry
 * 
 * When set, this bit indicates that the MAC Receiver has received an LPI pattern
 * and entered the LPI state. This bit is cleared by a read into this register.
 * 
 * Note:
 * 
 * This bit may not get set if the MAC stops receiving the LPI pattern for a very
 * short duration, such as, less than 3 clock cycles of CSR clock.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : rlpiex
 * 
 * Receive LPI Exit
 * 
 * When set, this bit indicates that the MAC Receiver has stopped receiving the LPI
 * pattern on the GMII or MII interface, exited the LPI state, and resumed the
 * normal reception. This bit is cleared by a read into this register.
 * 
 * Note:
 * 
 * This bit may not get set if the MAC stops receiving the LPI pattern for a very
 * short duration, such as, less than 3 clock cycles of CSR clock.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : reserved_7_4
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4 register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4 register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4 register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4_WIDTH      4
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4 register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4_SET_MSK    0x000000f0
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4 register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4_CLR_MSK    0xffffff0f
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4 register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4 field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4_GET(value) (((value) & 0x000000f0) >> 4)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4_SET(value) (((value) << 4) & 0x000000f0)

/*
 * Field : tlpist
 * 
 * Transmit LPI State
 * 
 * When set, this bit indicates that the MAC is transmitting the LPI pattern on the
 * GMII or MII interface.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : rlpist
 * 
 * Receive LPI State
 * 
 * When set, this bit indicates that the MAC is receiving the LPI pattern on the
 * GMII or MII interface.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : reserved_15_10
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10 register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10 register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10 register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10_WIDTH      6
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10 register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10_SET_MSK    0x0000fc00
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10 register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10_CLR_MSK    0xffff03ff
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10 register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10 field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10_GET(value) (((value) & 0x0000fc00) >> 10)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10_SET(value) (((value) << 10) & 0x0000fc00)

/*
 * Field : lpien
 * 
 * LPI Enable
 * 
 * When set, this bit instructs the MAC Transmitter to enter the LPI state. When
 * reset, this bit instructs the MAC to exit the LPI state and resume normal
 * transmission.
 * 
 * This bit is cleared when the LPITXA bit is set and the MAC exits the LPI state
 * because of the arrival of a new packet for transmission.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : pls
 * 
 * PHY Link Status
 * 
 * This bit indicates the link status of the PHY. The MAC Transmitter asserts the
 * LPI pattern only when the link status is up (okay) at least for the time
 * indicated by the LPI LS TIMER.
 * 
 * When set, the link is considered to be okay (up) and when reset, the link is
 * considered to be down.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description
 * :--------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_PLS
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_PLS
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_PLS register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_PLS register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_MSB        17
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_PLS register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_PLS register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_SET_MSK    0x00020000
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_PLS register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_CLR_MSK    0xfffdffff
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_PLS register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_PLS field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_PLS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : plsen
 * 
 * PHY Link Status Enable
 * 
 * This bit enables the link status received on the RGMII, SGMII, or SMII receive
 * paths to be used for activating the LPI LS TIMER.
 * 
 * When set, the MAC uses the link-status bits of Register 54 (SGMII/RGMII/SMII
 * Status Register) and Bit 17 (PLS) for the LPI LS Timer trigger. When cleared,
 * the MAC ignores the link-status bits of Register 54 and takes only the PLS bit.
 * 
 * This bit is RO and reserved if you have not selected the RGMII, SGMII, or SMII
 * PHY interface.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_MSB        18
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_SET_MSK    0x00040000
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_CLR_MSK    0xfffbffff
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : lpitxa
 * 
 * LPI TX Automate
 * 
 * This bit controls the behavior of the MAC when it is entering or coming out of
 * the LPI mode on the transmit side. This bit is not functional in the GMAC-CORE
 * configuration in which the Tx clock gating is done during the LPI mode.
 * 
 * If the LPITXA and LPIEN bits are set to 1, the MAC enters the LPI mode only
 * after all outstanding frames (in the core) and pending frames (in the
 * application interface) have been transmitted. The MAC comes out of the LPI mode
 * when the application sends any frame for transmission or the application issues
 * a TX FIFO Flush command. In addition, the MAC automatically clears the LPIEN bit
 * when it exits the LPI state. If TX FIFO Flush is set, in Bit 20 of Register 6
 * (Operation Mode Register), when the MAC is in the LPI mode, the MAC exits the
 * LPI mode.
 * 
 * When this bit is 0, the LPIEN bit directly controls behavior of the MAC when it
 * is entering or coming out of the LPI mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA
 * 
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_MSB        19
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_SET_MSK    0x00080000
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : reserved_31_20
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20 register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20 register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20 register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20_WIDTH      12
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20 register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20_SET_MSK    0xfff00000
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20 register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20_CLR_MSK    0x000fffff
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20 register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20 field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20_GET(value) (((value) & 0xfff00000) >> 20)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20_SET(value) (((value) << 20) & 0xfff00000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_LPI_CTL_STAT.
 */
struct ALT_EMAC_GMAC_LPI_CTL_STAT_s
{
    const uint32_t  tlpien         :  1;  /* ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN */
    const uint32_t  tlpiex         :  1;  /* ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX */
    const uint32_t  rlpien         :  1;  /* ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN */
    const uint32_t  rlpiex         :  1;  /* ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX */
    const uint32_t  reserved_7_4   :  4;  /* ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_7_4 */
    const uint32_t  tlpist         :  1;  /* ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST */
    const uint32_t  rlpist         :  1;  /* ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST */
    const uint32_t  reserved_15_10 :  6;  /* ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_15_10 */
    uint32_t        lpien          :  1;  /* ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN */
    uint32_t        pls            :  1;  /* ALT_EMAC_GMAC_LPI_CTL_STAT_PLS */
    const uint32_t  plsen          :  1;  /* ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN */
    uint32_t        lpitxa         :  1;  /* ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA */
    const uint32_t  reserved_31_20 : 12;  /* ALT_EMAC_GMAC_LPI_CTL_STAT_RSVD_31_20 */
};

/* The typedef declaration for register ALT_EMAC_GMAC_LPI_CTL_STAT. */
typedef volatile struct ALT_EMAC_GMAC_LPI_CTL_STAT_s  ALT_EMAC_GMAC_LPI_CTL_STAT_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_LPI_CTL_STAT register from the beginning of the component. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_OFST        0x30
/* The address of the ALT_EMAC_GMAC_LPI_CTL_STAT register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_LPI_CTL_STAT_OFST))

/*
 * Register : gmacgrp_lpi_timers_control
 * 
 * <b> Register 13 (LPI Timers Control Register) </b>
 * 
 * The LPI Timers Control register controls the timeout values in the LPI states.
 * It specifies the time for which the MAC transmits the LPI pattern and also the
 * time for which the MAC waits before resuming the normal transmission. This
 * register is present only when you select the Energy Efficient Ethernet feature
 * during core configuration.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                          
 * :--------|:-------|:------|:--------------------------------------
 *  [15:0]  | RW     | 0x0   | ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT       
 *  [25:16] | RW     | 0x3e8 | ALT_EMAC_GMAC_LPI_TMRS_CTL_LST       
 *  [31:26] | R      | 0x0   | ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26
 * 
 */
/*
 * Field : twt
 * 
 * LPI TW Timer
 * 
 * This field specifies the minimum time (in microseconds) for which the MAC waits
 * after it stops transmitting the LPI pattern to the PHY and before it resumes the
 * normal transmission. The TLPIEX status bit is set after the expiry of this
 * timer.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT register field value. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT register field value. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT field value from a register. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : lst
 * 
 * LPI LS Timer
 * 
 * This field specifies the minimum time (in milliseconds) for which the link
 * status from the PHY should be up (OKAY) before the LPI pattern can be
 * transmitted to the PHY. The MAC does not transmit the LPI pattern even when the
 * LPIEN bit is set unless the LPI LS Timer reaches the programmed terminal count.
 * The default value of the LPI LS Timer is 1000 (1 sec) as defined in the IEEE
 * standard.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_TMRS_CTL_LST register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_LST_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_TMRS_CTL_LST register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_LST_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_LPI_TMRS_CTL_LST register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_LST_WIDTH      10
/* The mask used to set the ALT_EMAC_GMAC_LPI_TMRS_CTL_LST register field value. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_LST_SET_MSK    0x03ff0000
/* The mask used to clear the ALT_EMAC_GMAC_LPI_TMRS_CTL_LST register field value. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_LST_CLR_MSK    0xfc00ffff
/* The reset value of the ALT_EMAC_GMAC_LPI_TMRS_CTL_LST register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_LST_RESET      0x3e8
/* Extracts the ALT_EMAC_GMAC_LPI_TMRS_CTL_LST field value from a register. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_LST_GET(value) (((value) & 0x03ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_LPI_TMRS_CTL_LST register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_LST_SET(value) (((value) << 16) & 0x03ff0000)

/*
 * Field : reserved_31_26
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26_WIDTH      6
/* The mask used to set the ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26 register field value. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26_SET_MSK    0xfc000000
/* The mask used to clear the ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26 register field value. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26_CLR_MSK    0x03ffffff
/* The reset value of the ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26 field value from a register. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26_GET(value) (((value) & 0xfc000000) >> 26)
/* Produces a ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26_SET(value) (((value) << 26) & 0xfc000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_LPI_TMRS_CTL.
 */
struct ALT_EMAC_GMAC_LPI_TMRS_CTL_s
{
    uint32_t        twt            : 16;  /* ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT */
    uint32_t        lst            : 10;  /* ALT_EMAC_GMAC_LPI_TMRS_CTL_LST */
    const uint32_t  reserved_31_26 :  6;  /* ALT_EMAC_GMAC_LPI_TMRS_CTL_RSVD_31_26 */
};

/* The typedef declaration for register ALT_EMAC_GMAC_LPI_TMRS_CTL. */
typedef volatile struct ALT_EMAC_GMAC_LPI_TMRS_CTL_s  ALT_EMAC_GMAC_LPI_TMRS_CTL_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_LPI_TMRS_CTL register. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_RESET       0x03e80000
/* The byte offset of the ALT_EMAC_GMAC_LPI_TMRS_CTL register from the beginning of the component. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_OFST        0x34
/* The address of the ALT_EMAC_GMAC_LPI_TMRS_CTL register. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_LPI_TMRS_CTL_OFST))

/*
 * Register : gmacgrp_interrupt_status
 * 
 * <b> Register 14 (Interrupt Register) </b>
 * 
 * The Interrupt Status register identifies the events in the MAC that can generate
 * interrupt. All interrupt events are generated only when the corresponding
 * optional feature is selected during core configuration and enabled during
 * operation. Therefore, these bits are reserved when the corresponding features
 * are not present in the core.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                      
 * :--------|:-------|:------|:----------------------------------
 *  [0]     | R      | 0x0   | ALT_EMAC_GMAC_INT_STAT_RGSMIIIS  
 *  [1]     | R      | 0x0   | ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS 
 *  [2]     | R      | 0x0   | ALT_EMAC_GMAC_INT_STAT_PCSANCIS  
 *  [3]     | R      | 0x0   | ALT_EMAC_GMAC_INT_STAT_PMTIS     
 *  [4]     | R      | 0x0   | ALT_EMAC_GMAC_INT_STAT_MMCIS     
 *  [5]     | R      | 0x0   | ALT_EMAC_GMAC_INT_STAT_MMCRXIS   
 *  [6]     | R      | 0x0   | ALT_EMAC_GMAC_INT_STAT_MMCTXIS   
 *  [7]     | R      | 0x0   | ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS 
 *  [8]     | R      | 0x0   | ALT_EMAC_GMAC_INT_STAT_RSVD_8    
 *  [9]     | R      | 0x0   | ALT_EMAC_GMAC_INT_STAT_TSIS      
 *  [10]    | R      | 0x0   | ALT_EMAC_GMAC_INT_STAT_LPIIS     
 *  [11]    | R      | 0x0   | ALT_EMAC_GMAC_INT_STAT_GPIIS     
 *  [31:12] | R      | 0x0   | ALT_EMAC_GMAC_INT_STAT_RSVD_31_12
 * 
 */
/*
 * Field : rgsmiiis
 * 
 * RGMII or SMII Interrupt Status
 * 
 * This bit is set because of any change in value of the Link Status of RGMII or
 * SMII interface (Bit 3 in Register 54 (SGMII/RGMII/SMII Status Register)). This
 * bit is cleared when you perform a read operation on the SGMII/RGMII/SMII Status
 * Register.
 * 
 * This bit is valid only when you select the optional RGMII or SMII PHY interface
 * during core configuration and operation.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_RGSMIIIS
 * 
 */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_RGSMIIIS
 * 
 */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_RGSMIIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_RGSMIIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_RGSMIIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_RGSMIIIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_RGSMIIIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_RGSMIIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_RGSMIIIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_INT_STAT_RGSMIIIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : pcslchgis
 * 
 * PCS Link Status Changed
 * 
 * This bit is set because of any change in Link Status in the TBI, RTBI, or SGMII
 * PHY interface (Bit 2 in Register 49 (AN Status Register)). This bit is cleared
 * when you perform a read operation on the AN Status register.
 * 
 * This bit is valid only when you select the optional TBI, RTBI, or SGMII PHY
 * interface during core configuration and operation.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : pcsancis
 * 
 * PCS Auto-Negotiation Complete
 * 
 * This bit is set when the Auto-negotiation is completed in the TBI, RTBI, or
 * SGMII PHY interface (Bit 5 in Register 49 (AN Status Register)). This bit is
 * cleared when you perform a read operation to the AN Status register.
 * 
 * This bit is valid only when you select the optional TBI, RTBI, or SGMII PHY
 * interface during core configuration and operation.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_PCSANCIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PCSANCIS_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_PCSANCIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PCSANCIS_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_PCSANCIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PCSANCIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_PCSANCIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_PCSANCIS_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_PCSANCIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_PCSANCIS_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_PCSANCIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PCSANCIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_PCSANCIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_PCSANCIS_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_INT_STAT_PCSANCIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_PCSANCIS_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : pmtis
 * 
 * PMT Interrupt Status
 * 
 * This bit is set when a Magic packet or Wake-on-LAN frame is received in the
 * power-down mode (see Bits 5 and 6 in the PMT Control and Status Register). This
 * bit is cleared when both Bits[6:5] are cleared because of a read operation to
 * the PMT Control and Status register.
 * 
 * This bit is valid only when you select the optional PMT module during core
 * configuration.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_PMTIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PMTIS_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_PMTIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PMTIS_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_PMTIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PMTIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_PMTIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_PMTIS_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_PMTIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_PMTIS_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_PMTIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PMTIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_PMTIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_PMTIS_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_INT_STAT_PMTIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_PMTIS_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : mmcis
 * 
 * MMC Interrupt Status
 * 
 * This bit is set high when any of the Bits [7:5] is set high and cleared only
 * when all of these bits are low.
 * 
 * This bit is valid only when you select the optional MMC module during core
 * configuration.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_INT_STAT_MMCIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_INT_STAT_MMCIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_MMCIS
 * 
 */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_MMCIS
 * 
 */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_MMCIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_MMCIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_MMCIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_MMCIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_MMCIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_MMCIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_MMCIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_INT_STAT_MMCIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : mmcrxis
 * 
 * MMC Receive Interrupt Status
 * 
 * This bit is set high when an interrupt is generated in the MMC Receive Interrupt
 * Register. This bit is cleared when all the bits in this interrupt register are
 * cleared.
 * 
 * This bit is valid only when you select the optional MMC module during core
 * configuration.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description
 * :--------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_INT_STAT_MMCRXIS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_INT_STAT_MMCRXIS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_MMCRXIS
 * 
 */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_MMCRXIS
 * 
 */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_MMCRXIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_MMCRXIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_MMCRXIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_MMCRXIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_SET_MSK    0x00000020
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_MMCRXIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_CLR_MSK    0xffffffdf
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_MMCRXIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_MMCRXIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_EMAC_GMAC_INT_STAT_MMCRXIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : mmctxis
 * 
 * MMC Transmit Interrupt Status
 * 
 * This bit is set high when an interrupt is generated in the MMC Transmit
 * Interrupt Register. This bit is cleared when all the bits in this interrupt
 * register are cleared.
 * 
 * This bit is valid only when you select the optional MMC module during core
 * configuration.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_INT_STAT_MMCTXIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_INT_STAT_MMCTXIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_MMCTXIS
 * 
 */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_MMCTXIS
 * 
 */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_MMCTXIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_MMCTXIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_MSB        6
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_MMCTXIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_MMCTXIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_SET_MSK    0x00000040
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_MMCTXIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_CLR_MSK    0xffffffbf
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_MMCTXIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_MMCTXIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_EMAC_GMAC_INT_STAT_MMCTXIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : mmcrxipis
 * 
 * MMC Receive Checksum Offload Interrupt Status
 * 
 * This bit is set high when an interrupt is generated in the MMC Receive Checksum
 * Offload Interrupt Register. This bit is cleared when all the bits in this
 * interrupt register are cleared.
 * 
 * This bit is valid only when you select the optional MMC module and Checksum
 * Offload Engine (Type 2) during core configuration.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS
 * 
 */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS
 * 
 */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_SET_MSK    0x00000080
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_CLR_MSK    0xffffff7f
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : reserved_8
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_RSVD_8 register field. */
#define ALT_EMAC_GMAC_INT_STAT_RSVD_8_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_RSVD_8 register field. */
#define ALT_EMAC_GMAC_INT_STAT_RSVD_8_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_RSVD_8 register field. */
#define ALT_EMAC_GMAC_INT_STAT_RSVD_8_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_RSVD_8 register field value. */
#define ALT_EMAC_GMAC_INT_STAT_RSVD_8_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_RSVD_8 register field value. */
#define ALT_EMAC_GMAC_INT_STAT_RSVD_8_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_RSVD_8 register field. */
#define ALT_EMAC_GMAC_INT_STAT_RSVD_8_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_RSVD_8 field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_RSVD_8_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_INT_STAT_RSVD_8 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_RSVD_8_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : tsis
 * 
 * Timestamp Interrupt Status
 * 
 * When the Advanced Timestamp feature is enabled, this bit is set when any of the
 * following conditions is true:
 * 
 * * The system time value equals or exceeds the value specified in the Target Time
 *   High and Low registers.
 * 
 * * There is an overflow in the seconds register.
 * 
 * * The Auxiliary snapshot trigger is asserted.
 * 
 * This bit is cleared on reading Bit 0 of the Register 458 (Timestamp Status
 * Register).
 * 
 * If default Timestamping is enabled, when set, this bit indicates that the system
 * time value is equal to or exceeds the value specified in the Target Time
 * registers. In this mode, this bit is cleared after the completion of the read of
 * this bit. In all other modes, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description
 * :------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_INT_STAT_TSIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_INT_STAT_TSIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_TSIS
 * 
 */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_TSIS
 * 
 */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_TSIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_TSIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_TSIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_TSIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_TSIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_TSIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_TSIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_INT_STAT_TSIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : lpiis
 * 
 * LPI Interrupt Status
 * 
 * When the Energy Efficient Ethernet feature is enabled, this bit is set for any
 * LPI state entry or exit in the MAC Transmitter or Receiver. This bit is cleared
 * on reading Bit 0 of Register 12 (LPI Control and Status Register). In all other
 * modes, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_INT_STAT_LPIIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_INT_STAT_LPIIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_LPIIS
 * 
 */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_LPIIS
 * 
 */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_LPIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_LPIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_LPIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_LPIIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_SET_MSK    0x00000400
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_LPIIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_CLR_MSK    0xfffffbff
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_LPIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_LPIIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_EMAC_GMAC_INT_STAT_LPIIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : gpiis
 * 
 * GPI Interrupt Status
 * 
 * When the GPIO feature is enabled, this bit is set when any active event (LL or
 * LH) occurs on GPIS field (Bits [3:0]) of Register 56 (General Purpose IO
 * Register) and the corresponding GPIE bit is enabled. This bit is cleared on
 * reading the lane 0 (GPIS) of Register 56 (Genaral Purpose IO Register). When the
 * GPIO feature is not enabled, this bit is reserved.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_GPIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_GPIIS_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_GPIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_GPIIS_MSB        11
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_GPIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_GPIIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_GPIIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_GPIIS_SET_MSK    0x00000800
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_GPIIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_GPIIS_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_GPIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_GPIIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_GPIIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_GPIIS_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_EMAC_GMAC_INT_STAT_GPIIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_GPIIS_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : reserved_31_12
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_RSVD_31_12 register field. */
#define ALT_EMAC_GMAC_INT_STAT_RSVD_31_12_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_RSVD_31_12 register field. */
#define ALT_EMAC_GMAC_INT_STAT_RSVD_31_12_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_RSVD_31_12 register field. */
#define ALT_EMAC_GMAC_INT_STAT_RSVD_31_12_WIDTH      20
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_RSVD_31_12 register field value. */
#define ALT_EMAC_GMAC_INT_STAT_RSVD_31_12_SET_MSK    0xfffff000
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_RSVD_31_12 register field value. */
#define ALT_EMAC_GMAC_INT_STAT_RSVD_31_12_CLR_MSK    0x00000fff
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_RSVD_31_12 register field. */
#define ALT_EMAC_GMAC_INT_STAT_RSVD_31_12_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_RSVD_31_12 field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_RSVD_31_12_GET(value) (((value) & 0xfffff000) >> 12)
/* Produces a ALT_EMAC_GMAC_INT_STAT_RSVD_31_12 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_RSVD_31_12_SET(value) (((value) << 12) & 0xfffff000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_INT_STAT.
 */
struct ALT_EMAC_GMAC_INT_STAT_s
{
    const uint32_t  rgsmiiis       :  1;  /* ALT_EMAC_GMAC_INT_STAT_RGSMIIIS */
    const uint32_t  pcslchgis      :  1;  /* ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS */
    const uint32_t  pcsancis       :  1;  /* ALT_EMAC_GMAC_INT_STAT_PCSANCIS */
    const uint32_t  pmtis          :  1;  /* ALT_EMAC_GMAC_INT_STAT_PMTIS */
    const uint32_t  mmcis          :  1;  /* ALT_EMAC_GMAC_INT_STAT_MMCIS */
    const uint32_t  mmcrxis        :  1;  /* ALT_EMAC_GMAC_INT_STAT_MMCRXIS */
    const uint32_t  mmctxis        :  1;  /* ALT_EMAC_GMAC_INT_STAT_MMCTXIS */
    const uint32_t  mmcrxipis      :  1;  /* ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS */
    const uint32_t  reserved_8     :  1;  /* ALT_EMAC_GMAC_INT_STAT_RSVD_8 */
    const uint32_t  tsis           :  1;  /* ALT_EMAC_GMAC_INT_STAT_TSIS */
    const uint32_t  lpiis          :  1;  /* ALT_EMAC_GMAC_INT_STAT_LPIIS */
    const uint32_t  gpiis          :  1;  /* ALT_EMAC_GMAC_INT_STAT_GPIIS */
    const uint32_t  reserved_31_12 : 20;  /* ALT_EMAC_GMAC_INT_STAT_RSVD_31_12 */
};

/* The typedef declaration for register ALT_EMAC_GMAC_INT_STAT. */
typedef volatile struct ALT_EMAC_GMAC_INT_STAT_s  ALT_EMAC_GMAC_INT_STAT_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_INT_STAT register. */
#define ALT_EMAC_GMAC_INT_STAT_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_INT_STAT register from the beginning of the component. */
#define ALT_EMAC_GMAC_INT_STAT_OFST        0x38
/* The address of the ALT_EMAC_GMAC_INT_STAT register. */
#define ALT_EMAC_GMAC_INT_STAT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_INT_STAT_OFST))

/*
 * Register : gmacgrp_interrupt_mask
 * 
 * <b> Register 15 (Interrupt Mask Register) </b>
 * 
 * The Interrupt Mask Register bits enable you to mask the interrupt signal because
 * of the corresponding event in the Interrupt Status Register. The interrupt
 * signal is sbd_intr_o in the GMAC-AHB, GMAC-AXI, and GMAC-DMA configuration and
 * mci_intr_o in the GMAC-MTL and GMAC-CORE configuration.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                     
 * :--------|:-------|:------|:---------------------------------
 *  [0]     | R      | 0x0   | ALT_EMAC_GMAC_INT_MSK_RGSMIIIM  
 *  [1]     | R      | 0x0   | ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM 
 *  [2]     | R      | 0x0   | ALT_EMAC_GMAC_INT_MSK_PCSANCIM  
 *  [3]     | RW     | 0x0   | ALT_EMAC_GMAC_INT_MSK_PMTIM     
 *  [8:4]   | R      | 0x0   | ALT_EMAC_GMAC_INT_MSK_RSVD_8_4  
 *  [9]     | R      | 0x0   | ALT_EMAC_GMAC_INT_MSK_TSIM      
 *  [10]    | RW     | 0x0   | ALT_EMAC_GMAC_INT_MSK_LPIIM     
 *  [31:11] | R      | 0x0   | ALT_EMAC_GMAC_INT_MSK_RSVD_31_11
 * 
 */
/*
 * Field : rgsmiiim
 * 
 * RGMII or SMII Interrupt Mask
 * 
 * When set, this bit disables the assertion of the interrupt signal because of the
 * setting of the RGMII or SMII Interrupt Status bit in Register 14 (Interrupt
 * Status Register).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description
 * :--------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_MSK_RGSMIIIM
 * 
 */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_MSK_RGSMIIIM
 * 
 */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_MSK_RGSMIIIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_MSK_RGSMIIIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_INT_MSK_RGSMIIIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_MSK_RGSMIIIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_INT_MSK_RGSMIIIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_INT_MSK_RGSMIIIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_MSK_RGSMIIIM field value from a register. */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_INT_MSK_RGSMIIIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : pcslchgim
 * 
 * PCS Link Status Interrupt Mask
 * 
 * When set, this bit disables the assertion of the interrupt signal because of the
 * setting of the PCS Link-status changed bit in Register 14 (Interrupt Status
 * Register).
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM field value from a register. */
#define ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : pcsancim
 * 
 * PCS AN Completion Interrupt Mask
 * 
 * When set, this bit disables the assertion of the interrupt signal because of the
 * setting of PCS Auto-negotiation complete bit in Register 14 (Interrupt Status
 * Register).
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_MSK_PCSANCIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PCSANCIM_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_MSK_PCSANCIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PCSANCIM_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_INT_MSK_PCSANCIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PCSANCIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_MSK_PCSANCIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_PCSANCIM_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_INT_MSK_PCSANCIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_PCSANCIM_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_INT_MSK_PCSANCIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PCSANCIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_MSK_PCSANCIM field value from a register. */
#define ALT_EMAC_GMAC_INT_MSK_PCSANCIM_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_INT_MSK_PCSANCIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_MSK_PCSANCIM_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : pmtim
 * 
 * PMT Interrupt Mask
 * 
 * When set, this bit disables the assertion of the interrupt signal because of the
 * setting of PMT Interrupt Status bit in Register 14 (Interrupt Status Register).
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_MSK_PMTIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PMTIM_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_MSK_PMTIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PMTIM_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_INT_MSK_PMTIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PMTIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_MSK_PMTIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_PMTIM_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_INT_MSK_PMTIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_PMTIM_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_INT_MSK_PMTIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PMTIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_MSK_PMTIM field value from a register. */
#define ALT_EMAC_GMAC_INT_MSK_PMTIM_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_INT_MSK_PMTIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_MSK_PMTIM_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : reserved_8_4
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_MSK_RSVD_8_4 register field. */
#define ALT_EMAC_GMAC_INT_MSK_RSVD_8_4_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_MSK_RSVD_8_4 register field. */
#define ALT_EMAC_GMAC_INT_MSK_RSVD_8_4_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_INT_MSK_RSVD_8_4 register field. */
#define ALT_EMAC_GMAC_INT_MSK_RSVD_8_4_WIDTH      5
/* The mask used to set the ALT_EMAC_GMAC_INT_MSK_RSVD_8_4 register field value. */
#define ALT_EMAC_GMAC_INT_MSK_RSVD_8_4_SET_MSK    0x000001f0
/* The mask used to clear the ALT_EMAC_GMAC_INT_MSK_RSVD_8_4 register field value. */
#define ALT_EMAC_GMAC_INT_MSK_RSVD_8_4_CLR_MSK    0xfffffe0f
/* The reset value of the ALT_EMAC_GMAC_INT_MSK_RSVD_8_4 register field. */
#define ALT_EMAC_GMAC_INT_MSK_RSVD_8_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_MSK_RSVD_8_4 field value from a register. */
#define ALT_EMAC_GMAC_INT_MSK_RSVD_8_4_GET(value) (((value) & 0x000001f0) >> 4)
/* Produces a ALT_EMAC_GMAC_INT_MSK_RSVD_8_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_MSK_RSVD_8_4_SET(value) (((value) << 4) & 0x000001f0)

/*
 * Field : tsim
 * 
 * Timestamp Interrupt Mask
 * 
 * When set, this bit disables the assertion of the interrupt signal because of the
 * setting of Timestamp Interrupt Status bit in Register 14 (Interrupt Status
 * Register).
 * 
 * This bit is valid only when IEEE1588 timestamping is enabled. In all other
 * modes, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description
 * :----------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_INT_MSK_TSIM_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_INT_MSK_TSIM_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_MSK_TSIM
 * 
 */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_MSK_TSIM
 * 
 */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_MSK_TSIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_MSK_TSIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_INT_MSK_TSIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_MSK_TSIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_INT_MSK_TSIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_INT_MSK_TSIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_MSK_TSIM field value from a register. */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_INT_MSK_TSIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : lpiim
 * 
 * LPI Interrupt Mask
 * 
 * When set, this bit disables the assertion of the interrupt signal because of the
 * setting of the LPI Interrupt Status bit in Register 14 (Interrupt Status
 * Register).
 * 
 * This bit is valid only when you select the Energy Efficient Ethernet feature
 * during core configuration. In all other modes, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description
 * :-----------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_INT_MSK_LPIIM_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_INT_MSK_LPIIM_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_MSK_LPIIM
 * 
 */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_MSK_LPIIM
 * 
 */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_MSK_LPIIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_MSK_LPIIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_INT_MSK_LPIIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_MSK_LPIIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_SET_MSK    0x00000400
/* The mask used to clear the ALT_EMAC_GMAC_INT_MSK_LPIIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_CLR_MSK    0xfffffbff
/* The reset value of the ALT_EMAC_GMAC_INT_MSK_LPIIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_MSK_LPIIM field value from a register. */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_EMAC_GMAC_INT_MSK_LPIIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : reserved_31_11
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_MSK_RSVD_31_11 register field. */
#define ALT_EMAC_GMAC_INT_MSK_RSVD_31_11_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_MSK_RSVD_31_11 register field. */
#define ALT_EMAC_GMAC_INT_MSK_RSVD_31_11_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_INT_MSK_RSVD_31_11 register field. */
#define ALT_EMAC_GMAC_INT_MSK_RSVD_31_11_WIDTH      21
/* The mask used to set the ALT_EMAC_GMAC_INT_MSK_RSVD_31_11 register field value. */
#define ALT_EMAC_GMAC_INT_MSK_RSVD_31_11_SET_MSK    0xfffff800
/* The mask used to clear the ALT_EMAC_GMAC_INT_MSK_RSVD_31_11 register field value. */
#define ALT_EMAC_GMAC_INT_MSK_RSVD_31_11_CLR_MSK    0x000007ff
/* The reset value of the ALT_EMAC_GMAC_INT_MSK_RSVD_31_11 register field. */
#define ALT_EMAC_GMAC_INT_MSK_RSVD_31_11_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_MSK_RSVD_31_11 field value from a register. */
#define ALT_EMAC_GMAC_INT_MSK_RSVD_31_11_GET(value) (((value) & 0xfffff800) >> 11)
/* Produces a ALT_EMAC_GMAC_INT_MSK_RSVD_31_11 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_MSK_RSVD_31_11_SET(value) (((value) << 11) & 0xfffff800)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_INT_MSK.
 */
struct ALT_EMAC_GMAC_INT_MSK_s
{
    const uint32_t  rgsmiiim       :  1;  /* ALT_EMAC_GMAC_INT_MSK_RGSMIIIM */
    const uint32_t  pcslchgim      :  1;  /* ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM */
    const uint32_t  pcsancim       :  1;  /* ALT_EMAC_GMAC_INT_MSK_PCSANCIM */
    uint32_t        pmtim          :  1;  /* ALT_EMAC_GMAC_INT_MSK_PMTIM */
    const uint32_t  reserved_8_4   :  5;  /* ALT_EMAC_GMAC_INT_MSK_RSVD_8_4 */
    const uint32_t  tsim           :  1;  /* ALT_EMAC_GMAC_INT_MSK_TSIM */
    uint32_t        lpiim          :  1;  /* ALT_EMAC_GMAC_INT_MSK_LPIIM */
    const uint32_t  reserved_31_11 : 21;  /* ALT_EMAC_GMAC_INT_MSK_RSVD_31_11 */
};

/* The typedef declaration for register ALT_EMAC_GMAC_INT_MSK. */
typedef volatile struct ALT_EMAC_GMAC_INT_MSK_s  ALT_EMAC_GMAC_INT_MSK_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_INT_MSK register. */
#define ALT_EMAC_GMAC_INT_MSK_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_INT_MSK register from the beginning of the component. */
#define ALT_EMAC_GMAC_INT_MSK_OFST        0x3c
/* The address of the ALT_EMAC_GMAC_INT_MSK register. */
#define ALT_EMAC_GMAC_INT_MSK_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_INT_MSK_OFST))

/*
 * Register : gmacgrp_mac_address0_high
 * 
 * <b> Register 16 (MAC Address0 High Register) </b>
 * 
 * The MAC Address0 High register holds the upper 16 bits of the first 6-byte MAC
 * address of the station. The first DA byte that is received on the (G)MII
 * interface corresponds to the LS byte (Bits [7:0]) of the MAC Address Low
 * register. For example, if 0x112233445566 is received (0x11 in lane 0 of the
 * first column) on the (G)MII as the destination address, then the MacAddress0
 * Register [47:0] is compared with 0x665544332211.
 * 
 * If the MAC address registers are configured to be double-synchronized to the
 * (G)MII clock domains, then the synchronization is triggered only when
 * Bits[31:24] (in little-endian mode) or Bits[7:0] (in big-endian mode) of the MAC
 * Address0 Low Register are written. For proper synchronization updates, the
 * consecutive writes to this Address Low Register should be performed after at
 * least four clock cycles in the destination clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                            
 * :--------|:-------|:-------|:----------------------------------------
 *  [15:0]  | RW     | 0xffff | ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI    
 *  [30:16] | R      | 0x0    | ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16
 *  [31]    | R      | 0x1    | ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE        
 * 
 */
/*
 * Field : addrhi
 * 
 * MAC Address0 [47:32]
 * 
 * This field contains the upper 16 bits (47:32) of the first 6-byte MAC address.
 * The MAC uses this field for filtering the received frames and inserting the MAC
 * address in the Transmit Flow Control (PAUSE) Frames.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_30_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16_WIDTH      15
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16_SET_MSK    0x7fff0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16_CLR_MSK    0x8000ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16_GET(value) (((value) & 0x7fff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16_SET(value) (((value) << 16) & 0x7fff0000)

/*
 * Field : ae
 * 
 * Address Enable
 * 
 * This bit is always set to 1.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE_RESET      0x1
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR0_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR0_HIGH_s
{
    uint32_t        addrhi         : 16;  /* ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI */
    const uint32_t  reserved_30_16 : 15;  /* ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RSVD_30_16 */
    const uint32_t  ae             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR0_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR0_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR0_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_RESET       0x8000ffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_OFST        0x40
/* The address of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR0_HIGH_OFST))

/*
 * Register : gmacgrp_mac_address0_low
 * 
 * <b> Register 17 (MAC Address0 Low Register) </b>
 * 
 * The MAC Address0 Low register holds the lower 32 bits of the first 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                       
 * :-------|:-------|:-----------|:-----------------------------------
 *  [31:0] | RW     | 0xffffffff | ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO
 * 
 */
/*
 * Field : addrlo
 * 
 * MAC Address0 [31:0]
 * 
 * This field contains the lower 32 bits of the first 6-byte MAC address. This is
 * used by the MAC for filtering the received frames and inserting the MAC address
 * in the Transmit Flow Control (PAUSE) Frames.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR0_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR0_LOW_s
{
    uint32_t  addrlo : 32;  /* ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR0_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR0_LOW_s  ALT_EMAC_GMAC_MAC_ADDR0_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR0_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_RESET       0xffffffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR0_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_OFST        0x44
/* The address of the ALT_EMAC_GMAC_MAC_ADDR0_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR0_LOW_OFST))

/*
 * Register : gmacgrp_mac_address1_high
 * 
 * <b> Register 18 (MAC Address1 High Register) </b>
 * 
 * The MAC Address1 High register holds the upper 16 bits of the second 6-byte MAC
 * address of the station.
 * 
 * If the MAC address registers are configured to be double-synchronized to the
 * (G)MII clock domains, then the synchronization is triggered only when
 * Bits[31:24] (in little-endian mode) or Bits[7:0] (in big-endian mode) of the MAC
 * Address1 Low Register are written. For proper synchronization updates, the
 * consecutive writes to this Address Low Register should be performed after at
 * least four clock cycles in the destination clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                            
 * :--------|:-------|:-------|:----------------------------------------
 *  [15:0]  | RW     | 0xffff | ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI    
 *  [23:16] | R      | 0x0    | ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16
 *  [24]    | RW     | 0x0    | Mask Byte Control                      
 *  [25]    | RW     | 0x0    | Mask Byte Control                      
 *  [26]    | RW     | 0x0    | Mask Byte Control                      
 *  [27]    | RW     | 0x0    | Mask Byte Control                      
 *  [28]    | RW     | 0x0    | Mask Byte Control                      
 *  [29]    | RW     | 0x0    | Mask Byte Control                      
 *  [30]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA        
 *  [31]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE        
 * 
 */
/*
 * Field : addrhi
 * 
 * MAC Address1 [47:32]
 * 
 * This field contains the upper 16 bits (47:32) of the second 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_23_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16_CLR_MSK    0xff00ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address1 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address1 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address1 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address1 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address1 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address1 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sa
 * 
 * Source Address
 * 
 * When this bit is set, the MAC Address1[47:0] is used to compare with the SA
 * fields of the received frame.
 * 
 * When this bit is reset, the MAC Address1[47:0] is used to compare with the DA
 * fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : ae
 * 
 * Address Enable
 * 
 * When this bit is set, the address filter module uses the second MAC address for
 * perfect filtering.
 * 
 * When this bit is reset, the address filter module ignores the address for
 * filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR1_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR1_HIGH_s
{
    uint32_t        addrhi         : 16;  /* ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI */
    const uint32_t  reserved_23_16 :  8;  /* ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RSVD_23_16 */
    uint32_t        mbc_0          :  1;  /* Mask Byte Control */
    uint32_t        mbc_1          :  1;  /* Mask Byte Control */
    uint32_t        mbc_2          :  1;  /* Mask Byte Control */
    uint32_t        mbc_3          :  1;  /* Mask Byte Control */
    uint32_t        mbc_4          :  1;  /* Mask Byte Control */
    uint32_t        mbc_5          :  1;  /* Mask Byte Control */
    uint32_t        sa             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA */
    uint32_t        ae             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR1_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR1_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_RESET       0x0000ffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_OFST        0x48
/* The address of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR1_HIGH_OFST))

/*
 * Register : gmacgrp_mac_address1_low
 * 
 * <b> Register 19 (MAC Address1 Low Register) </b>
 * 
 * The MAC Address1 Low register holds the lower 32 bits of the second 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                       
 * :-------|:-------|:-----------|:-----------------------------------
 *  [31:0] | RW     | 0xffffffff | ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO
 * 
 */
/*
 * Field : addrlo
 * 
 * MAC Address1 [31:0]
 * 
 * This field contains the lower 32 bits of the second 6-byte MAC address. The
 * content of this field is undefined until loaded by the Application after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR1_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR1_LOW_s
{
    uint32_t  addrlo : 32;  /* ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR1_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR1_LOW_s  ALT_EMAC_GMAC_MAC_ADDR1_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_RESET       0xffffffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR1_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_OFST        0x4c
/* The address of the ALT_EMAC_GMAC_MAC_ADDR1_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR1_LOW_OFST))

/*
 * Register : gmacgrp_mac_address2_high
 * 
 * <b> Register 20 (MAC Address2 High Register) </b>
 * 
 * The MAC Address2 High register holds the upper 16 bits of the third 6-byte MAC
 * address of the station.
 * 
 * If the MAC address registers are configured to be double-synchronized to the
 * (G)MII clock domains, then
 * 
 * the synchronization is triggered only when Bits[31:24] (in little-endian mode)
 * or Bits[7:0] (in big-endian mode) of the MAC Address2 Low Register are written.
 * For proper synchronization updates, consecutive writes to this MAC Address2 Low
 * Register must be performed after at least four clock cycles in the destination
 * clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                            
 * :--------|:-------|:-------|:----------------------------------------
 *  [15:0]  | RW     | 0xffff | ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI    
 *  [23:16] | R      | 0x0    | ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16
 *  [24]    | RW     | 0x0    | Mask Byte Control                      
 *  [25]    | RW     | 0x0    | Mask Byte Control                      
 *  [26]    | RW     | 0x0    | Mask Byte Control                      
 *  [27]    | RW     | 0x0    | Mask Byte Control                      
 *  [28]    | RW     | 0x0    | Mask Byte Control                      
 *  [29]    | RW     | 0x0    | Mask Byte Control                      
 *  [30]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA        
 *  [31]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE        
 * 
 */
/*
 * Field : addrhi
 * 
 * MAC Address2 [47:32]
 * 
 * This field contains the upper 16 bits (47:32) of the third 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_23_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16_CLR_MSK    0xff00ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address2 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address2 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address2 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address2 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address2 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address2 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sa
 * 
 * Source Address
 * 
 * When this bit is set, the MAC Address2[47:0] is used to compare with the SA
 * fields of the received frame.
 * 
 * When this bit is reset, the MAC Address2[47:0] is used to compare with the DA
 * fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : ae
 * 
 * Address Enable
 * 
 * When this bit is set, the address filter module uses the third MAC address for
 * perfect filtering.
 * 
 * When this bit is reset, the address filter module ignores the address for
 * filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR2_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR2_HIGH_s
{
    uint32_t        addrhi         : 16;  /* ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI */
    const uint32_t  reserved_23_16 :  8;  /* ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RSVD_23_16 */
    uint32_t        mbc_0          :  1;  /* Mask Byte Control */
    uint32_t        mbc_1          :  1;  /* Mask Byte Control */
    uint32_t        mbc_2          :  1;  /* Mask Byte Control */
    uint32_t        mbc_3          :  1;  /* Mask Byte Control */
    uint32_t        mbc_4          :  1;  /* Mask Byte Control */
    uint32_t        mbc_5          :  1;  /* Mask Byte Control */
    uint32_t        sa             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA */
    uint32_t        ae             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR2_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR2_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_RESET       0x0000ffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_OFST        0x50
/* The address of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR2_HIGH_OFST))

/*
 * Register : gmacgrp_mac_address2_low
 * 
 * <b> Register 21 (MAC Address2 Low Register) </b>
 * 
 * The MAC Address2 Low register holds the lower 32 bits of the third 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                       
 * :-------|:-------|:-----------|:-----------------------------------
 *  [31:0] | RW     | 0xffffffff | ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO
 * 
 */
/*
 * Field : addrlo
 * 
 * MAC Address2 [31:0]
 * 
 * This field contains the lower 32 bits of the third 6-byte MAC address. The
 * content of this field is undefined until loaded by the Application after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR2_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR2_LOW_s
{
    uint32_t  addrlo : 32;  /* ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR2_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR2_LOW_s  ALT_EMAC_GMAC_MAC_ADDR2_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_RESET       0xffffffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR2_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_OFST        0x54
/* The address of the ALT_EMAC_GMAC_MAC_ADDR2_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR2_LOW_OFST))

/*
 * Register : gmacgrp_mac_address3_high
 * 
 * <b> Register 22 (MAC Address3 High Register) </b>
 * 
 * The MAC Address3 High register holds the upper 16 bits of the fourth 6-byte MAC
 * address of the station.
 * 
 * If the MAC address registers are configured to be double-synchronized to the
 * (G)MII clock domains, then
 * 
 * the synchronization is triggered only when Bits[31:24] (in little-endian mode)
 * or Bits[7:0] (in big-endian mode) of the MAC Address3 Low Register are written.
 * For proper synchronization updates, consecutive writes to this MAC Address3 Low
 * Register must be performed after at least four clock cycles in the destination
 * clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                            
 * :--------|:-------|:-------|:----------------------------------------
 *  [15:0]  | RW     | 0xffff | ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI    
 *  [23:16] | R      | 0x0    | ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16
 *  [24]    | RW     | 0x0    | Mask Byte Control                      
 *  [25]    | RW     | 0x0    | Mask Byte Control                      
 *  [26]    | RW     | 0x0    | Mask Byte Control                      
 *  [27]    | RW     | 0x0    | Mask Byte Control                      
 *  [28]    | RW     | 0x0    | Mask Byte Control                      
 *  [29]    | RW     | 0x0    | Mask Byte Control                      
 *  [30]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA        
 *  [31]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE        
 * 
 */
/*
 * Field : addrhi
 * 
 * MAC Address3 [47:32]
 * 
 * This field contains the upper 16 bits (47:32) of the fourth 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_23_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16_CLR_MSK    0xff00ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address3 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address3 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address3 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address3 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address3 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address3 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sa
 * 
 * Source Address
 * 
 * When this bit is set, the MAC Address3[47:0] is used to compare with the SA
 * fields of the received frame.
 * 
 * When this bit is reset, the MAC Address3[47:0] is used to compare with the DA
 * fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : ae
 * 
 * Address Enable
 * 
 * When this bit is set, the address filter module uses the fourth MAC address for
 * perfect filtering.
 * 
 * When this bit is reset, the address filter module ignores the address for
 * filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR3_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR3_HIGH_s
{
    uint32_t        addrhi         : 16;  /* ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI */
    const uint32_t  reserved_23_16 :  8;  /* ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RSVD_23_16 */
    uint32_t        mbc_0          :  1;  /* Mask Byte Control */
    uint32_t        mbc_1          :  1;  /* Mask Byte Control */
    uint32_t        mbc_2          :  1;  /* Mask Byte Control */
    uint32_t        mbc_3          :  1;  /* Mask Byte Control */
    uint32_t        mbc_4          :  1;  /* Mask Byte Control */
    uint32_t        mbc_5          :  1;  /* Mask Byte Control */
    uint32_t        sa             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA */
    uint32_t        ae             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR3_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR3_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_RESET       0x0000ffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_OFST        0x58
/* The address of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR3_HIGH_OFST))

/*
 * Register : gmacgrp_mac_address3_low
 * 
 * <b> Register 23 (MAC Address3 Low Register) </b>
 * 
 * The MAC Address3 Low register holds the lower 32 bits of the fourth 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                       
 * :-------|:-------|:-----------|:-----------------------------------
 *  [31:0] | RW     | 0xffffffff | ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO
 * 
 */
/*
 * Field : addrlo
 * 
 * MAC Address3 [31:0]
 * 
 * This field contains the lower 32 bits of the fourth 6-byte MAC address. The
 * content of this field is undefined until loaded by the Application after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR3_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR3_LOW_s
{
    uint32_t  addrlo : 32;  /* ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR3_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR3_LOW_s  ALT_EMAC_GMAC_MAC_ADDR3_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_RESET       0xffffffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR3_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_OFST        0x5c
/* The address of the ALT_EMAC_GMAC_MAC_ADDR3_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR3_LOW_OFST))

/*
 * Register : gmacgrp_mac_address4_high
 * 
 * <b> Register 24 (MAC Address4 High Register) </b>
 * 
 * The MAC Address4 High register holds the upper 16 bits of the fifth 6-byte MAC
 * address of the station.
 * 
 * If the MAC address registers are configured to be double-synchronized to the
 * (G)MII clock domains, then
 * 
 * the synchronization is triggered only when Bits[31:24] (in little-endian mode)
 * or Bits[7:0] (in big-endian mode) of the MAC Address4 Low Register are written.
 * For proper synchronization updates, consecutive writes to this MAC Address4 Low
 * Register must be performed after at least four clock cycles in the destination
 * clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                            
 * :--------|:-------|:-------|:----------------------------------------
 *  [15:0]  | RW     | 0xffff | ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI    
 *  [23:16] | R      | 0x0    | ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16
 *  [24]    | RW     | 0x0    | Mask Byte Control                      
 *  [25]    | RW     | 0x0    | Mask Byte Control                      
 *  [26]    | RW     | 0x0    | Mask Byte Control                      
 *  [27]    | RW     | 0x0    | Mask Byte Control                      
 *  [28]    | RW     | 0x0    | Mask Byte Control                      
 *  [29]    | RW     | 0x0    | Mask Byte Control                      
 *  [30]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA        
 *  [31]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE        
 * 
 */
/*
 * Field : addrhi
 * 
 * MAC Address4 [47:32]
 * 
 * This field contains the upper 16 bits (47:32) of the fifth 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_23_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16_CLR_MSK    0xff00ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address4 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address4 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address4 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address4 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address4 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address4 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sa
 * 
 * Source Address
 * 
 * When this bit is set, the MAC Address4[47:0] is used to compare with the SA
 * fields of the received frame.
 * 
 * When this bit is reset, the MAC Address4[47:0] is used to compare with the DA
 * fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : ae
 * 
 * Address Enable
 * 
 * When this bit is set, the address filter module uses the fifth MAC address for
 * perfect filtering.
 * 
 * When this bit is reset, the address filter module ignores the address for
 * filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR4_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR4_HIGH_s
{
    uint32_t        addrhi         : 16;  /* ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI */
    const uint32_t  reserved_23_16 :  8;  /* ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RSVD_23_16 */
    uint32_t        mbc_0          :  1;  /* Mask Byte Control */
    uint32_t        mbc_1          :  1;  /* Mask Byte Control */
    uint32_t        mbc_2          :  1;  /* Mask Byte Control */
    uint32_t        mbc_3          :  1;  /* Mask Byte Control */
    uint32_t        mbc_4          :  1;  /* Mask Byte Control */
    uint32_t        mbc_5          :  1;  /* Mask Byte Control */
    uint32_t        sa             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA */
    uint32_t        ae             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR4_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR4_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_RESET       0x0000ffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_OFST        0x60
/* The address of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR4_HIGH_OFST))

/*
 * Register : gmacgrp_mac_address4_low
 * 
 * <b> Register 25 (MAC Address4 Low Register) </b>
 * 
 * The MAC Address4 Low register holds the lower 32 bits of the fifth 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                       
 * :-------|:-------|:-----------|:-----------------------------------
 *  [31:0] | RW     | 0xffffffff | ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO
 * 
 */
/*
 * Field : addrlo
 * 
 * MAC Address4 [31:0]
 * 
 * This field contains the lower 32 bits of the fifth 6-byte MAC address. The
 * content of this field is undefined until loaded by the Application after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR4_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR4_LOW_s
{
    uint32_t  addrlo : 32;  /* ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR4_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR4_LOW_s  ALT_EMAC_GMAC_MAC_ADDR4_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_RESET       0xffffffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR4_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_OFST        0x64
/* The address of the ALT_EMAC_GMAC_MAC_ADDR4_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR4_LOW_OFST))

/*
 * Register : gmacgrp_mac_address5_high
 * 
 * <b> Register 26 (MAC Address5 High Register) </b>
 * 
 * The MAC Address5 High register holds the upper 16 bits of the sixth 6-byte MAC
 * address of the station.
 * 
 * If the MAC address registers are configured to be double-synchronized to the
 * (G)MII clock domains, then
 * 
 * the synchronization is triggered only when Bits[31:24] (in little-endian mode)
 * or Bits[7:0] (in big-endian mode) of the MAC Address5 Low Register are written.
 * For proper synchronization updates, consecutive writes to this MAC Address5 Low
 * Register must be performed after at least four clock cycles in the destination
 * clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                            
 * :--------|:-------|:-------|:----------------------------------------
 *  [15:0]  | RW     | 0xffff | ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI    
 *  [23:16] | R      | 0x0    | ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16
 *  [24]    | RW     | 0x0    | Mask Byte Control                      
 *  [25]    | RW     | 0x0    | Mask Byte Control                      
 *  [26]    | RW     | 0x0    | Mask Byte Control                      
 *  [27]    | RW     | 0x0    | Mask Byte Control                      
 *  [28]    | RW     | 0x0    | Mask Byte Control                      
 *  [29]    | RW     | 0x0    | Mask Byte Control                      
 *  [30]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA        
 *  [31]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE        
 * 
 */
/*
 * Field : addrhi
 * 
 * MAC Address5 [47:32]
 * 
 * This field contains the upper 16 bits (47:32) of the sixth 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_23_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16_CLR_MSK    0xff00ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address5 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address5 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address5 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address5 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address5 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address5 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sa
 * 
 * Source Address
 * 
 * When this bit is set, the MAC Address5[47:0] is used to compare with the SA
 * fields of the received frame.
 * 
 * When this bit is reset, the MAC Address5[47:0] is used to compare with the DA
 * fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : ae
 * 
 * Address Enable
 * 
 * When this bit is set, the address filter module uses the sixth MAC address for
 * perfect filtering. When this bit is reset, the address filter module ignores the
 * address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR5_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR5_HIGH_s
{
    uint32_t        addrhi         : 16;  /* ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI */
    const uint32_t  reserved_23_16 :  8;  /* ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RSVD_23_16 */
    uint32_t        mbc_0          :  1;  /* Mask Byte Control */
    uint32_t        mbc_1          :  1;  /* Mask Byte Control */
    uint32_t        mbc_2          :  1;  /* Mask Byte Control */
    uint32_t        mbc_3          :  1;  /* Mask Byte Control */
    uint32_t        mbc_4          :  1;  /* Mask Byte Control */
    uint32_t        mbc_5          :  1;  /* Mask Byte Control */
    uint32_t        sa             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA */
    uint32_t        ae             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR5_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR5_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_RESET       0x0000ffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_OFST        0x68
/* The address of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR5_HIGH_OFST))

/*
 * Register : gmacgrp_mac_address5_low
 * 
 * <b> Register 27 (MAC Address5 Low Register) </b>
 * 
 * The MAC Address5 Low register holds the lower 32 bits of the sixth 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                       
 * :-------|:-------|:-----------|:-----------------------------------
 *  [31:0] | RW     | 0xffffffff | ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO
 * 
 */
/*
 * Field : addrlo
 * 
 * MAC Address5 [31:0]
 * 
 * This field contains the lower 32 bits of the sixth 6-byte MAC address. The
 * content of this field is undefined until loaded by the Application after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR5_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR5_LOW_s
{
    uint32_t  addrlo : 32;  /* ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR5_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR5_LOW_s  ALT_EMAC_GMAC_MAC_ADDR5_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_RESET       0xffffffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR5_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_OFST        0x6c
/* The address of the ALT_EMAC_GMAC_MAC_ADDR5_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR5_LOW_OFST))

/*
 * Register : gmacgrp_mac_address6_high
 * 
 * <b> Register 28 (MAC Address6 High Register) </b>
 * 
 * The MAC Address6 High register holds the upper 16 bits of the seventh 6-byte MAC
 * address of the station.
 * 
 * If the MAC address registers are configured to be double-synchronized to the
 * (G)MII clock domains, then the synchronization is triggered only when
 * Bits[31:24] (in little-endian mode) or Bits[7:0] (in big-endian mode) of the MAC
 * Address6 Low Register are written. For proper synchronization updates, the
 * consecutive writes to this MAC Address6 Low Register should be performed after
 * at least four clock cycles in the destination clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                            
 * :--------|:-------|:-------|:----------------------------------------
 *  [15:0]  | RW     | 0xffff | ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI    
 *  [23:16] | R      | 0x0    | ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16
 *  [24]    | RW     | 0x0    | Mask Byte Control                      
 *  [25]    | RW     | 0x0    | Mask Byte Control                      
 *  [26]    | RW     | 0x0    | Mask Byte Control                      
 *  [27]    | RW     | 0x0    | Mask Byte Control                      
 *  [28]    | RW     | 0x0    | Mask Byte Control                      
 *  [29]    | RW     | 0x0    | Mask Byte Control                      
 *  [30]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA        
 *  [31]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE        
 * 
 */
/*
 * Field : addrhi
 * 
 * MAC Address6 [47:32]
 * 
 * This field contains the upper 16 bits (47:32) of the seventh 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_23_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16_CLR_MSK    0xff00ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address6 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address6 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address6 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address6 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address6 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address6 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sa
 * 
 * Source Address
 * 
 * When this bit is set, the MAC Address6[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is reset, the MAC Address6[47:0] is
 * used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : ae
 * 
 * Address Enable
 * 
 * When this bit is set, the address filter module uses the seventh MAC address for
 * perfect filtering.
 * 
 * When this bit is reset, the address filter module ignores the address for
 * filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR6_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR6_HIGH_s
{
    uint32_t        addrhi         : 16;  /* ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI */
    const uint32_t  reserved_23_16 :  8;  /* ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RSVD_23_16 */
    uint32_t        mbc_0          :  1;  /* Mask Byte Control */
    uint32_t        mbc_1          :  1;  /* Mask Byte Control */
    uint32_t        mbc_2          :  1;  /* Mask Byte Control */
    uint32_t        mbc_3          :  1;  /* Mask Byte Control */
    uint32_t        mbc_4          :  1;  /* Mask Byte Control */
    uint32_t        mbc_5          :  1;  /* Mask Byte Control */
    uint32_t        sa             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA */
    uint32_t        ae             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR6_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR6_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_RESET       0x0000ffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_OFST        0x70
/* The address of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR6_HIGH_OFST))

/*
 * Register : gmacgrp_mac_address6_low
 * 
 * <b> Register 29 (MAC Address6 Low Register) </b>
 * 
 * The MAC Address6 Low register holds the lower 32 bits of the seventh 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                       
 * :-------|:-------|:-----------|:-----------------------------------
 *  [31:0] | RW     | 0xffffffff | ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO
 * 
 */
/*
 * Field : addrlo
 * 
 * MAC Address6 [31:0]
 * 
 * This field contains the lower 32 bits of the seventh 6-byte MAC address. The
 * content of this field is undefined until loaded by the Application after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR6_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR6_LOW_s
{
    uint32_t  addrlo : 32;  /* ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR6_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR6_LOW_s  ALT_EMAC_GMAC_MAC_ADDR6_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_RESET       0xffffffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR6_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_OFST        0x74
/* The address of the ALT_EMAC_GMAC_MAC_ADDR6_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR6_LOW_OFST))

/*
 * Register : gmacgrp_mac_address7_high
 * 
 * <b> Register 30 (MAC Address7 High Register) </b>
 * 
 * The MAC Address7 High register holds the upper 16 bits of the eighth 6-byte MAC
 * address of the station.
 * 
 * If the MAC address registers are configured to be double-synchronized to the
 * (G)MII clock domains, then the synchronization is triggered only when
 * Bits[31:24] (in little-endian mode) or Bits[7:0] (in big-endian mode) of the MAC
 * Address7 Low Register are written. For proper synchronization updates, the
 * consecutive writes to this MAC Address7 Low Register should be performed after
 * at least four clock cycles in the destination clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                            
 * :--------|:-------|:-------|:----------------------------------------
 *  [15:0]  | RW     | 0xffff | ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI    
 *  [23:16] | R      | 0x0    | ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16
 *  [24]    | RW     | 0x0    | Mask Byte Control                      
 *  [25]    | RW     | 0x0    | Mask Byte Control                      
 *  [26]    | RW     | 0x0    | Mask Byte Control                      
 *  [27]    | RW     | 0x0    | Mask Byte Control                      
 *  [28]    | RW     | 0x0    | Mask Byte Control                      
 *  [29]    | RW     | 0x0    | Mask Byte Control                      
 *  [30]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA        
 *  [31]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE        
 * 
 */
/*
 * Field : addrhi
 * 
 * MAC Address7 [47:32]
 * 
 * This field contains the upper 16 bits (47:32) of the eighth 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_23_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16_CLR_MSK    0xff00ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address7 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address7 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address7 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address7 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address7 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address7 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sa
 * 
 * Source Address
 * 
 * When this bit is set, the MAC Address7[47:0] is used to compare with the SA
 * fields of the received frame.
 * 
 * When this bit is reset, the MAC Address7[47:0] is used to compare with the DA
 * fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : ae
 * 
 * Address Enable
 * 
 * When this bit is set, the address filter module uses the eighth MAC address for
 * perfect filtering.
 * 
 * When this bit is reset, the address filter module ignores the address for
 * filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR7_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR7_HIGH_s
{
    uint32_t        addrhi         : 16;  /* ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI */
    const uint32_t  reserved_23_16 :  8;  /* ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RSVD_23_16 */
    uint32_t        mbc_0          :  1;  /* Mask Byte Control */
    uint32_t        mbc_1          :  1;  /* Mask Byte Control */
    uint32_t        mbc_2          :  1;  /* Mask Byte Control */
    uint32_t        mbc_3          :  1;  /* Mask Byte Control */
    uint32_t        mbc_4          :  1;  /* Mask Byte Control */
    uint32_t        mbc_5          :  1;  /* Mask Byte Control */
    uint32_t        sa             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA */
    uint32_t        ae             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR7_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR7_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_RESET       0x0000ffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_OFST        0x78
/* The address of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR7_HIGH_OFST))

/*
 * Register : gmacgrp_mac_address7_low
 * 
 * <b> Register 31 (MAC Address7 Low Register) </b>
 * 
 * The MAC Address7 Low register holds the lower 32 bits of the eighth 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                       
 * :-------|:-------|:-----------|:-----------------------------------
 *  [31:0] | RW     | 0xffffffff | ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO
 * 
 */
/*
 * Field : addrlo
 * 
 * MAC Address7 [31:0]
 * 
 * This field contains the lower 32 bits of the eighth 6-byte MAC address. The
 * content of this field is undefined until loaded by the Application after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR7_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR7_LOW_s
{
    uint32_t  addrlo : 32;  /* ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR7_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR7_LOW_s  ALT_EMAC_GMAC_MAC_ADDR7_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_RESET       0xffffffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR7_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_OFST        0x7c
/* The address of the ALT_EMAC_GMAC_MAC_ADDR7_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR7_LOW_OFST))

/*
 * Register : gmacgrp_mac_address8_high
 * 
 * <b> Register 32 (MAC Address8 High Register) </b>
 * 
 * The MAC Address8 High register holds the upper 16 bits of the nineth 6-byte MAC
 * address of the station.
 * 
 * If the MAC address registers are configured to be double-synchronized to the
 * (G)MII clock domains, then the synchronization is triggered only when
 * Bits[31:24] (in little-endian mode) or Bits[7:0] (in big-endian mode) of the MAC
 * Address8 Low Register are written. For proper synchronization updates, the
 * consecutive writes to this MAC Address8 Low Register should be performed after
 * at least four clock cycles in the destination clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                            
 * :--------|:-------|:-------|:----------------------------------------
 *  [15:0]  | RW     | 0xffff | ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI    
 *  [23:16] | R      | 0x0    | ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16
 *  [24]    | RW     | 0x0    | Mask Byte Control                      
 *  [25]    | RW     | 0x0    | Mask Byte Control                      
 *  [26]    | RW     | 0x0    | Mask Byte Control                      
 *  [27]    | RW     | 0x0    | Mask Byte Control                      
 *  [28]    | RW     | 0x0    | Mask Byte Control                      
 *  [29]    | RW     | 0x0    | Mask Byte Control                      
 *  [30]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA        
 *  [31]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE        
 * 
 */
/*
 * Field : addrhi
 * 
 * MAC Address8 [47:32]
 * 
 * This field contains the upper 16 bits (47:32) of the nineth 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_23_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16_CLR_MSK    0xff00ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address8 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address8 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address8 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address8 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address8 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address8 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sa
 * 
 * Source Address
 * 
 * When this bit is set, the MAC Address8[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is reset, the MAC Address8[47:0] is
 * used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : ae
 * 
 * Address Enable
 * 
 * When this bit is set, the address filter module uses the nineth MAC address for
 * perfect filtering. When this bit is reset, the address filter module ignores the
 * address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR8_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR8_HIGH_s
{
    uint32_t        addrhi         : 16;  /* ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI */
    const uint32_t  reserved_23_16 :  8;  /* ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RSVD_23_16 */
    uint32_t        mbc_0          :  1;  /* Mask Byte Control */
    uint32_t        mbc_1          :  1;  /* Mask Byte Control */
    uint32_t        mbc_2          :  1;  /* Mask Byte Control */
    uint32_t        mbc_3          :  1;  /* Mask Byte Control */
    uint32_t        mbc_4          :  1;  /* Mask Byte Control */
    uint32_t        mbc_5          :  1;  /* Mask Byte Control */
    uint32_t        sa             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA */
    uint32_t        ae             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR8_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR8_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_RESET       0x0000ffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_OFST        0x80
/* The address of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR8_HIGH_OFST))

/*
 * Register : gmacgrp_mac_address8_low
 * 
 * <b> Register 33 (MAC Address8 Low Register) </b>
 * 
 * The MAC Address8 Low register holds the lower 32 bits of the nineth 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                       
 * :-------|:-------|:-----------|:-----------------------------------
 *  [31:0] | RW     | 0xffffffff | ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO
 * 
 */
/*
 * Field : addrlo
 * 
 * MAC Address8 [31:0]
 * 
 * This field contains the lower 32 bits of the nineth 6-byte MAC address. The
 * content of this field is undefined until loaded by the Application after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR8_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR8_LOW_s
{
    uint32_t  addrlo : 32;  /* ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR8_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR8_LOW_s  ALT_EMAC_GMAC_MAC_ADDR8_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_RESET       0xffffffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR8_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_OFST        0x84
/* The address of the ALT_EMAC_GMAC_MAC_ADDR8_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR8_LOW_OFST))

/*
 * Register : gmacgrp_mac_address9_high
 * 
 * <b> Register 34 (MAC Address9 High Register) </b>
 * 
 * The MAC Address9 High register holds the upper 16 bits of the tenth 6-byte MAC
 * address of the station.
 * 
 * If the MAC address registers are configured to be double-synchronized to the
 * (G)MII clock domains, then the synchronization is triggered only when
 * Bits[31:24] (in little-endian mode) or Bits[7:0] (in big-endian mode) of the MAC
 * Address9 Low Register are written. For proper synchronization updates, the
 * consecutive writes to this MAC Address9 Low Register should be performed after
 * at least four clock cycles in the destination clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                            
 * :--------|:-------|:-------|:----------------------------------------
 *  [15:0]  | RW     | 0xffff | ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI    
 *  [23:16] | R      | 0x0    | ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16
 *  [24]    | RW     | 0x0    | Mask Byte Control                      
 *  [25]    | RW     | 0x0    | Mask Byte Control                      
 *  [26]    | RW     | 0x0    | Mask Byte Control                      
 *  [27]    | RW     | 0x0    | Mask Byte Control                      
 *  [28]    | RW     | 0x0    | Mask Byte Control                      
 *  [29]    | RW     | 0x0    | Mask Byte Control                      
 *  [30]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA        
 *  [31]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE        
 * 
 */
/*
 * Field : addrhi
 * 
 * MAC Address9 [47:32]
 * 
 * This field contains the upper 16 bits (47:32) of the tenth 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_23_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16_CLR_MSK    0xff00ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address9 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address9 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address9 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address9 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address9 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address9 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sa
 * 
 * Source Address
 * 
 * When this bit is set, the MAC Address9[47:0] is used to compare with the SA
 * fields of the received frame.
 * 
 * When this bit is reset, the MAC Address9[47:0] is used to compare with the DA
 * fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : ae
 * 
 * Address Enable
 * 
 * When this bit is set, the address filter module uses the tenth MAC address for
 * perfect filtering. When this bit is reset, the address filter module ignores the
 * address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR9_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR9_HIGH_s
{
    uint32_t        addrhi         : 16;  /* ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI */
    const uint32_t  reserved_23_16 :  8;  /* ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RSVD_23_16 */
    uint32_t        mbc_0          :  1;  /* Mask Byte Control */
    uint32_t        mbc_1          :  1;  /* Mask Byte Control */
    uint32_t        mbc_2          :  1;  /* Mask Byte Control */
    uint32_t        mbc_3          :  1;  /* Mask Byte Control */
    uint32_t        mbc_4          :  1;  /* Mask Byte Control */
    uint32_t        mbc_5          :  1;  /* Mask Byte Control */
    uint32_t        sa             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA */
    uint32_t        ae             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR9_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR9_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_RESET       0x0000ffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_OFST        0x88
/* The address of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR9_HIGH_OFST))

/*
 * Register : gmacgrp_mac_address9_low
 * 
 * <b> Register 35 (MAC Address9 Low Register) </b>
 * 
 * The MAC Address9 Low register holds the lower 32 bits of the tenth 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                       
 * :-------|:-------|:-----------|:-----------------------------------
 *  [31:0] | RW     | 0xffffffff | ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO
 * 
 */
/*
 * Field : addrlo
 * 
 * MAC Address9 [31:0]
 * 
 * This field contains the lower 32 bits of the tenth 6-byte MAC address. The
 * content of this field is undefined until loaded by the Application after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR9_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR9_LOW_s
{
    uint32_t  addrlo : 32;  /* ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR9_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR9_LOW_s  ALT_EMAC_GMAC_MAC_ADDR9_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_RESET       0xffffffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR9_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_OFST        0x8c
/* The address of the ALT_EMAC_GMAC_MAC_ADDR9_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR9_LOW_OFST))

/*
 * Register : gmacgrp_mac_address10_high
 * 
 * <b> Register 36 (MAC Address10 High Register) </b>
 * 
 * The MAC Address10 High register holds the upper 16 bits of the 11th 6-byte MAC
 * address of the station.
 * 
 * If the MAC address registers are configured to be double-synchronized to the
 * (G)MII clock domains, then the synchronization is triggered only when
 * Bits[31:24] (in little-endian mode) or Bits[7:0] (in big-endian mode) of the MAC
 * Address10 Low Register are written. For proper synchronization updates, the
 * consecutive writes to this MAC Address10 Low Register should be performed after
 * at least four clock cycles in the destination clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                             
 * :--------|:-------|:-------|:-----------------------------------------
 *  [15:0]  | RW     | 0xffff | ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI    
 *  [23:16] | R      | 0x0    | ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16
 *  [24]    | RW     | 0x0    | Mask Byte Control                       
 *  [25]    | RW     | 0x0    | Mask Byte Control                       
 *  [26]    | RW     | 0x0    | Mask Byte Control                       
 *  [27]    | RW     | 0x0    | Mask Byte Control                       
 *  [28]    | RW     | 0x0    | Mask Byte Control                       
 *  [29]    | RW     | 0x0    | Mask Byte Control                       
 *  [30]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA        
 *  [31]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE        
 * 
 */
/*
 * Field : addrhi
 * 
 * MAC Address10 [47:32]
 * 
 * This field contains the upper 16 bits (47:32) of the 11th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_23_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16_CLR_MSK    0xff00ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address10 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address10 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address10 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address10 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address10 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address10 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sa
 * 
 * Source Address
 * 
 * When this bit is set, the MAC Address10[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is reset, the MAC Address10[47:0] is
 * used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : ae
 * 
 * Address Enable
 * 
 * When this bit is set, the address filter module uses the 11th MAC address for
 * perfect filtering. When this bit is reset, the address filter module ignores the
 * address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR10_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR10_HIGH_s
{
    uint32_t        addrhi         : 16;  /* ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI */
    const uint32_t  reserved_23_16 :  8;  /* ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RSVD_23_16 */
    uint32_t        mbc_0          :  1;  /* Mask Byte Control */
    uint32_t        mbc_1          :  1;  /* Mask Byte Control */
    uint32_t        mbc_2          :  1;  /* Mask Byte Control */
    uint32_t        mbc_3          :  1;  /* Mask Byte Control */
    uint32_t        mbc_4          :  1;  /* Mask Byte Control */
    uint32_t        mbc_5          :  1;  /* Mask Byte Control */
    uint32_t        sa             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA */
    uint32_t        ae             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR10_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR10_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_RESET       0x0000ffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_OFST        0x90
/* The address of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR10_HIGH_OFST))

/*
 * Register : gmacgrp_mac_address10_low
 * 
 * <b> Register 37 (MAC Address10 Low Register) </b>
 * 
 * The MAC Address10 Low register holds the lower 32 bits of the 11th 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                        
 * :-------|:-------|:-----------|:------------------------------------
 *  [31:0] | RW     | 0xffffffff | ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO
 * 
 */
/*
 * Field : addrlo
 * 
 * MAC Address10 [31:0]
 * 
 * This field contains the lower 32 bits of the 11th 6-byte MAC address. The
 * content of this field is undefined until loaded by the Application after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR10_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR10_LOW_s
{
    uint32_t  addrlo : 32;  /* ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR10_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR10_LOW_s  ALT_EMAC_GMAC_MAC_ADDR10_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_RESET       0xffffffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR10_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_OFST        0x94
/* The address of the ALT_EMAC_GMAC_MAC_ADDR10_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR10_LOW_OFST))

/*
 * Register : gmacgrp_mac_address11_high
 * 
 * <b> Register 38 (MAC Address11 High Register) </b>
 * 
 * The MAC Address11 High register holds the upper 16 bits of the 12th 6-byte MAC
 * address of the station.
 * 
 * If the MAC address registers are configured to be double-synchronized to the
 * (G)MII clock domains, then the synchronization is triggered only when
 * Bits[31:24] (in little-endian mode) or Bits[7:0] (in big-endian mode) of the MAC
 * Address11 Low Register are written. For proper synchronization updates, the
 * consecutive writes to this MAC Address11 Low Register should be performed after
 * at least four clock cycles in the destination clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                             
 * :--------|:-------|:-------|:-----------------------------------------
 *  [15:0]  | RW     | 0xffff | ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI    
 *  [23:16] | R      | 0x0    | ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16
 *  [24]    | RW     | 0x0    | Mask Byte Control                       
 *  [25]    | RW     | 0x0    | Mask Byte Control                       
 *  [26]    | RW     | 0x0    | Mask Byte Control                       
 *  [27]    | RW     | 0x0    | Mask Byte Control                       
 *  [28]    | RW     | 0x0    | Mask Byte Control                       
 *  [29]    | RW     | 0x0    | Mask Byte Control                       
 *  [30]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA        
 *  [31]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE        
 * 
 */
/*
 * Field : addrhi
 * 
 * MAC Address11 [47:32]
 * 
 * This field contains the upper 16 bits (47:32) of the 12th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_23_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16_CLR_MSK    0xff00ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address11 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address11 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address11 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address11 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address11 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address11 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sa
 * 
 * Source Address
 * 
 * When this bit is set, the MAC Address11[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is reset, the MAC Address11[47:0] is
 * used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : ae
 * 
 * Address Enable
 * 
 * When this bit is set, the address filter module uses the twelfth MAC address for
 * perfect filtering. When this bit is reset, the address filter module ignores the
 * address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR11_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR11_HIGH_s
{
    uint32_t        addrhi         : 16;  /* ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI */
    const uint32_t  reserved_23_16 :  8;  /* ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RSVD_23_16 */
    uint32_t        mbc_0          :  1;  /* Mask Byte Control */
    uint32_t        mbc_1          :  1;  /* Mask Byte Control */
    uint32_t        mbc_2          :  1;  /* Mask Byte Control */
    uint32_t        mbc_3          :  1;  /* Mask Byte Control */
    uint32_t        mbc_4          :  1;  /* Mask Byte Control */
    uint32_t        mbc_5          :  1;  /* Mask Byte Control */
    uint32_t        sa             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA */
    uint32_t        ae             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR11_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR11_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_RESET       0x0000ffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_OFST        0x98
/* The address of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR11_HIGH_OFST))

/*
 * Register : gmacgrp_mac_address11_low
 * 
 * <b> Register 39 (MAC Address1 Low Register) </b>
 * 
 * The MAC Address11 Low register holds the lower 32 bits of the 12th 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                        
 * :-------|:-------|:-----------|:------------------------------------
 *  [31:0] | RW     | 0xffffffff | ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO
 * 
 */
/*
 * Field : addrlo
 * 
 * MAC Address11 [31:0]
 * 
 * This field contains the lower 32 bits of the 12th 6-byte MAC address. The
 * content of this field is undefined until loaded by the Application after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR11_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR11_LOW_s
{
    uint32_t  addrlo : 32;  /* ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR11_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR11_LOW_s  ALT_EMAC_GMAC_MAC_ADDR11_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_RESET       0xffffffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR11_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_OFST        0x9c
/* The address of the ALT_EMAC_GMAC_MAC_ADDR11_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR11_LOW_OFST))

/*
 * Register : gmacgrp_mac_address12_high
 * 
 * <b> Register 40 (MAC Address12 High Register ) </b>
 * 
 * The MAC Address12 High register holds the upper 16 bits of the 13th 6-byte MAC
 * address of the station.
 * 
 * If the MAC address registers are configured to be double-synchronized to the
 * (G)MII clock domains, then the synchronization is triggered only when
 * Bits[31:24] (in little-endian mode) or Bits[7:0] (in big-endian mode) of the MAC
 * Address13 Low Register are written. For proper synchronization updates, the
 * consecutive writes to this MAC Address12 Low Register should be performed after
 * at least four clock cycles in the destination clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                             
 * :--------|:-------|:-------|:-----------------------------------------
 *  [15:0]  | RW     | 0xffff | ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI    
 *  [23:16] | R      | 0x0    | ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16
 *  [24]    | RW     | 0x0    | Mask Byte Control                       
 *  [25]    | RW     | 0x0    | Mask Byte Control                       
 *  [26]    | RW     | 0x0    | Mask Byte Control                       
 *  [27]    | RW     | 0x0    | Mask Byte Control                       
 *  [28]    | RW     | 0x0    | Mask Byte Control                       
 *  [29]    | RW     | 0x0    | Mask Byte Control                       
 *  [30]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA        
 *  [31]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE        
 * 
 */
/*
 * Field : addrhi
 * 
 * MAC Address12 [47:32]
 * 
 * This field contains the upper 16 bits (47:32) of the 13th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_23_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16_CLR_MSK    0xff00ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address12 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address12 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address12 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address12 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address12 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address12 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sa
 * 
 * Source Address
 * 
 * When this bit is set, the MAC Address12[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is reset, the MAC Address12[47:0] is
 * used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : ae
 * 
 * Address Enable
 * 
 * When this bit is set, the address filter module uses the 13th MAC address for
 * perfect filtering. When this bit is reset, the address filter module ignores the
 * address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR12_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR12_HIGH_s
{
    uint32_t        addrhi         : 16;  /* ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI */
    const uint32_t  reserved_23_16 :  8;  /* ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RSVD_23_16 */
    uint32_t        mbc_0          :  1;  /* Mask Byte Control */
    uint32_t        mbc_1          :  1;  /* Mask Byte Control */
    uint32_t        mbc_2          :  1;  /* Mask Byte Control */
    uint32_t        mbc_3          :  1;  /* Mask Byte Control */
    uint32_t        mbc_4          :  1;  /* Mask Byte Control */
    uint32_t        mbc_5          :  1;  /* Mask Byte Control */
    uint32_t        sa             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA */
    uint32_t        ae             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR12_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR12_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_RESET       0x0000ffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_OFST        0xa0
/* The address of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR12_HIGH_OFST))

/*
 * Register : gmacgrp_mac_address12_low
 * 
 * <b> Register 41 (MAC Address12 Low Register) </b>
 * 
 * The MAC Address12 Low register holds the lower 32 bits of the 13th 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                        
 * :-------|:-------|:-----------|:------------------------------------
 *  [31:0] | RW     | 0xffffffff | ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO
 * 
 */
/*
 * Field : addrlo
 * 
 * MAC Address12 [31:0]
 * 
 * This field contains the lower 32 bits of the 13th 6-byte MAC address. The
 * content of this field is undefined until loaded by the Application after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR12_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR12_LOW_s
{
    uint32_t  addrlo : 32;  /* ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR12_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR12_LOW_s  ALT_EMAC_GMAC_MAC_ADDR12_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_RESET       0xffffffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR12_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_OFST        0xa4
/* The address of the ALT_EMAC_GMAC_MAC_ADDR12_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR12_LOW_OFST))

/*
 * Register : gmacgrp_mac_address13_high
 * 
 * <b> Register 42 (MAC Address13 High Register) </b>
 * 
 * The MAC Address13 High register holds the upper 16 bits of the 14th 6-byte MAC
 * address of the station.
 * 
 * If the MAC address registers are configured to be double-synchronized to the
 * (G)MII clock domains, then the synchronization is triggered only when
 * Bits[31:24] (in little-endian mode) or Bits[7:0] (in big-endian mode) of the MAC
 * Address13 Low Register are written. For proper synchronization updates, the
 * consecutive writes to this MAC Address13 Low Register should be performed after
 * at least four clock cycles in the destination clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                             
 * :--------|:-------|:-------|:-----------------------------------------
 *  [15:0]  | RW     | 0xffff | ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI    
 *  [23:16] | R      | 0x0    | ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16
 *  [24]    | RW     | 0x0    | Mask Byte Control                       
 *  [25]    | RW     | 0x0    | Mask Byte Control                       
 *  [26]    | RW     | 0x0    | Mask Byte Control                       
 *  [27]    | RW     | 0x0    | Mask Byte Control                       
 *  [28]    | RW     | 0x0    | Mask Byte Control                       
 *  [29]    | RW     | 0x0    | Mask Byte Control                       
 *  [30]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA        
 *  [31]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE        
 * 
 */
/*
 * Field : addrhi
 * 
 * MAC Address13 [47:32]
 * 
 * This field contains the upper 16 bits (47:32) of the 14th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_23_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16_CLR_MSK    0xff00ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address13 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address13 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address13 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address13 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address13 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address13 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sa
 * 
 * Source Address
 * 
 * When this bit is set, the MAC Address13[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is reset, the MAC Address13[47:0] is
 * used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : ae
 * 
 * Address Enable
 * 
 * When this bit is set, the address filter module uses the 14th MAC address for
 * perfect filtering. When this bit is reset, the address filter module ignores the
 * address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR13_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR13_HIGH_s
{
    uint32_t        addrhi         : 16;  /* ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI */
    const uint32_t  reserved_23_16 :  8;  /* ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RSVD_23_16 */
    uint32_t        mbc_0          :  1;  /* Mask Byte Control */
    uint32_t        mbc_1          :  1;  /* Mask Byte Control */
    uint32_t        mbc_2          :  1;  /* Mask Byte Control */
    uint32_t        mbc_3          :  1;  /* Mask Byte Control */
    uint32_t        mbc_4          :  1;  /* Mask Byte Control */
    uint32_t        mbc_5          :  1;  /* Mask Byte Control */
    uint32_t        sa             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA */
    uint32_t        ae             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR13_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR13_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_RESET       0x0000ffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_OFST        0xa8
/* The address of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR13_HIGH_OFST))

/*
 * Register : gmacgrp_mac_address13_low
 * 
 * <b> Register 43 (MAC Address13 Low Register) </b>
 * 
 * The MAC Address13 Low register holds the lower 32 bits of the 14th 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                        
 * :-------|:-------|:-----------|:------------------------------------
 *  [31:0] | RW     | 0xffffffff | ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO
 * 
 */
/*
 * Field : addrlo
 * 
 * MAC Address13 [31:0]
 * 
 * This field contains the lower 32 bits of the 14th 6-byte MAC address. The
 * content of this field is undefined until loaded by the Application after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR13_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR13_LOW_s
{
    uint32_t  addrlo : 32;  /* ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR13_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR13_LOW_s  ALT_EMAC_GMAC_MAC_ADDR13_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_RESET       0xffffffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR13_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_OFST        0xac
/* The address of the ALT_EMAC_GMAC_MAC_ADDR13_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR13_LOW_OFST))

/*
 * Register : gmacgrp_mac_address14_high
 * 
 * <b> Register 44 (MAC Address14 High Register) </b>
 * 
 * The MAC Address14 High register holds the upper 16 bits of the 15th 6-byte MAC
 * address of the station.
 * 
 * If the MAC address registers are configured to be double-synchronized to the
 * (G)MII clock domains, then the synchronization is triggered only when
 * Bits[31:24] (in little-endian mode) or Bits[7:0] (in big-endian mode) of the MAC
 * Address15 Low Register are written. For proper synchronization updates, the
 * consecutive writes to this MAC Address14 Low Register should be performed after
 * at least four clock cycles in the destination clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                             
 * :--------|:-------|:-------|:-----------------------------------------
 *  [15:0]  | RW     | 0xffff | ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI    
 *  [23:16] | R      | 0x0    | ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16
 *  [24]    | RW     | 0x0    | Mask Byte Control                       
 *  [25]    | RW     | 0x0    | Mask Byte Control                       
 *  [26]    | RW     | 0x0    | Mask Byte Control                       
 *  [27]    | RW     | 0x0    | Mask Byte Control                       
 *  [28]    | RW     | 0x0    | Mask Byte Control                       
 *  [29]    | RW     | 0x0    | Mask Byte Control                       
 *  [30]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA        
 *  [31]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE        
 * 
 */
/*
 * Field : addrhi
 * 
 * MAC Address14 [47:32]
 * 
 * This field contains the upper 16 bits (47:32) of the 15th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_23_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16_CLR_MSK    0xff00ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address14 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address14 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address14 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address14 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address14 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address14 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sa
 * 
 * Source Address
 * 
 * When this bit is set, the MAC Address14[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is reset, the MAC Address14[47:0] is
 * used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : ae
 * 
 * Address Enable
 * 
 * When this bit is set, the address filter module uses the 15th MAC address for
 * perfect filtering. When this bit is reset, the address filter module ignores the
 * address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR14_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR14_HIGH_s
{
    uint32_t        addrhi         : 16;  /* ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI */
    const uint32_t  reserved_23_16 :  8;  /* ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RSVD_23_16 */
    uint32_t        mbc_0          :  1;  /* Mask Byte Control */
    uint32_t        mbc_1          :  1;  /* Mask Byte Control */
    uint32_t        mbc_2          :  1;  /* Mask Byte Control */
    uint32_t        mbc_3          :  1;  /* Mask Byte Control */
    uint32_t        mbc_4          :  1;  /* Mask Byte Control */
    uint32_t        mbc_5          :  1;  /* Mask Byte Control */
    uint32_t        sa             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA */
    uint32_t        ae             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR14_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR14_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_RESET       0x0000ffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_OFST        0xb0
/* The address of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR14_HIGH_OFST))

/*
 * Register : gmacgrp_mac_address14_low
 * 
 * <b> Register 45 (MAC Address14 Low Register) </b>
 * 
 * The MAC Address14 Low register holds the lower 32 bits of the 15th 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                        
 * :-------|:-------|:-----------|:------------------------------------
 *  [31:0] | RW     | 0xffffffff | ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO
 * 
 */
/*
 * Field : addrlo
 * 
 * MAC Address14 [31:0]
 * 
 * This field contains the lower 32 bits of the 15th 6-byte MAC address. The
 * content of this field is undefined until loaded by the Application after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR14_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR14_LOW_s
{
    uint32_t  addrlo : 32;  /* ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR14_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR14_LOW_s  ALT_EMAC_GMAC_MAC_ADDR14_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_RESET       0xffffffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR14_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_OFST        0xb4
/* The address of the ALT_EMAC_GMAC_MAC_ADDR14_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR14_LOW_OFST))

/*
 * Register : gmacgrp_mac_address15_high
 * 
 * <b> Register 46 (MAC Address15 High Register) </b>
 * 
 * The MAC Address15 High register holds the upper 16 bits of the 16th 6-byte MAC
 * address of the station.
 * 
 * If the MAC address registers are configured to be double-synchronized to the
 * (G)MII clock domains, then the synchronization is triggered only when
 * Bits[31:24] (in little-endian mode) or Bits[7:0] (in big-endian mode) of the MAC
 * Address15 Low Register are written. For proper synchronization updates, the
 * consecutive writes to this MAC Address15 Low Register should be performed after
 * at least four clock cycles in the destination clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                             
 * :--------|:-------|:-------|:-----------------------------------------
 *  [15:0]  | RW     | 0xffff | ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI    
 *  [23:16] | R      | 0x0    | ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16
 *  [24]    | RW     | 0x0    | Mask Byte Control                       
 *  [25]    | RW     | 0x0    | Mask Byte Control                       
 *  [26]    | RW     | 0x0    | Mask Byte Control                       
 *  [27]    | RW     | 0x0    | Mask Byte Control                       
 *  [28]    | RW     | 0x0    | Mask Byte Control                       
 *  [29]    | RW     | 0x0    | Mask Byte Control                       
 *  [30]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA        
 *  [31]    | RW     | 0x0    | ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE        
 * 
 */
/*
 * Field : addrhi
 * 
 * MAC Address15 [47:32] This field contains the upper 16 bits (47:32) of the 16th
 * 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : reserved_23_16
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16_CLR_MSK    0xff00ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address15 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address15 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address15 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address15 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address15 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address15 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_E_UNMSKED | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_E_MSKED   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sa
 * 
 * Source Address
 * 
 * When this bit is set, the MAC Address15[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is reset, the MAC Address15[47:0] is
 * used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : ae
 * 
 * Address Enable
 * 
 * When this bit is set, the address filter module uses the 16th MAC address for
 * perfect filtering. When this bit is reset, the address filter module ignores the
 * address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE
 * 
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR15_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR15_HIGH_s
{
    uint32_t        addrhi         : 16;  /* ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI */
    const uint32_t  reserved_23_16 :  8;  /* ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RSVD_23_16 */
    uint32_t        mbc_0          :  1;  /* Mask Byte Control */
    uint32_t        mbc_1          :  1;  /* Mask Byte Control */
    uint32_t        mbc_2          :  1;  /* Mask Byte Control */
    uint32_t        mbc_3          :  1;  /* Mask Byte Control */
    uint32_t        mbc_4          :  1;  /* Mask Byte Control */
    uint32_t        mbc_5          :  1;  /* Mask Byte Control */
    uint32_t        sa             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA */
    uint32_t        ae             :  1;  /* ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR15_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR15_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_RESET       0x0000ffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_OFST        0xb8
/* The address of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR15_HIGH_OFST))

/*
 * Register : gmacgrp_mac_address15_low
 * 
 * <b> Register 47 (MAC Address15 Low Register) </b>
 * 
 * The MAC Address15 Low register holds the lower 32 bits of the 16th 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                        
 * :-------|:-------|:-----------|:------------------------------------
 *  [31:0] | RW     | 0xffffffff | ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO
 * 
 */
/*
 * Field : addrlo
 * 
 * MAC Address15 [31:0]
 * 
 * This field contains the lower 32 bits of the 16th 6-byte MAC address. The
 * content of this field is undefined until loaded by the Application after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR15_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR15_LOW_s
{
    uint32_t  addrlo : 32;  /* ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR15_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR15_LOW_s  ALT_EMAC_GMAC_MAC_ADDR15_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_RESET       0xffffffff
/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR15_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_OFST        0xbc
/* The address of the ALT_EMAC_GMAC_MAC_ADDR15_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR15_LOW_OFST))

/*
 * Register : Register 54 (SGMII/RGMII/SMII Status Register) - gmacgrp_sgmii_rgmii_smii_control_status
 * 
 * The SGMII/RGMII/SMII Status register indicates the status signals received by
 * the RGMII interface (selected at reset) from the PHY.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description
 * :-------|:-------|:------|:------------
 *  [0]    | R      | 0x0   | Link Mode  
 *  [2:1]  | R      | 0x0   | Link Speed 
 *  [3]    | R      | 0x0   | Link Status
 *  [31:4] | ???    | 0x0   | *UNDEFINED*
 * 
 */
/*
 * Field : Link Mode - lnkmod
 * 
 * This bit indicates the current mode of operation of the link
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description
 * :--------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_E_HALFDUP | 0x0   |            
 *  ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_E_FULLDUP | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD
 * 
 */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_E_HALFDUP 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD
 * 
 */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_E_FULLDUP 0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD register field value. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD register field value. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD field value from a register. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Link Speed - lnkspeed
 * 
 * This bit indicates the current speed of the link. Bit 2 is reserved when the MAC
 * is configured for the SMII PHY interface.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                  | Value | Description
 * :------------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_E_SPEED2POINT5MHZ | 0x0   |            
 *  ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_E_SPEED25MHZ      | 0x1   |            
 *  ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_E_SPEED125MHZ     | 0x2   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED
 * 
 */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_E_SPEED2POINT5MHZ   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED
 * 
 */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_E_SPEED25MHZ        0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED
 * 
 */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_E_SPEED125MHZ       0x2

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED register field value. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_SET_MSK    0x00000006
/* The mask used to clear the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED register field value. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_CLR_MSK    0xfffffff9
/* The reset value of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED field value from a register. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_GET(value) (((value) & 0x00000006) >> 1)
/* Produces a ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_SET(value) (((value) << 1) & 0x00000006)

/*
 * Field : Link Status - lnksts
 * 
 * This bit indicates whether the link is up (1'b1) or down (1'b0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_E_LINKDOWN | 0x0   |            
 *  ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_E_LINKUP   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS
 * 
 */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_E_LINKDOWN    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS
 * 
 */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_E_LINKUP      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS register field value. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS register field value. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS field value from a register. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_SET(value) (((value) << 3) & 0x00000008)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MII_CTL_STAT.
 */
struct ALT_EMAC_GMAC_MII_CTL_STAT_s
{
    const uint32_t  lnkmod   :  1;  /* Link Mode */
    const uint32_t  lnkspeed :  2;  /* Link Speed */
    const uint32_t  lnksts   :  1;  /* Link Status */
    uint32_t                 : 28;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MII_CTL_STAT. */
typedef volatile struct ALT_EMAC_GMAC_MII_CTL_STAT_s  ALT_EMAC_GMAC_MII_CTL_STAT_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MII_CTL_STAT register. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_MII_CTL_STAT register from the beginning of the component. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_OFST        0xd8
/* The address of the ALT_EMAC_GMAC_MII_CTL_STAT register. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MII_CTL_STAT_OFST))

/*
 * Register : gmacgrp_wdog_timeout
 * 
 * <b> Register 55 (Watchdog Timeout Register) </b>
 * 
 * This register controls the watchdog timeout for received frames.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                      
 * :--------|:-------|:------|:----------------------------------
 *  [13:0]  | RW     | 0x0   | ALT_EMAC_GMAC_WDOG_TMO_WTO       
 *  [15:14] | R      | 0x0   | ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14
 *  [16]    | RW     | 0x0   | ALT_EMAC_GMAC_WDOG_TMO_PWE       
 *  [31:17] | R      | 0x0   | ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17
 * 
 */
/*
 * Field : wto
 * 
 * Watchdog Timeout
 * 
 * When Bit 16 (PWE) is set and Bit 23 (WD) of Register 0 (MAC Configuration
 * Register) is reset, this field is used as watchdog timeout for a received frame.
 * If the length of a received frame exceeds the value of this field, such frame is
 * terminated and declared as an error frame.
 * 
 * Note: When Bit 16 (PWE) is set, the value in this field should be more than
 * 1,522 (0x05F2). Otherwise, the IEEE Std 802.3-specified valid tagged frames are
 * declared as error frames and are dropped.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_WDOG_TMO_WTO register field. */
#define ALT_EMAC_GMAC_WDOG_TMO_WTO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_WDOG_TMO_WTO register field. */
#define ALT_EMAC_GMAC_WDOG_TMO_WTO_MSB        13
/* The width in bits of the ALT_EMAC_GMAC_WDOG_TMO_WTO register field. */
#define ALT_EMAC_GMAC_WDOG_TMO_WTO_WIDTH      14
/* The mask used to set the ALT_EMAC_GMAC_WDOG_TMO_WTO register field value. */
#define ALT_EMAC_GMAC_WDOG_TMO_WTO_SET_MSK    0x00003fff
/* The mask used to clear the ALT_EMAC_GMAC_WDOG_TMO_WTO register field value. */
#define ALT_EMAC_GMAC_WDOG_TMO_WTO_CLR_MSK    0xffffc000
/* The reset value of the ALT_EMAC_GMAC_WDOG_TMO_WTO register field. */
#define ALT_EMAC_GMAC_WDOG_TMO_WTO_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_WDOG_TMO_WTO field value from a register. */
#define ALT_EMAC_GMAC_WDOG_TMO_WTO_GET(value) (((value) & 0x00003fff) >> 0)
/* Produces a ALT_EMAC_GMAC_WDOG_TMO_WTO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_WDOG_TMO_WTO_SET(value) (((value) << 0) & 0x00003fff)

/*
 * Field : reserved_15_14
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14 register field. */
#define ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14 register field. */
#define ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14 register field. */
#define ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14 register field value. */
#define ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14_SET_MSK    0x0000c000
/* The mask used to clear the ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14 register field value. */
#define ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14_CLR_MSK    0xffff3fff
/* The reset value of the ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14 register field. */
#define ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14 field value from a register. */
#define ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14_GET(value) (((value) & 0x0000c000) >> 14)
/* Produces a ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14_SET(value) (((value) << 14) & 0x0000c000)

/*
 * Field : pwe
 * 
 * Programmable Watchdog Enable
 * 
 * When this bit is set and Bit 23 (WD) of Register 0 (MAC Configuration Register)
 * is reset, the WTO field (Bits[13:0]) is used as watchdog timeout for a received
 * frame.
 * 
 * When this bit is cleared, the watchdog timeout for a received frame is
 * controlled by the setting of Bit 23 (WD) and Bit 20 (JE) in Register 0 (MAC
 * Configuration Register).
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_WDOG_TMO_PWE register field. */
#define ALT_EMAC_GMAC_WDOG_TMO_PWE_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_WDOG_TMO_PWE register field. */
#define ALT_EMAC_GMAC_WDOG_TMO_PWE_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_WDOG_TMO_PWE register field. */
#define ALT_EMAC_GMAC_WDOG_TMO_PWE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_WDOG_TMO_PWE register field value. */
#define ALT_EMAC_GMAC_WDOG_TMO_PWE_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_WDOG_TMO_PWE register field value. */
#define ALT_EMAC_GMAC_WDOG_TMO_PWE_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_WDOG_TMO_PWE register field. */
#define ALT_EMAC_GMAC_WDOG_TMO_PWE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_WDOG_TMO_PWE field value from a register. */
#define ALT_EMAC_GMAC_WDOG_TMO_PWE_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_WDOG_TMO_PWE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_WDOG_TMO_PWE_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : reserved_31_17
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17 register field. */
#define ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17 register field. */
#define ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17 register field. */
#define ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17_WIDTH      15
/* The mask used to set the ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17 register field value. */
#define ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17_SET_MSK    0xfffe0000
/* The mask used to clear the ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17 register field value. */
#define ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17_CLR_MSK    0x0001ffff
/* The reset value of the ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17 register field. */
#define ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17 field value from a register. */
#define ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17_GET(value) (((value) & 0xfffe0000) >> 17)
/* Produces a ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17_SET(value) (((value) << 17) & 0xfffe0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_WDOG_TMO.
 */
struct ALT_EMAC_GMAC_WDOG_TMO_s
{
    uint32_t        wto            : 14;  /* ALT_EMAC_GMAC_WDOG_TMO_WTO */
    const uint32_t  reserved_15_14 :  2;  /* ALT_EMAC_GMAC_WDOG_TMO_RSVD_15_14 */
    uint32_t        pwe            :  1;  /* ALT_EMAC_GMAC_WDOG_TMO_PWE */
    const uint32_t  reserved_31_17 : 15;  /* ALT_EMAC_GMAC_WDOG_TMO_RSVD_31_17 */
};

/* The typedef declaration for register ALT_EMAC_GMAC_WDOG_TMO. */
typedef volatile struct ALT_EMAC_GMAC_WDOG_TMO_s  ALT_EMAC_GMAC_WDOG_TMO_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_WDOG_TMO register. */
#define ALT_EMAC_GMAC_WDOG_TMO_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_WDOG_TMO register from the beginning of the component. */
#define ALT_EMAC_GMAC_WDOG_TMO_OFST        0xdc
/* The address of the ALT_EMAC_GMAC_WDOG_TMO register. */
#define ALT_EMAC_GMAC_WDOG_TMO_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_WDOG_TMO_OFST))

/*
 * Register : gmacgrp_genpio
 * 
 * <b> Register 56 (General Purpose IO Register) </b>
 * 
 * This register provides the control to drive up to 4 bits of output ports (GPO)
 * and the status of up to 4 input
 * 
 * ports (GPIS). It also provides the control to generate interrupts on events
 * occurring on the gpi_i pin.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                   
 * :--------|:-------|:------|:-------------------------------
 *  [0]     | R      | 0x0   | ALT_EMAC_GMAC_GENPIO_GPIS     
 *  [7:1]   | R      | 0x0   | ALT_EMAC_GMAC_GENPIO_RSVD_7_X 
 *  [8]     | RW     | 0x0   | ALT_EMAC_GMAC_GENPIO_GPO      
 *  [15:9]  | R      | 0x0   | ALT_EMAC_GMAC_GENPIO_RSVD_15_X
 *  [16]    | RW     | 0x0   | ALT_EMAC_GMAC_GENPIO_GPIE     
 *  [23:17] | R      | 0x0   | ALT_EMAC_GMAC_GENPIO_RSVD_23_X
 *  [24]    | RW     | 0x0   | ALT_EMAC_GMAC_GENPIO_GPIT     
 *  [31:25] | R      | 0x0   | ALT_EMAC_GMAC_GENPIO_RSVD_31_X
 * 
 */
/*
 * Field : gpis
 * 
 * General Purpose Input Status
 * 
 * This field gives the status of the signals connected to the gpi_i input ports.
 * This field is of the following types based on the setting of the corresponding
 * GPIT field of this register:
 * 
 * * Latched-low (LL): This field is cleared when the corresponding gpi_i input
 *   becomes low. This field remains low until the host reads this field. After
 *   this, this field reflects the current value of the gpi_i input.
 * 
 * * Latched-high (LH): This field is set when the corresponding gpi_i input
 *   becomes high. This field remains high until the host reads this field. After
 *   this, this field reflects the current value of the gpi_i input.
 * 
 * <br>
 * 
 * The number of bits available in this field depend on the GP Input Signal Width
 * option. Other bits are not used (reserved and always reset).
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GENPIO_GPIS register field. */
#define ALT_EMAC_GMAC_GENPIO_GPIS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GENPIO_GPIS register field. */
#define ALT_EMAC_GMAC_GENPIO_GPIS_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_GENPIO_GPIS register field. */
#define ALT_EMAC_GMAC_GENPIO_GPIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_GENPIO_GPIS register field value. */
#define ALT_EMAC_GMAC_GENPIO_GPIS_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_GENPIO_GPIS register field value. */
#define ALT_EMAC_GMAC_GENPIO_GPIS_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_GENPIO_GPIS register field. */
#define ALT_EMAC_GMAC_GENPIO_GPIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GENPIO_GPIS field value from a register. */
#define ALT_EMAC_GMAC_GENPIO_GPIS_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_GENPIO_GPIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GENPIO_GPIS_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : reserved_7_x
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GENPIO_RSVD_7_X register field. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_7_X_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GENPIO_RSVD_7_X register field. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_7_X_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_GENPIO_RSVD_7_X register field. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_7_X_WIDTH      7
/* The mask used to set the ALT_EMAC_GMAC_GENPIO_RSVD_7_X register field value. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_7_X_SET_MSK    0x000000fe
/* The mask used to clear the ALT_EMAC_GMAC_GENPIO_RSVD_7_X register field value. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_7_X_CLR_MSK    0xffffff01
/* The reset value of the ALT_EMAC_GMAC_GENPIO_RSVD_7_X register field. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_7_X_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GENPIO_RSVD_7_X field value from a register. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_7_X_GET(value) (((value) & 0x000000fe) >> 1)
/* Produces a ALT_EMAC_GMAC_GENPIO_RSVD_7_X register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_7_X_SET(value) (((value) << 1) & 0x000000fe)

/*
 * Field : gpo
 * 
 * General Purpose Output
 * 
 * When this bit is set, it directly drives the gpo_o output ports. When this bit
 * is reset, it does not directly drive the gpo_o output ports.
 * 
 * The number of bits available in this field depend on the GP Output Signal Width
 * option. Other bits are not used (reserved and always reset).
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GENPIO_GPO register field. */
#define ALT_EMAC_GMAC_GENPIO_GPO_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GENPIO_GPO register field. */
#define ALT_EMAC_GMAC_GENPIO_GPO_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_GENPIO_GPO register field. */
#define ALT_EMAC_GMAC_GENPIO_GPO_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_GENPIO_GPO register field value. */
#define ALT_EMAC_GMAC_GENPIO_GPO_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_GENPIO_GPO register field value. */
#define ALT_EMAC_GMAC_GENPIO_GPO_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_GENPIO_GPO register field. */
#define ALT_EMAC_GMAC_GENPIO_GPO_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GENPIO_GPO field value from a register. */
#define ALT_EMAC_GMAC_GENPIO_GPO_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_GENPIO_GPO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GENPIO_GPO_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : reserved_15_x
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GENPIO_RSVD_15_X register field. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_15_X_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GENPIO_RSVD_15_X register field. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_15_X_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_GENPIO_RSVD_15_X register field. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_15_X_WIDTH      7
/* The mask used to set the ALT_EMAC_GMAC_GENPIO_RSVD_15_X register field value. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_15_X_SET_MSK    0x0000fe00
/* The mask used to clear the ALT_EMAC_GMAC_GENPIO_RSVD_15_X register field value. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_15_X_CLR_MSK    0xffff01ff
/* The reset value of the ALT_EMAC_GMAC_GENPIO_RSVD_15_X register field. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_15_X_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GENPIO_RSVD_15_X field value from a register. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_15_X_GET(value) (((value) & 0x0000fe00) >> 9)
/* Produces a ALT_EMAC_GMAC_GENPIO_RSVD_15_X register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_15_X_SET(value) (((value) << 9) & 0x0000fe00)

/*
 * Field : gpie
 * 
 * GPI Interrupt Enable
 * 
 * When this bit is set and the programmed event (LL or LH) occurs on the
 * corresponding GPIS bit, Bit 11 (GPIIS) of Register 14 (Interrupt Status
 * Register) is set. Accordingly, the interrupt is generated on the mci_intr_o or
 * sbd_intr_o. The GPIIS bit is cleared when the host reads the Bits[7:0] of this
 * register.
 * 
 * When reset, Bit 11 (GPIIS) of Register 14 (Interrupt Status Register) is not set
 * when any event occurs on the corresponding GPIS bits.
 * 
 * The number of bits available in this field depend on the GP Input Signal Width
 * option. Other bits are not used (reserved and always reset).
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GENPIO_GPIE register field. */
#define ALT_EMAC_GMAC_GENPIO_GPIE_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GENPIO_GPIE register field. */
#define ALT_EMAC_GMAC_GENPIO_GPIE_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_GENPIO_GPIE register field. */
#define ALT_EMAC_GMAC_GENPIO_GPIE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_GENPIO_GPIE register field value. */
#define ALT_EMAC_GMAC_GENPIO_GPIE_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_GENPIO_GPIE register field value. */
#define ALT_EMAC_GMAC_GENPIO_GPIE_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_GENPIO_GPIE register field. */
#define ALT_EMAC_GMAC_GENPIO_GPIE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GENPIO_GPIE field value from a register. */
#define ALT_EMAC_GMAC_GENPIO_GPIE_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_GENPIO_GPIE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GENPIO_GPIE_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : reserved_23_x
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GENPIO_RSVD_23_X register field. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_23_X_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GENPIO_RSVD_23_X register field. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_23_X_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_GENPIO_RSVD_23_X register field. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_23_X_WIDTH      7
/* The mask used to set the ALT_EMAC_GMAC_GENPIO_RSVD_23_X register field value. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_23_X_SET_MSK    0x00fe0000
/* The mask used to clear the ALT_EMAC_GMAC_GENPIO_RSVD_23_X register field value. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_23_X_CLR_MSK    0xff01ffff
/* The reset value of the ALT_EMAC_GMAC_GENPIO_RSVD_23_X register field. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_23_X_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GENPIO_RSVD_23_X field value from a register. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_23_X_GET(value) (((value) & 0x00fe0000) >> 17)
/* Produces a ALT_EMAC_GMAC_GENPIO_RSVD_23_X register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_23_X_SET(value) (((value) << 17) & 0x00fe0000)

/*
 * Field : gpit
 * 
 * GPI Type
 * 
 * When set, this bit indicates that the corresponding GPIS is of latched-low (LL)
 * type. When reset, this bit indicates that the corresponding GPIS is of latched-
 * high (LH) type.
 * 
 * The number of bits available in this field depend on the GP Input Signal Width
 * option. Other bits are not used (reserved and always reset).
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GENPIO_GPIT register field. */
#define ALT_EMAC_GMAC_GENPIO_GPIT_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GENPIO_GPIT register field. */
#define ALT_EMAC_GMAC_GENPIO_GPIT_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_GENPIO_GPIT register field. */
#define ALT_EMAC_GMAC_GENPIO_GPIT_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_GENPIO_GPIT register field value. */
#define ALT_EMAC_GMAC_GENPIO_GPIT_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_GENPIO_GPIT register field value. */
#define ALT_EMAC_GMAC_GENPIO_GPIT_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_GENPIO_GPIT register field. */
#define ALT_EMAC_GMAC_GENPIO_GPIT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GENPIO_GPIT field value from a register. */
#define ALT_EMAC_GMAC_GENPIO_GPIT_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_GENPIO_GPIT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GENPIO_GPIT_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : reserved_31_x
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GENPIO_RSVD_31_X register field. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_31_X_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GENPIO_RSVD_31_X register field. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_31_X_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_GENPIO_RSVD_31_X register field. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_31_X_WIDTH      7
/* The mask used to set the ALT_EMAC_GMAC_GENPIO_RSVD_31_X register field value. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_31_X_SET_MSK    0xfe000000
/* The mask used to clear the ALT_EMAC_GMAC_GENPIO_RSVD_31_X register field value. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_31_X_CLR_MSK    0x01ffffff
/* The reset value of the ALT_EMAC_GMAC_GENPIO_RSVD_31_X register field. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_31_X_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GENPIO_RSVD_31_X field value from a register. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_31_X_GET(value) (((value) & 0xfe000000) >> 25)
/* Produces a ALT_EMAC_GMAC_GENPIO_RSVD_31_X register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GENPIO_RSVD_31_X_SET(value) (((value) << 25) & 0xfe000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_GENPIO.
 */
struct ALT_EMAC_GMAC_GENPIO_s
{
    const uint32_t  gpis          :  1;  /* ALT_EMAC_GMAC_GENPIO_GPIS */
    const uint32_t  reserved_7_x  :  7;  /* ALT_EMAC_GMAC_GENPIO_RSVD_7_X */
    uint32_t        gpo           :  1;  /* ALT_EMAC_GMAC_GENPIO_GPO */
    const uint32_t  reserved_15_x :  7;  /* ALT_EMAC_GMAC_GENPIO_RSVD_15_X */
    uint32_t        gpie          :  1;  /* ALT_EMAC_GMAC_GENPIO_GPIE */
    const uint32_t  reserved_23_x :  7;  /* ALT_EMAC_GMAC_GENPIO_RSVD_23_X */
    uint32_t        gpit          :  1;  /* ALT_EMAC_GMAC_GENPIO_GPIT */
    const uint32_t  reserved_31_x :  7;  /* ALT_EMAC_GMAC_GENPIO_RSVD_31_X */
};

/* The typedef declaration for register ALT_EMAC_GMAC_GENPIO. */
typedef volatile struct ALT_EMAC_GMAC_GENPIO_s  ALT_EMAC_GMAC_GENPIO_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_GENPIO register. */
#define ALT_EMAC_GMAC_GENPIO_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_GENPIO register from the beginning of the component. */
#define ALT_EMAC_GMAC_GENPIO_OFST        0xe0
/* The address of the ALT_EMAC_GMAC_GENPIO register. */
#define ALT_EMAC_GMAC_GENPIO_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_GENPIO_OFST))

/*
 * Register : gmacgrp_mmc_control
 * 
 * <b> Register 64 (MMC Control Register) </b>
 * 
 * The MMC Control register establishes the operating mode of the management
 * counters.
 * 
 * Note:
 * 
 * The bit 0 (Counters Reset) has higher priority than bit 4 (Counter Preset).
 * Therefore, when the Software tries to set both bits in the same write cycle, all
 * counters are cleared and the bit 4 is not set.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                     
 * :-------|:-------|:------|:---------------------------------
 *  [0]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_CTL_CNTRST    
 *  [1]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO 
 *  [2]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_CTL_RSTONRD   
 *  [3]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ  
 *  [4]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_CTL_CNTPRST   
 *  [5]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL
 *  [7:6]  | R      | 0x0   | ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6  
 *  [8]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_CTL_UCDBC     
 *  [31:9] | R      | 0x0   | ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9 
 * 
 */
/*
 * Field : cntrst
 * 
 * Counters Reset
 * 
 * When this bit is set, all counters are reset. This bit is cleared automatically
 * after one clock cycle.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description
 * :------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_CTL_CNTRST_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_CTL_CNTRST_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTRST
 * 
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTRST
 * 
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTRST register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTRST register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_MMC_CTL_CNTRST register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_CTL_CNTRST register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_MMC_CTL_CNTRST register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_MMC_CTL_CNTRST register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_CTL_CNTRST field value from a register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_MMC_CTL_CNTRST register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : cntstopro
 * 
 * Counters Stop Rollover
 * 
 * When this bit is set, after reaching maximum value, the counter does not roll
 * over to zero.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO
 * 
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO
 * 
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO field value from a register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : rstonrd
 * 
 * Reset on Read
 * 
 * When this bit is set, the MMC counters are reset to zero after Read (self-
 * clearing after reset). The counters are cleared when the least significant byte
 * lane (bits[7:0]) is read.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_CTL_RSTONRD_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_CTL_RSTONRD_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_RSTONRD
 * 
 */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_RSTONRD
 * 
 */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_CTL_RSTONRD register field. */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_CTL_RSTONRD register field. */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_MMC_CTL_RSTONRD register field. */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_CTL_RSTONRD register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_MMC_CTL_RSTONRD register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_MMC_CTL_RSTONRD register field. */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_CTL_RSTONRD field value from a register. */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_MMC_CTL_RSTONRD register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : cntfreez
 * 
 * MMC Counter Freeze
 * 
 * When this bit is set, it freezes all MMC counters to their current value. Until
 * this bit is reset to 0, no MMC counter is updated because of any transmitted or
 * received frame. If any MMC counter is read with the Reset on Read bit set, then
 * that counter is also cleared in this mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description
 * :--------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ
 * 
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ
 * 
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ field value from a register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : cntprst
 * 
 * Counters Preset
 * 
 * When this bit is set, all counters are initialized or preset to almost full or
 * almost half according to bit 5. This bit is cleared automatically after 1 clock
 * cycle. This bit, along with bit 5, is useful for debugging and testing the
 * assertion of interrupts because of MMC counter becoming half-full or full.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_CTL_CNTPRST_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_CTL_CNTPRST_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTPRST
 * 
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTPRST
 * 
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTPRST register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTPRST register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_MMC_CTL_CNTPRST register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_CTL_CNTPRST register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_MMC_CTL_CNTPRST register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_MMC_CTL_CNTPRST register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_CTL_CNTPRST field value from a register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_MMC_CTL_CNTPRST register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : cntprstlvl
 * 
 * Full-Half Preset
 * 
 * When low and bit 4 is set, all MMC counters get preset to almost-half value. All
 * octet counters get preset to 0x7FFF_F800 (half - 2KBytes) and all frame-counters
 * gets preset to 0x7FFF_FFF0 (half - 16).
 * 
 * When this bit is high and bit 4 is set, all MMC counters get preset to almost-
 * full value. All octet counters get preset to 0xFFFF_F800 (full - 2KBytes) and
 * all frame-counters gets preset to 0xFFFF_FFF0 (full - 16).
 * 
 * For 16-bit counters, the almost-half preset values are 0x7800 and 0x7FF0 for the
 * respective octet and frame counters. Similarly, the almost-full preset values
 * for the 16-bit counters are 0xF800 and 0xFFF0.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_E_ALMOSTHALF | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_E_ALMOSTFULL | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL
 * 
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_E_ALMOSTHALF   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL
 * 
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_E_ALMOSTFULL   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_SET_MSK    0x00000020
/* The mask used to clear the ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_CLR_MSK    0xffffffdf
/* The reset value of the ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL field value from a register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : reserved_7_6
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6 register field. */
#define ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6 register field. */
#define ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6 register field. */
#define ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6 register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6_SET_MSK    0x000000c0
/* The mask used to clear the ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6 register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6_CLR_MSK    0xffffff3f
/* The reset value of the ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6 register field. */
#define ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6 field value from a register. */
#define ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6_GET(value) (((value) & 0x000000c0) >> 6)
/* Produces a ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6_SET(value) (((value) << 6) & 0x000000c0)

/*
 * Field : ucdbc
 * 
 * Update MMC Counters for Dropped Broadcast Frames
 * 
 * When set, this bit enables MAC to update all the related MMC Counters for
 * Broadcast frames dropped due to setting of DBF bit (Disable Broadcast Frames) of
 * MAC Filter Register at offset 0x0004.
 * 
 * When reset, MMC Counters are not updated for dropped Broadcast frames.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_CTL_UCDBC register field. */
#define ALT_EMAC_GMAC_MMC_CTL_UCDBC_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_CTL_UCDBC register field. */
#define ALT_EMAC_GMAC_MMC_CTL_UCDBC_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_MMC_CTL_UCDBC register field. */
#define ALT_EMAC_GMAC_MMC_CTL_UCDBC_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_CTL_UCDBC register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_UCDBC_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_MMC_CTL_UCDBC register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_UCDBC_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_MMC_CTL_UCDBC register field. */
#define ALT_EMAC_GMAC_MMC_CTL_UCDBC_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_CTL_UCDBC field value from a register. */
#define ALT_EMAC_GMAC_MMC_CTL_UCDBC_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_MMC_CTL_UCDBC register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_CTL_UCDBC_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : reserved_31_9
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9 register field. */
#define ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9 register field. */
#define ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9 register field. */
#define ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9_WIDTH      23
/* The mask used to set the ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9 register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9_SET_MSK    0xfffffe00
/* The mask used to clear the ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9 register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9_CLR_MSK    0x000001ff
/* The reset value of the ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9 register field. */
#define ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9 field value from a register. */
#define ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9_GET(value) (((value) & 0xfffffe00) >> 9)
/* Produces a ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9_SET(value) (((value) << 9) & 0xfffffe00)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MMC_CTL.
 */
struct ALT_EMAC_GMAC_MMC_CTL_s
{
    uint32_t        cntrst        :  1;  /* ALT_EMAC_GMAC_MMC_CTL_CNTRST */
    uint32_t        cntstopro     :  1;  /* ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO */
    uint32_t        rstonrd       :  1;  /* ALT_EMAC_GMAC_MMC_CTL_RSTONRD */
    uint32_t        cntfreez      :  1;  /* ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ */
    uint32_t        cntprst       :  1;  /* ALT_EMAC_GMAC_MMC_CTL_CNTPRST */
    uint32_t        cntprstlvl    :  1;  /* ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL */
    const uint32_t  reserved_7_6  :  2;  /* ALT_EMAC_GMAC_MMC_CTL_RSVD_7_6 */
    uint32_t        ucdbc         :  1;  /* ALT_EMAC_GMAC_MMC_CTL_UCDBC */
    const uint32_t  reserved_31_9 : 23;  /* ALT_EMAC_GMAC_MMC_CTL_RSVD_31_9 */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MMC_CTL. */
typedef volatile struct ALT_EMAC_GMAC_MMC_CTL_s  ALT_EMAC_GMAC_MMC_CTL_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MMC_CTL register. */
#define ALT_EMAC_GMAC_MMC_CTL_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_MMC_CTL register from the beginning of the component. */
#define ALT_EMAC_GMAC_MMC_CTL_OFST        0x100
/* The address of the ALT_EMAC_GMAC_MMC_CTL register. */
#define ALT_EMAC_GMAC_MMC_CTL_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MMC_CTL_OFST))

/*
 * Register : gmacgrp_mmc_receive_interrupt
 * 
 * <b> Register 65 (MMC Receive Interrupt Register) </b>
 * 
 * The MMC Receive Interrupt register maintains the interrupts that are generated
 * when the following happens:
 * 
 * * Receive statistic counters reach half of their maximum values (0x8000_0000 for
 *   32-bit counter and 0x8000 for 16-bit counter).
 * 
 * * Receive statistic counters cross their maximum values (0xFFFF_FFFF for 32-bit
 *   counter and 0xFFFF for 16-bit counter).
 * 
 * When the Counter Stop Rollover is set, then interrupts are set but the counter
 * remains at all-ones. The MMC Receive Interrupt register is a 32-bit wide
 * register. An interrupt bit is cleared when the respective MMC counter that
 * caused the interrupt is read. The least significant byte lane (Bits[7:0]) of the
 * respective counter must be read in order to clear the interrupt bit.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                              
 * :--------|:-------|:------|:------------------------------------------
 *  [0]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS         
 *  [1]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS         
 *  [2]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS          
 *  [3]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS          
 *  [4]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS          
 *  [5]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS        
 *  [6]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS       
 *  [7]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS         
 *  [8]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS        
 *  [9]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS       
 *  [10]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS       
 *  [11]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS      
 *  [12]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS  
 *  [13]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS 
 *  [14]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS 
 *  [15]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS
 *  [16]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS
 *  [17]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS          
 *  [18]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS        
 *  [19]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS       
 *  [20]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS         
 *  [21]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS          
 *  [22]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS       
 *  [23]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS         
 *  [24]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS       
 *  [25]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS          
 *  [31:26] | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26      
 * 
 */
/*
 * Field : rxgbfrmis
 * 
 * MMC Receive Good Bad Frame Counter Interrupt Status
 * 
 * This bit is set when the rxframecount_bg counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description
 * :----------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_E_ALMOSTHALF | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_E_ALMOSTFULL | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_E_ALMOSTHALF   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_E_ALMOSTFULL   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : rxgboctis
 * 
 * MMC Receive Good Bad Octet Counter Interrupt Status
 * 
 * This bit is set when the rxoctetcount_bg counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : rxgoctis
 * 
 * MMC Receive Good Octet Counter Interrupt Status.
 * 
 * This bit is set when the rxoctetcount_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : rxbcgfis
 * 
 * MMC Receive Broadcast Good Frame Counter Interrupt Status.
 * 
 * This bit is set when the rxbroadcastframes_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : rxmcgfis
 * 
 * MMC Receive Multicast Good Frame Counter Interrupt Status
 * 
 * This bit is set when the rxmulticastframes_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : rxcrcerfis
 * 
 * MMC Receive CRC Error Frame Counter Interrupt Status
 * 
 * This bit is set when the rxcrcerror counter reaches half of the maximum value or
 * the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_SET_MSK    0x00000020
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_CLR_MSK    0xffffffdf
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : rxalgnerfis
 * 
 * MMC Receive Alignment Error Frame Counter Interrupt Status
 * 
 * This bit is set when the rxalignmenterror counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description
 * :-------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_MSB        6
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_SET_MSK    0x00000040
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_CLR_MSK    0xffffffbf
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : rxruntfis
 * 
 * MMC Receive Runt Frame Counter Interrupt Status
 * 
 * This bit is set when the rxrunterror counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_SET_MSK    0x00000080
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_CLR_MSK    0xffffff7f
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : rxjaberfis
 * 
 * MMC Receive Jabber Error Frame Counter Interrupt Status
 * 
 * This bit is set when the rxjabbererror counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : rxusizegfis
 * 
 * MMC Receive Undersize Good Frame Counter Interrupt Status
 * 
 * This bit is set when the rxundersize_g counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description
 * :-------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : rxosizegfis
 * 
 * MMC Receive Oversize Good Frame Counter Interrupt Status
 * 
 * This bit is set when the rxoversize_g counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description
 * :-------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_SET_MSK    0x00000400
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_CLR_MSK    0xfffffbff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : rx64octgbfis
 * 
 * MMC Receive 64 Octet Good Bad Frame Counter Interrupt Status
 * 
 * This bit is set when the rx64octets_gb counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description
 * :--------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_MSB        11
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_SET_MSK    0x00000800
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : rx65t127octgbfis
 * 
 * MMC Receive 65 to 127 Octet Good Bad Frame Counter Interrupt Status
 * 
 * This is set when the rx65to127octets_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description
 * :------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_MSB        12
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_SET_MSK    0x00001000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_CLR_MSK    0xffffefff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : rx128t255octgbfis
 * 
 * MMC Receive 128 to 255 Octet Good Bad Frame Counter Interrupt Status
 * 
 * This bit is set when the rx128to255octets_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description
 * :-------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_MSB        13
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_SET_MSK    0x00002000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_CLR_MSK    0xffffdfff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : rx256t511octgbfis
 * 
 * MMC Receive 256 to 511 Octet Good Bad Frame Counter Interrupt Status
 * 
 * This bit is set when the rx256to511octets_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description
 * :-------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_MSB        14
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_SET_MSK    0x00004000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_CLR_MSK    0xffffbfff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : rx512t1023octgbfis
 * 
 * MMC Receive 512 to 1023 Octet Good Bad Frame Counter Interrupt Status
 * 
 * This bit is set when the rx512to1023octets_gb counter reaches half of the
 * maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description
 * :--------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_SET_MSK    0x00008000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_CLR_MSK    0xffff7fff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : rx1024tmaxoctgbfis
 * 
 * MMC Receive 1024 to Maximum Octet Good Bad Frame Counter Interrupt Status
 * 
 * This bit is set when the rx1024tomaxoctets_gb counter reaches half of the
 * maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description
 * :--------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : rxucgfis
 * 
 * MMC Receive Unicast Good Frame Counter Interrupt Status
 * 
 * This bit is set when the rxunicastframes_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_MSB        17
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_SET_MSK    0x00020000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_CLR_MSK    0xfffdffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : rxlenerfis
 * 
 * MMC Receive Length Error Frame Counter Interrupt Status
 * 
 * This bit is set when the rxlengtherror counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_MSB        18
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_SET_MSK    0x00040000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_CLR_MSK    0xfffbffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : rxorangefis
 * 
 * MMC Receive Out Of Range Error Frame Counter Interrupt Status
 * 
 * This bit is set when the rxoutofrangetype counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description
 * :-------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_MSB        19
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_SET_MSK    0x00080000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : rxpausfis
 * 
 * MMC Receive Pause Frame Counter Interrupt Status
 * 
 * This bit is set when the rxpauseframe counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_MSB        20
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_SET_MSK    0x00100000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_CLR_MSK    0xffefffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : rxfovfis
 * 
 * MMC Receive FIFO Overflow Frame Counter Interrupt Status
 * 
 * This bit is set when the rxfifooverflow counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_MSB        21
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_SET_MSK    0x00200000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_CLR_MSK    0xffdfffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : rxvlangbfis
 * 
 * MMC Receive VLAN Good Bad Frame Counter Interrupt Status
 * 
 * This bit is set when the rxvlanframes_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description
 * :-------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_MSB        22
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_SET_MSK    0x00400000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_CLR_MSK    0xffbfffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : rxwdogfis
 * 
 * MMC Receive Watchdog Error Frame Counter Interrupt Status
 * 
 * This bit is set when the rxwatchdogerror counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_SET_MSK    0x00800000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_CLR_MSK    0xff7fffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : rxrcverrfis
 * 
 * MMC Receive Error Frame Counter Interrupt Status
 * 
 * This bit is set when the rxrcverror counter reaches half of the maximum value or
 * the maximum value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : rxctrlfis
 * 
 * MMC Receive Control Frame Counter Interrupt Status
 * 
 * This bit is set when the rxctrlframes_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : reserved_31_26
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26_WIDTH      6
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26 register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26_SET_MSK    0xfc000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26 register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26_CLR_MSK    0x03ffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26 field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26_GET(value) (((value) & 0xfc000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26_SET(value) (((value) << 26) & 0xfc000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MMC_RX_INT.
 */
struct ALT_EMAC_GMAC_MMC_RX_INT_s
{
    const uint32_t  rxgbfrmis          :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS */
    const uint32_t  rxgboctis          :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS */
    const uint32_t  rxgoctis           :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS */
    const uint32_t  rxbcgfis           :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS */
    const uint32_t  rxmcgfis           :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS */
    const uint32_t  rxcrcerfis         :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS */
    const uint32_t  rxalgnerfis        :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS */
    const uint32_t  rxruntfis          :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS */
    const uint32_t  rxjaberfis         :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS */
    const uint32_t  rxusizegfis        :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS */
    const uint32_t  rxosizegfis        :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS */
    const uint32_t  rx64octgbfis       :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS */
    const uint32_t  rx65t127octgbfis   :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS */
    const uint32_t  rx128t255octgbfis  :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS */
    const uint32_t  rx256t511octgbfis  :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS */
    const uint32_t  rx512t1023octgbfis :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS */
    const uint32_t  rx1024tmaxoctgbfis :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS */
    const uint32_t  rxucgfis           :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS */
    const uint32_t  rxlenerfis         :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS */
    const uint32_t  rxorangefis        :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS */
    const uint32_t  rxpausfis          :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS */
    const uint32_t  rxfovfis           :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS */
    const uint32_t  rxvlangbfis        :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS */
    const uint32_t  rxwdogfis          :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS */
    const uint32_t  rxrcverrfis        :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS */
    const uint32_t  rxctrlfis          :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS */
    const uint32_t  reserved_31_26     :  6;  /* ALT_EMAC_GMAC_MMC_RX_INT_RSVD_31_26 */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MMC_RX_INT. */
typedef volatile struct ALT_EMAC_GMAC_MMC_RX_INT_s  ALT_EMAC_GMAC_MMC_RX_INT_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_MMC_RX_INT register from the beginning of the component. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OFST        0x104
/* The address of the ALT_EMAC_GMAC_MMC_RX_INT register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MMC_RX_INT_OFST))

/*
 * Register : gmacgrp_mmc_transmit_interrupt
 * 
 * <b> Register 66 (MMC Transmit Interrupt Register) </b>
 * 
 * The MMC Transmit Interrupt register maintains the interrupts generated when
 * transmit statistic counters reach half of their maximum values (0x8000_0000 for
 * 32-bit counter and 0x8000 for 16-bit counter), and the maximum values
 * (0xFFFF_FFFF for 32-bit counter and 0xFFFF for 16-bit counter). When Counter
 * Stop Rollover is set, then interrupts are set but the counter remains at all-
 * ones. The MMC Transmit Interrupt register is a 32-bit wide register. An
 * interrupt bit is cleared when the respective MMC counter that caused the
 * interrupt is read. The least significant byte lane (Bits[7:0]) of the respective
 * counter must be read in order to clear the interrupt bit.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                              
 * :--------|:-------|:------|:------------------------------------------
 *  [0]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS         
 *  [1]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS         
 *  [2]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS          
 *  [3]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS          
 *  [4]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS      
 *  [5]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS  
 *  [6]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS 
 *  [7]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS 
 *  [8]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS
 *  [9]     | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS
 *  [10]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS         
 *  [11]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS         
 *  [12]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS         
 *  [13]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS      
 *  [14]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS        
 *  [15]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS        
 *  [16]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS          
 *  [17]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS       
 *  [18]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS        
 *  [19]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS        
 *  [20]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS          
 *  [21]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS          
 *  [22]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS        
 *  [23]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS         
 *  [24]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS        
 *  [25]    | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS       
 *  [31:26] | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26      
 * 
 */
/*
 * Field : txgboctis
 * 
 * MMC Transmit Good Bad Octet Counter Interrupt Status
 * 
 * This bit is set when the txoctetcount_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : txgbfrmis
 * 
 * MMC Transmit Good Bad Frame Counter Interrupt Status
 * 
 * This bit is set when the txframecount_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : txbcgfis
 * 
 * MMC Transmit Broadcast Good Frame Counter Interrupt Status
 * 
 * This bit is set when the txbroadcastframes_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : txmcgfis
 * 
 * MMC Transmit Multicast Good Frame Counter Interrupt Status
 * 
 * This bit is set when the txmulticastframes_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : tx64octgbfis
 * 
 * MMC Transmit 64 Octet Good Bad Frame Counter Interrupt Status.
 * 
 * This bit is set when the tx64octets_gb counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description
 * :-------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : tx65t127octgbfis
 * 
 * MMC Transmit 65 to 127 Octet Good Bad Frame Counter Interrupt Status
 * 
 * This bit is set when the tx65to127octets_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description
 * :------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_SET_MSK    0x00000020
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_CLR_MSK    0xffffffdf
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : tx128t255octgbfis
 * 
 * MMC Transmit 128 to 255 Octet Good Bad Frame Counter Interrupt Status
 * 
 * This bit is set when the tx128to255octets_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description
 * :-------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_MSB        6
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_SET_MSK    0x00000040
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_CLR_MSK    0xffffffbf
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : tx256t511octgbfis
 * 
 * MMC Transmit 256 to 511 Octet Good Bad Frame Counter Interrupt Status
 * 
 * This bit is set when the tx256to511octets_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description
 * :-------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_SET_MSK    0x00000080
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_CLR_MSK    0xffffff7f
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : tx512t1023octgbfis
 * 
 * MMC Transmit 512 to 1023 Octet Good Bad Frame Counter Interrupt Status
 * 
 * This bit is set when the tx512to1023octets_gb counter reaches half of the
 * maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description
 * :--------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : tx1024tmaxoctgbfis
 * 
 * MMC Transmit 1024 to Maximum Octet Good Bad Frame Counter Interrupt Status
 * 
 * This bit is set when the tx1024tomaxoctets_gb counter reaches half of the
 * maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description
 * :--------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : txucgbfis
 * 
 * MMC Transmit Unicast Good Bad Frame Counter Interrupt Status
 * 
 * This bit is set when the txunicastframes_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_SET_MSK    0x00000400
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_CLR_MSK    0xfffffbff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : txmcgbfis
 * 
 * MMC Transmit Multicast Good Bad Frame Counter Interrupt Status
 * 
 * This bit is set when the txmulticastframes_gb counter reaches half of the
 * maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_E_INACT | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_E_ACT   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_MSB        11
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_SET_MSK    0x00000800
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : txbcgbfis
 * 
 * MMC Transmit Broadcast Good Bad Frame Counter Interrupt Status
 * 
 * This bit is set when the txbroadcastframes_gb counter reaches half of the
 * maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_MSB        12
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_SET_MSK    0x00001000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_CLR_MSK    0xffffefff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : txuflowerfis
 * 
 * MMC Transmit Underflow Error Frame Counter Interrupt Status
 * 
 * This bit is set when the txunderflowerror counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description
 * :-------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_MSB        13
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_SET_MSK    0x00002000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_CLR_MSK    0xffffdfff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : txscolgfis
 * 
 * MMC Transmit Single Collision Good Frame Counter Interrupt Status
 * 
 * This bit is set when the txsinglecol_g counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_MSB        14
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_SET_MSK    0x00004000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_CLR_MSK    0xffffbfff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : txmcolgfis
 * 
 * MMC Transmit Multiple Collision Good Frame Counter Interrupt Status
 * 
 * This bit is set when the txmulticol_g counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_SET_MSK    0x00008000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_CLR_MSK    0xffff7fff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : txdeffis
 * 
 * MMC Transmit Deferred Frame Counter Interrupt Status
 * 
 * This bit is set when the txdeferred counter reaches half of the maximum value or
 * the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : txlatcolfis
 * 
 * MMC Transmit Late Collision Frame Counter Interrupt Status
 * 
 * This bit is set when the txlatecol counter reaches half of the maximum value or
 * the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_MSB        17
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_SET_MSK    0x00020000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_CLR_MSK    0xfffdffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : txexcolfis
 * 
 * MMC Transmit Excessive Collision Frame Counter Interrupt Status
 * 
 * This bit is set when the txexcesscol counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_MSB        18
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_SET_MSK    0x00040000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_CLR_MSK    0xfffbffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : txcarerfis
 * 
 * MMC Transmit Carrier Error Frame Counter Interrupt Status
 * 
 * This bit is set when the txcarriererror counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_MSB        19
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_SET_MSK    0x00080000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : txgoctis
 * 
 * MMC Transmit Good Octet Counter Interrupt Status
 * 
 * This bit is set when the txoctetcount_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_MSB        20
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_SET_MSK    0x00100000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_CLR_MSK    0xffefffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : txgfrmis
 * 
 * MMC Transmit Good Frame Counter Interrupt Status
 * 
 * This bit is set when the txframecount_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_MSB        21
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_SET_MSK    0x00200000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_CLR_MSK    0xffdfffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : txexdeffis
 * 
 * MMC Transmit Excessive Deferral Frame Counter Interrupt Status
 * 
 * This bit is set when the txexcessdef counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_MSB        22
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_SET_MSK    0x00400000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_CLR_MSK    0xffbfffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : txpausfis
 * 
 * MMC Transmit Pause Frame Counter Interrupt Status
 * 
 * This bit is set when the txpauseframeserror counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_SET_MSK    0x00800000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_CLR_MSK    0xff7fffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : txvlangfis
 * 
 * MMC Transmit VLAN Good Frame Counter Interrupt Status
 * 
 * This bit is set when the txvlanframes_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_E_DISD | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_E_END  | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : txosizegfis
 * 
 * MMC Transmit Oversize Good Frame Counter Interrupt Status
 * 
 * This bit is set when the txoversize_g counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : reserved_31_26
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26_WIDTH      6
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26 register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26_SET_MSK    0xfc000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26 register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26_CLR_MSK    0x03ffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26 field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26_GET(value) (((value) & 0xfc000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26_SET(value) (((value) << 26) & 0xfc000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MMC_TX_INT.
 */
struct ALT_EMAC_GMAC_MMC_TX_INT_s
{
    const uint32_t  txgboctis          :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS */
    const uint32_t  txgbfrmis          :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS */
    const uint32_t  txbcgfis           :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS */
    const uint32_t  txmcgfis           :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS */
    const uint32_t  tx64octgbfis       :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS */
    const uint32_t  tx65t127octgbfis   :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS */
    const uint32_t  tx128t255octgbfis  :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS */
    const uint32_t  tx256t511octgbfis  :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS */
    const uint32_t  tx512t1023octgbfis :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS */
    const uint32_t  tx1024tmaxoctgbfis :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS */
    const uint32_t  txucgbfis          :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS */
    const uint32_t  txmcgbfis          :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS */
    const uint32_t  txbcgbfis          :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS */
    const uint32_t  txuflowerfis       :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS */
    const uint32_t  txscolgfis         :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS */
    const uint32_t  txmcolgfis         :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS */
    const uint32_t  txdeffis           :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS */
    const uint32_t  txlatcolfis        :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS */
    const uint32_t  txexcolfis         :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS */
    const uint32_t  txcarerfis         :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS */
    const uint32_t  txgoctis           :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS */
    const uint32_t  txgfrmis           :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS */
    const uint32_t  txexdeffis         :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS */
    const uint32_t  txpausfis          :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS */
    const uint32_t  txvlangfis         :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS */
    const uint32_t  txosizegfis        :  1;  /* ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS */
    const uint32_t  reserved_31_26     :  6;  /* ALT_EMAC_GMAC_MMC_TX_INT_RSVD_31_26 */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MMC_TX_INT. */
typedef volatile struct ALT_EMAC_GMAC_MMC_TX_INT_s  ALT_EMAC_GMAC_MMC_TX_INT_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_MMC_TX_INT register from the beginning of the component. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OFST        0x108
/* The address of the ALT_EMAC_GMAC_MMC_TX_INT register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MMC_TX_INT_OFST))

/*
 * Register : gmacgrp_mmc_receive_interrupt_mask
 * 
 * Regsiter 67 (MMC Receive Interrupt Mask Register)
 * 
 * The MMC Receive Interrupt Mask register maintains the masks for the interrupts
 * generated when the receive statistic counters reach half of their maximum value,
 * or maximum value. This register is 32-bits wide.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                  
 * :--------|:-------|:------|:----------------------------------------------
 *  [0]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM         
 *  [1]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM         
 *  [2]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM          
 *  [3]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM          
 *  [4]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM          
 *  [5]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM        
 *  [6]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM       
 *  [7]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM         
 *  [8]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM        
 *  [9]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM       
 *  [10]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM       
 *  [11]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM      
 *  [12]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM  
 *  [13]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM 
 *  [14]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM 
 *  [15]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM
 *  [16]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM
 *  [17]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM          
 *  [18]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM        
 *  [19]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM       
 *  [20]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM         
 *  [21]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM          
 *  [22]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM       
 *  [23]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM         
 *  [24]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM       
 *  [25]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM          
 *  [31:26] | R      | 0x0   | ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26      
 * 
 */
/*
 * Field : rxgbfrmim
 * 
 * MMC Receive Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxframecount_gb counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description
 * :-------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : rxgboctim
 * 
 * MMC Receive Good Bad Octet Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxoctetcount_gb counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description
 * :-------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : rxgoctim
 * 
 * MMC Receive Good Octet Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxoctetcount_g counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description
 * :------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : rxbcgfim
 * 
 * MMC Receive Broadcast Good Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxbroadcastframes_g counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description
 * :------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : rxmcgfim
 * 
 * MMC Receive Multicast Good Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxmulticastframes_g counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description
 * :------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : rxcrcerfim
 * 
 * MMC Receive CRC Error Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxcrcerror counter reaches half of
 * the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description
 * :--------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_SET_MSK    0x00000020
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_CLR_MSK    0xffffffdf
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : rxalgnerfim
 * 
 * MMC Receive Alignment Error Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxalignmenterror counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description
 * :---------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_E_NOMSKINTR  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_E_MSKINTR    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_MSB        6
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_SET_MSK    0x00000040
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_CLR_MSK    0xffffffbf
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : rxruntfim
 * 
 * MMC Receive Runt Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxrunterror counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description
 * :-------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_SET_MSK    0x00000080
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_CLR_MSK    0xffffff7f
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : rxjaberfim
 * 
 * MMC Receive Jabber Error Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxjabbererror counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description
 * :--------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : rxusizegfim
 * 
 * MMC Receive Undersize Good Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxundersize_g counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description
 * :---------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_E_NOMSKINTR  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_E_MSKINTR    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : rxosizegfim
 * 
 * MMC Receive Oversize Good Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxoversize_g counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description
 * :---------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_E_NOMSKINTR  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_E_MSKINTR    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_SET_MSK    0x00000400
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_CLR_MSK    0xfffffbff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : rx64octgbfim
 * 
 * MMC Receive 64 Octet Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rx64octets_gb counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                | Value | Description
 * :----------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_MSB        11
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_SET_MSK    0x00000800
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : rx65t127octgbfim
 * 
 * MMC Receive 65 to 127 Octet Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rx65to127octets_gb counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                    | Value | Description
 * :--------------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_MSB        12
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_SET_MSK    0x00001000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_CLR_MSK    0xffffefff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : rx128t255octgbfim
 * 
 * MMC Receive 128 to 255 Octet Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rx128to255octets_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                     | Value | Description
 * :---------------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_MSB        13
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_SET_MSK    0x00002000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_CLR_MSK    0xffffdfff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : rx256t511octgbfim
 * 
 * MMC Receive 256 to 511 Octet Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rx256to511octets_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                     | Value | Description
 * :---------------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_MSB        14
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_SET_MSK    0x00004000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_CLR_MSK    0xffffbfff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : rx512t1023octgbfim
 * 
 * MMC Receive 512 to 1023 Octet Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rx512to1023octets_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                      | Value | Description
 * :----------------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_SET_MSK    0x00008000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_CLR_MSK    0xffff7fff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : rx1024tmaxoctgbfim
 * 
 * MMC Receive 1024 to Maximum Octet Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rx1024tomaxoctets_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                      | Value | Description
 * :----------------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : rxucgfim
 * 
 * MMC Receive Unicast Good Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxunicastframes_g counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description
 * :------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_MSB        17
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_SET_MSK    0x00020000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_CLR_MSK    0xfffdffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : rxlenerfim
 * 
 * MMC Receive Length Error Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxlengtherror counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description
 * :--------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_MSB        18
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_SET_MSK    0x00040000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_CLR_MSK    0xfffbffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : rxorangefim
 * 
 * MMC Receive Out Of Range Error Frame Counter Interrupt  Mask
 * 
 * Setting this bit masks the interrupt when the rxoutofrangetype counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description
 * :---------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_E_NOMSKINTR  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_E_MSKINTR    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_MSB        19
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_SET_MSK    0x00080000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : rxpausfim
 * 
 * MMC Receive Pause Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxpauseframes counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description
 * :-------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_MSB        20
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_SET_MSK    0x00100000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_CLR_MSK    0xffefffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : rxfovfim
 * 
 * MMC Receive FIFO Overflow Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxfifooverflow counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description
 * :------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_MSB        21
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_SET_MSK    0x00200000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_CLR_MSK    0xffdfffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : rxvlangbfim
 * 
 * MMC Receive VLAN Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxvlanframes_gb counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description
 * :---------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_E_NOMSKINTR  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_E_MSKINTR    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_MSB        22
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_SET_MSK    0x00400000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_CLR_MSK    0xffbfffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : rxwdogfim
 * 
 * MMC Receive Watchdog Error Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxwatchdog counter reaches half of
 * the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description
 * :-------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_SET_MSK    0x00800000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_CLR_MSK    0xff7fffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : rxrcverrfim
 * 
 * MMC Receive Error Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxrcverror error counter reaches
 * half the maximum value, and also when it reaches the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description
 * :---------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_E_NOMSKINTR  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_E_MSKINTR    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : rxctrlfim
 * 
 * MMC Receive Control Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the rxctrlframes counter reaches half
 * the maximum value, and also when it reaches the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description
 * :------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : reserved_31_26
 * 
 * Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26_WIDTH      6
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26 register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26_SET_MSK    0xfc000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26 register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26_CLR_MSK    0x03ffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26 register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26 field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26_GET(value) (((value) & 0xfc000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26_SET(value) (((value) << 26) & 0xfc000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MMC_RX_INT_MSK.
 */
struct ALT_EMAC_GMAC_MMC_RX_INT_MSK_s
{
    uint32_t        rxgbfrmim          :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM */
    uint32_t        rxgboctim          :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM */
    uint32_t        rxgoctim           :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM */
    uint32_t        rxbcgfim           :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM */
    uint32_t        rxmcgfim           :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM */
    uint32_t        rxcrcerfim         :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM */
    uint32_t        rxalgnerfim        :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM */
    uint32_t        rxruntfim          :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM */
    uint32_t        rxjaberfim         :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM */
    uint32_t        rxusizegfim        :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM */
    uint32_t        rxosizegfim        :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM */
    uint32_t        rx64octgbfim       :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM */
    uint32_t        rx65t127octgbfim   :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM */
    uint32_t        rx128t255octgbfim  :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM */
    uint32_t        rx256t511octgbfim  :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM */
    uint32_t        rx512t1023octgbfim :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM */
    uint32_t        rx1024tmaxoctgbfim :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM */
    uint32_t        rxucgfim           :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM */
    uint32_t        rxlenerfim         :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM */
    uint32_t        rxorangefim        :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM */
    uint32_t        rxpausfim          :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM */
    uint32_t        rxfovfim           :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM */
    uint32_t        rxvlangbfim        :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM */
    uint32_t        rxwdogfim          :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM */
    uint32_t        rxrcverrfim        :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM */
    uint32_t        rxctrlfim          :  1;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM */
    const uint32_t  reserved_31_26     :  6;  /* ALT_EMAC_GMAC_MMC_RX_INT_MSK_RSVD_31_26 */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MMC_RX_INT_MSK. */
typedef volatile struct ALT_EMAC_GMAC_MMC_RX_INT_MSK_s  ALT_EMAC_GMAC_MMC_RX_INT_MSK_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RESET       0x00000000
/* The byte offset of the ALT_EMAC_GMAC_MMC_RX_INT_MSK register from the beginning of the component. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OFST        0x10c
/* The address of the ALT_EMAC_GMAC_MMC_RX_INT_MSK register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MMC_RX_INT_MSK_OFST))

/*
 * Register : gmacgrp_mmc_transmit_interrupt_mask
 * 
 * <b> Register 68 (MMC Transmit Interrupt Mask Register) </b>
 * 
 * The MMC Transmit Interrupt Mask register maintains the masks for the interrupts
 * generated when the transmit statistic counters reach half of their maximum value
 * or maximum value. This register is 32-bits wide.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                  
 * :--------|:-------|:------|:----------------------------------------------
 *  [0]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM         
 *  [1]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM         
 *  [2]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM          
 *  [3]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM          
 *  [4]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM      
 *  [5]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM  
 *  [6]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM 
 *  [7]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM 
 *  [8]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM
 *  [9]     | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM
 *  [10]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM         
 *  [11]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM         
 *  [12]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM         
 *  [13]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM      
 *  [14]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM        
 *  [15]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM        
 *  [16]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM          
 *  [17]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM       
 *  [18]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM        
 *  [19]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM        
 *  [20]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM          
 *  [21]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM          
 *  [22]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM        
 *  [23]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM         
 *  [24]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM        
 *  [25]    | RW     | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM       
 *  [31:26] | R      | 0x0   | ALT_EMAC_GMAC_MMC_TX_INT_MSK_RSVD_31_26      
 * 
 */
/*
 * Field : txgboctim
 * 
 * MMC Transmit Good Bad Octet Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the txoctetcount_gb counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description
 * :-------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : txgbfrmim
 * 
 * MMC Transmit Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the txframecount_gb counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description
 * :-------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : txbcgfim
 * 
 * MMC Transmit Broadcast Good Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the txbroadcastframes_g counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description
 * :------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : txmcgfim
 * 
 * MMC Transmit Multicast Good Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the txmulticastframes_g counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description
 * :------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : tx64octgbfim
 * 
 * MMC Transmit 64 Octet Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the tx64octets_gb counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                | Value | Description
 * :----------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : tx65t127octgbfim
 * 
 * MMC Transmit 65 to 127 Octet Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the tx65to127octets_gb counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                    | Value | Description
 * :--------------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_SET_MSK    0x00000020
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_CLR_MSK    0xffffffdf
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : tx128t255octgbfim
 * 
 * MMC Transmit 128 to 255 Octet Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the tx128to255octets_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                     | Value | Description
 * :---------------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_MSB        6
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_SET_MSK    0x00000040
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_CLR_MSK    0xffffffbf
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : tx256t511octgbfim
 * 
 * MMC Transmit 256 to 511 Octet Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the tx256to511octets_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                     | Value | Description
 * :---------------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_SET_MSK    0x00000080
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_CLR_MSK    0xffffff7f
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : tx512t1023octgbfim
 * 
 * MMC Transmit 512 to 1023 Octet Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the tx512to1023octets_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                      | Value | Description
 * :----------------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : tx1024tmaxoctgbfim
 * 
 * MMC Transmit 1024 to Maximum Octet Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the tx1024tomaxoctets_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                      | Value | Description
 * :----------------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : txucgbfim
 * 
 * MMC Transmit Unicast Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the txunicastframes_gb counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description
 * :-------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_SET_MSK    0x00000400
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_CLR_MSK    0xfffffbff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : txmcgbfim
 * 
 * MMC Transmit Multicast Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the txmulticastframes_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description
 * :-------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_MSB        11
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_SET_MSK    0x00000800
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : txbcgbfim
 * 
 * MMC Transmit Broadcast Good Bad Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the txbroadcastframes_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description
 * :-------------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_E_NOMSKINTR | 0x0   |            
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_E_MSKINTR   | 0x1   |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM
 * 
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_MSB        12
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_SET_MSK    0x00001000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_CLR_MSK    0xffffefff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : txuflowerfim
 * 
 * MMC Transmit Underflow Error Frame Counter Interrupt Mask
 * 
 * Setting this bit masks the interrupt when the txunderflowerror counter reaches
 * half of the m