/********************************************************************************//*!
 * @file  usleep_soc.c
 * @brief  usleep utility C source code file.
 * 
 * @details  usleep utility C source code file.
 * 
 * @note  nothing. 
 * 
 * @attention 
 * Copyright (C) 2013-2019 MACNICA,Inc. All Rights Reserved.\n
 *   This software is licensed "AS IS". 
 *   Please perform use of this software by a user's own responsibility and expense.
 *   It cannot guarantee in the maker side about the damage which occurred by the ab-
 *   ility not to use or use this software, and all damage that occurred secondarily.
 **//*******************************************************************************/
#include "alt_globaltmr.h"
#include "alt_clock_manager.h"

void usleep(uint32_t us)
{
	uint64_t start_time = alt_globaltmr_get64();
	uint32_t timer_prescaler = alt_globaltmr_prescaler_get() + 1;
	uint64_t end_time;
	alt_freq_t timer_clock;

	alt_clk_freq_get(ALT_CLK_MPU_PERIPH, &timer_clock);
	end_time = start_time + ( us * ((timer_clock / timer_prescaler) / 1000000) );

	while(alt_globaltmr_get64() < end_time)
	{
	}
}
