//*******************************************************************************
// file  tap37_fir.v
//
// attention
// Copyright (C) 2018 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS". 
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
//*******************************************************************************
//--------------------------------------------------------
//
// Description : Direct Form FIR
//
// Limitation  : 37 taps 
//
// --------------------------------------------------------

module tap37_fir
#(	parameter M					= 36,//(TAP_NUM -1),	// The degree of a polynomial
	parameter TAP_NUM			=	37
)
(
	input wire 			clk,
	input wire 			reset_n,
	input	wire			enb,
	input wire [15:0]	data_in,
	output wire [15:0] data_out
);


integer i;



wire	[15:0] h[0:TAP_NUM-1];	// coeff data
reg	[15:0] x[0:TAP_NUM-1];	// "monomial" or "one of polynomial"
reg	[15:0] y;		// Result or Routing

/* Set Coeff Datas of 37 Taps */
	assign	h[0] = 16'b0000000000000000;	// Coeff data :   0
	assign	h[1] = 16'b1111111111111011;	// Coeff data :  -5
	assign	h[2] = 16'b1111111111110010;	// Coeff data :  -14
	assign	h[3] = 16'b0000000000000000;	// Coeff data :   0
	assign	h[4] = 16'b0000000001000000;	// Coeff data :  64
	assign	h[5] = 16'b0000000010101010;	// Coeff data :  170
	assign	h[6] = 16'b0000000100000010;	// Coeff data :  258
	assign	h[7] = 16'b0000000011100101;	// Coeff data :  229
	assign	h[8] = 16'b0000000000000000;	// Coeff data :   0
	assign	h[9] = 16'b1111111001010111;    // Coeff data :  -425
	assign	h[10] = 16'b1111110001110011; // Coeff data :  -909
	assign	h[11] = 16'b1111101101011100; // Coeff data :  -1188
	assign	h[12] = 16'b1111110001000011; // Coeff data :  -957
	assign	h[13] = 16'b0000000000000000; // Coeff data :   0
	assign	h[14] = 16'b0000011010011011; // Coeff data :  1691
	assign	h[15] = 16'b0000111100001111; // Coeff data :  3855
	assign	h[16] = 16'b0001011101111100; // Coeff data :  6012
	assign	h[17] = 16'b0001110110110100; // Coeff data :  7604
	assign	h[18] = 16'b0001111111111111; // Coeff data :  8191
	assign	h[19] = 16'b0001110110110100; // Coeff data :  7604
	assign	h[20] = 16'b0001011101111100; // Coeff data :  6012
	assign	h[21] = 16'b0000111100001111; // Coeff data :  3855
	assign	h[22] = 16'b0000011010011011; // Coeff data :  1691
	assign	h[23] = 16'b0000000000000000; // Coeff data :   0
	assign	h[24] = 16'b1111110001000011; // Coeff data :  -957
	assign	h[25] = 16'b1111101101011100; // Coeff data :  -1188
	assign	h[26] = 16'b1111110001110011; // Coeff data :  -909
	assign	h[27] = 16'b1111111001010111; // Coeff data :  -425
	assign	h[28] = 16'b0000000000000000; // Coeff data :   0
	assign	h[29] = 16'b0000000011100101; // Coeff data :  229
	assign	h[30] = 16'b0000000100000010; // Coeff data :  258
	assign	h[31] = 16'b0000000010101010; // Coeff data :  170
	assign	h[32] = 16'b0000000001000000; // Coeff data :  64
	assign	h[33] = 16'b0000000000000000; // Coeff data :   0
	assign	h[34] = 16'b1111111111110010; // Coeff data :  -14
	assign	h[35] = 16'b1111111111111011; // Coeff data :  -5
	assign	h[36] = 16'b0000000000000000; // Coeff data :   0



always @(posedge clk or negedge reset_n)
begin
	if(reset_n == 0)
	begin
		y = 16'b0000000000000000;
		
	end 
	else  if(enb == 1'b1) begin

/* Calculate as Direct Form FIR */

		x[0] = data_in;
		y = 16'b0000000000000000;
	
		for(i = 0; i <= M ; i = i+1)
		begin
			y = y + h[i]*x[i];			// Calculate of Difference Equation
		end
		

		for(i = M; i > 0; i = i-1)
		begin
			x[i] = x[i-1];					// Move the data signal (Shift)
		end

		
	end
	else begin
		y = 16'b0000000000000000;
	end
	
end


assign data_out = y;

endmodule