//*******************************************************************************
// file  gray_16counter.c
//
// attention
// Copyright (C) 2018 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS". 
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
//*******************************************************************************
module gray_16counter (
      input wire clk,
      input wire en,
      input wire rst,
      output reg [15:0] counts_out  //'Gray' code counts output.
   );


   reg [15:0] binary_counts;

   always @ (posedge clk) begin
      if (rst) begin
         binary_counts <= {16{1'b 0}} + 1;  //Gray counts begins at '1' with
         counts_out    <= {16{1'b 0}};      // first 'en'.
      end
      else if (en) begin
         binary_counts <=  binary_counts + 1;
         counts_out    <= {binary_counts[15], binary_counts[14:0] ^ binary_counts[15:1]};
      end
   end
endmodule