//*******************************************************************************
// file  sample_master_top_tb.v
//
// attention
// Copyright (C) 2018 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS". 
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
//*******************************************************************************
`timescale 1 ns / 100 ps
module	sample_master_top_tb;

reg tb_clk;
reg tb_reset_n;
reg tb_ext_rst_i;

wire	[19:0]	tb_avmm_addr_o;
wire	[1:0]	tb_avmm_be_o;
wire		tb_re_o;
reg	[15:0]	tb_rdata_i;
wire		tb_we_o;
wire [15:0]	tb_wdata_o;
reg		tb_waitreq;

reg 		tb_ext_montr_i;
wire [15:0]	tb_ext_montr_d_o;
wire [1:0]	tb_ext_montr_o;



sample_master_top  sample_master_top_inst(
	// General Interface
        .clk			(tb_clk),               //   clk
        .reset_n		(tb_reset_n),           //   reset_n

   // Avalon-MM Master Interface
        .avmm_address		(tb_avmm_addr_o),      //   address
        .avmm_byteenable	(tb_avmm_be_o),   //   byteenable
        .avmm_read			(tb_re_o),         //   read
        .avmm_readdata		(tb_rdata_i),     //   readdata
        .avmm_write			(tb_we_o),        //   write
        .avmm_writedata		(tb_wdata_o),    //   writedata
        .avmm_waitreq		(tb_waitreq),
        
   // Conduit Interface
        .external_port_in	(tb_ext_montr_i),  	//   export_0 : Counter Reset Input to Binary and Dray Code
        .external_port_dout	(tb_ext_montr_d_o),  //   export_1 : Monitor of Avalon-MM Master Write Data Contents
        .external_port_out	(tb_ext_montr_o)	 	//   export_2 : State Indicator 2'b00(IDLE) 2'b01(WRITE)  2'b10(READ)
    );


always begin
  tb_clk = 1'b1;
  #10 tb_clk = 1'b0;
  #10;
end

initial begin

	tb_reset_n	=	1'b0; 
	tb_ext_montr_i = 1'b1;
	tb_waitreq = 1'b1;
	tb_rdata_i = 16'h0000;
	
	#1000;
	tb_reset_n	=	1'b1; 
	#100 tb_waitreq = 1'b0;
	     tb_rdata_i = 16'h0001;
	#100 tb_ext_montr_i = 1'b0;
	#1000	tb_rdata_i = 16'h0002;
	#1000	tb_rdata_i = 16'h0003;
	#1000	tb_rdata_i = 16'h0004;
	#1000	tb_rdata_i = 16'h0005;
	#1000	tb_rdata_i = 16'h0006;
	#1000	tb_rdata_i = 16'h0007;
	#1000	tb_rdata_i = 16'h0008;
	#3000;
	tb_waitreq = 1'b1;
	#3000;

end

endmodule