//*******************************************************************************
// file  sample_st_sink_top.v
//
// attention
// Copyright (C) 2018 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS". 
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
//*******************************************************************************
module sample_st_sink_top
#(
	parameter	MAX_LENG = 7000
)
(
   // General Interface
        input  wire        	clk,						//   clk
        input  wire        	reset_n,					//   reset_n
        
   // Avalon-ST Sink Interface
        output	reg				avst_sink_ready,		// ready
        input  	wire        	avst_sink_valid,	//   valid
        input  	wire [15:0] 	avst_sink_data,   //   data
        input  	wire        	avst_sink_sop,		//   Start Of Packet
        input  	wire        	avst_sink_eop,    //   End Of Packet
        
   // Conduit Interface
        output reg [15:0]		external_port_dout	//   export_1 : Monitor of Avalon-MM Master Write Data Contents
    );
    

   reg	[15:0]	out_16data;
 	reg 				cnt_start;
	reg 				cnt_stop;
	reg	[15:0] 				bin_cnt;
	wire	[1:0]	sop_eop;


 
   // ALWAYS CONSTRUCT BLOCK
    //  Data Sink Function
	always @(posedge clk or negedge reset_n) begin
		if (reset_n == 1'b0) begin
			external_port_dout <= 16'h0000;
		end
		else if ( avst_sink_valid == 1'b1 ) begin
			external_port_dout <= avst_sink_data;
		end
		else begin
			external_port_dout <= 16'hzzzz;
		end
	end

	// Sink Data Control
	always @(posedge clk or negedge reset_n) begin
		if (reset_n == 1'b0) begin
			cnt_start <= 1'b0;
			cnt_stop <= 1'b0;
		end
		else begin
			case (sop_eop)
			2'b01	: begin
				cnt_start <= 1'b1;
				cnt_stop <= 1'b0;
			end 
			2'b10	: begin
				cnt_start <= 1'b0;				
				cnt_stop <= 1'b1;
			end
			default	: begin
				cnt_start <= 1'b0;
				cnt_stop <= 1'b0;
			end
			endcase
		end
	end
	
	// Flow Contlore used by Binary Counter
	always @( posedge clk or negedge reset_n ) begin
	if (reset_n == 1'b0) begin
		bin_cnt		<= 16'h0000;
		avst_sink_ready <= 1'b0;
		end
	else if( cnt_start == 1'b1 ) begin
		bin_cnt		<= bin_cnt + 1;
		avst_sink_ready <= 1'b1;
		end
	else if ( cnt_stop == 1'b1 ) begin
		bin_cnt		<= 16'h0000;
		avst_sink_ready <= 1'b1;
	end
	else if (bin_cnt == MAX_LENG) begin
		avst_sink_ready <= 1'b0;
	end
	else begin
		bin_cnt		<= bin_cnt + 1;
		avst_sink_ready <= 1'b1;
		end
	end
	
	assign sop_eop[0] = avst_sink_sop;
	assign sop_eop[1] = avst_sink_eop;

endmodule