//*******************************************************************************
// file  sample_st_src_top.v
//
// attention
// Copyright (C) 2018 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS". 
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
//*******************************************************************************
module sample_st_src_top
#(
	parameter	MAX_LENG = 1023,
					STET_IDLE  		= 2'b00,
					STET_TRANSFER	= 2'b01,
					STET_WAIT		= 2'b10,
					STET_ENB_CNT	= 2'b11
)
(
   // General Interface
        input  wire        	clk,               //   clk
        input  wire        	reset_n,           //   reset_n
        
   // Avalon-ST Source Interface
        input	wire				avst_src_ready,		// ready
        output  reg        	avst_src_valid,        //   valid
        output  reg [15:0] 	avst_src_data,    //   data
        output  reg        	avst_src_sop,        //   Start Of Packet
        output  reg        	avst_src_eop,        //   End Of Packet
        
   // Conduit Interface
        input  wire        	external_port_in,  	//   export_0 : Counter Reset Input to Binary and Dray Code
        output reg [15:0]		external_port_dout,  //   export_1 : Monitor of Avalon-MM Master Write Data Contents
        output reg [1:0]		external_port_out	 	//   export_2 : State Indicator 2'b00(IDLE) 2'b01(WRITE)  2'b10(READ)
    );
    

    reg	gray_en;
    reg	gray_pause;
    reg	bin_en;
    reg	bin_pause;
    reg	cnt_rst;
   
    wire	[15:0]	gray16_dataout;
    wire	[15:0]	bin16_dataout;
    reg	[15:0]	out_16data;
    
    reg	sop;
    reg	eop;
    reg	transfer;

    
    reg	[1:0]		stsc_state;
	 
//    parameter	STET_IDLE  		= 2'b00,
//					STET_TRANSFER	= 2'b01, 
//					STET_WAIT		= 2'b10,
//					STET_ENB_CNT	= 2'b11;
    
	 
	 // Binary Counter
	 bin_16counter  bin_16counter_inst(
	.clk		(clk),
	.reset	(~reset_n|external_port_in|cnt_rst),
	.enb		(bin_en),
	.pause	(bin_pause),
	.max	(MAX_LENG),
	.b			(bin16_dataout)
	);
	
	 // Gray Code counter
	 gray_16counter gray_16counter_inst(
   .clk			(clk),
	.en			(gray_en),
	.pause		(gray_pause),
	.rst			(~reset_n|external_port_in),
   .counts_out	(gray16_dataout)
   );

 
   // ALWAYS CONSTRUCT BLOCK
	// Packet Controle used by Counter
	always @(posedge clk or negedge reset_n) begin
		if (reset_n == 1'b0) begin
			transfer	<= 1'b0;	// Not Data Transder
//			bin_en	<= 1'b0;
			cnt_rst	<= 1'b1;
		end
//		else if(bin_en == 1'b1) begin
		else begin
			case( bin16_dataout )
				16'h0000	: begin	// SOP
					sop	<= 1'b1;
					eop	<= 1'b0;
					transfer	<= 1'b1;	// Data Transder
				end
				MAX_LENG	: begin	// EOP: Packet length is MAX_LENG half-words ( 1 half word = 16 bits ) 
					sop	<= 1'b0;
					eop	<= 1'b1;
					transfer	<= 1'b1;	// Data Transder
				end
				16'h1111	: begin	// Invalid Data 
					sop	<= 1'b0;
					eop	<= 1'b0;
					transfer	<= 1'b1;	// Data Transder
				end
				default	: begin	// Packt Transfer between SOP and EOP
					sop	<= 1'b0;
					eop	<= 1'b0;
					transfer	<= 1'b1;	// Data Transder
					cnt_rst	<= 1'b0;
				end
			endcase
		end
	end

    // State Machine
	 always @(posedge clk or negedge reset_n) begin

    	if (reset_n == 1'b0) begin
    		avst_src_valid			<= 1'b0;
    		avst_src_data			<= 16'hzzzz;
    		avst_src_sop			<= 1'b0;
    		avst_src_eop			<= 1'b0;
			external_port_dout	<= 16'hzzzz;   
			external_port_out		<= 2'bzz;
			bin_en	<= 1'b0;
			gray_en	<= 1'b0;	
			external_port_out 	<= 2'bzz;
			bin_pause				<= 1'b0;  // Packet Increments
			gray_pause				<= 1'b0;  // Packet Data Increments
    		stsc_state = STET_IDLE;
    	end
    	else begin		
    		case( stsc_state )
			// Idle State
	    		STET_IDLE : begin
	    		avst_src_valid		<= 1'b0;
	    		avst_src_data		<= 16'h0000;
	    		avst_src_sop		<= 1'b0;
	    		avst_src_eop		<= 1'b0;
			external_port_dout	<= 16'h0000; 		
			external_port_out		<= STET_IDLE;
			bin_en	<= 1'b0;
			bin_pause				<= 1'b0;  // Packet Increments
			gray_en	<= 1'b0;
			gray_pause				<= 1'b0;  // Packet Data Increments
			stsc_state = STET_ENB_CNT;
    		end
			// Counter  Enable
		STET_ENB_CNT  : begin
			bin_en	<= 1'b1;
			gray_en	<= 1'b1;
			if( bin16_dataout == 16'hffff) begin
				stsc_state = STET_ENB_CNT;
			end
			else begin
				stsc_state = STET_TRANSFER;
			end
		end
			// Transfer State
    		STET_TRANSFER : begin
			gray_en				<= 1'b1;
			gray_pause			<= 1'b0;  // Packet Data Increments
			bin_en				<= 1'b1;
			bin_pause			<= 1'b0;  // Packet Increments
    			if( avst_src_ready == 1'b1 && transfer == 1'b1) begin
				avst_src_valid				<= 1'b1;
    				avst_src_data			<= out_16data;//bin16_dataout;//gray16_dataout;
    				avst_src_sop			<= sop;
    				avst_src_eop			<= eop;
	    			external_port_dout	<= out_16data;//bin16_dataout;//gray16_dataout;
				external_port_out			<= STET_TRANSFER;
				gray_pause					<= 1'b0;  // Packet Data Increments
				stsc_state =STET_TRANSFER;
    			end
			else if(avst_src_ready == 1'b0 && transfer == 1'b1) begin
				stsc_state =STET_WAIT;
			end
			else begin
				stsc_state =STET_WAIT;
			end
			end
			STET_WAIT : begin	
				gray_pause			<= 1'b1;  // Pause Packet Data Increments
				bin_pause			<= 1'b1;  // Pause Packet Increments
				if(avst_src_ready == 1'b0 && transfer == 1'b1) begin
					avst_src_valid				<= avst_src_valid;
    					avst_src_data			<= avst_src_data;
    					avst_src_sop			<= avst_src_sop;
    					avst_src_eop			<= avst_src_eop;
	    				external_port_dout	<= external_port_dout;
					gray_pause			<= 1'b1;  // Packet Data Increments
					external_port_out <= STET_WAIT;
				end
				else if(avst_src_ready == 1'b1 && transfer == 1'b1) begin
					stsc_state = STET_TRANSFER;
				end
				else begin
					stsc_state = STET_WAIT;
				end
    		end
    		endcase
			out_16data <= gray16_dataout; // bin16_dataout;// output data select
    	end
	//out_16data <= gray16_dataout; // bin16_dataout;// output data select
    end


endmodule