// test_system_tb.v

// Generated using ACDS version 18.0 614

//`timescale 1 ps / 1 ps
`timescale 1 ns / 100 ps
module test_system_tb (
	);

	wire    test_system_inst_clk_bfm_clk_clk;       // test_system_inst_clk_bfm:clk -> [test_system_inst:clk_clk, test_system_inst_reset_bfm:clk]
	wire    test_system_inst_reset_bfm_reset_reset; // test_system_inst_reset_bfm:reset -> test_system_inst:reset_reset_n

	reg 		tb_ext_rst_i;
	wire	[1:0]	tb_ext_montr_o;

	reg	[19:0]	tb_avms_addr_i;
	reg	[1:0]	tb_avm_be_i;
	reg		tb_re_i;
	wire	[15:0]	tb_rdata_o;
	reg		tb_we_i;
	reg	[15:0]	tb_wdata_i;


	test_system test_system_inst (
		.clk_clk                         (test_system_inst_clk_bfm_clk_clk),       //                  clk.clk
		.m_slave_cmp_avms_ept_address    (tb_avms_addr_i),                                       // m_slave_cmp_avms_ept.address
		.m_slave_cmp_avms_ept_byteenable (tb_avm_be_i),                                       //                     .byteenable
		.m_slave_cmp_avms_ept_read       (tb_re_i),                                       //                     .read
		.m_slave_cmp_avms_ept_readdata   (tb_rdata_o),                                       //                     .readdata
		.m_slave_cmp_avms_ept_write      (tb_we_i),                                       //                     .write
		.m_slave_cmp_avms_ept_writedata  (tb_wdata_i),                                       //                     .writedata
		.m_slave_cmp_cdt_ept_export_0    (tb_ext_rst_i),                                       //  m_slave_cmp_cdt_ept.export_0
		.m_slave_cmp_cdt_ept_export_1    (tb_ext_montr_o),                                       //                     .export_1
		.reset_reset_n                   (test_system_inst_reset_bfm_reset_reset)  //                reset.reset_n
	);

	altera_avalon_clock_source #(
		.CLOCK_RATE (50000000),
		.CLOCK_UNIT (1)
	) test_system_inst_clk_bfm (
		.clk (test_system_inst_clk_bfm_clk_clk)  // clk.clk
	);

	altera_avalon_reset_source #(
		.ASSERT_HIGH_RESET    (0),
		.INITIAL_RESET_CYCLES (50)
	) test_system_inst_reset_bfm (
		.reset (test_system_inst_reset_bfm_reset_reset), // reset.reset_n
		.clk   (test_system_inst_clk_bfm_clk_clk)        //   clk.clk
	);

always @( posedge test_system_inst_clk_bfm_clk_clk or negedge test_system_inst_reset_bfm_reset_reset ) begin
	if (tb_we_i == 1'b1) begin
		tb_wdata_i = tb_wdata_i +1;
		end
	else begin
		tb_wdata_i = tb_wdata_i;
	end
end

initial begin
	tb_avms_addr_i = 20'h00000; // address 0x00000
	tb_avm_be_i = 2'b00;
	tb_re_i = 1'b0;
	tb_we_i = 1'b0;
	tb_wdata_i = 16'h0000;
	tb_ext_rst_i = 1'b0;

	#1000;
	#200;
	
	#100 tb_avms_addr_i = 20'h00004; // address 0x00004
	#20 	tb_re_i = 1'b0;
		tb_we_i = 1'b1;
		tb_avm_be_i = 2'b11;
	#20	tb_re_i = 1'b1;
		
	#3000;
	#20	tb_re_i = 1'b0;
	#100    tb_re_i = 1'b1;

	#1000;
	#20	tb_re_i = 1'b0;
	#100 tb_avms_addr_i = 20'h00008; // address 0x00008
	#740	tb_re_i = 1'b1;
	
	#3000;
	#100 tb_ext_rst_i = 1'b1;
	#500 tb_ext_rst_i = 1'b0;

	#3000;
	tb_avms_addr_i = 20'h00000; // address 0x00000
end

endmodule
