﻿/********************************************************************************//*!
 * @file  sample_app_setting.h
 * @brief  Initial setting of the HPS and the Board.
 * 
 * @details  Initial setting of the HPS and the Board.
 * 
 * @note  nothing. 
 * 
 * @date <b> History: \<Date\> \<Rev\> \<Keyword\> \<Details\> </b>
 * @date 2015/03/02  ---  #18042  新規作成.
 * @date 2015/06/25  ---  #20263  v15.0対応/文字コード変更(UTF-8) 他. 
 * @date 2016/07/26  ---  -----  v16.0での確認およびHelio以外の評価ボードへの対応を実施.
 * @date 2021/04/23  ---  -----  SoC EDS v20.1 / Arm DS 2020.1 への対応を実施. 
 * 
 * @attention 
 * Copyright (C) 2013-2021 MACNICA,Inc. All Rights Reserved.\n
 *   This software is licensed "AS IS". 
 *   Please perform use of this software by a user's own responsibility and expense.
 *   It cannot guarantee in the maker side about the damage which occurred by the ab-
 *   ility not to use or use this software, and all damage that occurred secondarily.
 **//*******************************************************************************/

#ifndef __SAMPLE_APP_SETTING_H__
#define __SAMPLE_APP_SETTING_H__

/***********************************************************************************
 *  includes
 ***********************************************************************************/
#include <stdint.h>
#include "hwlib.h"
#include "alt_generalpurpose_io.h"

/***********************************************************************************
 *  externs 
 ***********************************************************************************/

/***********************************************************************************
 *  proto types 
 ***********************************************************************************/

/***********************************************************************************
 *  definitions (define, enum, typedef, etc..) 
 ***********************************************************************************/
// NOTE: To enable debugging output, delete the next line and uncomment the
//   line after.
#define dprintf(...)
// #define dprintf  printf

/* Basic definition*/
#define	__WARN_UNUSED__		__attribute__((unused))

#define	_KB		1024UL
#define	_MB		(1024UL*1024UL)
#define	_GB		(1024UL*1024UL*1024UL)

typedef void (*CALLBACK_FUNKt)(uint32_t, void*);

#define ACP_WINDOW_BASE	(0x80000000)

#if 99	/* These are implemented on sample_mmu.c */
/******** Definition Memory Region ********/
/*! SDRAM0(Common0 Region) .. PA:0x00000000~0x001FFFFF <--> VA: (=PA) */
#define	SDRAM0_PHYSICAL_ADDR		0x00000000
#define	SDRAM0_VIRTUAL_ADDR			SDRAM0_PHYSICAL_ADDR
#define	SDRAM0_SIZE					( 2 * _MB )

/*! SDRAMx(Private Region) .. PA:0x00200000~0x0FFFFFFF <--> VA: (=PA) */
#define	SDRAMx_PHYSICAL_ADDR		0x00200000
#define	SDRAMx_VIRTUAL_ADDR			SDRAMx_PHYSICAL_ADDR
#define	SDRAMx_SIZE					( 254 * _MB )

/*! SDRAM1(Common1 Region) .. PA:0x10000000~0x1FFFFFFF <--> VA: (=PA) */
#define	SDRAM1_PHYSICAL_ADDR		0x10000000
#define	SDRAM1_VIRTUAL_ADDR			SDRAM1_PHYSICAL_ADDR
#define	SDRAM1_SIZE					( 256 * _MB )

/*! SDRAM2(Common2 Region) .. PA:0x20000000~0x27FFFFFF <--> VA: (=PA) */
#define	SDRAM2_PHYSICAL_ADDR		0x20000000
#define	SDRAM2_VIRTUAL_ADDR			SDRAM2_PHYSICAL_ADDR
#define	SDRAM2_SIZE					( 128 * _MB )

/*! SDRAM3(Common3 Region) .. PA:0x28000000~0x2FFFFFFF <--> VA: (=PA) */
#define	SDRAM3_PHYSICAL_ADDR		0x28000000
#define	SDRAM3_VIRTUAL_ADDR			SDRAM3_PHYSICAL_ADDR
#define	SDRAM3_SIZE					( 128 * _MB )

/*! SDRAM4(Common4 Region) .. PA:0x30000000~0x3FFFFFFF <--> VA: (=PA) */
#define	SDRAM4_PHYSICAL_ADDR		0x30000000
#define	SDRAM4_VIRTUAL_ADDR			SDRAM4_PHYSICAL_ADDR
#define	SDRAM4_SIZE					( 256 * _MB )

/*! ACPWINDOW .. PA:0x80000000~0xBFFFFFFF <--> VA: (=PA) *//* DMA用APIがNGになるので、PA=VAでMMU設定 */
#define	ACPWINDOW_PHYSICAL_ADDR		0x80000000
#define	ACPWINDOW_VIRTUAL_ADDR		ACPWINDOW_PHYSICAL_ADDR
#define	ACPWINDOW_SIZE				(1 * _GB)

/*! HPS2FPGA .. PA:0xC000000~0xFBFFFFFF <--> VA: (=PA) */
#define	HPS2FPGA_PHYSICAL_ADDR		0xC0000000
#define	HPS2FPGA_VIRTUAL_ADDR		HPS2FPGA_PHYSICAL_ADDR
#define	HPS2FPGA_SIZE				( 960 * _MB )

/*! LW_HPS2FPGA .. PA:0xFF200000~0xFF3FFFFF <--> VA: (=PA) */
#define	LW_HPS2FPGA_PHYSICAL_ADDR	0xFF200000
#define	LW_HPS2FPGA_VIRTUAL_ADDR	LW_HPS2FPGA_PHYSICAL_ADDR
#define	LW_HPS2FPGA_SIZE			( 2 * _MB )

#ifdef soc_cv_av
/*! PERIPHRALS .. PA:0xFF400000~0xFFEFFFFF <--> VA: (=PA) */
#define	PERIPHRALS_PHYSICAL_ADDR	0xFF400000
#define	PERIPHRALS_VIRTUAL_ADDR		PERIPHRALS_PHYSICAL_ADDR
#define	PERIPHRALS_SIZE				( 11 * _MB )

/*! BOOTROM .. PA:0xFFFD0000~0xFFFDFFFF <--> VA: (=PA) */
#define	BOOTROM_PHYSICAL_ADDR		0xFFFD0000
#define	BOOTROM_VIRTUAL_ADDR		BOOTROM_PHYSICAL_ADDR
#define	BOOTROM_SIZE				( 64 *_KB )

/*! MPUSCU .. PA:0xFFFEC000~0xFFFEDFFF <--> VA: (=PA) */
#define	MPUSCU_PHYSICAL_ADDR		0xFFFEC000
#define	MPUSCU_VIRTUAL_ADDR			MPUSCU_PHYSICAL_ADDR
#define	MPUSCU_SIZE					( 8 * _KB)

/*! MPUL2 .. PA:0xFFFEF000~0xFFFEFFFF <--> VA: (=PA) */
#define	MPUL2_PHYSICAL_ADDR			0xFFFEF000
#define	MPUL2_VIRTUAL_ADDR			MPUL2_PHYSICAL_ADDR
#define	MPUL2_SIZE					( 4 * _KB)

/*! ONCHIPRAM .. PA:0xFFFF0000~0xFFFFFFFF <--> VA: (=PA) */
#define	RAM_PHYSICAL_ADDR			0xFFFF0000
#define	RAM_VIRTUAL_ADDR			RAM_PHYSICAL_ADDR
#define	RAM_SIZE					( 64 *_KB )
#else /* soc_cv_av */
/*! A10 PERIPHRALS .. PA:0xFF400000~0xFFDFFFFF <--> VA: (=PA) */
#define	PERIPHRALS_PHYSICAL_ADDR	0xFF400000
#define	PERIPHRALS_VIRTUAL_ADDR		PERIPHRALS_PHYSICAL_ADDR
#define	PERIPHRALS_SIZE				( 10 * _MB )

/*! A10 ONCHIPRAM .. PA:0xFFE00000~0xFFE3FFFF <--> VA: (=PA) */
#define	RAM_PHYSICAL_ADDR			0xFFE00000
#define	RAM_VIRTUAL_ADDR			RAM_PHYSICAL_ADDR
#define	RAM_SIZE					( 256 *_KB )

/*! A10 BOOTROM .. PA:0xFFFC0000~0xFFFDFFFF <--> VA: (=PA) */
#define	BOOTROM_PHYSICAL_ADDR		0xFFFC0000
#define	BOOTROM_VIRTUAL_ADDR		BOOTROM_PHYSICAL_ADDR
#define	BOOTROM_SIZE				( 128 *_KB )

/*! A10 MPUSCU .. PA:0xFFFFC000~0xFFFFDFFF <--> VA: (=PA) */
#define	MPUSCU_PHYSICAL_ADDR		0xFFFFC000
#define	MPUSCU_VIRTUAL_ADDR			MPUSCU_PHYSICAL_ADDR
#define	MPUSCU_SIZE					( 8 * _KB)

/*! A10 MPUL2 .. PA:0xFFFFF000~0xFFFFFFFF <--> VA: (=PA) */
#define	MPUL2_PHYSICAL_ADDR			0xFFFFF000
#define	MPUL2_VIRTUAL_ADDR			MPUL2_PHYSICAL_ADDR
#define	MPUL2_SIZE					( 4 * _KB)
#endif /* soc_cv_av */
#endif	/* These are implemented on sample_mmu.c */

/*** Definition for on-board-switch detection ***/
#define SAMPLE_SWITCH_BIT_SLIDE0	(0x00000001)
#define SAMPLE_SWITCH_BIT_SLIDE1	(0x00000002)
#define SAMPLE_SWITCH_BIT_SLIDE2	(0x00000004)
#define SAMPLE_SWITCH_BIT_SLIDE3	(0x00000008)
#define SAMPLE_SWITCH_BIT_SLIDEALL	(SAMPLE_SWITCH_BIT_SLIDE0 | SAMPLE_SWITCH_BIT_SLIDE1 | SAMPLE_SWITCH_BIT_SLIDE2 | SAMPLE_SWITCH_BIT_SLIDE3)
#define SAMPLE_SWITCH_BIT_PUSH0		(0x00000010)
#define SAMPLE_SWITCH_BIT_PUSH1		(0x00000020)
#define SAMPLE_SWITCH_BIT_PUSH2		(0x00000040)
#define SAMPLE_SWITCH_BIT_PUSH3		(0x00000080)
#define SAMPLE_SWITCH_BIT_PUSHALL	(SAMPLE_SWITCH_BIT_PUSH0 | SAMPLE_SWITCH_BIT_PUSH1 | SAMPLE_SWITCH_BIT_PUSH2 | SAMPLE_SWITCH_BIT_PUSH3)
#define SAMPLE_SWITCH_BIT_ALL		(SAMPLE_SWITCH_BIT_SLIDEALL | SAMPLE_SWITCH_BIT_PUSHALL)

#define SAMPLE_SWITCH_BIT_NUM		(SAMPLE_SWITCH_BIT_SLIDE0 | SAMPLE_SWITCH_BIT_SLIDE1 | SAMPLE_SWITCH_BIT_SLIDE2 | SAMPLE_SWITCH_BIT_SLIDE3)

/***********************************************************************************
 *  variables
 ***********************************************************************************/


/***********************************************************************************
 *  functions 
 ***********************************************************************************/
extern int cpu0_init(void);
#if 99
extern ALT_STATUS_CODE socfpga_int_start(void);
extern void socfpga_int_stop(void);
extern void sample_config_switch(void);
#endif // 99
extern uint32_t sample_detect_switch(void);

#endif /* __SAMPLE_APP_SETTING_H__ */
/***********************************************************************************
 * end of file 
 ***********************************************************************************/
