﻿/********************************************************************************//*!
 * @file  util_interrupt_log.h 
 * @brief  Interrupt logging programs.
 * 
 * @details  Provides a mechanism to logging interrupt occurrence information.
 * 
 * @note  nothing. 
 * 
 * @date <b> History: \<Date\> \<Rev\> \<Keyword\> \<Details\> </b>
 * @date 2015/06/26  ---  #20263  新規作成. 
 * 
 * @attention 
 * Copyright (C) 2013-2019 MACNICA,Inc. All Rights Reserved.\n
 *   This software is licensed "AS IS". 
 *   Please perform use of this software by a user's own responsibility and expense.
 *   It cannot guarantee in the maker side about the damage which occurred by the ab-
 *   ility not to use or use this software, and all damage that occurred secondarily.
 **//*******************************************************************************/

/***********************************************************************************
 *  includes 
 ***********************************************************************************/
#include "hwlib.h"
#include "alt_interrupt_common.h"

/***********************************************************************************
 *  externs 
 ***********************************************************************************/

/***********************************************************************************
 *  proto types 
 ***********************************************************************************/

/***********************************************************************************
 *  definitions (define, enum, typedef, etc..) 
 ***********************************************************************************/

/***********************************************************************************
 *  variables 
 ***********************************************************************************/

/***********************************************************************************
 *  functions 
 ***********************************************************************************/
/* 初期化処理: 最初に必ず呼ぶ */
void util_intlog_init(void);

/* ログ記録処理: 割り込みルーチン上で呼ぶ */
void util_intlog_record(ALT_INT_INTERRUPT_t kind, int opt1, int opt2);

/* ログ出力処理: 通常ルーチン上で定期的に呼ぶ */
void util_intlog_print(void);

/***********************************************************************************
 * end of file 
 ***********************************************************************************/
