/* file GSFI_Operation_sample.h
 *
 * Copyright (C) 2021 MACNICA,Inc. All Rights Reserved.
 *  This software is licensed "AS IS".
 *  Please perform use of this software by a user's own responsibility and expense.
 *  It cannot guarantee in the maker side about the damage which occurred
 *  by the ab-ility not to use or use this software, and all damage that occurred secondarily.
 * Created on: 2021/07/15
 */

/* time out */
#define TIMEOUT_1US_VALUE  1000000

/* IO MODE */
#define STANDARD  0
#define DUAL      1
#define QUAD      2

/***********************************************************************************
 * definitions (define)
 * Flash ROM ̎ނɍ킹ĐݒύXĂB
 * *********************************************************************************/
#define MACRONIX_ISSI				(0)		// Macronix  ISSI  Flash ROM  Addressing ̐ݒ QUAD ̐ݒ肪KvȂ̂ŁAgpƂ 1 ɂĂB
#define ADDRESS_IO_MODE				(0)	    // QUAD Write  Address I/O Mode  Standard ɂKvꍇ 1 ɂĂBiISSI  EPCQA ̏ꍇLɂĂBj

/*******************************************************************************
 * Flash ROM Command Info based on EPCQ256 EPCQA128 MT25QL256 MX25L25645G IS25LP256D
 *******************************************************************************/
#define READ_DEVICE_ID_CMD			(0x9F)
#define READ_DEVICE_ID_BYTES		(4)
#define READ_STATUS_CMD				(0x05)
#define READ_STATUS_BYTES			(1)
#define READ_FLAG_STATUS_CMD		(0x70) 		// EPCQA Macronix ISSI is not support
#define READ_FLAG_STATUS_BYTES		(1)
#define READ_NON_VOLA_CONFIG_CMD	(0xB5) 		// EPCQA is not support. EPCQ Micron:0xB5, Macronix:0x15, ISSI:0x61
#define READ_NON_VOLA_CONFIG_BYTES	(2)

#define WRITE_STATUS_CMD			(0x01)
#define WRITE_STATUS_BYTES			(1)
#define WRITE_NON_VOLA_CONFIG_CMD	(0xB1) 		// EPCQA Macronix ISSI is not support
#define WRITE_NON_VOLA_CONFIG_BYTES	(2)
#define WRITE_ENABLE_CMD			(0x06)
#define WRITE_ENABLE_BYTES			(0)
#define WRITE_DISABLE_CMD			(0x04)
#define WRITE_DISABLE_BYTES			(0)

#define READ_BYTES_CMD					(0x03)
#define READ_BYTES_DUMMY				(0)
#define EXTENDED_DUAL_FAST_READ_CMD		(0xBB)
#define EXTENDED_DUAL_FAST_READ_DUMMY	(10)      // EPCQ Micron:8 or 10 or 12, EPCQA ISSI Macronix:6 or 10
#define EXTENDED_QUAD_FAST_READ_CMD		(0xEB)
#define EXTENDED_QUAD_FAST_READ_DUMMY	(10)      // EPCQ Micron:8 or 10 or 12, EPCQA ISSI Macronix:6 or 10

#define WRITE_BYTES_CMD					(0x02)
#define WRITE_BYTES_DUMMY				(0)
#define EXTENDED_DUAL_FAST_WRITE_CMD	(0xD2)    // EPCQA Macronix ISSI is not support
#define EXTENDED_DUAL_FAST_WRITE_DUMMY	(0)
#define EXTENDED_QUAD_FAST_WRITE_CMD	(0x12)    //EPCQ:0x12, EPCQA:0x32, Micron Macronix ISSI:0x38
#define EXTENDED_QUAD_FAST_WRITE_DUMMY	(0)

#define ERASE_SUBSECTOR_CMD			(0x20)
#define ERASE_SUBSECTOR_DUMMY		(0)
#define ERASE_SECTOR_CMD			(0xD8)
#define ERASE_SECTOR_DUMMY			(0)
#define ERASE_BULK_CMD				(0xC7)
#define ERASE_BULK_DUMMY			(0)

/*******************************************************************************
 * Flash ROM Command Info for Macronix ISSI base on MX25K25645G IS25LP256D
 * ****************************************************************************/
#define ENABLE_4BYTE_FOR_MX25L_CMD		(0xB7)
#define ENABLE_4BYTE_FOR_MX25L_BYTES	(0)
#define DISABLE_4BYTE_FOR_MX25L_CMD 	(0xE9) // Macronix:0xE9, ISSI:0x29
#define DISABLE_4BYTE_FOR_MX25L_BYTES 	(0)

/*******************************************************************************
 * Flash ROM Command Info Other Registers base on MT25QL256
 * ****************************************************************************/
#define READ_VOLA_CONFIG_CMD			(0x85)
#define READ_VOLA_CONFIG_BYTES 			(1)
#define READ_ENHAN_VOLA_CONFIG_CMD		(0x65)
#define READ_ENHAN_VOLA_CONFIG_BYTES	(1)
#define READ_EXTEN_ADD_REG_CMD			(0xC8)
#define READ_EXTEN_ADD_REG_BYTES		(1)
#define READ_GEN_PURPOSE_REG_CMD		(0x96)
#define READ_GEN_PURPOSE_REG_BYTES		(1)
#define READ_SEC_PROTECT_CMD			(0x2D)
#define READ_SEC_PROTECT_BYTES			(1)
#define READ_VOLA_LOCK_BIT_CMD			(0xE8)
#define READ_VOLA_LOCK_BIT_BYTES		(1)
#define READ_NON_VOLA_LOCK_BIT_CMD		(0xE2)
#define READ_VOLA_LOCK_BIT_BYTES		(1)
#define READ_GLOBAL_FREEZE_BIT_CMD		(0xA7)
#define READ_GLOBAL_FREEZE_BIT_BYTES	(1)


/*******************************************************************************
 * GSFI Register Map
 *******************************************************************************/
/*******************************************************************************
 * Control Register
 * - Addressing mode:
 *    0x0: 3-bytes addressing.
 *    0x1: 4-bytes addressing.
 * - Chip select:
 *    0x0: To select first device.
 *    0x1: To select second device.
 *    0x2: To select third device.
 * - Enable:
 *    Set this bit to 0 to disable the output of the IP and put all output signal to high
 *    impedance state. This can be used to share bus with other devices.
 *******************************************************************************/
#define GSFI_CONTROL_REG							(0x0)
#define GSFI_CONTROL_ADDRESSING_MODE_MASK			(0x00000010) //[8]
#define GSFI_CONTROL_ADDRESSING_MODE_BIT			(8)
#define GSFI_CONTROL_CHIP_SELECT_MASK				(0x000000F0) //[7:4]
#define GSFI_CONTROL_CHIP_SELECT_BIT				(4)
#define GSFI_CONTROL_ENABLE_MASK					(0x00000001) //[0]
/*******************************************************************************
 * SPI Clock Baud-rate Register
 * - Baud rate divisor:
 *      0x1  : /2
 *      0x2  : /4
 *      ...
 *      0xF  : /30
 *      0x10 : /32
 ******************************************************************************/
#define GSFI_SPI_CLOCK_REG							(0x1)
#define GSFI_SPI_CLOCK_BAUD_RATE_MASK				(0x0000001F) //[4:0]
/*******************************************************************************
 * CS Delay Setting Register
 * - tSHSL:
 *     0: tSHSL is 3 IP_CLK.
 *     n: tSHSL is 3+n IP_CLK.
 * - CS de-assert:
 *     0: Chip select is de-asserted at the last falling edge of SCLK.
 *     n: Chip select is de-asserted n number of clocks after the last falling edge of SCLK.
 * - CS assert:
 *     0: Chip select is asserted half flash clock period before the first rising edge of SCLK.
 *     n: Chip select is asserted half flash clock period plus n number of IP_CLK.
 *******************************************************************************/
#define GSFI_CS_DELAY_REG							(0x2)
#define GSFI_CS_DELAY_TSHSL_MASK					(0x00000F00) //[11:8]
#define GSFI_CS_DELAY_TSHSL_BIT						(8)
#define GSFI_CS_DELAY_CS_DE_ASSERT_MASK				(0x000000F0) //[7:4]
#define GSFI_CS_DELAY_CS_DE_ASSERT_BIT				(4)
#define GSFI_CS_DELAY_CS_ASSERT_MASK				(0x0000000F) //[3:0]
/*******************************************************************************
 * Read Capturing Register
 * - Read delay:
 *   The clock to output timing of the flash plus the board trace, I/O pin timing can
 *   contribute to high value of delay to the data arriving at the IP logic. The delay
 *   capture provides a way for the IP to delay its reading logic to compensate for those delays.
 *   Delay the read data logic by a value of the IP_CLK cycles.
 ******************************************************************************/
#define GSFI_READ_CAP_REG							(0x3)
#define GSFI_READ_CAP_READ_DELAY_MASK				(0x0000000F) //[3:0]
/*******************************************************************************
 * Operating Protocols Setting Register
 *    0x0: Standard SPI mode command input is sent on DQ0.
 *    0x1: Dual I/O mode command input is sent on DQ[1:0].
 *    0x2: Quad I/O mode
 * - Read data out transfer mode	: Transfer mode for read data output.
 * - Read address transfer mode		: Transfer mode for read address input Description as bit 1:0.
 * - Write Data in transfer mode	: Transfer mode for write data input Description as bit 1:0.
 * - Write address transfer mode	: Transfer mode for write address input Description as bit 1:0.
 *  - Instruction transfer mode		: Transfer mode for opcode:
 ******************************************************************************/
#define GSFI_OPERATE_PROTCOL_REG					(0x4)
#define GSFI_OPERATE_PROTCOL_READ_DATA_MASK			(0x00030000) //[17:16]
#define GSFI_OPERATE_PROTCOL_READ_DATA_BIT			(16)
#define GSFI_OPERATE_PROTCOL_READ_ADD_MASK			(0x00003000) //[13:12]
#define GSFI_OPERATE_PROTCOL_READ_ADD_BIT			(12)
#define GSFI_OPERATE_PROTCOL_WRITE_DATA_MASK		(0x00000300) //[9:8]
#define GSFI_OPERATE_PROTCOL_WRITE_DATA_BIT			(8)
#define GSFI_OPERATE_PROTCOL_WRITE_ADD_MASK			(0x00000030) //[5:4]
#define GSFI_OPERATE_PROTCOL_WRITE_ADD_BIT			(4)
#define GSFI_OPERATE_PROTCOL_INST_MASK				(0x00000003) //[1:0]
/*******************************************************************************
 * Read Instruction Register
 * - Dummy cycles:
 *      Number of default dummy cycles used for read operation. Refer to the respective flash device datasheet.
 * - Read opcode:
 *      The opcode for read operation. Refer to the respective flash device datasheet to
 *       select the correct opcode according to the transfer mode setting.
 ******************************************************************************/
#define GSFI_READ_INST_REG							(0x5)
#define GSFI_READ_INST_DUMMY_CYCLE_MASK				(0x00001F00) //[12:8]
#define GSFI_READ_INST_DUMMY_CYCLE_BIT				(8)
#define GSFI_READ_INST_READ_OPECODE_MASK			(0x000000FF) //[7:0]
/*******************************************************************************
 * Write Instruction Register
 * - Polling opcode:
 *      The opcode to check if the write operation has been completed. After write operation
 *      is completed, the IP releases the wait request of the Avalon memory-mapped interface.
 *      In applicable devices, you can set as the status register or flag status register.
 * - Write opcode:
 *      The opcode for write operation. Refer to the respective flash device datasheet to
 *      select the correct opcode according to the transfer mode setting.
 * *******************************************************************************/
#define GSFI_WRITE_INST_REG							(0x6)
#define GSFI_WRITE_INST_POLLING_OPECODE_MASK		(0x0000FF00) //[15:8]
#define GSFI_WRITE_INST_POLLING_OPECODE_BIT			(8)
#define GSFI_WRITE_INST_WRITE_OPECODE_MASK			(0x000000FF) //[7:0]
/*******************************************************************************
 * Flash Command Setting Register
 * - Number of dummy cycles:
 *      The number of dummy cycles. Set to 0 when the operation does not require any
 *      dummy cycles. Refer to the respective flash device datasheet for dummy clock requirements.
 * - Number of data bytes:
 *      The number of write or read data. This works together with bit 11. If the value is
 *      Set to 0 if the operation has no write or read data, for example, write enable.
 * - Data type:
 *      Indicates the type of data (bit [15:12]).
 *        0: Number of byte declared in [15:12] is write data to flash device
 *        1: Number of byte declared in [15:12] is read data from flash device
 * - Number of address bytes:
 *      Number of address bytes to send to the flash device. Either 3 or 4 bytes
 *      If this is set to zero then the operation does not carry any address byte.
 * - Opcode:
 *       The opcode of the operation.
 ********************************************************************************/
#define GSFI_CMD_SET_REG							(0x7)
#define GSFI_CMD_SET_NUM_DUMMY_CYCLE_MASK			(0x001F0000) //[20:16]
#define GSFI_CMD_SET_NUM_DUMMY_CYCLE_BIT			(16)
#define GSFI_CMD_SET_NUM_DATA_BYTES_MASK			(0x0000F000) //[15:12]
#define GSFI_CMD_SET_NUM_DATA_BYTES_BIT				(12)
#define GSFI_CMD_SET_DATA_TYPE_MASK					(0x00000800) //[11]
#define GSFI_CMD_SET_DATA_TYPE_BIT					(11)
#define GSFI_CMD_SET_NUM_ADD_BYTES_MASK				(0x00000700) //[10:8]
#define GSFI_CMD_SET_NUM_ADD_BYTES_BIT				(8)
#define GSFI_CMD_SET_OPECODE_MASK					(0x000000FF) //[7:0]
/*******************************************************************************
 * Flash Command Register
 * - Start						: Write 1 to this bit to start the operation.
 * - Stating address			: Address of flash command.
 * - Lower 4 bytes write data	: The first 4-byte of write data to flash device.
 * - Upper 4 bytes write data	: The last 4-byte of write data to the flash device.
 * - Lower 4 bytes read data	: The first 4-byte of read data from flash device.
 * - Upper 4 bytes read data 	: The last 4-byte of read data from the flash device.
 * *****************************************************************************/
#define GSFI_CMD_CONTROL_REG						(0x8)
#define GSFI_CMD_CONTROL_START_MASK					(0x00000001) //[0]
#define GSFI_CMD_ADD_REG							(0x9)
#define GSFI_CMD_WRITE_DATA0_REG					(0xA)
#define GSFI_CMD_WRITE_DATA1_REG					(0xB)
#define GSFI_CMD_READ_DATA0_REG						(0xC)
#define GSFI_CMD_READ_DATA1_REG						(0xD)

typedef struct gsfi_flash_info
{
	alt_u32 flash_rom;
	alt_u32 sector_size;
	alt_u32 subsector_size;
	alt_u32 number_of_sector;
	alt_u32 addressing_mode;
	alt_u32 gsfi_csr_base;
	alt_u32 gsfi_mem_base;
	alt_u32 gsfi_csr_span;
	alt_u32 gsfi_mem_span;
	alt_u32 io_mode;
	alt_u32 data_size;

}gsfi_flash_info;

typedef struct gsfi_flash_const
{
	alt_u32 flash_rom;
	alt_u32 sector_size;
	alt_u32 subsector_size;
	alt_u32 number_of_sector;
	alt_u32 addressing_mode;

}gsfi_flash_const;

int flash_info_init(gsfi_flash_info *flash_info, alt_u32 gsfi_csr_base, alt_u32 gsfi_mem_base, alt_u32 gsfi_mem_span, alt_u32 gsfi_csr_span, alt_u32 io_mode, alt_u32 data_size);
int change_clock_rate(gsfi_flash_info *flash_info, alt_u32 clock_rate);
int change_io_mode(gsfi_flash_info *flash_info, alt_u32 io_mode_id);
int read_various_register(gsfi_flash_info *flash_info, alt_u32 cmd, alt_u32 num_data_bytes);
int read_device_id(gsfi_flash_info *flash_info);
int read_status_register(gsfi_flash_info *flash_info);
int read_flag_status_register(gsfi_flash_info *flash_info);
int read_config_register(gsfi_flash_info *flash_info);
int write_various_register(gsfi_flash_info *flash_info, alt_u32 cmd, alt_u32 num_data_bytes, alt_u32 write_data);
void write_enable(gsfi_flash_info *flash_info);
int write_status_reg(gsfi_flash_info *flash_info, alt_u32 write_data);
void enable_4byte_for_mx25L(gsfi_flash_info *flash_info);
void disable_4byte_for_mx25L(gsfi_flash_info *flash_info);
int write_sector_protect(gsfi_flash_info *flash_info, alt_u32 sector_lock_id);
int poll_for_write_in_progress(gsfi_flash_info *flash_info);
int validate_write_sector_arguments(gsfi_flash_info *flash_info, alt_u32 offset, alt_u32 length);
int erase_sector(gsfi_flash_info *flash_info, int sector_offset);
int read_memory(gsfi_flash_info *flash_info, void *dest_addr, alt_u32 offset, alt_u32 length);
int write_memory(gsfi_flash_info *flash_info, const void *data_addr, alt_u32 write_offset, alt_u32 length);
