OUTPUT_FORMAT("elf32-littlearm", "elf32-bigarm", "elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY(_socfpga_main)

MEMORY
{
  boot_rom (rx) : ORIGIN = 0xfffd0000, LENGTH = 64K
  oc_ram (rwx) : ORIGIN = 0xffff0000, LENGTH = 64K
  ram_common0 (rwx) : ORIGIN = 0x00000000, LENGTH = 2M
  ram (rwx)         : ORIGIN = 0x00200000, LENGTH = 254M
  ram_common1 (rwx) : ORIGIN = 0x10000000, LENGTH = 256M
  ram_common2 (rwx) : ORIGIN = 0x20000000, LENGTH = 128M
  ram_common3 (rwx) : ORIGIN = 0x28000000, LENGTH = 128M
  ram_common4 (rwx) : ORIGIN = 0x30000000, LENGTH = 256M
}

SECTIONS
{
  .common0_region (NOLOAD):
  {
    *(.common0_region .common0_region.*)
  } >ram_common0
  
  .common1_region (NOLOAD):
  {
    *(.common1_region .common1_region.*)
  } >ram_common1
  
  .common2_region (NOLOAD):
  {
    *(.common2_region .common2_region.*)
  } >ram_common2
  
  .common3_region (NOLOAD):
  {
    *(.common3_region .common3_region.*)
  } >ram_common3
  
  .common4_region (NOLOAD):
  {
    *(.common4_region .common4_region.*)
  } >ram_common4
  
  /* .reserved_for_headerinfo (NOLOAD):
  {
    . = 0x40;
  } >ram */
  
  .vector : 
  {
    */alt_interrupt.o (.vectors*)
    */alt_base.o (.vectors*)
    * (.vectors*)
  } >ram
  .interp     : { *(.interp) 	} >ram
  .hash          : { *(.hash)		} >ram
  .dynsym        : { *(.dynsym)		} >ram
  .dynstr        : { *(.dynstr)		} >ram
  .gnu.version   : { *(.gnu.version)	} >ram
  .gnu.version_d   : { *(.gnu.version_d)	} >ram
  .gnu.version_r   : { *(.gnu.version_r)	} >ram
  .rel.init      : { *(.rel.init)	} >ram
  .rela.init     : { *(.rela.init)	} >ram
  .rel.text      :
    {
      *(.rel.text)
      *(.rel.text.*)
      *(.rel.gnu.linkonce.t*)
    } >ram
  .rela.text     :
    {
      *(.rela.text)
      *(.rela.text.*)
      *(.rela.gnu.linkonce.t*)
    } >ram
  .rel.fini      : { *(.rel.fini)	} >ram
  .rela.fini     : { *(.rela.fini)	} >ram
  .rel.rodata    :
    {
      *(.rel.rodata)
      *(.rel.rodata.*)
      *(.rel.gnu.linkonce.r*)
    } >ram
  .rela.rodata   :
    {
      *(.rela.rodata)
      *(.rela.rodata.*)
      *(.rela.gnu.linkonce.r*)
    } >ram
  .rel.data      :
    {
      *(.rel.data)
      *(.rel.data.*)
      *(.rel.gnu.linkonce.d*)
    } >ram
  .rela.data     :
    {
      *(.rela.data)
      *(.rela.data.*)
      *(.rela.gnu.linkonce.d*)
    } >ram
  .rel.ctors     : { *(.rel.ctors)	} >ram
  .rela.ctors    : { *(.rela.ctors)	} >ram
  .rel.dtors     : { *(.rel.dtors)	} >ram
  .rela.dtors    : { *(.rela.dtors)	} >ram
  .rel.got       : { *(.rel.got)		} >ram
  .rela.got      : { *(.rela.got)		} >ram
  .rel.sdata     :
    {
      *(.rel.sdata)
      *(.rel.sdata.*)
      *(.rel.gnu.linkonce.s*)
    } >ram
  .rela.sdata     :
    {
      *(.rela.sdata)
      *(.rela.sdata.*)
      *(.rela.gnu.linkonce.s*)
    } >ram
  .rel.sbss      : { *(.rel.sbss)		} >ram
  .rela.sbss     : { *(.rela.sbss)	} >ram
  .rel.bss       : { *(.rel.bss)		} >ram
  .rela.bss      : { *(.rela.bss)		} >ram
  .rel.plt       : { *(.rel.plt)		} >ram
  .rela.plt      : { *(.rela.plt)		} >ram
  .plt      : { *(.plt)	} >ram
  .text      :
  {
    *(.text)
    *(.text.*)
    *(.stub)
    /* .gnu.warning sections are handled specially by elf32.em.  */
    *(.gnu.warning)
    *(.gnu.linkonce.t*)
    *(.glue_7t) *(.glue_7)
  } >ram
  .init          : 
  { 
    KEEP (*(.init))
  } >ram
  _etext = .;
  PROVIDE (etext = .);
  .fini      :
  {
    KEEP (*(.fini))
  } >ram
  .rodata   : { *(.rodata) *(.rodata.*) *(.gnu.linkonce.r*) } >ram
  .rodata1   : { *(.rodata1) } >ram
  .eh_frame_hdr : { *(.eh_frame_hdr) } >ram
  /* Adjust the address for the data segment.  We want to adjust up to
     the same address within the page on the next page up.  */
  . = ALIGN(256) + (. & (256 - 1));
  .data    :
  {
    *(.data)
    *(.data.*)
    *(.gnu.linkonce.d*)
    SORT(CONSTRUCTORS)
  } >ram
  .data1   : { *(.data1) } >ram
  .eh_frame : { KEEP (*(.eh_frame)) } >ram
  .gcc_except_table : { *(.gcc_except_table) } >ram
  .ctors   : 
  {
    /* gcc uses crtbegin.o to find the start of
       the constructors, so we make sure it is
       first.  Because this is a wildcard, it
       doesn't matter if the user does not
       actually link against crtbegin.o; the
       linker won't look for a file to match a
       wildcard.  The wildcard also means that it
       doesn't matter which directory crtbegin.o
       is in.  */
    KEEP (*crtbegin.o(.ctors))
    /* We don't want to include the .ctor section from
       from the crtend.o file until after the sorted ctors.
       The .ctor section from the crtend file contains the
       end of ctors marker and it must be last */
    KEEP (*(EXCLUDE_FILE (*crtend.o ) .ctors))
    KEEP (*(SORT(.ctors.*)))
    KEEP (*(.ctors))
  } >ram
   .dtors         :
  {
    KEEP (*crtbegin.o(.dtors))
    KEEP (*(EXCLUDE_FILE (*crtend.o ) .dtors))
    KEEP (*(SORT(.dtors.*)))
    KEEP (*(.dtors))
  } >ram
  .jcr            : { KEEP (*(.jcr)) } >ram
  .got           : { *(.got.plt) *(.got) } >ram
  .dynamic       : { *(.dynamic) } >ram
  /* We want the small data sections together, so single-instruction offsets
     can access them all, and initialized data all before uninitialized, so
     we can shorten the on-disk segment size.  */
  .sdata     : 
  {
    *(.sdata) 
    *(.sdata.*)
    *(.gnu.linkonce.s.*)
  } >ram
  _edata = .;
  PROVIDE (edata = .);
  __bss_start = .;
  __bss_start__ = .;
  .sbss      :
  {
    *(.dynsbss)
    *(.sbss)
    *(.sbss.*)
    *(.scommon)
  } >ram
  .bss       :
  {
   *(.dynbss)
   *(.bss)
   *(.bss.*)
   *(COMMON)
   /* Align here to ensure that the .bss section occupies space up to
      _end.  Align after .bss to ensure correct alignment even if the
      .bss section disappears because there are no input sections.  */
   . = ALIGN(32 / 8);
  } >ram
  . = ALIGN(32 / 8);
  _end = .;
  _bss_end__ = . ; __bss_end__ = . ; __end__ = . ;
  PROVIDE (end = .);
  /* Stabs debugging sections.  */
  .stab 0 : { *(.stab) } >ram
  .stabstr 0 : { *(.stabstr) } >ram
  .stab.excl 0 : { *(.stab.excl) } >ram
  .stab.exclstr 0 : { *(.stab.exclstr) } >ram
  .stab.index 0 : { *(.stab.index) } >ram
  .stab.indexstr 0 : { *(.stab.indexstr) } >ram
  .comment 0 : { *(.comment) } >ram

  /* DWARF debug sections.
     Symbols in the DWARF debugging sections are relative to the beginning
     of the section so we begin them at 0.  */
  /* DWARF 1 */
  .debug          0 : { *(.debug) }
  .line           0 : { *(.line) }
  /* GNU DWARF 1 extensions */
  .debug_srcinfo  0 : { *(.debug_srcinfo) }
  .debug_sfnames  0 : { *(.debug_sfnames) }
  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }
  /* DWARF 2 */
  .debug_info     0 : { *(.debug_info) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }
  .debug_ranges   0 : { *(.debug_ranges) }
  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : { *(.debug_weaknames) }
  .debug_funcnames 0 : { *(.debug_funcnames) }
  .debug_typenames 0 : { *(.debug_typenames) }
  .debug_varnames  0 : { *(.debug_varnames) }
  .stack 0x80000 : { _stack = .; *(.stack) }
  /* These must appear regardless of  .  */
}
