/******************************************************************************
 *
 * Copyright 2017 Altera Corporation. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors
 * may be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************/
/*! \file
 *  Contains S10 register translations for the Altera Hardware Libraries Ethernet
 *  Application Programming Interface
 *  ALTX_ register names will be used in the code and will remain constant for all chips.
 */

#ifndef __ALTX_ETHERNET_H__
#define __ALTX_ETHERNET_H__

#ifdef __cplusplus
extern "C"
{
#endif  /* __cplusplus */

#define ALTX_EMAC_GMACGRP_GMII_ADDRESS_PA_SET                           ALT_EMAC_GMAC_GMII_ADDR_PA_SET
#define ALTX_EMAC_GMACGRP_GMII_ADDRESS_GR_SET                           ALT_EMAC_GMAC_GMII_ADDR_GR_SET
#define ALTX_EMAC_GMACGRP_GMII_ADDRESS_GW_CLR_MSK                       ALT_EMAC_GMAC_GMII_ADDR_GW_CLR_MSK
#define ALTX_EMAC_GMACGRP_GMII_ADDRESS_GW_SET_MSK                       ALT_EMAC_GMAC_GMII_ADDR_GW_SET_MSK
#define ALTX_EMAC_GMACGRP_GMII_ADDRESS_CR_SET                           ALT_EMAC_GMAC_GMII_ADDR_CR_SET
#define ALTX_EMAC_GMACGRP_GMII_ADDRESS_CR_E_DIV102                      ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV102
#define ALTX_EMAC_GMACGRP_GMII_ADDRESS_GB_SET                           ALT_EMAC_GMAC_GMII_ADDR_GB_SET
#define ALTX_EMAC_GMACGRP_GMII_ADDRESS_GB_SET_MSK                       ALT_EMAC_GMAC_GMII_ADDR_GB_SET_MSK
#define ALTX_EMAC_GMACGRP_GMII_ADDRESS_ADDR                             ALT_EMAC_GMAC_GMII_ADDR_ADDR
#define ALTX_EMAC_GMACGRP_GMII_DATA_ADDR                                ALT_EMAC_GMAC_GMII_DATA_ADDR

#define ALTX_SYSMGR_CORE_EMAC0_ADDR                                     ALT_SYSMGR_EMAC_ADDR
#define ALTX_SYSMGR_CORE_EMAC1_ADDR                                     ALT_SYSMGR_EMAC_ADDR
#define ALTX_SYSMGR_CORE_FPGAINTF_EN_3_EMAC_0_SET_MSK                   ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0_SET_MSK
#define ALTX_SYSMGR_CORE_FPGAINTF_EN_3_EMAC_1_SET_MSK                   ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1_SET_MSK
#define ALTX_SYSMGR_CORE_EMAC0_PHY_INTF_SEL_SET_MSK                     ALT_SYSMGR_EMAC_CTL_PHYSEL_0_SET_MSK
#define ALTX_SYSMGR_CORE_EMAC1_PHY_INTF_SEL_SET_MSK                     ALT_SYSMGR_EMAC_CTL_PHYSEL_1_SET_MSK
#define ALTX_SYSMGR_CORE_EMAC0_PHY_INTF_SEL_E_RGMII                     ALT_SYSMGR_EMAC_CTL_PHYSEL_0_SET(ALT_SYSMGR_EMAC_CTL_PHYSEL_0_E_RGMII)
#define ALTX_SYSMGR_CORE_EMAC1_PHY_INTF_SEL_E_RGMII                     ALT_SYSMGR_EMAC_CTL_PHYSEL_1_SET(ALT_SYSMGR_EMAC_CTL_PHYSEL_1_E_RGMII)
#define ALTX_SYSMGR_CORE_FPGAINTF_EN_3_ADDR                             ALT_SYSMGR_FPGAINTF_MODULE_ADDR
 
#define ALTX_EMAC_DMAGRP_AHB_OR_AXI_STATUS_ADDR                         ALT_EMAC_DMA_AHB_OR_AXI_STAT_ADDR
#define ALTX_EMAC_DMAGRP_BUS_MODE_AAL_SET_MSK                           ALT_EMAC_DMA_BUS_MOD_AAL_SET_MSK
#define ALTX_EMAC_DMAGRP_BUS_MODE_ADDR                                  ALT_EMAC_DMA_BUS_MOD_ADDR
#define ALTX_EMAC_DMAGRP_BUS_MODE_ATDS_SET_MSK                          ALT_EMAC_DMA_BUS_MOD_ATDS_SET_MSK
#define ALTX_EMAC_DMAGRP_BUS_MODE_EIGHTXPBL_SET                         ALT_EMAC_DMA_BUS_MOD_EIGHTXPBL_SET
#define ALTX_EMAC_DMAGRP_BUS_MODE_FB_SET_MSK                            ALT_EMAC_DMA_BUS_MOD_FB_SET_MSK
#define ALTX_EMAC_DMAGRP_BUS_MODE_PBL_SET                               ALT_EMAC_DMA_BUS_MOD_PBL_SET
#define ALTX_EMAC_DMAGRP_BUS_MODE_RPBL_SET                              ALT_EMAC_DMA_BUS_MOD_RPBL_SET
#define ALTX_EMAC_DMAGRP_BUS_MODE_SWR_GET                               ALT_EMAC_DMA_BUS_MOD_SWR_GET
#define ALTX_EMAC_DMAGRP_BUS_MODE_SWR_SET_MSK                           ALT_EMAC_DMA_BUS_MOD_SWR_SET_MSK
#define ALTX_EMAC_DMAGRP_BUS_MODE_USP_SET_MSK                           ALT_EMAC_DMA_BUS_MOD_USP_SET_MSK
#define ALTX_EMAC_DMAGRP_CURRENT_HOST_RECEIVE_BUFFER_ADDRESS_ADDR       ALT_EMAC_DMA_CUR_HOST_RX_BUF_ADDR_ADDR
#define ALTX_EMAC_DMAGRP_CURRENT_HOST_RECEIVE_DESCRIPTOR_ADDR           ALT_EMAC_DMA_CUR_HOST_RX_DESC_ADDR
#define ALTX_EMAC_DMAGRP_CURRENT_HOST_TRANSMIT_BUFFER_ADDRESS_ADDR      ALT_EMAC_DMA_CUR_HOST_TX_BUF_ADDR_ADDR
#define ALTX_EMAC_DMAGRP_CURRENT_HOST_TRANSMIT_DESCRIPTOR_ADDR          ALT_EMAC_DMA_CUR_HOST_TX_DESC_ADDR
#define ALTX_EMAC_DMAGRP_INTERRUPT_ENABLE_ADDR                          ALT_EMAC_DMA_INT_EN_ADDR
#define ALTX_EMAC_DMAGRP_INTERRUPT_ENABLE_NIE_SET_MSK                   ALT_EMAC_DMA_INT_EN_NIE_SET_MSK
#define ALTX_EMAC_DMAGRP_INTERRUPT_ENABLE_TUE_SET_MSK                   ALT_EMAC_DMA_INT_EN_TUE_SET_MSK
#define ALTX_EMAC_DMAGRP_INTERRUPT_ENABLE_AIE_SET_MSK                   ALT_EMAC_DMA_INT_EN_AIE_SET_MSK
#define ALTX_EMAC_DMAGRP_INTERRUPT_ENABLE_ERE_SET_MSK                   ALT_EMAC_DMA_INT_EN_ERE_SET_MSK
#define ALTX_EMAC_DMAGRP_INTERRUPT_ENABLE_ETE_SET_MSK                   ALT_EMAC_DMA_INT_EN_ETE_SET_MSK
#define ALTX_EMAC_DMAGRP_INTERRUPT_ENABLE_FBE_SET_MSK                   ALT_EMAC_DMA_INT_EN_FBE_SET_MSK
#define ALTX_EMAC_DMAGRP_INTERRUPT_ENABLE_OVE_SET_MSK                   ALT_EMAC_DMA_INT_EN_OVE_SET_MSK
#define ALTX_EMAC_DMAGRP_INTERRUPT_ENABLE_RIE_SET_MSK                   ALT_EMAC_DMA_INT_EN_RIE_SET_MSK
#define ALTX_EMAC_DMAGRP_INTERRUPT_ENABLE_RSE_SET_MSK                   ALT_EMAC_DMA_INT_EN_RSE_SET_MSK
#define ALTX_EMAC_DMAGRP_INTERRUPT_ENABLE_RUE_SET_MSK                   ALT_EMAC_DMA_INT_EN_RUE_SET_MSK
#define ALTX_EMAC_DMAGRP_INTERRUPT_ENABLE_RWE_SET_MSK                   ALT_EMAC_DMA_INT_EN_RWE_SET_MSK
#define ALTX_EMAC_DMAGRP_INTERRUPT_ENABLE_TIE_SET_MSK                   ALT_EMAC_DMA_INT_EN_TIE_SET_MSK
#define ALTX_EMAC_DMAGRP_INTERRUPT_ENABLE_TJE_SET_MSK                   ALT_EMAC_DMA_INT_EN_TJE_SET_MSK
#define ALTX_EMAC_DMAGRP_INTERRUPT_ENABLE_TSE_SET_MSK                   ALT_EMAC_DMA_INT_EN_TSE_SET_MSK
#define ALTX_EMAC_DMAGRP_INTERRUPT_ENABLE_UNE_SET_MSK                   ALT_EMAC_DMA_INT_EN_UNE_SET_MSK
#define ALTX_EMAC_DMAGRP_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_ADDR  ALT_EMAC_DMA_MFRM_BUF_OVF_CNTR_ADDR
#define ALTX_EMAC_DMAGRP_OPERATION_MODE_ADDR                            ALT_EMAC_DMA_OP_MOD_ADDR
#define ALTX_EMAC_DMAGRP_OPERATION_MODE_FTF_GET                         ALT_EMAC_DMA_OP_MOD_FTF_GET
#define ALTX_EMAC_DMAGRP_OPERATION_MODE_FTF_SET_MSK                     ALT_EMAC_DMA_OP_MOD_FTF_SET_MSK
#define ALTX_EMAC_DMAGRP_OPERATION_MODE_OSF_SET_MSK                     ALT_EMAC_DMA_OP_MOD_OSF_SET_MSK
#define ALTX_EMAC_DMAGRP_OPERATION_MODE_RSF_SET_MSK                     ALT_EMAC_DMA_OP_MOD_RSF_SET_MSK
#define ALTX_EMAC_DMAGRP_OPERATION_MODE_SR_SET_MSK                      ALT_EMAC_DMA_OP_MOD_SR_SET_MSK
#define ALTX_EMAC_DMAGRP_OPERATION_MODE_ST_SET_MSK                      ALT_EMAC_DMA_OP_MOD_ST_SET_MSK
#define ALTX_EMAC_DMAGRP_OPERATION_MODE_TSF_SET_MSK                     ALT_EMAC_DMA_OP_MOD_TSF_SET_MSK
#define ALTX_EMAC_DMAGRP_RECEIVE_DESCRIPTOR_LIST_ADDRESS_ADDR           ALT_EMAC_DMA_RX_DESC_LIST_ADDR_ADDR
#define ALTX_EMAC_DMAGRP_RECEIVE_POLL_DEMAND_ADDR                       ALT_EMAC_DMA_RX_POLL_DEMAND_ADDR
#define ALTX_EMAC_DMAGRP_STATUS_ADDR                                    ALT_EMAC_DMA_STAT_ADDR
#define ALTX_EMAC_DMAGRP_STATUS_OVF_SET_MSK                             ALT_EMAC_DMA_STAT_OVF_SET_MSK
#define ALTX_EMAC_DMAGRP_STATUS_RS_SET_MSK                              ALT_EMAC_DMA_STAT_RS_SET_MSK
#define ALTX_EMAC_DMAGRP_STATUS_RU_SET_MSK                              ALT_EMAC_DMA_STAT_RU_SET_MSK
#define ALTX_EMAC_DMAGRP_STATUS_TS_SET_MSK                              ALT_EMAC_DMA_STAT_TS_SET_MSK
#define ALTX_EMAC_DMAGRP_TRANSMIT_DESCRIPTOR_LIST_ADDRESS_ADDR          ALT_EMAC_DMA_TX_DESC_LIST_ADDR_ADDR
#define ALTX_EMAC_DMAGRP_TRANSMIT_POLL_DEMAND_ADDR                      ALT_EMAC_DMA_TX_POLL_DEMAND_ADDR

#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_IPC_SET_MSK                 ALT_EMAC_GMAC_MAC_CFG_IPC_SET_MSK
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_JD_SET_MSK                  ALT_EMAC_GMAC_MAC_CFG_JD_SET_MSK
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_PS_SET_MSK                  ALT_EMAC_GMAC_MAC_CFG_PS_SET_MSK
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_BE_SET_MSK                  ALT_EMAC_GMAC_MAC_CFG_BE_SET_MSK
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_WD_SET_MSK                  ALT_EMAC_GMAC_MAC_CFG_WD_SET_MSK
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_DO_SET_MSK                  ALT_EMAC_GMAC_MAC_CFG_DO_SET_MSK
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_DM_SET_MSK                  ALT_EMAC_GMAC_MAC_CFG_DM_SET_MSK
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_FES_SET_MSK                 ALT_EMAC_GMAC_MAC_CFG_FES_SET_MSK
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_PS_SET_MSK                  ALT_EMAC_GMAC_MAC_CFG_PS_SET_MSK
#define ALTX_EMAC_GMACGRP_INTERRUPT_STATUS_LPIIS_SET_MSK                ALT_EMAC_GMAC_INT_STAT_LPIIS_SET_MSK
#define ALTX_EMAC_GMACGRP_INTERRUPT_STATUS_TSIS_SET_MSK                 ALT_EMAC_GMAC_INT_STAT_TSIS_SET_MSK
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_ADDR                        ALT_EMAC_GMAC_MAC_CFG_ADDR
#define ALTX_EMAC_GMACGRP_MAC_FRAME_FILTER_ADDR                         ALT_EMAC_GMAC_MAC_FRM_FLT_ADDR
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_ADDR                        ALT_EMAC_GMAC_MAC_CFG_ADDR
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_TE_SET_MSK                  ALT_EMAC_GMAC_MAC_CFG_TE_SET_MSK
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_ADDR                        ALT_EMAC_GMAC_MAC_CFG_ADDR
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_TE_SET_MSK                  ALT_EMAC_GMAC_MAC_CFG_TE_SET_MSK
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_ADDR                        ALT_EMAC_GMAC_MAC_CFG_ADDR
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_RE_SET_MSK                  ALT_EMAC_GMAC_MAC_CFG_RE_SET_MSK
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_ADDR                        ALT_EMAC_GMAC_MAC_CFG_ADDR
#define ALTX_EMAC_GMACGRP_MAC_CONFIGURATION_RE_SET_MSK                  ALT_EMAC_GMAC_MAC_CFG_RE_SET_MSK
#define ALTX_EMAC_GMACGRP_FLOW_CONTROL_FCA_BPA_GET                      ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_GET
#define ALTX_EMAC_GMACGRP_FLOW_CONTROL_ADDR                             ALT_EMAC_GMAC_FLOW_CTL_ADDR
#define ALTX_EMAC_GMACGRP_FLOW_CONTROL_ADDR                             ALT_EMAC_GMAC_FLOW_CTL_ADDR
#define ALTX_EMAC_GMACGRP_FLOW_CONTROL_FCA_BPA_SET_MSK                  ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_SET_MSK
#define ALTX_EMAC_GMACGRP_SGMII_RGMII_SMII_CONTROL_STATUS_LNKSTS_GET    ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_GET
#define ALTX_EMAC_GMACGRP_SGMII_RGMII_SMII_CONTROL_STATUS_ADDR          ALT_EMAC_GMAC_MII_CTL_STAT_ADDR
#define ALTX_EMAC_GMACGRP_FLOW_CONTROL_ADDR                             ALT_EMAC_GMAC_FLOW_CTL_ADDR
#define ALTX_EMAC_GMACGRP_FLOW_CONTROL_FCA_BPA_SET_MSK                  ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_SET_MSK
#define ALTX_EMAC_GMACGRP_FLOW_CONTROL_ADDR                             ALT_EMAC_GMAC_FLOW_CTL_ADDR
#define ALTX_EMAC_GMACGRP_FLOW_CONTROL_FCA_BPA_SET_MSK                  ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_SET_MSK
#define ALTX_EMAC_GMACGRP_INTERRUPT_STATUS_ADDR                         ALT_EMAC_GMAC_INT_STAT_ADDR
#define ALTX_EMAC_GMACGRP_INTERRUPT_STATUS_ADDR                         ALT_EMAC_GMAC_INT_STAT_ADDR
#define ALTX_EMAC_GMACGRP_INTERRUPT_MASK_ADDR                           ALT_EMAC_GMAC_INT_MSK_ADDR
#define ALTX_EMAC_GMACGRP_INTERRUPT_MASK_ADDR                           ALT_EMAC_GMAC_INT_MSK_ADDR
#define ALTX_EMAC_GMACGRP_MAC_ADDRESS0_HIGH_ADDR                        ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDR
#define ALTX_EMAC_GMACGRP_MAC_ADDRESS0_LOW_ADDR                         ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDR
#define ALTX_EMAC_GMACGRP_MAC_ADDRESS0_HIGH_ADDR                        ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDR
#define ALTX_EMAC_GMACGRP_MAC_ADDRESS0_LOW_ADDR                         ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDR
#define ALTX_EMAC_GMACGRP_INTERRUPT_STATUS_RGSMIIIS_SET_MSK             ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_SET_MSK

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif  /* __ALTX_ETHERNET_H__ */
