#ifndef __IO_H__
#define __IO_H__

#include "socal/socal.h"

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

#ifndef SYSTEM_BUS_WIDTH
#define SYSTEM_BUS_WIDTH (32)
#endif

/* Dynamic bus access functions */

#define __IO_CALC_ADDRESS_DYNAMIC(BASE, OFFSET) \
  ((void *)(((uint8_t*)BASE) + (OFFSET)))

#define IORD_32DIRECT(BASE, OFFSET) \
  alt_read_word (__IO_CALC_ADDRESS_DYNAMIC ((BASE), (OFFSET)))

#define IORD_16DIRECT(BASE, OFFSET) \
  alt_read_hword (__IO_CALC_ADDRESS_DYNAMIC ((BASE), (OFFSET)))

#define IORD_8DIRECT(BASE, OFFSET) \
  alt_read_byte (__IO_CALC_ADDRESS_DYNAMIC ((BASE), (OFFSET)))



#define IOWR_32DIRECT(BASE, OFFSET, DATA) \
  alt_write_word (__IO_CALC_ADDRESS_DYNAMIC ((BASE), (OFFSET)), (DATA))

#define IOWR_16DIRECT(BASE, OFFSET, DATA) \
  alt_write_hword (__IO_CALC_ADDRESS_DYNAMIC ((BASE), (OFFSET)), (DATA))

#define IOWR_8DIRECT(BASE, OFFSET, DATA) \
  alt_write_byte (__IO_CALC_ADDRESS_DYNAMIC ((BASE), (OFFSET)), (DATA))


/* Native bus access functions */

#define __IO_CALC_ADDRESS_NATIVE(BASE, REGNUM) \
  ((void *)(((uint8_t*)BASE) + ((REGNUM) * (SYSTEM_BUS_WIDTH/8))))

#define IORD(BASE, REGNUM) \
  alt_read_word (__IO_CALC_ADDRESS_NATIVE ((BASE), (REGNUM)))

#define IOWR(BASE, REGNUM, DATA) \
  alt_write_word (__IO_CALC_ADDRESS_NATIVE ((BASE), (REGNUM)), (DATA))


#ifdef __cplusplus
}
#endif

#endif /* __IO_H__ */
