//*******************************************************************************
// file  m10_adc_oly.v
//
// attention
// Copyright (C) 2018 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS". 
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
//*******************************************************************************
module m10_adc_oly(
	command_valid,
	command_startofpacket,
	command_endofpacket,
	reset_sink_reset_n,
	adc_pll_clock,
	pll_locked,
	clk,
	command_channel,
	command_ready,
	response_valid,
	response_startofpacket,
	response_endofpacket,
	response_channel,
	response_data
);


input wire				command_valid;
input wire				command_startofpacket;
input wire				command_endofpacket;
input wire				reset_sink_reset_n;
input wire				adc_pll_clock;
input wire				pll_locked;
input wire				clk;
input wire	[4:0] 	command_channel;
output wire				command_ready;
output wire				response_valid;
output wire				response_startofpacket;
output wire				response_endofpacket;
output wire	[4:0] 	response_channel;
output wire	[11:0] 	response_data;






adc_core_oly_inst	u0(
	.adc_pll_clock_clk		(adc_pll_clock),
	.adc_pll_locked_export	(pll_locked),
	.clock_clk					(clk),
	.command_valid				(command_valid),
	.command_startofpacket	(command_startofpacket),
	.command_endofpacket		(command_endofpacket),
	.reset_sink_reset_n		(reset_sink_reset_n),
	.command_channel			(command_channel),
	.command_ready				(command_ready),
	.response_valid			(response_valid),
	.response_startofpacket	(response_startofpacket),
	.response_endofpacket	(response_endofpacket),
	.response_channel			(response_channel),
	.response_data				(response_data));


endmodule
