/***********************************************************************************
*                                                                                  *
* Copyright 2013-2015 Altera Corporation. All Rights Reserved.                     *
*                                                                                  *
* Redistribution and use in source and binary forms, with or without               *
* modification, are permitted provided that the following conditions are met:      *
*                                                                                  *
* 1. Redistributions of source code must retain the above copyright notice,        *
*    this list of conditions and the following disclaimer.                         *
*                                                                                  *
* 2. Redistributions in binary form must reproduce the above copyright notice,     *
*    this list of conditions and the following disclaimer in the documentation     *
*    and/or other materials provided with the distribution.                        *
*                                                                                  *
* 3. Neither the name of the copyright holder nor the names of its contributors    *
*    may be used to endorse or promote products derived from this software without *
*    specific prior written permission.                                            *
*                                                                                  *
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"      *
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE        *
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE        *
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR              *
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF             *
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN          *
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)          *
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE       *
* POSSIBILITY OF SUCH DAMAGE.                                                      *
*                                                                                  *
***********************************************************************************/

/* Altera - ALT_USB_GLOB */

#ifndef __ALT_SOCAL_USB_H__
#define __ALT_SOCAL_USB_H__

#ifndef __ASSEMBLY__
#ifdef __cplusplus
#include <cstdint>
extern "C"
{
#else   /* __cplusplus */
#include <stdint.h>
#endif  /* __cplusplus */
#endif  /* __ASSEMBLY__ */

/*
 * Component : ALT_USB_GLOB
 * 
 */
/*
 * Register : gotgctl
 * 
 * OTG Control and Status Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                      
 * :--------|:-------|:------|:----------------------------------
 *  [0]     | R      | 0x0   | ALT_USB_GLOB_GOTGCTL_SESREQSCS   
 *  [1]     | RW     | 0x0   | ALT_USB_GLOB_GOTGCTL_SESREQ      
 *  [2]     | RW     | 0x0   | ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN 
 *  [3]     | RW     | 0x0   | ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL
 *  [4]     | RW     | 0x0   | ALT_USB_GLOB_GOTGCTL_AVALIDOVEN  
 *  [5]     | RW     | 0x0   | ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL 
 *  [6]     | RW     | 0x0   | ALT_USB_GLOB_GOTGCTL_BVALIDOVEN  
 *  [7]     | RW     | 0x0   | ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL 
 *  [8]     | R      | 0x0   | ALT_USB_GLOB_GOTGCTL_HSTNEGSCS   
 *  [9]     | RW     | 0x0   | ALT_USB_GLOB_GOTGCTL_HNPREQ      
 *  [10]    | RW     | 0x0   | ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN 
 *  [11]    | RW     | 0x0   | ALT_USB_GLOB_GOTGCTL_DEVHNPEN    
 *  [13:12] | ???    | 0x0   | *UNDEFINED*                      
 *  [14]    | RW     | 0x0   | ALT_USB_GLOB_GOTGCTL_EHEN        
 *  [15]    | ???    | 0x0   | *UNDEFINED*                      
 *  [16]    | R      | 0x1   | ALT_USB_GLOB_GOTGCTL_CONIDSTS    
 *  [17]    | R      | 0x0   | ALT_USB_GLOB_GOTGCTL_DBNCTIME    
 *  [18]    | R      | 0x0   | ALT_USB_GLOB_GOTGCTL_ASESVLD     
 *  [19]    | R      | 0x0   | ALT_USB_GLOB_GOTGCTL_BSESVLD     
 *  [20]    | RW     | 0x0   | ALT_USB_GLOB_GOTGCTL_OTGVER      
 *  [21]    | R      | 0x0   | ALT_USB_GLOB_GOTGCTL_CURMOD      
 *  [31:22] | ???    | 0x0   | *UNDEFINED*                      
 * 
 */
/*
 * Field : sesreqscs
 * 
 * Mode: Device only
 * 
 * Session Request Success (SesReqScs)
 * 
 * The core sets this bit when a session request initiation is
 * 
 * successful.
 * 
 * 1'b0: Session request failure
 * 
 * 1'b1: Session request success
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description            
 * :-----------------------------------------|:------|:------------------------
 *  ALT_USB_GLOB_GOTGCTL_SESREQSCS_E_FAIL    | 0x0   | Session request failure
 *  ALT_USB_GLOB_GOTGCTL_SESREQSCS_E_SUCCESS | 0x1   | Session request success
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_SESREQSCS
 * 
 * Session request failure
 */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_E_FAIL       0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_SESREQSCS
 * 
 * Session request success
 */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_E_SUCCESS    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_SESREQSCS register field. */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_SESREQSCS register field. */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_MSB        0
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_SESREQSCS register field. */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_SESREQSCS register field value. */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_SESREQSCS register field value. */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_GLOB_GOTGCTL_SESREQSCS register field. */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_SESREQSCS field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_GLOB_GOTGCTL_SESREQSCS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : sesreq
 * 
 * Mode: Device only
 * 
 * Session Request (SesReq)
 * 
 * The application sets this bit to initiate a session request on the
 * 
 * USB. The application can clear this bit by writing a 0 when the
 * 
 * Host Negotiation Success Status Change bit in the OTG
 * 
 * Interrupt register (GOTGINT.HstNegSucStsChng) is SET. The
 * 
 * core clears this bit when the HstNegSucStsChng bit is cleared.
 * 
 * If you use the USB 1.1 Full-Speed Serial Transceiver interface to
 * 
 * initiate the session request, the application must wait until the
 * 
 * VBUS discharges to 0.2 V, after the B-Session Valid bit in this
 * 
 * register (GOTGCTL.BSesVld) is cleared. This discharge time
 * 
 * varies between different PHYs and can be obtained from the
 * 
 * PHY vendor.
 * 
 * 1'b0: No session request
 * 
 * 1'b1: Session request
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description       
 * :----------------------------------------|:------|:-------------------
 *  ALT_USB_GLOB_GOTGCTL_SESREQ_E_NOREQUEST | 0x0   | No session request
 *  ALT_USB_GLOB_GOTGCTL_SESREQ_E_REQUEST   | 0x1   | Session request   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_SESREQ
 * 
 * No session request
 */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_E_NOREQUEST 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_SESREQ
 * 
 * Session request
 */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_E_REQUEST   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_SESREQ register field. */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_SESREQ register field. */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_MSB        1
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_SESREQ register field. */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_SESREQ register field value. */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_SESREQ register field value. */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_GLOB_GOTGCTL_SESREQ register field. */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_SESREQ field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_GLOB_GOTGCTL_SESREQ register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : vbvalidoven
 * 
 * VBUS Valid Override Enable (VbvalidOvEn)
 * 
 * This bit is used to enable/disable the software to
 * 
 * override the Bvalid signal using the GOTGCTL.VbvalidOvVal.
 * 
 * 1'b1 : Internally Bvalid received from the PHY is overridden with
 * GOTGCTL.VbvalidOvVal.
 * 
 * 1'b0 : Override is disabled and bvalid signal from the respective PHY selected
 * is used
 * 
 * internally by the core
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                    
 * :----------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_E_DISD | 0x0   | Override is disabled and bvalid signal from the
 * :                                        |       | respective PHY selected is used internally by  
 * :                                        |       | the force                                      
 *  ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_E_END  | 0x1   | The vbus-valid signal received from the PHY is 
 * :                                        |       | overridden with GOTGCTL.vbvalidOvVal           
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN
 * 
 * Override is disabled and bvalid signal from the respective PHY selected is used
 * internally by the force
 */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN
 * 
 * The vbus-valid signal received from the PHY is overridden with
 * GOTGCTL.vbvalidOvVal
 */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_MSB        2
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : vbvalidovval
 * 
 * VBUS Valid OverrideValue (VbvalidOvVal)
 * 
 * This bit is used to set Override value for vbusvalid
 * 
 * signal when GOTGCTL.VbvalidOvEn is set.
 * 
 * 1'b0 : vbusvalid value is 1'b0 when GOTGCTL.VbvalidOvEn =1
 * 
 * 1'b1 : vbusvalid value is 1'b1 when GOTGCTL.VbvalidOvEn =1
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                  
 * :-----------------------------------------|:------|:----------------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_E_SET0 | 0x0   | vbusvalid value when GOTGCTL.VbvalidOvEn = 1 
 *  ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_E_SET1 | 0x1   | vbusvalid value when GOTGCTL.VbvalidOvEn is 1
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL
 * 
 * vbusvalid value when GOTGCTL.VbvalidOvEn = 1
 */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_E_SET0    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL
 * 
 * vbusvalid value when GOTGCTL.VbvalidOvEn is 1
 */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_E_SET1    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_MSB        3
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL register field value. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL register field value. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : avalidoven
 * 
 * A-Peripheral Session Valid Override Enable (AvalidOvEn)
 * 
 * This bit is used to enable/disable the software to
 * 
 * override the Avalid signal using the GOTGCTL.AvalidOvVal.
 * 
 * 1'b1 : Internally Avalid received from the PHY is overridden with
 * GOTGCTL.AvalidOvVal.
 * 
 * 1'b0 : Override is disabled and avalid signal from the respective PHY selected
 * is used
 * 
 * internally by the core
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                                    
 * :---------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_E_DISD | 0x0   | Override is disabled and Avalid signal from the
 * :                                       |       | respective PHY is used internally by the core. 
 *  ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_E_END  | 0x1   | Internally Avalid received from the PHY is     
 * :                                       |       | overridden with GOTGCTL.AvalidOvVa             
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_AVALIDOVEN
 * 
 * Override is disabled and Avalid signal from the respective PHY is used
 * internally by the core.
 */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_E_DISD  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_AVALIDOVEN
 * 
 * Internally Avalid received from the PHY is overridden with GOTGCTL.AvalidOvVa
 */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_AVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_AVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_MSB        4
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_AVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_AVALIDOVEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_AVALIDOVEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_GLOB_GOTGCTL_AVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_AVALIDOVEN field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_GLOB_GOTGCTL_AVALIDOVEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : avalidovval
 * 
 * A-Peripheral Session Valid OverrideValue (AvalidOvVal)
 * 
 * This bit is used to set Override value for Avalid signal
 * 
 * when GOTGCTL.AvalidOvEn is set.
 * 
 * 1'b0 : Avalid value is 1'b0 when GOTGCTL.AvalidOvEn =1
 * 
 * 1'b1 : Avalid value is 1'b1 when GOTGCTL.AvalidOvEn =1
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                                    
 * :------------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_E_VALUE0 | 0x0   | Avalid value is 1'b0 when GOTGCTL.BvalidOvEn =1
 *  ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_E_VALUE1 | 0x1   | Avalid value is 1'b1 when GOTGCTL.BvalidOvEn =1
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL
 * 
 * Avalid value is 1'b0 when GOTGCTL.BvalidOvEn =1
 */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_E_VALUE0   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL
 * 
 * Avalid value is 1'b1 when GOTGCTL.BvalidOvEn =1
 */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_E_VALUE1   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_MSB        5
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL register field value. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL register field value. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : bvalidoven
 * 
 * B-Peripheral Session Valid Override Enable (BvalidOvEn)
 * 
 * This bit is used to enable/disable the software to
 * 
 * override the Bvalid signal using the GOTGCTL.BvalidOvVal.
 * 
 * 1'b1 : Internally Bvalid received from the PHY is overridden with
 * GOTGCTL.BvalidOvVal.
 * 
 * 1'b0 : Override is disabled and bvalid signal from the respective PHY selected
 * is used
 * 
 * internally by the force
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                                    
 * :---------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_E_DISD | 0x0   | Override is disabled and bvalid signal from the
 * :                                       |       | respective PHY selected is used internally by  
 * :                                       |       | the core                                       
 *  ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_E_END  | 0x1   | Internally Bvalid received from the PHY is     
 * :                                       |       | overridden with GOTGCTL.BvalidOvVal            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_BVALIDOVEN
 * 
 * Override is disabled and bvalid signal from the respective PHY selected is used
 * internally by the core
 */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_E_DISD  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_BVALIDOVEN
 * 
 * Internally Bvalid received from the PHY is overridden with GOTGCTL.BvalidOvVal
 */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_BVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_BVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_MSB        6
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_BVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_BVALIDOVEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_BVALIDOVEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_GLOB_GOTGCTL_BVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_BVALIDOVEN field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_GLOB_GOTGCTL_BVALIDOVEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : bvalidovval
 * 
 * B-Peripheral Session Valid OverrideValue (BvalidOvVal)
 * 
 * This bit is used to set Override value for Bvalid
 * 
 * signal when GOTGCTL.BvalidOvEn is set.
 * 
 * 1'b0 : Bvalid value is 1'b0 when GOTGCTL.BvalidOvEn =1
 * 
 * 1'b1 : Bvalid value is 1'b1 when GOTGCTL.BvalidOvEn =1
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                            
 * :------------------------------------------|:------|:----------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_E_VALUE0 | 0x0   | Bvalid value when GOTGCTL.AvalidOvEn =1
 *  ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_E_VALUE1 | 0x1   | Bvalid value when GOTGCTL.AvalidOvEn =1
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL
 * 
 * Bvalid value when GOTGCTL.AvalidOvEn =1
 */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_E_VALUE0   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL
 * 
 * Bvalid value when GOTGCTL.AvalidOvEn =1
 */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_E_VALUE1   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_MSB        7
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL register field value. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL register field value. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : hstnegscs
 * 
 * Mode: Device only
 * 
 * Host Negotiation Success (HstNegScs)
 * 
 * The core sets this bit when host negotiation is successful. The
 * 
 * core clears this bit when the HNP Request (HNPReq) bit in this
 * 
 * register is SET.
 * 
 * 1'b0: Host negotiation failure
 * 
 * 1'b1: Host negotiation success
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description             
 * :-----------------------------------------|:------|:-------------------------
 *  ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_E_FAIL    | 0x0   | Host negotiation failure
 *  ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_E_SUCCESS | 0x1   | Host negotiation success
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_HSTNEGSCS
 * 
 * Host negotiation failure
 */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_E_FAIL       0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_HSTNEGSCS
 * 
 * Host negotiation success
 */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_E_SUCCESS    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_HSTNEGSCS register field. */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_HSTNEGSCS register field. */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_MSB        8
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_HSTNEGSCS register field. */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_HSTNEGSCS register field value. */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_HSTNEGSCS register field value. */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_HSTNEGSCS register field. */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_HSTNEGSCS field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_GLOB_GOTGCTL_HSTNEGSCS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : hnpreq
 * 
 * Mode: Device only
 * 
 * HNP Request (HNPReq)
 * 
 * The application sets this bit to initiate an HNP request to the
 * 
 * connected USB host. The application can clear this bit by writing
 * 
 * a 0 when the Host Negotiation Success Status Change bit in the
 * 
 * OTG Interrupt register (GOTGINT.HstNegSucStsChng) is SET.
 * 
 * The core clears this bit when the HstNegSucStsChng bit is
 * 
 * cleared.
 * 
 * 1'b0: No HNP request
 * 
 * 1'b1: HNP request
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description   
 * :-----------------------------------|:------|:---------------
 *  ALT_USB_GLOB_GOTGCTL_HNPREQ_E_DISD | 0x0   | No HNP request
 *  ALT_USB_GLOB_GOTGCTL_HNPREQ_E_END  | 0x1   | HNP request   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_HNPREQ
 * 
 * No HNP request
 */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_E_DISD  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_HNPREQ
 * 
 * HNP request
 */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_HNPREQ register field. */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_HNPREQ register field. */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_MSB        9
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_HNPREQ register field. */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_HNPREQ register field value. */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_SET_MSK    0x00000200
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_HNPREQ register field value. */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_CLR_MSK    0xfffffdff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_HNPREQ register field. */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_HNPREQ field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_USB_GLOB_GOTGCTL_HNPREQ register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : hstsethnpen
 * 
 * Mode: Host only
 * 
 * Host Set HNP Enable (HstSetHNPEn)
 * 
 * The application sets this bit when it has successfully enabled
 * 
 * HNP (using the SetFeature.SetHNPEnable command) on the
 * 
 * connected device.
 * 
 * 1'b0: Host Set HNP is not enabled
 * 
 * 1'b1: Host Set HNP is enabled
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                
 * :----------------------------------------|:------|:----------------------------
 *  ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_E_DISD | 0x0   | Host Set HNP is not enabled
 *  ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_E_END  | 0x1   | Host Set HNP is enabled    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN
 * 
 * Host Set HNP is not enabled
 */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN
 * 
 * Host Set HNP is enabled
 */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN register field. */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN register field. */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_MSB        10
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN register field. */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_SET_MSK    0x00000400
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_CLR_MSK    0xfffffbff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN register field. */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : devhnpen
 * 
 * Mode: Device only
 * 
 * Device HNP Enabled (DevHNPEn)
 * 
 * The application sets this bit when it successfully receives a
 * 
 * SetFeature.SetHNPEnable command from the connected USB
 * 
 * host.
 * 
 * 1'b0: HNP is not enabled in the application
 * 
 * 1'b1: HNP is enabled in the application
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                          
 * :-------------------------------------|:------|:--------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_DEVHNPEN_E_DISD | 0x0   | HNP is not enabled in the application
 *  ALT_USB_GLOB_GOTGCTL_DEVHNPEN_E_END  | 0x1   | HNP Enabled                          
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_DEVHNPEN
 * 
 * HNP is not enabled in the application
 */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_E_DISD    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_DEVHNPEN
 * 
 * HNP Enabled
 */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_DEVHNPEN register field. */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_DEVHNPEN register field. */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_MSB        11
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_DEVHNPEN register field. */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_DEVHNPEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_DEVHNPEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_DEVHNPEN register field. */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_DEVHNPEN field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_GLOB_GOTGCTL_DEVHNPEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : ehen
 * 
 * Mode: SRP Capable Host
 * 
 * Embedded Host Enable (EHEn)
 * 
 * 1'b1 : Enable Embedded Host Mode.
 * 
 * 1'b0: Disable Embedded Host Mode.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_EHEN register field. */
#define ALT_USB_GLOB_GOTGCTL_EHEN_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_EHEN register field. */
#define ALT_USB_GLOB_GOTGCTL_EHEN_MSB        14
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_EHEN register field. */
#define ALT_USB_GLOB_GOTGCTL_EHEN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_EHEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_EHEN_SET_MSK    0x00004000
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_EHEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_EHEN_CLR_MSK    0xffffbfff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_EHEN register field. */
#define ALT_USB_GLOB_GOTGCTL_EHEN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_EHEN field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_EHEN_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_USB_GLOB_GOTGCTL_EHEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_EHEN_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : conidsts
 * 
 * Mode: Host and Device
 * 
 * Connector ID Status (ConIDSts)
 * 
 * Indicates the connector ID status on a connect event.
 * 
 * 1'b0: The DWC_otg core is in A-Device mode
 * 
 * 1'b1: The DWC_otg core is in B-Device mode
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                         
 * :-------------------------------------|:------|:-------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_CONIDSTS_E_MODA | 0x0   | The DWC_otg core is in A-Device mode
 *  ALT_USB_GLOB_GOTGCTL_CONIDSTS_E_MODB | 0x1   | The otg core is in B-Device mode    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_CONIDSTS
 * 
 * The DWC_otg core is in A-Device mode
 */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_E_MODA    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_CONIDSTS
 * 
 * The otg core is in B-Device mode
 */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_E_MODB    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_CONIDSTS register field. */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_CONIDSTS register field. */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_MSB        16
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_CONIDSTS register field. */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_CONIDSTS register field value. */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_SET_MSK    0x00010000
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_CONIDSTS register field value. */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_CLR_MSK    0xfffeffff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_CONIDSTS register field. */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_RESET      0x1
/* Extracts the ALT_USB_GLOB_GOTGCTL_CONIDSTS field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_USB_GLOB_GOTGCTL_CONIDSTS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : dbnctime
 * 
 * Mode: Host only
 * 
 * Long/Short Debounce Time (DbncTime)
 * 
 * Indicates the debounce time of a detected connection.
 * 
 * 1'b0: Long debounce time, used FOR physical connections
 * 
 * (100 ms + 2.5 micro-sec)
 * 
 * 1'b1: Short debounce time, used FOR soft connections (2.5 micro-sec)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                   
 * :--------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_DBNCTIME_E_LONG  | 0x0   | Long debounce time, used FOR physical         
 * :                                      |       | connections (100 ms + 2.5 s)                  
 *  ALT_USB_GLOB_GOTGCTL_DBNCTIME_E_SHORT | 0x1   | Short debounce time, used FOR soft connections
 * :                                      |       | (2.5 s                                        
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_DBNCTIME
 * 
 * Long debounce time, used FOR physical connections (100 ms + 2.5 s)
 */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_E_LONG    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_DBNCTIME
 * 
 * Short debounce time, used FOR soft connections (2.5 s
 */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_E_SHORT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_DBNCTIME register field. */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_DBNCTIME register field. */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_MSB        17
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_DBNCTIME register field. */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_DBNCTIME register field value. */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_SET_MSK    0x00020000
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_DBNCTIME register field value. */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_CLR_MSK    0xfffdffff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_DBNCTIME register field. */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_DBNCTIME field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_USB_GLOB_GOTGCTL_DBNCTIME register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : asesvld
 * 
 * Mode: Host only
 * 
 * A-Session Valid (ASesVld)
 * 
 * Indicates the Host mode transceiver status.
 * 
 * 1'b0: A-session is not valid
 * 
 * 1'b1: A-session is valid
 * 
 * Note: If you do not enabled OTG features (such as SRP and HNP), the
 * 
 * read reset value will be 1.The vbus assigns the values internally for non-
 * 
 * SRP or non-HNP configurations.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description           
 * :----------------------------------------|:------|:-----------------------
 *  ALT_USB_GLOB_GOTGCTL_ASESVLD_E_VALID    | 0x0   | A-session is not valid
 *  ALT_USB_GLOB_GOTGCTL_ASESVLD_E_NOTVALID | 0x1   | A-session is valid    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_ASESVLD
 * 
 * A-session is not valid
 */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_E_VALID    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_ASESVLD
 * 
 * A-session is valid
 */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_E_NOTVALID 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_ASESVLD register field. */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_ASESVLD register field. */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_MSB        18
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_ASESVLD register field. */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_ASESVLD register field value. */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_SET_MSK    0x00040000
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_ASESVLD register field value. */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_CLR_MSK    0xfffbffff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_ASESVLD register field. */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_ASESVLD field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_USB_GLOB_GOTGCTL_ASESVLD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : bsesvld
 * 
 * Mode: Device only
 * 
 * B-Session Valid (BSesVld)
 * 
 * Indicates the Device mode transceiver status.
 * 
 * 1'b0: B-session is not valid.
 * 
 * 1'b1: B-session is valid.
 * 
 * In OTG mode, you can use this bit to determine IF the device is
 * 
 * connected or disconnected.
 * 
 * Note: If you do not enabled OTG features (such as SRP and HNP), the
 * 
 * read reset value will be 1.The vbus assigns the values internally for non-
 * 
 * SRP or non-HNP configurations.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description           
 * :----------------------------------------|:------|:-----------------------
 *  ALT_USB_GLOB_GOTGCTL_BSESVLD_E_NOTVALID | 0x0   | B-session is not valid
 *  ALT_USB_GLOB_GOTGCTL_BSESVLD_E_VALID    | 0x1   | B-session is valid    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_BSESVLD
 * 
 * B-session is not valid
 */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_E_NOTVALID 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_BSESVLD
 * 
 * B-session is valid
 */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_E_VALID    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_BSESVLD register field. */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_BSESVLD register field. */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_MSB        19
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_BSESVLD register field. */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_BSESVLD register field value. */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_SET_MSK    0x00080000
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_BSESVLD register field value. */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_BSESVLD register field. */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_BSESVLD field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_USB_GLOB_GOTGCTL_BSESVLD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : otgver
 * 
 * OTG Version (OTGVer)
 * 
 * Indicates the OTG revision.
 * 
 * 1'b0: OTG Version 1.3. In this version the core supports Data line
 * 
 * pulsing and VBus pulsing for SRP.
 * 
 * 1'b1: OTG Version 2.0. In this version the core supports only Data
 * 
 * line pulsing for SRP.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                              
 * :------------------------------------|:------|:------------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_OTGVER_E_VER13 | 0x0   | OTG Version 1.3. In this version the core
 * :                                    |       | supports Data line                       
 *  ALT_USB_GLOB_GOTGCTL_OTGVER_E_VER20 | 0x1   | OTG Version 2.0. In this version the core
 * :                                    |       | supports only Data line pulsing for SRP  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_OTGVER
 * 
 * OTG Version 1.3. In this version the core supports Data line
 */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_E_VER13 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_OTGVER
 * 
 * OTG Version 2.0. In this version the core supports only Data line pulsing for
 * SRP
 */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_E_VER20 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_OTGVER register field. */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_OTGVER register field. */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_MSB        20
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_OTGVER register field. */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_OTGVER register field value. */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_SET_MSK    0x00100000
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_OTGVER register field value. */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_CLR_MSK    0xffefffff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_OTGVER register field. */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_OTGVER field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_USB_GLOB_GOTGCTL_OTGVER register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : curmod
 * 
 * Mode: Host and Device
 * 
 * Current Mode of Operation (CurMod)
 * 
 * Indicates the current mode.
 * 
 * 1'b0: Device mode
 * 
 * 1'b1: Host mode
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_CURMOD register field. */
#define ALT_USB_GLOB_GOTGCTL_CURMOD_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_CURMOD register field. */
#define ALT_USB_GLOB_GOTGCTL_CURMOD_MSB        21
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_CURMOD register field. */
#define ALT_USB_GLOB_GOTGCTL_CURMOD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_CURMOD register field value. */
#define ALT_USB_GLOB_GOTGCTL_CURMOD_SET_MSK    0x00200000
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_CURMOD register field value. */
#define ALT_USB_GLOB_GOTGCTL_CURMOD_CLR_MSK    0xffdfffff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_CURMOD register field. */
#define ALT_USB_GLOB_GOTGCTL_CURMOD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_CURMOD field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_CURMOD_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_USB_GLOB_GOTGCTL_CURMOD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_CURMOD_SET(value) (((value) << 21) & 0x00200000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GOTGCTL.
 */
struct ALT_USB_GLOB_GOTGCTL_s
{
    const uint32_t  sesreqscs    :  1;  /* ALT_USB_GLOB_GOTGCTL_SESREQSCS */
    uint32_t        sesreq       :  1;  /* ALT_USB_GLOB_GOTGCTL_SESREQ */
    uint32_t        vbvalidoven  :  1;  /* ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN */
    uint32_t        vbvalidovval :  1;  /* ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL */
    uint32_t        avalidoven   :  1;  /* ALT_USB_GLOB_GOTGCTL_AVALIDOVEN */
    uint32_t        avalidovval  :  1;  /* ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL */
    uint32_t        bvalidoven   :  1;  /* ALT_USB_GLOB_GOTGCTL_BVALIDOVEN */
    uint32_t        bvalidovval  :  1;  /* ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL */
    const uint32_t  hstnegscs    :  1;  /* ALT_USB_GLOB_GOTGCTL_HSTNEGSCS */
    uint32_t        hnpreq       :  1;  /* ALT_USB_GLOB_GOTGCTL_HNPREQ */
    uint32_t        hstsethnpen  :  1;  /* ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN */
    uint32_t        devhnpen     :  1;  /* ALT_USB_GLOB_GOTGCTL_DEVHNPEN */
    uint32_t                     :  2;  /* *UNDEFINED* */
    uint32_t        ehen         :  1;  /* ALT_USB_GLOB_GOTGCTL_EHEN */
    uint32_t                     :  1;  /* *UNDEFINED* */
    const uint32_t  conidsts     :  1;  /* ALT_USB_GLOB_GOTGCTL_CONIDSTS */
    const uint32_t  dbnctime     :  1;  /* ALT_USB_GLOB_GOTGCTL_DBNCTIME */
    const uint32_t  asesvld      :  1;  /* ALT_USB_GLOB_GOTGCTL_ASESVLD */
    const uint32_t  bsesvld      :  1;  /* ALT_USB_GLOB_GOTGCTL_BSESVLD */
    uint32_t        otgver       :  1;  /* ALT_USB_GLOB_GOTGCTL_OTGVER */
    const uint32_t  curmod       :  1;  /* ALT_USB_GLOB_GOTGCTL_CURMOD */
    uint32_t                     : 10;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GOTGCTL. */
typedef volatile struct ALT_USB_GLOB_GOTGCTL_s  ALT_USB_GLOB_GOTGCTL_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GOTGCTL register. */
#define ALT_USB_GLOB_GOTGCTL_RESET       0x00010000
/* The byte offset of the ALT_USB_GLOB_GOTGCTL register from the beginning of the component. */
#define ALT_USB_GLOB_GOTGCTL_OFST        0x0
/* The address of the ALT_USB_GLOB_GOTGCTL register. */
#define ALT_USB_GLOB_GOTGCTL_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GOTGCTL_OFST))

/*
 * Register : gotgint
 * 
 * OTG Interrupt Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                          
 * :--------|:-------|:------|:--------------------------------------
 *  [1:0]   | ???    | 0x0   | *UNDEFINED*                          
 *  [2]     | RW     | 0x0   | ALT_USB_GLOB_GOTGINT_SESENDDET       
 *  [7:3]   | ???    | 0x0   | *UNDEFINED*                          
 *  [8]     | RW     | 0x0   | ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG
 *  [9]     | RW     | 0x0   | ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG
 *  [16:10] | ???    | 0x0   | *UNDEFINED*                          
 *  [17]    | RW     | 0x0   | ALT_USB_GLOB_GOTGINT_HSTNEGDET       
 *  [18]    | RW     | 0x0   | ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG     
 *  [19]    | RW     | 0x0   | ALT_USB_GLOB_GOTGINT_DBNCEDONE       
 *  [31:20] | ???    | 0x0   | *UNDEFINED*                          
 * 
 */
/*
 * Field : sesenddet
 * 
 * Mode:Host and Device
 * 
 * Session End Detected (SesEndDet)
 * 
 * The core sets this bit when the utmiotg_bvalid signal is
 * 
 * deasserted.This bit can be set only by the core and the application should write
 * 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                                 
 * :---------------------------------------|:------|:---------------------------------------------
 *  ALT_USB_GLOB_GOTGINT_SESENDDET_E_INACT | 0x0   | Non Active State                            
 *  ALT_USB_GLOB_GOTGINT_SESENDDET_E_ACT   | 0x1   | Set when utmisrp_bvalid signal is deasserted
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_SESENDDET
 * 
 * Non Active State
 */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_SESENDDET
 * 
 * Set when utmisrp_bvalid signal is deasserted
 */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGINT_SESENDDET register field. */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGINT_SESENDDET register field. */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_MSB        2
/* The width in bits of the ALT_USB_GLOB_GOTGINT_SESENDDET register field. */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGINT_SESENDDET register field value. */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_GLOB_GOTGINT_SESENDDET register field value. */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_GLOB_GOTGINT_SESENDDET register field. */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGINT_SESENDDET field value from a register. */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_GLOB_GOTGINT_SESENDDET register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : sesreqsucstschng
 * 
 * Mode:Host and Device
 * 
 * Session Request Success Status Change
 * 
 * (SesReqSucStsChng)
 * 
 * The core sets this bit on the success or failure of a session
 * 
 * request. The application must read the Session Request
 * 
 * Success bit in the OTG Control and Status register
 * 
 * (GOTGCTL.SesReqScs) to check For success or failure.This bit can be set only by
 * the core and the application should write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description           
 * :----------------------------------------------|:------|:-----------------------
 *  ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_E_INACT | 0x0   | No change             
 *  ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_E_ACT   | 0x1   | Session Request Status
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG
 * 
 * No change
 */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG
 * 
 * Session Request Status
 */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG register field. */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG register field. */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_MSB        8
/* The width in bits of the ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG register field. */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG register field value. */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG register field value. */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG register field. */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG field value from a register. */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : hstnegsucstschng
 * 
 * Mode:Host and Device
 * 
 * Host Negotiation Success Status Change (HstNegSucStsChng)
 * 
 * The core sets this bit on the success or failure of a USB host
 * 
 * negotiation request. The application must read the Host
 * 
 * Negotiation Success bit of the OTG Control and Status register
 * 
 * (GOTGCTL.HstNegScs) to check For success or failure.This bit can be set only by
 * the core and the application should write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                   
 * :----------------------------------------------|:------|:-------------------------------
 *  ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_E_INACT | 0x0   | No Change                     
 *  ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_E_ACT   | 0x1   | Host Negotiation Status Change
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG
 * 
 * No Change
 */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG
 * 
 * Host Negotiation Status Change
 */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG register field. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG register field. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_MSB        9
/* The width in bits of the ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG register field. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG register field value. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_SET_MSK    0x00000200
/* The mask used to clear the ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG register field value. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_CLR_MSK    0xfffffdff
/* The reset value of the ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG register field. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG field value from a register. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : hstnegdet
 * 
 * Mode:Host and Device
 * 
 * Host Negotiation Detected (HstNegDet)
 * 
 * The core sets this bit when it detects a host negotiation request
 * 
 * on the USB.This bit can be set only by the core and the application should write
 * 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description              
 * :---------------------------------------|:------|:--------------------------
 *  ALT_USB_GLOB_GOTGINT_HSTNEGDET_E_INACT | 0x0   | No Change                
 *  ALT_USB_GLOB_GOTGINT_HSTNEGDET_E_ACT   | 0x1   | Host Negotiation Detected
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_HSTNEGDET
 * 
 * No Change
 */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_HSTNEGDET
 * 
 * Host Negotiation Detected
 */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGINT_HSTNEGDET register field. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGINT_HSTNEGDET register field. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_MSB        17
/* The width in bits of the ALT_USB_GLOB_GOTGINT_HSTNEGDET register field. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGINT_HSTNEGDET register field value. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_SET_MSK    0x00020000
/* The mask used to clear the ALT_USB_GLOB_GOTGINT_HSTNEGDET register field value. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_CLR_MSK    0xfffdffff
/* The reset value of the ALT_USB_GLOB_GOTGINT_HSTNEGDET register field. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGINT_HSTNEGDET field value from a register. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_USB_GLOB_GOTGINT_HSTNEGDET register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : adevtoutchg
 * 
 * Mode:Host and Device
 * 
 * A-Device Timeout Change (ADevTOUTChg)
 * 
 * The core sets this bit to indicate that the A-device has timed out
 * 
 * WHILE waiting FOR the B-device to connect.This bit can be set only by the core
 * and the application should write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description     
 * :-----------------------------------------|:------|:-----------------
 *  ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_E_INACT | 0x0   | No Change       
 *  ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_E_ACT   | 0x1   | A-Device Timeout
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG
 * 
 * No Change
 */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG
 * 
 * A-Device Timeout
 */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG register field. */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG register field. */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_MSB        18
/* The width in bits of the ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG register field. */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG register field value. */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_SET_MSK    0x00040000
/* The mask used to clear the ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG register field value. */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_CLR_MSK    0xfffbffff
/* The reset value of the ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG register field. */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG field value from a register. */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : dbncedone
 * 
 * Mode: Host only
 * 
 * Debounce Done (DbnceDone)
 * 
 * The core sets this bit when the debounce is completed after the
 * 
 * device connect. The application can start driving USB reset after
 * 
 * seeing this interrupt. This bit is only valid when the HNP
 * 
 * Capable or SRP Capable bit is SET in the Core USB
 * 
 * Configuration register (GUSBCFG.HNPCap or
 * 
 * GUSBCFG.SRPCap, respectively).This bit can be set only by the core and the
 * application should write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description       
 * :---------------------------------------|:------|:-------------------
 *  ALT_USB_GLOB_GOTGINT_DBNCEDONE_E_INACT | 0x0   | No Change         
 *  ALT_USB_GLOB_GOTGINT_DBNCEDONE_E_ACT   | 0x1   | Debounce completed
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_DBNCEDONE
 * 
 * No Change
 */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_DBNCEDONE
 * 
 * Debounce completed
 */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGINT_DBNCEDONE register field. */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGINT_DBNCEDONE register field. */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_MSB        19
/* The width in bits of the ALT_USB_GLOB_GOTGINT_DBNCEDONE register field. */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGINT_DBNCEDONE register field value. */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_SET_MSK    0x00080000
/* The mask used to clear the ALT_USB_GLOB_GOTGINT_DBNCEDONE register field value. */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_USB_GLOB_GOTGINT_DBNCEDONE register field. */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGINT_DBNCEDONE field value from a register. */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_USB_GLOB_GOTGINT_DBNCEDONE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_SET(value) (((value) << 19) & 0x00080000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GOTGINT.
 */
struct ALT_USB_GLOB_GOTGINT_s
{
    uint32_t                   :  2;  /* *UNDEFINED* */
    uint32_t  sesenddet        :  1;  /* ALT_USB_GLOB_GOTGINT_SESENDDET */
    uint32_t                   :  5;  /* *UNDEFINED* */
    uint32_t  sesreqsucstschng :  1;  /* ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG */
    uint32_t  hstnegsucstschng :  1;  /* ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG */
    uint32_t                   :  7;  /* *UNDEFINED* */
    uint32_t  hstnegdet        :  1;  /* ALT_USB_GLOB_GOTGINT_HSTNEGDET */
    uint32_t  adevtoutchg      :  1;  /* ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG */
    uint32_t  dbncedone        :  1;  /* ALT_USB_GLOB_GOTGINT_DBNCEDONE */
    uint32_t                   : 12;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GOTGINT. */
typedef volatile struct ALT_USB_GLOB_GOTGINT_s  ALT_USB_GLOB_GOTGINT_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GOTGINT register. */
#define ALT_USB_GLOB_GOTGINT_RESET       0x00000000
/* The byte offset of the ALT_USB_GLOB_GOTGINT register from the beginning of the component. */
#define ALT_USB_GLOB_GOTGINT_OFST        0x4
/* The address of the ALT_USB_GLOB_GOTGINT register. */
#define ALT_USB_GLOB_GOTGINT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GOTGINT_OFST))

/*
 * Register : gahbcfg
 * 
 * AHB Configuration Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                          
 * :--------|:-------|:------|:--------------------------------------
 *  [0]     | RW     | 0x0   | ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK     
 *  [4:1]   | RW     | 0x0   | ALT_USB_GLOB_GAHBCFG_HBSTLEN         
 *  [5]     | RW     | 0x0   | ALT_USB_GLOB_GAHBCFG_DMAEN           
 *  [6]     | ???    | 0x0   | *UNDEFINED*                          
 *  [7]     | RW     | 0x0   | ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL     
 *  [8]     | RW     | 0x0   | ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL      
 *  [20:9]  | ???    | 0x0   | *UNDEFINED*                          
 *  [21]    | RW     | 0x0   | ALT_USB_GLOB_GAHBCFG_REMMEMSUPP      
 *  [22]    | RW     | 0x0   | ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT  
 *  [23]    | RW     | 0x0   | ALT_USB_GLOB_GAHBCFG_AHBSINGLE       
 *  [24]    | RW     | 0x0   | ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS
 *  [31:25] | ???    | 0x0   | *UNDEFINED*                          
 * 
 */
/*
 * Field : glblintrmsk
 * 
 * Mode:Host and device
 * 
 * Global Interrupt Mask (GlblIntrMsk)
 * 
 * The application uses this bit to mask or unmask the interrupt line
 * 
 * assertion to itself. Irrespective of this bit's setting, the interrupt
 * 
 * status registers are updated by the core.
 * 
 * 1'b0: Mask the interrupt assertion to the application.
 * 
 * 1'b1: Unmask the interrupt assertion to the application.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                    
 * :-----------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_E_MSK   | 0x0   | Mask the interrupt assertion to the application
 *  ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_E_NOMSK | 0x1   | Unmask the interrupt assertion to the          
 * :                                         |       | application.                                   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK
 * 
 * Mask the interrupt assertion to the application
 */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK
 * 
 * Unmask the interrupt assertion to the application.
 */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK register field. */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK register field. */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_MSB        0
/* The width in bits of the ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK register field. */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK register field value. */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK register field value. */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK register field. */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK field value from a register. */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : hbstlen
 * 
 * Mode:Host and device
 * 
 * Burst Length/Type (HBstLen)
 * 
 * This field is used in both External and Internal DMA modes. In
 * 
 * External DMA mode, these bits appear on dma_burst[3:0] ports,
 * 
 * which can be used by an external wrapper to interface the
 * 
 * External DMA Controller interface to Synopsys DW_ahb_dmac
 * 
 * or ARM PrimeCell.
 * 
 * External DMA Modedefines the DMA burst length in terms of
 * 
 * 32-bit words:
 * 
 * 4'b0000: 1 word
 * 
 * 4'b0001: 4 words
 * 
 * 4'b0010: 8 words
 * 
 * 4'b0011: 16 words
 * 
 * 4'b0100: 32 words
 * 
 * 4'b0101: 64 word
 * 
 * s
 * 
 * 4'b0110: 128 words
 * 
 * 4'b0111: 256 words
 * 
 * Others: Reserved
 * 
 * Internal DMA ModeAHB Master burst type:
 * 
 * 4'b0000 Single
 * 
 * 4'b0001 INCR
 * 
 * 4'b0011 INCR4
 * 
 * 4'b0101 INCR8
 * 
 * 4'b0111 INCR16
 * 
 * Others: Reserved
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                           | Value | Description       
 * :-----------------------------------------------|:------|:-------------------
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD1ORSINGLE   | 0x0   | 1 word or single  
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD4ORINCR     | 0x1   | 4 word or incr    
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD8           | 0x2   | 8 word            
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD16ORINCR4   | 0x3   | 16 word or incr4  
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD32          | 0x4   | 32 word           
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD64ORINCR8   | 0x5   | 64 word or incr8  
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD128         | 0x6   | 128 word          
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD256ORINCR16 | 0x7   | 256 word or incr16
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORDX           | 0x8   | Others reserved   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * 1 word or single
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD1ORSINGLE    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * 4 word or incr
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD4ORINCR      0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * 8 word
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD8            0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * 16 word or incr4
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD16ORINCR4    0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * 32 word
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD32           0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * 64 word or incr8
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD64ORINCR8    0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * 128 word
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD128          0x6
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * 256 word or incr16
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD256ORINCR16  0x7
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * Others reserved
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORDX            0x8

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GAHBCFG_HBSTLEN register field. */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GAHBCFG_HBSTLEN register field. */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_MSB        4
/* The width in bits of the ALT_USB_GLOB_GAHBCFG_HBSTLEN register field. */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GAHBCFG_HBSTLEN register field value. */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_SET_MSK    0x0000001e
/* The mask used to clear the ALT_USB_GLOB_GAHBCFG_HBSTLEN register field value. */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_CLR_MSK    0xffffffe1
/* The reset value of the ALT_USB_GLOB_GAHBCFG_HBSTLEN register field. */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GAHBCFG_HBSTLEN field value from a register. */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_GET(value) (((value) & 0x0000001e) >> 1)
/* Produces a ALT_USB_GLOB_GAHBCFG_HBSTLEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_SET(value) (((value) << 1) & 0x0000001e)

/*
 * Field : dmaen
 * 
 * Mode:Host and device
 * 
 * DMA Enable (DMAEn)
 * 
 * 1'b0: Core operates in Slave mode
 * 
 * 1'b1: Core operates in a DMA mode
 * 
 * This bit is always 0 when Slave-Only mode has been selected
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                
 * :------------------------------------|:------|:----------------------------
 *  ALT_USB_GLOB_GAHBCFG_DMAEN_E_SLVMOD | 0x0   | Core operates in Slave mode
 *  ALT_USB_GLOB_GAHBCFG_DMAEN_E_DMAMOD | 0x1   | Core operates in a DMA mode
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_DMAEN
 * 
 * Core operates in Slave mode
 */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_E_SLVMOD 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_DMAEN
 * 
 * Core operates in a DMA mode
 */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_E_DMAMOD 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GAHBCFG_DMAEN register field. */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GAHBCFG_DMAEN register field. */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_MSB        5
/* The width in bits of the ALT_USB_GLOB_GAHBCFG_DMAEN register field. */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GAHBCFG_DMAEN register field value. */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_GLOB_GAHBCFG_DMAEN register field value. */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_GLOB_GAHBCFG_DMAEN register field. */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GAHBCFG_DMAEN field value from a register. */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_GLOB_GAHBCFG_DMAEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : nptxfemplvl
 * 
 * Mode:Host and device
 * 
 * Non-Periodic TxFIFO Empty Level (NPTxFEmpLvl)
 * 
 * This bit is used only in Slave mode.
 * 
 * In host mode and with Shared FIFO with device mode, this bit
 * 
 * indicates when the Non-Periodic TxFIFO Empty Interrupt bit in
 * 
 * the Core Interrupt register (GINTSTS.NPTxFEmp) is triggered.
 * 
 * With dedicated FIFO in device mode, this bit indicates when IN
 * 
 * endpoint Transmit FIFO empty interrupt (DIEPINTn.TxFEmp) is
 * 
 * triggered.
 * 
 * Host mode and with Shared FIFO with device mode:-
 * 
 * 1'b0: GINTSTS.NPTxFEmp interrupt indicates that the Non-
 * 
 * Periodic TxFIFO is half empty
 * 
 * 1'b1: GINTSTS.NPTxFEmp interrupt indicates that the Non-
 * 
 * Periodic TxFIFO is completely empty
 * 
 * Dedicated FIFO in device mode :-
 * 
 * 1'b0: DIEPINTn.TxFEmp interrupt indicates that the IN
 * 
 * Endpoint TxFIFO is half empty
 * 
 * 1'b1: DIEPINTn.TxFEmp interrupt indicates that the IN
 * 
 * Endpoint TxFIFO is completely empty
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_E_HALFEMPTY | 0x0   | DIEPINTn.TxFEmp interrupt indicates that the IN 
 * :                                             |       | Endpoint TxFIFO is half empty or DIEPINTn.TxFEmp
 * :                                             |       | interrupt indicates that the IN Endpoint TxFIFO 
 * :                                             |       | is half empty                                   
 *  ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_E_EMPTY     | 0x1   | GINTSTS.NPTxFEmp interrupt indicates that the   
 * :                                             |       | Non-Periodic TxFIFO is completely empty or      
 * :                                             |       | DIEPINTn.TxFEmp interrupt indicates that the IN 
 * :                                             |       | Endpoint TxFIFO is completely empty             
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL
 * 
 * DIEPINTn.TxFEmp interrupt indicates that the IN Endpoint TxFIFO is half empty or
 * DIEPINTn.TxFEmp interrupt indicates that the IN Endpoint TxFIFO is half empty
 */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_E_HALFEMPTY    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL
 * 
 * GINTSTS.NPTxFEmp interrupt indicates that the Non-Periodic TxFIFO is completely
 * empty or DIEPINTn.TxFEmp interrupt indicates that the IN Endpoint TxFIFO is
 * completely empty
 */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_E_EMPTY        0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL register field. */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL register field. */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_MSB        7
/* The width in bits of the ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL register field. */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL register field value. */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL register field value. */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL register field. */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL field value from a register. */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : ptxfemplvl
 * 
 * Mode:Host only
 * 
 * Periodic TxFIFO Empty Level (PTxFEmpLvl)
 * 
 * Indicates when the Periodic TxFIFO Empty Interrupt bit in the
 * 
 * Core Interrupt register (GINTSTS.PTxFEmp) is triggered. This
 * 
 * bit is used only in Slave mode.
 * 
 * 1'b0: GINTSTS.PTxFEmp interrupt indicates that the
 * 
 * Periodic TxFIFO is half empty
 * 
 * 1'b1: GINTSTS.PTxFEmp interrupt indicates that the
 * 
 * Periodic TxFIFO is completely empty
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                 
 * :--------------------------------------------|:------|:---------------------------------------------
 *  ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_E_HALFEMPTY | 0x0   | GINTSTS.PTxFEmp interrupt indicates that the
 * :                                            |       | Periodic TxFIFO is half empty               
 *  ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_E_EMPTY     | 0x1   | GINTSTS.PTxFEmp interrupt indicates that the
 * :                                            |       | Periodic TxFIFO is completely empty         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL
 * 
 * GINTSTS.PTxFEmp interrupt indicates that the Periodic TxFIFO is half empty
 */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_E_HALFEMPTY 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL
 * 
 * GINTSTS.PTxFEmp interrupt indicates that the Periodic TxFIFO is completely empty
 */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_E_EMPTY     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL register field. */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL register field. */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_MSB        8
/* The width in bits of the ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL register field. */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL register field value. */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL register field value. */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL register field. */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL field value from a register. */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : remmemsupp
 * 
 * Remote Memory Support (RemMemSupp)
 * 
 * This bit is programmed to enable the functionality to wait for the system DMA
 * 
 * Done Signal for the DMA Write Transfers.
 * 
 * GAHBCFG.RemMemSupp=1
 * 
 * * The int_dma_req output signal is asserted when HSOTG DMA starts
 * 
 * write transfer to the external memory. When the core is done with the
 * 
 * Transfers it asserts int_dma_done signal to flag the completion of DMA
 * 
 * writes from HSOTG. The core then waits for sys_dma_done signal from
 * 
 * the system to proceed further and complete the Data Transfer
 * 
 * corresponding to a particular Channel/Endpoint.
 * 
 * GAHBCFG.RemMemSupp=0
 * 
 * * The int_dma_req and int_dma_done signals are not asserted and the
 * 
 * core proceeds with the assertion of the XferComp interrupt as soon as
 * 
 * the DMA write transfer is done at the HSOTG Core Boundary and it
 * 
 * doesn't wait for the sys_dma_done signal to complete the DATA transfers
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                                   
 * :---------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_E_DISD | 0x0   | Disable wait for system DMA Done Signal       
 *  ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_E_END  | 0x1   | Enable wait for the system DMA Done Signal for
 * :                                       |       | the DMA Write Transfers                       
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_REMMEMSUPP
 * 
 * Disable wait for system DMA Done Signal
 */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_E_DISD  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_REMMEMSUPP
 * 
 * Enable wait for the system DMA Done Signal for the DMA Write Transfers
 */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GAHBCFG_REMMEMSUPP register field. */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GAHBCFG_REMMEMSUPP register field. */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_MSB        21
/* The width in bits of the ALT_USB_GLOB_GAHBCFG_REMMEMSUPP register field. */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GAHBCFG_REMMEMSUPP register field value. */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_SET_MSK    0x00200000
/* The mask used to clear the ALT_USB_GLOB_GAHBCFG_REMMEMSUPP register field value. */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_CLR_MSK    0xffdfffff
/* The reset value of the ALT_USB_GLOB_GAHBCFG_REMMEMSUPP register field. */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GAHBCFG_REMMEMSUPP field value from a register. */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_USB_GLOB_GAHBCFG_REMMEMSUPP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : notialldmawrit
 * 
 * Notify All Dma Write Transactions (NotiAllDmaWrit)
 * 
 * This bit is programmed to enable the System DMA Done functionality for all
 * 
 * the DMA write Transactions corresponding to the Channel/Endpoint. This bit
 * 
 * is valid only when GAHBCFG.RemMemSupp is set to 1.
 * 
 * GAHBCFG.NotiAllDmaWrit = 1
 * 
 * * HSOTG core asserts int_dma_req for all the DMA write transactions on
 * 
 * the AHB interface along with int_dma_done, chep_last_transact and
 * 
 * chep_number signal informations. The core waits for sys_dma_done
 * 
 * signal for all the DMA write transactions in order to complete the transfer
 * 
 * of a particular Channel/Endpoint.
 * 
 * GAHBCFG.NotiAllDmaWrit = 0
 * 
 * * HSOTG core asserts int_dma_req signal only for the last transaction of
 * 
 * DMA write transfer corresponding to a particular Channel/Endpoint.
 * 
 * Similarly, the core waits for sys_dma_done signal only for that
 * 
 * transaction of DMA write to complete the transfer of a particular
 * 
 * Channel/Endpoint.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description                                     
 * :------------------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_E_LASTTRANS | 0x0   | HSOTG core asserts int_dma_req signal only for  
 * :                                                |       | the last transaction of DMA write transfer      
 * :                                                |       | corresponding to a particular Channel/Endpoint. 
 * :                                                |       | Similarly, the core waits for sys_dma_done      
 * :                                                |       | signal only for that transaction of DMA write to
 * :                                                |       | complete the transfer of a particular           
 * :                                                |       | Channel/Endpoint                                
 *  ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_E_ALLTRANS  | 0x1   | HSOTG core asserts int_dma_req for all the DMA  
 * :                                                |       | write transactions on the AHB interface along   
 * :                                                |       | with int_dma_done, chep_last_transact and       
 * :                                                |       | chep_number signal informations. The core waits 
 * :                                                |       | for sys_dma_done signal for all the DMA write   
 * :                                                |       | transactions in order to complete the transfer  
 * :                                                |       | of a particular Channel/Endpoint                
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT
 * 
 * HSOTG core asserts int_dma_req signal only for the last transaction of DMA write
 * transfer corresponding to a particular Channel/Endpoint. Similarly, the core
 * waits for sys_dma_done signal only for that transaction of DMA write to complete
 * the transfer of a particular Channel/Endpoint
 */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_E_LASTTRANS 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT
 * 
 * HSOTG core asserts int_dma_req for all the DMA write transactions on the AHB
 * interface along with int_dma_done, chep_last_transact and chep_number signal
 * informations. The core waits for sys_dma_done signal for all the DMA write
 * transactions in order to complete the transfer of a particular Channel/Endpoint
 */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_E_ALLTRANS  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT register field. */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT register field. */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_MSB        22
/* The width in bits of the ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT register field. */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT register field value. */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_SET_MSK    0x00400000
/* The mask used to clear the ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT register field value. */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_CLR_MSK    0xffbfffff
/* The reset value of the ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT register field. */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT field value from a register. */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : ahbsingle
 * 
 * AHB Single Support (AHBSingle)
 * 
 * This bit when programmed supports Single transfers for the remaining data in a
 * 
 * transfer when the DWC_otg core is operating in DMA mode.
 * 
 * 1'b0: This is the default mode. When this bit is set to 1'b0,
 * 
 * the remaining data in the transfer is sent using INCR burst size.
 * 
 * 1'b1: When set to 1'b1, the remaining data in a transfer is sent using Single
 * 
 * burst size.
 * 
 * Note: if this feature is enabled, the AHB RETRY and SPLIT transfers still have
 * INCR
 * 
 * burst type. Enable this feature when the AHB Slave connected to the DWC_otg core
 * does
 * 
 * not support INCR burst (and when Split, and Retry transactions are not being
 * used
 * 
 * in the bus).
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GAHBCFG_AHBSINGLE register field. */
#define ALT_USB_GLOB_GAHBCFG_AHBSINGLE_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GAHBCFG_AHBSINGLE register field. */
#define ALT_USB_GLOB_GAHBCFG_AHBSINGLE_MSB        23
/* The width in bits of the ALT_USB_GLOB_GAHBCFG_AHBSINGLE register field. */
#define ALT_USB_GLOB_GAHBCFG_AHBSINGLE_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GAHBCFG_AHBSINGLE register field value. */
#define ALT_USB_GLOB_GAHBCFG_AHBSINGLE_SET_MSK    0x00800000
/* The mask used to clear the ALT_USB_GLOB_GAHBCFG_AHBSINGLE register field value. */
#define ALT_USB_GLOB_GAHBCFG_AHBSINGLE_CLR_MSK    0xff7fffff
/* The reset value of the ALT_USB_GLOB_GAHBCFG_AHBSINGLE register field. */
#define ALT_USB_GLOB_GAHBCFG_AHBSINGLE_RESET      0x0
/* Extracts the ALT_USB_GLOB_GAHBCFG_AHBSINGLE field value from a register. */
#define ALT_USB_GLOB_GAHBCFG_AHBSINGLE_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_USB_GLOB_GAHBCFG_AHBSINGLE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GAHBCFG_AHBSINGLE_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : invdescendianess
 * 
 * Invert Descriptor Endianess (InvDescEndianess)
 * 
 * 1'b0: Descriptor Endianness is same as AHB Master Endianness
 * 
 * 1'b1: Descriptor Endianness is Little Endian if AHB Master Endianness is Big
 * Endian.
 * 
 * Descriptor Endianness is Big Endian if AHB Master Endianness is Little Endian.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS register field. */
#define ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS register field. */
#define ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS_MSB        24
/* The width in bits of the ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS register field. */
#define ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS register field value. */
#define ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS_SET_MSK    0x01000000
/* The mask used to clear the ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS register field value. */
#define ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS_CLR_MSK    0xfeffffff
/* The reset value of the ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS register field. */
#define ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS_RESET      0x0
/* Extracts the ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS field value from a register. */
#define ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS_SET(value) (((value) << 24) & 0x01000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GAHBCFG.
 */
struct ALT_USB_GLOB_GAHBCFG_s
{
    uint32_t  glblintrmsk      :  1;  /* ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK */
    uint32_t  hbstlen          :  4;  /* ALT_USB_GLOB_GAHBCFG_HBSTLEN */
    uint32_t  dmaen            :  1;  /* ALT_USB_GLOB_GAHBCFG_DMAEN */
    uint32_t                   :  1;  /* *UNDEFINED* */
    uint32_t  nptxfemplvl      :  1;  /* ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL */
    uint32_t  ptxfemplvl       :  1;  /* ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL */
    uint32_t                   : 12;  /* *UNDEFINED* */
    uint32_t  remmemsupp       :  1;  /* ALT_USB_GLOB_GAHBCFG_REMMEMSUPP */
    uint32_t  notialldmawrit   :  1;  /* ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT */
    uint32_t  ahbsingle        :  1;  /* ALT_USB_GLOB_GAHBCFG_AHBSINGLE */
    uint32_t  invdescendianess :  1;  /* ALT_USB_GLOB_GAHBCFG_INVDESCENDIANESS */
    uint32_t                   :  7;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GAHBCFG. */
typedef volatile struct ALT_USB_GLOB_GAHBCFG_s  ALT_USB_GLOB_GAHBCFG_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GAHBCFG register. */
#define ALT_USB_GLOB_GAHBCFG_RESET       0x00000000
/* The byte offset of the ALT_USB_GLOB_GAHBCFG register from the beginning of the component. */
#define ALT_USB_GLOB_GAHBCFG_OFST        0x8
/* The address of the ALT_USB_GLOB_GAHBCFG register. */
#define ALT_USB_GLOB_GAHBCFG_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GAHBCFG_OFST))

/*
 * Register : gusbcfg
 * 
 * USB Configuration Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                              
 * :--------|:-------|:------|:------------------------------------------
 *  [2:0]   | RW     | 0x0   | ALT_USB_GLOB_GUSBCFG_TOUTCAL             
 *  [3]     | R      | 0x0   | ALT_USB_GLOB_GUSBCFG_PHYIF               
 *  [4]     | R      | 0x1   | ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL       
 *  [5]     | R      | 0x0   | ALT_USB_GLOB_GUSBCFG_FSINTF              
 *  [6]     | R      | 0x0   | ALT_USB_GLOB_GUSBCFG_PHYSEL              
 *  [7]     | RW     | 0x0   | ALT_USB_GLOB_GUSBCFG_DDRSEL              
 *  [8]     | RW     | 0x0   | ALT_USB_GLOB_GUSBCFG_SRPCAP              
 *  [9]     | RW     | 0x0   | ALT_USB_GLOB_GUSBCFG_HNPCAP              
 *  [13:10] | RW     | 0x5   | ALT_USB_GLOB_GUSBCFG_USBTRDTIM           
 *  [17:14] | ???    | 0x0   | *UNDEFINED*                              
 *  [18]    | RW     | 0x0   | ALT_USB_GLOB_GUSBCFG_ULPIAUTORES         
 *  [19]    | RW     | 0x0   | ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM         
 *  [20]    | RW     | 0x0   | ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV      
 *  [21]    | RW     | 0x0   | ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR
 *  [22]    | RW     | 0x0   | ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE      
 *  [23]    | RW     | 0x0   | ALT_USB_GLOB_GUSBCFG_COMPLEMENT          
 *  [24]    | RW     | 0x0   | ALT_USB_GLOB_GUSBCFG_INDICATOR           
 *  [25]    | RW     | 0x0   | ALT_USB_GLOB_GUSBCFG_ULPI                
 *  [26]    | R      | 0x0   | ALT_USB_GLOB_GUSBCFG_IC_USBCAP           
 *  [27]    | ???    | 0x0   | *UNDEFINED*                              
 *  [28]    | RW     | 0x0   | ALT_USB_GLOB_GUSBCFG_TXENDDELAY          
 *  [29]    | RW     | 0x0   | ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD         
 *  [30]    | RW     | 0x0   | ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD         
 *  [31]    | W      | 0x0   | ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT        
 * 
 */
/*
 * Field : toutcal
 * 
 * Mode:Host and Device
 * 
 * HS/FS Timeout Calibration (TOutCal)
 * 
 * The number of PHY clocks that the application programs in this
 * 
 * field is added to the high-speed/full-speed interpacket timeout
 * 
 * duration in the core to account For any additional delays
 * 
 * introduced by the PHY. This can be required, because the delay
 * 
 * introduced by the PHY in generating the linestate condition can
 * 
 * vary from one PHY to another.
 * 
 * The USB standard timeout value For high-speed operation is 736
 * 
 * to 816 (inclusive) bit times. The USB standard timeout value For
 * 
 * full-speed operation is 16 to 18 (inclusive) bit times. The
 * 
 * application must program this field based on the speed of
 * 
 * enumeration. The number of bit times added per PHY clock are:
 * 
 * High-speed operation:
 * 
 * One 30-MHz PHY clock = 16 bit times
 * 
 * One 60-MHz PHY clock = 8 bit times
 * 
 * Full-speed operation:
 * 
 * One 30-MHz PHY clock = 0.4 bit times
 * 
 * One 60-MHz PHY clock = 0.2 bit times
 * 
 * One 48-MHz PHY clock = 0.25 bit times
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_TOUTCAL register field. */
#define ALT_USB_GLOB_GUSBCFG_TOUTCAL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_TOUTCAL register field. */
#define ALT_USB_GLOB_GUSBCFG_TOUTCAL_MSB        2
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_TOUTCAL register field. */
#define ALT_USB_GLOB_GUSBCFG_TOUTCAL_WIDTH      3
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_TOUTCAL register field value. */
#define ALT_USB_GLOB_GUSBCFG_TOUTCAL_SET_MSK    0x00000007
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_TOUTCAL register field value. */
#define ALT_USB_GLOB_GUSBCFG_TOUTCAL_CLR_MSK    0xfffffff8
/* The reset value of the ALT_USB_GLOB_GUSBCFG_TOUTCAL register field. */
#define ALT_USB_GLOB_GUSBCFG_TOUTCAL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_TOUTCAL field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_TOUTCAL_GET(value) (((value) & 0x00000007) >> 0)
/* Produces a ALT_USB_GLOB_GUSBCFG_TOUTCAL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_TOUTCAL_SET(value) (((value) << 0) & 0x00000007)

/*
 * Field : phyif
 * 
 * Mode:Host and Device
 * 
 * PHY Interface (PHYIf)
 * 
 * The application uses this bit to configure the core To support a
 * 
 * UTMI+ PHY with an 8- or 16-bit interface. When a ULPI PHY is
 * 
 * chosen, this must be Set to 8-bit mode.
 * 
 * 1'b0: 8 bits
 * 
 * 1'b1: 16 bits
 * 
 * This bit is writable only If UTMI+ and ULPI were selected
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description  
 * :-----------------------------------|:------|:--------------
 *  ALT_USB_GLOB_GUSBCFG_PHYIF_E_BITS8 | 0x0   | PHY 8bit Mode
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_PHYIF
 * 
 * PHY 8bit Mode
 */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_E_BITS8  0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_PHYIF register field. */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_PHYIF register field. */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_MSB        3
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_PHYIF register field. */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_PHYIF register field value. */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_PHYIF register field value. */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_GLOB_GUSBCFG_PHYIF register field. */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_PHYIF field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_GLOB_GUSBCFG_PHYIF register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : ulpi_utmi_sel
 * 
 * Mode:Host and Device
 * 
 * ULPI or UTMI+ Select (ULPI_UTMI_Sel)
 * 
 * The application uses this bit to select either a UTMI+ interface or
 * 
 * ULPI Interface.
 * 
 * 1'b0: UTMI+ Interface
 * 
 * 1'b1: ULPI Interface
 * 
 * This bit is writable only If UTMI+ and ULPI was specified For
 * 
 * High-Speed PHY Interface(s).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_E_ULPI | 0x0   | ULPI PHY   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL
 * 
 * ULPI PHY
 */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_E_ULPI   0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_MSB        4
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_RESET      0x1
/* Extracts the ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : fsintf
 * 
 * Mode:Host and Device
 * 
 * Full-Speed Serial Interface Select (FSIntf)
 * 
 * The application uses this bit to select either a unidirectional or
 * 
 * bidirectional USB 1.1 full-speed serial transceiver interface.
 * 
 * 1'b0: 6-pin unidirectional full-speed serial interface
 * 
 * 1'b1: 3-pin bidirectional full-speed serial interface
 * 
 * If a USB 1.1 Full-Speed Serial Transceiver interface was not
 * 
 * selected, this bit is always 0, with Write
 * 
 * Only access. If a USB 1.1 FS interface was selected, Then the
 * 
 * application can Set this bit to select between the 3- and 6-pin
 * 
 * interfaces, and access is Read and Write.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                     
 * :-------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_FSINTF_E_FS6PIN | 0x0   | 6-pin unidirectional full-speed serial interface
 *  ALT_USB_GLOB_GUSBCFG_FSINTF_E_FS3PIN | 0x1   | 3-pin bidirectional full-speed serial interface 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_FSINTF
 * 
 * 6-pin unidirectional full-speed serial interface
 */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_E_FS6PIN    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_FSINTF
 * 
 * 3-pin bidirectional full-speed serial interface
 */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_E_FS3PIN    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_FSINTF register field. */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_FSINTF register field. */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_MSB        5
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_FSINTF register field. */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_FSINTF register field value. */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_FSINTF register field value. */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_GLOB_GUSBCFG_FSINTF register field. */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_FSINTF field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_GLOB_GUSBCFG_FSINTF register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : physel
 * 
 * Mode:Host and Device
 * 
 * USB 2.0 High-Speed PHY or USB 1.1 Full-Speed Serial
 * 
 * Transceiver Select (PHYSel)
 * 
 * The application uses this bit to select either a high-speed UTMI+
 * 
 * or ULPI PHY, or a full-speed transceiver.
 * 
 * 1'b0: USB 2.0 high-speed UTMI+ or ULPI PHY
 * 
 * 1'b1: USB 1.1 full-speed serial transceiver
 * 
 * If a USB 1.1 Full-Speed Serial Transceiver interface was not
 * 
 * selected in, this bit is always 0, with Write Only access.
 * 
 * If a high-speed PHY interface was not selected in,
 * 
 * this bit is always 1, with Write Only access.
 * 
 * If both interface types were selected (parameters have non-zero values),
 * 
 * the application uses this bit to select which interface is active,
 * 
 * and access is Read and Write.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description            
 * :------------------------------------|:------|:------------------------
 *  ALT_USB_GLOB_GUSBCFG_PHYSEL_E_USB20 | 0x0   | USB 2.0 high-speed ULPI
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_PHYSEL
 * 
 * USB 2.0 high-speed ULPI
 */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_E_USB20 0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_PHYSEL register field. */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_PHYSEL register field. */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_MSB        6
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_PHYSEL register field. */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_PHYSEL register field value. */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_PHYSEL register field value. */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_GLOB_GUSBCFG_PHYSEL register field. */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_PHYSEL field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_GLOB_GUSBCFG_PHYSEL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : ddrsel
 * 
 * Mode:Host and Device
 * 
 * ULPI DDR Select (DDRSel)
 * 
 * The application uses this bit to select a Single Data Rate (SDR)
 * 
 * or Double Data Rate (DDR) or ULPI interface.
 * 
 * 1'b0: Single Data Rate ULPI Interface, with 8-bit-wide data
 * 
 * bus
 * 
 * 1'b1: Double Data Rate ULPI Interface, with 4-bit-wide data
 * 
 * bus
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description                                     
 * :----------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_DDRSEL_E_SDR | 0x0   | Single Data Rate ULPI Interfacewith 8-bit-wide  
 * :                                  |       | data bus                                        
 *  ALT_USB_GLOB_GUSBCFG_DDRSEL_E_DDR | 0x1   | Double Data Rate ULPI Interface, with 4-bit-wide
 * :                                  |       | data bus                                        
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_DDRSEL
 * 
 * Single Data Rate ULPI Interfacewith 8-bit-wide data bus
 */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_E_SDR   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_DDRSEL
 * 
 * Double Data Rate ULPI Interface, with 4-bit-wide data bus
 */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_E_DDR   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_DDRSEL register field. */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_DDRSEL register field. */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_MSB        7
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_DDRSEL register field. */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_DDRSEL register field value. */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_DDRSEL register field value. */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_GLOB_GUSBCFG_DDRSEL register field. */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_DDRSEL field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_GLOB_GUSBCFG_DDRSEL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : srpcap
 * 
 * Mode:Host and Device
 * 
 * SRP-Capable (SRPCap)
 * 
 * The application uses this bit to control the DWC_otg core SRP
 * 
 * capabilities. If the core operates as a non-SRP-capable
 * 
 * B-device, it cannot request the connected A-device (host) to
 * 
 * activate VBUS and start a session.
 * 
 * 1'b0: SRP capability is not enabled.
 * 
 * 1'b1: SRP capability is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                  
 * :-----------------------------------|:------|:------------------------------
 *  ALT_USB_GLOB_GUSBCFG_SRPCAP_E_DISD | 0x0   | SRP capability is not enabled
 *  ALT_USB_GLOB_GUSBCFG_SRPCAP_E_END  | 0x1   | SRP capability is enabled    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_SRPCAP
 * 
 * SRP capability is not enabled
 */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_E_DISD  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_SRPCAP
 * 
 * SRP capability is enabled
 */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_SRPCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_SRPCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_MSB        8
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_SRPCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_SRPCAP register field value. */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_SRPCAP register field value. */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_SRPCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_SRPCAP field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_GLOB_GUSBCFG_SRPCAP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : hnpcap
 * 
 * Mode:Host and Device
 * 
 * HNP-Capable (HNPCap)
 * 
 * The application uses this bit to control the DWC_otg core's HNP
 * 
 * capabilities.
 * 
 * 1'b0: HNP capability is not enabled.
 * 
 * 1'b1: HNP capability is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                   
 * :-----------------------------------|:------|:-------------------------------
 *  ALT_USB_GLOB_GUSBCFG_HNPCAP_E_DISD | 0x0   | HNP capability is not enabled.
 *  ALT_USB_GLOB_GUSBCFG_HNPCAP_E_END  | 0x1   | HNP capability is enabled     
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_HNPCAP
 * 
 * HNP capability is not enabled.
 */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_E_DISD  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_HNPCAP
 * 
 * HNP capability is enabled
 */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_HNPCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_HNPCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_MSB        9
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_HNPCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_HNPCAP register field value. */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_SET_MSK    0x00000200
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_HNPCAP register field value. */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_CLR_MSK    0xfffffdff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_HNPCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_HNPCAP field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_USB_GLOB_GUSBCFG_HNPCAP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : usbtrdtim
 * 
 * Mode: Device only
 * 
 * USB Turnaround Time (USBTrdTim)
 * 
 * Sets the turnaround time in PHY clocks.
 * 
 * Specifies the response time For a MAC request to the Packet
 * 
 * FIFO Controller (PFC) to fetch data from the DFIFO (SPRAM).
 * 
 * This must be programmed to
 * 
 * 4'h5: When the MAC interface is 16-bit UTMI+ .
 * 
 * 4'h9: When the MAC interface is 8-bit UTMI+ .
 * 
 * Note: The values above are calculated For the minimum AHB
 * 
 * frequency of 30 MHz. USB turnaround time is critical For
 * 
 * certification where long cables and 5-Hubs are used, so If you
 * 
 * need the AHB to run at less than 30 MHz, and If USB turnaround
 * 
 * time is not critical, these bits can be programmed to a larger
 * 
 * value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                  
 * :------------------------------------------|:------|:------------------------------
 *  ALT_USB_GLOB_GUSBCFG_USBTRDTIM_E_TURNTIME | 0x9   | MAC interface is 8-bit UTMI+.
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_USBTRDTIM
 * 
 * MAC interface is 8-bit UTMI+.
 */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_E_TURNTIME   0x9

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_USBTRDTIM register field. */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_USBTRDTIM register field. */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_MSB        13
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_USBTRDTIM register field. */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_USBTRDTIM register field value. */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_SET_MSK    0x00003c00
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_USBTRDTIM register field value. */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_CLR_MSK    0xffffc3ff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_USBTRDTIM register field. */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_RESET      0x5
/* Extracts the ALT_USB_GLOB_GUSBCFG_USBTRDTIM field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_GET(value) (((value) & 0x00003c00) >> 10)
/* Produces a ALT_USB_GLOB_GUSBCFG_USBTRDTIM register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_SET(value) (((value) << 10) & 0x00003c00)

/*
 * Field : ulpiautores
 * 
 * Mode:Host and Device
 * 
 * ULPI Auto Resume (ULPIAutoRes)
 * 
 * This bit sets the AutoResume bit in the Interface Control register
 * 
 * on the ULPI PHY.
 * 
 * 1'b0: PHY does not use AutoResume feature.
 * 
 * 1'b1: PHY uses AutoResume feature.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                        
 * :----------------------------------------|:------|:------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_E_DISD | 0x0   | PHY does not use AutoResume feature
 *  ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_E_END  | 0x1   | PHY uses AutoResume feature        
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPIAUTORES
 * 
 * PHY does not use AutoResume feature
 */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPIAUTORES
 * 
 * PHY uses AutoResume feature
 */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_ULPIAUTORES register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_ULPIAUTORES register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_MSB        18
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_ULPIAUTORES register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_ULPIAUTORES register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_SET_MSK    0x00040000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_ULPIAUTORES register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_CLR_MSK    0xfffbffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_ULPIAUTORES register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_ULPIAUTORES field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_USB_GLOB_GUSBCFG_ULPIAUTORES register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : ulpiclksusm
 * 
 * Mode:Host and Device
 * 
 * ULPI Clock SuspendM (ULPIClkSusM)
 * 
 * This bit sets the ClockSuspendM bit in the Interface Control
 * 
 * register on the ULPI PHY. This bit applies only in serial or carkit
 * 
 * modes.
 * 
 * 1'b0: PHY powers down internal clock during suspend.
 * 
 * 1'b1: PHY does not power down internal clock.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                  
 * :---------------------------------------------|:------|:----------------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_E_PWDCLK    | 0x0   | PHY powers down internal clock during suspend
 *  ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_E_NONPWDCLK | 0x1   | PHY does not power down internal clock       
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM
 * 
 * PHY powers down internal clock during suspend
 */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_E_PWDCLK       0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM
 * 
 * PHY does not power down internal clock
 */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_E_NONPWDCLK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_MSB        19
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_SET_MSK    0x00080000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : ulpiextvbusdrv
 * 
 * Mode:Host only
 * 
 * ULPI External VBUS Drive (ULPIExtVbusDrv)
 * 
 * This bit selects between internal or external supply to drive 5V
 * 
 * on VBUS, in ULPI PHY.
 * 
 * 1'b0: PHY drives VBUS using internal charge pump (Default).
 * 
 * 1'b1: PHY drives VBUS using external supply.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_E_INTERN | 0x0   | PHY drives VBUS using internal charge pump
 *  ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_E_EXTERN | 0x1   | PHY drives VBUS using external supply     
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV
 * 
 * PHY drives VBUS using internal charge pump
 */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_E_INTERN    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV
 * 
 * PHY drives VBUS using external supply
 */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_E_EXTERN    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_MSB        20
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_SET_MSK    0x00100000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_CLR_MSK    0xffefffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : ulpiextvbusindicator
 * 
 * Mode:Host only
 * 
 * ULPI External VBUS Indicator (ULPIExtVbusIndicator)
 * 
 * This bit indicates to the ULPI PHY to use an external VBUS overcurrent
 * 
 * indicator.
 * 
 * 1'b0: PHY uses internal VBUS valid comparator.
 * 
 * 1'b1: PHY uses external VBUS valid comparator.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description                            
 * :---------------------------------------------------|:------|:----------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_E_INTERN | 0x0   | PHY uses internal VBUS valid comparator
 *  ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_E_EXTERN | 0x1   | PHY uses external VBUS valid comparator
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR
 * 
 * PHY uses internal VBUS valid comparator
 */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_E_INTERN  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR
 * 
 * PHY uses external VBUS valid comparator
 */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_E_EXTERN  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_MSB        21
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_SET_MSK    0x00200000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_CLR_MSK    0xffdfffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : termseldlpulse
 * 
 * Mode:Device only
 * 
 * TermSel DLine Pulsing Selection (TermSelDLPulse)
 * 
 * This bit selects utmi_termselect to drive data line pulse during
 * 
 * SRP.
 * 
 * 1'b0: Data line pulsing using utmi_txvalid (Default).
 * 
 * 1'b1: Data line pulsing using utmi_termsel.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                         
 * :----------------------------------------------|:------|:-------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_E_TXVALID | 0x0   | Data line pulsing using utmi_txvalid
 *  ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_E_TERMSEL | 0x1   | Data line pulsing using utmi_termsel
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE
 * 
 * Data line pulsing using utmi_txvalid
 */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_E_TXVALID   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE
 * 
 * Data line pulsing using utmi_termsel
 */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_E_TERMSEL   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE register field. */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE register field. */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_MSB        22
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE register field. */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE register field value. */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_SET_MSK    0x00400000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE register field value. */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_CLR_MSK    0xffbfffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE register field. */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : complement
 * 
 * Mode:Host only
 * 
 * Indicator Complement
 * 
 * Controls the PHY to invert the ExternalVbusIndicator input
 * 
 * signal, generating the Complement
 * 
 * Output. Please refer to the ULPI Spec For more detail
 * 
 * 1'b0: PHY does not invert ExternalVbusIndicator signal
 * 
 * 1'b1: PHY does invert ExternalVbusIndicator signal
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_COMPLEMENT_E_NONINVERT | 0x0   | PHY does not invert ExternalVbusIndicator signal
 *  ALT_USB_GLOB_GUSBCFG_COMPLEMENT_E_INVERT    | 0x1   | PHY does invert ExternalVbusIndicator signal    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_COMPLEMENT
 * 
 * PHY does not invert ExternalVbusIndicator signal
 */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_E_NONINVERT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_COMPLEMENT
 * 
 * PHY does invert ExternalVbusIndicator signal
 */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_E_INVERT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_COMPLEMENT register field. */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_COMPLEMENT register field. */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_MSB        23
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_COMPLEMENT register field. */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_COMPLEMENT register field value. */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_SET_MSK    0x00800000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_COMPLEMENT register field value. */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_CLR_MSK    0xff7fffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_COMPLEMENT register field. */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_COMPLEMENT field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_USB_GLOB_GUSBCFG_COMPLEMENT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : indicator
 * 
 * Mode:Host only
 * 
 * Indicator Pass Through
 * 
 * Controls wether the Complement Output is qualified with the
 * 
 * Internal Vbus Valid comparator before being used
 * 
 * in the Vbus State in the RX CMD. Please refer to the ULPI Spec
 * 
 * for more detail.
 * 
 * 1'b0: Complement Output signal is qualified with the Internal
 * 
 * VbusValid comparator.
 * 
 * 1'b1: Complement Output signal is not qualified with the
 * 
 * Internal VbusValid comparator.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                                    
 * :----------------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_INDICATOR_E_QUALIFIED    | 0x0   | Complement Output signal is qualified with the 
 * :                                              |       | Internal VbusValid comparator                  
 *  ALT_USB_GLOB_GUSBCFG_INDICATOR_E_NONQUALIFIED | 0x1   | Complement Output signal is not qualified  with
 * :                                              |       | the Internal VbusValid comparator              
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_INDICATOR
 * 
 * Complement Output signal is qualified with the Internal VbusValid comparator
 */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_E_QUALIFIED      0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_INDICATOR
 * 
 * Complement Output signal is not qualified  with the Internal VbusValid
 * comparator
 */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_E_NONQUALIFIED   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_INDICATOR register field. */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_INDICATOR register field. */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_MSB        24
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_INDICATOR register field. */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_INDICATOR register field value. */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_SET_MSK    0x01000000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_INDICATOR register field value. */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_CLR_MSK    0xfeffffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_INDICATOR register field. */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_INDICATOR field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_USB_GLOB_GUSBCFG_INDICATOR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : ulpi
 * 
 * Mode:Host only
 * 
 * ULPI Interface Protect Disable
 * 
 * Controls circuitry built into the PHY For protecting the ULPI
 * 
 * interface when the link tri-states STP and data.
 * 
 * Any pull-ups or pull-downs employed by this feature can be
 * 
 * disabled. Please refer to the ULPI Specification For more detail.
 * 
 * 1'b0: Enables the interface protect circuit
 * 
 * 1'b1: Disables the interface protect circuit
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                           
 * :---------------------------------|:------|:---------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_ULPI_E_END  | 0x0   | Enables the interface protect circuit 
 *  ALT_USB_GLOB_GUSBCFG_ULPI_E_DISD | 0x1   | Disables the interface protect circuit
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPI
 * 
 * Enables the interface protect circuit
 */
#define ALT_USB_GLOB_GUSBCFG_ULPI_E_END     0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPI
 * 
 * Disables the interface protect circuit
 */
#define ALT_USB_GLOB_GUSBCFG_ULPI_E_DISD    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_ULPI register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_ULPI register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_MSB        25
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_ULPI register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_ULPI register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_SET_MSK    0x02000000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_ULPI register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_CLR_MSK    0xfdffffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_ULPI register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_ULPI field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_USB_GLOB_GUSBCFG_ULPI register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : ic_usbcap
 * 
 * IC_USB-Capable (IC_USBCap)
 * 
 * The application uses this bit to control the DWC_otg core's IC_USB
 * 
 * capabilities.
 * 
 * 1'b0: IC_USB PHY Interface is not selected.
 * 
 * 1'b1: IC_USB PHY Interface is selected.
 * 
 * This bit is writable only if IC_USB is selected
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_IC_USBCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_IC_USBCAP_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_IC_USBCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_IC_USBCAP_MSB        26
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_IC_USBCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_IC_USBCAP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_IC_USBCAP register field value. */
#define ALT_USB_GLOB_GUSBCFG_IC_USBCAP_SET_MSK    0x04000000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_IC_USBCAP register field value. */
#define ALT_USB_GLOB_GUSBCFG_IC_USBCAP_CLR_MSK    0xfbffffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_IC_USBCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_IC_USBCAP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_IC_USBCAP field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_IC_USBCAP_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_USB_GLOB_GUSBCFG_IC_USBCAP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_IC_USBCAP_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : txenddelay
 * 
 * Mode: Device only
 * 
 * Tx End Delay (TxEndDelay)
 * 
 * Writing 1'b1 to this bit enables the core to follow the TxEndDelay timings as
 * per UTMI+ specification  1.05 section 4.1.5 for opmode signal during remote
 * wakeup.
 * 
 * 1'b0 : Normal Mode.
 * 
 * 1'b1 : Tx End delay.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GUSBCFG_TXENDDELAY_E_DISD | 0x0   | Normal Mode
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_TXENDDELAY
 * 
 * Normal Mode
 */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_E_DISD  0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_TXENDDELAY register field. */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_TXENDDELAY register field. */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_MSB        28
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_TXENDDELAY register field. */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_TXENDDELAY register field value. */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_SET_MSK    0x10000000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_TXENDDELAY register field value. */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_CLR_MSK    0xefffffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_TXENDDELAY register field. */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_TXENDDELAY field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_USB_GLOB_GUSBCFG_TXENDDELAY register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : forcehstmode
 * 
 * Mode:Host and device
 * 
 * Force Host Mode (ForceHstMode)
 * 
 * Writing a 1 to this bit forces the core to host mode irrespective of
 * 
 * utmiotg_iddig input pin.
 * 
 * 1'b0 : Normal Mode.
 * 
 * 1'b1 : Force Host Mode.
 * 
 * After setting the force bit, the application must wait at least 25 ms before
 * 
 * the change to take effect. When the simulation is in scale down mode,
 * 
 * waiting for 500 micro sec is sufficient.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description    
 * :----------------------------------------|:------|:----------------
 *  ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_E_DISD | 0x0   | Normal Mode    
 *  ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_E_END  | 0x1   | Force Host Mode
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD
 * 
 * Normal Mode
 */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD
 * 
 * Force Host Mode
 */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD register field. */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD register field. */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_MSB        29
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD register field. */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD register field value. */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_SET_MSK    0x20000000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD register field value. */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_CLR_MSK    0xdfffffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD register field. */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : forcedevmode
 * 
 * Mode:Host and device
 * 
 * Force Device Mode (ForceDevMode)
 * 
 * Writing a 1 to this bit forces the core to device mode irrespective
 * 
 * of utmiotg_iddig input pin.
 * 
 * 1'b0 : Normal Mode.
 * 
 * 1'b1 : Force Device Mode.
 * 
 * After setting the force bit, the application must wait at least 25 ms before
 * 
 * the change to take effect. When the simulation is in scale down mode,
 * 
 * waiting for 500 micro sec is sufficient.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description      
 * :----------------------------------------|:------|:------------------
 *  ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_E_DISD | 0x0   | Normal Mode      
 *  ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_E_END  | 0x1   | Force Device Mode
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD
 * 
 * Normal Mode
 */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD
 * 
 * Force Device Mode
 */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD register field. */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD register field. */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_MSB        30
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD register field. */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD register field value. */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD register field value. */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD register field. */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : corrupttxpkt
 * 
 * Mode:Host and device
 * 
 * Corrupt Tx packet
 * 
 * This bit is FOr debug purposes only. Never Set this bit to 1.The application
 * should always write 1'b0 to this bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_E_NODBG | 0x0   | Normal Mode
 *  ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_E_DBG   | 0x1   | Debug Mode 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT
 * 
 * Normal Mode
 */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_E_NODBG   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT
 * 
 * Debug Mode
 */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_E_DBG     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT register field. */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT register field. */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_MSB        31
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT register field. */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT register field value. */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT register field value. */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT register field. */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GUSBCFG.
 */
struct ALT_USB_GLOB_GUSBCFG_s
{
    uint32_t        toutcal              :  3;  /* ALT_USB_GLOB_GUSBCFG_TOUTCAL */
    const uint32_t  phyif                :  1;  /* ALT_USB_GLOB_GUSBCFG_PHYIF */
    const uint32_t  ulpi_utmi_sel        :  1;  /* ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL */
    const uint32_t  fsintf               :  1;  /* ALT_USB_GLOB_GUSBCFG_FSINTF */
    const uint32_t  physel               :  1;  /* ALT_USB_GLOB_GUSBCFG_PHYSEL */
    uint32_t        ddrsel               :  1;  /* ALT_USB_GLOB_GUSBCFG_DDRSEL */
    uint32_t        srpcap               :  1;  /* ALT_USB_GLOB_GUSBCFG_SRPCAP */
    uint32_t        hnpcap               :  1;  /* ALT_USB_GLOB_GUSBCFG_HNPCAP */
    uint32_t        usbtrdtim            :  4;  /* ALT_USB_GLOB_GUSBCFG_USBTRDTIM */
    uint32_t                             :  4;  /* *UNDEFINED* */
    uint32_t        ulpiautores          :  1;  /* ALT_USB_GLOB_GUSBCFG_ULPIAUTORES */
    uint32_t        ulpiclksusm          :  1;  /* ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM */
    uint32_t        ulpiextvbusdrv       :  1;  /* ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV */
    uint32_t        ulpiextvbusindicator :  1;  /* ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR */
    uint32_t        termseldlpulse       :  1;  /* ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE */
    uint32_t        complement           :  1;  /* ALT_USB_GLOB_GUSBCFG_COMPLEMENT */
    uint32_t        indicator            :  1;  /* ALT_USB_GLOB_GUSBCFG_INDICATOR */
    uint32_t        ulpi                 :  1;  /* ALT_USB_GLOB_GUSBCFG_ULPI */
    const uint32_t  ic_usbcap            :  1;  /* ALT_USB_GLOB_GUSBCFG_IC_USBCAP */
    uint32_t                             :  1;  /* *UNDEFINED* */
    uint32_t        txenddelay           :  1;  /* ALT_USB_GLOB_GUSBCFG_TXENDDELAY */
    uint32_t        forcehstmode         :  1;  /* ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD */
    uint32_t        forcedevmode         :  1;  /* ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD */
    uint32_t        corrupttxpkt         :  1;  /* ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT */
};

/* The typedef declaration for register ALT_USB_GLOB_GUSBCFG. */
typedef volatile struct ALT_USB_GLOB_GUSBCFG_s  ALT_USB_GLOB_GUSBCFG_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GUSBCFG register. */
#define ALT_USB_GLOB_GUSBCFG_RESET       0x00001410
/* The byte offset of the ALT_USB_GLOB_GUSBCFG register from the beginning of the component. */
#define ALT_USB_GLOB_GUSBCFG_OFST        0xc
/* The address of the ALT_USB_GLOB_GUSBCFG register. */
#define ALT_USB_GLOB_GUSBCFG_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GUSBCFG_OFST))

/*
 * Register : grstctl
 * 
 * Reset Register
 * 
 * Register Layout
 * 
 *  Bits    | Access   | Reset | Description                     
 * :--------|:---------|:------|:---------------------------------
 *  [0]     | R-W once | 0x0   | ALT_USB_GLOB_GRSTCTL_CSFTRST    
 *  [1]     | R-W once | 0x0   | ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST
 *  [2]     | R-W once | 0x0   | ALT_USB_GLOB_GRSTCTL_FRMCNTRRST 
 *  [3]     | ???      | 0x0   | *UNDEFINED*                     
 *  [4]     | R-W once | 0x0   | ALT_USB_GLOB_GRSTCTL_RXFFLSH    
 *  [5]     | R-W once | 0x0   | ALT_USB_GLOB_GRSTCTL_TXFFLSH    
 *  [10:6]  | RW       | 0x0   | ALT_USB_GLOB_GRSTCTL_TXFNUM     
 *  [29:11] | ???      | 0x0   | *UNDEFINED*                     
 *  [30]    | R        | 0x0   | ALT_USB_GLOB_GRSTCTL_DMAREQ     
 *  [31]    | R        | 0x1   | ALT_USB_GLOB_GRSTCTL_AHBIDLE    
 * 
 */
/*
 * Field : csftrst
 * 
 * Mode:Host and Device
 * 
 * Core Soft Reset (CSftRst)
 * 
 * Resets the hclk and phy_clock domains as follows:
 * 
 * Clears the interrupts and all the CSR registers except the
 * 
 * following register bits:
 * 
 * * PCGCCTL.RstPdwnModule
 * 
 * * PCGCCTL.GateHclk
 * 
 * * PCGCCTL.PwrClmp
 * 
 * * PCGCCTL.StopPPhyLPwrClkSelclk
 * 
 * * GUSBCFG.PhyLPwrClkSel
 * 
 * * GUSBCFG.DDRSel
 * 
 * * GUSBCFG.PHYSel
 * 
 * * GUSBCFG.FSIntf
 * 
 * * GUSBCFG.ULPI_UTMI_Sel
 * 
 * * GUSBCFG.PHYIf
 * 
 * * GUSBCFG.TxEndDelay
 * 
 * * GUSBCFG.TermSelDLPulse
 * 
 * * GUSBCFG.ULPIClkSusM
 * 
 * * GUSBCFG.ULPIAutoRes
 * 
 * * GUSBCFG.ULPIFsLs
 * 
 * * GGPIO
 * 
 * * GPWRDN
 * 
 * * GADPCTL
 * 
 * * HCFG.FSLSPclkSel
 * 
 * * DCFG.DevSpd
 * 
 * * DCTL.SftDiscon
 * 
 * * All module state machines
 * 
 * All module state machines (except the AHB Slave Unit) are
 * 
 * reset to the IDLE state, and all the transmit FIFOs and the
 * 
 * receive FIFO are flushed.
 * 
 * Any transactions on the AHB Master are terminated as soon
 * 
 * as possible, after gracefully completing the last data phase of
 * 
 * an AHB transfer. Any transactions on the USB are terminated
 * 
 * immediately.
 * 
 * When Hibernation or ADP feature is enabled, the PMU module is not
 * 
 * reset by the Core Soft Reset.
 * 
 * The application can write to this bit any time it wants to reset the
 * 
 * core. This is a self-clearing bit and the core clears this bit after
 * 
 * all the necessary logic is reset in the core, which can take
 * 
 * several clocks, depending on the current state of the core. Once
 * 
 * this bit is cleared software must wait at least 3 PHY clocks
 * 
 * before doing any access to the PHY domain (synchronization
 * 
 * delay). Software must also must check that bit 31 of this register
 * 
 * is 1 (AHB Master is IDLE) before starting any operation.
 * 
 * Typically software reset is used during software development
 * 
 * and also when you dynamically change the PHY selection bits in
 * 
 * the USB configuration registers listed above. When you change
 * 
 * the PHY, the corresponding clock For the PHY is selected and
 * 
 * used in the PHY domain. Once a new clock is selected, the PHY
 * 
 * domain has to be reset for proper operation.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                      
 * :--------------------------------------|:------|:----------------------------------
 *  ALT_USB_GLOB_GRSTCTL_CSFTRST_E_NOTACT | 0x0   | No reset                         
 *  ALT_USB_GLOB_GRSTCTL_CSFTRST_E_ACT    | 0x1   | Resets hclk and phy_clock domains
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_CSFTRST
 * 
 * No reset
 */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_E_NOTACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_CSFTRST
 * 
 * Resets hclk and phy_clock domains
 */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRSTCTL_CSFTRST register field. */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRSTCTL_CSFTRST register field. */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_MSB        0
/* The width in bits of the ALT_USB_GLOB_GRSTCTL_CSFTRST register field. */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GRSTCTL_CSFTRST register field value. */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_GLOB_GRSTCTL_CSFTRST register field value. */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_GLOB_GRSTCTL_CSFTRST register field. */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRSTCTL_CSFTRST field value from a register. */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_GLOB_GRSTCTL_CSFTRST register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : piufssftrst
 * 
 * Mode:Host and Device
 * 
 * PIU FS Dedicated Controller Soft Reset (PIUFSSftRst)
 * 
 * Resets the PIU FS Dedicated Controller
 * 
 * All module state machines in FS Dedicated Controller of PIU are
 * 
 * reset to the IDLE state. Used to reset the FS Dedicated controller in PIU in
 * case of any PHY Errors like Loss of activity or Babble Error resulting in the
 * PHY remaining in RX state for more than one frame boundary
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST register field. */
#define ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST register field. */
#define ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST_MSB        1
/* The width in bits of the ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST register field. */
#define ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST register field value. */
#define ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST register field value. */
#define ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST register field. */
#define ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST field value from a register. */
#define ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : frmcntrrst
 * 
 * Mode:Host only
 * 
 * Host Frame Counter Reset (FrmCntrRst)
 * 
 * The application writes this bit to reset the (micro)frame number
 * 
 * counter inside the core. When the (micro)frame counter is reset,
 * 
 * the subsequent SOF sent out by the core has a (micro)frame
 * 
 * number of 0.When application writes 1 to the bit, it might not
 * 
 * be able to read back the value as it will get cleared by the core in a few clock
 * cycles.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description             
 * :-----------------------------------------|:------|:-------------------------
 *  ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_E_NOTACT | 0x0   | No reset                
 *  ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_E_ACT    | 0x1   | Host Frame Counter Reset
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_FRMCNTRRST
 * 
 * No reset
 */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_E_NOTACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_FRMCNTRRST
 * 
 * Host Frame Counter Reset
 */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_E_ACT       0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRSTCTL_FRMCNTRRST register field. */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRSTCTL_FRMCNTRRST register field. */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_MSB        2
/* The width in bits of the ALT_USB_GLOB_GRSTCTL_FRMCNTRRST register field. */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GRSTCTL_FRMCNTRRST register field value. */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_GLOB_GRSTCTL_FRMCNTRRST register field value. */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_GLOB_GRSTCTL_FRMCNTRRST register field. */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRSTCTL_FRMCNTRRST field value from a register. */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_GLOB_GRSTCTL_FRMCNTRRST register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : rxfflsh
 * 
 * Mode:Host and Device
 * 
 * RxFIFO Flush (RxFFlsh)
 * 
 * The application can flush the entire RxFIFO using this bit, but
 * 
 * must first ensure that the core is not in the middle of a
 * 
 * transaction.
 * 
 * The application must only write to this bit after checking that the
 * 
 * core is neither reading from the RxFIFO nor writing to the
 * 
 * RxFIFO.
 * 
 * The application must wait until the bit is cleared before
 * 
 * performing any other operations. This bit requires 8 clocks
 * 
 * (slowest of PHY or AHB clock) to clear.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description               
 * :-------------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GRSTCTL_RXFFLSH_E_INACT | 0x0   | no flush the entire RxFIFO
 *  ALT_USB_GLOB_GRSTCTL_RXFFLSH_E_ACT   | 0x1   | flush the entire RxFIFO   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_RXFFLSH
 * 
 * no flush the entire RxFIFO
 */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_RXFFLSH
 * 
 * flush the entire RxFIFO
 */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRSTCTL_RXFFLSH register field. */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRSTCTL_RXFFLSH register field. */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_MSB        4
/* The width in bits of the ALT_USB_GLOB_GRSTCTL_RXFFLSH register field. */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GRSTCTL_RXFFLSH register field value. */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_GLOB_GRSTCTL_RXFFLSH register field value. */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_GLOB_GRSTCTL_RXFFLSH register field. */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRSTCTL_RXFFLSH field value from a register. */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_GLOB_GRSTCTL_RXFFLSH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : txfflsh
 * 
 * Mode:Host and Device
 * 
 * TxFIFO Flush (TxFFlsh)
 * 
 * This bit selectively flushes a single or all transmit FIFOs, but
 * 
 * cannot do so If the core is in the midst of a transaction.
 * 
 * The application must write this bit only after checking that the
 * 
 * core is neither writing to the TxFIFO nor reading from the
 * 
 * TxFIFO. Verify using these registers:
 * 
 * ReadNAK Effective Interrupt ensures the core is not
 * 
 * reading from the FIFO
 * 
 * WriteGRSTCTL.AHBIdle ensures the core is not writing
 * 
 * anything to the FIFO.
 * 
 * Flushing is normally recommended when FIFOs are
 * 
 * reconfigured or when switching between Shared FIFO and
 * 
 * Dedicated Transmit FIFO operation. FIFO flushing is also
 * 
 * recommended during device endpoint disable.
 * 
 * The application must wait until the core clears this bit before
 * 
 * performing any operations. This bit takes eight clocks to clear,
 * 
 * using the slower clock of phy_clk or hclk.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                 
 * :-------------------------------------|:------|:---------------------------------------------
 *  ALT_USB_GLOB_GRSTCTL_TXFFLSH_E_INACT | 0x0   | No Flush                                    
 *  ALT_USB_GLOB_GRSTCTL_TXFFLSH_E_ACT   | 0x1   | selectively flushes a single or all transmit
 * :                                     |       | FIFOs                                       
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_TXFFLSH
 * 
 * No Flush
 */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_TXFFLSH
 * 
 * selectively flushes a single or all transmit FIFOs
 */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRSTCTL_TXFFLSH register field. */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRSTCTL_TXFFLSH register field. */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_MSB        5
/* The width in bits of the ALT_USB_GLOB_GRSTCTL_TXFFLSH register field. */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GRSTCTL_TXFFLSH register field value. */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_GLOB_GRSTCTL_TXFFLSH register field value. */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_GLOB_GRSTCTL_TXFFLSH register field. */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRSTCTL_TXFFLSH field value from a register. */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_GLOB_GRSTCTL_TXFFLSH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : txfnum
 * 
 * Mode:Host and Device
 * 
 * TxFIFO Number (TxFNum)
 * 
 * This is the FIFO number that must be flushed using the TxFIFO
 * 
 * Flush bit. This field must not be changed until the core clears the
 * 
 * TxFIFO Flush bit.
 * 
 * 5'h0:
 * 
 * * Non-periodic TxFIFO flush in Host mode
 * 
 * * Non-periodic TxFIFO flush in device mode when in shared
 * 
 * FIFO operation
 * 
 * * Tx FIFO 0 flush in device mode when in dedicated FIFO
 * 
 * mode
 * 
 * 5'h1:
 * 
 * * Periodic TxFIFO flush in Host mode
 * 
 * * Periodic TxFIFO 1 flush in Device mode when in shared
 * 
 * FIFO operation
 * 
 * * TXFIFO 1 flush in device mode when in dedicated FIFO
 * 
 * mode
 * 
 * 5'h2:
 * 
 * * Periodic TxFIFO 2 flush in Device mode when in shared
 * 
 * FIFO operation
 * 
 * * TXFIFO 2 flush in device mode when in dedicated FIFO
 * 
 * mode
 * 
 * ...
 * 
 * 5'hF:
 * 
 * * Periodic TxFIFO 15 flush in Device mode when in shared
 * 
 * FIFO operation
 * 
 * * TXFIFO 15 flush in device mode when in dedicated FIFO
 * 
 * mode
 * 
 * 5'h10: Flush all the transmit FIFOs in device or host mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                                     
 * :------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF0  | 0x0   | - Non-periodic TxFIFO flush in Host mode - Non- 
 * :                                    |       | periodic TxFIFO flush in device mode when in    
 * :                                    |       | shared FIFO operation                           
 *  ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF1  | 0x1   | - Periodic TxFIFO flush in Host mode - Periodic 
 * :                                    |       | TxFIFO 1 flush in Device mode when in sharedFIFO
 * :                                    |       | operation                                       
 *  ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF2  | 0x2   | - Periodic TxFIFO 2 flush in Device mode when in
 * :                                    |       | sharedFIFO operation- TXFIFO 2 flush in device  
 * :                                    |       | mode when in dedicated FIFO mode                
 *  ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF15 | 0xf   | - Periodic TxFIFO 15 flush in Device mode when  
 * :                                    |       | in shared FIFO operation - TXFIFO 15 flush in   
 * :                                    |       | device mode when in dedicated FIFO mode         
 *  ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF16 | 0x10  | Flush all the transmit FIFOs in device or host  
 * :                                    |       | mode.                                           
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_TXFNUM
 * 
 * * Non-periodic TxFIFO flush in Host mode
 * 
 * * Non-periodic TxFIFO flush in device mode when in shared FIFO operation
 */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF0  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_TXFNUM
 * 
 * * Periodic TxFIFO flush in Host mode
 * 
 * * Periodic TxFIFO 1 flush in Device mode when in sharedFIFO operation
 */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF1  0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_TXFNUM
 * 
 * * Periodic TxFIFO 2 flush in Device mode when in sharedFIFO operation- TXFIFO 2
 *   flush in device mode when in dedicated FIFO mode
 */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF2  0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_TXFNUM
 * 
 * * Periodic TxFIFO 15 flush in Device mode when in shared FIFO operation
 * 
 * * TXFIFO 15 flush in device mode when in dedicated FIFO mode
 */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF15 0xf
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_TXFNUM
 * 
 * Flush all the transmit FIFOs in device or host mode.
 */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF16 0x10

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRSTCTL_TXFNUM register field. */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRSTCTL_TXFNUM register field. */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_MSB        10
/* The width in bits of the ALT_USB_GLOB_GRSTCTL_TXFNUM register field. */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_WIDTH      5
/* The mask used to set the ALT_USB_GLOB_GRSTCTL_TXFNUM register field value. */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_SET_MSK    0x000007c0
/* The mask used to clear the ALT_USB_GLOB_GRSTCTL_TXFNUM register field value. */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_CLR_MSK    0xfffff83f
/* The reset value of the ALT_USB_GLOB_GRSTCTL_TXFNUM register field. */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRSTCTL_TXFNUM field value from a register. */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_GET(value) (((value) & 0x000007c0) >> 6)
/* Produces a ALT_USB_GLOB_GRSTCTL_TXFNUM register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_SET(value) (((value) << 6) & 0x000007c0)

/*
 * Field : dmareq
 * 
 * Mode:Host and Device
 * 
 * DMA Request Signal (DMAReq)
 * 
 * Indicates that the DMA request is in progress. Used For debug.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description               
 * :------------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GRSTCTL_DMAREQ_E_INACT | 0x0   | No DMA request            
 *  ALT_USB_GLOB_GRSTCTL_DMAREQ_E_ACT   | 0x1   | DMA request is in progress
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_DMAREQ
 * 
 * No DMA request
 */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_DMAREQ
 * 
 * DMA request is in progress
 */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRSTCTL_DMAREQ register field. */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRSTCTL_DMAREQ register field. */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_MSB        30
/* The width in bits of the ALT_USB_GLOB_GRSTCTL_DMAREQ register field. */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GRSTCTL_DMAREQ register field value. */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_GLOB_GRSTCTL_DMAREQ register field value. */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_GLOB_GRSTCTL_DMAREQ register field. */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRSTCTL_DMAREQ field value from a register. */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_GLOB_GRSTCTL_DMAREQ register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : ahbidle
 * 
 * Mode:Host and Device
 * 
 * AHB Master Idle (AHBIdle)
 * 
 * Indicates that the AHB Master State Machine is in the IDLE
 * 
 * condition.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description    
 * :-------------------------------------|:------|:----------------
 *  ALT_USB_GLOB_GRSTCTL_AHBIDLE_E_INACT | 0x0   | Not Idle       
 *  ALT_USB_GLOB_GRSTCTL_AHBIDLE_E_ACT   | 0x1   | AHB Master Idle
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_AHBIDLE
 * 
 * Not Idle
 */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_AHBIDLE
 * 
 * AHB Master Idle
 */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRSTCTL_AHBIDLE register field. */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRSTCTL_AHBIDLE register field. */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_MSB        31
/* The width in bits of the ALT_USB_GLOB_GRSTCTL_AHBIDLE register field. */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GRSTCTL_AHBIDLE register field value. */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_GLOB_GRSTCTL_AHBIDLE register field value. */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_GLOB_GRSTCTL_AHBIDLE register field. */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_RESET      0x1
/* Extracts the ALT_USB_GLOB_GRSTCTL_AHBIDLE field value from a register. */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_GLOB_GRSTCTL_AHBIDLE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GRSTCTL.
 */
struct ALT_USB_GLOB_GRSTCTL_s
{
    uint32_t        csftrst     :  1;  /* ALT_USB_GLOB_GRSTCTL_CSFTRST */
    uint32_t        piufssftrst :  1;  /* ALT_USB_GLOB_GRSTCTL_PIUFSSFTRST */
    uint32_t        frmcntrrst  :  1;  /* ALT_USB_GLOB_GRSTCTL_FRMCNTRRST */
    uint32_t                    :  1;  /* *UNDEFINED* */
    uint32_t        rxfflsh     :  1;  /* ALT_USB_GLOB_GRSTCTL_RXFFLSH */
    uint32_t        txfflsh     :  1;  /* ALT_USB_GLOB_GRSTCTL_TXFFLSH */
    uint32_t        txfnum      :  5;  /* ALT_USB_GLOB_GRSTCTL_TXFNUM */
    uint32_t                    : 19;  /* *UNDEFINED* */
    const uint32_t  dmareq      :  1;  /* ALT_USB_GLOB_GRSTCTL_DMAREQ */
    const uint32_t  ahbidle     :  1;  /* ALT_USB_GLOB_GRSTCTL_AHBIDLE */
};

/* The typedef declaration for register ALT_USB_GLOB_GRSTCTL. */
typedef volatile struct ALT_USB_GLOB_GRSTCTL_s  ALT_USB_GLOB_GRSTCTL_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GRSTCTL register. */
#define ALT_USB_GLOB_GRSTCTL_RESET       0x80000000
/* The byte offset of the ALT_USB_GLOB_GRSTCTL register from the beginning of the component. */
#define ALT_USB_GLOB_GRSTCTL_OFST        0x10
/* The address of the ALT_USB_GLOB_GRSTCTL register. */
#define ALT_USB_GLOB_GRSTCTL_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GRSTCTL_OFST))

/*
 * Register : gintsts
 * 
 * Interrupt Register
 * 
 * Register Layout
 * 
 *  Bits  | Access | Reset | Description                      
 * :------|:-------|:------|:----------------------------------
 *  [0]   | R      | 0x0   | ALT_USB_GLOB_GINTSTS_CURMOD      
 *  [1]   | RW     | 0x0   | ALT_USB_GLOB_GINTSTS_MODMIS      
 *  [2]   | R      | 0x0   | ALT_USB_GLOB_GINTSTS_OTGINT      
 *  [3]   | RW     | 0x0   | ALT_USB_GLOB_GINTSTS_SOF         
 *  [4]   | R      | 0x0   | ALT_USB_GLOB_GINTSTS_RXFLVL      
 *  [5]   | R      | 0x1   | ALT_USB_GLOB_GINTSTS_NPTXFEMP    
 *  [6]   | R      | 0x0   | ALT_USB_GLOB_GINTSTS_GINNAKEFF   
 *  [7]   | R      | 0x0   | ALT_USB_GLOB_GINTSTS_GOUTNAKEFF  
 *  [9:8] | ???    | 0x0   | *UNDEFINED*                      
 *  [10]  | RW     | 0x0   | ALT_USB_GLOB_GINTSTS_ERLYSUSP    
 *  [11]  | RW     | 0x0   | ALT_USB_GLOB_GINTSTS_USBSUSP     
 *  [12]  | RW     | 0x0   | ALT_USB_GLOB_GINTSTS_USBRST      
 *  [13]  | RW     | 0x0   | ALT_USB_GLOB_GINTSTS_ENUMDONE    
 *  [14]  | RW     | 0x0   | ALT_USB_GLOB_GINTSTS_ISOOUTDROP  
 *  [15]  | RW     | 0x0   | ALT_USB_GLOB_GINTSTS_EOPF        
 *  [16]  | ???    | 0x0   | *UNDEFINED*                      
 *  [17]  | RW     | 0x0   | ALT_USB_GLOB_GINTSTS_EPMIS       
 *  [18]  | R      | 0x0   | ALT_USB_GLOB_GINTSTS_IEPINT      
 *  [19]  | R      | 0x0   | ALT_USB_GLOB_GINTSTS_OEPINT      
 *  [20]  | RW     | 0x0   | ALT_USB_GLOB_GINTSTS_INCOMPISOIN 
 *  [21]  | RW     | 0x0   | ALT_USB_GLOB_GINTSTS_INCOMPLP    
 *  [22]  | RW     | 0x0   | ALT_USB_GLOB_GINTSTS_FETSUSP     
 *  [23]  | RW     | 0x0   | ALT_USB_GLOB_GINTSTS_RSTDET      
 *  [24]  | R      | 0x0   | ALT_USB_GLOB_GINTSTS_PRTINT      
 *  [25]  | R      | 0x0   | ALT_USB_GLOB_GINTSTS_HCHINT      
 *  [26]  | R      | 0x1   | ALT_USB_GLOB_GINTSTS_PTXFEMP     
 *  [27]  | ???    | 0x0   | *UNDEFINED*                      
 *  [28]  | RW     | 0x1   | ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG
 *  [29]  | RW     | 0x0   | ALT_USB_GLOB_GINTSTS_DISCONNINT  
 *  [30]  | RW     | 0x0   | ALT_USB_GLOB_GINTSTS_SESSREQINT  
 *  [31]  | RW     | 0x0   | ALT_USB_GLOB_GINTSTS_WKUPINT     
 * 
 */
/*
 * Field : curmod
 * 
 * Mode: Host and Device
 * 
 * Current Mode of Operation (CurMod)
 * 
 * Indicates the current mode.
 * 
 * 1'b0: Device mode
 * 
 * 1'b1: Host mode
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GINTSTS_CURMOD_E_DEVICE | 0x0   | Device mode
 *  ALT_USB_GLOB_GINTSTS_CURMOD_E_HOST   | 0x1   | Host mode  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_CURMOD
 * 
 * Device mode
 */
#define ALT_USB_GLOB_GINTSTS_CURMOD_E_DEVICE    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_CURMOD
 * 
 * Host mode
 */
#define ALT_USB_GLOB_GINTSTS_CURMOD_E_HOST      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_CURMOD register field. */
#define ALT_USB_GLOB_GINTSTS_CURMOD_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_CURMOD register field. */
#define ALT_USB_GLOB_GINTSTS_CURMOD_MSB        0
/* The width in bits of the ALT_USB_GLOB_GINTSTS_CURMOD register field. */
#define ALT_USB_GLOB_GINTSTS_CURMOD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_CURMOD register field value. */
#define ALT_USB_GLOB_GINTSTS_CURMOD_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_CURMOD register field value. */
#define ALT_USB_GLOB_GINTSTS_CURMOD_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_GLOB_GINTSTS_CURMOD register field. */
#define ALT_USB_GLOB_GINTSTS_CURMOD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_CURMOD field value from a register. */
#define ALT_USB_GLOB_GINTSTS_CURMOD_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_GLOB_GINTSTS_CURMOD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_CURMOD_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : modemis
 * 
 * Mode: Host and Device
 * 
 * Mode Mismatch Interrupt (ModeMis)
 * 
 * The core sets this bit when the application is trying to access:
 * 
 * A Host mode register, when the core is operating in Device
 * 
 * mode
 * 
 * A Device mode register, when the core is operating in Host
 * 
 * mode
 * 
 * The register access is completed on the AHB with an OKAY
 * 
 * response, but is ignored by the core internally and does not
 * 
 * affect the operation of the core.This bit can be set only by the core and the
 * application should write 1 to clear
 * 
 * it
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description               
 * :------------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GINTSTS_MODMIS_E_INACT | 0x0   | No Mode Mismatch Interrupt
 *  ALT_USB_GLOB_GINTSTS_MODMIS_E_ACT   | 0x1   | Mode Mismatch Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_MODMIS
 * 
 * No Mode Mismatch Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_MODMIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_MODMIS
 * 
 * Mode Mismatch Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_MODMIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_MODMIS register field. */
#define ALT_USB_GLOB_GINTSTS_MODMIS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_MODMIS register field. */
#define ALT_USB_GLOB_GINTSTS_MODMIS_MSB        1
/* The width in bits of the ALT_USB_GLOB_GINTSTS_MODMIS register field. */
#define ALT_USB_GLOB_GINTSTS_MODMIS_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_MODMIS register field value. */
#define ALT_USB_GLOB_GINTSTS_MODMIS_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_MODMIS register field value. */
#define ALT_USB_GLOB_GINTSTS_MODMIS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_GLOB_GINTSTS_MODMIS register field. */
#define ALT_USB_GLOB_GINTSTS_MODMIS_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_MODMIS field value from a register. */
#define ALT_USB_GLOB_GINTSTS_MODMIS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_GLOB_GINTSTS_MODMIS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_MODMIS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : otgint
 * 
 * Mode: Host and Device
 * 
 * OTG Interrupt (OTGInt)
 * 
 * The core sets this bit to indicate an OTG protocol event. The
 * 
 * application must read the OTG Interrupt Status (GOTGINT)
 * 
 * register to determine the exact event that caused this interrupt.
 * 
 * The application must clear the appropriate status bit in the
 * 
 * GOTGINT register to clear this bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description  
 * :------------------------------------|:------|:--------------
 *  ALT_USB_GLOB_GINTSTS_OTGINT_E_INACT | 0x0   | No Interrupt 
 *  ALT_USB_GLOB_GINTSTS_OTGINT_E_ACT   | 0x1   | OTG Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_OTGINT
 * 
 * No Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_OTGINT_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_OTGINT
 * 
 * OTG Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_OTGINT_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_OTGINT register field. */
#define ALT_USB_GLOB_GINTSTS_OTGINT_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_OTGINT register field. */
#define ALT_USB_GLOB_GINTSTS_OTGINT_MSB        2
/* The width in bits of the ALT_USB_GLOB_GINTSTS_OTGINT register field. */
#define ALT_USB_GLOB_GINTSTS_OTGINT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_OTGINT register field value. */
#define ALT_USB_GLOB_GINTSTS_OTGINT_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_OTGINT register field value. */
#define ALT_USB_GLOB_GINTSTS_OTGINT_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_GLOB_GINTSTS_OTGINT register field. */
#define ALT_USB_GLOB_GINTSTS_OTGINT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_OTGINT field value from a register. */
#define ALT_USB_GLOB_GINTSTS_OTGINT_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_GLOB_GINTSTS_OTGINT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_OTGINT_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : sof
 * 
 * Mode: Host and Device
 * 
 * Start of (micro)Frame (Sof)
 * 
 * In Host mode, the core sets this bit to indicate that an SOF (FS),
 * 
 * micro-SOF (HS), or Keep-Alive (LS) is transmitted on the USB.
 * 
 * The application must write a 1 to this bit to clear the interrupt.
 * 
 * In Device mode, in the core sets this bit to indicate that an SOF
 * 
 * token has been received on the USB. The application can read
 * 
 * the Device Status register to get the current (micro)Frame
 * 
 * number. This interrupt is seen only when the core is operating at
 * 
 * either HS or FS.
 * 
 * Note: This register may return 1'b1 if read immediately after power on
 * 
 * reset. If the register bit reads 1'b1 immediately after power on reset it does
 * 
 * not indicate that an SOF has been sent (in case of host mode) or SOF has
 * 
 * been received (in case of device mode). The read value of this interrupt is
 * 
 * valid only after a valid connection between host and device is established. If
 * 
 * the bit is set after power on reset the application can clear the bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description   
 * :----------------------------------|:------|:---------------
 *  ALT_USB_GLOB_GINTSTS_SOF_E_INTACT | 0x0   | No sof        
 *  ALT_USB_GLOB_GINTSTS_SOF_E_ACT    | 0x1   | Start of Frame
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_SOF
 * 
 * No sof
 */
#define ALT_USB_GLOB_GINTSTS_SOF_E_INTACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_SOF
 * 
 * Start of Frame
 */
#define ALT_USB_GLOB_GINTSTS_SOF_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_SOF register field. */
#define ALT_USB_GLOB_GINTSTS_SOF_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_SOF register field. */
#define ALT_USB_GLOB_GINTSTS_SOF_MSB        3
/* The width in bits of the ALT_USB_GLOB_GINTSTS_SOF register field. */
#define ALT_USB_GLOB_GINTSTS_SOF_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_SOF register field value. */
#define ALT_USB_GLOB_GINTSTS_SOF_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_SOF register field value. */
#define ALT_USB_GLOB_GINTSTS_SOF_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_GLOB_GINTSTS_SOF register field. */
#define ALT_USB_GLOB_GINTSTS_SOF_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_SOF field value from a register. */
#define ALT_USB_GLOB_GINTSTS_SOF_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_GLOB_GINTSTS_SOF register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_SOF_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : rxflvl
 * 
 * Mode: Host and Device
 * 
 * RxFIFO Non-Empty (RxFLvl)
 * 
 * Indicates that there is at least one packet pending to be read
 * 
 * from the RxFIFO.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description      
 * :------------------------------------|:------|:------------------
 *  ALT_USB_GLOB_GINTSTS_RXFLVL_E_INACT | 0x0   | Not Active       
 *  ALT_USB_GLOB_GINTSTS_RXFLVL_E_ACT   | 0x1   | Rx Fifo Non Empty
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_RXFLVL
 * 
 * Not Active
 */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_RXFLVL
 * 
 * Rx Fifo Non Empty
 */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_RXFLVL register field. */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_RXFLVL register field. */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_MSB        4
/* The width in bits of the ALT_USB_GLOB_GINTSTS_RXFLVL register field. */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_RXFLVL register field value. */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_RXFLVL register field value. */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_GLOB_GINTSTS_RXFLVL register field. */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_RXFLVL field value from a register. */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_GLOB_GINTSTS_RXFLVL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : nptxfemp
 * 
 * Mode: Host and Device
 * 
 * Non-periodic TxFIFO Empty (NPTxFEmp)
 * 
 * This interrupt is asserted when the Non-periodic TxFIFO is
 * 
 * either half or completely empty, and there is space For at least
 * 
 * one Entry to be written to the Non-periodic Transmit Request
 * 
 * Queue. The half or completely empty status is determined by
 * 
 * the Non-periodic TxFIFO Empty Level bit in the Core AHB
 * 
 * Configuration register (GAHBCFG.NPTxFEmpLvl).
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_NPTXFEMP register field. */
#define ALT_USB_GLOB_GINTSTS_NPTXFEMP_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_NPTXFEMP register field. */
#define ALT_USB_GLOB_GINTSTS_NPTXFEMP_MSB        5
/* The width in bits of the ALT_USB_GLOB_GINTSTS_NPTXFEMP register field. */
#define ALT_USB_GLOB_GINTSTS_NPTXFEMP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_NPTXFEMP register field value. */
#define ALT_USB_GLOB_GINTSTS_NPTXFEMP_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_NPTXFEMP register field value. */
#define ALT_USB_GLOB_GINTSTS_NPTXFEMP_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_GLOB_GINTSTS_NPTXFEMP register field. */
#define ALT_USB_GLOB_GINTSTS_NPTXFEMP_RESET      0x1
/* Extracts the ALT_USB_GLOB_GINTSTS_NPTXFEMP field value from a register. */
#define ALT_USB_GLOB_GINTSTS_NPTXFEMP_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_GLOB_GINTSTS_NPTXFEMP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_NPTXFEMP_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : ginnakeff
 * 
 * Mode: Device only
 * 
 * Global IN Non-periodic NAK Effective (GINNakEff)
 * 
 * Indicates that the Set Global Non-periodic IN NAK bit in the
 * 
 * Device Control register (DCTL.SGNPInNak), Set by the
 * 
 * application, has taken effect in the core. That is, the core has
 * 
 * sampled the Global IN NAK bit Set by the application. This bit
 * 
 * can be cleared by clearing the Clear Global Non-periodic IN
 * 
 * NAK bit in the Device Control register (DCTL.CGNPInNak).
 * 
 * This interrupt does not necessarily mean that a NAK handshake
 * 
 * is sent out on the USB. The STALL bit takes precedence over
 * 
 * the NAK bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                      
 * :---------------------------------------|:------|:----------------------------------
 *  ALT_USB_GLOB_GINTSTS_GINNAKEFF_E_INACT | 0x0   | Not active                       
 *  ALT_USB_GLOB_GINTSTS_GINNAKEFF_E_ACT   | 0x1   | Set Global Non-periodic IN NAK bi
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_GINNAKEFF
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_GINNAKEFF
 * 
 * Set Global Non-periodic IN NAK bi
 */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_GINNAKEFF register field. */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_GINNAKEFF register field. */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_MSB        6
/* The width in bits of the ALT_USB_GLOB_GINTSTS_GINNAKEFF register field. */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_GINNAKEFF register field value. */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_GINNAKEFF register field value. */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_GLOB_GINTSTS_GINNAKEFF register field. */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_GINNAKEFF field value from a register. */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_GLOB_GINTSTS_GINNAKEFF register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : goutnakeff
 * 
 * Mode: Device only
 * 
 * Global OUT NAK Effective (GOUTNakEff)
 * 
 * Indicates that the Set Global OUT NAK bit in the Device Control
 * 
 * register (DCTL.SGOUTNak), Set by the application, has taken
 * 
 * effect in the core. This bit can be cleared by writing the Clear
 * 
 * Global OUT NAK bit in the Device Control register
 * 
 * (DCTL.CGOUTNak).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description             
 * :----------------------------------------|:------|:-------------------------
 *  ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_E_INACT | 0x0   | No Active               
 *  ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_E_ACT   | 0x1   | Global OUT NAK Effective
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_GOUTNAKEFF
 * 
 * No Active
 */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_GOUTNAKEFF
 * 
 * Global OUT NAK Effective
 */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_GOUTNAKEFF register field. */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_GOUTNAKEFF register field. */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_MSB        7
/* The width in bits of the ALT_USB_GLOB_GINTSTS_GOUTNAKEFF register field. */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_GOUTNAKEFF register field value. */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_GOUTNAKEFF register field value. */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_GLOB_GINTSTS_GOUTNAKEFF register field. */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_GOUTNAKEFF field value from a register. */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_GLOB_GINTSTS_GOUTNAKEFF register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : erlysusp
 * 
 * Mode: Device only
 * 
 * Early Suspend (ErlySusp)
 * 
 * The core sets this bit to indicate that an Idle state has been
 * 
 * detected on the USB For 3 ms.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description        
 * :--------------------------------------|:------|:--------------------
 *  ALT_USB_GLOB_GINTSTS_ERLYSUSP_E_INACT | 0x0   | No Idle            
 *  ALT_USB_GLOB_GINTSTS_ERLYSUSP_E_ACT   | 0x1   | Idle state detecetd
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_ERLYSUSP
 * 
 * No Idle
 */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_ERLYSUSP
 * 
 * Idle state detecetd
 */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_ERLYSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_ERLYSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_MSB        10
/* The width in bits of the ALT_USB_GLOB_GINTSTS_ERLYSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_ERLYSUSP register field value. */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_SET_MSK    0x00000400
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_ERLYSUSP register field value. */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_CLR_MSK    0xfffffbff
/* The reset value of the ALT_USB_GLOB_GINTSTS_ERLYSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_ERLYSUSP field value from a register. */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_USB_GLOB_GINTSTS_ERLYSUSP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : usbsusp
 * 
 * Mode: Device only
 * 
 * USB Suspend (USBSusp)
 * 
 * The core sets this bit to indicate that a suspend was detected on
 * 
 * the USB. The core enters the Suspended state when there is no
 * 
 * activity on the linestate signal For an extended period of
 * 
 * time.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GINTSTS_USBSUSP_E_INACT | 0x0   | Not Active 
 *  ALT_USB_GLOB_GINTSTS_USBSUSP_E_ACT   | 0x1   | USB Suspend
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_USBSUSP
 * 
 * Not Active
 */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_USBSUSP
 * 
 * USB Suspend
 */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_USBSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_USBSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_MSB        11
/* The width in bits of the ALT_USB_GLOB_GINTSTS_USBSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_USBSUSP register field value. */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_USBSUSP register field value. */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_GLOB_GINTSTS_USBSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_USBSUSP field value from a register. */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_GLOB_GINTSTS_USBSUSP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : usbrst
 * 
 * Mode: Device only
 * 
 * USB Reset (USBRst)
 * 
 * The core sets this bit to indicate that a reset is detected on the
 * 
 * USB.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description
 * :------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GINTSTS_USBRST_E_INACT | 0x0   | Not active 
 *  ALT_USB_GLOB_GINTSTS_USBRST_E_ACT   | 0x1   | USB Reset  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_USBRST
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_USBRST_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_USBRST
 * 
 * USB Reset
 */
#define ALT_USB_GLOB_GINTSTS_USBRST_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_USBRST register field. */
#define ALT_USB_GLOB_GINTSTS_USBRST_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_USBRST register field. */
#define ALT_USB_GLOB_GINTSTS_USBRST_MSB        12
/* The width in bits of the ALT_USB_GLOB_GINTSTS_USBRST register field. */
#define ALT_USB_GLOB_GINTSTS_USBRST_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_USBRST register field value. */
#define ALT_USB_GLOB_GINTSTS_USBRST_SET_MSK    0x00001000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_USBRST register field value. */
#define ALT_USB_GLOB_GINTSTS_USBRST_CLR_MSK    0xffffefff
/* The reset value of the ALT_USB_GLOB_GINTSTS_USBRST register field. */
#define ALT_USB_GLOB_GINTSTS_USBRST_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_USBRST field value from a register. */
#define ALT_USB_GLOB_GINTSTS_USBRST_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_USB_GLOB_GINTSTS_USBRST register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_USBRST_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : enumdone
 * 
 * Mode: Device only
 * 
 * Enumeration Done (EnumDone)
 * 
 * The core sets this bit to indicate that speed enumeration is
 * 
 * complete. The application must read the Device Status (DSTS)
 * 
 * register to obtain the enumerated speed.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description     
 * :--------------------------------------|:------|:-----------------
 *  ALT_USB_GLOB_GINTSTS_ENUMDONE_E_INACT | 0x0   | Not active      
 *  ALT_USB_GLOB_GINTSTS_ENUMDONE_E_ACT   | 0x1   | Enumeration Done
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_ENUMDONE
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_ENUMDONE
 * 
 * Enumeration Done
 */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_ENUMDONE register field. */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_ENUMDONE register field. */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_MSB        13
/* The width in bits of the ALT_USB_GLOB_GINTSTS_ENUMDONE register field. */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_ENUMDONE register field value. */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_ENUMDONE register field value. */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_GLOB_GINTSTS_ENUMDONE register field. */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_ENUMDONE field value from a register. */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_GLOB_GINTSTS_ENUMDONE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : isooutdrop
 * 
 * Mode: Device only
 * 
 * Isochronous OUT Packet Dropped Interrupt (ISOOutDrop)
 * 
 * The core sets this bit when it fails to write an isochronous OUT
 * 
 * packet into the RxFIFO because the RxFIFO does not have
 * 
 * enough space to accommodate a maximum packet size packet
 * 
 * for the isochronous OUT endpoint.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                            
 * :----------------------------------------|:------|:----------------------------------------
 *  ALT_USB_GLOB_GINTSTS_ISOOUTDROP_E_INACT | 0x0   | Not active                             
 *  ALT_USB_GLOB_GINTSTS_ISOOUTDROP_E_ACT   | 0x1   | Isochronous OUT Packet Dropped Interrup
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_ISOOUTDROP
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_ISOOUTDROP
 * 
 * Isochronous OUT Packet Dropped Interrup
 */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_ISOOUTDROP register field. */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_ISOOUTDROP register field. */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_MSB        14
/* The width in bits of the ALT_USB_GLOB_GINTSTS_ISOOUTDROP register field. */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_ISOOUTDROP register field value. */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_SET_MSK    0x00004000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_ISOOUTDROP register field value. */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_CLR_MSK    0xffffbfff
/* The reset value of the ALT_USB_GLOB_GINTSTS_ISOOUTDROP register field. */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_ISOOUTDROP field value from a register. */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_USB_GLOB_GINTSTS_ISOOUTDROP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : eopf
 * 
 * Mode: Device only
 * 
 * End of Periodic Frame Interrupt (EOPF)
 * 
 * Indicates that the period specified in the Periodic Frame Interval
 * 
 * field of the Device Configuration register (DCFG.PerFrInt) has
 * 
 * been reached in the current microframe.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_EOPF register field. */
#define ALT_USB_GLOB_GINTSTS_EOPF_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_EOPF register field. */
#define ALT_USB_GLOB_GINTSTS_EOPF_MSB        15
/* The width in bits of the ALT_USB_GLOB_GINTSTS_EOPF register field. */
#define ALT_USB_GLOB_GINTSTS_EOPF_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_EOPF register field value. */
#define ALT_USB_GLOB_GINTSTS_EOPF_SET_MSK    0x00008000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_EOPF register field value. */
#define ALT_USB_GLOB_GINTSTS_EOPF_CLR_MSK    0xffff7fff
/* The reset value of the ALT_USB_GLOB_GINTSTS_EOPF register field. */
#define ALT_USB_GLOB_GINTSTS_EOPF_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_EOPF field value from a register. */
#define ALT_USB_GLOB_GINTSTS_EOPF_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_USB_GLOB_GINTSTS_EOPF register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_EOPF_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : epmis
 * 
 * Mode: Device only
 * 
 * Endpoint Mismatch Interrupt (EPMis)
 * 
 * Note: This interrupt is valid only in shared FIFO operation.
 * 
 * Indicates that an IN token has been received For a non-periodic
 * 
 * endpoint, but the data For another endpoint is present in the top
 * 
 * of the Non-periodic Transmit FIFO and the IN endpoint
 * 
 * mismatch count programmed by the application has expired.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description               
 * :-----------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GINTSTS_EPMIS_E_INACT | 0x0   | Not active                
 *  ALT_USB_GLOB_GINTSTS_EPMIS_E_ACT   | 0x1   | Endpoint Mismatch Interrup
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_EPMIS
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_EPMIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_EPMIS
 * 
 * Endpoint Mismatch Interrup
 */
#define ALT_USB_GLOB_GINTSTS_EPMIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_EPMIS register field. */
#define ALT_USB_GLOB_GINTSTS_EPMIS_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_EPMIS register field. */
#define ALT_USB_GLOB_GINTSTS_EPMIS_MSB        17
/* The width in bits of the ALT_USB_GLOB_GINTSTS_EPMIS register field. */
#define ALT_USB_GLOB_GINTSTS_EPMIS_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_EPMIS register field value. */
#define ALT_USB_GLOB_GINTSTS_EPMIS_SET_MSK    0x00020000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_EPMIS register field value. */
#define ALT_USB_GLOB_GINTSTS_EPMIS_CLR_MSK    0xfffdffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_EPMIS register field. */
#define ALT_USB_GLOB_GINTSTS_EPMIS_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_EPMIS field value from a register. */
#define ALT_USB_GLOB_GINTSTS_EPMIS_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_USB_GLOB_GINTSTS_EPMIS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_EPMIS_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : iepint
 * 
 * Mode: Device only
 * 
 * IN Endpoints Interrupt (IEPInt)
 * 
 * The core sets this bit to indicate that an interrupt is pending on
 * 
 * one of the IN endpoints of the core (in Device mode). The
 * 
 * application must read the Device All Endpoints Interrupt (DAINT)
 * 
 * register to determine the exact number of the IN endpoint on
 * 
 * Device IN Endpoint-n Interrupt (DIEPINTn) register to determine
 * 
 * the exact cause of the interrupt. The application must clear the
 * 
 * appropriate status bit in the corresponding DIEPINTn register to
 * 
 * clear this bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description           
 * :------------------------------------|:------|:-----------------------
 *  ALT_USB_GLOB_GINTSTS_IEPINT_E_INACT | 0x0   | Not active            
 *  ALT_USB_GLOB_GINTSTS_IEPINT_E_ACT   | 0x1   | IN Endpoints Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_IEPINT
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_IEPINT_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_IEPINT
 * 
 * IN Endpoints Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_IEPINT_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_IEPINT register field. */
#define ALT_USB_GLOB_GINTSTS_IEPINT_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_IEPINT register field. */
#define ALT_USB_GLOB_GINTSTS_IEPINT_MSB        18
/* The width in bits of the ALT_USB_GLOB_GINTSTS_IEPINT register field. */
#define ALT_USB_GLOB_GINTSTS_IEPINT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_IEPINT register field value. */
#define ALT_USB_GLOB_GINTSTS_IEPINT_SET_MSK    0x00040000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_IEPINT register field value. */
#define ALT_USB_GLOB_GINTSTS_IEPINT_CLR_MSK    0xfffbffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_IEPINT register field. */
#define ALT_USB_GLOB_GINTSTS_IEPINT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_IEPINT field value from a register. */
#define ALT_USB_GLOB_GINTSTS_IEPINT_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_USB_GLOB_GINTSTS_IEPINT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_IEPINT_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : oepint
 * 
 * Mode: Device only
 * 
 * OUT Endpoints Interrupt (OEPInt)
 * 
 * The core sets this bit to indicate that an interrupt is pending on
 * 
 * one of the OUT endpoints of the core (in Device mode). The
 * 
 * application must read the Device All Endpoints Interrupt (DAINT)
 * 
 * register to determine the exact number of the OUT endpoint on
 * 
 * which the interrupt occurred, and Then read the corresponding
 * 
 * Device OUT Endpoint-n Interrupt (DOEPINTn) register to
 * 
 * determine the exact cause of the interrupt. The application must
 * 
 * clear the appropriate status bit in the corresponding DOEPINTn
 * 
 * register to clear this bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description            
 * :------------------------------------|:------|:------------------------
 *  ALT_USB_GLOB_GINTSTS_OEPINT_E_INACT | 0x0   | Not active             
 *  ALT_USB_GLOB_GINTSTS_OEPINT_E_ACT   | 0x1   | OUT Endpoints Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_OEPINT
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_OEPINT_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_OEPINT
 * 
 * OUT Endpoints Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_OEPINT_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_OEPINT register field. */
#define ALT_USB_GLOB_GINTSTS_OEPINT_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_OEPINT register field. */
#define ALT_USB_GLOB_GINTSTS_OEPINT_MSB        19
/* The width in bits of the ALT_USB_GLOB_GINTSTS_OEPINT register field. */
#define ALT_USB_GLOB_GINTSTS_OEPINT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_OEPINT register field value. */
#define ALT_USB_GLOB_GINTSTS_OEPINT_SET_MSK    0x00080000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_OEPINT register field value. */
#define ALT_USB_GLOB_GINTSTS_OEPINT_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_OEPINT register field. */
#define ALT_USB_GLOB_GINTSTS_OEPINT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_OEPINT field value from a register. */
#define ALT_USB_GLOB_GINTSTS_OEPINT_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_USB_GLOB_GINTSTS_OEPINT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_OEPINT_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : incompisoin
 * 
 * Mode: Device only
 * 
 * Incomplete Isochronous IN Transfer (incompISOIN)
 * 
 * The core sets this interrupt to indicate that there is at least one
 * 
 * isochronous IN endpoint on which the transfer is not completed
 * 
 * in the current microframe. This interrupt is asserted along with
 * 
 * the End of Periodic Frame Interrupt (EOPF) bit in this register.
 * 
 * Note: This interrupt is not asserted in Scatter/Gather DMA
 * 
 * mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                       
 * :-----------------------------------------|:------|:-----------------------------------
 *  ALT_USB_GLOB_GINTSTS_INCOMPISOIN_E_INACT | 0x0   | Not active                        
 *  ALT_USB_GLOB_GINTSTS_INCOMPISOIN_E_ACT   | 0x1   | Incomplete Isochronous IN Transfer
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_INCOMPISOIN
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_INCOMPISOIN
 * 
 * Incomplete Isochronous IN Transfer
 */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_INCOMPISOIN register field. */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_INCOMPISOIN register field. */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_MSB        20
/* The width in bits of the ALT_USB_GLOB_GINTSTS_INCOMPISOIN register field. */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_INCOMPISOIN register field value. */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_SET_MSK    0x00100000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_INCOMPISOIN register field value. */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_CLR_MSK    0xffefffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_INCOMPISOIN register field. */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_INCOMPISOIN field value from a register. */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_USB_GLOB_GINTSTS_INCOMPISOIN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : incomplp
 * 
 * Incomplete Periodic Transfer (incomplP)
 * 
 * In Host mode, the core sets this interrupt bit when there are
 * 
 * incomplete periodic transactions still pending which are
 * 
 * scheduled For the current microframe.
 * 
 * Incomplete Isochronous OUT Transfer (incompISOOUT)
 * 
 * The Device mode, the core sets this interrupt to indicate that
 * 
 * there is at least one isochronous OUT endpoint on which the
 * 
 * transfer is not completed in the current microframe. This
 * 
 * interrupt is asserted along with the End of Periodic Frame
 * 
 * Interrupt (EOPF) bit in this register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                 
 * :--------------------------------------|:------|:-----------------------------
 *  ALT_USB_GLOB_GINTSTS_INCOMPLP_E_INACT | 0x0   | Not active                  
 *  ALT_USB_GLOB_GINTSTS_INCOMPLP_E_ACT   | 0x1   | Incomplete Periodic Transfer
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_INCOMPLP
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_INCOMPLP
 * 
 * Incomplete Periodic Transfer
 */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_INCOMPLP register field. */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_INCOMPLP register field. */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_MSB        21
/* The width in bits of the ALT_USB_GLOB_GINTSTS_INCOMPLP register field. */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_INCOMPLP register field value. */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_SET_MSK    0x00200000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_INCOMPLP register field value. */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_CLR_MSK    0xffdfffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_INCOMPLP register field. */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_INCOMPLP field value from a register. */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_USB_GLOB_GINTSTS_INCOMPLP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : fetsusp
 * 
 * Mode: Device only
 * 
 * Data Fetch Suspended (FetSusp)
 * 
 * This interrupt is valid only in DMA mode. This interrupt indicates
 * 
 * that the core has stopped fetching data For IN endpoints due to
 * 
 * the unavailability of TxFIFO space or Request Queue space.
 * 
 * This interrupt is used by the application For an endpoint
 * 
 * mismatch algorithm.
 * 
 * For example, after detecting an endpoint mismatch, the
 * 
 * application:
 * 
 * Sets a Global non-periodic IN NAK handshake
 * 
 * Disables In endpoints
 * 
 * Flushes the FIFO
 * 
 * Determines the token sequence from the IN Token Sequence
 * 
 * Learning Queue
 * 
 * Re-enables the endpoints
 * 
 * Clears the Global non-periodic IN NAK handshake
 * 
 * If the Global non-periodic IN NAK is cleared, the core has not yet
 * 
 * fetched data For the IN endpoint, and the IN token is received:
 * 
 * the core generates an 'IN token received when FIFO empty'
 * 
 * interrupt. The OTG Then sends the host a NAK response. To
 * 
 * avoid this scenario, the application can check the
 * 
 * GINTSTS.FetSusp interrupt, which ensures that the FIFO is full
 * 
 * before clearing a Global NAK handshake.
 * 
 * Alternatively, the application can mask the "IN token received
 * 
 * when FIFO empty" interrupt when clearing a Global IN NAK
 * 
 * handshake.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description         
 * :-------------------------------------|:------|:---------------------
 *  ALT_USB_GLOB_GINTSTS_FETSUSP_E_INACT | 0x0   | Not active          
 *  ALT_USB_GLOB_GINTSTS_FETSUSP_E_ACT   | 0x1   | Data Fetch Suspended
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_FETSUSP
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_FETSUSP
 * 
 * Data Fetch Suspended
 */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_FETSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_FETSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_MSB        22
/* The width in bits of the ALT_USB_GLOB_GINTSTS_FETSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_FETSUSP register field value. */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_SET_MSK    0x00400000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_FETSUSP register field value. */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_CLR_MSK    0xffbfffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_FETSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_FETSUSP field value from a register. */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_USB_GLOB_GINTSTS_FETSUSP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : resetdet
 * 
 * Mode: Device only
 * 
 * Reset detected Interrupt  (ResetDet)
 * 
 * In Device mode, this interrupt is asserted when a reset is detected on the USB
 * in
 * 
 * partial power-down mode when the device is in Suspend.
 * 
 * In Host mode, this interrupt is not asserted.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description            
 * :------------------------------------|:------|:------------------------
 *  ALT_USB_GLOB_GINTSTS_RSTDET_E_INACT | 0x0   | Not active             
 *  ALT_USB_GLOB_GINTSTS_RSTDET_E_ACT   | 0x1   | Reset detected Interrup
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_RSTDET
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_RSTDET_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_RSTDET
 * 
 * Reset detected Interrup
 */
#define ALT_USB_GLOB_GINTSTS_RSTDET_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_RSTDET register field. */
#define ALT_USB_GLOB_GINTSTS_RSTDET_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_RSTDET register field. */
#define ALT_USB_GLOB_GINTSTS_RSTDET_MSB        23
/* The width in bits of the ALT_USB_GLOB_GINTSTS_RSTDET register field. */
#define ALT_USB_GLOB_GINTSTS_RSTDET_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_RSTDET register field value. */
#define ALT_USB_GLOB_GINTSTS_RSTDET_SET_MSK    0x00800000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_RSTDET register field value. */
#define ALT_USB_GLOB_GINTSTS_RSTDET_CLR_MSK    0xff7fffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_RSTDET register field. */
#define ALT_USB_GLOB_GINTSTS_RSTDET_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_RSTDET field value from a register. */
#define ALT_USB_GLOB_GINTSTS_RSTDET_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_USB_GLOB_GINTSTS_RSTDET register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_RSTDET_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : prtint
 * 
 * Mode:Host only
 * 
 * Host Port Interrupt (PrtInt)
 * 
 * The core sets this bit to indicate a change in port status of one of
 * 
 * the DWC_otg core ports in Host mode. The application must
 * 
 * read the Host Port Control and Status (HPRT) register to
 * 
 * determine the exact event that caused this interrupt. The
 * 
 * application must clear the appropriate status bit in the Host Port
 * 
 * Control and Status register to clear this bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description        
 * :------------------------------------|:------|:--------------------
 *  ALT_USB_GLOB_GINTSTS_PRTINT_E_INACT | 0x0   |                    
 *  ALT_USB_GLOB_GINTSTS_PRTINT_E_ACT   | 0x1   | Host Port Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_PRTINT
 * 
 */
#define ALT_USB_GLOB_GINTSTS_PRTINT_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_PRTINT
 * 
 * Host Port Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_PRTINT_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_PRTINT register field. */
#define ALT_USB_GLOB_GINTSTS_PRTINT_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_PRTINT register field. */
#define ALT_USB_GLOB_GINTSTS_PRTINT_MSB        24
/* The width in bits of the ALT_USB_GLOB_GINTSTS_PRTINT register field. */
#define ALT_USB_GLOB_GINTSTS_PRTINT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_PRTINT register field value. */
#define ALT_USB_GLOB_GINTSTS_PRTINT_SET_MSK    0x01000000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_PRTINT register field value. */
#define ALT_USB_GLOB_GINTSTS_PRTINT_CLR_MSK    0xfeffffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_PRTINT register field. */
#define ALT_USB_GLOB_GINTSTS_PRTINT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_PRTINT field value from a register. */
#define ALT_USB_GLOB_GINTSTS_PRTINT_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_USB_GLOB_GINTSTS_PRTINT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_PRTINT_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : hchint
 * 
 * Mode:Host only
 * 
 * Host Channels Interrupt (HChInt)
 * 
 * The core sets this bit to indicate that an interrupt is pending on
 * 
 * one of the channels of the core (in Host mode). The application
 * 
 * must read the Host All Channels Interrupt (HAINT) register to
 * 
 * determine the exact number of the channel on which the
 * 
 * interrupt occurred, and Then read the corresponding Host
 * 
 * Channel-n Interrupt (HCINTn) register to determine the exact
 * 
 * cause of the interrupt. The application must clear the
 * 
 * appropriate status bit in the HCINTn register to clear this bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description            
 * :------------------------------------|:------|:------------------------
 *  ALT_USB_GLOB_GINTSTS_HCHINT_E_INACT | 0x0   | Not active             
 *  ALT_USB_GLOB_GINTSTS_HCHINT_E_ACT   | 0x1   | Host Channels Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_HCHINT
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_HCHINT_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_HCHINT
 * 
 * Host Channels Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_HCHINT_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_HCHINT register field. */
#define ALT_USB_GLOB_GINTSTS_HCHINT_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_HCHINT register field. */
#define ALT_USB_GLOB_GINTSTS_HCHINT_MSB        25
/* The width in bits of the ALT_USB_GLOB_GINTSTS_HCHINT register field. */
#define ALT_USB_GLOB_GINTSTS_HCHINT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_HCHINT register field value. */
#define ALT_USB_GLOB_GINTSTS_HCHINT_SET_MSK    0x02000000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_HCHINT register field value. */
#define ALT_USB_GLOB_GINTSTS_HCHINT_CLR_MSK    0xfdffffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_HCHINT register field. */
#define ALT_USB_GLOB_GINTSTS_HCHINT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_HCHINT field value from a register. */
#define ALT_USB_GLOB_GINTSTS_HCHINT_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_USB_GLOB_GINTSTS_HCHINT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_HCHINT_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : ptxfemp
 * 
 * Mode:Host only
 * 
 * Periodic TxFIFO Empty (PTxFEmp)
 * 
 * This interrupt is asserted when the Periodic Transmit FIFO is either half or
 * 
 * completely empty and there is space for at least one entry to be written in
 * 
 * the Periodic Request Queue. The half or completely empty status is
 * 
 * determined by the Periodic TxFIFO Empty Level bit in the Core AHB
 * 
 * Configuration register (GAHBCFG.PTxFEmpLvl).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description          
 * :-------------------------------------|:------|:----------------------
 *  ALT_USB_GLOB_GINTSTS_PTXFEMP_E_INACT | 0x0   | Not active           
 *  ALT_USB_GLOB_GINTSTS_PTXFEMP_E_ACT   | 0x1   | Periodic TxFIFO Empty
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_PTXFEMP
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_PTXFEMP
 * 
 * Periodic TxFIFO Empty
 */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_PTXFEMP register field. */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_PTXFEMP register field. */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_MSB        26
/* The width in bits of the ALT_USB_GLOB_GINTSTS_PTXFEMP register field. */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_PTXFEMP register field value. */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_SET_MSK    0x04000000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_PTXFEMP register field value. */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_CLR_MSK    0xfbffffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_PTXFEMP register field. */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_RESET      0x1
/* Extracts the ALT_USB_GLOB_GINTSTS_PTXFEMP field value from a register. */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_USB_GLOB_GINTSTS_PTXFEMP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : conidstschng
 * 
 * Mode:Host and Device
 * 
 * Connector ID Status Change (ConIDStsChng)
 * 
 * The core sets this bit when there is a change in connector ID
 * 
 * status.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description               
 * :------------------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_E_INACT | 0x0   | Not Active                
 *  ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_E_ACT   | 0x1   | Connector ID Status Change
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG
 * 
 * Not Active
 */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG
 * 
 * Connector ID Status Change
 */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG register field. */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG register field. */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_MSB        28
/* The width in bits of the ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG register field. */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG register field value. */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_SET_MSK    0x10000000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG register field value. */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_CLR_MSK    0xefffffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG register field. */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_RESET      0x1
/* Extracts the ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG field value from a register. */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : disconnint
 * 
 * Mode:Host only
 * 
 * Disconnect Detected Interrupt (DisconnInt)
 * 
 * Asserted when a device disconnect is detected.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                  
 * :----------------------------------------|:------|:------------------------------
 *  ALT_USB_GLOB_GINTSTS_DISCONNINT_E_INACT | 0x0   | Not active                   
 *  ALT_USB_GLOB_GINTSTS_DISCONNINT_E_ACT   | 0x1   | Disconnect Detected Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_DISCONNINT
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_DISCONNINT
 * 
 * Disconnect Detected Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_DISCONNINT register field. */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_DISCONNINT register field. */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_MSB        29
/* The width in bits of the ALT_USB_GLOB_GINTSTS_DISCONNINT register field. */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_DISCONNINT register field value. */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_SET_MSK    0x20000000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_DISCONNINT register field value. */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_CLR_MSK    0xdfffffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_DISCONNINT register field. */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_DISCONNINT field value from a register. */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_USB_GLOB_GINTSTS_DISCONNINT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sessreqint
 * 
 * Mode:Host and Device
 * 
 * Session Request/New Session Detected Interrupt (SessReqInt)
 * 
 * In Host mode, this interrupt is asserted when a session request is detected
 * 
 * from the device. In Host mode, this interrupt is asserted when a session
 * 
 * request is detected from the device.
 * 
 * In Device mode, this interrupt is asserted when the utmisrp_bvalid signal
 * 
 * goes high.
 * 
 * For more information on how to use this interrupt, see 'Partial Power-Down
 * 
 * and Clock Gating Programming Model'.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                   
 * :----------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_GLOB_GINTSTS_SESSREQINT_E_INACT | 0x0   | Not active                                    
 *  ALT_USB_GLOB_GINTSTS_SESSREQINT_E_ACT   | 0x1   | Session Request New Session Detected Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_SESSREQINT
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_SESSREQINT
 * 
 * Session Request New Session Detected Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_SESSREQINT register field. */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_SESSREQINT register field. */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_MSB        30
/* The width in bits of the ALT_USB_GLOB_GINTSTS_SESSREQINT register field. */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_SESSREQINT register field value. */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_SESSREQINT register field value. */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_SESSREQINT register field. */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_SESSREQINT field value from a register. */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_GLOB_GINTSTS_SESSREQINT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : wkupint
 * 
 * Mode:Host and Device
 * 
 * Resume/Remote Wakeup Detected Interrupt (WkUpInt)
 * 
 * Wakeup Interrupt during Suspend(L2) or LPM(L1) state.
 * 
 * During Suspend(L2):
 * 
 * * Device Mode - This interrupt is asserted only when Host Initiated
 * 
 * Resume is detected on USB.
 * 
 * * Host Mode - This interrupt is asserted only when Device Initiated
 * 
 * Remote Wakeup is detected on USB.
 * 
 * For more information, see 'Partial Power-Down and Clock Gating
 * 
 * Programming Model'.
 * 
 * During LPM(L1):-
 * 
 * * Device Mode - This interrupt is asserted for either Host Initiated
 * 
 * Resume or Device Initiated Remote Wakeup on USB.
 * 
 * * Host Mode - This interrupt is asserted for either Host Initiated Resume
 * 
 * or Device Initiated Remote Wakeup on USB.
 * 
 * For more information, see 'LPM Entry and Exit Programming Model'
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                            
 * :-------------------------------------|:------|:----------------------------------------
 *  ALT_USB_GLOB_GINTSTS_WKUPINT_E_INACT | 0x0   | Not active                             
 *  ALT_USB_GLOB_GINTSTS_WKUPINT_E_ACT   | 0x1   | Resume Remote Wakeup Detected Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_WKUPINT
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_WKUPINT
 * 
 * Resume Remote Wakeup Detected Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_WKUPINT register field. */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_WKUPINT register field. */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_MSB        31
/* The width in bits of the ALT_USB_GLOB_GINTSTS_WKUPINT register field. */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_WKUPINT register field value. */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_WKUPINT register field value. */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_WKUPINT register field. */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_WKUPINT field value from a register. */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_GLOB_GINTSTS_WKUPINT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GINTSTS.
 */
struct ALT_USB_GLOB_GINTSTS_s
{
    const uint32_t  curmod       :  1;  /* ALT_USB_GLOB_GINTSTS_CURMOD */
    uint32_t        modemis      :  1;  /* ALT_USB_GLOB_GINTSTS_MODMIS */
    const uint32_t  otgint       :  1;  /* ALT_USB_GLOB_GINTSTS_OTGINT */
    uint32_t        sof          :  1;  /* ALT_USB_GLOB_GINTSTS_SOF */
    const uint32_t  rxflvl       :  1;  /* ALT_USB_GLOB_GINTSTS_RXFLVL */
    const uint32_t  nptxfemp     :  1;  /* ALT_USB_GLOB_GINTSTS_NPTXFEMP */
    const uint32_t  ginnakeff    :  1;  /* ALT_USB_GLOB_GINTSTS_GINNAKEFF */
    const uint32_t  goutnakeff   :  1;  /* ALT_USB_GLOB_GINTSTS_GOUTNAKEFF */
    uint32_t                     :  2;  /* *UNDEFINED* */
    uint32_t        erlysusp     :  1;  /* ALT_USB_GLOB_GINTSTS_ERLYSUSP */
    uint32_t        usbsusp      :  1;  /* ALT_USB_GLOB_GINTSTS_USBSUSP */
    uint32_t        usbrst       :  1;  /* ALT_USB_GLOB_GINTSTS_USBRST */
    uint32_t        enumdone     :  1;  /* ALT_USB_GLOB_GINTSTS_ENUMDONE */
    uint32_t        isooutdrop   :  1;  /* ALT_USB_GLOB_GINTSTS_ISOOUTDROP */
    uint32_t        eopf         :  1;  /* ALT_USB_GLOB_GINTSTS_EOPF */
    uint32_t                     :  1;  /* *UNDEFINED* */
    uint32_t        epmis        :  1;  /* ALT_USB_GLOB_GINTSTS_EPMIS */
    const uint32_t  iepint       :  1;  /* ALT_USB_GLOB_GINTSTS_IEPINT */
    const uint32_t  oepint       :  1;  /* ALT_USB_GLOB_GINTSTS_OEPINT */
    uint32_t        incompisoin  :  1;  /* ALT_USB_GLOB_GINTSTS_INCOMPISOIN */
    uint32_t        incomplp     :  1;  /* ALT_USB_GLOB_GINTSTS_INCOMPLP */
    uint32_t        fetsusp      :  1;  /* ALT_USB_GLOB_GINTSTS_FETSUSP */
    uint32_t        resetdet     :  1;  /* ALT_USB_GLOB_GINTSTS_RSTDET */
    const uint32_t  prtint       :  1;  /* ALT_USB_GLOB_GINTSTS_PRTINT */
    const uint32_t  hchint       :  1;  /* ALT_USB_GLOB_GINTSTS_HCHINT */
    const uint32_t  ptxfemp      :  1;  /* ALT_USB_GLOB_GINTSTS_PTXFEMP */
    uint32_t                     :  1;  /* *UNDEFINED* */
    uint32_t        conidstschng :  1;  /* ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG */
    uint32_t        disconnint   :  1;  /* ALT_USB_GLOB_GINTSTS_DISCONNINT */
    uint32_t        sessreqint   :  1;  /* ALT_USB_GLOB_GINTSTS_SESSREQINT */
    uint32_t        wkupint      :  1;  /* ALT_USB_GLOB_GINTSTS_WKUPINT */
};

/* The typedef declaration for register ALT_USB_GLOB_GINTSTS. */
typedef volatile struct ALT_USB_GLOB_GINTSTS_s  ALT_USB_GLOB_GINTSTS_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GINTSTS register. */
#define ALT_USB_GLOB_GINTSTS_RESET       0x14000020
/* The byte offset of the ALT_USB_GLOB_GINTSTS register from the beginning of the component. */
#define ALT_USB_GLOB_GINTSTS_OFST        0x14
/* The address of the ALT_USB_GLOB_GINTSTS register. */
#define ALT_USB_GLOB_GINTSTS_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GINTSTS_OFST))

/*
 * Register : gintmsk
 * 
 * Interrupt Mask Register
 * 
 * Register Layout
 * 
 *  Bits  | Access | Reset | Description                         
 * :------|:-------|:------|:-------------------------------------
 *  [0]   | ???    | 0x0   | *UNDEFINED*                         
 *  [1]   | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_MODMISMSK      
 *  [2]   | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_OTGINTMSK      
 *  [3]   | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_SOFMSK         
 *  [4]   | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_RXFLVLMSK      
 *  [5]   | ???    | 0x0   | *UNDEFINED*                         
 *  [6]   | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK   
 *  [7]   | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK  
 *  [9:8] | ???    | 0x0   | *UNDEFINED*                         
 *  [10]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK    
 *  [11]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_USBSUSPMSK     
 *  [12]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_USBRSTMSK      
 *  [13]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_ENUMDONEMSK    
 *  [14]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK  
 *  [15]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_EOPFMSK        
 *  [16]  | ???    | 0x0   | *UNDEFINED*                         
 *  [17]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_EPMISMSK       
 *  [18]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_IEPINTMSK      
 *  [19]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_OEPINTMSK      
 *  [20]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK 
 *  [21]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_INCOMPLPMSK    
 *  [22]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_FETSUSPMSK     
 *  [23]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_RSTDETMSK      
 *  [24]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_PRTINTMSK      
 *  [25]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_HCHINTMSK      
 *  [26]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_PTXFEMPMSK     
 *  [27]  | ???    | 0x0   | *UNDEFINED*                         
 *  [28]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK
 *  [29]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_DISCONNINTMSK  
 *  [30]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_SESSREQINTMSK  
 *  [31]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_WKUPINTMSK     
 * 
 */
/*
 * Field : modemismsk
 * 
 * Mode: Host and Device
 * 
 * Mode Mismatch Interrupt Mask (ModeMisMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                    
 * :---------------------------------------|:------|:--------------------------------
 *  ALT_USB_GLOB_GINTMSK_MODMISMSK_E_MSK   | 0x0   | Mode Mismatch Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_MODMISMSK_E_NOMSK | 0x1   | No Mask Mode Mismatch Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_MODMISMSK
 * 
 * Mode Mismatch Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_MODMISMSK
 * 
 * No Mask Mode Mismatch Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_MODMISMSK register field. */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_MODMISMSK register field. */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_MSB        1
/* The width in bits of the ALT_USB_GLOB_GINTMSK_MODMISMSK register field. */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_MODMISMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_MODMISMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_GLOB_GINTMSK_MODMISMSK register field. */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_MODMISMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_GLOB_GINTMSK_MODMISMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : otgintmsk
 * 
 * Mode: Host and Device
 * 
 * OTG Interrupt Mask (OTGIntMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description          
 * :---------------------------------------|:------|:----------------------
 *  ALT_USB_GLOB_GINTMSK_OTGINTMSK_E_MSK   | 0x0   | OTG Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_OTGINTMSK_E_NOMSK | 0x1   | No mask OTG Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_OTGINTMSK
 * 
 * OTG Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_OTGINTMSK
 * 
 * No mask OTG Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_OTGINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_OTGINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_MSB        2
/* The width in bits of the ALT_USB_GLOB_GINTMSK_OTGINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_OTGINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_OTGINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_GLOB_GINTMSK_OTGINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_OTGINTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_GLOB_GINTMSK_OTGINTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : sofmsk
 * 
 * Mode: Host and Device
 * 
 * Start of (micro)Frame Mask (SofMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description           
 * :------------------------------------|:------|:-----------------------
 *  ALT_USB_GLOB_GINTMSK_SOFMSK_E_MSK   | 0x0   | Start of Frame Mask   
 *  ALT_USB_GLOB_GINTMSK_SOFMSK_E_NOMSK | 0x1   | No Mask Start of Frame
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_SOFMSK
 * 
 * Start of Frame Mask
 */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_SOFMSK
 * 
 * No Mask Start of Frame
 */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_SOFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_SOFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_MSB        3
/* The width in bits of the ALT_USB_GLOB_GINTMSK_SOFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_SOFMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_SOFMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_GLOB_GINTMSK_SOFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_SOFMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_GLOB_GINTMSK_SOFMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : rxflvlmsk
 * 
 * Mode: Host and Device
 * 
 * Receive FIFO Non-Empty Mask (RxFLvlMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                   
 * :---------------------------------------|:------|:-------------------------------
 *  ALT_USB_GLOB_GINTMSK_RXFLVLMSK_E_MSK   | 0x0   | Receive FIFO Non-Empty Mask   
 *  ALT_USB_GLOB_GINTMSK_RXFLVLMSK_E_NOMSK | 0x1   | No maks Receive FIFO Non-Empty
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_RXFLVLMSK
 * 
 * Receive FIFO Non-Empty Mask
 */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_RXFLVLMSK
 * 
 * No maks Receive FIFO Non-Empty
 */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_RXFLVLMSK register field. */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_RXFLVLMSK register field. */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_MSB        4
/* The width in bits of the ALT_USB_GLOB_GINTMSK_RXFLVLMSK register field. */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_RXFLVLMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_RXFLVLMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_GLOB_GINTMSK_RXFLVLMSK register field. */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_RXFLVLMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_GLOB_GINTMSK_RXFLVLMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : ginnakeffmsk
 * 
 * Mode: Device only
 * 
 * Global Non-periodic IN NAK Effective Mask (GINNakEffMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                                 
 * :------------------------------------------|:------|:---------------------------------------------
 *  ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_E_MSK   | 0x0   | Global Non-periodic IN NAK Effective Mask   
 *  ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_E_NOMSK | 0x1   | No mask Global Non-periodic IN NAK Effective
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK
 * 
 * Global Non-periodic IN NAK Effective Mask
 */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_E_MSK     0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK
 * 
 * No mask Global Non-periodic IN NAK Effective
 */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_E_NOMSK   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_MSB        6
/* The width in bits of the ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : goutnakeffmsk
 * 
 * Mode: Device only
 * 
 * Global OUT NAK Effective Mask (GOUTNakEffMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                     
 * :--------------------------------------------|:------|:---------------------------------
 *  ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_E_MSK    | 0x0   | Global OUT NAK Effective Mask   
 *  ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_E_NOMAKS | 0x1   | No mask Global OUT NAK Effective
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK
 * 
 * Global OUT NAK Effective Mask
 */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK
 * 
 * No mask Global OUT NAK Effective
 */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_E_NOMAKS 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_MSB        7
/* The width in bits of the ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : erlysuspmsk
 * 
 * Mode: Device only
 * 
 * Early Suspend Mask (ErlySuspMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description               
 * :-----------------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_E_MSK   | 0x0   | Early Suspend Mask        
 *  ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_E_NOMSK | 0x1   | No mask Early Suspend Mask
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK
 * 
 * Early Suspend Mask
 */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK
 * 
 * No mask Early Suspend Mask
 */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_MSB        10
/* The width in bits of the ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_SET_MSK    0x00000400
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_CLR_MSK    0xfffffbff
/* The reset value of the ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : usbsuspmsk
 * 
 * Mode: Device only
 * 
 * USB Suspend Mask (USBSuspMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description         
 * :----------------------------------------|:------|:---------------------
 *  ALT_USB_GLOB_GINTMSK_USBSUSPMSK_E_MSK   | 0x0   | USB Suspend Mask    
 *  ALT_USB_GLOB_GINTMSK_USBSUSPMSK_E_NOMSK | 0x1   | No mask  USB Suspend
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_USBSUSPMSK
 * 
 * USB Suspend Mask
 */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_USBSUSPMSK
 * 
 * No mask  USB Suspend
 */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_USBSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_USBSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_MSB        11
/* The width in bits of the ALT_USB_GLOB_GINTMSK_USBSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_USBSUSPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_USBSUSPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_GLOB_GINTMSK_USBSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_USBSUSPMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_GLOB_GINTMSK_USBSUSPMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : usbrstmsk
 * 
 * Mode: Device only
 * 
 * USB Reset Mask (USBRstMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description      
 * :---------------------------------------|:------|:------------------
 *  ALT_USB_GLOB_GINTMSK_USBRSTMSK_E_MSK   | 0x0   | USB Reset Mask   
 *  ALT_USB_GLOB_GINTMSK_USBRSTMSK_E_NOMSK | 0x1   | No mask USB Reset
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_USBRSTMSK
 * 
 * USB Reset Mask
 */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_USBRSTMSK
 * 
 * No mask USB Reset
 */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_USBRSTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_USBRSTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_MSB        12
/* The width in bits of the ALT_USB_GLOB_GINTMSK_USBRSTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_USBRSTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_SET_MSK    0x00001000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_USBRSTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_CLR_MSK    0xffffefff
/* The reset value of the ALT_USB_GLOB_GINTMSK_USBRSTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_USBRSTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_USB_GLOB_GINTMSK_USBRSTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : enumdonemsk
 * 
 * Mode: Device only
 * 
 * Enumeration Done Mask (EnumDoneMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description             
 * :-----------------------------------------|:------|:-------------------------
 *  ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_E_MSK   | 0x0   | Enumeration Done Mask   
 *  ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_E_NOMSK | 0x1   | No mask Enumeration Done
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_ENUMDONEMSK
 * 
 * Enumeration Done Mask
 */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_ENUMDONEMSK
 * 
 * No mask Enumeration Done
 */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_ENUMDONEMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_ENUMDONEMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_MSB        13
/* The width in bits of the ALT_USB_GLOB_GINTMSK_ENUMDONEMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_ENUMDONEMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_ENUMDONEMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_GLOB_GINTMSK_ENUMDONEMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_ENUMDONEMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_GLOB_GINTMSK_ENUMDONEMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : isooutdropmsk
 * 
 * Mode: Device only
 * 
 * Isochronous OUT Packet Dropped Interrupt Mask
 * 
 * (ISOOutDropMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                                     
 * :-------------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_E_MSK   | 0x0   | Isochronous OUT Packet Dropped Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_E_NOMSK | 0x1   | No mask Isochronous OUT Packet Dropped Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK
 * 
 * Isochronous OUT Packet Dropped Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK
 * 
 * No mask Isochronous OUT Packet Dropped Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_MSB        14
/* The width in bits of the ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_SET_MSK    0x00004000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_CLR_MSK    0xffffbfff
/* The reset value of the ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : eopfmsk
 * 
 * Mode: Device only
 * 
 * End of Periodic Frame Interrupt Mask (EOPFMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                            
 * :-------------------------------------|:------|:----------------------------------------
 *  ALT_USB_GLOB_GINTMSK_EOPFMSK_E_MSK   | 0x0   | End of Periodic Frame Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_EOPFMSK_E_NOMSK | 0x1   | No mask End of Periodic Frame Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_EOPFMSK
 * 
 * End of Periodic Frame Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_EOPFMSK
 * 
 * No mask End of Periodic Frame Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_EOPFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_EOPFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_MSB        15
/* The width in bits of the ALT_USB_GLOB_GINTMSK_EOPFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_EOPFMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_SET_MSK    0x00008000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_EOPFMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_CLR_MSK    0xffff7fff
/* The reset value of the ALT_USB_GLOB_GINTMSK_EOPFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_EOPFMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_USB_GLOB_GINTMSK_EOPFMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : epmismsk
 * 
 * Mode: Device only
 * 
 * Endpoint Mismatch Interrupt Mask (EPMisMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                        
 * :--------------------------------------|:------|:------------------------------------
 *  ALT_USB_GLOB_GINTMSK_EPMISMSK_E_MSK   | 0x0   | Endpoint Mismatch Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_EPMISMSK_E_NOMSK | 0x1   | No mask Endpoint Mismatch Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_EPMISMSK
 * 
 * Endpoint Mismatch Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_E_MSK     0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_EPMISMSK
 * 
 * No mask Endpoint Mismatch Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_E_NOMSK   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_EPMISMSK register field. */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_EPMISMSK register field. */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_MSB        17
/* The width in bits of the ALT_USB_GLOB_GINTMSK_EPMISMSK register field. */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_EPMISMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_SET_MSK    0x00020000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_EPMISMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_CLR_MSK    0xfffdffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_EPMISMSK register field. */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_EPMISMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_USB_GLOB_GINTMSK_EPMISMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : iepintmsk
 * 
 * Mode: Device only
 * 
 * IN Endpoints Interrupt Mask (IEPIntMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                   
 * :----------------------------------------|:------|:-------------------------------
 *  ALT_USB_GLOB_GINTMSK_IEPINTMSK_E_MSK    | 0x0   | IN Endpoints Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_IEPINTMSK_E_NOMAKS | 0x1   | No mask IN Endpoints Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_IEPINTMSK
 * 
 * IN Endpoints Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_IEPINTMSK
 * 
 * No mask IN Endpoints Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_E_NOMAKS 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_IEPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_IEPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_MSB        18
/* The width in bits of the ALT_USB_GLOB_GINTMSK_IEPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_IEPINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_SET_MSK    0x00040000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_IEPINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_CLR_MSK    0xfffbffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_IEPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_IEPINTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_USB_GLOB_GINTMSK_IEPINTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : oepintmsk
 * 
 * Mode: Device only
 * 
 * OUT Endpoints Interrupt Mask (OEPIntMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                    
 * :---------------------------------------|:------|:--------------------------------
 *  ALT_USB_GLOB_GINTMSK_OEPINTMSK_E_MSK   | 0x0   | OUT Endpoints Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_OEPINTMSK_E_NOMSK | 0x1   | No mask OUT Endpoints Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_OEPINTMSK
 * 
 * OUT Endpoints Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_OEPINTMSK
 * 
 * No mask OUT Endpoints Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_OEPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_OEPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_MSB        19
/* The width in bits of the ALT_USB_GLOB_GINTMSK_OEPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_OEPINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_SET_MSK    0x00080000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_OEPINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_OEPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_OEPINTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_USB_GLOB_GINTMSK_OEPINTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : incompisoinmsk
 * 
 * Mode: Device only
 * 
 * Incomplete Isochronous IN Transfer Mask (incompISOINMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_E_MSK   | 0x0   | Incomplete Isochronous IN Transfer Mask   
 *  ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_E_NOMSK | 0x1   | No mask Incomplete Isochronous IN Transfer
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK
 * 
 * Incomplete Isochronous IN Transfer Mask
 */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK
 * 
 * No mask Incomplete Isochronous IN Transfer
 */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK register field. */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK register field. */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_MSB        20
/* The width in bits of the ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK register field. */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_SET_MSK    0x00100000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_CLR_MSK    0xffefffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK register field. */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : incomplpmsk
 * 
 * Mode: Host only
 * 
 * Incomplete Periodic Transfer Mask (incomplPMsk)
 * 
 * Mode: Device only
 * 
 * Incomplete Isochronous OUT Transfer Interrupt Mask (incompISOOUTMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                         
 * :-----------------------------------------|:------|:-------------------------------------
 *  ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_E_MSK   | 0x0   | Incomplete Periodic Transfer Mask   
 *  ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_E_NOMSK | 0x1   | No mask Incomplete Periodic Transfer
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_INCOMPLPMSK
 * 
 * Incomplete Periodic Transfer Mask
 */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_INCOMPLPMSK
 * 
 * No mask Incomplete Periodic Transfer
 */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_INCOMPLPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_INCOMPLPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_MSB        21
/* The width in bits of the ALT_USB_GLOB_GINTMSK_INCOMPLPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_INCOMPLPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_SET_MSK    0x00200000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_INCOMPLPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_CLR_MSK    0xffdfffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_INCOMPLPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_INCOMPLPMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_USB_GLOB_GINTMSK_INCOMPLPMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : fetsuspmsk
 * 
 * Mode: Device only
 * 
 * Data Fetch Suspended Mask (FetSuspMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                 
 * :----------------------------------------|:------|:-----------------------------
 *  ALT_USB_GLOB_GINTMSK_FETSUSPMSK_E_MSK   | 0x0   | Data Fetch Suspended Mask   
 *  ALT_USB_GLOB_GINTMSK_FETSUSPMSK_E_NOMSK | 0x1   | No mask Data Fetch Suspended
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_FETSUSPMSK
 * 
 * Data Fetch Suspended Mask
 */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_FETSUSPMSK
 * 
 * No mask Data Fetch Suspended
 */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_FETSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_FETSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_MSB        22
/* The width in bits of the ALT_USB_GLOB_GINTMSK_FETSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_FETSUSPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_SET_MSK    0x00400000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_FETSUSPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_CLR_MSK    0xffbfffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_FETSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_FETSUSPMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_USB_GLOB_GINTMSK_FETSUSPMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : resetdetmsk
 * 
 * Mode: Device only
 * 
 * Reset detected Interrupt Mask (ResetDetMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                     
 * :---------------------------------------|:------|:---------------------------------
 *  ALT_USB_GLOB_GINTMSK_RSTDETMSK_E_MSK   | 0x0   | Reset detected Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_RSTDETMSK_E_NOMSK | 0x1   | No mask Reset detected Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_RSTDETMSK
 * 
 * Reset detected Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_RSTDETMSK
 * 
 * No mask Reset detected Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_RSTDETMSK register field. */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_RSTDETMSK register field. */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_MSB        23
/* The width in bits of the ALT_USB_GLOB_GINTMSK_RSTDETMSK register field. */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_RSTDETMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_SET_MSK    0x00800000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_RSTDETMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_CLR_MSK    0xff7fffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_RSTDETMSK register field. */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_RSTDETMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_USB_GLOB_GINTMSK_RSTDETMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : prtintmsk
 * 
 * Mode: Host only
 * 
 * Host Port Interrupt Mask (PrtIntMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                
 * :---------------------------------------|:------|:----------------------------
 *  ALT_USB_GLOB_GINTMSK_PRTINTMSK_E_MSK   | 0x0   | Host Port Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_PRTINTMSK_E_NOMSK | 0x1   | No mask Host Port Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_PRTINTMSK
 * 
 * Host Port Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_PRTINTMSK
 * 
 * No mask Host Port Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_PRTINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_PRTINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_MSB        24
/* The width in bits of the ALT_USB_GLOB_GINTMSK_PRTINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_PRTINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_SET_MSK    0x01000000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_PRTINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_CLR_MSK    0xfeffffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_PRTINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_PRTINTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_USB_GLOB_GINTMSK_PRTINTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : hchintmsk
 * 
 * Mode: Host only
 * 
 * Host Channels Interrupt Mask (HChIntMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                    
 * :---------------------------------------|:------|:--------------------------------
 *  ALT_USB_GLOB_GINTMSK_HCHINTMSK_E_MSK   | 0x0   | Host Channels Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_HCHINTMSK_E_NOMSK | 0x1   | No mask Host Channels Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_HCHINTMSK
 * 
 * Host Channels Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_HCHINTMSK
 * 
 * No mask Host Channels Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_HCHINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_HCHINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_MSB        25
/* The width in bits of the ALT_USB_GLOB_GINTMSK_HCHINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_HCHINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_SET_MSK    0x02000000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_HCHINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_CLR_MSK    0xfdffffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_HCHINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_HCHINTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_USB_GLOB_GINTMSK_HCHINTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : ptxfempmsk
 * 
 * Mode: Host only
 * 
 * Periodic TxFIFO Empty Mask (PTxFEmpMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                  
 * :----------------------------------------|:------|:------------------------------
 *  ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_E_MSK   | 0x0   | Periodic TxFIFO Empty Mask   
 *  ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_E_NOMSK | 0x1   | No mask Periodic TxFIFO Empty
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_PTXFEMPMSK
 * 
 * Periodic TxFIFO Empty Mask
 */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_PTXFEMPMSK
 * 
 * No mask Periodic TxFIFO Empty
 */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_PTXFEMPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_PTXFEMPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_MSB        26
/* The width in bits of the ALT_USB_GLOB_GINTMSK_PTXFEMPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_PTXFEMPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_SET_MSK    0x04000000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_PTXFEMPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_CLR_MSK    0xfbffffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_PTXFEMPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_PTXFEMPMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_USB_GLOB_GINTMSK_PTXFEMPMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : conidstschngmsk
 * 
 * Mode: Host and Device
 * 
 * Connector ID Status Change Mask (ConIDStsChngMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                       
 * :---------------------------------------------|:------|:-----------------------------------
 *  ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_E_MSK   | 0x0   | Connector ID Status Change Mask   
 *  ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_E_NOMSK | 0x1   | No mask Connector ID Status Change
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK
 * 
 * Connector ID Status Change Mask
 */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK
 * 
 * No mask Connector ID Status Change
 */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK register field. */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK register field. */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_MSB        28
/* The width in bits of the ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK register field. */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_SET_MSK    0x10000000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_CLR_MSK    0xefffffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK register field. */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : disconnintmsk
 * 
 * Mode: Host and Device
 * 
 * Disconnect Detected Interrupt Mask (DisconnIntMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                          
 * :-------------------------------------------|:------|:--------------------------------------
 *  ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_E_MSK   | 0x0   | Disconnect Detected Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_E_NOMSK | 0x1   | No mask Disconnect Detected Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_DISCONNINTMSK
 * 
 * Disconnect Detected Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_DISCONNINTMSK
 * 
 * No mask Disconnect Detected Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_DISCONNINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_DISCONNINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_MSB        29
/* The width in bits of the ALT_USB_GLOB_GINTMSK_DISCONNINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_DISCONNINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_SET_MSK    0x20000000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_DISCONNINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_CLR_MSK    0xdfffffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_DISCONNINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_DISCONNINTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_USB_GLOB_GINTMSK_DISCONNINTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : sessreqintmsk
 * 
 * Mode: Host and Device
 * 
 * Session Request/New Session Detected Interrupt Mask
 * 
 * (SessReqIntMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                                   
 * :-------------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_E_MSK   | 0x0   | Session Request New Session Detected Interrupt
 * :                                           |       | Mask                                          
 *  ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_E_NOMSK | 0x1   | No mask Session RequestNew Session Detected   
 * :                                           |       | Interrupt                                     
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_SESSREQINTMSK
 * 
 * Session Request New Session Detected Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_SESSREQINTMSK
 * 
 * No mask Session RequestNew Session Detected Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_SESSREQINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_SESSREQINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_MSB        30
/* The width in bits of the ALT_USB_GLOB_GINTMSK_SESSREQINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_SESSREQINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_SESSREQINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_SESSREQINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_SESSREQINTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_GLOB_GINTMSK_SESSREQINTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : wkupintmsk
 * 
 * Mode: Host and Device
 * 
 * Resume/Remote Wakeup Detected Interrupt Mask
 * 
 * The WakeUp bit is used for LPM state wake up in a way similar to that of wake up
 * in suspend state.
 * 
 * (WkUpIntMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                   
 * :----------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_GLOB_GINTMSK_WKUPINTMSK_E_MSK   | 0x0   | Resume Remote Wakeup Detected Interrupt Mask  
 *  ALT_USB_GLOB_GINTMSK_WKUPINTMSK_E_NOMSK | 0x1   | No maskResume Remote Wakeup Detected Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_WKUPINTMSK
 * 
 * Resume Remote Wakeup Detected Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_WKUPINTMSK
 * 
 * No maskResume Remote Wakeup Detected Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_WKUPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_WKUPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_MSB        31
/* The width in bits of the ALT_USB_GLOB_GINTMSK_WKUPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_WKUPINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_WKUPINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_WKUPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_WKUPINTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_GLOB_GINTMSK_WKUPINTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GINTMSK.
 */
struct ALT_USB_GLOB_GINTMSK_s
{
    uint32_t                  :  1;  /* *UNDEFINED* */
    uint32_t  modemismsk      :  1;  /* ALT_USB_GLOB_GINTMSK_MODMISMSK */
    uint32_t  otgintmsk       :  1;  /* ALT_USB_GLOB_GINTMSK_OTGINTMSK */
    uint32_t  sofmsk          :  1;  /* ALT_USB_GLOB_GINTMSK_SOFMSK */
    uint32_t  rxflvlmsk       :  1;  /* ALT_USB_GLOB_GINTMSK_RXFLVLMSK */
    uint32_t                  :  1;  /* *UNDEFINED* */
    uint32_t  ginnakeffmsk    :  1;  /* ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK */
    uint32_t  goutnakeffmsk   :  1;  /* ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK */
    uint32_t                  :  2;  /* *UNDEFINED* */
    uint32_t  erlysuspmsk     :  1;  /* ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK */
    uint32_t  usbsuspmsk      :  1;  /* ALT_USB_GLOB_GINTMSK_USBSUSPMSK */
    uint32_t  usbrstmsk       :  1;  /* ALT_USB_GLOB_GINTMSK_USBRSTMSK */
    uint32_t  enumdonemsk     :  1;  /* ALT_USB_GLOB_GINTMSK_ENUMDONEMSK */
    uint32_t  isooutdropmsk   :  1;  /* ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK */
    uint32_t  eopfmsk         :  1;  /* ALT_USB_GLOB_GINTMSK_EOPFMSK */
    uint32_t                  :  1;  /* *UNDEFINED* */
    uint32_t  epmismsk        :  1;  /* ALT_USB_GLOB_GINTMSK_EPMISMSK */
    uint32_t  iepintmsk       :  1;  /* ALT_USB_GLOB_GINTMSK_IEPINTMSK */
    uint32_t  oepintmsk       :  1;  /* ALT_USB_GLOB_GINTMSK_OEPINTMSK */
    uint32_t  incompisoinmsk  :  1;  /* ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK */
    uint32_t  incomplpmsk     :  1;  /* ALT_USB_GLOB_GINTMSK_INCOMPLPMSK */
    uint32_t  fetsuspmsk      :  1;  /* ALT_USB_GLOB_GINTMSK_FETSUSPMSK */
    uint32_t  resetdetmsk     :  1;  /* ALT_USB_GLOB_GINTMSK_RSTDETMSK */
    uint32_t  prtintmsk       :  1;  /* ALT_USB_GLOB_GINTMSK_PRTINTMSK */
    uint32_t  hchintmsk       :  1;  /* ALT_USB_GLOB_GINTMSK_HCHINTMSK */
    uint32_t  ptxfempmsk      :  1;  /* ALT_USB_GLOB_GINTMSK_PTXFEMPMSK */
    uint32_t                  :  1;  /* *UNDEFINED* */
    uint32_t  conidstschngmsk :  1;  /* ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK */
    uint32_t  disconnintmsk   :  1;  /* ALT_USB_GLOB_GINTMSK_DISCONNINTMSK */
    uint32_t  sessreqintmsk   :  1;  /* ALT_USB_GLOB_GINTMSK_SESSREQINTMSK */
    uint32_t  wkupintmsk      :  1;  /* ALT_USB_GLOB_GINTMSK_WKUPINTMSK */
};

/* The typedef declaration for register ALT_USB_GLOB_GINTMSK. */
typedef volatile struct ALT_USB_GLOB_GINTMSK_s  ALT_USB_GLOB_GINTMSK_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GINTMSK register. */
#define ALT_USB_GLOB_GINTMSK_RESET       0x00000000
/* The byte offset of the ALT_USB_GLOB_GINTMSK register from the beginning of the component. */
#define ALT_USB_GLOB_GINTMSK_OFST        0x18
/* The address of the ALT_USB_GLOB_GINTMSK register. */
#define ALT_USB_GLOB_GINTMSK_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GINTMSK_OFST))

/*
 * Register : grxstsr
 * 
 * Receive Status Debug Read Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                
 * :--------|:-------|:------|:----------------------------
 *  [3:0]   | R      | 0x0   | ALT_USB_GLOB_GRXSTSR_CHNUM 
 *  [14:4]  | R      | 0x0   | ALT_USB_GLOB_GRXSTSR_BCNT  
 *  [16:15] | R      | 0x0   | ALT_USB_GLOB_GRXSTSR_DPID  
 *  [20:17] | R      | 0x0   | ALT_USB_GLOB_GRXSTSR_PKTSTS
 *  [24:21] | R      | 0x0   | ALT_USB_GLOB_GRXSTSR_FN    
 *  [31:25] | ???    | 0x0   | *UNDEFINED*                
 * 
 */
/*
 * Field : chnum
 * 
 * Mode: Host only
 * 
 * Channel Number (ChNum)
 * 
 * Indicates the channel number to which the current received
 * 
 * packet belongs.
 * 
 * Mode: Device only
 * 
 * Endpoint Number (EPNum)
 * 
 * Indicates the endpoint number to which the current received
 * 
 * packet belongs.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSR_CHNUM register field. */
#define ALT_USB_GLOB_GRXSTSR_CHNUM_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSR_CHNUM register field. */
#define ALT_USB_GLOB_GRXSTSR_CHNUM_MSB        3
/* The width in bits of the ALT_USB_GLOB_GRXSTSR_CHNUM register field. */
#define ALT_USB_GLOB_GRXSTSR_CHNUM_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GRXSTSR_CHNUM register field value. */
#define ALT_USB_GLOB_GRXSTSR_CHNUM_SET_MSK    0x0000000f
/* The mask used to clear the ALT_USB_GLOB_GRXSTSR_CHNUM register field value. */
#define ALT_USB_GLOB_GRXSTSR_CHNUM_CLR_MSK    0xfffffff0
/* The reset value of the ALT_USB_GLOB_GRXSTSR_CHNUM register field. */
#define ALT_USB_GLOB_GRXSTSR_CHNUM_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSR_CHNUM field value from a register. */
#define ALT_USB_GLOB_GRXSTSR_CHNUM_GET(value) (((value) & 0x0000000f) >> 0)
/* Produces a ALT_USB_GLOB_GRXSTSR_CHNUM register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSR_CHNUM_SET(value) (((value) << 0) & 0x0000000f)

/*
 * Field : bcnt
 * 
 * Mode: Host only
 * 
 * Byte Count (BCnt)
 * 
 * Indicates the byte count of the received IN data packet.
 * 
 * Mode: Device only
 * 
 * Byte Count (BCnt)
 * 
 * Indicates the byte count of the received data packet.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSR_BCNT register field. */
#define ALT_USB_GLOB_GRXSTSR_BCNT_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSR_BCNT register field. */
#define ALT_USB_GLOB_GRXSTSR_BCNT_MSB        14
/* The width in bits of the ALT_USB_GLOB_GRXSTSR_BCNT register field. */
#define ALT_USB_GLOB_GRXSTSR_BCNT_WIDTH      11
/* The mask used to set the ALT_USB_GLOB_GRXSTSR_BCNT register field value. */
#define ALT_USB_GLOB_GRXSTSR_BCNT_SET_MSK    0x00007ff0
/* The mask used to clear the ALT_USB_GLOB_GRXSTSR_BCNT register field value. */
#define ALT_USB_GLOB_GRXSTSR_BCNT_CLR_MSK    0xffff800f
/* The reset value of the ALT_USB_GLOB_GRXSTSR_BCNT register field. */
#define ALT_USB_GLOB_GRXSTSR_BCNT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSR_BCNT field value from a register. */
#define ALT_USB_GLOB_GRXSTSR_BCNT_GET(value) (((value) & 0x00007ff0) >> 4)
/* Produces a ALT_USB_GLOB_GRXSTSR_BCNT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSR_BCNT_SET(value) (((value) << 4) & 0x00007ff0)

/*
 * Field : dpid
 * 
 * Mode: Host only
 * 
 * Data PID (DPID)
 * 
 * Indicates the Data PID of the received packet
 * 
 * 2'b00: DATA0
 * 
 * 2'b10: DATA1
 * 
 * 2'b01: DATA2
 * 
 * 2'b11: MDATA
 * 
 * Mode: Device only
 * 
 * Data PID (DPID)
 * 
 * Indicates the Data PID of the received OUT data packet
 * 
 * 2'b00: DATA0
 * 
 * 2'b10: DATA1
 * 
 * 2'b01: DATA2
 * 
 * 2'b11: MDATA
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description
 * :----------------------------------|:------|:------------
 *  ALT_USB_GLOB_GRXSTSR_DPID_E_DATA0 | 0x0   | DATA0      
 *  ALT_USB_GLOB_GRXSTSR_DPID_E_DATA2 | 0x1   | DATA2      
 *  ALT_USB_GLOB_GRXSTSR_DPID_E_DATA1 | 0x2   | DATA1      
 *  ALT_USB_GLOB_GRXSTSR_DPID_E_MDATA | 0x3   | MDATA      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSR_DPID
 * 
 * DATA0
 */
#define ALT_USB_GLOB_GRXSTSR_DPID_E_DATA0   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSR_DPID
 * 
 * DATA2
 */
#define ALT_USB_GLOB_GRXSTSR_DPID_E_DATA2   0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSR_DPID
 * 
 * DATA1
 */
#define ALT_USB_GLOB_GRXSTSR_DPID_E_DATA1   0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSR_DPID
 * 
 * MDATA
 */
#define ALT_USB_GLOB_GRXSTSR_DPID_E_MDATA   0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSR_DPID register field. */
#define ALT_USB_GLOB_GRXSTSR_DPID_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSR_DPID register field. */
#define ALT_USB_GLOB_GRXSTSR_DPID_MSB        16
/* The width in bits of the ALT_USB_GLOB_GRXSTSR_DPID register field. */
#define ALT_USB_GLOB_GRXSTSR_DPID_WIDTH      2
/* The mask used to set the ALT_USB_GLOB_GRXSTSR_DPID register field value. */
#define ALT_USB_GLOB_GRXSTSR_DPID_SET_MSK    0x00018000
/* The mask used to clear the ALT_USB_GLOB_GRXSTSR_DPID register field value. */
#define ALT_USB_GLOB_GRXSTSR_DPID_CLR_MSK    0xfffe7fff
/* The reset value of the ALT_USB_GLOB_GRXSTSR_DPID register field. */
#define ALT_USB_GLOB_GRXSTSR_DPID_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSR_DPID field value from a register. */
#define ALT_USB_GLOB_GRXSTSR_DPID_GET(value) (((value) & 0x00018000) >> 15)
/* Produces a ALT_USB_GLOB_GRXSTSR_DPID register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSR_DPID_SET(value) (((value) << 15) & 0x00018000)

/*
 * Field : pktsts
 * 
 * Mode: Host only
 * 
 * Packet Status (PktSts)
 * 
 * Indicates the status of the received packet
 * 
 * 4'b0010: IN data packet received
 * 
 * 4'b0011: IN transfer completed (triggers an interrupt)
 * 
 * 4'b0101: Data toggle error (triggers an interrupt)
 * 
 * 4'b0111: Channel halted (triggers an interrupt)
 * 
 * Others: Reserved
 * 
 * Mode: Device only
 * 
 * Packet Status (PktSts)
 * 
 * Indicates the status of the received packet
 * 
 * 4'b0001: Global OUT NAK (triggers an interrupt)
 * 
 * 4'b0010: OUT data packet received
 * 
 * 4'b0011: OUT transfer completed (triggers an interrupt)
 * 
 * 4'b0100: SETUP transaction completed (triggers an
 * 
 * interrupt)
 * 
 * 4'b0110: SETUP data packet received
 * 
 * Others: Reserved
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                 
 * :--------------------------------------|:------|:---------------------------------------------
 *  ALT_USB_GLOB_GRXSTSR_PKTSTS_E_INDPRX  | 0x2   | IN data packet received                     
 *  ALT_USB_GLOB_GRXSTSR_PKTSTS_E_INTRCOM | 0x3   | IN transfer completed (triggers an interrupt
 *  ALT_USB_GLOB_GRXSTSR_PKTSTS_E_DTTOG   | 0x5   | Data toggle error (triggers an interrupt)   
 *  ALT_USB_GLOB_GRXSTSR_PKTSTS_E_CHHALT  | 0x7   | Channel halted (triggers an interrupt)      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSR_PKTSTS
 * 
 * IN data packet received
 */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_E_INDPRX    0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSR_PKTSTS
 * 
 * IN transfer completed (triggers an interrupt
 */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_E_INTRCOM   0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSR_PKTSTS
 * 
 * Data toggle error (triggers an interrupt)
 */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_E_DTTOG     0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSR_PKTSTS
 * 
 * Channel halted (triggers an interrupt)
 */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_E_CHHALT    0x7

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSR_PKTSTS register field. */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSR_PKTSTS register field. */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_MSB        20
/* The width in bits of the ALT_USB_GLOB_GRXSTSR_PKTSTS register field. */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GRXSTSR_PKTSTS register field value. */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_SET_MSK    0x001e0000
/* The mask used to clear the ALT_USB_GLOB_GRXSTSR_PKTSTS register field value. */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_CLR_MSK    0xffe1ffff
/* The reset value of the ALT_USB_GLOB_GRXSTSR_PKTSTS register field. */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSR_PKTSTS field value from a register. */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_GET(value) (((value) & 0x001e0000) >> 17)
/* Produces a ALT_USB_GLOB_GRXSTSR_PKTSTS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_SET(value) (((value) << 17) & 0x001e0000)

/*
 * Field : fn
 * 
 * Mode: Device only
 * 
 * Frame Number (FN)
 * 
 * This is the least significant 4 bits of the (micro)Frame number in
 * 
 * which the packet is received on the USB. This field is supported
 * 
 * only when isochronous OUT endpoints are supported.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSR_FN register field. */
#define ALT_USB_GLOB_GRXSTSR_FN_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSR_FN register field. */
#define ALT_USB_GLOB_GRXSTSR_FN_MSB        24
/* The width in bits of the ALT_USB_GLOB_GRXSTSR_FN register field. */
#define ALT_USB_GLOB_GRXSTSR_FN_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GRXSTSR_FN register field value. */
#define ALT_USB_GLOB_GRXSTSR_FN_SET_MSK    0x01e00000
/* The mask used to clear the ALT_USB_GLOB_GRXSTSR_FN register field value. */
#define ALT_USB_GLOB_GRXSTSR_FN_CLR_MSK    0xfe1fffff
/* The reset value of the ALT_USB_GLOB_GRXSTSR_FN register field. */
#define ALT_USB_GLOB_GRXSTSR_FN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSR_FN field value from a register. */
#define ALT_USB_GLOB_GRXSTSR_FN_GET(value) (((value) & 0x01e00000) >> 21)
/* Produces a ALT_USB_GLOB_GRXSTSR_FN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSR_FN_SET(value) (((value) << 21) & 0x01e00000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GRXSTSR.
 */
struct ALT_USB_GLOB_GRXSTSR_s
{
    const uint32_t  chnum  :  4;  /* ALT_USB_GLOB_GRXSTSR_CHNUM */
    const uint32_t  bcnt   : 11;  /* ALT_USB_GLOB_GRXSTSR_BCNT */
    const uint32_t  dpid   :  2;  /* ALT_USB_GLOB_GRXSTSR_DPID */
    const uint32_t  pktsts :  4;  /* ALT_USB_GLOB_GRXSTSR_PKTSTS */
    const uint32_t  fn     :  4;  /* ALT_USB_GLOB_GRXSTSR_FN */
    uint32_t               :  7;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GRXSTSR. */
typedef volatile struct ALT_USB_GLOB_GRXSTSR_s  ALT_USB_GLOB_GRXSTSR_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GRXSTSR register. */
#define ALT_USB_GLOB_GRXSTSR_RESET       0x00000000
/* The byte offset of the ALT_USB_GLOB_GRXSTSR register from the beginning of the component. */
#define ALT_USB_GLOB_GRXSTSR_OFST        0x1c
/* The address of the ALT_USB_GLOB_GRXSTSR register. */
#define ALT_USB_GLOB_GRXSTSR_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GRXSTSR_OFST))

/*
 * Register : grxstsp
 * 
 * Receive Status Read /Pop Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                
 * :--------|:-------|:------|:----------------------------
 *  [3:0]   | R      | 0x0   | ALT_USB_GLOB_GRXSTSP_CHNUM 
 *  [14:4]  | R      | 0x0   | ALT_USB_GLOB_GRXSTSP_BCNT  
 *  [16:15] | R      | 0x0   | ALT_USB_GLOB_GRXSTSP_DPID  
 *  [20:17] | R      | 0x0   | ALT_USB_GLOB_GRXSTSP_PKTSTS
 *  [24:21] | R      | 0x0   | ALT_USB_GLOB_GRXSTSP_FN    
 *  [31:25] | ???    | 0x0   | *UNDEFINED*                
 * 
 */
/*
 * Field : chnum
 * 
 * Mode: Host only
 * 
 * Channel Number (ChNum)
 * 
 * Indicates the channel number to which the current received
 * 
 * packet belongs.
 * 
 * Mode: Device only
 * 
 * Endpoint Number (EPNum)
 * 
 * Indicates the endpoint number to which the current received
 * 
 * packet belongs.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSP_CHNUM register field. */
#define ALT_USB_GLOB_GRXSTSP_CHNUM_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSP_CHNUM register field. */
#define ALT_USB_GLOB_GRXSTSP_CHNUM_MSB        3
/* The width in bits of the ALT_USB_GLOB_GRXSTSP_CHNUM register field. */
#define ALT_USB_GLOB_GRXSTSP_CHNUM_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GRXSTSP_CHNUM register field value. */
#define ALT_USB_GLOB_GRXSTSP_CHNUM_SET_MSK    0x0000000f
/* The mask used to clear the ALT_USB_GLOB_GRXSTSP_CHNUM register field value. */
#define ALT_USB_GLOB_GRXSTSP_CHNUM_CLR_MSK    0xfffffff0
/* The reset value of the ALT_USB_GLOB_GRXSTSP_CHNUM register field. */
#define ALT_USB_GLOB_GRXSTSP_CHNUM_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSP_CHNUM field value from a register. */
#define ALT_USB_GLOB_GRXSTSP_CHNUM_GET(value) (((value) & 0x0000000f) >> 0)
/* Produces a ALT_USB_GLOB_GRXSTSP_CHNUM register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSP_CHNUM_SET(value) (((value) << 0) & 0x0000000f)

/*
 * Field : bcnt
 * 
 * Mode: Host only
 * 
 * Byte Count (BCnt)
 * 
 * Indicates the byte count of the received IN data packet.
 * 
 * Mode: Device only
 * 
 * Byte Count (BCnt)
 * 
 * Indicates the byte count of the received data packet.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSP_BCNT register field. */
#define ALT_USB_GLOB_GRXSTSP_BCNT_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSP_BCNT register field. */
#define ALT_USB_GLOB_GRXSTSP_BCNT_MSB        14
/* The width in bits of the ALT_USB_GLOB_GRXSTSP_BCNT register field. */
#define ALT_USB_GLOB_GRXSTSP_BCNT_WIDTH      11
/* The mask used to set the ALT_USB_GLOB_GRXSTSP_BCNT register field value. */
#define ALT_USB_GLOB_GRXSTSP_BCNT_SET_MSK    0x00007ff0
/* The mask used to clear the ALT_USB_GLOB_GRXSTSP_BCNT register field value. */
#define ALT_USB_GLOB_GRXSTSP_BCNT_CLR_MSK    0xffff800f
/* The reset value of the ALT_USB_GLOB_GRXSTSP_BCNT register field. */
#define ALT_USB_GLOB_GRXSTSP_BCNT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSP_BCNT field value from a register. */
#define ALT_USB_GLOB_GRXSTSP_BCNT_GET(value) (((value) & 0x00007ff0) >> 4)
/* Produces a ALT_USB_GLOB_GRXSTSP_BCNT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSP_BCNT_SET(value) (((value) << 4) & 0x00007ff0)

/*
 * Field : dpid
 * 
 * Mode: Host only
 * 
 * Data PID (DPID)
 * 
 * Indicates the Data PID of the received packet
 * 
 * 2'b00: DATA0
 * 
 * 2'b10: DATA1
 * 
 * 2'b01: DATA2
 * 
 * 2'b11: MDATA
 * 
 * Mode: Device only
 * 
 * Data PID (DPID)
 * 
 * Indicates the Data PID of the received OUT data packet
 * 
 * 2'b00: DATA0
 * 
 * 2'b10: DATA1
 * 
 * 2'b01: DATA2
 * 
 * 2'b11: MDATA
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description
 * :----------------------------------|:------|:------------
 *  ALT_USB_GLOB_GRXSTSP_DPID_E_DATA0 | 0x0   | DATA0      
 *  ALT_USB_GLOB_GRXSTSP_DPID_E_DATA2 | 0x1   | DATA2      
 *  ALT_USB_GLOB_GRXSTSP_DPID_E_DATA1 | 0x2   | DATA1      
 *  ALT_USB_GLOB_GRXSTSP_DPID_E_MDATA | 0x3   | MDATA      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSP_DPID
 * 
 * DATA0
 */
#define ALT_USB_GLOB_GRXSTSP_DPID_E_DATA0   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSP_DPID
 * 
 * DATA2
 */
#define ALT_USB_GLOB_GRXSTSP_DPID_E_DATA2   0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSP_DPID
 * 
 * DATA1
 */
#define ALT_USB_GLOB_GRXSTSP_DPID_E_DATA1   0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSP_DPID
 * 
 * MDATA
 */
#define ALT_USB_GLOB_GRXSTSP_DPID_E_MDATA   0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSP_DPID register field. */
#define ALT_USB_GLOB_GRXSTSP_DPID_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSP_DPID register field. */
#define ALT_USB_GLOB_GRXSTSP_DPID_MSB        16
/* The width in bits of the ALT_USB_GLOB_GRXSTSP_DPID register field. */
#define ALT_USB_GLOB_GRXSTSP_DPID_WIDTH      2
/* The mask used to set the ALT_USB_GLOB_GRXSTSP_DPID register field value. */
#define ALT_USB_GLOB_GRXSTSP_DPID_SET_MSK    0x00018000
/* The mask used to clear the ALT_USB_GLOB_GRXSTSP_DPID register field value. */
#define ALT_USB_GLOB_GRXSTSP_DPID_CLR_MSK    0xfffe7fff
/* The reset value of the ALT_USB_GLOB_GRXSTSP_DPID register field. */
#define ALT_USB_GLOB_GRXSTSP_DPID_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSP_DPID field value from a register. */
#define ALT_USB_GLOB_GRXSTSP_DPID_GET(value) (((value) & 0x00018000) >> 15)
/* Produces a ALT_USB_GLOB_GRXSTSP_DPID register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSP_DPID_SET(value) (((value) << 15) & 0x00018000)

/*
 * Field : pktsts
 * 
 * Mode: Host only
 * 
 * Packet Status (PktSts)
 * 
 * Indicates the status of the received packet
 * 
 * 4'b0010: IN data packet received
 * 
 * 4'b0011: IN transfer completed (triggers an interrupt)
 * 
 * 4'b0101: Data toggle error (triggers an interrupt)
 * 
 * 4'b0111: Channel halted (triggers an interrupt)
 * 
 * Others: Reserved
 * 
 * Mode: Device only
 * 
 * Packet Status (PktSts)
 * 
 * Indicates the status of the received packet
 * 
 * 4'b0001: Global OUT NAK (triggers an interrupt)
 * 
 * 4'b0010: OUT data packet received
 * 
 * 4'b0011: OUT transfer completed (triggers an interrupt)
 * 
 * 4'b0100: SETUP transaction completed (triggers an
 * 
 * interrupt)
 * 
 * 4'b0110: SETUP data packet received
 * 
 * Others: Reserved
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description
 * :------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GRXSTSP_PKTSTS_E_DATA0 | 0x0   | DATA0      
 *  ALT_USB_GLOB_GRXSTSP_PKTSTS_E_DATA2 | 0x1   | DATA2      
 *  ALT_USB_GLOB_GRXSTSP_PKTSTS_E_DATA1 | 0x2   | DATA1      
 *  ALT_USB_GLOB_GRXSTSP_PKTSTS_E_MDATA | 0x3   | MDATA      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSP_PKTSTS
 * 
 * DATA0
 */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_E_DATA0 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSP_PKTSTS
 * 
 * DATA2
 */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_E_DATA2 0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSP_PKTSTS
 * 
 * DATA1
 */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_E_DATA1 0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSP_PKTSTS
 * 
 * MDATA
 */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_E_MDATA 0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSP_PKTSTS register field. */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSP_PKTSTS register field. */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_MSB        20
/* The width in bits of the ALT_USB_GLOB_GRXSTSP_PKTSTS register field. */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GRXSTSP_PKTSTS register field value. */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_SET_MSK    0x001e0000
/* The mask used to clear the ALT_USB_GLOB_GRXSTSP_PKTSTS register field value. */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_CLR_MSK    0xffe1ffff
/* The reset value of the ALT_USB_GLOB_GRXSTSP_PKTSTS register field. */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSP_PKTSTS field value from a register. */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_GET(value) (((value) & 0x001e0000) >> 17)
/* Produces a ALT_USB_GLOB_GRXSTSP_PKTSTS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_SET(value) (((value) << 17) & 0x001e0000)

/*
 * Field : fn
 * 
 * Mode: Device only
 * 
 * Frame Number (FN)
 * 
 * This is the least significant 4 bits of the (micro)Frame number in
 * 
 * which the packet is received on the USB. This field is supported
 * 
 * only when isochronous OUT endpoints are supported.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSP_FN register field. */
#define ALT_USB_GLOB_GRXSTSP_FN_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSP_FN register field. */
#define ALT_USB_GLOB_GRXSTSP_FN_MSB        24
/* The width in bits of the ALT_USB_GLOB_GRXSTSP_FN register field. */
#define ALT_USB_GLOB_GRXSTSP_FN_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GRXSTSP_FN register field value. */
#define ALT_USB_GLOB_GRXSTSP_FN_SET_MSK    0x01e00000
/* The mask used to clear the ALT_USB_GLOB_GRXSTSP_FN register field value. */
#define ALT_USB_GLOB_GRXSTSP_FN_CLR_MSK    0xfe1fffff
/* The reset value of the ALT_USB_GLOB_GRXSTSP_FN register field. */
#define ALT_USB_GLOB_GRXSTSP_FN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSP_FN field value from a register. */
#define ALT_USB_GLOB_GRXSTSP_FN_GET(value) (((value) & 0x01e00000) >> 21)
/* Produces a ALT_USB_GLOB_GRXSTSP_FN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSP_FN_SET(value) (((value) << 21) & 0x01e00000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GRXSTSP.
 */
struct ALT_USB_GLOB_GRXSTSP_s
{
    const uint32_t  chnum  :  4;  /* ALT_USB_GLOB_GRXSTSP_CHNUM */
    const uint32_t  bcnt   : 11;  /* ALT_USB_GLOB_GRXSTSP_BCNT */
    const uint32_t  dpid   :  2;  /* ALT_USB_GLOB_GRXSTSP_DPID */
    const uint32_t  pktsts :  4;  /* ALT_USB_GLOB_GRXSTSP_PKTSTS */
    const uint32_t  fn     :  4;  /* ALT_USB_GLOB_GRXSTSP_FN */
    uint32_t               :  7;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GRXSTSP. */
typedef volatile struct ALT_USB_GLOB_GRXSTSP_s  ALT_USB_GLOB_GRXSTSP_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GRXSTSP register. */
#define ALT_USB_GLOB_GRXSTSP_RESET       0x00000000
/* The byte offset of the ALT_USB_GLOB_GRXSTSP register from the beginning of the component. */
#define ALT_USB_GLOB_GRXSTSP_OFST        0x20
/* The address of the ALT_USB_GLOB_GRXSTSP register. */
#define ALT_USB_GLOB_GRXSTSP_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GRXSTSP_OFST))

/*
 * Register : grxfsiz
 * 
 * Receive FIFO Size Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                
 * :--------|:-------|:-------|:----------------------------
 *  [13:0]  | RW     | 0x2000 | ALT_USB_GLOB_GRXFSIZ_RXFDEP
 *  [31:14] | ???    | 0x0    | *UNDEFINED*                
 * 
 */
/*
 * Field : rxfdep
 * 
 * Mode: Host and Device
 * 
 * RxFIFO Depth (RxFDep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest Rx Data FIFO Depth during configuration. If Enable Dynamic FIFO Sizing
 * was selected,
 * 
 * you can write a new value in this field. Programmed values must not exceed the
 * power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXFSIZ_RXFDEP register field. */
#define ALT_USB_GLOB_GRXFSIZ_RXFDEP_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXFSIZ_RXFDEP register field. */
#define ALT_USB_GLOB_GRXFSIZ_RXFDEP_MSB        13
/* The width in bits of the ALT_USB_GLOB_GRXFSIZ_RXFDEP register field. */
#define ALT_USB_GLOB_GRXFSIZ_RXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_GRXFSIZ_RXFDEP register field value. */
#define ALT_USB_GLOB_GRXFSIZ_RXFDEP_SET_MSK    0x00003fff
/* The mask used to clear the ALT_USB_GLOB_GRXFSIZ_RXFDEP register field value. */
#define ALT_USB_GLOB_GRXFSIZ_RXFDEP_CLR_MSK    0xffffc000
/* The reset value of the ALT_USB_GLOB_GRXFSIZ_RXFDEP register field. */
#define ALT_USB_GLOB_GRXFSIZ_RXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_GRXFSIZ_RXFDEP field value from a register. */
#define ALT_USB_GLOB_GRXFSIZ_RXFDEP_GET(value) (((value) & 0x00003fff) >> 0)
/* Produces a ALT_USB_GLOB_GRXFSIZ_RXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXFSIZ_RXFDEP_SET(value) (((value) << 0) & 0x00003fff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GRXFSIZ.
 */
struct ALT_USB_GLOB_GRXFSIZ_s
{
    uint32_t  rxfdep : 14;  /* ALT_USB_GLOB_GRXFSIZ_RXFDEP */
    uint32_t         : 18;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GRXFSIZ. */
typedef volatile struct ALT_USB_GLOB_GRXFSIZ_s  ALT_USB_GLOB_GRXFSIZ_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GRXFSIZ register. */
#define ALT_USB_GLOB_GRXFSIZ_RESET       0x00002000
/* The byte offset of the ALT_USB_GLOB_GRXFSIZ register from the beginning of the component. */
#define ALT_USB_GLOB_GRXFSIZ_OFST        0x24
/* The address of the ALT_USB_GLOB_GRXFSIZ register. */
#define ALT_USB_GLOB_GRXFSIZ_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GRXFSIZ_OFST))

/*
 * Register : gnptxfsiz
 * 
 * Non-periodic Transmit FIFO Size Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                       
 * :--------|:-------|:-------|:-----------------------------------
 *  [15:0]  | RW     | 0x2000 | ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR
 *  [31:16] | RW     | 0x2000 | ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP   
 * 
 */
/*
 * Field : nptxfstaddr
 * 
 * Mode: Host only
 * 
 * Non-periodic Transmit RAM Start Address (NPTxFStAddr)
 * 
 * For host mode, this field is always valid. This field contains the memory start
 * address
 * 
 * For Non-periodic Transmit FIFO RAM.
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Mode: Device only
 * 
 * IN Endpoint FIFO0 Transmit RAM Start Address
 * 
 * (INEPTxF0StAddr)
 * 
 * This field contains the memory start address For IN Endpoint
 * 
 * Transmit FIFO# 0.
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR register field. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR register field. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR register field. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR register field value. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR register field value. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR register field. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR_RESET      0x2000
/* Extracts the ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : nptxfdep
 * 
 * Mode: Host only
 * 
 * Non-periodic TxFIFO Depth (NPTxFDep)
 * 
 * For host mode, this field is always valid.
 * 
 * For Device mode, this field is valid for shared fifo
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Mode: Device only
 * 
 * IN Endpoint TxFIFO 0 Depth (INEPTxF0Dep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * This field is determined by Enable Dynamic FIFO Sizing
 * 
 * Programmed values must not
 * 
 * exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP register field. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP register field. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP_MSB        31
/* The width in bits of the ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP register field. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP register field value. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP_SET_MSK    0xffff0000
/* The mask used to clear the ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP register field value. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP_CLR_MSK    0x0000ffff
/* The reset value of the ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP register field. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP field value from a register. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP_GET(value) (((value) & 0xffff0000) >> 16)
/* Produces a ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP_SET(value) (((value) << 16) & 0xffff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GNPTXFSIZ.
 */
struct ALT_USB_GLOB_GNPTXFSIZ_s
{
    uint32_t  nptxfstaddr : 16;  /* ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR */
    uint32_t  nptxfdep    : 16;  /* ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP */
};

/* The typedef declaration for register ALT_USB_GLOB_GNPTXFSIZ. */
typedef volatile struct ALT_USB_GLOB_GNPTXFSIZ_s  ALT_USB_GLOB_GNPTXFSIZ_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GNPTXFSIZ register. */
#define ALT_USB_GLOB_GNPTXFSIZ_RESET       0x20002000
/* The byte offset of the ALT_USB_GLOB_GNPTXFSIZ register from the beginning of the component. */
#define ALT_USB_GLOB_GNPTXFSIZ_OFST        0x28
/* The address of the ALT_USB_GLOB_GNPTXFSIZ register. */
#define ALT_USB_GLOB_GNPTXFSIZ_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GNPTXFSIZ_OFST))

/*
 * Register : gnptxsts
 * 
 * Non-periodic Transmit FIFO/Queue Status Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                        
 * :--------|:-------|:-------|:------------------------------------
 *  [15:0]  | R      | 0x2000 | ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL
 *  [23:16] | R      | 0x8    | ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 *  [30:24] | R      | 0x0    | ALT_USB_GLOB_GNPTXSTS_NPTXQTOP     
 *  [31]    | ???    | 0x0    | *UNDEFINED*                        
 * 
 */
/*
 * Field : nptxfspcavail
 * 
 * Non-periodic TxFIFO Space Avail (NPTxFSpcAvail)
 * 
 * Indicates the amount of free space available in the Non-periodic
 * 
 * TxFIFO.
 * 
 * Values are in terms of 32-bit words.
 * 
 * 16'h0: Non-periodic TxFIFO is full
 * 
 * 16'h1: 1 word available
 * 
 * 16'h2: 2 words available
 * 
 * 16'hn: n words available (where 0 <= n <= 32,768)
 * 
 * 16'h8000: 32,768 words available
 * 
 * Others: Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL_MSB        15
/* The width in bits of the ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL register field value. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL register field value. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL_RESET      0x2000
/* Extracts the ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL field value from a register. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : nptxqspcavail
 * 
 * Non-periodic Transmit Request Queue Space Available
 * 
 * (NPTxQSpcAvail)
 * 
 * Indicates the amount of free space available in the Non-periodic
 * 
 * Transmit Request Queue. This queue holds both IN and OUT
 * 
 * requests in Host mode. Device mode has only IN requests.
 * 
 * 8'h0: Non-periodic Transmit Request Queue is full
 * 
 * 8'h1: 1 location available
 * 
 * 8'h2: 2 locations available
 * 
 * n: n locations available (0 <= n <= 8)
 * 
 * Others: Reserved
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                                
 * :-------------------------------------------|:------|:--------------------------------------------
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_FULL | 0x0   | Non-periodic Transmit Request Queue is full
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE1 | 0x1   | 1 location available                       
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE2 | 0x2   | 2 locations available                      
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE3 | 0x3   | 3 locations available                      
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE4 | 0x4   | 4 locations available                      
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE5 | 0x5   | 5 locations available                      
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE6 | 0x6   | 6 locations available                      
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE7 | 0x7   | 7 locations available                      
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE8 | 0x8   | 8 locations available                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * Non-periodic Transmit Request Queue is full
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_FULL  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * 1 location available
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE1  0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * 2 locations available
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE2  0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * 3 locations available
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE3  0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * 4 locations available
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE4  0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * 5 locations available
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE5  0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * 6 locations available
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE6  0x6
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * 7 locations available
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE7  0x7
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * 8 locations available
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE8  0x8

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_MSB        23
/* The width in bits of the ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_WIDTH      8
/* The mask used to set the ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL register field value. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL register field value. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_CLR_MSK    0xff00ffff
/* The reset value of the ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_RESET      0x8
/* Extracts the ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL field value from a register. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : nptxqtop
 * 
 * Top of the Non-periodic Transmit Request Queue (NPTxQTop)
 * 
 * Entry in the Non-periodic Tx Request Queue that is currently
 * 
 * being processed by the MAC.
 * 
 * Bits [30:27]: Channel/endpoint number
 * 
 * Bits [26:25]:
 * 
 * * 2'b00: IN/OUT token
 * 
 * * 2'b01: Zero-length transmit packet (device IN/host OUT)
 * 
 * * 2'b10: PING/CSPLIT token
 * 
 * * 2'b11: Channel halt command
 * 
 * Bit [24]: Terminate (last Entry For selected channel/endpoint)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_E_INOUTTK    | 0x0   | IN/OUT token                                    
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_E_ZEROTX     | 0x1   | Zero-length transmit packet (device IN/host OUT)
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_E_PINGCSPLIT | 0x2   | PING/CSPLIT token                               
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_E_CHNHALT    | 0x3   | Channel halt command                            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQTOP
 * 
 * IN/OUT token
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_E_INOUTTK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQTOP
 * 
 * Zero-length transmit packet (device IN/host OUT)
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_E_ZEROTX     0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQTOP
 * 
 * PING/CSPLIT token
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_E_PINGCSPLIT 0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQTOP
 * 
 * Channel halt command
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_E_CHNHALT    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GNPTXSTS_NPTXQTOP register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GNPTXSTS_NPTXQTOP register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_MSB        30
/* The width in bits of the ALT_USB_GLOB_GNPTXSTS_NPTXQTOP register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_WIDTH      7
/* The mask used to set the ALT_USB_GLOB_GNPTXSTS_NPTXQTOP register field value. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_SET_MSK    0x7f000000
/* The mask used to clear the ALT_USB_GLOB_GNPTXSTS_NPTXQTOP register field value. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_CLR_MSK    0x80ffffff
/* The reset value of the ALT_USB_GLOB_GNPTXSTS_NPTXQTOP register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GNPTXSTS_NPTXQTOP field value from a register. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_GET(value) (((value) & 0x7f000000) >> 24)
/* Produces a ALT_USB_GLOB_GNPTXSTS_NPTXQTOP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_SET(value) (((value) << 24) & 0x7f000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GNPTXSTS.
 */
struct ALT_USB_GLOB_GNPTXSTS_s
{
    const uint32_t  nptxfspcavail : 16;  /* ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL */
    const uint32_t  nptxqspcavail :  8;  /* ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL */
    const uint32_t  nptxqtop      :  7;  /* ALT_USB_GLOB_GNPTXSTS_NPTXQTOP */
    uint32_t                      :  1;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GNPTXSTS. */
typedef volatile struct ALT_USB_GLOB_GNPTXSTS_s  ALT_USB_GLOB_GNPTXSTS_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GNPTXSTS register. */
#define ALT_USB_GLOB_GNPTXSTS_RESET       0x00082000
/* The byte offset of the ALT_USB_GLOB_GNPTXSTS register from the beginning of the component. */
#define ALT_USB_GLOB_GNPTXSTS_OFST        0x2c
/* The address of the ALT_USB_GLOB_GNPTXSTS register. */
#define ALT_USB_GLOB_GNPTXSTS_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GNPTXSTS_OFST))

/*
 * Register : gpvndctl
 * 
 * PHY Vendor Control Register
 * 
 * Register Layout
 * 
 *  Bits    | Access   | Reset | Description                      
 * :--------|:---------|:------|:----------------------------------
 *  [7:0]   | RW       | 0x0   | ALT_USB_GLOB_GPVNDCTL_REGDATA    
 *  [15:8]  | RW       | 0x0   | ALT_USB_GLOB_GPVNDCTL_VCTL       
 *  [21:16] | RW       | 0x0   | ALT_USB_GLOB_GPVNDCTL_REGADDR    
 *  [22]    | RW       | 0x0   | ALT_USB_GLOB_GPVNDCTL_REGWR      
 *  [24:23] | ???      | 0x0   | *UNDEFINED*                      
 *  [25]    | R-W once | 0x0   | ALT_USB_GLOB_GPVNDCTL_NEWREGREQ  
 *  [26]    | R        | 0x0   | ALT_USB_GLOB_GPVNDCTL_VSTSBSY    
 *  [27]    | RW       | 0x0   | ALT_USB_GLOB_GPVNDCTL_VSTSDONE   
 *  [30:28] | ???      | 0x0   | *UNDEFINED*                      
 *  [31]    | R-W once | 0x0   | ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR
 * 
 */
/*
 * Field : regdata
 * 
 * Register Data (RegData)
 * 
 * Contains the write data For register write. Read data For
 * 
 * register read, valid when VStatus Done is Set.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GPVNDCTL_REGDATA register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGDATA_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GPVNDCTL_REGDATA register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGDATA_MSB        7
/* The width in bits of the ALT_USB_GLOB_GPVNDCTL_REGDATA register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGDATA_WIDTH      8
/* The mask used to set the ALT_USB_GLOB_GPVNDCTL_REGDATA register field value. */
#define ALT_USB_GLOB_GPVNDCTL_REGDATA_SET_MSK    0x000000ff
/* The mask used to clear the ALT_USB_GLOB_GPVNDCTL_REGDATA register field value. */
#define ALT_USB_GLOB_GPVNDCTL_REGDATA_CLR_MSK    0xffffff00
/* The reset value of the ALT_USB_GLOB_GPVNDCTL_REGDATA register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGDATA_RESET      0x0
/* Extracts the ALT_USB_GLOB_GPVNDCTL_REGDATA field value from a register. */
#define ALT_USB_GLOB_GPVNDCTL_REGDATA_GET(value) (((value) & 0x000000ff) >> 0)
/* Produces a ALT_USB_GLOB_GPVNDCTL_REGDATA register field value suitable for setting the register. */
#define ALT_USB_GLOB_GPVNDCTL_REGDATA_SET(value) (((value) << 0) & 0x000000ff)

/*
 * Field : vctrl
 * 
 * UTMI+ Vendor Control Register Address (VCtrl)
 * 
 * The 4-bit register address a vendor defined 4-bit parallel
 * 
 * output bus. Bits 11:8 of this field are placed on
 * 
 * utmi_vcontrol[3:0].
 * 
 * ULPI Extended Register Address (ExtRegAddr)
 * 
 * The 6-bit PHY extended register address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GPVNDCTL_VCTL register field. */
#define ALT_USB_GLOB_GPVNDCTL_VCTL_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GPVNDCTL_VCTL register field. */
#define ALT_USB_GLOB_GPVNDCTL_VCTL_MSB        15
/* The width in bits of the ALT_USB_GLOB_GPVNDCTL_VCTL register field. */
#define ALT_USB_GLOB_GPVNDCTL_VCTL_WIDTH      8
/* The mask used to set the ALT_USB_GLOB_GPVNDCTL_VCTL register field value. */
#define ALT_USB_GLOB_GPVNDCTL_VCTL_SET_MSK    0x0000ff00
/* The mask used to clear the ALT_USB_GLOB_GPVNDCTL_VCTL register field value. */
#define ALT_USB_GLOB_GPVNDCTL_VCTL_CLR_MSK    0xffff00ff
/* The reset value of the ALT_USB_GLOB_GPVNDCTL_VCTL register field. */
#define ALT_USB_GLOB_GPVNDCTL_VCTL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GPVNDCTL_VCTL field value from a register. */
#define ALT_USB_GLOB_GPVNDCTL_VCTL_GET(value) (((value) & 0x0000ff00) >> 8)
/* Produces a ALT_USB_GLOB_GPVNDCTL_VCTL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GPVNDCTL_VCTL_SET(value) (((value) << 8) & 0x0000ff00)

/*
 * Field : regaddr
 * 
 * Register Address (RegAddr)
 * 
 * The 6-bit PHY register address For immediate PHY Register
 * 
 * Set access. Set to 6'h2F For Extended PHY Register Set
 * 
 * access.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GPVNDCTL_REGADDR register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGADDR_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GPVNDCTL_REGADDR register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGADDR_MSB        21
/* The width in bits of the ALT_USB_GLOB_GPVNDCTL_REGADDR register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGADDR_WIDTH      6
/* The mask used to set the ALT_USB_GLOB_GPVNDCTL_REGADDR register field value. */
#define ALT_USB_GLOB_GPVNDCTL_REGADDR_SET_MSK    0x003f0000
/* The mask used to clear the ALT_USB_GLOB_GPVNDCTL_REGADDR register field value. */
#define ALT_USB_GLOB_GPVNDCTL_REGADDR_CLR_MSK    0xffc0ffff
/* The reset value of the ALT_USB_GLOB_GPVNDCTL_REGADDR register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGADDR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GPVNDCTL_REGADDR field value from a register. */
#define ALT_USB_GLOB_GPVNDCTL_REGADDR_GET(value) (((value) & 0x003f0000) >> 16)
/* Produces a ALT_USB_GLOB_GPVNDCTL_REGADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GPVNDCTL_REGADDR_SET(value) (((value) << 16) & 0x003f0000)

/*
 * Field : regwr
 * 
 * Register Write (RegWr)
 * 
 * Set this bit For register writes, and clear it For register reads.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description   
 * :---------------------------------|:------|:---------------
 *  ALT_USB_GLOB_GPVNDCTL_REGWR_E_RD | 0x0   | Register Write
 *  ALT_USB_GLOB_GPVNDCTL_REGWR_E_WR | 0x1   | Register Write
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_REGWR
 * 
 * Register Write
 */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_E_RD    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_REGWR
 * 
 * Register Write
 */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_E_WR    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GPVNDCTL_REGWR register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GPVNDCTL_REGWR register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_MSB        22
/* The width in bits of the ALT_USB_GLOB_GPVNDCTL_REGWR register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GPVNDCTL_REGWR register field value. */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_SET_MSK    0x00400000
/* The mask used to clear the ALT_USB_GLOB_GPVNDCTL_REGWR register field value. */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_CLR_MSK    0xffbfffff
/* The reset value of the ALT_USB_GLOB_GPVNDCTL_REGWR register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GPVNDCTL_REGWR field value from a register. */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_USB_GLOB_GPVNDCTL_REGWR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : newregreq
 * 
 * New Register Request (NewRegReq)
 * 
 * The application sets this bit For a new vendor control
 * 
 * access.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                    
 * :----------------------------------------|:------|:--------------------------------
 *  ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_E_INACT | 0x0   | New Register Request not active
 *  ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_E_ACT   | 0x1   | New Register Request active    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_NEWREGREQ
 * 
 * New Register Request not active
 */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_NEWREGREQ
 * 
 * New Register Request active
 */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GPVNDCTL_NEWREGREQ register field. */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GPVNDCTL_NEWREGREQ register field. */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_MSB        25
/* The width in bits of the ALT_USB_GLOB_GPVNDCTL_NEWREGREQ register field. */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GPVNDCTL_NEWREGREQ register field value. */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_SET_MSK    0x02000000
/* The mask used to clear the ALT_USB_GLOB_GPVNDCTL_NEWREGREQ register field value. */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_CLR_MSK    0xfdffffff
/* The reset value of the ALT_USB_GLOB_GPVNDCTL_NEWREGREQ register field. */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_RESET      0x0
/* Extracts the ALT_USB_GLOB_GPVNDCTL_NEWREGREQ field value from a register. */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_USB_GLOB_GPVNDCTL_NEWREGREQ register field value suitable for setting the register. */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : vstsbsy
 * 
 * VStatus Busy (VStsBsy)
 * 
 * The core sets this bit when the vendor control access is in
 * 
 * progress and clears this bit when done.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description          
 * :--------------------------------------|:------|:----------------------
 *  ALT_USB_GLOB_GPVNDCTL_VSTSBSY_E_INACT | 0x0   | VStatus Busy inactive
 *  ALT_USB_GLOB_GPVNDCTL_VSTSBSY_E_ACT   | 0x1   | VStatus Busy active  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_VSTSBSY
 * 
 * VStatus Busy inactive
 */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_VSTSBSY
 * 
 * VStatus Busy active
 */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GPVNDCTL_VSTSBSY register field. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GPVNDCTL_VSTSBSY register field. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_MSB        26
/* The width in bits of the ALT_USB_GLOB_GPVNDCTL_VSTSBSY register field. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GPVNDCTL_VSTSBSY register field value. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_SET_MSK    0x04000000
/* The mask used to clear the ALT_USB_GLOB_GPVNDCTL_VSTSBSY register field value. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_CLR_MSK    0xfbffffff
/* The reset value of the ALT_USB_GLOB_GPVNDCTL_VSTSBSY register field. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_RESET      0x0
/* Extracts the ALT_USB_GLOB_GPVNDCTL_VSTSBSY field value from a register. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_USB_GLOB_GPVNDCTL_VSTSBSY register field value suitable for setting the register. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : vstsdone
 * 
 * VStatus Done (VStsDone)
 * 
 * The core sets this bit when the vendor control access is
 * 
 * done.
 * 
 * This bit is cleared by the core when the application sets the
 * 
 * New Register Request bit (bit 25).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description          
 * :---------------------------------------|:------|:----------------------
 *  ALT_USB_GLOB_GPVNDCTL_VSTSDONE_E_INACT | 0x0   | VStatus Done inactive
 *  ALT_USB_GLOB_GPVNDCTL_VSTSDONE_E_ACT   | 0x1   | VStatus Done active  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_VSTSDONE
 * 
 * VStatus Done inactive
 */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_VSTSDONE
 * 
 * VStatus Done active
 */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GPVNDCTL_VSTSDONE register field. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GPVNDCTL_VSTSDONE register field. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_MSB        27
/* The width in bits of the ALT_USB_GLOB_GPVNDCTL_VSTSDONE register field. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GPVNDCTL_VSTSDONE register field value. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_SET_MSK    0x08000000
/* The mask used to clear the ALT_USB_GLOB_GPVNDCTL_VSTSDONE register field value. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_USB_GLOB_GPVNDCTL_VSTSDONE register field. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_RESET      0x0
/* Extracts the ALT_USB_GLOB_GPVNDCTL_VSTSDONE field value from a register. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_USB_GLOB_GPVNDCTL_VSTSDONE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : disulpidrvr
 * 
 * Disable ULPI Drivers (DisUlpiDrvr)
 * 
 * The application sets this bit when it has finished processing
 * 
 * the ULPI Carkit Interrupt (GINTSTS.ULPICKINT). When
 * 
 * Set, the DWC_otg core disables drivers For output signals
 * 
 * and masks input signal For the ULPI interface. DWC_otg
 * 
 * clears this bit before enabling the ULPI interface.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description               
 * :-----------------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_E_END  | 0x0   | ULPI ouput signals        
 *  ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_E_DISD | 0x1   | Disable ULPI ouput signals
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR
 * 
 * ULPI ouput signals
 */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_E_END     0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR
 * 
 * Disable ULPI ouput signals
 */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_E_DISD    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR register field. */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR register field. */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_MSB        31
/* The width in bits of the ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR register field. */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR register field value. */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR register field value. */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR register field. */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR field value from a register. */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GPVNDCTL.
 */
struct ALT_USB_GLOB_GPVNDCTL_s
{
    uint32_t        regdata     :  8;  /* ALT_USB_GLOB_GPVNDCTL_REGDATA */
    uint32_t        vctrl       :  8;  /* ALT_USB_GLOB_GPVNDCTL_VCTL */
    uint32_t        regaddr     :  6;  /* ALT_USB_GLOB_GPVNDCTL_REGADDR */
    uint32_t        regwr       :  1;  /* ALT_USB_GLOB_GPVNDCTL_REGWR */
    uint32_t                    :  2;  /* *UNDEFINED* */
    uint32_t        newregreq   :  1;  /* ALT_USB_GLOB_GPVNDCTL_NEWREGREQ */
    const uint32_t  vstsbsy     :  1;  /* ALT_USB_GLOB_GPVNDCTL_VSTSBSY */
    uint32_t        vstsdone    :  1;  /* ALT_USB_GLOB_GPVNDCTL_VSTSDONE */
    uint32_t                    :  3;  /* *UNDEFINED* */
    uint32_t        disulpidrvr :  1;  /* ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR */
};

/* The typedef declaration for register ALT_USB_GLOB_GPVNDCTL. */
typedef volatile struct ALT_USB_GLOB_GPVNDCTL_s  ALT_USB_GLOB_GPVNDCTL_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GPVNDCTL register. */
#define ALT_USB_GLOB_GPVNDCTL_RESET       0x00000000
/* The byte offset of the ALT_USB_GLOB_GPVNDCTL register from the beginning of the component. */
#define ALT_USB_GLOB_GPVNDCTL_OFST        0x34
/* The address of the ALT_USB_GLOB_GPVNDCTL register. */
#define ALT_USB_GLOB_GPVNDCTL_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GPVNDCTL_OFST))

/*
 * Register : ggpio
 * 
 * General Purpose Input/Output Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description           
 * :--------|:-------|:------|:-----------------------
 *  [15:0]  | R      | 0x0   | ALT_USB_GLOB_GGPIO_GPI
 *  [31:16] | RW     | 0x0   | ALT_USB_GLOB_GGPIO_GPO
 * 
 */
/*
 * Field : gpi
 * 
 * General Purpose Input (GPI)
 * 
 * This field's read value reflects the gp_i[15:0] core input value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GGPIO_GPI register field. */
#define ALT_USB_GLOB_GGPIO_GPI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GGPIO_GPI register field. */
#define ALT_USB_GLOB_GGPIO_GPI_MSB        15
/* The width in bits of the ALT_USB_GLOB_GGPIO_GPI register field. */
#define ALT_USB_GLOB_GGPIO_GPI_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_GGPIO_GPI register field value. */
#define ALT_USB_GLOB_GGPIO_GPI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_GGPIO_GPI register field value. */
#define ALT_USB_GLOB_GGPIO_GPI_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_GGPIO_GPI register field. */
#define ALT_USB_GLOB_GGPIO_GPI_RESET      0x0
/* Extracts the ALT_USB_GLOB_GGPIO_GPI field value from a register. */
#define ALT_USB_GLOB_GGPIO_GPI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_GGPIO_GPI register field value suitable for setting the register. */
#define ALT_USB_GLOB_GGPIO_GPI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : gpo
 * 
 * General Purpose Output (GPO)
 * 
 * This field is driven as an output from the core, gp_o[15:0]. The
 * 
 * application can program this field to determine the
 * 
 * corresponding value on the gp_o[15:0] output.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GGPIO_GPO register field. */
#define ALT_USB_GLOB_GGPIO_GPO_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GGPIO_GPO register field. */
#define ALT_USB_GLOB_GGPIO_GPO_MSB        31
/* The width in bits of the ALT_USB_GLOB_GGPIO_GPO register field. */
#define ALT_USB_GLOB_GGPIO_GPO_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_GGPIO_GPO register field value. */
#define ALT_USB_GLOB_GGPIO_GPO_SET_MSK    0xffff0000
/* The mask used to clear the ALT_USB_GLOB_GGPIO_GPO register field value. */
#define ALT_USB_GLOB_GGPIO_GPO_CLR_MSK    0x0000ffff
/* The reset value of the ALT_USB_GLOB_GGPIO_GPO register field. */
#define ALT_USB_GLOB_GGPIO_GPO_RESET      0x0
/* Extracts the ALT_USB_GLOB_GGPIO_GPO field value from a register. */
#define ALT_USB_GLOB_GGPIO_GPO_GET(value) (((value) & 0xffff0000) >> 16)
/* Produces a ALT_USB_GLOB_GGPIO_GPO register field value suitable for setting the register. */
#define ALT_USB_GLOB_GGPIO_GPO_SET(value) (((value) << 16) & 0xffff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GGPIO.
 */
struct ALT_USB_GLOB_GGPIO_s
{
    const uint32_t  gpi : 16;  /* ALT_USB_GLOB_GGPIO_GPI */
    uint32_t        gpo : 16;  /* ALT_USB_GLOB_GGPIO_GPO */
};

/* The typedef declaration for register ALT_USB_GLOB_GGPIO. */
typedef volatile struct ALT_USB_GLOB_GGPIO_s  ALT_USB_GLOB_GGPIO_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GGPIO register. */
#define ALT_USB_GLOB_GGPIO_RESET       0x00000000
/* The byte offset of the ALT_USB_GLOB_GGPIO register from the beginning of the component. */
#define ALT_USB_GLOB_GGPIO_OFST        0x38
/* The address of the ALT_USB_GLOB_GGPIO register. */
#define ALT_USB_GLOB_GGPIO_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GGPIO_OFST))

/*
 * Register : guid
 * 
 * User ID Register
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description           
 * :-------|:-------|:-----------|:-----------------------
 *  [31:0] | R      | 0x12345678 | ALT_USB_GLOB_GUID_GUID
 * 
 */
/*
 * Field : guid
 * 
 * User ID (UserID)
 * 
 * Application-programmable ID field.
 * 
 * Reset: Configurable
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUID_GUID register field. */
#define ALT_USB_GLOB_GUID_GUID_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUID_GUID register field. */
#define ALT_USB_GLOB_GUID_GUID_MSB        31
/* The width in bits of the ALT_USB_GLOB_GUID_GUID register field. */
#define ALT_USB_GLOB_GUID_GUID_WIDTH      32
/* The mask used to set the ALT_USB_GLOB_GUID_GUID register field value. */
#define ALT_USB_GLOB_GUID_GUID_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_GLOB_GUID_GUID register field value. */
#define ALT_USB_GLOB_GUID_GUID_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_GLOB_GUID_GUID register field. */
#define ALT_USB_GLOB_GUID_GUID_RESET      0x12345678
/* Extracts the ALT_USB_GLOB_GUID_GUID field value from a register. */
#define ALT_USB_GLOB_GUID_GUID_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_GLOB_GUID_GUID register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUID_GUID_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GUID.
 */
struct ALT_USB_GLOB_GUID_s
{
    const uint32_t  guid : 32;  /* ALT_USB_GLOB_GUID_GUID */
};

/* The typedef declaration for register ALT_USB_GLOB_GUID. */
typedef volatile struct ALT_USB_GLOB_GUID_s  ALT_USB_GLOB_GUID_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GUID register. */
#define ALT_USB_GLOB_GUID_RESET       0x12345678
/* The byte offset of the ALT_USB_GLOB_GUID register from the beginning of the component. */
#define ALT_USB_GLOB_GUID_OFST        0x3c
/* The address of the ALT_USB_GLOB_GUID register. */
#define ALT_USB_GLOB_GUID_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GUID_OFST))

/*
 * Register : gsnpsid
 * 
 * Synopsys ID Register
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description                 
 * :-------|:-------|:-----------|:-----------------------------
 *  [31:0] | R      | 0x4f54320a | ALT_USB_GLOB_GSNPSID_GSNPSID
 * 
 */
/*
 * Field : gsnpsid
 * 
 * Release number of the DWC_otg core being used is currently
 * 
 * OTG
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GSNPSID_GSNPSID register field. */
#define ALT_USB_GLOB_GSNPSID_GSNPSID_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GSNPSID_GSNPSID register field. */
#define ALT_USB_GLOB_GSNPSID_GSNPSID_MSB        31
/* The width in bits of the ALT_USB_GLOB_GSNPSID_GSNPSID register field. */
#define ALT_USB_GLOB_GSNPSID_GSNPSID_WIDTH      32
/* The mask used to set the ALT_USB_GLOB_GSNPSID_GSNPSID register field value. */
#define ALT_USB_GLOB_GSNPSID_GSNPSID_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_GLOB_GSNPSID_GSNPSID register field value. */
#define ALT_USB_GLOB_GSNPSID_GSNPSID_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_GLOB_GSNPSID_GSNPSID register field. */
#define ALT_USB_GLOB_GSNPSID_GSNPSID_RESET      0x4f54320a
/* Extracts the ALT_USB_GLOB_GSNPSID_GSNPSID field value from a register. */
#define ALT_USB_GLOB_GSNPSID_GSNPSID_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_GLOB_GSNPSID_GSNPSID register field value suitable for setting the register. */
#define ALT_USB_GLOB_GSNPSID_GSNPSID_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GSNPSID.
 */
struct ALT_USB_GLOB_GSNPSID_s
{
    const uint32_t  gsnpsid : 32;  /* ALT_USB_GLOB_GSNPSID_GSNPSID */
};

/* The typedef declaration for register ALT_USB_GLOB_GSNPSID. */
typedef volatile struct ALT_USB_GLOB_GSNPSID_s  ALT_USB_GLOB_GSNPSID_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GSNPSID register. */
#define ALT_USB_GLOB_GSNPSID_RESET       0x4f54320a
/* The byte offset of the ALT_USB_GLOB_GSNPSID register from the beginning of the component. */
#define ALT_USB_GLOB_GSNPSID_OFST        0x40
/* The address of the ALT_USB_GLOB_GSNPSID register. */
#define ALT_USB_GLOB_GSNPSID_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GSNPSID_OFST))

/*
 * Register : ghwcfg1
 * 
 * User HW Config1 Register
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [31:0] | R      | 0x0   | ALT_USB_GLOB_GHWCFG1_GHWCFG1
 * 
 */
/*
 * Field : ghwcfg1
 * 
 * This 32-bit field uses two bits per
 * 
 * endpoint to determine the endpoint direction.
 * 
 * Endpoint
 * 
 * Bits [31:30]: Endpoint 15 direction
 * 
 * Bits [29:28]: Endpoint 14 direction
 * 
 * ...
 * 
 * Bits [3:2]: Endpoint 1 direction
 * 
 * Bits[1:0]: Endpoint 0 direction (always BIDIR)
 * 
 * Direction
 * 
 * 2'b00: BIDIR (IN and OUT) endpoint
 * 
 * 2'b01: IN endpoint
 * 
 * 2'b10: OUT endpoint
 * 
 * 2'b11: Reserved
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                
 * :----------------------------------------|:------|:----------------------------
 *  ALT_USB_GLOB_GHWCFG1_GHWCFG1_E_BDIR     | 0x0   | BIDIR (IN and OUT) endpoint
 *  ALT_USB_GLOB_GHWCFG1_GHWCFG1_E_INENDPT  | 0x1   | IN endpoint                
 *  ALT_USB_GLOB_GHWCFG1_GHWCFG1_E_OUTENDPT | 0x2   | OUT endpoint               
 *  ALT_USB_GLOB_GHWCFG1_GHWCFG1_E_RSVD     | 0x3   | Reserved                   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG1_GHWCFG1
 * 
 * BIDIR (IN and OUT) endpoint
 */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_E_BDIR     0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG1_GHWCFG1
 * 
 * IN endpoint
 */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_E_INENDPT  0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG1_GHWCFG1
 * 
 * OUT endpoint
 */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_E_OUTENDPT 0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG1_GHWCFG1
 * 
 * Reserved
 */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_E_RSVD     0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG1_GHWCFG1 register field. */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG1_GHWCFG1 register field. */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_MSB        31
/* The width in bits of the ALT_USB_GLOB_GHWCFG1_GHWCFG1 register field. */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_WIDTH      32
/* The mask used to set the ALT_USB_GLOB_GHWCFG1_GHWCFG1 register field value. */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_GLOB_GHWCFG1_GHWCFG1 register field value. */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_GLOB_GHWCFG1_GHWCFG1 register field. */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG1_GHWCFG1 field value from a register. */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_GLOB_GHWCFG1_GHWCFG1 register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GHWCFG1.
 */
struct ALT_USB_GLOB_GHWCFG1_s
{
    const uint32_t  ghwcfg1 : 32;  /* ALT_USB_GLOB_GHWCFG1_GHWCFG1 */
};

/* The typedef declaration for register ALT_USB_GLOB_GHWCFG1. */
typedef volatile struct ALT_USB_GLOB_GHWCFG1_s  ALT_USB_GLOB_GHWCFG1_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GHWCFG1 register. */
#define ALT_USB_GLOB_GHWCFG1_RESET       0x00000000
/* The byte offset of the ALT_USB_GLOB_GHWCFG1 register from the beginning of the component. */
#define ALT_USB_GLOB_GHWCFG1_OFST        0x44
/* The address of the ALT_USB_GLOB_GHWCFG1 register. */
#define ALT_USB_GLOB_GHWCFG1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GHWCFG1_OFST))

/*
 * Register : ghwcfg2
 * 
 * User HW Config2 Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                         
 * :--------|:-------|:------|:-------------------------------------
 *  [2:0]   | R      | 0x0   | ALT_USB_GLOB_GHWCFG2_OTGMOD         
 *  [4:3]   | R      | 0x2   | ALT_USB_GLOB_GHWCFG2_OTGARCH        
 *  [5]     | R      | 0x0   | ALT_USB_GLOB_GHWCFG2_SINGPNT        
 *  [7:6]   | R      | 0x2   | ALT_USB_GLOB_GHWCFG2_HSPHYTYPE      
 *  [9:8]   | R      | 0x0   | ALT_USB_GLOB_GHWCFG2_FSPHYTYPE      
 *  [13:10] | R      | 0xf   | ALT_USB_GLOB_GHWCFG2_NUMDEVEPS      
 *  [17:14] | R      | 0xf   | ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL     
 *  [18]    | R      | 0x1   | ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT   
 *  [19]    | R      | 0x1   | ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING  
 *  [20]    | R      | 0x0   | ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT
 *  [21]    | ???    | 0x0   | *UNDEFINED*                         
 *  [23:22] | R      | 0x2   | ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH     
 *  [25:24] | R      | 0x0   | ALT_USB_GLOB_GHWCFG2_PTXQDEPTH      
 *  [30:26] | R      | 0x8   | ALT_USB_GLOB_GHWCFG2_TKNQDEPTH      
 *  [31]    | ???    | 0x0   | *UNDEFINED*                         
 * 
 */
/*
 * Field : otgmode
 * 
 * Mode of Operation (OtgMode)
 * 
 * 3'b000: HNP- and SRP-Capable OTG (Host & Device)
 * 
 * 3'b001: SRP-Capable OTG (Host & Device)
 * 
 * 3'b010: Non-HNP and Non-SRP Capable OTG (Host &
 * 
 * Device)
 * 
 * 3'b011: SRP-Capable Device
 * 
 * 3'b100: Non-OTG Device
 * 
 * 3'b101: SRP-Capable Host
 * 
 * 3'b110: Non-OTG Host
 * 
 * Others: Reserved
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                                    
 * :---------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_GLOB_GHWCFG2_OTGMOD_E_HNPSRP   | 0x0   | HNP- and SRP-Capable OTG (Host & Device        
 *  ALT_USB_GLOB_GHWCFG2_OTGMOD_E_SRPOTG   | 0x1   | SRP-Capable OTG (Host & Device)                
 *  ALT_USB_GLOB_GHWCFG2_OTGMOD_E_NHNPNSRP | 0x2   | Non-HNP and Non-SRP Capable OTG (Host & Device)
 *  ALT_USB_GLOB_GHWCFG2_OTGMOD_E_SRPCAPD  | 0x3   | SRP-Capable Device                             
 *  ALT_USB_GLOB_GHWCFG2_OTGMOD_E_NONOTGD  | 0x4   | Non-OTG Device                                 
 *  ALT_USB_GLOB_GHWCFG2_OTGMOD_E_SRPCAPH  | 0x5   | SRP-Capable Host                               
 *  ALT_USB_GLOB_GHWCFG2_OTGMOD_E_NONOTGH  | 0x6   | Non-OTG Host                                   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_OTGMOD
 * 
 * HNP- and SRP-Capable OTG (Host & Device
 */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_E_HNPSRP    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_OTGMOD
 * 
 * SRP-Capable OTG (Host & Device)
 */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_E_SRPOTG    0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_OTGMOD
 * 
 * Non-HNP and Non-SRP Capable OTG (Host & Device)
 */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_E_NHNPNSRP  0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_OTGMOD
 * 
 * SRP-Capable Device
 */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_E_SRPCAPD   0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_OTGMOD
 * 
 * Non-OTG Device
 */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_E_NONOTGD   0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_OTGMOD
 * 
 * SRP-Capable Host
 */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_E_SRPCAPH   0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_OTGMOD
 * 
 * Non-OTG Host
 */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_E_NONOTGH   0x6

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_OTGMOD register field. */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_OTGMOD register field. */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_MSB        2
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_OTGMOD register field. */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_WIDTH      3
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_OTGMOD register field value. */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_SET_MSK    0x00000007
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_OTGMOD register field value. */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_CLR_MSK    0xfffffff8
/* The reset value of the ALT_USB_GLOB_GHWCFG2_OTGMOD register field. */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG2_OTGMOD field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_GET(value) (((value) & 0x00000007) >> 0)
/* Produces a ALT_USB_GLOB_GHWCFG2_OTGMOD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_SET(value) (((value) << 0) & 0x00000007)

/*
 * Field : otgarch
 * 
 * Architecture (OtgArch)
 * 
 * 2'b00: Slave-Only
 * 
 * 2'b01: External DMA
 * 
 * 2'b10: Internal DMA
 * 
 * Others: Reserved
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description 
 * :--------------------------------------|:------|:-------------
 *  ALT_USB_GLOB_GHWCFG2_OTGARCH_E_DMAMOD | 0x2   | Internal DMA
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_OTGARCH
 * 
 * Internal DMA
 */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_E_DMAMOD   0x2

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_OTGARCH register field. */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_OTGARCH register field. */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_MSB        4
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_OTGARCH register field. */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_WIDTH      2
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_OTGARCH register field value. */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_SET_MSK    0x00000018
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_OTGARCH register field value. */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_CLR_MSK    0xffffffe7
/* The reset value of the ALT_USB_GLOB_GHWCFG2_OTGARCH register field. */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_RESET      0x2
/* Extracts the ALT_USB_GLOB_GHWCFG2_OTGARCH field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_GET(value) (((value) & 0x00000018) >> 3)
/* Produces a ALT_USB_GLOB_GHWCFG2_OTGARCH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_SET(value) (((value) << 3) & 0x00000018)

/*
 * Field : singpnt
 * 
 * Point-to-Point (SingPnt)
 * 
 * 1'b0: Multi-point application  (hub and split support)
 * 
 * 1'b1: Single-point application (no hub and split support)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description            
 * :-------------------------------------------|:------|:------------------------
 *  ALT_USB_GLOB_GHWCFG2_SINGPNT_E_SINGLEPOINT | 0x1   | Single-point applicatio
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_SINGPNT
 * 
 * Single-point applicatio
 */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_E_SINGLEPOINT  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_SINGPNT register field. */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_SINGPNT register field. */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_MSB        5
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_SINGPNT register field. */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_SINGPNT register field value. */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_SINGPNT register field value. */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_GLOB_GHWCFG2_SINGPNT register field. */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG2_SINGPNT field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_GLOB_GHWCFG2_SINGPNT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : hsphytype
 * 
 * High-Speed PHY Interface Type (HSPhyType)
 * 
 * 2'b00: High-Speed interface not supported
 * 
 * 2'b01: UTMI+
 * 
 * 2'b10: ULPI
 * 
 * 2'b11: UTMI+ and ULPI
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                       
 * :--------------------------------------|:------|:-----------------------------------
 *  ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_E_NOHS | 0x0   | High-Speed interface not supported
 *  ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_E_ULPI | 0x2   | ULPI                              
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_HSPHYTYPE
 * 
 * High-Speed interface not supported
 */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_E_NOHS   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_HSPHYTYPE
 * 
 * ULPI
 */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_E_ULPI   0x2

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_HSPHYTYPE register field. */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_HSPHYTYPE register field. */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_MSB        7
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_HSPHYTYPE register field. */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_WIDTH      2
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_HSPHYTYPE register field value. */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_SET_MSK    0x000000c0
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_HSPHYTYPE register field value. */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_CLR_MSK    0xffffff3f
/* The reset value of the ALT_USB_GLOB_GHWCFG2_HSPHYTYPE register field. */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_RESET      0x2
/* Extracts the ALT_USB_GLOB_GHWCFG2_HSPHYTYPE field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_GET(value) (((value) & 0x000000c0) >> 6)
/* Produces a ALT_USB_GLOB_GHWCFG2_HSPHYTYPE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_SET(value) (((value) << 6) & 0x000000c0)

/*
 * Field : fsphytype
 * 
 * Full-Speed PHY Interface Type (FSPhyType)
 * 
 * 2'b00: Full-speed interface not supported
 * 
 * 2'b01: Dedicated full-speed interface
 * 
 * 2'b10: FS pins shared with UTMI+ pins
 * 
 * 2'b11: FS pins shared with ULPI pins
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description
 * :-------------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_E_FULLSPEED | 0x2   | ULPI Type  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_FSPHYTYPE
 * 
 * ULPI Type
 */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_E_FULLSPEED  0x2

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_FSPHYTYPE register field. */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_FSPHYTYPE register field. */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_MSB        9
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_FSPHYTYPE register field. */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_WIDTH      2
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_FSPHYTYPE register field value. */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_SET_MSK    0x00000300
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_FSPHYTYPE register field value. */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_CLR_MSK    0xfffffcff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_FSPHYTYPE register field. */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG2_FSPHYTYPE field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_GET(value) (((value) & 0x00000300) >> 8)
/* Produces a ALT_USB_GLOB_GHWCFG2_FSPHYTYPE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_SET(value) (((value) << 8) & 0x00000300)

/*
 * Field : numdeveps
 * 
 * Number of Device Endpoints (NumDevEps)
 * 
 * Indicates the number of device endpoints supported by the core
 * 
 * in Device mode in addition to control endpoint 0. The range of
 * 
 * this field is 1-15.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description  
 * :-----------------------------------------|:------|:--------------
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT0  | 0x0   | End point  0 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT1  | 0x1   | End point  1 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT2  | 0x2   | End point  2 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT3  | 0x3   | End point  3 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT4  | 0x4   | End point  4 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT5  | 0x5   | End point  5 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT6  | 0x6   | End point  6 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT7  | 0x7   | End point  7 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT8  | 0x8   | End point  8 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT9  | 0x9   | End point  9 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT10 | 0xa   | End point  10
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT11 | 0xb   | End point  11
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT12 | 0xc   | End point  12
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT13 | 0xd   | End point  13
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT14 | 0xe   | End point  14
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT15 | 0xf   | End point  15
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  0
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT0     0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  1
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT1     0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  2
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT2     0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  3
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT3     0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  4
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT4     0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  5
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT5     0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  6
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT6     0x6
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  7
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT7     0x7
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  8
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT8     0x8
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  9
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT9     0x9
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  10
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT10    0xa
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  11
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT11    0xb
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  12
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT12    0xc
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  13
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT13    0xd
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  14
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT14    0xe
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  15
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT15    0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_NUMDEVEPS register field. */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_NUMDEVEPS register field. */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_MSB        13
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_NUMDEVEPS register field. */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_NUMDEVEPS register field value. */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_SET_MSK    0x00003c00
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_NUMDEVEPS register field value. */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_CLR_MSK    0xffffc3ff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_NUMDEVEPS register field. */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_RESET      0xf
/* Extracts the ALT_USB_GLOB_GHWCFG2_NUMDEVEPS field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_GET(value) (((value) & 0x00003c00) >> 10)
/* Produces a ALT_USB_GLOB_GHWCFG2_NUMDEVEPS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_SET(value) (((value) << 10) & 0x00003c00)

/*
 * Field : numhstchnl
 * 
 * Number of Host Channels (NumHstChnl)
 * 
 * Indicates the number of host channels supported by the core in
 * 
 * Host mode. The range of this field is 0-15: 0 specifies 1 channel,
 * 
 * 15 specifies 16 channels.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description    
 * :-------------------------------------------|:------|:----------------
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH0  | 0x0   | Host Channel 1 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH1  | 0x1   | Host Channel 2 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH2  | 0x2   | Host Channel 3 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH3  | 0x3   | Host Channel 4 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH4  | 0x4   | Host Channel 5 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH5  | 0x5   | Host Channel 6 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH6  | 0x6   | Host Channel 7 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH7  | 0x7   | Host Channel 8 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH8  | 0x8   | Host Channel 9 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH9  | 0x9   | Host Channel 10
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH10 | 0xa   | Host Channel 11
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH11 | 0xb   | Host Channel 12
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH12 | 0xc   | Host Channel 13
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH13 | 0xd   | Host Channel 14
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH14 | 0xe   | Host Channel 15
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH15 | 0xf   | Host Channel 16
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 1
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH0   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 2
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH1   0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 3
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH2   0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 4
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH3   0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 5
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH4   0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 6
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH5   0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 7
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH6   0x6
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 8
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH7   0x7
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 9
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH8   0x8
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 10
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH9   0x9
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 11
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH10  0xa
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 12
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH11  0xb
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 13
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH12  0xc
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 14
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH13  0xd
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 15
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH14  0xe
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 16
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH15  0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL register field. */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL register field. */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_MSB        17
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL register field. */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL register field value. */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_SET_MSK    0x0003c000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL register field value. */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_CLR_MSK    0xfffc3fff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL register field. */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_RESET      0xf
/* Extracts the ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_GET(value) (((value) & 0x0003c000) >> 14)
/* Produces a ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_SET(value) (((value) << 14) & 0x0003c000)

/*
 * Field : periosupport
 * 
 * Periodic OUT Channels Supported in Host Mode (PerioSupport)
 * 
 * 1'b0: No
 * 
 * 1'b1: Yes
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                 
 * :----------------------------------------|:------|:---------------------------------------------
 *  ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_E_END | 0x1   | Periodic OUT Channels Supported in Host Mode
 * :                                        |       | Supported                                   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT
 * 
 * Periodic OUT Channels Supported in Host Mode Supported
 */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_E_END 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_MSB        18
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT register field value. */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_SET_MSK    0x00040000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT register field value. */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_CLR_MSK    0xfffbffff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_RESET      0x1
/* Extracts the ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : dynfifosizing
 * 
 * Dynamic FIFO Sizing Enabled (DynFifoSizing)
 * 
 * 1'b0: No
 * 
 * 1'b1: Yes
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                
 * :-----------------------------------------|:------|:----------------------------
 *  ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_E_END | 0x1   | Dynamic FIFO Sizing Enabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING
 * 
 * Dynamic FIFO Sizing Enabled
 */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING register field. */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING register field. */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_MSB        19
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING register field. */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING register field value. */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_SET_MSK    0x00080000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING register field value. */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING register field. */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_RESET      0x1
/* Extracts the ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : multiprocintrpt
 * 
 * Multi Processor Interrupt Enabled (MultiProcIntrpt)
 * 
 * 1'b0: No
 * 
 * 1'b1: Yes
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                         
 * :--------------------------------------------|:------|:-------------------------------------
 *  ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_E_DISD | 0x0   | No Multi Processor Interrupt Enabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT
 * 
 * No Multi Processor Interrupt Enabled
 */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_E_DISD 0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT register field. */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT register field. */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_MSB        20
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT register field. */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT register field value. */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_SET_MSK    0x00100000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT register field value. */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_CLR_MSK    0xffefffff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT register field. */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : nptxqdepth
 * 
 * Non-periodic Request Queue Depth (NPTxQDepth)
 * 
 * 2'b00: 2
 * 
 * 2'b01: 4
 * 
 * 2'b10: 8
 * 
 * Others: Reserved
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_E_TWO   | 0x0   | Que size 2 
 *  ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_E_FOUR  | 0x1   | Que size 4 
 *  ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_E_EIGHT | 0x2   | Que size 8 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH
 * 
 * Que size 2
 */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_E_TWO   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH
 * 
 * Que size 4
 */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_E_FOUR  0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH
 * 
 * Que size 8
 */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_E_EIGHT 0x2

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_MSB        23
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_WIDTH      2
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH register field value. */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_SET_MSK    0x00c00000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH register field value. */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_CLR_MSK    0xff3fffff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_RESET      0x2
/* Extracts the ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_GET(value) (((value) & 0x00c00000) >> 22)
/* Produces a ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_SET(value) (((value) << 22) & 0x00c00000)

/*
 * Field : ptxqdepth
 * 
 * Host Mode Periodic Request Queue Depth (PTxQDepth)
 * 
 * 2'b00: 2
 * 
 * 2'b01: 4
 * 
 * 2'b10: 8
 * 
 * 2'b11:16
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description 
 * :---------------------------------------|:------|:-------------
 *  ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_E_QUE2  | 0x0   | Que Depth 2 
 *  ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_E_QUE4  | 0x1   | Que Depth 4 
 *  ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_E_QUE8  | 0x2   | Que Depth 8 
 *  ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_E_QUE16 | 0x3   | Que Depth 16
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_PTXQDEPTH
 * 
 * Que Depth 2
 */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_E_QUE2   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_PTXQDEPTH
 * 
 * Que Depth 4
 */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_E_QUE4   0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_PTXQDEPTH
 * 
 * Que Depth 8
 */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_E_QUE8   0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_PTXQDEPTH
 * 
 * Que Depth 16
 */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_E_QUE16  0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_PTXQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_PTXQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_MSB        25
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_PTXQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_WIDTH      2
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_PTXQDEPTH register field value. */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_SET_MSK    0x03000000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_PTXQDEPTH register field value. */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_CLR_MSK    0xfcffffff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_PTXQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG2_PTXQDEPTH field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_GET(value) (((value) & 0x03000000) >> 24)
/* Produces a ALT_USB_GLOB_GHWCFG2_PTXQDEPTH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_SET(value) (((value) << 24) & 0x03000000)

/*
 * Field : tknqdepth
 * 
 * Device Mode IN Token Sequence Learning Queue Depth
 * 
 * (TknQDepth)
 * 
 * Range: 0-30
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_TKNQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_TKNQDEPTH_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_TKNQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_TKNQDEPTH_MSB        30
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_TKNQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_TKNQDEPTH_WIDTH      5
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_TKNQDEPTH register field value. */
#define ALT_USB_GLOB_GHWCFG2_TKNQDEPTH_SET_MSK    0x7c000000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_TKNQDEPTH register field value. */
#define ALT_USB_GLOB_GHWCFG2_TKNQDEPTH_CLR_MSK    0x83ffffff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_TKNQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_TKNQDEPTH_RESET      0x8
/* Extracts the ALT_USB_GLOB_GHWCFG2_TKNQDEPTH field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_TKNQDEPTH_GET(value) (((value) & 0x7c000000) >> 26)
/* Produces a ALT_USB_GLOB_GHWCFG2_TKNQDEPTH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_TKNQDEPTH_SET(value) (((value) << 26) & 0x7c000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GHWCFG2.
 */
struct ALT_USB_GLOB_GHWCFG2_s
{
    const uint32_t  otgmode         :  3;  /* ALT_USB_GLOB_GHWCFG2_OTGMOD */
    const uint32_t  otgarch         :  2;  /* ALT_USB_GLOB_GHWCFG2_OTGARCH */
    const uint32_t  singpnt         :  1;  /* ALT_USB_GLOB_GHWCFG2_SINGPNT */
    const uint32_t  hsphytype       :  2;  /* ALT_USB_GLOB_GHWCFG2_HSPHYTYPE */
    const uint32_t  fsphytype       :  2;  /* ALT_USB_GLOB_GHWCFG2_FSPHYTYPE */
    const uint32_t  numdeveps       :  4;  /* ALT_USB_GLOB_GHWCFG2_NUMDEVEPS */
    const uint32_t  numhstchnl      :  4;  /* ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL */
    const uint32_t  periosupport    :  1;  /* ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT */
    const uint32_t  dynfifosizing   :  1;  /* ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING */
    const uint32_t  multiprocintrpt :  1;  /* ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT */
    uint32_t                        :  1;  /* *UNDEFINED* */
    const uint32_t  nptxqdepth      :  2;  /* ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH */
    const uint32_t  ptxqdepth       :  2;  /* ALT_USB_GLOB_GHWCFG2_PTXQDEPTH */
    const uint32_t  tknqdepth       :  5;  /* ALT_USB_GLOB_GHWCFG2_TKNQDEPTH */
    uint32_t                        :  1;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GHWCFG2. */
typedef volatile struct ALT_USB_GLOB_GHWCFG2_s  ALT_USB_GLOB_GHWCFG2_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GHWCFG2 register. */
#define ALT_USB_GLOB_GHWCFG2_RESET       0x208ffc90
/* The byte offset of the ALT_USB_GLOB_GHWCFG2 register from the beginning of the component. */
#define ALT_USB_GLOB_GHWCFG2_OFST        0x48
/* The address of the ALT_USB_GLOB_GHWCFG2 register. */
#define ALT_USB_GLOB_GHWCFG2_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GHWCFG2_OFST))

/*
 * Register : ghwcfg3
 * 
 * User HW Config3 Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                       
 * :--------|:-------|:-------|:-----------------------------------
 *  [3:0]   | R      | 0x8    | ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 *  [6:4]   | R      | 0x6    | ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH 
 *  [7]     | R      | 0x1    | ALT_USB_GLOB_GHWCFG3_OTGEN        
 *  [8]     | R      | 0x0    | ALT_USB_GLOB_GHWCFG3_I2CINTSEL    
 *  [9]     | R      | 0x1    | ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT   
 *  [10]    | R      | 0x0    | ALT_USB_GLOB_GHWCFG3_OPTFEATURE   
 *  [11]    | R      | 0x0    | ALT_USB_GLOB_GHWCFG3_RSTTYPE      
 *  [12]    | R      | 0x0    | ALT_USB_GLOB_GHWCFG3_ADPSUPPORT   
 *  [13]    | R      | 0x0    | ALT_USB_GLOB_GHWCFG3_HSICMOD      
 *  [14]    | R      | 0x0    | ALT_USB_GLOB_GHWCFG3_BCSUPPORT    
 *  [15]    | R      | 0x0    | ALT_USB_GLOB_GHWCFG3_LPMMOD       
 *  [31:16] | R      | 0x1f80 | ALT_USB_GLOB_GHWCFG3_DFIFODEPTH   
 * 
 */
/*
 * Field : xfersizewidth
 * 
 * Width of Transfer Size Counters (XferSizeWidth)
 * 
 * 4'b0000: 11 bits
 * 
 * 4'b0001: 12 bits
 * 
 * ...
 * 
 * 4'b1000: 19 bits
 * 
 * Others: Reserved
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                           
 * :---------------------------------------------|:------|:---------------------------------------
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH11 | 0x0   | Width of Transfer Size Counter 11 bits
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH12 | 0x1   | Width of Transfer Size Counter 12 bits
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH13 | 0x2   | Width of Transfer Size Counter 13 bits
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH14 | 0x3   | Width of Transfer Size Counter 14 bits
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH15 | 0x4   | Width of Transfer Size Counter 15 bits
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH16 | 0x5   | Width of Transfer Size Counter 16 bits
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH17 | 0x6   | Width of Transfer Size Counter 17 bits
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH18 | 0x7   | Width of Transfer Size Counter 18 bits
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH19 | 0x8   | Width of Transfer Size Counter 19 bits
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 11 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH11    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 12 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH12    0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 13 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH13    0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 14 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH14    0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 15 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH15    0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 16 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH16    0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 17 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH17    0x6
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 18 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH18    0x7
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 19 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH19    0x8

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_MSB        3
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH register field value. */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_SET_MSK    0x0000000f
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH register field value. */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_CLR_MSK    0xfffffff0
/* The reset value of the ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_RESET      0x8
/* Extracts the ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_GET(value) (((value) & 0x0000000f) >> 0)
/* Produces a ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_SET(value) (((value) << 0) & 0x0000000f)

/*
 * Field : pktsizewidth
 * 
 * Width of Packet Size Counters (PktSizeWidth)
 * 
 * 3'b000: 4 bits
 * 
 * 3'b001: 5 bits
 * 
 * 3'b010: 6 bits
 * 
 * 3'b011: 7 bits
 * 
 * 3'b100: 8 bits
 * 
 * 3'b101: 9 bits
 * 
 * 3'b110: 10 bits
 * 
 * Others: Reserved
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                    
 * :-------------------------------------------|:------|:--------------------------------
 *  ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS4  | 0x0   | Width of Packet Size Counter 4 
 *  ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS5  | 0x1   | Width of Packet Size Counter 5 
 *  ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS6  | 0x2   | Width of Packet Size Counter 6 
 *  ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS7  | 0x3   | Width of Packet Size Counter 7 
 *  ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS8  | 0x4   | Width of Packet Size Counter 8 
 *  ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS9  | 0x5   | Width of Packet Size Counter 9 
 *  ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS10 | 0x6   | Width of Packet Size Counter 10
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH
 * 
 * Width of Packet Size Counter 4
 */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS4   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH
 * 
 * Width of Packet Size Counter 5
 */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS5   0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH
 * 
 * Width of Packet Size Counter 6
 */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS6   0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH
 * 
 * Width of Packet Size Counter 7
 */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS7   0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH
 * 
 * Width of Packet Size Counter 8
 */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS8   0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH
 * 
 * Width of Packet Size Counter 9
 */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS9   0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH
 * 
 * Width of Packet Size Counter 10
 */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS10  0x6

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_MSB        6
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_WIDTH      3
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH register field value. */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_SET_MSK    0x00000070
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH register field value. */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_CLR_MSK    0xffffff8f
/* The reset value of the ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_RESET      0x6
/* Extracts the ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_GET(value) (((value) & 0x00000070) >> 4)
/* Produces a ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_SET(value) (((value) << 4) & 0x00000070)

/*
 * Field : otgen
 * 
 * OTG Function Enabled (OtgEn)
 * 
 * The application uses this bit to indicate the DWC_otg core's
 * 
 * OTG capabilities.
 * 
 * 1'b0: Not OTG capable
 * 
 * 1'b1: OTG Capable
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description
 * :---------------------------------|:------|:------------
 *  ALT_USB_GLOB_GHWCFG3_OTGEN_E_END | 0x1   | OTG Capable
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_OTGEN
 * 
 * OTG Capable
 */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_OTGEN register field. */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_OTGEN register field. */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_MSB        7
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_OTGEN register field. */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_OTGEN register field value. */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_OTGEN register field value. */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_GLOB_GHWCFG3_OTGEN register field. */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_RESET      0x1
/* Extracts the ALT_USB_GLOB_GHWCFG3_OTGEN field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_GLOB_GHWCFG3_OTGEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : i2cintsel
 * 
 * I2C Selection (I2CIntSel)
 * 
 * 1'b0: I2C Interface is not available on the core.
 * 
 * 1'b1: I2C Interface is available on the core.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description  
 * :--------------------------------------|:------|:--------------
 *  ALT_USB_GLOB_GHWCFG3_I2CINTSEL_E_DISD | 0x0   | I2C Interface
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_I2CINTSEL
 * 
 * I2C Interface
 */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_E_DISD   0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_I2CINTSEL register field. */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_I2CINTSEL register field. */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_MSB        8
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_I2CINTSEL register field. */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_I2CINTSEL register field value. */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_I2CINTSEL register field value. */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_I2CINTSEL register field. */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG3_I2CINTSEL field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_GLOB_GHWCFG3_I2CINTSEL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : vndctlsupt
 * 
 * Vendor Control Interface Support (VndctlSupt)
 * 
 * 1'b0: Vendor Control Interface is not available on the core.
 * 
 * 1'b1: Vendor Control Interface is available.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                     
 * :--------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_E_END | 0x1   | Vendor Control Interface is not available on the
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT
 * 
 * Vendor Control Interface is not available on the
 */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT register field. */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT register field. */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_MSB        9
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT register field. */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT register field value. */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_SET_MSK    0x00000200
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT register field value. */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_CLR_MSK    0xfffffdff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT register field. */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_RESET      0x1
/* Extracts the ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : optfeature
 * 
 * Optional Features Removed (OptFeature)
 * 
 * Indicates whether the User ID register, GPIO interface ports,
 * 
 * and SOF toggle and counter ports were removed For gate count
 * 
 * optimization by enabling Remove Optional Features.
 * 
 * 1'b0: No
 * 
 * 1'b1: Yes
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description         
 * :---------------------------------------|:------|:---------------------
 *  ALT_USB_GLOB_GHWCFG3_OPTFEATURE_E_DISD | 0x0   | No Optional features
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_OPTFEATURE
 * 
 * No Optional features
 */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_E_DISD  0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_OPTFEATURE register field. */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_OPTFEATURE register field. */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_MSB        10
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_OPTFEATURE register field. */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_OPTFEATURE register field value. */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_SET_MSK    0x00000400
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_OPTFEATURE register field value. */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_CLR_MSK    0xfffffbff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_OPTFEATURE register field. */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG3_OPTFEATURE field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_USB_GLOB_GHWCFG3_OPTFEATURE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : rsttype
 * 
 * Reset Style For Clocked always Blocks in RTL (RstType)
 * 
 * 1'b0: Asynchronous reset is used in the core
 * 
 * 1'b1: Synchronous reset is used in the core
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                           
 * :-----------------------------------|:------|:---------------------------------------
 *  ALT_USB_GLOB_GHWCFG3_RSTTYPE_E_END | 0x0   | Asynchronous reset is used in the core
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_RSTTYPE
 * 
 * Asynchronous reset is used in the core
 */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_E_END  0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_RSTTYPE register field. */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_RSTTYPE register field. */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_MSB        11
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_RSTTYPE register field. */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_RSTTYPE register field value. */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_RSTTYPE register field value. */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_RSTTYPE register field. */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG3_RSTTYPE field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_GLOB_GHWCFG3_RSTTYPE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : adpsupport
 * 
 * This bit indicates whether ADP logic is present within or external to the HS OTG
 * 
 * controller
 * 
 * 0: No ADP logic present with HSOTG controller
 * 
 * 1: ADP logic is present along with HSOTG controller.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                     
 * :--------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_E_END | 0x1   | ADP logic is present along with HSOTG controller
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_ADPSUPPORT
 * 
 * ADP logic is present along with HSOTG controller
 */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_ADPSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_ADPSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_MSB        12
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_ADPSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_ADPSUPPORT register field value. */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_SET_MSK    0x00001000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_ADPSUPPORT register field value. */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_CLR_MSK    0xffffefff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_ADPSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG3_ADPSUPPORT field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_USB_GLOB_GHWCFG3_ADPSUPPORT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : hsicmode
 * 
 * HSIC mode specified for Mode of Operation
 * 
 * Value Range: 0 - 1
 * 
 * 1: HSIC-capable with shared UTMI PHY interface
 * 
 * 0: Non-HSIC-capable
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description     
 * :------------------------------------|:------|:-----------------
 *  ALT_USB_GLOB_GHWCFG3_HSICMOD_E_DISD | 0x0   | Non-HSIC-capable
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_HSICMOD
 * 
 * Non-HSIC-capable
 */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_E_DISD 0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_HSICMOD register field. */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_HSICMOD register field. */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_MSB        13
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_HSICMOD register field. */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_HSICMOD register field value. */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_HSICMOD register field value. */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_HSICMOD register field. */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG3_HSICMOD field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_GLOB_GHWCFG3_HSICMOD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : bcsupport
 * 
 * This bit indicates the HS OTG controller support for Battery Charger.
 * 
 * 0 - No Battery Charger Support
 * 
 * 1 - Battery Charger support present.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description               
 * :--------------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GHWCFG3_BCSUPPORT_E_DISD | 0x0   | No Battery Charger Support
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_BCSUPPORT
 * 
 * No Battery Charger Support
 */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_E_DISD   0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_BCSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_BCSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_MSB        14
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_BCSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_BCSUPPORT register field value. */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_SET_MSK    0x00004000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_BCSUPPORT register field value. */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_CLR_MSK    0xffffbfff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_BCSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG3_BCSUPPORT field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_USB_GLOB_GHWCFG3_BCSUPPORT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : lpmmode
 * 
 * LPM mode specified for Mode of Operation.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description 
 * :-----------------------------------|:------|:-------------
 *  ALT_USB_GLOB_GHWCFG3_LPMMOD_E_DISD | 0x0   | LPM disabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_LPMMOD
 * 
 * LPM disabled
 */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_E_DISD  0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_LPMMOD register field. */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_LPMMOD register field. */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_MSB        15
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_LPMMOD register field. */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_LPMMOD register field value. */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_SET_MSK    0x00008000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_LPMMOD register field value. */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_CLR_MSK    0xffff7fff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_LPMMOD register field. */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG3_LPMMOD field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_USB_GLOB_GHWCFG3_LPMMOD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : dfifodepth
 * 
 * DFIFO Depth (DfifoDepth - EP_LOC_CNT)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 32
 * 
 * Maximum value is 32,768
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_DFIFODEPTH register field. */
#define ALT_USB_GLOB_GHWCFG3_DFIFODEPTH_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_DFIFODEPTH register field. */
#define ALT_USB_GLOB_GHWCFG3_DFIFODEPTH_MSB        31
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_DFIFODEPTH register field. */
#define ALT_USB_GLOB_GHWCFG3_DFIFODEPTH_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_DFIFODEPTH register field value. */
#define ALT_USB_GLOB_GHWCFG3_DFIFODEPTH_SET_MSK    0xffff0000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_DFIFODEPTH register field value. */
#define ALT_USB_GLOB_GHWCFG3_DFIFODEPTH_CLR_MSK    0x0000ffff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_DFIFODEPTH register field. */
#define ALT_USB_GLOB_GHWCFG3_DFIFODEPTH_RESET      0x1f80
/* Extracts the ALT_USB_GLOB_GHWCFG3_DFIFODEPTH field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_DFIFODEPTH_GET(value) (((value) & 0xffff0000) >> 16)
/* Produces a ALT_USB_GLOB_GHWCFG3_DFIFODEPTH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_DFIFODEPTH_SET(value) (((value) << 16) & 0xffff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GHWCFG3.
 */
struct ALT_USB_GLOB_GHWCFG3_s
{
    const uint32_t  xfersizewidth :  4;  /* ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH */
    const uint32_t  pktsizewidth  :  3;  /* ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH */
    const uint32_t  otgen         :  1;  /* ALT_USB_GLOB_GHWCFG3_OTGEN */
    const uint32_t  i2cintsel     :  1;  /* ALT_USB_GLOB_GHWCFG3_I2CINTSEL */
    const uint32_t  vndctlsupt    :  1;  /* ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT */
    const uint32_t  optfeature    :  1;  /* ALT_USB_GLOB_GHWCFG3_OPTFEATURE */
    const uint32_t  rsttype       :  1;  /* ALT_USB_GLOB_GHWCFG3_RSTTYPE */
    const uint32_t  adpsupport    :  1;  /* ALT_USB_GLOB_GHWCFG3_ADPSUPPORT */
    const uint32_t  hsicmode      :  1;  /* ALT_USB_GLOB_GHWCFG3_HSICMOD */
    const uint32_t  bcsupport     :  1;  /* ALT_USB_GLOB_GHWCFG3_BCSUPPORT */
    const uint32_t  lpmmode       :  1;  /* ALT_USB_GLOB_GHWCFG3_LPMMOD */
    const uint32_t  dfifodepth    : 16;  /* ALT_USB_GLOB_GHWCFG3_DFIFODEPTH */
};

/* The typedef declaration for register ALT_USB_GLOB_GHWCFG3. */
typedef volatile struct ALT_USB_GLOB_GHWCFG3_s  ALT_USB_GLOB_GHWCFG3_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GHWCFG3 register. */
#define ALT_USB_GLOB_GHWCFG3_RESET       0x1f8002e8
/* The byte offset of the ALT_USB_GLOB_GHWCFG3 register from the beginning of the component. */
#define ALT_USB_GLOB_GHWCFG3_OFST        0x4c
/* The address of the ALT_USB_GLOB_GHWCFG3 register. */
#define ALT_USB_GLOB_GHWCFG3_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GHWCFG3_OFST))

/*
 * Register : ghwcfg4
 * 
 * User HW Config4 Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                             
 * :--------|:-------|:------|:-----------------------------------------
 *  [3:0]   | R      | 0x0   | ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS     
 *  [4]     | R      | 0x0   | ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN       
 *  [5]     | R      | 0x1   | ALT_USB_GLOB_GHWCFG4_AHBFREQ            
 *  [6]     | R      | 0x0   | ALT_USB_GLOB_GHWCFG4_HIBERNATION        
 *  [7]     | R      | 0x0   | ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION
 *  [13:8]  | ???    | 0x0   | *UNDEFINED*                             
 *  [15:14] | R      | 0x0   | ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH       
 *  [19:16] | R      | 0xf   | ALT_USB_GLOB_GHWCFG4_NUMCTLEPS          
 *  [20]    | R      | 0x0   | ALT_USB_GLOB_GHWCFG4_IDDGFLTR           
 *  [21]    | R      | 0x0   | ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR      
 *  [22]    | R      | 0x0   | ALT_USB_GLOB_GHWCFG4_AVALIDFLTR         
 *  [23]    | R      | 0x0   | ALT_USB_GLOB_GHWCFG4_BVALIDFLTR         
 *  [24]    | R      | 0x0   | ALT_USB_GLOB_GHWCFG4_SESSENDFLTR        
 *  [25]    | R      | 0x1   | ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD         
 *  [29:26] | R      | 0xf   | ALT_USB_GLOB_GHWCFG4_INEPS              
 *  [30]    | R      | 0x1   | ALT_USB_GLOB_GHWCFG4_DMA_CFG            
 *  [31]    | R      | 0x1   | ALT_USB_GLOB_GHWCFG4_DMA                
 * 
 */
/*
 * Field : numdevperioeps
 * 
 * Number of Device Mode Periodic IN Endpoints
 * 
 * (NumDevPerioEps)
 * 
 * Range: 0-15
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS_MSB        3
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS register field value. */
#define ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS_SET_MSK    0x0000000f
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS register field value. */
#define ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS_CLR_MSK    0xfffffff0
/* The reset value of the ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS_GET(value) (((value) & 0x0000000f) >> 0)
/* Produces a ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS_SET(value) (((value) << 0) & 0x0000000f)

/*
 * Field : partialpwrdn
 * 
 * Enable Partial Power Down (PartialPwrDn)
 * 
 * 1'b0: Partial Power Down Not Enabled
 * 
 * 1'b1: Partial Power Down Enabled
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                
 * :-----------------------------------------|:------|:----------------------------
 *  ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_E_DISD | 0x0   | Partial Power Down disabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN
 * 
 * Partial Power Down disabled
 */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_E_DISD    0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN register field. */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN register field. */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_MSB        4
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN register field. */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN register field value. */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN register field value. */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN register field. */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : ahbfreq
 * 
 * Minimum AHB Frequency Less Than 60 MHz (AhbFreq)
 * 
 * 1'b0: No
 * 
 * 1'b1: Yes
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                          
 * :-----------------------------------|:------|:--------------------------------------
 *  ALT_USB_GLOB_GHWCFG4_AHBFREQ_E_END | 0x1   | Minimum AHB Frequency Less Than 60 MH
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_AHBFREQ
 * 
 * Minimum AHB Frequency Less Than 60 MH
 */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_AHBFREQ register field. */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_AHBFREQ register field. */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_MSB        5
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_AHBFREQ register field. */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_AHBFREQ register field value. */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_AHBFREQ register field value. */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_GLOB_GHWCFG4_AHBFREQ register field. */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_RESET      0x1
/* Extracts the ALT_USB_GLOB_GHWCFG4_AHBFREQ field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_GLOB_GHWCFG4_AHBFREQ register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : hibernation
 * 
 * Enable Hibernation (Hibernation)
 * 
 * 1'b0: Hibernation feature not enabled
 * 
 * 1'b1: Hibernation feature enabled
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                 
 * :----------------------------------------|:------|:-----------------------------
 *  ALT_USB_GLOB_GHWCFG4_HIBERNATION_E_DISD | 0x0   | Hibernation feature disabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_HIBERNATION
 * 
 * Hibernation feature disabled
 */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_E_DISD 0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_HIBERNATION register field. */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_HIBERNATION register field. */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_MSB        6
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_HIBERNATION register field. */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_HIBERNATION register field value. */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_HIBERNATION register field value. */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_GLOB_GHWCFG4_HIBERNATION register field. */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_HIBERNATION field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_GLOB_GHWCFG4_HIBERNATION register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : extendedhibernation
 * 
 * Enable Hibernation
 * 
 * 1'b0: Extended Hibernation feature not enabled
 * 
 * 1'b1: Extended Hibernation feature enabled
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION register field. */
#define ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION register field. */
#define ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION_MSB        7
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION register field. */
#define ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION register field value. */
#define ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION register field value. */
#define ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION register field. */
#define ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : phydatawidth
 * 
 * UTMI+ PHY/ULPI-to-Internal UTMI+ Wrapper Data Width
 * 
 * (PhyDataWidth)
 * 
 * When a ULPI PHY is used, an internal wrapper converts ULPI to
 * 
 * UTMI+ .
 * 
 * 2'b00: 8 bits
 * 
 * 2'b01: 16 bits
 * 
 * 2'b10: 8/16 bits, software selectable
 * 
 * Others: Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH_MSB        15
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH_WIDTH      2
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH register field value. */
#define ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH_SET_MSK    0x0000c000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH register field value. */
#define ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH_CLR_MSK    0xffff3fff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH_GET(value) (((value) & 0x0000c000) >> 14)
/* Produces a ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH_SET(value) (((value) << 14) & 0x0000c000)

/*
 * Field : numctleps
 * 
 * Number of Device Mode Control Endpoints in Addition to
 * 
 * Endpoint 0 (NumCtlEps)
 * 
 * Range: 0-15
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description  
 * :-----------------------------------------|:------|:--------------
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT0  | 0x0   | End point  0 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT1  | 0x1   | End point  1 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT2  | 0x2   | End point  2 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT3  | 0x3   | End point  3 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT4  | 0x4   | End point  4 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT5  | 0x5   | End point  5 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT6  | 0x6   | End point  6 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT7  | 0x7   | End point  7 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT8  | 0x8   | End point  8 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT9  | 0x9   | End point  9 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT10 | 0xa   | End point  10
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT11 | 0xb   | End point  11
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT12 | 0xc   | End point  12
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT13 | 0xd   | End point  13
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT14 | 0xe   | End point  14
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT15 | 0xf   | End point  15
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  0
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT0     0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  1
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT1     0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  2
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT2     0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  3
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT3     0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  4
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT4     0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  5
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT5     0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  6
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT6     0x6
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  7
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT7     0x7
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  8
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT8     0x8
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  9
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT9     0x9
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  10
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT10    0xa
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  11
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT11    0xb
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  12
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT12    0xc
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  13
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT13    0xd
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  14
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT14    0xe
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  15
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT15    0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_NUMCTLEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_NUMCTLEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_MSB        19
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_NUMCTLEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_NUMCTLEPS register field value. */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_SET_MSK    0x000f0000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_NUMCTLEPS register field value. */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_CLR_MSK    0xfff0ffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_NUMCTLEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_RESET      0xf
/* Extracts the ALT_USB_GLOB_GHWCFG4_NUMCTLEPS field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_GET(value) (((value) & 0x000f0000) >> 16)
/* Produces a ALT_USB_GLOB_GHWCFG4_NUMCTLEPS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_SET(value) (((value) << 16) & 0x000f0000)

/*
 * Field : iddgfltr
 * 
 * IDDIG Filter Enable (IddgFltr)
 * 
 * 1'b0: No filter
 * 
 * 1'b1: Filter
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description          
 * :-------------------------------------|:------|:----------------------
 *  ALT_USB_GLOB_GHWCFG4_IDDGFLTR_E_DISD | 0x0   | Iddig Filter Disabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_IDDGFLTR
 * 
 * Iddig Filter Disabled
 */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_E_DISD    0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_IDDGFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_IDDGFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_MSB        20
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_IDDGFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_IDDGFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_SET_MSK    0x00100000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_IDDGFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_CLR_MSK    0xffefffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_IDDGFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_IDDGFLTR field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_USB_GLOB_GHWCFG4_IDDGFLTR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : vbusvalidfltr
 * 
 * VBUS Valid Filter Enabled (VBusValidFltr)
 * 
 * 1'b0: No filter
 * 
 * 1'b1: Filter
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description               
 * :------------------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_E_DISD | 0x0   | Vbus Valid Filter Disabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR
 * 
 * Vbus Valid Filter Disabled
 */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_E_DISD   0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_MSB        21
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_SET_MSK    0x00200000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_CLR_MSK    0xffdfffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : avalidfltr
 * 
 * a_valid Filter Enabled (AValidFltr)
 * 
 * 1'b0: No filter
 * 
 * 1'b1: Filter
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_E_DISD | 0x0   | No filter  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_AVALIDFLTR
 * 
 * No filter
 */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_E_DISD  0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_AVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_AVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_MSB        22
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_AVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_AVALIDFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_SET_MSK    0x00400000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_AVALIDFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_CLR_MSK    0xffbfffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_AVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_AVALIDFLTR field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_USB_GLOB_GHWCFG4_AVALIDFLTR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : bvalidfltr
 * 
 * b_valid Filter Enabled (BValidFltr)
 * 
 * 1'b0: No filter
 * 
 * 1'b1: Filter
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_E_DISD | 0x0   | No Filter  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_BVALIDFLTR
 * 
 * No Filter
 */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_E_DISD  0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_BVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_BVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_MSB        23
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_BVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_BVALIDFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_SET_MSK    0x00800000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_BVALIDFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_CLR_MSK    0xff7fffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_BVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_BVALIDFLTR field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_USB_GLOB_GHWCFG4_BVALIDFLTR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : sessendfltr
 * 
 * session_end Filter Enabled (SessEndFltr)
 * 
 * 1'b0: No filter
 * 
 * 1'b1: Filter
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_E_DISD | 0x0   | No filter  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_SESSENDFLTR
 * 
 * No filter
 */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_E_DISD 0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_SESSENDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_SESSENDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_MSB        24
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_SESSENDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_SESSENDFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_SET_MSK    0x01000000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_SESSENDFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_CLR_MSK    0xfeffffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_SESSENDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_SESSENDFLTR field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_USB_GLOB_GHWCFG4_SESSENDFLTR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : dedfifomode
 * 
 * Enable Dedicated Transmit FIFO For device IN Endpoints
 * 
 * (DedFifoMode)
 * 
 * 1'b0 : Dedicated Transmit FIFO Operation not enabled.
 * 
 * 1'b1 : Dedicated Transmit FIFO Operation enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                              
 * :--------------------------------------|:------|:------------------------------------------
 *  ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_E_END | 0x1   | Dedicated Transmit FIFO Operation enabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD
 * 
 * Dedicated Transmit FIFO Operation enabled
 */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD register field. */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD register field. */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_MSB        25
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD register field. */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD register field value. */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_SET_MSK    0x02000000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD register field value. */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_CLR_MSK    0xfdffffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD register field. */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_RESET      0x1
/* Extracts the ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : ineps
 * 
 * Number of Device Mode IN Endpoints Including Control
 * 
 * Endpoints (INEps)
 * 
 * Range 0 -15
 * 
 * 0 : 1 IN Endpoint
 * 
 * 1 : 2 IN Endpoints
 * 
 * ....
 * 
 * 15 : 16 IN Endpoints
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description   
 * :-------------------------------------|:------|:---------------
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT1  | 0x0   | In Endpoint 1 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT2  | 0x1   | In Endpoint 2 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT3  | 0x2   | In Endpoint 3 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT4  | 0x3   | In Endpoint 4 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT5  | 0x4   | In Endpoint 5 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT6  | 0x5   | In Endpoint 6 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT7  | 0x6   | In Endpoint 7 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT8  | 0x7   | In Endpoint 8 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT9  | 0x8   | In Endpoint 9 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT10 | 0x9   | In Endpoint 10
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT11 | 0xa   | In Endpoint 11
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT12 | 0xb   | In Endpoint 12
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT13 | 0xc   | In Endpoint 13
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT14 | 0xd   | In Endpoint 14
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT15 | 0xe   | In Endpoint 15
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT16 | 0xf   | In Endpoint 16
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 1
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT1     0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 2
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT2     0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 3
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT3     0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 4
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT4     0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 5
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT5     0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 6
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT6     0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 7
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT7     0x6
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 8
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT8     0x7
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 9
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT9     0x8
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 10
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT10    0x9
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 11
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT11    0xa
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 12
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT12    0xb
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 13
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT13    0xc
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 14
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT14    0xd
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 15
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT15    0xe
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 16
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT16    0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_INEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_INEPS_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_INEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_INEPS_MSB        29
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_INEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_INEPS_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_INEPS register field value. */
#define ALT_USB_GLOB_GHWCFG4_INEPS_SET_MSK    0x3c000000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_INEPS register field value. */
#define ALT_USB_GLOB_GHWCFG4_INEPS_CLR_MSK    0xc3ffffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_INEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_INEPS_RESET      0xf
/* Extracts the ALT_USB_GLOB_GHWCFG4_INEPS field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_INEPS_GET(value) (((value) & 0x3c000000) >> 26)
/* Produces a ALT_USB_GLOB_GHWCFG4_INEPS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_INEPS_SET(value) (((value) << 26) & 0x3c000000)

/*
 * Field : dma_configuration
 * 
 * Scatter/Gather DMA configuration
 * 
 * 1'b0: Non-Scatter/Gather DMA configuration
 * 
 * 1'b1: Scatter/Gather DMA configuration
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                         
 * :------------------------------------------|:------|:-------------------------------------
 *  ALT_USB_GLOB_GHWCFG4_DMA_CFG_E_NONSCATTER | 0x0   | Non-Scatter/Gather DMA configuration
 *  ALT_USB_GLOB_GHWCFG4_DMA_CFG_E_SCATTER    | 0x1   | Scatter/Gather DMA configuration    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_DMA_CFG
 * 
 * Non-Scatter/Gather DMA configuration
 */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_E_NONSCATTER   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_DMA_CFG
 * 
 * Scatter/Gather DMA configuration
 */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_E_SCATTER      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_DMA_CFG register field. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_DMA_CFG register field. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_MSB        30
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_DMA_CFG register field. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_DMA_CFG register field value. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_DMA_CFG register field value. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_DMA_CFG register field. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_RESET      0x1
/* Extracts the ALT_USB_GLOB_GHWCFG4_DMA_CFG field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_GLOB_GHWCFG4_DMA_CFG register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : dma
 * 
 * Scatter/Gather DMA configuration
 * 
 * 1'b0: Non Dynamic configuration
 * 
 * 1'b1: Dynamic configuration
 * 
 * Field Enumeration Values:
 * 
 *  Enum                           | Value | Description          
 * :-------------------------------|:------|:----------------------
 *  ALT_USB_GLOB_GHWCFG4_DMA_E_END | 0x1   | Dynamic configuration
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_DMA
 * 
 * Dynamic configuration
 */
#define ALT_USB_GLOB_GHWCFG4_DMA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_DMA register field. */
#define ALT_USB_GLOB_GHWCFG4_DMA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_DMA register field. */
#define ALT_USB_GLOB_GHWCFG4_DMA_MSB        31
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_DMA register field. */
#define ALT_USB_GLOB_GHWCFG4_DMA_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_DMA register field value. */
#define ALT_USB_GLOB_GHWCFG4_DMA_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_DMA register field value. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_DMA register field. */
#define ALT_USB_GLOB_GHWCFG4_DMA_RESET      0x1
/* Extracts the ALT_USB_GLOB_GHWCFG4_DMA field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_DMA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_GLOB_GHWCFG4_DMA register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_DMA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GHWCFG4.
 */
struct ALT_USB_GLOB_GHWCFG4_s
{
    const uint32_t  numdevperioeps      :  4;  /* ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS */
    const uint32_t  partialpwrdn        :  1;  /* ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN */
    const uint32_t  ahbfreq             :  1;  /* ALT_USB_GLOB_GHWCFG4_AHBFREQ */
    const uint32_t  hibernation         :  1;  /* ALT_USB_GLOB_GHWCFG4_HIBERNATION */
    const uint32_t  extendedhibernation :  1;  /* ALT_USB_GLOB_GHWCFG4_EXTENDEDHIBERNATION */
    uint32_t                            :  6;  /* *UNDEFINED* */
    const uint32_t  phydatawidth        :  2;  /* ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH */
    const uint32_t  numctleps           :  4;  /* ALT_USB_GLOB_GHWCFG4_NUMCTLEPS */
    const uint32_t  iddgfltr            :  1;  /* ALT_USB_GLOB_GHWCFG4_IDDGFLTR */
    const uint32_t  vbusvalidfltr       :  1;  /* ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR */
    const uint32_t  avalidfltr          :  1;  /* ALT_USB_GLOB_GHWCFG4_AVALIDFLTR */
    const uint32_t  bvalidfltr          :  1;  /* ALT_USB_GLOB_GHWCFG4_BVALIDFLTR */
    const uint32_t  sessendfltr         :  1;  /* ALT_USB_GLOB_GHWCFG4_SESSENDFLTR */
    const uint32_t  dedfifomode         :  1;  /* ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD */
    const uint32_t  ineps               :  4;  /* ALT_USB_GLOB_GHWCFG4_INEPS */
    const uint32_t  dma_configuration   :  1;  /* ALT_USB_GLOB_GHWCFG4_DMA_CFG */
    const uint32_t  dma                 :  1;  /* ALT_USB_GLOB_GHWCFG4_DMA */
};

/* The typedef declaration for register ALT_USB_GLOB_GHWCFG4. */
typedef volatile struct ALT_USB_GLOB_GHWCFG4_s  ALT_USB_GLOB_GHWCFG4_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GHWCFG4 register. */
#define ALT_USB_GLOB_GHWCFG4_RESET       0xfe0f0020
/* The byte offset of the ALT_USB_GLOB_GHWCFG4 register from the beginning of the component. */
#define ALT_USB_GLOB_GHWCFG4_OFST        0x50
/* The address of the ALT_USB_GLOB_GHWCFG4 register. */
#define ALT_USB_GLOB_GHWCFG4_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GHWCFG4_OFST))

/*
 * Register : gdfifocfg
 * 
 * Global DFIFO Configuration Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                          
 * :--------|:-------|:-------|:--------------------------------------
 *  [15:0]  | RW     | 0x2000 | ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG     
 *  [31:16] | RW     | 0x1f80 | ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR
 * 
 */
/*
 * Field : gdfifocfg
 * 
 * GDFIFOCfg
 * 
 * This field is for dynamic programming of the DFIFO Size. This value takes effect
 * 
 * only when the application programs a non zero value to this register. The
 * 
 * value programmed must conform to the guidelines described in 'FIFO RAM
 * 
 * Allocation'. The DWC_otg core does not have any corrective logic
 * 
 * if the FIFO sizes are programmed incorrectly.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG register field. */
#define ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG register field. */
#define ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG_MSB        15
/* The width in bits of the ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG register field. */
#define ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG register field value. */
#define ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG register field value. */
#define ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG register field. */
#define ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG_RESET      0x2000
/* Extracts the ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG field value from a register. */
#define ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG register field value suitable for setting the register. */
#define ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : epinfobaseaddr
 * 
 * EPInfoBaseAddr
 * 
 * This field provides the start address of the EP info controller.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR register field. */
#define ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR register field. */
#define ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR_MSB        31
/* The width in bits of the ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR register field. */
#define ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR register field value. */
#define ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR_SET_MSK    0xffff0000
/* The mask used to clear the ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR register field value. */
#define ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR_CLR_MSK    0x0000ffff
/* The reset value of the ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR register field. */
#define ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR_RESET      0x1f80
/* Extracts the ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR field value from a register. */
#define ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR_GET(value) (((value) & 0xffff0000) >> 16)
/* Produces a ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR_SET(value) (((value) << 16) & 0xffff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GDFIFOCFG.
 */
struct ALT_USB_GLOB_GDFIFOCFG_s
{
    uint32_t  gdfifocfg      : 16;  /* ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG */
    uint32_t  epinfobaseaddr : 16;  /* ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR */
};

/* The typedef declaration for register ALT_USB_GLOB_GDFIFOCFG. */
typedef volatile struct ALT_USB_GLOB_GDFIFOCFG_s  ALT_USB_GLOB_GDFIFOCFG_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_GDFIFOCFG register. */
#define ALT_USB_GLOB_GDFIFOCFG_RESET       0x1f802000
/* The byte offset of the ALT_USB_GLOB_GDFIFOCFG register from the beginning of the component. */
#define ALT_USB_GLOB_GDFIFOCFG_OFST        0x5c
/* The address of the ALT_USB_GLOB_GDFIFOCFG register. */
#define ALT_USB_GLOB_GDFIFOCFG_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GDFIFOCFG_OFST))

/*
 * Register : hptxfsiz
 * 
 * Host Periodic Transmit FIFO Size Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                     
 * :--------|:-------|:-------|:---------------------------------
 *  [14:0]  | RW     | 0x4000 | ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR
 *  [15]    | ???    | 0x0    | *UNDEFINED*                     
 *  [29:16] | RW     | 0x2000 | ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE  
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                     
 * 
 */
/*
 * Field : ptxfstaddr
 * 
 * Host Periodic TxFIFO Start Address (PTxFStAddr)
 * 
 * The power-on reset value of this register is the sum of the Largest Rx Data
 * 
 * FIFO Depth and Largest Non-periodic Tx Data FIFO Depth
 * 
 * Programmed values must not exceed the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR register field. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR register field. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR_MSB        14
/* The width in bits of the ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR register field. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR_WIDTH      15
/* The mask used to set the ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR register field value. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR_SET_MSK    0x00007fff
/* The mask used to clear the ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR register field value. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR_CLR_MSK    0xffff8000
/* The reset value of the ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR register field. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR_RESET      0x4000
/* Extracts the ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR_GET(value) (((value) & 0x00007fff) >> 0)
/* Produces a ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR_SET(value) (((value) << 0) & 0x00007fff)

/*
 * Field : ptxfsize
 * 
 * Host Periodic TxFIFO Depth (PTxFSize)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the Largest Host
 * 
 * Mode Periodic Tx Data FIFO Depth.
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE register field. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE register field. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE_MSB        29
/* The width in bits of the ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE register field. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE register field value. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE register field value. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE register field. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE_RESET      0x2000
/* Extracts the ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE field value from a register. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE register field value suitable for setting the register. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_HPTXFSIZ.
 */
struct ALT_USB_GLOB_HPTXFSIZ_s
{
    uint32_t  ptxfstaddr : 15;  /* ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR */
    uint32_t             :  1;  /* *UNDEFINED* */
    uint32_t  ptxfsize   : 14;  /* ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE */
    uint32_t             :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_HPTXFSIZ. */
typedef volatile struct ALT_USB_GLOB_HPTXFSIZ_s  ALT_USB_GLOB_HPTXFSIZ_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_HPTXFSIZ register. */
#define ALT_USB_GLOB_HPTXFSIZ_RESET       0x20004000
/* The byte offset of the ALT_USB_GLOB_HPTXFSIZ register from the beginning of the component. */
#define ALT_USB_GLOB_HPTXFSIZ_OFST        0x100
/* The address of the ALT_USB_GLOB_HPTXFSIZ register. */
#define ALT_USB_GLOB_HPTXFSIZ_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_HPTXFSIZ_OFST))

/*
 * Register : dieptxf1
 * 
 * Device IN Endpoint Transmit FIFO Size Register 1
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                         
 * :--------|:-------|:-------|:-------------------------------------
 *  [14:0]  | RW     | 0x4000 | ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR
 *  [15]    | ???    | 0x0    | *UNDEFINED*                         
 *  [29:16] | RW     | 0x2000 | ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP   
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                         
 * 
 */
/*
 * Field : inepntxfstaddr
 * 
 * IN Endpoint FIFOn Transmit RAM Start Address
 * 
 * (INEPnTxFStAddr)
 * 
 * This field contains the memory start address For IN endpoint
 * 
 * Transmit FIFOn (0<n< = 15).
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest Rx Data FIFO Depth
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR_MSB        14
/* The width in bits of the ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR_WIDTH      15
/* The mask used to set the ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR_SET_MSK    0x00007fff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR_CLR_MSK    0xffff8000
/* The reset value of the ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR_RESET      0x4000
/* Extracts the ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR_GET(value) (((value) & 0x00007fff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x00007fff)

/*
 * Field : inepntxfdep
 * 
 * IN Endpoint TxFIFO Depth (INEPnTxFDep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest IN Endpoint FIFO number Depth
 * 
 * Programmed values must not exceed the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF1.
 */
struct ALT_USB_GLOB_DIEPTXF1_s
{
    uint32_t  inepntxfstaddr : 15;  /* ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR */
    uint32_t                 :  1;  /* *UNDEFINED* */
    uint32_t  inepntxfdep    : 14;  /* ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF1. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF1_s  ALT_USB_GLOB_DIEPTXF1_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_DIEPTXF1 register. */
#define ALT_USB_GLOB_DIEPTXF1_RESET       0x20004000
/* The byte offset of the ALT_USB_GLOB_DIEPTXF1 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF1_OFST        0x104
/* The address of the ALT_USB_GLOB_DIEPTXF1 register. */
#define ALT_USB_GLOB_DIEPTXF1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF1_OFST))

/*
 * Register : dieptxf2
 * 
 * Device IN Endpoint Transmit FIFO Size Register 2
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                         
 * :--------|:-------|:-------|:-------------------------------------
 *  [14:0]  | RW     | 0x6000 | ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR
 *  [15]    | ???    | 0x0    | *UNDEFINED*                         
 *  [29:16] | RW     | 0x2000 | ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP   
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                         
 * 
 */
/*
 * Field : inepntxfstaddr
 * 
 * IN Endpoint FIFOn Transmit RAM Start Address
 * 
 * (INEPnTxFStAddr)
 * 
 * This field contains the memory start address For IN endpoint
 * 
 * Transmit FIFOn (0<n< = 15).
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest Rx Data FIFO Depth
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR_MSB        14
/* The width in bits of the ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR_WIDTH      15
/* The mask used to set the ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR_SET_MSK    0x00007fff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR_CLR_MSK    0xffff8000
/* The reset value of the ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR_RESET      0x6000
/* Extracts the ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR_GET(value) (((value) & 0x00007fff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x00007fff)

/*
 * Field : inepntxfdep
 * 
 * IN Endpoint TxFIFO Depth (INEPnTxFDep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest IN Endpoint FIFO number Depth
 * 
 * Programmed values must not exceed the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF2.
 */
struct ALT_USB_GLOB_DIEPTXF2_s
{
    uint32_t  inepntxfstaddr : 15;  /* ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR */
    uint32_t                 :  1;  /* *UNDEFINED* */
    uint32_t  inepntxfdep    : 14;  /* ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF2. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF2_s  ALT_USB_GLOB_DIEPTXF2_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_DIEPTXF2 register. */
#define ALT_USB_GLOB_DIEPTXF2_RESET       0x20006000
/* The byte offset of the ALT_USB_GLOB_DIEPTXF2 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF2_OFST        0x108
/* The address of the ALT_USB_GLOB_DIEPTXF2 register. */
#define ALT_USB_GLOB_DIEPTXF2_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF2_OFST))

/*
 * Register : dieptxf3
 * 
 * Device IN Endpoint Transmit FIFO Size Register 3
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                         
 * :--------|:-------|:-------|:-------------------------------------
 *  [15:0]  | RW     | 0x8000 | ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR
 *  [29:16] | RW     | 0x2000 | ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP   
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                         
 * 
 */
/*
 * Field : inepntxfstaddr
 * 
 * IN Endpoint FIFOn Transmit RAM Start Address
 * 
 * (INEPnTxFStAddr)
 * 
 * This field contains the memory start address For IN endpoint
 * 
 * Transmit FIFOn (0<n< = 15).
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest Rx Data FIFO Depth
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR_RESET      0x8000
/* Extracts the ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : inepntxfdep
 * 
 * IN Endpoint TxFIFO Depth (INEPnTxFDep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest IN Endpoint FIFO number Depth
 * 
 * Programmed values must not exceed the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF3.
 */
struct ALT_USB_GLOB_DIEPTXF3_s
{
    uint32_t  inepntxfstaddr : 16;  /* ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR */
    uint32_t  inepntxfdep    : 14;  /* ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF3. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF3_s  ALT_USB_GLOB_DIEPTXF3_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_DIEPTXF3 register. */
#define ALT_USB_GLOB_DIEPTXF3_RESET       0x20008000
/* The byte offset of the ALT_USB_GLOB_DIEPTXF3 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF3_OFST        0x10c
/* The address of the ALT_USB_GLOB_DIEPTXF3 register. */
#define ALT_USB_GLOB_DIEPTXF3_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF3_OFST))

/*
 * Register : dieptxf4
 * 
 * Device IN Endpoint Transmit FIFO Size Register 4
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                         
 * :--------|:-------|:-------|:-------------------------------------
 *  [15:0]  | RW     | 0xa000 | ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR
 *  [29:16] | RW     | 0x2000 | ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP   
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                         
 * 
 */
/*
 * Field : inepntxfstaddr
 * 
 * IN Endpoint FIFOn Transmit RAM Start Address
 * 
 * (INEPnTxFStAddr)
 * 
 * This field contains the memory start address For IN endpoint
 * 
 * Transmit FIFOn (0<n< = 15).
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest Rx Data FIFO Depth
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR_RESET      0xa000
/* Extracts the ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : inepntxfdep
 * 
 * IN Endpoint TxFIFO Depth (INEPnTxFDep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest IN Endpoint FIFO number Depth
 * 
 * Programmed values must not exceed the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF4.
 */
struct ALT_USB_GLOB_DIEPTXF4_s
{
    uint32_t  inepntxfstaddr : 16;  /* ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR */
    uint32_t  inepntxfdep    : 14;  /* ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF4. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF4_s  ALT_USB_GLOB_DIEPTXF4_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_DIEPTXF4 register. */
#define ALT_USB_GLOB_DIEPTXF4_RESET       0x2000a000
/* The byte offset of the ALT_USB_GLOB_DIEPTXF4 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF4_OFST        0x110
/* The address of the ALT_USB_GLOB_DIEPTXF4 register. */
#define ALT_USB_GLOB_DIEPTXF4_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF4_OFST))

/*
 * Register : dieptxf5
 * 
 * Device IN Endpoint Transmit FIFO Size Register 5
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                         
 * :--------|:-------|:-------|:-------------------------------------
 *  [15:0]  | RW     | 0xc000 | ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR
 *  [29:16] | RW     | 0x2000 | ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP   
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                         
 * 
 */
/*
 * Field : inepntxfstaddr
 * 
 * IN Endpoint FIFOn Transmit RAM Start Address
 * 
 * (INEPnTxFStAddr)
 * 
 * This field contains the memory start address For IN endpoint
 * 
 * Transmit FIFOn (0<n< = 15).
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest Rx Data FIFO Depth
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR_RESET      0xc000
/* Extracts the ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : inepntxfdep
 * 
 * IN Endpoint TxFIFO Depth (INEPnTxFDep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest IN Endpoint FIFO number Depth
 * 
 * Programmed values must not exceed the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF5.
 */
struct ALT_USB_GLOB_DIEPTXF5_s
{
    uint32_t  inepntxfstaddr : 16;  /* ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR */
    uint32_t  inepntxfdep    : 14;  /* ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF5. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF5_s  ALT_USB_GLOB_DIEPTXF5_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_DIEPTXF5 register. */
#define ALT_USB_GLOB_DIEPTXF5_RESET       0x2000c000
/* The byte offset of the ALT_USB_GLOB_DIEPTXF5 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF5_OFST        0x114
/* The address of the ALT_USB_GLOB_DIEPTXF5 register. */
#define ALT_USB_GLOB_DIEPTXF5_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF5_OFST))

/*
 * Register : dieptxf6
 * 
 * Device IN Endpoint Transmit FIFO Size Register 6
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                         
 * :--------|:-------|:-------|:-------------------------------------
 *  [15:0]  | RW     | 0xe000 | ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR
 *  [29:16] | RW     | 0x2000 | ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP   
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                         
 * 
 */
/*
 * Field : inepntxfstaddr
 * 
 * IN Endpoint FIFOn Transmit RAM Start Address
 * 
 * (INEPnTxFStAddr)
 * 
 * This field contains the memory start address For IN endpoint
 * 
 * Transmit FIFOn (0<n< = 15).
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest Rx Data FIFO Depth
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR_RESET      0xe000
/* Extracts the ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : inepntxfdep
 * 
 * IN Endpoint TxFIFO Depth (INEPnTxFDep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest IN Endpoint FIFO number Depth
 * 
 * Programmed values must not exceed the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF6.
 */
struct ALT_USB_GLOB_DIEPTXF6_s
{
    uint32_t  inepntxfstaddr : 16;  /* ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR */
    uint32_t  inepntxfdep    : 14;  /* ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF6. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF6_s  ALT_USB_GLOB_DIEPTXF6_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_DIEPTXF6 register. */
#define ALT_USB_GLOB_DIEPTXF6_RESET       0x2000e000
/* The byte offset of the ALT_USB_GLOB_DIEPTXF6 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF6_OFST        0x118
/* The address of the ALT_USB_GLOB_DIEPTXF6 register. */
#define ALT_USB_GLOB_DIEPTXF6_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF6_OFST))

/*
 * Register : dieptxf7
 * 
 * Device IN Endpoint Transmit FIFO Size Register 7
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                         
 * :--------|:-------|:-------|:-------------------------------------
 *  [15:0]  | RW     | 0x0    | ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR
 *  [29:16] | RW     | 0x2000 | ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP   
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                         
 * 
 */
/*
 * Field : inepntxfstaddr
 * 
 * IN Endpoint FIFOn Transmit RAM Start Address
 * 
 * (INEPnTxFStAddr)
 * 
 * This field contains the memory start address For IN endpoint
 * 
 * Transmit FIFOn (0<n< = 15).
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest Rx Data FIFO Depth
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR_RESET      0x0
/* Extracts the ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : inepntxfdep
 * 
 * IN Endpoint TxFIFO Depth (INEPnTxFDep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest IN Endpoint FIFO number Depth
 * 
 * Programmed values must not exceed the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF7.
 */
struct ALT_USB_GLOB_DIEPTXF7_s
{
    uint32_t  inepntxfstaddr : 16;  /* ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR */
    uint32_t  inepntxfdep    : 14;  /* ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF7. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF7_s  ALT_USB_GLOB_DIEPTXF7_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_DIEPTXF7 register. */
#define ALT_USB_GLOB_DIEPTXF7_RESET       0x20000000
/* The byte offset of the ALT_USB_GLOB_DIEPTXF7 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF7_OFST        0x11c
/* The address of the ALT_USB_GLOB_DIEPTXF7 register. */
#define ALT_USB_GLOB_DIEPTXF7_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF7_OFST))

/*
 * Register : dieptxf8
 * 
 * Device IN Endpoint Transmit FIFO Size Register 8
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                         
 * :--------|:-------|:-------|:-------------------------------------
 *  [15:0]  | RW     | 0x2000 | ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR
 *  [29:16] | RW     | 0x2000 | ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP   
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                         
 * 
 */
/*
 * Field : inepntxfstaddr
 * 
 * IN Endpoint FIFOn Transmit RAM Start Address
 * 
 * (INEPnTxFStAddr)
 * 
 * This field contains the memory start address For IN endpoint
 * 
 * Transmit FIFOn (0<n< = 15).
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest Rx Data FIFO Depth
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : inepntxfdep
 * 
 * IN Endpoint TxFIFO Depth (INEPnTxFDep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest IN Endpoint FIFO number Depth
 * 
 * Programmed values must not exceed the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF8.
 */
struct ALT_USB_GLOB_DIEPTXF8_s
{
    uint32_t  inepntxfstaddr : 16;  /* ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR */
    uint32_t  inepntxfdep    : 14;  /* ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF8. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF8_s  ALT_USB_GLOB_DIEPTXF8_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_DIEPTXF8 register. */
#define ALT_USB_GLOB_DIEPTXF8_RESET       0x20002000
/* The byte offset of the ALT_USB_GLOB_DIEPTXF8 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF8_OFST        0x120
/* The address of the ALT_USB_GLOB_DIEPTXF8 register. */
#define ALT_USB_GLOB_DIEPTXF8_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF8_OFST))

/*
 * Register : dieptxf9
 * 
 * Device IN Endpoint Transmit FIFO Size Register 9
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                         
 * :--------|:-------|:-------|:-------------------------------------
 *  [15:0]  | RW     | 0x4000 | ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR
 *  [29:16] | RW     | 0x2000 | ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP   
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                         
 * 
 */
/*
 * Field : inepntxfstaddr
 * 
 * IN Endpoint FIFOn Transmit RAM Start Address
 * 
 * (INEPnTxFStAddr)
 * 
 * This field contains the memory start address For IN endpoint
 * 
 * Transmit FIFOn (0<n< = 15).
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest Rx Data FIFO Depth
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR_RESET      0x4000
/* Extracts the ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : inepntxfdep
 * 
 * IN Endpoint TxFIFO Depth (INEPnTxFDep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest IN Endpoint FIFO number Depth
 * 
 * Programmed values must not exceed the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF9.
 */
struct ALT_USB_GLOB_DIEPTXF9_s
{
    uint32_t  inepntxfstaddr : 16;  /* ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR */
    uint32_t  inepntxfdep    : 14;  /* ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF9. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF9_s  ALT_USB_GLOB_DIEPTXF9_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_DIEPTXF9 register. */
#define ALT_USB_GLOB_DIEPTXF9_RESET       0x20004000
/* The byte offset of the ALT_USB_GLOB_DIEPTXF9 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF9_OFST        0x124
/* The address of the ALT_USB_GLOB_DIEPTXF9 register. */
#define ALT_USB_GLOB_DIEPTXF9_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF9_OFST))

/*
 * Register : dieptxf10
 * 
 * Device IN Endpoint Transmit FIFO Size Register 10
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                          
 * :--------|:-------|:-------|:--------------------------------------
 *  [15:0]  | RW     | 0x6000 | ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR
 *  [29:16] | RW     | 0x2000 | ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP   
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                          
 * 
 */
/*
 * Field : inepntxfstaddr
 * 
 * IN Endpoint FIFOn Transmit RAM Start Address
 * 
 * (INEPnTxFStAddr)
 * 
 * This field contains the memory start address For IN endpoint
 * 
 * Transmit FIFOn (0<n< = 15).
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest Rx Data FIFO Depth
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR_RESET      0x6000
/* Extracts the ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : inepntxfdep
 * 
 * IN Endpoint TxFIFO Depth (INEPnTxFDep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest IN Endpoint FIFO number Depth
 * 
 * Programmed values must not exceed the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF10.
 */
struct ALT_USB_GLOB_DIEPTXF10_s
{
    uint32_t  inepntxfstaddr : 16;  /* ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR */
    uint32_t  inepntxfdep    : 14;  /* ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF10. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF10_s  ALT_USB_GLOB_DIEPTXF10_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_DIEPTXF10 register. */
#define ALT_USB_GLOB_DIEPTXF10_RESET       0x20006000
/* The byte offset of the ALT_USB_GLOB_DIEPTXF10 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF10_OFST        0x128
/* The address of the ALT_USB_GLOB_DIEPTXF10 register. */
#define ALT_USB_GLOB_DIEPTXF10_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF10_OFST))

/*
 * Register : dieptxf11
 * 
 * Device IN Endpoint Transmit FIFO Size Register 11
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                          
 * :--------|:-------|:-------|:--------------------------------------
 *  [15:0]  | RW     | 0x8000 | ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR
 *  [29:16] | RW     | 0x2000 | ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP   
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                          
 * 
 */
/*
 * Field : inepntxfstaddr
 * 
 * IN Endpoint FIFOn Transmit RAM Start Address
 * 
 * (INEPnTxFStAddr)
 * 
 * This field contains the memory start address For IN endpoint
 * 
 * Transmit FIFOn (0<n< = 15).
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest Rx Data FIFO Depth
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR_RESET      0x8000
/* Extracts the ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : inepntxfdep
 * 
 * IN Endpoint TxFIFO Depth (INEPnTxFDep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest IN Endpoint FIFO number Depth
 * 
 * Programmed values must not exceed the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF11.
 */
struct ALT_USB_GLOB_DIEPTXF11_s
{
    uint32_t  inepntxfstaddr : 16;  /* ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR */
    uint32_t  inepntxfdep    : 14;  /* ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF11. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF11_s  ALT_USB_GLOB_DIEPTXF11_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_DIEPTXF11 register. */
#define ALT_USB_GLOB_DIEPTXF11_RESET       0x20008000
/* The byte offset of the ALT_USB_GLOB_DIEPTXF11 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF11_OFST        0x12c
/* The address of the ALT_USB_GLOB_DIEPTXF11 register. */
#define ALT_USB_GLOB_DIEPTXF11_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF11_OFST))

/*
 * Register : dieptxf12
 * 
 * Device IN Endpoint Transmit FIFO Size Register 12
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                          
 * :--------|:-------|:-------|:--------------------------------------
 *  [15:0]  | RW     | 0xa000 | ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR
 *  [29:16] | RW     | 0x2000 | ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP   
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                          
 * 
 */
/*
 * Field : inepntxfstaddr
 * 
 * IN Endpoint FIFOn Transmit RAM Start Address
 * 
 * (INEPnTxFStAddr)
 * 
 * This field contains the memory start address For IN endpoint
 * 
 * Transmit FIFOn (0<n< = 15).
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest Rx Data FIFO Depth
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR_RESET      0xa000
/* Extracts the ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : inepntxfdep
 * 
 * IN Endpoint TxFIFO Depth (INEPnTxFDep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest IN Endpoint FIFO number Depth
 * 
 * Programmed values must not exceed the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF12.
 */
struct ALT_USB_GLOB_DIEPTXF12_s
{
    uint32_t  inepntxfstaddr : 16;  /* ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR */
    uint32_t  inepntxfdep    : 14;  /* ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF12. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF12_s  ALT_USB_GLOB_DIEPTXF12_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_DIEPTXF12 register. */
#define ALT_USB_GLOB_DIEPTXF12_RESET       0x2000a000
/* The byte offset of the ALT_USB_GLOB_DIEPTXF12 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF12_OFST        0x130
/* The address of the ALT_USB_GLOB_DIEPTXF12 register. */
#define ALT_USB_GLOB_DIEPTXF12_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF12_OFST))

/*
 * Register : dieptxf13
 * 
 * Device IN Endpoint Transmit FIFO Size Register 13
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                          
 * :--------|:-------|:-------|:--------------------------------------
 *  [15:0]  | RW     | 0xc000 | ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR
 *  [29:16] | RW     | 0x2000 | ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP   
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                          
 * 
 */
/*
 * Field : inepntxfstaddr
 * 
 * IN Endpoint FIFOn Transmit RAM Start Address
 * 
 * (INEPnTxFStAddr)
 * 
 * This field contains the memory start address For IN endpoint
 * 
 * Transmit FIFOn (0<n< = 15).
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest Rx Data FIFO Depth
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR_RESET      0xc000
/* Extracts the ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : inepntxfdep
 * 
 * IN Endpoint TxFIFO Depth (INEPnTxFDep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest IN Endpoint FIFO number Depth
 * 
 * Programmed values must not exceed the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF13.
 */
struct ALT_USB_GLOB_DIEPTXF13_s
{
    uint32_t  inepntxfstaddr : 16;  /* ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR */
    uint32_t  inepntxfdep    : 14;  /* ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF13. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF13_s  ALT_USB_GLOB_DIEPTXF13_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_DIEPTXF13 register. */
#define ALT_USB_GLOB_DIEPTXF13_RESET       0x2000c000
/* The byte offset of the ALT_USB_GLOB_DIEPTXF13 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF13_OFST        0x134
/* The address of the ALT_USB_GLOB_DIEPTXF13 register. */
#define ALT_USB_GLOB_DIEPTXF13_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF13_OFST))

/*
 * Register : dieptxf14
 * 
 * Device IN Endpoint Transmit FIFO Size Register 14
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                          
 * :--------|:-------|:-------|:--------------------------------------
 *  [15:0]  | RW     | 0xe000 | ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR
 *  [29:16] | RW     | 0x2000 | ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP   
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                          
 * 
 */
/*
 * Field : inepntxfstaddr
 * 
 * IN Endpoint FIFOn Transmit RAM Start Address
 * 
 * (INEPnTxFStAddr)
 * 
 * This field contains the memory start address For IN endpoint
 * 
 * Transmit FIFOn (0<n< = 15).
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest Rx Data FIFO Depth
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR_RESET      0xe000
/* Extracts the ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : inepntxfdep
 * 
 * IN Endpoint TxFIFO Depth (INEPnTxFDep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest IN Endpoint FIFO number Depth
 * 
 * Programmed values must not exceed the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF14.
 */
struct ALT_USB_GLOB_DIEPTXF14_s
{
    uint32_t  inepntxfstaddr : 16;  /* ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR */
    uint32_t  inepntxfdep    : 14;  /* ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF14. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF14_s  ALT_USB_GLOB_DIEPTXF14_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_DIEPTXF14 register. */
#define ALT_USB_GLOB_DIEPTXF14_RESET       0x2000e000
/* The byte offset of the ALT_USB_GLOB_DIEPTXF14 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF14_OFST        0x138
/* The address of the ALT_USB_GLOB_DIEPTXF14 register. */
#define ALT_USB_GLOB_DIEPTXF14_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF14_OFST))

/*
 * Register : dieptxf15
 * 
 * Device IN Endpoint Transmit FIFO Size Register 15
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                          
 * :--------|:-------|:-------|:--------------------------------------
 *  [15:0]  | RW     | 0x0    | ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR
 *  [29:16] | RW     | 0x2000 | ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP   
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                          
 * 
 */
/*
 * Field : inepntxfstaddr
 * 
 * IN Endpoint FIFOn Transmit RAM Start Address
 * 
 * (INEPnTxFStAddr)
 * 
 * This field contains the memory start address For IN endpoint
 * 
 * Transmit FIFOn (0<n< = 15).
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest Rx Data FIFO Depth
 * 
 * Programmed values must not exceed the power-on value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR_RESET      0x0
/* Extracts the ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : inepntxfdep
 * 
 * IN Endpoint TxFIFO Depth (INEPnTxFDep)
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 32,768
 * 
 * The power-on reset value of this register is specified as the
 * 
 * Largest IN Endpoint FIFO number Depth
 * 
 * Programmed values must not exceed the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF15.
 */
struct ALT_USB_GLOB_DIEPTXF15_s
{
    uint32_t  inepntxfstaddr : 16;  /* ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR */
    uint32_t  inepntxfdep    : 14;  /* ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF15. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF15_s  ALT_USB_GLOB_DIEPTXF15_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_GLOB_DIEPTXF15 register. */
#define ALT_USB_GLOB_DIEPTXF15_RESET       0x20000000
/* The byte offset of the ALT_USB_GLOB_DIEPTXF15 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF15_OFST        0x13c
/* The address of the ALT_USB_GLOB_DIEPTXF15 register. */
#define ALT_USB_GLOB_DIEPTXF15_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF15_OFST))

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register group ALT_USB_GLOB.
 */
struct ALT_USB_GLOB_s
{
    ALT_USB_GLOB_GOTGCTL_t    gotgctl;             /* ALT_USB_GLOB_GOTGCTL */
    ALT_USB_GLOB_GOTGINT_t    gotgint;             /* ALT_USB_GLOB_GOTGINT */
    ALT_USB_GLOB_GAHBCFG_t    gahbcfg;             /* ALT_USB_GLOB_GAHBCFG */
    ALT_USB_GLOB_GUSBCFG_t    gusbcfg;             /* ALT_USB_GLOB_GUSBCFG */
    ALT_USB_GLOB_GRSTCTL_t    grstctl;             /* ALT_USB_GLOB_GRSTCTL */
    ALT_USB_GLOB_GINTSTS_t    gintsts;             /* ALT_USB_GLOB_GINTSTS */
    ALT_USB_GLOB_GINTMSK_t    gintmsk;             /* ALT_USB_GLOB_GINTMSK */
    ALT_USB_GLOB_GRXSTSR_t    grxstsr;             /* ALT_USB_GLOB_GRXSTSR */
    ALT_USB_GLOB_GRXSTSP_t    grxstsp;             /* ALT_USB_GLOB_GRXSTSP */
    ALT_USB_GLOB_GRXFSIZ_t    grxfsiz;             /* ALT_USB_GLOB_GRXFSIZ */
    ALT_USB_GLOB_GNPTXFSIZ_t  gnptxfsiz;           /* ALT_USB_GLOB_GNPTXFSIZ */
    ALT_USB_GLOB_GNPTXSTS_t   gnptxsts;            /* ALT_USB_GLOB_GNPTXSTS */
    volatile uint32_t         _pad_0x30_0x33;      /* *UNDEFINED* */
    ALT_USB_GLOB_GPVNDCTL_t   gpvndctl;            /* ALT_USB_GLOB_GPVNDCTL */
    ALT_USB_GLOB_GGPIO_t      ggpio;               /* ALT_USB_GLOB_GGPIO */
    ALT_USB_GLOB_GUID_t       guid;                /* ALT_USB_GLOB_GUID */
    ALT_USB_GLOB_GSNPSID_t    gsnpsid;             /* ALT_USB_GLOB_GSNPSID */
    ALT_USB_GLOB_GHWCFG1_t    ghwcfg1;             /* ALT_USB_GLOB_GHWCFG1 */
    ALT_USB_GLOB_GHWCFG2_t    ghwcfg2;             /* ALT_USB_GLOB_GHWCFG2 */
    ALT_USB_GLOB_GHWCFG3_t    ghwcfg3;             /* ALT_USB_GLOB_GHWCFG3 */
    ALT_USB_GLOB_GHWCFG4_t    ghwcfg4;             /* ALT_USB_GLOB_GHWCFG4 */
    volatile uint32_t         _pad_0x54_0x5b[2];   /* *UNDEFINED* */
    ALT_USB_GLOB_GDFIFOCFG_t  gdfifocfg;           /* ALT_USB_GLOB_GDFIFOCFG */
    volatile uint32_t         _pad_0x60_0xff[40];  /* *UNDEFINED* */
    ALT_USB_GLOB_HPTXFSIZ_t   hptxfsiz;            /* ALT_USB_GLOB_HPTXFSIZ */
    ALT_USB_GLOB_DIEPTXF1_t   dieptxf1;            /* ALT_USB_GLOB_DIEPTXF1 */
    ALT_USB_GLOB_DIEPTXF2_t   dieptxf2;            /* ALT_USB_GLOB_DIEPTXF2 */
    ALT_USB_GLOB_DIEPTXF3_t   dieptxf3;            /* ALT_USB_GLOB_DIEPTXF3 */
    ALT_USB_GLOB_DIEPTXF4_t   dieptxf4;            /* ALT_USB_GLOB_DIEPTXF4 */
    ALT_USB_GLOB_DIEPTXF5_t   dieptxf5;            /* ALT_USB_GLOB_DIEPTXF5 */
    ALT_USB_GLOB_DIEPTXF6_t   dieptxf6;            /* ALT_USB_GLOB_DIEPTXF6 */
    ALT_USB_GLOB_DIEPTXF7_t   dieptxf7;            /* ALT_USB_GLOB_DIEPTXF7 */
    ALT_USB_GLOB_DIEPTXF8_t   dieptxf8;            /* ALT_USB_GLOB_DIEPTXF8 */
    ALT_USB_GLOB_DIEPTXF9_t   dieptxf9;            /* ALT_USB_GLOB_DIEPTXF9 */
    ALT_USB_GLOB_DIEPTXF10_t  dieptxf10;           /* ALT_USB_GLOB_DIEPTXF10 */
    ALT_USB_GLOB_DIEPTXF11_t  dieptxf11;           /* ALT_USB_GLOB_DIEPTXF11 */
    ALT_USB_GLOB_DIEPTXF12_t  dieptxf12;           /* ALT_USB_GLOB_DIEPTXF12 */
    ALT_USB_GLOB_DIEPTXF13_t  dieptxf13;           /* ALT_USB_GLOB_DIEPTXF13 */
    ALT_USB_GLOB_DIEPTXF14_t  dieptxf14;           /* ALT_USB_GLOB_DIEPTXF14 */
    ALT_USB_GLOB_DIEPTXF15_t  dieptxf15;           /* ALT_USB_GLOB_DIEPTXF15 */
};

/* The typedef declaration for register group ALT_USB_GLOB. */
typedef volatile struct ALT_USB_GLOB_s  ALT_USB_GLOB_t;
/* The struct declaration for the raw register contents of register group ALT_USB_GLOB. */
struct ALT_USB_GLOB_raw_s
{
    volatile uint32_t  gotgctl;             /* ALT_USB_GLOB_GOTGCTL */
    volatile uint32_t  gotgint;             /* ALT_USB_GLOB_GOTGINT */
    volatile uint32_t  gahbcfg;             /* ALT_USB_GLOB_GAHBCFG */
    volatile uint32_t  gusbcfg;             /* ALT_USB_GLOB_GUSBCFG */
    volatile uint32_t  grstctl;             /* ALT_USB_GLOB_GRSTCTL */
    volatile uint32_t  gintsts;             /* ALT_USB_GLOB_GINTSTS */
    volatile uint32_t  gintmsk;             /* ALT_USB_GLOB_GINTMSK */
    volatile uint32_t  grxstsr;             /* ALT_USB_GLOB_GRXSTSR */
    volatile uint32_t  grxstsp;             /* ALT_USB_GLOB_GRXSTSP */
    volatile uint32_t  grxfsiz;             /* ALT_USB_GLOB_GRXFSIZ */
    volatile uint32_t  gnptxfsiz;           /* ALT_USB_GLOB_GNPTXFSIZ */
    volatile uint32_t  gnptxsts;            /* ALT_USB_GLOB_GNPTXSTS */
    uint32_t           _pad_0x30_0x33;      /* *UNDEFINED* */
    volatile uint32_t  gpvndctl;            /* ALT_USB_GLOB_GPVNDCTL */
    volatile uint32_t  ggpio;               /* ALT_USB_GLOB_GGPIO */
    volatile uint32_t  guid;                /* ALT_USB_GLOB_GUID */
    volatile uint32_t  gsnpsid;             /* ALT_USB_GLOB_GSNPSID */
    volatile uint32_t  ghwcfg1;             /* ALT_USB_GLOB_GHWCFG1 */
    volatile uint32_t  ghwcfg2;             /* ALT_USB_GLOB_GHWCFG2 */
    volatile uint32_t  ghwcfg3;             /* ALT_USB_GLOB_GHWCFG3 */
    volatile uint32_t  ghwcfg4;             /* ALT_USB_GLOB_GHWCFG4 */
    uint32_t           _pad_0x54_0x5b[2];   /* *UNDEFINED* */
    volatile uint32_t  gdfifocfg;           /* ALT_USB_GLOB_GDFIFOCFG */
    uint32_t           _pad_0x60_0xff[40];  /* *UNDEFINED* */
    volatile uint32_t  hptxfsiz;            /* ALT_USB_GLOB_HPTXFSIZ */
    volatile uint32_t  dieptxf1;            /* ALT_USB_GLOB_DIEPTXF1 */
    volatile uint32_t  dieptxf2;            /* ALT_USB_GLOB_DIEPTXF2 */
    volatile uint32_t  dieptxf3;            /* ALT_USB_GLOB_DIEPTXF3 */
    volatile uint32_t  dieptxf4;            /* ALT_USB_GLOB_DIEPTXF4 */
    volatile uint32_t  dieptxf5;            /* ALT_USB_GLOB_DIEPTXF5 */
    volatile uint32_t  dieptxf6;            /* ALT_USB_GLOB_DIEPTXF6 */
    volatile uint32_t  dieptxf7;            /* ALT_USB_GLOB_DIEPTXF7 */
    volatile uint32_t  dieptxf8;            /* ALT_USB_GLOB_DIEPTXF8 */
    volatile uint32_t  dieptxf9;            /* ALT_USB_GLOB_DIEPTXF9 */
    volatile uint32_t  dieptxf10;           /* ALT_USB_GLOB_DIEPTXF10 */
    volatile uint32_t  dieptxf11;           /* ALT_USB_GLOB_DIEPTXF11 */
    volatile uint32_t  dieptxf12;           /* ALT_USB_GLOB_DIEPTXF12 */
    volatile uint32_t  dieptxf13;           /* ALT_USB_GLOB_DIEPTXF13 */
    volatile uint32_t  dieptxf14;           /* ALT_USB_GLOB_DIEPTXF14 */
    volatile uint32_t  dieptxf15;           /* ALT_USB_GLOB_DIEPTXF15 */
};

/* The typedef declaration for the raw register contents of register group ALT_USB_GLOB. */
typedef volatile struct ALT_USB_GLOB_raw_s  ALT_USB_GLOB_raw_t;
#endif  /* __ASSEMBLY__ */


/*
 * Component : ALT_USB_HOST
 * 
 */
/*
 * Register : hcfg
 * 
 * Host Configuration Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                  
 * :--------|:-------|:------|:------------------------------
 *  [1:0]   | RW     | 0x0   | ALT_USB_HOST_HCFG_FSLSPCLKSEL
 *  [2]     | RW     | 0x0   | ALT_USB_HOST_HCFG_FSLSSUPP   
 *  [6:3]   | ???    | 0x0   | *UNDEFINED*                  
 *  [7]     | RW     | 0x0   | ALT_USB_HOST_HCFG_ENA32KHZS  
 *  [15:8]  | RW     | 0x2   | ALT_USB_HOST_HCFG_RESVALID   
 *  [22:16] | ???    | 0x0   | *UNDEFINED*                  
 *  [23]    | RW     | 0x0   | ALT_USB_HOST_HCFG_DESCDMA    
 *  [25:24] | RW     | 0x0   | ALT_USB_HOST_HCFG_FRLISTEN   
 *  [26]    | RW     | 0x0   | ALT_USB_HOST_HCFG_PERSCHEDENA
 *  [30:27] | ???    | 0x0   | *UNDEFINED*                  
 *  [31]    | RW     | 0x0   | ALT_USB_HOST_HCFG_MODCHTIMEN 
 * 
 */
/*
 * Field : fslspclksel
 * 
 * FS/LS PHY Clock Select (FSLSPclkSel)
 * 
 * When the core is in FS Host mode
 * 
 * 2'b00: PHY clock is running at 30/60 MHz
 * 
 * 2'b01: PHY clock is running at 48 MHz
 * 
 * Others: Reserved
 * 
 * When the core is in LS Host mode
 * 
 * 2'b00: PHY clock is running at 30/60 MHz. When the
 * 
 * UTMI+/ULPI PHY Low Power mode is not selected, use
 * 
 * 30/60 MHz.
 * 
 * 2'b01: PHY clock is running at 48 MHz. When the UTMI+
 * 
 * PHY Low Power mode is selected, use 48MHz If the PHY
 * 
 * supplies a 48 MHz clock during LS mode.
 * 
 * 2'b10: PHY clock is running at 6 MHz. In USB 1.1 FS mode,
 * 
 * use 6 MHz when the UTMI+ PHY Low Power mode is
 * 
 * selected and the PHY supplies a 6 MHz clock during LS
 * 
 * mode. If you select a 6 MHz clock during LS mode, you must
 * 
 * do a soft reset.
 * 
 * 2'b11: Reserved
 * 
 * Notes:
 * 
 * When Core in FS mode, the internal and external clocks have the same frequency.
 * 
 * When Core in LS mode,
 * 
 * * If FSLSPclkSel = 2'b00: Internal and external clocks have the same frequency
 * 
 * * If FSLSPclkSel = 2'b10: Internal clock is the divided by eight version of
 *   external 48 MHz clock
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                      
 * :----------------------------------------|:------|:----------------------------------
 *  ALT_USB_HOST_HCFG_FSLSPCLKSEL_E_CLK3060 | 0x0   | PHY clock is running at 30/60 MHz
 *  ALT_USB_HOST_HCFG_FSLSPCLKSEL_E_CLK48   | 0x1   | PHY clock is running at 48 MHz   
 *  ALT_USB_HOST_HCFG_FSLSPCLKSEL_E_CLK6    | 0x2   | PHY clock is running at 6 MHz    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FSLSPCLKSEL
 * 
 * PHY clock is running at 30/60 MHz
 */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_E_CLK3060 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FSLSPCLKSEL
 * 
 * PHY clock is running at 48 MHz
 */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_E_CLK48   0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FSLSPCLKSEL
 * 
 * PHY clock is running at 6 MHz
 */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_E_CLK6    0x2

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCFG_FSLSPCLKSEL register field. */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCFG_FSLSPCLKSEL register field. */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_MSB        1
/* The width in bits of the ALT_USB_HOST_HCFG_FSLSPCLKSEL register field. */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCFG_FSLSPCLKSEL register field value. */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_USB_HOST_HCFG_FSLSPCLKSEL register field value. */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_USB_HOST_HCFG_FSLSPCLKSEL register field. */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_RESET      0x0
/* Extracts the ALT_USB_HOST_HCFG_FSLSPCLKSEL field value from a register. */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_USB_HOST_HCFG_FSLSPCLKSEL register field value suitable for setting the register. */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_SET(value) (((value) << 0) & 0x00000003)

/*
 * Field : fslssupp
 * 
 * FS- and LS-Only Support (FSLSSupp)
 * 
 * The application uses this bit to control the core's enumeration
 * 
 * speed. Using this bit, the application can make the core
 * 
 * enumerate as a FS host, even If the connected device supports
 * 
 * HS traffic. Do not make changes to this field after initial
 * 
 * programming.
 * 
 * 1'b0: HS/FS/LS, based on the maximum speed supported by
 * 
 * the connected device
 * 
 * 1'b1: FS/LS-only, even If the connected device can support
 * 
 * HS
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                                   
 * :------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_HOST_HCFG_FSLSSUPP_E_HSFSLS | 0x0   | HS/FS/LS, based on the maximum speed supported
 * :                                    |       | by the connected device                       
 *  ALT_USB_HOST_HCFG_FSLSSUPP_E_FSLS   | 0x1   | FS/LS-only, even if the connected device can  
 * :                                    |       | support HS                                    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FSLSSUPP
 * 
 * HS/FS/LS, based on the maximum speed supported by the connected device
 */
#define ALT_USB_HOST_HCFG_FSLSSUPP_E_HSFSLS 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FSLSSUPP
 * 
 * FS/LS-only, even if the connected device can support HS
 */
#define ALT_USB_HOST_HCFG_FSLSSUPP_E_FSLS   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCFG_FSLSSUPP register field. */
#define ALT_USB_HOST_HCFG_FSLSSUPP_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCFG_FSLSSUPP register field. */
#define ALT_USB_HOST_HCFG_FSLSSUPP_MSB        2
/* The width in bits of the ALT_USB_HOST_HCFG_FSLSSUPP register field. */
#define ALT_USB_HOST_HCFG_FSLSSUPP_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCFG_FSLSSUPP register field value. */
#define ALT_USB_HOST_HCFG_FSLSSUPP_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_HOST_HCFG_FSLSSUPP register field value. */
#define ALT_USB_HOST_HCFG_FSLSSUPP_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_HOST_HCFG_FSLSSUPP register field. */
#define ALT_USB_HOST_HCFG_FSLSSUPP_RESET      0x0
/* Extracts the ALT_USB_HOST_HCFG_FSLSSUPP field value from a register. */
#define ALT_USB_HOST_HCFG_FSLSSUPP_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_HOST_HCFG_FSLSSUPP register field value suitable for setting the register. */
#define ALT_USB_HOST_HCFG_FSLSSUPP_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : ena32khzs
 * 
 * Enable 32 KHz Suspend mode (Ena32KHzS)
 * 
 * This bit can be set only in FS PHY interface is selected.
 * 
 * Else, this bit needs to be set to zero.
 * 
 * When FS PHY interface is chosen and this bit is set,
 * 
 * the core expects that the PHY clock during Suspend is switched
 * 
 * from 48 MHz to 32 KHz.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                                    
 * :-----------------------------------|:------|:------------------------------------------------
 *  ALT_USB_HOST_HCFG_ENA32KHZS_E_DISD | 0x0   | USB 1.1 Full-Speed Not Selected                
 *  ALT_USB_HOST_HCFG_ENA32KHZS_E_END  | 0x1   | USB 1.1 Full-Speed Serial Transceiver Interface
 * :                                   |       | selected                                       
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_ENA32KHZS
 * 
 * USB 1.1 Full-Speed Not Selected
 */
#define ALT_USB_HOST_HCFG_ENA32KHZS_E_DISD  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_ENA32KHZS
 * 
 * USB 1.1 Full-Speed Serial Transceiver Interface selected
 */
#define ALT_USB_HOST_HCFG_ENA32KHZS_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCFG_ENA32KHZS register field. */
#define ALT_USB_HOST_HCFG_ENA32KHZS_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCFG_ENA32KHZS register field. */
#define ALT_USB_HOST_HCFG_ENA32KHZS_MSB        7
/* The width in bits of the ALT_USB_HOST_HCFG_ENA32KHZS register field. */
#define ALT_USB_HOST_HCFG_ENA32KHZS_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCFG_ENA32KHZS register field value. */
#define ALT_USB_HOST_HCFG_ENA32KHZS_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_HOST_HCFG_ENA32KHZS register field value. */
#define ALT_USB_HOST_HCFG_ENA32KHZS_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_HOST_HCFG_ENA32KHZS register field. */
#define ALT_USB_HOST_HCFG_ENA32KHZS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCFG_ENA32KHZS field value from a register. */
#define ALT_USB_HOST_HCFG_ENA32KHZS_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_HOST_HCFG_ENA32KHZS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCFG_ENA32KHZS_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : resvalid
 * 
 * Resume Validation Period  (ResValid)
 * 
 * This field is effective only when HCFG.Ena32KHzS is set.
 * 
 * It will control the resume period when the core resumes from suspend.
 * 
 * The core counts for 'ResValid' number of clock cycles to detect a
 * 
 * valid resume when this is set.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCFG_RESVALID register field. */
#define ALT_USB_HOST_HCFG_RESVALID_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCFG_RESVALID register field. */
#define ALT_USB_HOST_HCFG_RESVALID_MSB        15
/* The width in bits of the ALT_USB_HOST_HCFG_RESVALID register field. */
#define ALT_USB_HOST_HCFG_RESVALID_WIDTH      8
/* The mask used to set the ALT_USB_HOST_HCFG_RESVALID register field value. */
#define ALT_USB_HOST_HCFG_RESVALID_SET_MSK    0x0000ff00
/* The mask used to clear the ALT_USB_HOST_HCFG_RESVALID register field value. */
#define ALT_USB_HOST_HCFG_RESVALID_CLR_MSK    0xffff00ff
/* The reset value of the ALT_USB_HOST_HCFG_RESVALID register field. */
#define ALT_USB_HOST_HCFG_RESVALID_RESET      0x2
/* Extracts the ALT_USB_HOST_HCFG_RESVALID field value from a register. */
#define ALT_USB_HOST_HCFG_RESVALID_GET(value) (((value) & 0x0000ff00) >> 8)
/* Produces a ALT_USB_HOST_HCFG_RESVALID register field value suitable for setting the register. */
#define ALT_USB_HOST_HCFG_RESVALID_SET(value) (((value) << 8) & 0x0000ff00)

/*
 * Field : descdma
 * 
 * Enable Scatter/gather DMA in Host mode (DescDMA).
 * 
 * When the Scatter/Gather DMA option selected during configuration
 * 
 * of the RTL, the application can set this bit during initialization
 * 
 * to enable the Scatter/Gather DMA operation.
 * 
 * NOTE: This bit must be modified only once after a reset.
 * 
 * \The following combinations are available for programming:
 * 
 * GAHBCFG.DMAEn=0,HCFG.DescDMA=0 => Slave mode
 * 
 * GAHBCFG.DMAEn=0,HCFG.DescDMA=1 => Invalid
 * 
 * GAHBCFG.DMAEn=1,HCFG.DescDMA=0 => Buffered DMA mode
 * 
 * GAHBCFG.DMAEn=1,HCFG.DescDMA=1 => Scatter/Gather DMA mode
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                
 * :---------------------------------|:------|:----------------------------
 *  ALT_USB_HOST_HCFG_DESCDMA_E_DISD | 0x0   | No Scatter/Gather DMA      
 *  ALT_USB_HOST_HCFG_DESCDMA_E_END  | 0x1   | Scatter/Gather DMA selected
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_DESCDMA
 * 
 * No Scatter/Gather DMA
 */
#define ALT_USB_HOST_HCFG_DESCDMA_E_DISD    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_DESCDMA
 * 
 * Scatter/Gather DMA selected
 */
#define ALT_USB_HOST_HCFG_DESCDMA_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCFG_DESCDMA register field. */
#define ALT_USB_HOST_HCFG_DESCDMA_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCFG_DESCDMA register field. */
#define ALT_USB_HOST_HCFG_DESCDMA_MSB        23
/* The width in bits of the ALT_USB_HOST_HCFG_DESCDMA register field. */
#define ALT_USB_HOST_HCFG_DESCDMA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCFG_DESCDMA register field value. */
#define ALT_USB_HOST_HCFG_DESCDMA_SET_MSK    0x00800000
/* The mask used to clear the ALT_USB_HOST_HCFG_DESCDMA register field value. */
#define ALT_USB_HOST_HCFG_DESCDMA_CLR_MSK    0xff7fffff
/* The reset value of the ALT_USB_HOST_HCFG_DESCDMA register field. */
#define ALT_USB_HOST_HCFG_DESCDMA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCFG_DESCDMA field value from a register. */
#define ALT_USB_HOST_HCFG_DESCDMA_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_USB_HOST_HCFG_DESCDMA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCFG_DESCDMA_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : frlisten
 * 
 * Frame List Entries(FrListEn). The value in the register specifies the number
 * 
 * of entries in the Frame list.
 * 
 * This field is valid only in Scatter/Gather DMA mode.
 * 
 * 2'b00: 8 Entries
 * 
 * 2'b01: 16 Entries
 * 
 * 2'b10: 32 Entries
 * 
 * 2'b11: 63 Entries
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCFG_FRLISTEN_E_RSVD    | 0x0   | Reserved   
 *  ALT_USB_HOST_HCFG_FRLISTEN_E_ENTRY8  | 0x1   | 8  Entries 
 *  ALT_USB_HOST_HCFG_FRLISTEN_E_ENTRY16 | 0x2   | 16 Entries 
 *  ALT_USB_HOST_HCFG_FRLISTEN_E_ENTRY32 | 0x3   | 32 Entries 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FRLISTEN
 * 
 * Reserved
 */
#define ALT_USB_HOST_HCFG_FRLISTEN_E_RSVD       0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FRLISTEN
 * 
 * 8  Entries
 */
#define ALT_USB_HOST_HCFG_FRLISTEN_E_ENTRY8     0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FRLISTEN
 * 
 * 16 Entries
 */
#define ALT_USB_HOST_HCFG_FRLISTEN_E_ENTRY16    0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FRLISTEN
 * 
 * 32 Entries
 */
#define ALT_USB_HOST_HCFG_FRLISTEN_E_ENTRY32    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCFG_FRLISTEN register field. */
#define ALT_USB_HOST_HCFG_FRLISTEN_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCFG_FRLISTEN register field. */
#define ALT_USB_HOST_HCFG_FRLISTEN_MSB        25
/* The width in bits of the ALT_USB_HOST_HCFG_FRLISTEN register field. */
#define ALT_USB_HOST_HCFG_FRLISTEN_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCFG_FRLISTEN register field value. */
#define ALT_USB_HOST_HCFG_FRLISTEN_SET_MSK    0x03000000
/* The mask used to clear the ALT_USB_HOST_HCFG_FRLISTEN register field value. */
#define ALT_USB_HOST_HCFG_FRLISTEN_CLR_MSK    0xfcffffff
/* The reset value of the ALT_USB_HOST_HCFG_FRLISTEN register field. */
#define ALT_USB_HOST_HCFG_FRLISTEN_RESET      0x0
/* Extracts the ALT_USB_HOST_HCFG_FRLISTEN field value from a register. */
#define ALT_USB_HOST_HCFG_FRLISTEN_GET(value) (((value) & 0x03000000) >> 24)
/* Produces a ALT_USB_HOST_HCFG_FRLISTEN register field value suitable for setting the register. */
#define ALT_USB_HOST_HCFG_FRLISTEN_SET(value) (((value) << 24) & 0x03000000)

/*
 * Field : perschedena
 * 
 * Enable Periodic Scheduling (PerSchedEna):
 * 
 * Applicable in host DDMA mode only.
 * 
 * Enables periodic scheduling within the core. Initially, the bit is reset.
 * 
 * The core will not process any periodic channels. As soon as this bit is set,
 * 
 * the core will get ready to start scheduling periodic channels and
 * 
 * sets HCFG.PerSchedStat. The setting of HCFG.PerSchedStat indicates the core
 * 
 * has enabled periodic scheduling. Once HCFG.PerSchedEna is set,
 * 
 * the application is not supposed to again reset the bit unless HCFG.PerSchedStat
 * 
 * is set. As soon as this bit is reset, the core will get ready to
 * 
 * stop scheduling periodic channels and resets HCFG.PerSchedStat.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                 
 * :-------------------------------------|:------|:---------------------------------------------
 *  ALT_USB_HOST_HCFG_PERSCHEDENA_E_DISD | 0x0   | Disables periodic scheduling within the core
 *  ALT_USB_HOST_HCFG_PERSCHEDENA_E_END  | 0x1   | Enables periodic scheduling within the core 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_PERSCHEDENA
 * 
 * Disables periodic scheduling within the core
 */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_E_DISD    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_PERSCHEDENA
 * 
 * Enables periodic scheduling within the core
 */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCFG_PERSCHEDENA register field. */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCFG_PERSCHEDENA register field. */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_MSB        26
/* The width in bits of the ALT_USB_HOST_HCFG_PERSCHEDENA register field. */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCFG_PERSCHEDENA register field value. */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_SET_MSK    0x04000000
/* The mask used to clear the ALT_USB_HOST_HCFG_PERSCHEDENA register field value. */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_CLR_MSK    0xfbffffff
/* The reset value of the ALT_USB_HOST_HCFG_PERSCHEDENA register field. */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCFG_PERSCHEDENA field value from a register. */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_USB_HOST_HCFG_PERSCHEDENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : modechtimen
 * 
 * Mode Change Ready Timer Enable (ModeChTimEn)
 * 
 * This bit is used to enable/disable the Host core
 * 
 * to wait  200 PHY clock cycles at the end of Resumeto change the opmode signal to
 * the PHY to 00
 * 
 * after Suspend or LPM.
 * 
 * 1'b0 : The Host core waits for either 200 PHY clock cycles or a linestate
 * 
 * of SE0 at the end of resume to the change the opmode from 2'b10 to 2'b00
 * 
 * 1'b1 : The Host core waits only for a linstate of SE0 at the end of resume
 * 
 * to change the opmode from 2'b10 to 2'b00.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                                    
 * :------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_HOST_HCFG_MODCHTIMEN_E_END  | 0x0   | The Host core waits for either 200 PHY clock   
 * :                                    |       | cycles or a linestate of SE0 at the end of     
 * :                                    |       | resume to change the opmode from 0x2 to 0x0    
 *  ALT_USB_HOST_HCFG_MODCHTIMEN_E_DISD | 0x1   | The Host core waits only for a linestate of SE0
 * :                                    |       | at the end of resume to change the opmode from 
 * :                                    |       | 0x2 to 0x0                                     
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_MODCHTIMEN
 * 
 * The Host core waits for either 200 PHY clock cycles or a linestate of SE0 at the
 * end of resume to change the opmode from 0x2 to 0x0
 */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_E_END  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_MODCHTIMEN
 * 
 * The Host core waits only for a linestate of SE0 at the end of resume to change
 * the opmode from 0x2 to 0x0
 */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_E_DISD 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCFG_MODCHTIMEN register field. */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCFG_MODCHTIMEN register field. */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_MSB        31
/* The width in bits of the ALT_USB_HOST_HCFG_MODCHTIMEN register field. */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCFG_MODCHTIMEN register field value. */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCFG_MODCHTIMEN register field value. */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCFG_MODCHTIMEN register field. */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_RESET      0x0
/* Extracts the ALT_USB_HOST_HCFG_MODCHTIMEN field value from a register. */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCFG_MODCHTIMEN register field value suitable for setting the register. */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCFG.
 */
struct ALT_USB_HOST_HCFG_s
{
    uint32_t  fslspclksel :  2;  /* ALT_USB_HOST_HCFG_FSLSPCLKSEL */
    uint32_t  fslssupp    :  1;  /* ALT_USB_HOST_HCFG_FSLSSUPP */
    uint32_t              :  4;  /* *UNDEFINED* */
    uint32_t  ena32khzs   :  1;  /* ALT_USB_HOST_HCFG_ENA32KHZS */
    uint32_t  resvalid    :  8;  /* ALT_USB_HOST_HCFG_RESVALID */
    uint32_t              :  7;  /* *UNDEFINED* */
    uint32_t  descdma     :  1;  /* ALT_USB_HOST_HCFG_DESCDMA */
    uint32_t  frlisten    :  2;  /* ALT_USB_HOST_HCFG_FRLISTEN */
    uint32_t  perschedena :  1;  /* ALT_USB_HOST_HCFG_PERSCHEDENA */
    uint32_t              :  4;  /* *UNDEFINED* */
    uint32_t  modechtimen :  1;  /* ALT_USB_HOST_HCFG_MODCHTIMEN */
};

/* The typedef declaration for register ALT_USB_HOST_HCFG. */
typedef volatile struct ALT_USB_HOST_HCFG_s  ALT_USB_HOST_HCFG_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCFG register. */
#define ALT_USB_HOST_HCFG_RESET       0x00000200
/* The byte offset of the ALT_USB_HOST_HCFG register from the beginning of the component. */
#define ALT_USB_HOST_HCFG_OFST        0x0
/* The address of the ALT_USB_HOST_HCFG register. */
#define ALT_USB_HOST_HCFG_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCFG_OFST))

/*
 * Register : hfir
 * 
 * Host Frame Interval Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                 
 * :--------|:-------|:-------|:-----------------------------
 *  [15:0]  | RW     | 0xea60 | ALT_USB_HOST_HFIR_FRINT     
 *  [16]    | RW     | 0x0    | ALT_USB_HOST_HFIR_HFIRRLDCTL
 *  [31:17] | ???    | 0x0    | *UNDEFINED*                 
 * 
 */
/*
 * Field : frint
 * 
 * Frame Interval (FrInt)
 * 
 * The value that the application programs to this field specifies
 * 
 * the interval between two consecutive SOFs (FS) or micro-
 * 
 * SOFs (HS) or Keep-Alive tokens (HS). This field contains the
 * 
 * number of PHY clocks that constitute the required frame
 * 
 * interval. The Default value Set in this field For a FS operation
 * 
 * when the PHY clock frequency is 60 MHz. The application can
 * 
 * write a value to this register only after the Port Enable bit of the
 * 
 * Host Port Control and Status register (HPRT.PrtEnaPort) has
 * 
 * been Set. If no value is programmed, the core calculates the
 * 
 * value based on the PHY clock specified in the FS/LS PHY
 * 
 * Clock Select field of the Host Configuration register
 * 
 * (HCFG.FSLSPclkSel). Do not change the value of this field
 * 
 * after the initial configuration.
 * 
 * 125 s * (PHY clock frequency For HS)
 * 
 * 1 ms * (PHY clock frequency For FS/LS)
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HFIR_FRINT register field. */
#define ALT_USB_HOST_HFIR_FRINT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HFIR_FRINT register field. */
#define ALT_USB_HOST_HFIR_FRINT_MSB        15
/* The width in bits of the ALT_USB_HOST_HFIR_FRINT register field. */
#define ALT_USB_HOST_HFIR_FRINT_WIDTH      16
/* The mask used to set the ALT_USB_HOST_HFIR_FRINT register field value. */
#define ALT_USB_HOST_HFIR_FRINT_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_HOST_HFIR_FRINT register field value. */
#define ALT_USB_HOST_HFIR_FRINT_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_HOST_HFIR_FRINT register field. */
#define ALT_USB_HOST_HFIR_FRINT_RESET      0xea60
/* Extracts the ALT_USB_HOST_HFIR_FRINT field value from a register. */
#define ALT_USB_HOST_HFIR_FRINT_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_HOST_HFIR_FRINT register field value suitable for setting the register. */
#define ALT_USB_HOST_HFIR_FRINT_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : hfirrldctrl
 * 
 * Reload Control (HFIRRldCtrl)
 * 
 * This bit allows dynamic reloading of the HFIR register during run time.
 * 
 * 1'b0 : The HFIR cannot be reloaded dynamically
 * 
 * 1'b1: the HFIR can be dynamically reloaded during runtime.
 * 
 * This bit needs to be programmed during initial configuration and its value
 * should not be changed during runtime.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                                
 * :------------------------------------|:------|:--------------------------------------------
 *  ALT_USB_HOST_HFIR_HFIRRLDCTL_E_DISD | 0x0   | The HFIR cannot be reloaded dynamically    
 *  ALT_USB_HOST_HFIR_HFIRRLDCTL_E_END  | 0x1   | The HFIR can be dynamically reloaded during
 * :                                    |       | runtime                                    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HFIR_HFIRRLDCTL
 * 
 * The HFIR cannot be reloaded dynamically
 */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HFIR_HFIRRLDCTL
 * 
 * The HFIR can be dynamically reloaded during runtime
 */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HFIR_HFIRRLDCTL register field. */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HFIR_HFIRRLDCTL register field. */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_MSB        16
/* The width in bits of the ALT_USB_HOST_HFIR_HFIRRLDCTL register field. */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HFIR_HFIRRLDCTL register field value. */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_SET_MSK    0x00010000
/* The mask used to clear the ALT_USB_HOST_HFIR_HFIRRLDCTL register field value. */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_CLR_MSK    0xfffeffff
/* The reset value of the ALT_USB_HOST_HFIR_HFIRRLDCTL register field. */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_RESET      0x0
/* Extracts the ALT_USB_HOST_HFIR_HFIRRLDCTL field value from a register. */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_USB_HOST_HFIR_HFIRRLDCTL register field value suitable for setting the register. */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_SET(value) (((value) << 16) & 0x00010000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HFIR.
 */
struct ALT_USB_HOST_HFIR_s
{
    uint32_t  frint       : 16;  /* ALT_USB_HOST_HFIR_FRINT */
    uint32_t  hfirrldctrl :  1;  /* ALT_USB_HOST_HFIR_HFIRRLDCTL */
    uint32_t              : 15;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HFIR. */
typedef volatile struct ALT_USB_HOST_HFIR_s  ALT_USB_HOST_HFIR_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HFIR register. */
#define ALT_USB_HOST_HFIR_RESET       0x0000ea60
/* The byte offset of the ALT_USB_HOST_HFIR register from the beginning of the component. */
#define ALT_USB_HOST_HFIR_OFST        0x4
/* The address of the ALT_USB_HOST_HFIR register. */
#define ALT_USB_HOST_HFIR_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HFIR_OFST))

/*
 * Register : hfnum
 * 
 * Host Frame Number/Frame Time Remaining Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description             
 * :--------|:-------|:-------|:-------------------------
 *  [15:0]  | R      | 0x3fff | ALT_USB_HOST_HFNUM_FRNUM
 *  [31:16] | R      | 0x0    | ALT_USB_HOST_HFNUM_FRREM
 * 
 */
/*
 * Field : frnum
 * 
 * Frame Number (FrNum)
 * 
 * This field increments when a new SOF is transmitted on the
 * 
 * USB, and is reset to 0 when it reaches 16'h3FFF.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description          
 * :---------------------------------|:------|:----------------------
 *  ALT_USB_HOST_HFNUM_FRNUM_E_INACT | 0x0   | No SOF is transmitted
 *  ALT_USB_HOST_HFNUM_FRNUM_E_ACT   | 0x1   | SOF is transmitted   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HFNUM_FRNUM
 * 
 * No SOF is transmitted
 */
#define ALT_USB_HOST_HFNUM_FRNUM_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HFNUM_FRNUM
 * 
 * SOF is transmitted
 */
#define ALT_USB_HOST_HFNUM_FRNUM_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HFNUM_FRNUM register field. */
#define ALT_USB_HOST_HFNUM_FRNUM_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HFNUM_FRNUM register field. */
#define ALT_USB_HOST_HFNUM_FRNUM_MSB        15
/* The width in bits of the ALT_USB_HOST_HFNUM_FRNUM register field. */
#define ALT_USB_HOST_HFNUM_FRNUM_WIDTH      16
/* The mask used to set the ALT_USB_HOST_HFNUM_FRNUM register field value. */
#define ALT_USB_HOST_HFNUM_FRNUM_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_HOST_HFNUM_FRNUM register field value. */
#define ALT_USB_HOST_HFNUM_FRNUM_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_HOST_HFNUM_FRNUM register field. */
#define ALT_USB_HOST_HFNUM_FRNUM_RESET      0x3fff
/* Extracts the ALT_USB_HOST_HFNUM_FRNUM field value from a register. */
#define ALT_USB_HOST_HFNUM_FRNUM_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_HOST_HFNUM_FRNUM register field value suitable for setting the register. */
#define ALT_USB_HOST_HFNUM_FRNUM_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : frrem
 * 
 * Frame Time Remaining (FrRem)
 * 
 * Indicates the amount of time remaining in the current
 * 
 * microframe (HS) or Frame (FS/LS), in terms of PHY clocks. This
 * 
 * field decrements on each PHY clock. When it reaches zero, this
 * 
 * field is reloaded with the value in the Frame Interval register and
 * 
 * a new SOF is transmitted on the USB.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HFNUM_FRREM register field. */
#define ALT_USB_HOST_HFNUM_FRREM_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HFNUM_FRREM register field. */
#define ALT_USB_HOST_HFNUM_FRREM_MSB        31
/* The width in bits of the ALT_USB_HOST_HFNUM_FRREM register field. */
#define ALT_USB_HOST_HFNUM_FRREM_WIDTH      16
/* The mask used to set the ALT_USB_HOST_HFNUM_FRREM register field value. */
#define ALT_USB_HOST_HFNUM_FRREM_SET_MSK    0xffff0000
/* The mask used to clear the ALT_USB_HOST_HFNUM_FRREM register field value. */
#define ALT_USB_HOST_HFNUM_FRREM_CLR_MSK    0x0000ffff
/* The reset value of the ALT_USB_HOST_HFNUM_FRREM register field. */
#define ALT_USB_HOST_HFNUM_FRREM_RESET      0x0
/* Extracts the ALT_USB_HOST_HFNUM_FRREM field value from a register. */
#define ALT_USB_HOST_HFNUM_FRREM_GET(value) (((value) & 0xffff0000) >> 16)
/* Produces a ALT_USB_HOST_HFNUM_FRREM register field value suitable for setting the register. */
#define ALT_USB_HOST_HFNUM_FRREM_SET(value) (((value) << 16) & 0xffff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HFNUM.
 */
struct ALT_USB_HOST_HFNUM_s
{
    const uint32_t  frnum : 16;  /* ALT_USB_HOST_HFNUM_FRNUM */
    const uint32_t  frrem : 16;  /* ALT_USB_HOST_HFNUM_FRREM */
};

/* The typedef declaration for register ALT_USB_HOST_HFNUM. */
typedef volatile struct ALT_USB_HOST_HFNUM_s  ALT_USB_HOST_HFNUM_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HFNUM register. */
#define ALT_USB_HOST_HFNUM_RESET       0x00003fff
/* The byte offset of the ALT_USB_HOST_HFNUM register from the beginning of the component. */
#define ALT_USB_HOST_HFNUM_OFST        0x8
/* The address of the ALT_USB_HOST_HFNUM register. */
#define ALT_USB_HOST_HFNUM_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HFNUM_OFST))

/*
 * Register : hptxsts
 * 
 * Host Periodic Transmit FIFO/Queue Status Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                      
 * :--------|:-------|:-------|:----------------------------------
 *  [15:0]  | R      | 0x2000 | ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL
 *  [23:16] | R      | 0x10   | ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 *  [24]    | R      | 0x0    | Terminate                        
 *  [26:25] | R      | 0x0    | Type                             
 *  [30:27] | R      | 0x0    | Channel Endpoint Number          
 *  [31]    | R      | 0x0    | Odd Even Micro Frame             
 * 
 */
/*
 * Field : ptxfspcavail
 * 
 * Periodic Transmit Data FIFO Space Available
 * 
 * (PTxFSpcAvail)
 * 
 * Indicates the number of free locations available to be written to in the
 * Periodic
 * 
 * TxFIFO.
 * 
 * Values are in terms of 32-bit words
 * 
 * 16'h0    : Periodic TxFIFO is full
 * 
 * 16'h1    : 1 word available
 * 
 * 16'h2    : 2 words available
 * 
 * 16'hn    : n words available (where 0  n  32,768)
 * 
 * 16'h8000 : 32,768 words
 * 
 * Others   : Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL register field. */
#define ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL register field. */
#define ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL_MSB        15
/* The width in bits of the ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL register field. */
#define ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL_WIDTH      16
/* The mask used to set the ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL register field value. */
#define ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL register field value. */
#define ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL register field. */
#define ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL_RESET      0x2000
/* Extracts the ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL field value from a register. */
#define ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL register field value suitable for setting the register. */
#define ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : ptxqspcavail
 * 
 * Periodic Transmit Request Queue Space Available
 * 
 * (PTxQSpcAvail)
 * 
 * Indicates the number of free locations available to be written in
 * 
 * the Periodic Transmit Request Queue. This queue holds both IN
 * 
 * and OUT requests.
 * 
 * 8'h0: Periodic Transmit Request Queue is full
 * 
 * 8'h1: 1 location available
 * 
 * 8'h2: 2 locations available
 * 
 * n: n locations available (0 <= n <= 16)
 * 
 * Others: Reserved
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                            
 * :------------------------------------------|:------|:----------------------------------------
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FULL  | 0x0   | Periodic Transmit Request Queue is full
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE1 | 0x1   | 1 location available                   
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE2 | 0x2   | 2 location available                   
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE3 | 0x3   | 3 location available                   
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE4 | 0x4   | 4 location available                   
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE5 | 0x5   | 5 location available                   
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE6 | 0x6   | 6 location available                   
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE7 | 0x7   | 7 location available                   
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE8 | 0x8   | 8 location available                   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * Periodic Transmit Request Queue is full
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FULL    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * 1 location available
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE1   0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * 2 location available
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE2   0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * 3 location available
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE3   0x3
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * 4 location available
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE4   0x4
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * 5 location available
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE5   0x5
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * 6 location available
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE6   0x6
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * 7 location available
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE7   0x7
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * 8 location available
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE8   0x8

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL register field. */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL register field. */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_MSB        23
/* The width in bits of the ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL register field. */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_WIDTH      8
/* The mask used to set the ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL register field value. */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL register field value. */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_CLR_MSK    0xff00ffff
/* The reset value of the ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL register field. */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_RESET      0x10
/* Extracts the ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL field value from a register. */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL register field value suitable for setting the register. */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Terminate - term
 * 
 * Terminate last entry for selected channel/endpoint.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description                      
 * :----------------------------------|:------|:----------------------------------
 *  ALT_USB_HOST_HPTXSTS_TERM_E_INACT | 0x0   | No termination                   
 *  ALT_USB_HOST_HPTXSTS_TERM_E_ACT   | 0x1   | Terminate last entry for selected
 * :                                  |       | channel/endpoint                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_TERM
 * 
 * No termination
 */
#define ALT_USB_HOST_HPTXSTS_TERM_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_TERM
 * 
 * Terminate last entry for selected channel/endpoint
 */
#define ALT_USB_HOST_HPTXSTS_TERM_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPTXSTS_TERM register field. */
#define ALT_USB_HOST_HPTXSTS_TERM_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPTXSTS_TERM register field. */
#define ALT_USB_HOST_HPTXSTS_TERM_MSB        24
/* The width in bits of the ALT_USB_HOST_HPTXSTS_TERM register field. */
#define ALT_USB_HOST_HPTXSTS_TERM_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPTXSTS_TERM register field value. */
#define ALT_USB_HOST_HPTXSTS_TERM_SET_MSK    0x01000000
/* The mask used to clear the ALT_USB_HOST_HPTXSTS_TERM register field value. */
#define ALT_USB_HOST_HPTXSTS_TERM_CLR_MSK    0xfeffffff
/* The reset value of the ALT_USB_HOST_HPTXSTS_TERM register field. */
#define ALT_USB_HOST_HPTXSTS_TERM_RESET      0x0
/* Extracts the ALT_USB_HOST_HPTXSTS_TERM field value from a register. */
#define ALT_USB_HOST_HPTXSTS_TERM_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_USB_HOST_HPTXSTS_TERM register field value suitable for setting the register. */
#define ALT_USB_HOST_HPTXSTS_TERM_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Type - type
 * 
 * This indicates the Entry in the Periodic Tx Request Queue that is currently
 * being processes by the MAC.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description            
 * :--------------------------------------|:------|:------------------------
 *  ALT_USB_HOST_HPTXSTS_TYPE_E_INOUT     | 0x0   | IN/OUT type            
 *  ALT_USB_HOST_HPTXSTS_TYPE_E_ZEROLNGTH | 0x1   | Zero-length packet type
 *  ALT_USB_HOST_HPTXSTS_TYPE_E_CSPLIT    | 0x2   | CSPLIT type            
 *  ALT_USB_HOST_HPTXSTS_TYPE_E_DIS       | 0x3   | Disable channel command
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_TYPE
 * 
 * IN/OUT type
 */
#define ALT_USB_HOST_HPTXSTS_TYPE_E_INOUT       0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_TYPE
 * 
 * Zero-length packet type
 */
#define ALT_USB_HOST_HPTXSTS_TYPE_E_ZEROLNGTH   0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_TYPE
 * 
 * CSPLIT type
 */
#define ALT_USB_HOST_HPTXSTS_TYPE_E_CSPLIT      0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_TYPE
 * 
 * Disable channel command
 */
#define ALT_USB_HOST_HPTXSTS_TYPE_E_DIS         0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPTXSTS_TYPE register field. */
#define ALT_USB_HOST_HPTXSTS_TYPE_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPTXSTS_TYPE register field. */
#define ALT_USB_HOST_HPTXSTS_TYPE_MSB        26
/* The width in bits of the ALT_USB_HOST_HPTXSTS_TYPE register field. */
#define ALT_USB_HOST_HPTXSTS_TYPE_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HPTXSTS_TYPE register field value. */
#define ALT_USB_HOST_HPTXSTS_TYPE_SET_MSK    0x06000000
/* The mask used to clear the ALT_USB_HOST_HPTXSTS_TYPE register field value. */
#define ALT_USB_HOST_HPTXSTS_TYPE_CLR_MSK    0xf9ffffff
/* The reset value of the ALT_USB_HOST_HPTXSTS_TYPE register field. */
#define ALT_USB_HOST_HPTXSTS_TYPE_RESET      0x0
/* Extracts the ALT_USB_HOST_HPTXSTS_TYPE field value from a register. */
#define ALT_USB_HOST_HPTXSTS_TYPE_GET(value) (((value) & 0x06000000) >> 25)
/* Produces a ALT_USB_HOST_HPTXSTS_TYPE register field value suitable for setting the register. */
#define ALT_USB_HOST_HPTXSTS_TYPE_SET(value) (((value) << 25) & 0x06000000)

/*
 * Field : Channel Endpoint Number - chanendpt
 * 
 * This indicates the channel endpoint number that is currently being processes by
 * the MAC.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description  
 * :-----------------------------------------|:------|:--------------
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT0  | 0x0   | End point  1 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT1  | 0x1   | End point  2 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT2  | 0x2   | End point  3 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT3  | 0x3   | End point  4 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT4  | 0x4   | End point  5 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT5  | 0x5   | End point  6 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT6  | 0x6   | End point  7 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT7  | 0x7   | End point  8 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT8  | 0x8   | End point  9 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT9  | 0x9   | End point  10
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT10 | 0xa   | End point 11 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT11 | 0xb   | End point 12 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT12 | 0xc   | End point 13 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT13 | 0xd   | End point 14 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT14 | 0xe   | End point 15 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT15 | 0xf   | End point 16 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  1
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT0     0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  2
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT1     0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  3
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT2     0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  4
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT3     0x3
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  5
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT4     0x4
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  6
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT5     0x5
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  7
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT6     0x6
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  8
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT7     0x7
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  9
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT8     0x8
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  10
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT9     0x9
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point 11
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT10    0xa
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point 12
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT11    0xb
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point 13
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT12    0xc
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point 14
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT13    0xd
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point 15
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT14    0xe
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point 16
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT15    0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPTXSTS_CHANENDPT register field. */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPTXSTS_CHANENDPT register field. */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_MSB        30
/* The width in bits of the ALT_USB_HOST_HPTXSTS_CHANENDPT register field. */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_WIDTH      4
/* The mask used to set the ALT_USB_HOST_HPTXSTS_CHANENDPT register field value. */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_SET_MSK    0x78000000
/* The mask used to clear the ALT_USB_HOST_HPTXSTS_CHANENDPT register field value. */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_CLR_MSK    0x87ffffff
/* The reset value of the ALT_USB_HOST_HPTXSTS_CHANENDPT register field. */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_RESET      0x0
/* Extracts the ALT_USB_HOST_HPTXSTS_CHANENDPT field value from a register. */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_GET(value) (((value) & 0x78000000) >> 27)
/* Produces a ALT_USB_HOST_HPTXSTS_CHANENDPT register field value suitable for setting the register. */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_SET(value) (((value) << 27) & 0x78000000)

/*
 * Field : Odd Even Micro Frame - oddevnmframe
 * 
 * This indicates the odd/even micro frame that is currently being processes by the
 * MAC.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description              
 * :---------------------------------------|:------|:--------------------------
 *  ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_E_EVEN | 0x0   | Send in even (micro)Frame
 *  ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_E_ODD  | 0x1   | Send in odd (micro)Frame 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_ODDEVNMFRM
 * 
 * Send in even (micro)Frame
 */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_E_EVEN  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_ODDEVNMFRM
 * 
 * Send in odd (micro)Frame
 */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_E_ODD   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPTXSTS_ODDEVNMFRM register field. */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPTXSTS_ODDEVNMFRM register field. */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_MSB        31
/* The width in bits of the ALT_USB_HOST_HPTXSTS_ODDEVNMFRM register field. */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPTXSTS_ODDEVNMFRM register field value. */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HPTXSTS_ODDEVNMFRM register field value. */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HPTXSTS_ODDEVNMFRM register field. */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_RESET      0x0
/* Extracts the ALT_USB_HOST_HPTXSTS_ODDEVNMFRM field value from a register. */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HPTXSTS_ODDEVNMFRM register field value suitable for setting the register. */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HPTXSTS.
 */
struct ALT_USB_HOST_HPTXSTS_s
{
    const uint32_t  ptxfspcavail : 16;  /* ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL */
    const uint32_t  ptxqspcavail :  8;  /* ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL */
    const uint32_t  term         :  1;  /* Terminate */
    const uint32_t  type         :  2;  /* Type */
    const uint32_t  chanendpt    :  4;  /* Channel Endpoint Number */
    const uint32_t  oddevnmframe :  1;  /* Odd Even Micro Frame */
};

/* The typedef declaration for register ALT_USB_HOST_HPTXSTS. */
typedef volatile struct ALT_USB_HOST_HPTXSTS_s  ALT_USB_HOST_HPTXSTS_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HPTXSTS register. */
#define ALT_USB_HOST_HPTXSTS_RESET       0x00102000
/* The byte offset of the ALT_USB_HOST_HPTXSTS register from the beginning of the component. */
#define ALT_USB_HOST_HPTXSTS_OFST        0x10
/* The address of the ALT_USB_HOST_HPTXSTS register. */
#define ALT_USB_HOST_HPTXSTS_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HPTXSTS_OFST))

/*
 * Register : haint
 * 
 * Host All Channels Interrupt Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description             
 * :--------|:-------|:------|:-------------------------
 *  [15:0]  | R      | 0x0   | ALT_USB_HOST_HAINT_HAINT
 *  [31:16] | ???    | 0x0   | *UNDEFINED*             
 * 
 */
/*
 * Field : haint
 * 
 * Channel Interrupt for channel no.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HAINT_HAINT register field. */
#define ALT_USB_HOST_HAINT_HAINT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HAINT_HAINT register field. */
#define ALT_USB_HOST_HAINT_HAINT_MSB        15
/* The width in bits of the ALT_USB_HOST_HAINT_HAINT register field. */
#define ALT_USB_HOST_HAINT_HAINT_WIDTH      16
/* The mask used to set the ALT_USB_HOST_HAINT_HAINT register field value. */
#define ALT_USB_HOST_HAINT_HAINT_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_HOST_HAINT_HAINT register field value. */
#define ALT_USB_HOST_HAINT_HAINT_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_HOST_HAINT_HAINT register field. */
#define ALT_USB_HOST_HAINT_HAINT_RESET      0x0
/* Extracts the ALT_USB_HOST_HAINT_HAINT field value from a register. */
#define ALT_USB_HOST_HAINT_HAINT_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_HOST_HAINT_HAINT register field value suitable for setting the register. */
#define ALT_USB_HOST_HAINT_HAINT_SET(value) (((value) << 0) & 0x0000ffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HAINT.
 */
struct ALT_USB_HOST_HAINT_s
{
    const uint32_t  haint : 16;  /* ALT_USB_HOST_HAINT_HAINT */
    uint32_t              : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HAINT. */
typedef volatile struct ALT_USB_HOST_HAINT_s  ALT_USB_HOST_HAINT_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HAINT register. */
#define ALT_USB_HOST_HAINT_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HAINT register from the beginning of the component. */
#define ALT_USB_HOST_HAINT_OFST        0x14
/* The address of the ALT_USB_HOST_HAINT register. */
#define ALT_USB_HOST_HAINT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HAINT_OFST))

/*
 * Register : haintmsk
 * 
 * Host All Channels Interrupt Mask Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                   
 * :--------|:-------|:------|:-------------------------------
 *  [15:0]  | RW     | 0x0   | ALT_USB_HOST_HAINTMSK_HAINTMSK
 *  [31:16] | ???    | 0x0   | *UNDEFINED*                   
 * 
 */
/*
 * Field : haintmsk
 * 
 * Channel Interrupt Msk for channel
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description     
 * :---------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HAINTMSK_HAINTMSK_E_MSK   | 0x0   | Mask interrupt  
 *  ALT_USB_HOST_HAINTMSK_HAINTMSK_E_NOMSK | 0x1   | Unmask interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HAINTMSK_HAINTMSK
 * 
 * Mask interrupt
 */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HAINTMSK_HAINTMSK
 * 
 * Unmask interrupt
 */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HAINTMSK_HAINTMSK register field. */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HAINTMSK_HAINTMSK register field. */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_MSB        15
/* The width in bits of the ALT_USB_HOST_HAINTMSK_HAINTMSK register field. */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_WIDTH      16
/* The mask used to set the ALT_USB_HOST_HAINTMSK_HAINTMSK register field value. */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_HOST_HAINTMSK_HAINTMSK register field value. */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_HOST_HAINTMSK_HAINTMSK register field. */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HAINTMSK_HAINTMSK field value from a register. */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_HOST_HAINTMSK_HAINTMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_SET(value) (((value) << 0) & 0x0000ffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HAINTMSK.
 */
struct ALT_USB_HOST_HAINTMSK_s
{
    uint32_t  haintmsk : 16;  /* ALT_USB_HOST_HAINTMSK_HAINTMSK */
    uint32_t           : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HAINTMSK. */
typedef volatile struct ALT_USB_HOST_HAINTMSK_s  ALT_USB_HOST_HAINTMSK_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HAINTMSK register. */
#define ALT_USB_HOST_HAINTMSK_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HAINTMSK register from the beginning of the component. */
#define ALT_USB_HOST_HAINTMSK_OFST        0x18
/* The address of the ALT_USB_HOST_HAINTMSK register. */
#define ALT_USB_HOST_HAINTMSK_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HAINTMSK_OFST))

/*
 * Register : hflbaddr
 * 
 * Host Frame List Base Address Register
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                   
 * :-------|:-------|:------|:-------------------------------
 *  [31:0] | RW     | 0x0   | ALT_USB_HOST_HFLBADDR_HFLBADDR
 * 
 */
/*
 * Field : hflbaddr
 * 
 * The starting address of the Frame list.
 * 
 * This register is used only for Isochronous and Interrupt Channels.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HFLBADDR_HFLBADDR register field. */
#define ALT_USB_HOST_HFLBADDR_HFLBADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HFLBADDR_HFLBADDR register field. */
#define ALT_USB_HOST_HFLBADDR_HFLBADDR_MSB        31
/* The width in bits of the ALT_USB_HOST_HFLBADDR_HFLBADDR register field. */
#define ALT_USB_HOST_HFLBADDR_HFLBADDR_WIDTH      32
/* The mask used to set the ALT_USB_HOST_HFLBADDR_HFLBADDR register field value. */
#define ALT_USB_HOST_HFLBADDR_HFLBADDR_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_HOST_HFLBADDR_HFLBADDR register field value. */
#define ALT_USB_HOST_HFLBADDR_HFLBADDR_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_HOST_HFLBADDR_HFLBADDR register field. */
#define ALT_USB_HOST_HFLBADDR_HFLBADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HFLBADDR_HFLBADDR field value from a register. */
#define ALT_USB_HOST_HFLBADDR_HFLBADDR_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_HOST_HFLBADDR_HFLBADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HFLBADDR_HFLBADDR_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HFLBADDR.
 */
struct ALT_USB_HOST_HFLBADDR_s
{
    uint32_t  hflbaddr : 32;  /* ALT_USB_HOST_HFLBADDR_HFLBADDR */
};

/* The typedef declaration for register ALT_USB_HOST_HFLBADDR. */
typedef volatile struct ALT_USB_HOST_HFLBADDR_s  ALT_USB_HOST_HFLBADDR_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HFLBADDR register. */
#define ALT_USB_HOST_HFLBADDR_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HFLBADDR register from the beginning of the component. */
#define ALT_USB_HOST_HFLBADDR_OFST        0x1c
/* The address of the ALT_USB_HOST_HFLBADDR register. */
#define ALT_USB_HOST_HFLBADDR_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HFLBADDR_OFST))

/*
 * Register : hprt
 * 
 * Host Port Control and Status Register
 * 
 * Register Layout
 * 
 *  Bits    | Access   | Reset | Description                     
 * :--------|:---------|:------|:---------------------------------
 *  [0]     | R        | 0x0   | ALT_USB_HOST_HPRT_PRTCONNSTS    
 *  [1]     | RW       | 0x0   | ALT_USB_HOST_HPRT_PRTCONNDET    
 *  [2]     | RW       | 0x0   | ALT_USB_HOST_HPRT_PRTENA        
 *  [3]     | RW       | 0x0   | ALT_USB_HOST_HPRT_PRTENCHNG     
 *  [4]     | R        | 0x0   | ALT_USB_HOST_HPRT_PRTOVRCURRACT 
 *  [5]     | RW       | 0x0   | ALT_USB_HOST_HPRT_PRTOVRCURRCHNG
 *  [6]     | RW       | 0x0   | ALT_USB_HOST_HPRT_PRTRES        
 *  [7]     | R-W once | 0x0   | ALT_USB_HOST_HPRT_PRTSUSP       
 *  [8]     | RW       | 0x0   | ALT_USB_HOST_HPRT_PRTRST        
 *  [9]     | ???      | 0x0   | *UNDEFINED*                     
 *  [11:10] | R        | 0x0   | ALT_USB_HOST_HPRT_PRTLNSTS      
 *  [12]    | RW       | 0x0   | ALT_USB_HOST_HPRT_PRTPWR        
 *  [16:13] | RW       | 0x0   | ALT_USB_HOST_HPRT_PRTTSTCTL     
 *  [18:17] | R        | 0x0   | ALT_USB_HOST_HPRT_PRTSPD        
 *  [31:19] | ???      | 0x0   | *UNDEFINED*                     
 * 
 */
/*
 * Field : prtconnsts
 * 
 * Port Connect Status (PrtConnSts)
 * 
 * 0: No device is attached to the port.
 * 
 * 1: A device is attached to the port.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                      
 * :-------------------------------------------|:------|:----------------------------------
 *  ALT_USB_HOST_HPRT_PRTCONNSTS_E_NOTATTACHED | 0x0   | No device is attached to the port
 *  ALT_USB_HOST_HPRT_PRTCONNSTS_E_ATTACHED    | 0x1   | A device is attached to the port 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTCONNSTS
 * 
 * No device is attached to the port
 */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_E_NOTATTACHED  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTCONNSTS
 * 
 * A device is attached to the port
 */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_E_ATTACHED     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTCONNSTS register field. */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTCONNSTS register field. */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_MSB        0
/* The width in bits of the ALT_USB_HOST_HPRT_PRTCONNSTS register field. */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTCONNSTS register field value. */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTCONNSTS register field value. */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_HOST_HPRT_PRTCONNSTS register field. */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTCONNSTS field value from a register. */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_HOST_HPRT_PRTCONNSTS register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : prtconndet
 * 
 * Port Connect Detected (PrtConnDet)
 * 
 * The core sets this bit when a device connection is detected
 * 
 * to trigger an interrupt to the application using the Host Port
 * 
 * Interrupt bit of the Core Interrupt register (GINTSTS.PrtInt).This bit can be
 * set only by the core and the application should write 1 to clear it.The
 * application must write a 1 to this bit to clear the
 * 
 * interrupt.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                  
 * :-------------------------------------|:------|:------------------------------
 *  ALT_USB_HOST_HPRT_PRTCONNDET_E_ACT   | 0x0   | Device connection detected   
 *  ALT_USB_HOST_HPRT_PRTCONNDET_E_INACT | 0x1   | No device connection detected
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTCONNDET
 * 
 * Device connection detected
 */
#define ALT_USB_HOST_HPRT_PRTCONNDET_E_ACT      0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTCONNDET
 * 
 * No device connection detected
 */
#define ALT_USB_HOST_HPRT_PRTCONNDET_E_INACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTCONNDET register field. */
#define ALT_USB_HOST_HPRT_PRTCONNDET_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTCONNDET register field. */
#define ALT_USB_HOST_HPRT_PRTCONNDET_MSB        1
/* The width in bits of the ALT_USB_HOST_HPRT_PRTCONNDET register field. */
#define ALT_USB_HOST_HPRT_PRTCONNDET_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTCONNDET register field value. */
#define ALT_USB_HOST_HPRT_PRTCONNDET_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTCONNDET register field value. */
#define ALT_USB_HOST_HPRT_PRTCONNDET_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_HOST_HPRT_PRTCONNDET register field. */
#define ALT_USB_HOST_HPRT_PRTCONNDET_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTCONNDET field value from a register. */
#define ALT_USB_HOST_HPRT_PRTCONNDET_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_HOST_HPRT_PRTCONNDET register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTCONNDET_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : prtena
 * 
 * Port Enable (PrtEna)
 * 
 * A port is enabled only by the core after a reset sequence,
 * 
 * and is disabled by an overcurrent condition, a disconnect
 * 
 * condition, or by the application clearing this bit. The
 * 
 * application cannot Set this bit by a register write. It can only
 * 
 * clear it to disable the port by writing 1.. This bit does not trigger any
 * 
 * interrupt to the application.
 * 
 * 1'b0: Port disabled
 * 
 * 1'b1: Port enabled
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description  
 * :--------------------------------|:------|:--------------
 *  ALT_USB_HOST_HPRT_PRTENA_E_DISD | 0x0   | Port disabled
 *  ALT_USB_HOST_HPRT_PRTENA_E_END  | 0x1   | Port enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTENA
 * 
 * Port disabled
 */
#define ALT_USB_HOST_HPRT_PRTENA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTENA
 * 
 * Port enabled
 */
#define ALT_USB_HOST_HPRT_PRTENA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTENA register field. */
#define ALT_USB_HOST_HPRT_PRTENA_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTENA register field. */
#define ALT_USB_HOST_HPRT_PRTENA_MSB        2
/* The width in bits of the ALT_USB_HOST_HPRT_PRTENA register field. */
#define ALT_USB_HOST_HPRT_PRTENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTENA register field value. */
#define ALT_USB_HOST_HPRT_PRTENA_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTENA register field value. */
#define ALT_USB_HOST_HPRT_PRTENA_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_HOST_HPRT_PRTENA register field. */
#define ALT_USB_HOST_HPRT_PRTENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTENA field value from a register. */
#define ALT_USB_HOST_HPRT_PRTENA_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_HOST_HPRT_PRTENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTENA_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : prtenchng
 * 
 * Port Enable/Disable Change (PrtEnChng)
 * 
 * The core sets this bit when the status of the Port Enable bit
 * 
 * [2] of this register changes.This bit can be set only by the core and the
 * application should write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                
 * :------------------------------------|:------|:----------------------------
 *  ALT_USB_HOST_HPRT_PRTENCHNG_E_INACT | 0x0   | Port Enable bit 2 no change
 *  ALT_USB_HOST_HPRT_PRTENCHNG_E_ACT   | 0x1   | Port Enable bit 2 changed  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTENCHNG
 * 
 * Port Enable bit 2 no change
 */
#define ALT_USB_HOST_HPRT_PRTENCHNG_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTENCHNG
 * 
 * Port Enable bit 2 changed
 */
#define ALT_USB_HOST_HPRT_PRTENCHNG_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTENCHNG register field. */
#define ALT_USB_HOST_HPRT_PRTENCHNG_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTENCHNG register field. */
#define ALT_USB_HOST_HPRT_PRTENCHNG_MSB        3
/* The width in bits of the ALT_USB_HOST_HPRT_PRTENCHNG register field. */
#define ALT_USB_HOST_HPRT_PRTENCHNG_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTENCHNG register field value. */
#define ALT_USB_HOST_HPRT_PRTENCHNG_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTENCHNG register field value. */
#define ALT_USB_HOST_HPRT_PRTENCHNG_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_HOST_HPRT_PRTENCHNG register field. */
#define ALT_USB_HOST_HPRT_PRTENCHNG_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTENCHNG field value from a register. */
#define ALT_USB_HOST_HPRT_PRTENCHNG_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_HOST_HPRT_PRTENCHNG register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTENCHNG_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : prtovrcurract
 * 
 * Port Overcurrent Active (PrtOvrCurrAct)
 * 
 * Indicates the overcurrent condition of the port.
 * 
 * 1'b0: No overcurrent condition
 * 
 * 1'b1: Overcurrent condition
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description             
 * :----------------------------------------|:------|:-------------------------
 *  ALT_USB_HOST_HPRT_PRTOVRCURRACT_E_INACT | 0x0   | No overcurrent condition
 *  ALT_USB_HOST_HPRT_PRTOVRCURRACT_E_ACT   | 0x1   | Overcurrent condition   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTOVRCURRACT
 * 
 * No overcurrent condition
 */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTOVRCURRACT
 * 
 * Overcurrent condition
 */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTOVRCURRACT register field. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTOVRCURRACT register field. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_MSB        4
/* The width in bits of the ALT_USB_HOST_HPRT_PRTOVRCURRACT register field. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTOVRCURRACT register field value. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTOVRCURRACT register field value. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_HOST_HPRT_PRTOVRCURRACT register field. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTOVRCURRACT field value from a register. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_HOST_HPRT_PRTOVRCURRACT register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : prtovrcurrchng
 * 
 * Port Overcurrent Change (PrtOvrCurrChng)
 * 
 * The core sets this bit when the status of the Port
 * 
 * Overcurrent Active bit (bit 4) in this register changes.This bit can be set only
 * by the core and the application should write 1 to clear it
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                         
 * :-----------------------------------------|:------|:-------------------------------------
 *  ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_E_INACT | 0x0   | Status of port overcurrent no change
 *  ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_E_ACT   | 0x1   | Status of port overcurrent changed  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTOVRCURRCHNG
 * 
 * Status of port overcurrent no change
 */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTOVRCURRCHNG
 * 
 * Status of port overcurrent changed
 */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTOVRCURRCHNG register field. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTOVRCURRCHNG register field. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_MSB        5
/* The width in bits of the ALT_USB_HOST_HPRT_PRTOVRCURRCHNG register field. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTOVRCURRCHNG register field value. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTOVRCURRCHNG register field value. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_HOST_HPRT_PRTOVRCURRCHNG register field. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTOVRCURRCHNG field value from a register. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_HOST_HPRT_PRTOVRCURRCHNG register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : prtres
 * 
 * Port Resume (PrtRes)
 * 
 * The application sets this bit to drive resume signaling on the
 * 
 * port. The core continues to drive the resume signal until the
 * 
 * application clears this bit.
 * 
 * If the core detects a USB remote wakeup sequence, as
 * 
 * indicated by the Port Resume/Remote Wakeup Detected
 * 
 * Interrupt bit of the Core Interrupt register
 * 
 * (GINTSTS.WkUpInt), the core starts driving resume
 * 
 * signaling without application intervention and clears this bit
 * 
 * when it detects a disconnect condition. The read value of
 * 
 * this bit indicates whether the core is currently driving
 * 
 * resume signaling.
 * 
 * 1'b0: No resume driven
 * 
 * 1'b1: Resume driven
 * 
 * When LPM is enabled, In L1 state the behavior of this bit is as follows:
 * 
 * The application sets this bit to drive resume signaling on the port.
 * 
 * The core continues to drive the resume signal until a pre-determined time
 * 
 * specified in GLPMCFG.HIRD_Thres[3:0] field. If the core detects a USB remote
 * 
 * wakeup sequence, as indicated by the Port L1Resume/Remote L1Wakeup Detected
 * 
 * Interrupt bit of the Core Interrupt register (GINTSTS.L1WkUpInt),
 * 
 * the core starts driving resume signaling without application intervention
 * 
 * and clears this bit at the end of resume.This bit can be set by both core or
 * application
 * 
 * and also cleared by core or application. This bit is cleared by the core even if
 * there is
 * 
 * no device connected to the Host.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description     
 * :------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HPRT_PRTRES_E_NORESUME | 0x0   | No resume driven
 *  ALT_USB_HOST_HPRT_PRTRES_E_RESUME   | 0x1   | Resume driven   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTRES
 * 
 * No resume driven
 */
#define ALT_USB_HOST_HPRT_PRTRES_E_NORESUME 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTRES
 * 
 * Resume driven
 */
#define ALT_USB_HOST_HPRT_PRTRES_E_RESUME   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTRES register field. */
#define ALT_USB_HOST_HPRT_PRTRES_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTRES register field. */
#define ALT_USB_HOST_HPRT_PRTRES_MSB        6
/* The width in bits of the ALT_USB_HOST_HPRT_PRTRES register field. */
#define ALT_USB_HOST_HPRT_PRTRES_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTRES register field value. */
#define ALT_USB_HOST_HPRT_PRTRES_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTRES register field value. */
#define ALT_USB_HOST_HPRT_PRTRES_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_HOST_HPRT_PRTRES register field. */
#define ALT_USB_HOST_HPRT_PRTRES_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTRES field value from a register. */
#define ALT_USB_HOST_HPRT_PRTRES_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_HOST_HPRT_PRTRES register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTRES_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : prtsusp
 * 
 * Port Suspend (PrtSusp)
 * 
 * The application sets this bit to put this port in Suspend
 * 
 * mode. The core only stops sending SOFs when this is Set.
 * 
 * To stop the PHY clock, the application must Set the Port
 * 
 * Clock Stop bit, which asserts the suspend input pin of the
 * 
 * PHY.
 * 
 * The read value of this bit reflects the current suspend status
 * 
 * of the port. This bit is cleared by the core after a remote
 * 
 * wakeup signal is detected or the application sets the Port
 * 
 * Reset bit or Port Resume bit in this register or the
 * 
 * Resume/Remote Wakeup Detected Interrupt bit or
 * 
 * Disconnect Detected Interrupt bit in the Core Interrupt
 * 
 * register (GINTSTS.WkUpInt or GINTSTS.DisconnInt,
 * 
 * respectively).This bit is cleared by the core even if there is
 * 
 * no device connected to the Host.
 * 
 * 1'b0: Port not in Suspend mode
 * 
 * 1'b1: Port in Suspend mode
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description             
 * :----------------------------------|:------|:-------------------------
 *  ALT_USB_HOST_HPRT_PRTSUSP_E_INACT | 0x0   | Port not in Suspend mode
 *  ALT_USB_HOST_HPRT_PRTSUSP_E_ACT   | 0x1   | Port in Suspend mode    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTSUSP
 * 
 * Port not in Suspend mode
 */
#define ALT_USB_HOST_HPRT_PRTSUSP_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTSUSP
 * 
 * Port in Suspend mode
 */
#define ALT_USB_HOST_HPRT_PRTSUSP_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTSUSP register field. */
#define ALT_USB_HOST_HPRT_PRTSUSP_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTSUSP register field. */
#define ALT_USB_HOST_HPRT_PRTSUSP_MSB        7
/* The width in bits of the ALT_USB_HOST_HPRT_PRTSUSP register field. */
#define ALT_USB_HOST_HPRT_PRTSUSP_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTSUSP register field value. */
#define ALT_USB_HOST_HPRT_PRTSUSP_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTSUSP register field value. */
#define ALT_USB_HOST_HPRT_PRTSUSP_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_HOST_HPRT_PRTSUSP register field. */
#define ALT_USB_HOST_HPRT_PRTSUSP_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTSUSP field value from a register. */
#define ALT_USB_HOST_HPRT_PRTSUSP_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_HOST_HPRT_PRTSUSP register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTSUSP_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : prtrst
 * 
 * Port Reset (PrtRst)
 * 
 * When the application sets this bit, a reset sequence is
 * 
 * started on this port. The application must time the reset
 * 
 * period and clear this bit after the reset sequence is
 * 
 * complete.
 * 
 * 1'b0: Port not in reset
 * 
 * 1'b1: Port in reset
 * 
 * The application must leave this bit Set For at least a
 * 
 * minimum duration mentioned below to start a reset on the
 * 
 * port. The application can leave it Set For another 10 ms in
 * 
 * addition to the required minimum duration, before clearing
 * 
 * the bit, even though there is no maximum limit Set by the
 * 
 * USB standard.This bit is cleared by the core even if there is
 * 
 * no device connected to the Host.
 * 
 * High speed: 50 ms
 * 
 * Full speed/Low speed: 10 ms
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description      
 * :--------------------------------|:------|:------------------
 *  ALT_USB_HOST_HPRT_PRTRST_E_DISD | 0x0   | Port not in reset
 *  ALT_USB_HOST_HPRT_PRTRST_E_END  | 0x1   | Port in reset    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTRST
 * 
 * Port not in reset
 */
#define ALT_USB_HOST_HPRT_PRTRST_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTRST
 * 
 * Port in reset
 */
#define ALT_USB_HOST_HPRT_PRTRST_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTRST register field. */
#define ALT_USB_HOST_HPRT_PRTRST_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTRST register field. */
#define ALT_USB_HOST_HPRT_PRTRST_MSB        8
/* The width in bits of the ALT_USB_HOST_HPRT_PRTRST register field. */
#define ALT_USB_HOST_HPRT_PRTRST_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTRST register field value. */
#define ALT_USB_HOST_HPRT_PRTRST_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTRST register field value. */
#define ALT_USB_HOST_HPRT_PRTRST_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_HOST_HPRT_PRTRST register field. */
#define ALT_USB_HOST_HPRT_PRTRST_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTRST field value from a register. */
#define ALT_USB_HOST_HPRT_PRTRST_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_HOST_HPRT_PRTRST register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTRST_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : prtlnsts
 * 
 * Port Line Status (PrtLnSts)
 * 
 * Indicates the current logic level USB data lines
 * 
 * Bit [10]: Logic level of D+
 * 
 * Bit [11]: Logic level of D-
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description      
 * :------------------------------------|:------|:------------------
 *  ALT_USB_HOST_HPRT_PRTLNSTS_E_PLUSD  | 0x1   | Logic level of D+
 *  ALT_USB_HOST_HPRT_PRTLNSTS_E_MINUSD | 0x2   | Logic level of D-
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTLNSTS
 * 
 * Logic level of D+
 */
#define ALT_USB_HOST_HPRT_PRTLNSTS_E_PLUSD  0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTLNSTS
 * 
 * Logic level of D-
 */
#define ALT_USB_HOST_HPRT_PRTLNSTS_E_MINUSD 0x2

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTLNSTS register field. */
#define ALT_USB_HOST_HPRT_PRTLNSTS_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTLNSTS register field. */
#define ALT_USB_HOST_HPRT_PRTLNSTS_MSB        11
/* The width in bits of the ALT_USB_HOST_HPRT_PRTLNSTS register field. */
#define ALT_USB_HOST_HPRT_PRTLNSTS_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HPRT_PRTLNSTS register field value. */
#define ALT_USB_HOST_HPRT_PRTLNSTS_SET_MSK    0x00000c00
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTLNSTS register field value. */
#define ALT_USB_HOST_HPRT_PRTLNSTS_CLR_MSK    0xfffff3ff
/* The reset value of the ALT_USB_HOST_HPRT_PRTLNSTS register field. */
#define ALT_USB_HOST_HPRT_PRTLNSTS_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTLNSTS field value from a register. */
#define ALT_USB_HOST_HPRT_PRTLNSTS_GET(value) (((value) & 0x00000c00) >> 10)
/* Produces a ALT_USB_HOST_HPRT_PRTLNSTS register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTLNSTS_SET(value) (((value) << 10) & 0x00000c00)

/*
 * Field : prtpwr
 * 
 * Port Power (PrtPwr)
 * 
 * The application uses this field to control power to this port (write 1'b1 to set
 * to 1'b1
 * 
 * and write 1'b0 to set to 1'b0), and the core can clear this bit on an over
 * current
 * 
 * condition.
 * 
 * 1'b0: Power off
 * 
 * 1'b1: Power on
 * 
 * Field Enumeration Values:
 * 
 *  Enum                           | Value | Description
 * :-------------------------------|:------|:------------
 *  ALT_USB_HOST_HPRT_PRTPWR_E_OFF | 0x0   | Power off  
 *  ALT_USB_HOST_HPRT_PRTPWR_E_ON  | 0x1   | Power on   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTPWR
 * 
 * Power off
 */
#define ALT_USB_HOST_HPRT_PRTPWR_E_OFF  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTPWR
 * 
 * Power on
 */
#define ALT_USB_HOST_HPRT_PRTPWR_E_ON   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTPWR register field. */
#define ALT_USB_HOST_HPRT_PRTPWR_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTPWR register field. */
#define ALT_USB_HOST_HPRT_PRTPWR_MSB        12
/* The width in bits of the ALT_USB_HOST_HPRT_PRTPWR register field. */
#define ALT_USB_HOST_HPRT_PRTPWR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTPWR register field value. */
#define ALT_USB_HOST_HPRT_PRTPWR_SET_MSK    0x00001000
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTPWR register field value. */
#define ALT_USB_HOST_HPRT_PRTPWR_CLR_MSK    0xffffefff
/* The reset value of the ALT_USB_HOST_HPRT_PRTPWR register field. */
#define ALT_USB_HOST_HPRT_PRTPWR_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTPWR field value from a register. */
#define ALT_USB_HOST_HPRT_PRTPWR_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_USB_HOST_HPRT_PRTPWR register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTPWR_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : prttstctl
 * 
 * Port Test Control (PrtTstCtl)
 * 
 * The application writes a nonzero value to this field to put the
 * 
 * port into a Test mode, and the corresponding pattern is
 * 
 * signaled on the port.
 * 
 * 4'b0000: Test mode disabled
 * 
 * 4'b0001: Test_J mode
 * 
 * 4'b0010: Test_K mode
 * 
 * 4'b0011: Test_SE0_NAK mode
 * 
 * 4'b0100: Test_Packet mode
 * 
 * 4'b0101: Test_Force_Enable
 * 
 * Others: Reserved
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description       
 * :---------------------------------------|:------|:-------------------
 *  ALT_USB_HOST_HPRT_PRTTSTCTL_E_DISD     | 0x0   | Test mode disabled
 *  ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTJ    | 0x1   | Test_J mode       
 *  ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTK    | 0x2   | Test_K mode       
 *  ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTSN   | 0x3   | Test_SE0_NAK mode 
 *  ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTPM   | 0x4   | Test_Packet mode  
 *  ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTFENB | 0x5   | Test_force_Enable 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTTSTCTL
 * 
 * Test mode disabled
 */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_E_DISD      0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTTSTCTL
 * 
 * Test_J mode
 */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTJ     0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTTSTCTL
 * 
 * Test_K mode
 */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTK     0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTTSTCTL
 * 
 * Test_SE0_NAK mode
 */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTSN    0x3
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTTSTCTL
 * 
 * Test_Packet mode
 */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTPM    0x4
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTTSTCTL
 * 
 * Test_force_Enable
 */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTFENB  0x5

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTTSTCTL register field. */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTTSTCTL register field. */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_MSB        16
/* The width in bits of the ALT_USB_HOST_HPRT_PRTTSTCTL register field. */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_WIDTH      4
/* The mask used to set the ALT_USB_HOST_HPRT_PRTTSTCTL register field value. */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_SET_MSK    0x0001e000
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTTSTCTL register field value. */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_CLR_MSK    0xfffe1fff
/* The reset value of the ALT_USB_HOST_HPRT_PRTTSTCTL register field. */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTTSTCTL field value from a register. */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_GET(value) (((value) & 0x0001e000) >> 13)
/* Produces a ALT_USB_HOST_HPRT_PRTTSTCTL register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_SET(value) (((value) << 13) & 0x0001e000)

/*
 * Field : prtspd
 * 
 * Port Speed (PrtSpd)
 * 
 * Indicates the speed of the device attached to this port.
 * 
 * 2'b00: High speed
 * 
 * 2'b01: Full speed
 * 
 * 2'b10: Low speed
 * 
 * 2'b11: Reserved
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description
 * :-----------------------------------|:------|:------------
 *  ALT_USB_HOST_HPRT_PRTSPD_E_HIGHSPD | 0x0   | High speed 
 *  ALT_USB_HOST_HPRT_PRTSPD_E_FULLSPD | 0x1   | Full speed 
 *  ALT_USB_HOST_HPRT_PRTSPD_E_LOWSPD  | 0x2   | Low speed  
 *  ALT_USB_HOST_HPRT_PRTSPD_E_RSVD    | 0x3   | Reserved   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTSPD
 * 
 * High speed
 */
#define ALT_USB_HOST_HPRT_PRTSPD_E_HIGHSPD  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTSPD
 * 
 * Full speed
 */
#define ALT_USB_HOST_HPRT_PRTSPD_E_FULLSPD  0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTSPD
 * 
 * Low speed
 */
#define ALT_USB_HOST_HPRT_PRTSPD_E_LOWSPD   0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTSPD
 * 
 * Reserved
 */
#define ALT_USB_HOST_HPRT_PRTSPD_E_RSVD     0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTSPD register field. */
#define ALT_USB_HOST_HPRT_PRTSPD_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTSPD register field. */
#define ALT_USB_HOST_HPRT_PRTSPD_MSB        18
/* The width in bits of the ALT_USB_HOST_HPRT_PRTSPD register field. */
#define ALT_USB_HOST_HPRT_PRTSPD_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HPRT_PRTSPD register field value. */
#define ALT_USB_HOST_HPRT_PRTSPD_SET_MSK    0x00060000
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTSPD register field value. */
#define ALT_USB_HOST_HPRT_PRTSPD_CLR_MSK    0xfff9ffff
/* The reset value of the ALT_USB_HOST_HPRT_PRTSPD register field. */
#define ALT_USB_HOST_HPRT_PRTSPD_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTSPD field value from a register. */
#define ALT_USB_HOST_HPRT_PRTSPD_GET(value) (((value) & 0x00060000) >> 17)
/* Produces a ALT_USB_HOST_HPRT_PRTSPD register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTSPD_SET(value) (((value) << 17) & 0x00060000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HPRT.
 */
struct ALT_USB_HOST_HPRT_s
{
    const uint32_t  prtconnsts     :  1;  /* ALT_USB_HOST_HPRT_PRTCONNSTS */
    uint32_t        prtconndet     :  1;  /* ALT_USB_HOST_HPRT_PRTCONNDET */
    uint32_t        prtena         :  1;  /* ALT_USB_HOST_HPRT_PRTENA */
    uint32_t        prtenchng      :  1;  /* ALT_USB_HOST_HPRT_PRTENCHNG */
    const uint32_t  prtovrcurract  :  1;  /* ALT_USB_HOST_HPRT_PRTOVRCURRACT */
    uint32_t        prtovrcurrchng :  1;  /* ALT_USB_HOST_HPRT_PRTOVRCURRCHNG */
    uint32_t        prtres         :  1;  /* ALT_USB_HOST_HPRT_PRTRES */
    uint32_t        prtsusp        :  1;  /* ALT_USB_HOST_HPRT_PRTSUSP */
    uint32_t        prtrst         :  1;  /* ALT_USB_HOST_HPRT_PRTRST */
    uint32_t                       :  1;  /* *UNDEFINED* */
    const uint32_t  prtlnsts       :  2;  /* ALT_USB_HOST_HPRT_PRTLNSTS */
    uint32_t        prtpwr         :  1;  /* ALT_USB_HOST_HPRT_PRTPWR */
    uint32_t        prttstctl      :  4;  /* ALT_USB_HOST_HPRT_PRTTSTCTL */
    const uint32_t  prtspd         :  2;  /* ALT_USB_HOST_HPRT_PRTSPD */
    uint32_t                       : 13;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HPRT. */
typedef volatile struct ALT_USB_HOST_HPRT_s  ALT_USB_HOST_HPRT_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HPRT register. */
#define ALT_USB_HOST_HPRT_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HPRT register from the beginning of the component. */
#define ALT_USB_HOST_HPRT_OFST        0x40
/* The address of the ALT_USB_HOST_HPRT register. */
#define ALT_USB_HOST_HPRT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HPRT_OFST))

/*
 * Register : hcchar0
 * 
 * Host Channel 0 Characteristics Register
 * 
 * Register Layout
 * 
 *  Bits    | Access   | Reset | Description                 
 * :--------|:---------|:------|:-----------------------------
 *  [10:0]  | RW       | 0x0   | ALT_USB_HOST_HCCHAR0_MPS    
 *  [14:11] | RW       | 0x0   | ALT_USB_HOST_HCCHAR0_EPNUM  
 *  [15]    | RW       | 0x0   | ALT_USB_HOST_HCCHAR0_EPDIR  
 *  [16]    | ???      | 0x0   | *UNDEFINED*                 
 *  [17]    | RW       | 0x0   | ALT_USB_HOST_HCCHAR0_LSPDDEV
 *  [19:18] | RW       | 0x0   | ALT_USB_HOST_HCCHAR0_EPTYPE 
 *  [21:20] | RW       | 0x0   | ALT_USB_HOST_HCCHAR0_EC     
 *  [28:22] | RW       | 0x0   | ALT_USB_HOST_HCCHAR0_DEVADDR
 *  [29]    | RW       | 0x0   | ALT_USB_HOST_HCCHAR0_ODDFRM 
 *  [30]    | R-W once | 0x0   | ALT_USB_HOST_HCCHAR0_CHDIS  
 *  [31]    | R-W once | 0x0   | ALT_USB_HOST_HCCHAR0_CHENA  
 * 
 */
/*
 * Field : mps
 * 
 * Maximum Packet Size (MPS)
 * 
 * Indicates the maximum packet size of the associated endpoint.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_MPS register field. */
#define ALT_USB_HOST_HCCHAR0_MPS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_MPS register field. */
#define ALT_USB_HOST_HCCHAR0_MPS_MSB        10
/* The width in bits of the ALT_USB_HOST_HCCHAR0_MPS register field. */
#define ALT_USB_HOST_HCCHAR0_MPS_WIDTH      11
/* The mask used to set the ALT_USB_HOST_HCCHAR0_MPS register field value. */
#define ALT_USB_HOST_HCCHAR0_MPS_SET_MSK    0x000007ff
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_MPS register field value. */
#define ALT_USB_HOST_HCCHAR0_MPS_CLR_MSK    0xfffff800
/* The reset value of the ALT_USB_HOST_HCCHAR0_MPS register field. */
#define ALT_USB_HOST_HCCHAR0_MPS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_MPS field value from a register. */
#define ALT_USB_HOST_HCCHAR0_MPS_GET(value) (((value) & 0x000007ff) >> 0)
/* Produces a ALT_USB_HOST_HCCHAR0_MPS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_MPS_SET(value) (((value) << 0) & 0x000007ff)

/*
 * Field : epnum
 * 
 * Endpoint Number (EPNum)
 * 
 * Indicates the endpoint number on the device serving as the data
 * 
 * source or sink.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description  
 * :-------------------------------------|:------|:--------------
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT0  | 0x0   | End point  0 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT1  | 0x1   | End point  1 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT2  | 0x2   | End point  2 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT3  | 0x3   | End point  3 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT4  | 0x4   | End point  4 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT5  | 0x5   | End point  5 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT6  | 0x6   | End point  6 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT7  | 0x7   | End point  7 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT8  | 0x8   | End point  8 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT9  | 0x9   | End point  9 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT10 | 0xa   | End point  10
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT11 | 0xb   | End point  11
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT12 | 0xc   | End point  12
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT13 | 0xd   | End point  13
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT14 | 0xe   | End point  14
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT15 | 0xf   | End point  15
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  0
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT0     0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  1
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT1     0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  2
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT2     0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  3
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT3     0x3
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  4
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT4     0x4
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  5
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT5     0x5
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  6
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT6     0x6
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  7
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT7     0x7
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  8
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT8     0x8
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  9
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT9     0x9
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  10
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT10    0xa
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  11
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT11    0xb
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  12
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT12    0xc
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  13
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT13    0xd
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  14
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT14    0xe
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  15
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT15    0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR0_EPNUM_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR0_EPNUM_MSB        14
/* The width in bits of the ALT_USB_HOST_HCCHAR0_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR0_EPNUM_WIDTH      4
/* The mask used to set the ALT_USB_HOST_HCCHAR0_EPNUM register field value. */
#define ALT_USB_HOST_HCCHAR0_EPNUM_SET_MSK    0x00007800
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_EPNUM register field value. */
#define ALT_USB_HOST_HCCHAR0_EPNUM_CLR_MSK    0xffff87ff
/* The reset value of the ALT_USB_HOST_HCCHAR0_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR0_EPNUM_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_EPNUM field value from a register. */
#define ALT_USB_HOST_HCCHAR0_EPNUM_GET(value) (((value) & 0x00007800) >> 11)
/* Produces a ALT_USB_HOST_HCCHAR0_EPNUM register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_EPNUM_SET(value) (((value) << 11) & 0x00007800)

/*
 * Field : epdir
 * 
 * Endpoint Direction (EPDir)
 * 
 * Indicates whether the transaction is IN or OUT.
 * 
 * 1'b0: OUT
 * 
 * 1'b1: IN
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description
 * :------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCCHAR0_EPDIR_E_OUTDIR | 0x0   | OUT        
 *  ALT_USB_HOST_HCCHAR0_EPDIR_E_INDIR  | 0x1   | IN         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPDIR
 * 
 * OUT
 */
#define ALT_USB_HOST_HCCHAR0_EPDIR_E_OUTDIR 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPDIR
 * 
 * IN
 */
#define ALT_USB_HOST_HCCHAR0_EPDIR_E_INDIR  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR0_EPDIR_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR0_EPDIR_MSB        15
/* The width in bits of the ALT_USB_HOST_HCCHAR0_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR0_EPDIR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR0_EPDIR register field value. */
#define ALT_USB_HOST_HCCHAR0_EPDIR_SET_MSK    0x00008000
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_EPDIR register field value. */
#define ALT_USB_HOST_HCCHAR0_EPDIR_CLR_MSK    0xffff7fff
/* The reset value of the ALT_USB_HOST_HCCHAR0_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR0_EPDIR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_EPDIR field value from a register. */
#define ALT_USB_HOST_HCCHAR0_EPDIR_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_USB_HOST_HCCHAR0_EPDIR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_EPDIR_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : lspddev
 * 
 * Low-Speed Device (LSpdDev)
 * 
 * This field is Set by the application to indicate that this channel is
 * 
 * communicating to a low-speed device.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                    
 * :-------------------------------------------|:------|:--------------------------------
 *  ALT_USB_HOST_HCCHAR0_LSPDDEV_E_NONLOWSPEED | 0x0   | Communicating with non lowspeed
 *  ALT_USB_HOST_HCCHAR0_LSPDDEV_E_LOWSPEED    | 0x1   | Communicating with lowspeed    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_LSPDDEV
 * 
 * Communicating with non lowspeed
 */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_E_NONLOWSPEED  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_LSPDDEV
 * 
 * Communicating with lowspeed
 */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_E_LOWSPEED     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_MSB        17
/* The width in bits of the ALT_USB_HOST_HCCHAR0_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR0_LSPDDEV register field value. */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_SET_MSK    0x00020000
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_LSPDDEV register field value. */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_CLR_MSK    0xfffdffff
/* The reset value of the ALT_USB_HOST_HCCHAR0_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_LSPDDEV field value from a register. */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_USB_HOST_HCCHAR0_LSPDDEV register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : eptype
 * 
 * Endpoint Type (EPType)
 * 
 * Indicates the transfer type selected.
 * 
 * 2'b00: Control
 * 
 * 2'b01: Isochronous
 * 
 * 2'b10: Bulk
 * 
 * 2'b11: Interrupt
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCCHAR0_EPTYPE_E_CTL    | 0x0   | Control    
 *  ALT_USB_HOST_HCCHAR0_EPTYPE_E_ISOC   | 0x1   | Isochronous
 *  ALT_USB_HOST_HCCHAR0_EPTYPE_E_BULK   | 0x2   | Bulk       
 *  ALT_USB_HOST_HCCHAR0_EPTYPE_E_INTERR | 0x3   | Interrupt  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPTYPE
 * 
 * Control
 */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_E_CTL       0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPTYPE
 * 
 * Isochronous
 */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_E_ISOC      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPTYPE
 * 
 * Bulk
 */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_E_BULK      0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPTYPE
 * 
 * Interrupt
 */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_E_INTERR    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_MSB        19
/* The width in bits of the ALT_USB_HOST_HCCHAR0_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCCHAR0_EPTYPE register field value. */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_SET_MSK    0x000c0000
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_EPTYPE register field value. */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_CLR_MSK    0xfff3ffff
/* The reset value of the ALT_USB_HOST_HCCHAR0_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_EPTYPE field value from a register. */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_GET(value) (((value) & 0x000c0000) >> 18)
/* Produces a ALT_USB_HOST_HCCHAR0_EPTYPE register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_SET(value) (((value) << 18) & 0x000c0000)

/*
 * Field : ec
 * 
 * Multi Count (MC) / Error Count (EC)
 * 
 * When the Split Enable bit of the Host Channel-n Split Control
 * 
 * register (HCSPLTn.SpltEna) is reset (1'b0), this field indicates to
 * 
 * the host the number of transactions that must be executed per
 * 
 * microframe For this periodic endpoint. For non periodic transfers,
 * 
 * this field is used only in DMA mode, and specifies the number
 * 
 * packets to be fetched For this channel before the internal DMA
 * 
 * engine changes arbitration.
 * 
 * 2'b00: Reserved This field yields undefined results.
 * 
 * 2'b01: 1 transaction
 * 
 * 2'b10: 2 transactions to be issued For this endpoint per
 * 
 * microframe
 * 
 * 2'b11: 3 transactions to be issued For this endpoint per
 * 
 * microframe
 * 
 * When HCSPLTn.SpltEna is Set (1'b1), this field indicates the
 * 
 * number of immediate retries to be performed For a periodic split
 * 
 * transactions on transaction errors. This field must be Set to at
 * 
 * least 2'b01.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                  
 * :-------------------------------------|:------|:----------------------------------------------
 *  ALT_USB_HOST_HCCHAR0_EC_E_RSVD       | 0x0   | Reserved This field yields undefined results 
 *  ALT_USB_HOST_HCCHAR0_EC_E_TRANSONE   | 0x1   | 1 transaction                                
 *  ALT_USB_HOST_HCCHAR0_EC_E_TRANSTWO   | 0x2   | 2 transactions to be issued for this endpoint
 * :                                     |       | per microframe                               
 *  ALT_USB_HOST_HCCHAR0_EC_E_TRANSTHREE | 0x3   | 3 transactions to be issued for this endpoint
 * :                                     |       | per microframe                               
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EC
 * 
 * Reserved This field yields undefined results
 */
#define ALT_USB_HOST_HCCHAR0_EC_E_RSVD          0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EC
 * 
 * 1 transaction
 */
#define ALT_USB_HOST_HCCHAR0_EC_E_TRANSONE      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EC
 * 
 * 2 transactions to be issued for this endpoint per microframe
 */
#define ALT_USB_HOST_HCCHAR0_EC_E_TRANSTWO      0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EC
 * 
 * 3 transactions to be issued for this endpoint per microframe
 */
#define ALT_USB_HOST_HCCHAR0_EC_E_TRANSTHREE    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_EC register field. */
#define ALT_USB_HOST_HCCHAR0_EC_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_EC register field. */
#define ALT_USB_HOST_HCCHAR0_EC_MSB        21
/* The width in bits of the ALT_USB_HOST_HCCHAR0_EC register field. */
#define ALT_USB_HOST_HCCHAR0_EC_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCCHAR0_EC register field value. */
#define ALT_USB_HOST_HCCHAR0_EC_SET_MSK    0x00300000
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_EC register field value. */
#define ALT_USB_HOST_HCCHAR0_EC_CLR_MSK    0xffcfffff
/* The reset value of the ALT_USB_HOST_HCCHAR0_EC register field. */
#define ALT_USB_HOST_HCCHAR0_EC_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_EC field value from a register. */
#define ALT_USB_HOST_HCCHAR0_EC_GET(value) (((value) & 0x00300000) >> 20)
/* Produces a ALT_USB_HOST_HCCHAR0_EC register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_EC_SET(value) (((value) << 20) & 0x00300000)

/*
 * Field : devaddr
 * 
 * Device Address (DevAddr)
 * 
 * This field selects the specific device serving as the data source
 * 
 * or sink.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR0_DEVADDR_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR0_DEVADDR_MSB        28
/* The width in bits of the ALT_USB_HOST_HCCHAR0_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR0_DEVADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCCHAR0_DEVADDR register field value. */
#define ALT_USB_HOST_HCCHAR0_DEVADDR_SET_MSK    0x1fc00000
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_DEVADDR register field value. */
#define ALT_USB_HOST_HCCHAR0_DEVADDR_CLR_MSK    0xe03fffff
/* The reset value of the ALT_USB_HOST_HCCHAR0_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR0_DEVADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_DEVADDR field value from a register. */
#define ALT_USB_HOST_HCCHAR0_DEVADDR_GET(value) (((value) & 0x1fc00000) >> 22)
/* Produces a ALT_USB_HOST_HCCHAR0_DEVADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_DEVADDR_SET(value) (((value) << 22) & 0x1fc00000)

/*
 * Field : oddfrm
 * 
 * Odd Frame (OddFrm)
 * 
 * This field is set (reset) by the application to indicate that the OTG host must
 * perform
 * 
 * a transfer in an odd (micro)frame. This field is applicable for only periodic
 * 
 * (isochronous and interrupt) transactions.
 * 
 * 1'b0: Even (micro)frame
 * 
 * 1'b1: Odd (micro)frame
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_ODDFRM register field. */
#define ALT_USB_HOST_HCCHAR0_ODDFRM_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_ODDFRM register field. */
#define ALT_USB_HOST_HCCHAR0_ODDFRM_MSB        29
/* The width in bits of the ALT_USB_HOST_HCCHAR0_ODDFRM register field. */
#define ALT_USB_HOST_HCCHAR0_ODDFRM_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR0_ODDFRM register field value. */
#define ALT_USB_HOST_HCCHAR0_ODDFRM_SET_MSK    0x20000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_ODDFRM register field value. */
#define ALT_USB_HOST_HCCHAR0_ODDFRM_CLR_MSK    0xdfffffff
/* The reset value of the ALT_USB_HOST_HCCHAR0_ODDFRM register field. */
#define ALT_USB_HOST_HCCHAR0_ODDFRM_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_ODDFRM field value from a register. */
#define ALT_USB_HOST_HCCHAR0_ODDFRM_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_USB_HOST_HCCHAR0_ODDFRM register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_ODDFRM_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : chdis
 * 
 * Channel Disable (ChDis)
 * 
 * The application sets this bit to stop transmitting/receiving data
 * 
 * on a channel, even before the transfer For that channel is
 * 
 * complete. The application must wait For the Channel Disabled
 * 
 * interrupt before treating the channel as disabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                     
 * :-----------------------------------|:------|:---------------------------------
 *  ALT_USB_HOST_HCCHAR0_CHDIS_E_INACT | 0x0   | No activity                     
 *  ALT_USB_HOST_HCCHAR0_CHDIS_E_ACT   | 0x1   | Stop transmitting/receiving data
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_CHDIS
 * 
 * No activity
 */
#define ALT_USB_HOST_HCCHAR0_CHDIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_CHDIS
 * 
 * Stop transmitting/receiving data
 */
#define ALT_USB_HOST_HCCHAR0_CHDIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR0_CHDIS_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR0_CHDIS_MSB        30
/* The width in bits of the ALT_USB_HOST_HCCHAR0_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR0_CHDIS_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR0_CHDIS register field value. */
#define ALT_USB_HOST_HCCHAR0_CHDIS_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_CHDIS register field value. */
#define ALT_USB_HOST_HCCHAR0_CHDIS_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_HOST_HCCHAR0_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR0_CHDIS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_CHDIS field value from a register. */
#define ALT_USB_HOST_HCCHAR0_CHDIS_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_HOST_HCCHAR0_CHDIS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_CHDIS_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : chena
 * 
 * Channel Enable (ChEna)
 * 
 * When Scatter/Gather mode is enabled
 * 
 * 1'b0: Indicates that the descriptor structure is not yet ready.
 * 
 * 1'b1:  Indicates  that  the  descriptor  structure  and  data  buffer  with
 * 
 * data is setup and this channel can access the descriptor.
 * 
 * When Scatter/Gather mode is disabled
 * 
 * This field is set by the application and cleared by the OTG host.
 * 
 * 1'b0: Channel disabled
 * 
 * 1'b1: Channel enabled
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                                     
 * :------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_HOST_HCCHAR0_CHENA_E_NOTRDY | 0x0   | Indicates that the descriptor structure is not  
 * :                                    |       | yet ready                                       
 *  ALT_USB_HOST_HCCHAR0_CHENA_E_RDY    | 0x1   | Indicates that the descriptor structure and data
 * :                                    |       | buffer with data is setup and this channel can  
 * :                                    |       | access the descriptor                           
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_CHENA
 * 
 * Indicates that the descriptor structure is not yet ready
 */
#define ALT_USB_HOST_HCCHAR0_CHENA_E_NOTRDY 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_CHENA
 * 
 * Indicates that the descriptor structure and data  buffer with data is setup and
 * this channel can access the descriptor
 */
#define ALT_USB_HOST_HCCHAR0_CHENA_E_RDY    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_CHENA register field. */
#define ALT_USB_HOST_HCCHAR0_CHENA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_CHENA register field. */
#define ALT_USB_HOST_HCCHAR0_CHENA_MSB        31
/* The width in bits of the ALT_USB_HOST_HCCHAR0_CHENA register field. */
#define ALT_USB_HOST_HCCHAR0_CHENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR0_CHENA register field value. */
#define ALT_USB_HOST_HCCHAR0_CHENA_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_CHENA register field value. */
#define ALT_USB_HOST_HCCHAR0_CHENA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCCHAR0_CHENA register field. */
#define ALT_USB_HOST_HCCHAR0_CHENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_CHENA field value from a register. */
#define ALT_USB_HOST_HCCHAR0_CHENA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCCHAR0_CHENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_CHENA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCCHAR0.
 */
struct ALT_USB_HOST_HCCHAR0_s
{
    uint32_t  mps     : 11;  /* ALT_USB_HOST_HCCHAR0_MPS */
    uint32_t  epnum   :  4;  /* ALT_USB_HOST_HCCHAR0_EPNUM */
    uint32_t  epdir   :  1;  /* ALT_USB_HOST_HCCHAR0_EPDIR */
    uint32_t          :  1;  /* *UNDEFINED* */
    uint32_t  lspddev :  1;  /* ALT_USB_HOST_HCCHAR0_LSPDDEV */
    uint32_t  eptype  :  2;  /* ALT_USB_HOST_HCCHAR0_EPTYPE */
    uint32_t  ec      :  2;  /* ALT_USB_HOST_HCCHAR0_EC */
    uint32_t  devaddr :  7;  /* ALT_USB_HOST_HCCHAR0_DEVADDR */
    uint32_t  oddfrm  :  1;  /* ALT_USB_HOST_HCCHAR0_ODDFRM */
    uint32_t  chdis   :  1;  /* ALT_USB_HOST_HCCHAR0_CHDIS */
    uint32_t  chena   :  1;  /* ALT_USB_HOST_HCCHAR0_CHENA */
};

/* The typedef declaration for register ALT_USB_HOST_HCCHAR0. */
typedef volatile struct ALT_USB_HOST_HCCHAR0_s  ALT_USB_HOST_HCCHAR0_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCCHAR0 register. */
#define ALT_USB_HOST_HCCHAR0_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCCHAR0 register from the beginning of the component. */
#define ALT_USB_HOST_HCCHAR0_OFST        0x100
/* The address of the ALT_USB_HOST_HCCHAR0 register. */
#define ALT_USB_HOST_HCCHAR0_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCCHAR0_OFST))

/*
 * Register : hcsplt0
 * 
 * Host Channel 0 Split Control Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                  
 * :--------|:-------|:------|:------------------------------
 *  [6:0]   | RW     | 0x0   | ALT_USB_HOST_HCSPLT0_PRTADDR 
 *  [13:7]  | RW     | 0x0   | ALT_USB_HOST_HCSPLT0_HUBADDR 
 *  [15:14] | RW     | 0x0   | ALT_USB_HOST_HCSPLT0_XACTPOS 
 *  [16]    | RW     | 0x0   | ALT_USB_HOST_HCSPLT0_COMPSPLT
 *  [30:17] | ???    | 0x0   | *UNDEFINED*                  
 *  [31]    | RW     | 0x0   | ALT_USB_HOST_HCSPLT0_SPLTENA 
 * 
 */
/*
 * Field : prtaddr
 * 
 * Port Address (PrtAddr)
 * 
 * This field is the port number of the recipient transaction
 * 
 * translator.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT0_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT0_PRTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT0_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT0_PRTADDR_MSB        6
/* The width in bits of the ALT_USB_HOST_HCSPLT0_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT0_PRTADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCSPLT0_PRTADDR register field value. */
#define ALT_USB_HOST_HCSPLT0_PRTADDR_SET_MSK    0x0000007f
/* The mask used to clear the ALT_USB_HOST_HCSPLT0_PRTADDR register field value. */
#define ALT_USB_HOST_HCSPLT0_PRTADDR_CLR_MSK    0xffffff80
/* The reset value of the ALT_USB_HOST_HCSPLT0_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT0_PRTADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT0_PRTADDR field value from a register. */
#define ALT_USB_HOST_HCSPLT0_PRTADDR_GET(value) (((value) & 0x0000007f) >> 0)
/* Produces a ALT_USB_HOST_HCSPLT0_PRTADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT0_PRTADDR_SET(value) (((value) << 0) & 0x0000007f)

/*
 * Field : hubaddr
 * 
 * Hub Address (HubAddr)
 * 
 * This field holds the device address of the transaction translator's
 * 
 * hub.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT0_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT0_HUBADDR_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT0_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT0_HUBADDR_MSB        13
/* The width in bits of the ALT_USB_HOST_HCSPLT0_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT0_HUBADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCSPLT0_HUBADDR register field value. */
#define ALT_USB_HOST_HCSPLT0_HUBADDR_SET_MSK    0x00003f80
/* The mask used to clear the ALT_USB_HOST_HCSPLT0_HUBADDR register field value. */
#define ALT_USB_HOST_HCSPLT0_HUBADDR_CLR_MSK    0xffffc07f
/* The reset value of the ALT_USB_HOST_HCSPLT0_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT0_HUBADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT0_HUBADDR field value from a register. */
#define ALT_USB_HOST_HCSPLT0_HUBADDR_GET(value) (((value) & 0x00003f80) >> 7)
/* Produces a ALT_USB_HOST_HCSPLT0_HUBADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT0_HUBADDR_SET(value) (((value) << 7) & 0x00003f80)

/*
 * Field : xactpos
 * 
 * Transaction Position (XactPos)
 * 
 * This field is used to determine whether to send all, first, middle,
 * 
 * or last payloads with each OUT transaction.
 * 
 * 2'b11: All. This is the entire data payload is of this transaction
 * 
 * (which is less than or equal to 188 bytes).
 * 
 * 2'b10: Begin. This is the first data payload of this transaction
 * 
 * (which is larger than 188 bytes).
 * 
 * 2'b00: Mid. This is the middle payload of this transaction
 * 
 * (which is larger than 188 bytes).
 * 
 * 2'b01: End. This is the last payload of this transaction (which
 * 
 * is larger than 188 bytes).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                    
 * :--------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_HOST_HCSPLT0_XACTPOS_E_MIDDLE | 0x0   | Mid. This is the middle payload of this        
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT0_XACTPOS_E_END    | 0x1   | End. This is the last payload of this          
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT0_XACTPOS_E_BEGIN  | 0x2   | Begin. This is the first data payload of this  
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT0_XACTPOS_E_ALL    | 0x3   | All. This is the entire data payload is of this
 * :                                      |       | transaction (which is less than or equal to 188
 * :                                      |       | bytes)                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT0_XACTPOS
 * 
 * Mid. This is the middle payload of this transaction (which is larger than 188
 * bytes)
 */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_E_MIDDLE   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT0_XACTPOS
 * 
 * End. This is the last payload of this transaction (which is larger than 188
 * bytes)
 */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_E_END      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT0_XACTPOS
 * 
 * Begin. This is the first data payload of this transaction (which is larger than
 * 188 bytes)
 */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_E_BEGIN    0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT0_XACTPOS
 * 
 * All. This is the entire data payload is of this transaction (which is less than
 * or equal to 188 bytes)
 */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_E_ALL      0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT0_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT0_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_MSB        15
/* The width in bits of the ALT_USB_HOST_HCSPLT0_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCSPLT0_XACTPOS register field value. */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_SET_MSK    0x0000c000
/* The mask used to clear the ALT_USB_HOST_HCSPLT0_XACTPOS register field value. */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_CLR_MSK    0xffff3fff
/* The reset value of the ALT_USB_HOST_HCSPLT0_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT0_XACTPOS field value from a register. */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_GET(value) (((value) & 0x0000c000) >> 14)
/* Produces a ALT_USB_HOST_HCSPLT0_XACTPOS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_SET(value) (((value) << 14) & 0x0000c000)

/*
 * Field : compsplt
 * 
 * Do Complete Split (CompSplt)
 * 
 * The application sets this field to request the OTG host to perform
 * 
 * a complete split transaction.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description         
 * :----------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCSPLT0_COMPSPLT_E_NOSPLIT | 0x0   | No split transaction
 *  ALT_USB_HOST_HCSPLT0_COMPSPLT_E_SPLIT   | 0x1   | Split transaction   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT0_COMPSPLT
 * 
 * No split transaction
 */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_E_NOSPLIT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT0_COMPSPLT
 * 
 * Split transaction
 */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_E_SPLIT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT0_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT0_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_MSB        16
/* The width in bits of the ALT_USB_HOST_HCSPLT0_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCSPLT0_COMPSPLT register field value. */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_SET_MSK    0x00010000
/* The mask used to clear the ALT_USB_HOST_HCSPLT0_COMPSPLT register field value. */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_CLR_MSK    0xfffeffff
/* The reset value of the ALT_USB_HOST_HCSPLT0_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT0_COMPSPLT field value from a register. */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_USB_HOST_HCSPLT0_COMPSPLT register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : spltena
 * 
 * Split Enable (SpltEna)
 * 
 * The application sets this field to indicate that this channel is
 * 
 * enabled to perform split transactions.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description      
 * :------------------------------------|:------|:------------------
 *  ALT_USB_HOST_HCSPLT0_SPLTENA_E_DISD | 0x0   | Split not enabled
 *  ALT_USB_HOST_HCSPLT0_SPLTENA_E_END  | 0x1   | Split enabled    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT0_SPLTENA
 * 
 * Split not enabled
 */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT0_SPLTENA
 * 
 * Split enabled
 */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT0_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT0_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_MSB        31
/* The width in bits of the ALT_USB_HOST_HCSPLT0_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCSPLT0_SPLTENA register field value. */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCSPLT0_SPLTENA register field value. */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCSPLT0_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT0_SPLTENA field value from a register. */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCSPLT0_SPLTENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCSPLT0.
 */
struct ALT_USB_HOST_HCSPLT0_s
{
    uint32_t  prtaddr  :  7;  /* ALT_USB_HOST_HCSPLT0_PRTADDR */
    uint32_t  hubaddr  :  7;  /* ALT_USB_HOST_HCSPLT0_HUBADDR */
    uint32_t  xactpos  :  2;  /* ALT_USB_HOST_HCSPLT0_XACTPOS */
    uint32_t  compsplt :  1;  /* ALT_USB_HOST_HCSPLT0_COMPSPLT */
    uint32_t           : 14;  /* *UNDEFINED* */
    uint32_t  spltena  :  1;  /* ALT_USB_HOST_HCSPLT0_SPLTENA */
};

/* The typedef declaration for register ALT_USB_HOST_HCSPLT0. */
typedef volatile struct ALT_USB_HOST_HCSPLT0_s  ALT_USB_HOST_HCSPLT0_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCSPLT0 register. */
#define ALT_USB_HOST_HCSPLT0_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCSPLT0 register from the beginning of the component. */
#define ALT_USB_HOST_HCSPLT0_OFST        0x104
/* The address of the ALT_USB_HOST_HCSPLT0 register. */
#define ALT_USB_HOST_HCSPLT0_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCSPLT0_OFST))

/*
 * Register : hcint0
 * 
 * Host Channel 0 Interrupt Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                          
 * :--------|:-------|:------|:--------------------------------------
 *  [0]     | RW     | 0x0   | ALT_USB_HOST_HCINT0_XFERCOMPL        
 *  [1]     | RW     | 0x0   | ALT_USB_HOST_HCINT0_CHHLTD           
 *  [2]     | RW     | 0x0   | ALT_USB_HOST_HCINT0_AHBERR           
 *  [3]     | RW     | 0x0   | ALT_USB_HOST_HCINT0_STALL            
 *  [4]     | RW     | 0x0   | ALT_USB_HOST_HCINT0_NAK              
 *  [5]     | RW     | 0x0   | ALT_USB_HOST_HCINT0_ACK              
 *  [6]     | RW     | 0x0   | ALT_USB_HOST_HCINT0_NYET             
 *  [7]     | RW     | 0x0   | ALT_USB_HOST_HCINT0_XACTERR          
 *  [8]     | RW     | 0x0   | ALT_USB_HOST_HCINT0_BBLERR           
 *  [9]     | RW     | 0x0   | ALT_USB_HOST_HCINT0_FRMOVRUN         
 *  [10]    | RW     | 0x0   | ALT_USB_HOST_HCINT0_DATATGLERR       
 *  [11]    | RW     | 0x0   | ALT_USB_HOST_HCINT0_BNAINTR          
 *  [12]    | RW     | 0x0   | ALT_USB_HOST_HCINT0_XCS_XACT_ERR     
 *  [13]    | RW     | 0x0   | ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR
 *  [31:14] | ???    | 0x0   | *UNDEFINED*                          
 * 
 */
/*
 * Field : xfercompl
 * 
 * Transfer Completed (XferCompl)
 * 
 * Transfer completed normally without any errors.This bit can be set only by the
 * core and the application should write 1 to clear it.
 * 
 * For Scatter/Gather DMA mode, it indicates that current descriptor processing got
 * 
 * completed with IOC bit set in its descriptor.
 * 
 * In non Scatter/Gather DMA mode, it indicates that Transfer completed normally
 * without
 * 
 * any errors.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                   
 * :--------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_HOST_HCINT0_XFERCOMPL_E_INACT | 0x0   | No transfer                                   
 *  ALT_USB_HOST_HCINT0_XFERCOMPL_E_ACT   | 0x1   | Transfer completed normally without any errors
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_XFERCOMPL
 * 
 * No transfer
 */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_XFERCOMPL
 * 
 * Transfer completed normally without any errors
 */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_MSB        0
/* The width in bits of the ALT_USB_HOST_HCINT0_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_XFERCOMPL register field value. */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_HOST_HCINT0_XFERCOMPL register field value. */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_HOST_HCINT0_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_XFERCOMPL field value from a register. */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_HOST_HCINT0_XFERCOMPL register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : chhltd
 * 
 * Channel Halted (ChHltd)
 * 
 * In non Scatter/Gather DMA mode, it indicates the transfer completed abnormally
 * either because of any USB transaction error or in response to disable request by
 * the application or because of a completed transfer.
 * 
 * in Scatter/gather DMA mode, this indicates that transfer completed due to any of
 * the following
 * 
 * . EOL being set in descriptor
 * 
 * . AHB error
 * 
 * . Excessive transaction errors
 * 
 * . Babble
 * 
 * . Stall
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description       
 * :-----------------------------------|:------|:-------------------
 *  ALT_USB_HOST_HCINT0_CHHLTD_E_INACT | 0x0   | Channel not halted
 *  ALT_USB_HOST_HCINT0_CHHLTD_E_ACT   | 0x1   | Channel Halted    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_CHHLTD
 * 
 * Channel not halted
 */
#define ALT_USB_HOST_HCINT0_CHHLTD_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_CHHLTD
 * 
 * Channel Halted
 */
#define ALT_USB_HOST_HCINT0_CHHLTD_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_CHHLTD register field. */
#define ALT_USB_HOST_HCINT0_CHHLTD_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_CHHLTD register field. */
#define ALT_USB_HOST_HCINT0_CHHLTD_MSB        1
/* The width in bits of the ALT_USB_HOST_HCINT0_CHHLTD register field. */
#define ALT_USB_HOST_HCINT0_CHHLTD_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_CHHLTD register field value. */
#define ALT_USB_HOST_HCINT0_CHHLTD_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_HOST_HCINT0_CHHLTD register field value. */
#define ALT_USB_HOST_HCINT0_CHHLTD_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_HOST_HCINT0_CHHLTD register field. */
#define ALT_USB_HOST_HCINT0_CHHLTD_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_CHHLTD field value from a register. */
#define ALT_USB_HOST_HCINT0_CHHLTD_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_HOST_HCINT0_CHHLTD register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_CHHLTD_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : ahberr
 * 
 * AHB Error (AHBErr)
 * 
 * This is generated only in Internal DMA mode when there is an
 * 
 * AHB error during AHB read/write. The application can read the
 * 
 * corresponding channel's DMA address register to get the error
 * 
 * address.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                    
 * :-----------------------------------|:------|:--------------------------------
 *  ALT_USB_HOST_HCINT0_AHBERR_E_INACT | 0x0   | No AHB error                   
 *  ALT_USB_HOST_HCINT0_AHBERR_E_ACT   | 0x1   | AHB error during AHB read/write
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_AHBERR
 * 
 * No AHB error
 */
#define ALT_USB_HOST_HCINT0_AHBERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_AHBERR
 * 
 * AHB error during AHB read/write
 */
#define ALT_USB_HOST_HCINT0_AHBERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_AHBERR register field. */
#define ALT_USB_HOST_HCINT0_AHBERR_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_AHBERR register field. */
#define ALT_USB_HOST_HCINT0_AHBERR_MSB        2
/* The width in bits of the ALT_USB_HOST_HCINT0_AHBERR register field. */
#define ALT_USB_HOST_HCINT0_AHBERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_AHBERR register field value. */
#define ALT_USB_HOST_HCINT0_AHBERR_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_HOST_HCINT0_AHBERR register field value. */
#define ALT_USB_HOST_HCINT0_AHBERR_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_HOST_HCINT0_AHBERR register field. */
#define ALT_USB_HOST_HCINT0_AHBERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_AHBERR field value from a register. */
#define ALT_USB_HOST_HCINT0_AHBERR_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_HOST_HCINT0_AHBERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_AHBERR_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : stall
 * 
 * STALL Response Received Interrupt (STALL)
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description       
 * :----------------------------------|:------|:-------------------
 *  ALT_USB_HOST_HCINT0_STALL_E_INACT | 0x0   | No Stall Interrupt
 *  ALT_USB_HOST_HCINT0_STALL_E_ACT   | 0x1   | Stall Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_STALL
 * 
 * No Stall Interrupt
 */
#define ALT_USB_HOST_HCINT0_STALL_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_STALL
 * 
 * Stall Interrupt
 */
#define ALT_USB_HOST_HCINT0_STALL_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_STALL register field. */
#define ALT_USB_HOST_HCINT0_STALL_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_STALL register field. */
#define ALT_USB_HOST_HCINT0_STALL_MSB        3
/* The width in bits of the ALT_USB_HOST_HCINT0_STALL register field. */
#define ALT_USB_HOST_HCINT0_STALL_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_STALL register field value. */
#define ALT_USB_HOST_HCINT0_STALL_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_HOST_HCINT0_STALL register field value. */
#define ALT_USB_HOST_HCINT0_STALL_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_HOST_HCINT0_STALL register field. */
#define ALT_USB_HOST_HCINT0_STALL_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_STALL field value from a register. */
#define ALT_USB_HOST_HCINT0_STALL_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_HOST_HCINT0_STALL register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_STALL_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : nak
 * 
 * NAK Response Received Interrupt (NAK)
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                       
 * :--------------------------------|:------|:-----------------------------------
 *  ALT_USB_HOST_HCINT0_NAK_E_INACT | 0x0   | No NAK Response Received Interrupt
 *  ALT_USB_HOST_HCINT0_NAK_E_ACT   | 0x1   | NAK Response Received Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_NAK
 * 
 * No NAK Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT0_NAK_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_NAK
 * 
 * NAK Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT0_NAK_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_NAK register field. */
#define ALT_USB_HOST_HCINT0_NAK_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_NAK register field. */
#define ALT_USB_HOST_HCINT0_NAK_MSB        4
/* The width in bits of the ALT_USB_HOST_HCINT0_NAK register field. */
#define ALT_USB_HOST_HCINT0_NAK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_NAK register field value. */
#define ALT_USB_HOST_HCINT0_NAK_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_HOST_HCINT0_NAK register field value. */
#define ALT_USB_HOST_HCINT0_NAK_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_HOST_HCINT0_NAK register field. */
#define ALT_USB_HOST_HCINT0_NAK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_NAK field value from a register. */
#define ALT_USB_HOST_HCINT0_NAK_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_HOST_HCINT0_NAK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_NAK_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : ack
 * 
 * ACK Response Received/Transmitted Interrupt (ACK)
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                                   
 * :--------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_HOST_HCINT0_ACK_E_INACT | 0x0   | No ACK Response Received Transmitted Interrupt
 *  ALT_USB_HOST_HCINT0_ACK_E_ACT   | 0x1   | ACK Response Received Transmitted Interrup    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_ACK
 * 
 * No ACK Response Received Transmitted Interrupt
 */
#define ALT_USB_HOST_HCINT0_ACK_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_ACK
 * 
 * ACK Response Received Transmitted Interrup
 */
#define ALT_USB_HOST_HCINT0_ACK_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_ACK register field. */
#define ALT_USB_HOST_HCINT0_ACK_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_ACK register field. */
#define ALT_USB_HOST_HCINT0_ACK_MSB        5
/* The width in bits of the ALT_USB_HOST_HCINT0_ACK register field. */
#define ALT_USB_HOST_HCINT0_ACK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_ACK register field value. */
#define ALT_USB_HOST_HCINT0_ACK_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_HOST_HCINT0_ACK register field value. */
#define ALT_USB_HOST_HCINT0_ACK_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_HOST_HCINT0_ACK register field. */
#define ALT_USB_HOST_HCINT0_ACK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_ACK field value from a register. */
#define ALT_USB_HOST_HCINT0_ACK_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_HOST_HCINT0_ACK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_ACK_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : nyet
 * 
 * NYET Response Received Interrupt (NYET)
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                        
 * :---------------------------------|:------|:------------------------------------
 *  ALT_USB_HOST_HCINT0_NYET_E_INACT | 0x0   | No NYET Response Received Interrupt
 *  ALT_USB_HOST_HCINT0_NYET_E_ACT   | 0x1   | NYET Response Received Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_NYET
 * 
 * No NYET Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT0_NYET_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_NYET
 * 
 * NYET Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT0_NYET_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_NYET register field. */
#define ALT_USB_HOST_HCINT0_NYET_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_NYET register field. */
#define ALT_USB_HOST_HCINT0_NYET_MSB        6
/* The width in bits of the ALT_USB_HOST_HCINT0_NYET register field. */
#define ALT_USB_HOST_HCINT0_NYET_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_NYET register field value. */
#define ALT_USB_HOST_HCINT0_NYET_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_HOST_HCINT0_NYET register field value. */
#define ALT_USB_HOST_HCINT0_NYET_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_HOST_HCINT0_NYET register field. */
#define ALT_USB_HOST_HCINT0_NYET_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_NYET field value from a register. */
#define ALT_USB_HOST_HCINT0_NYET_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_HOST_HCINT0_NYET register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_NYET_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : xacterr
 * 
 * Transaction Error (XactErr)
 * 
 * Indicates one of the following errors occurred on the USB.
 * 
 * CRC check failure
 * 
 * Timeout
 * 
 * Bit stuff error
 * 
 * False EOP
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description         
 * :------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCINT0_XACTERR_E_INACT | 0x0   | No Transaction Error
 *  ALT_USB_HOST_HCINT0_XACTERR_E_ACT   | 0x1   | Transaction Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_XACTERR
 * 
 * No Transaction Error
 */
#define ALT_USB_HOST_HCINT0_XACTERR_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_XACTERR
 * 
 * Transaction Error
 */
#define ALT_USB_HOST_HCINT0_XACTERR_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_XACTERR register field. */
#define ALT_USB_HOST_HCINT0_XACTERR_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_XACTERR register field. */
#define ALT_USB_HOST_HCINT0_XACTERR_MSB        7
/* The width in bits of the ALT_USB_HOST_HCINT0_XACTERR register field. */
#define ALT_USB_HOST_HCINT0_XACTERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_XACTERR register field value. */
#define ALT_USB_HOST_HCINT0_XACTERR_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_HOST_HCINT0_XACTERR register field value. */
#define ALT_USB_HOST_HCINT0_XACTERR_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_HOST_HCINT0_XACTERR register field. */
#define ALT_USB_HOST_HCINT0_XACTERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_XACTERR field value from a register. */
#define ALT_USB_HOST_HCINT0_XACTERR_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_HOST_HCINT0_XACTERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_XACTERR_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : bblerr
 * 
 * Babble Error (BblErr)
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core..This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description    
 * :-----------------------------------|:------|:----------------
 *  ALT_USB_HOST_HCINT0_BBLERR_E_INACT | 0x0   | No Babble Error
 *  ALT_USB_HOST_HCINT0_BBLERR_E_ACT   | 0x1   | Babble Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_BBLERR
 * 
 * No Babble Error
 */
#define ALT_USB_HOST_HCINT0_BBLERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_BBLERR
 * 
 * Babble Error
 */
#define ALT_USB_HOST_HCINT0_BBLERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_BBLERR register field. */
#define ALT_USB_HOST_HCINT0_BBLERR_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_BBLERR register field. */
#define ALT_USB_HOST_HCINT0_BBLERR_MSB        8
/* The width in bits of the ALT_USB_HOST_HCINT0_BBLERR register field. */
#define ALT_USB_HOST_HCINT0_BBLERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_BBLERR register field value. */
#define ALT_USB_HOST_HCINT0_BBLERR_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_HOST_HCINT0_BBLERR register field value. */
#define ALT_USB_HOST_HCINT0_BBLERR_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_HOST_HCINT0_BBLERR register field. */
#define ALT_USB_HOST_HCINT0_BBLERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_BBLERR field value from a register. */
#define ALT_USB_HOST_HCINT0_BBLERR_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_HOST_HCINT0_BBLERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_BBLERR_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : frmovrun
 * 
 * Frame Overrun (FrmOvrun).In Scatter/Gather DMA mode, the interrupt due to this
 * bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description     
 * :-------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCINT0_FRMOVRUN_E_INACT | 0x0   | No Frame Overrun
 *  ALT_USB_HOST_HCINT0_FRMOVRUN_E_ACT   | 0x1   | Frame Overrun   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_FRMOVRUN
 * 
 * No Frame Overrun
 */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_FRMOVRUN
 * 
 * Frame Overrun
 */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_MSB        9
/* The width in bits of the ALT_USB_HOST_HCINT0_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_FRMOVRUN register field value. */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_SET_MSK    0x00000200
/* The mask used to clear the ALT_USB_HOST_HCINT0_FRMOVRUN register field value. */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_CLR_MSK    0xfffffdff
/* The reset value of the ALT_USB_HOST_HCINT0_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_FRMOVRUN field value from a register. */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_USB_HOST_HCINT0_FRMOVRUN register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : datatglerr
 * 
 * Data Toggle Error (DataTglErr).This bit can be set only by the core and the
 * application should write 1 to clear
 * 
 * it.In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description         
 * :---------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCINT0_DATATGLERR_E_INACT | 0x0   | No Data Toggle Error
 *  ALT_USB_HOST_HCINT0_DATATGLERR_E_ACT   | 0x1   | Data Toggle Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_DATATGLERR
 * 
 * No Data Toggle Error
 */
#define ALT_USB_HOST_HCINT0_DATATGLERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_DATATGLERR
 * 
 * Data Toggle Error
 */
#define ALT_USB_HOST_HCINT0_DATATGLERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT0_DATATGLERR_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT0_DATATGLERR_MSB        10
/* The width in bits of the ALT_USB_HOST_HCINT0_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT0_DATATGLERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_DATATGLERR register field value. */
#define ALT_USB_HOST_HCINT0_DATATGLERR_SET_MSK    0x00000400
/* The mask used to clear the ALT_USB_HOST_HCINT0_DATATGLERR register field value. */
#define ALT_USB_HOST_HCINT0_DATATGLERR_CLR_MSK    0xfffffbff
/* The reset value of the ALT_USB_HOST_HCINT0_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT0_DATATGLERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_DATATGLERR field value from a register. */
#define ALT_USB_HOST_HCINT0_DATATGLERR_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_USB_HOST_HCINT0_DATATGLERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_DATATGLERR_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : bnaintr
 * 
 * BNA (Buffer Not Available) Interrupt (BNAIntr)
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled.
 * 
 * The core generates this interrupt when the descriptor accessed
 * 
 * is not ready for the Core to process. BNA will not be generated
 * 
 * for Isochronous channels.
 * 
 * For non Scatter/Gather DMA mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description     
 * :------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCINT0_BNAINTR_E_INACT | 0x0   | No BNA Interrupt
 *  ALT_USB_HOST_HCINT0_BNAINTR_E_ACT   | 0x1   | BNA Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_BNAINTR
 * 
 * No BNA Interrupt
 */
#define ALT_USB_HOST_HCINT0_BNAINTR_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_BNAINTR
 * 
 * BNA Interrupt
 */
#define ALT_USB_HOST_HCINT0_BNAINTR_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_BNAINTR register field. */
#define ALT_USB_HOST_HCINT0_BNAINTR_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_BNAINTR register field. */
#define ALT_USB_HOST_HCINT0_BNAINTR_MSB        11
/* The width in bits of the ALT_USB_HOST_HCINT0_BNAINTR register field. */
#define ALT_USB_HOST_HCINT0_BNAINTR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_BNAINTR register field value. */
#define ALT_USB_HOST_HCINT0_BNAINTR_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_HOST_HCINT0_BNAINTR register field value. */
#define ALT_USB_HOST_HCINT0_BNAINTR_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_HOST_HCINT0_BNAINTR register field. */
#define ALT_USB_HOST_HCINT0_BNAINTR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_BNAINTR field value from a register. */
#define ALT_USB_HOST_HCINT0_BNAINTR_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_HOST_HCINT0_BNAINTR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_BNAINTR_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : xcs_xact_err
 * 
 * Excessive Transaction Error (XCS_XACT_ERR)
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled. The core sets
 * this bit
 * 
 * when 3 consecutive transaction errors occurred on the USB bus. XCS_XACT_ERR will
 * 
 * not be generated for Isochronous channels.
 * 
 * For non Scatter/Gather DMA mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                   
 * :-------------------------------------------|:------|:-------------------------------
 *  ALT_USB_HOST_HCINT0_XCS_XACT_ERR_E_INACT   | 0x0   | No Excessive Transaction Error
 *  ALT_USB_HOST_HCINT0_XCS_XACT_ERR_E_ACVTIVE | 0x1   | Excessive Transaction Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_XCS_XACT_ERR
 * 
 * No Excessive Transaction Error
 */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_XCS_XACT_ERR
 * 
 * Excessive Transaction Error
 */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_E_ACVTIVE  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_MSB        12
/* The width in bits of the ALT_USB_HOST_HCINT0_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_XCS_XACT_ERR register field value. */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_SET_MSK    0x00001000
/* The mask used to clear the ALT_USB_HOST_HCINT0_XCS_XACT_ERR register field value. */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_CLR_MSK    0xffffefff
/* The reset value of the ALT_USB_HOST_HCINT0_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_XCS_XACT_ERR field value from a register. */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_USB_HOST_HCINT0_XCS_XACT_ERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : desc_lst_rollintr
 * 
 * Descriptor rollover interrupt (DESC_LST_ROLLIntr)
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled. The core sets
 * this bit
 * 
 * when the corresponding channel's descriptor list rolls over.
 * 
 * For non Scatter/Gather DMA mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                     
 * :----------------------------------------------|:------|:---------------------------------
 *  ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_E_INACT | 0x0   | No Descriptor rollover interrupt
 *  ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_E_ACT   | 0x1   | Descriptor rollover interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR
 * 
 * No Descriptor rollover interrupt
 */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR
 * 
 * Descriptor rollover interrupt
 */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_MSB        13
/* The width in bits of the ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR register field value. */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR register field value. */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR field value from a register. */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_SET(value) (((value) << 13) & 0x00002000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCINT0.
 */
struct ALT_USB_HOST_HCINT0_s
{
    uint32_t  xfercompl         :  1;  /* ALT_USB_HOST_HCINT0_XFERCOMPL */
    uint32_t  chhltd            :  1;  /* ALT_USB_HOST_HCINT0_CHHLTD */
    uint32_t  ahberr            :  1;  /* ALT_USB_HOST_HCINT0_AHBERR */
    uint32_t  stall             :  1;  /* ALT_USB_HOST_HCINT0_STALL */
    uint32_t  nak               :  1;  /* ALT_USB_HOST_HCINT0_NAK */
    uint32_t  ack               :  1;  /* ALT_USB_HOST_HCINT0_ACK */
    uint32_t  nyet              :  1;  /* ALT_USB_HOST_HCINT0_NYET */
    uint32_t  xacterr           :  1;  /* ALT_USB_HOST_HCINT0_XACTERR */
    uint32_t  bblerr            :  1;  /* ALT_USB_HOST_HCINT0_BBLERR */
    uint32_t  frmovrun          :  1;  /* ALT_USB_HOST_HCINT0_FRMOVRUN */
    uint32_t  datatglerr        :  1;  /* ALT_USB_HOST_HCINT0_DATATGLERR */
    uint32_t  bnaintr           :  1;  /* ALT_USB_HOST_HCINT0_BNAINTR */
    uint32_t  xcs_xact_err      :  1;  /* ALT_USB_HOST_HCINT0_XCS_XACT_ERR */
    uint32_t  desc_lst_rollintr :  1;  /* ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR */
    uint32_t                    : 18;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HCINT0. */
typedef volatile struct ALT_USB_HOST_HCINT0_s  ALT_USB_HOST_HCINT0_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCINT0 register. */
#define ALT_USB_HOST_HCINT0_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCINT0 register from the beginning of the component. */
#define ALT_USB_HOST_HCINT0_OFST        0x108
/* The address of the ALT_USB_HOST_HCINT0 register. */
#define ALT_USB_HOST_HCINT0_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCINT0_OFST))

/*
 * Register : hcintmsk0
 * 
 * Host Channel 0 Interrupt Mask Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                               
 * :--------|:-------|:------|:-------------------------------------------
 *  [0]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK       
 *  [1]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK0_CHHLTDMSK          
 *  [2]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK0_AHBERRMSK          
 *  [3]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK0_STALLMSK           
 *  [4]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK0_NAKMSK             
 *  [5]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK0_ACKMSK             
 *  [6]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK0_NYETMSK            
 *  [7]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK0_XACTERRMSK         
 *  [8]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK0_BBLERRMSK          
 *  [9]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK        
 *  [10]    | RW     | 0x0   | ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK      
 *  [11]    | RW     | 0x0   | ALT_USB_HOST_HCINTMSK0_BNAINTRMSK         
 *  [12]    | ???    | 0x0   | *UNDEFINED*                               
 *  [13]    | RW     | 0x0   | ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK
 *  [31:14] | ???    | 0x0   | *UNDEFINED*                               
 * 
 */
/*
 * Field : xfercomplmsk
 * 
 * Transfer Completed Mask (XferComplMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description
 * :--------------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_MSB        0
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : chhltdmsk
 * 
 * Channel Halted Mask (ChHltdMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_CHHLTDMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_CHHLTDMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_MSB        1
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_CHHLTDMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_CHHLTDMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_HOST_HCINTMSK0_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_CHHLTDMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_HOST_HCINTMSK0_CHHLTDMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : ahberrmsk
 * 
 * AHB Error Mask (AHBErrMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK0_AHBERRMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK0_AHBERRMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_AHBERRMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_AHBERRMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_MSB        2
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_AHBERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_AHBERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_HOST_HCINTMSK0_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_AHBERRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_HOST_HCINTMSK0_AHBERRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : stallmsk
 * 
 * STALL Response Received Interrupt Mask (StallMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_STALLMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_STALLMSK_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_STALLMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_STALLMSK_MSB        3
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_STALLMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_STALLMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_STALLMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_STALLMSK_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_STALLMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_STALLMSK_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_HOST_HCINTMSK0_STALLMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_STALLMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_STALLMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_STALLMSK_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_HOST_HCINTMSK0_STALLMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_STALLMSK_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : nakmsk
 * 
 * NAK Response Received Interrupt Mask (NakMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_NAKMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_NAKMSK_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_NAKMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_NAKMSK_MSB        4
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_NAKMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_NAKMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_NAKMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_NAKMSK_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_NAKMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_NAKMSK_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_HOST_HCINTMSK0_NAKMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_NAKMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_NAKMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_NAKMSK_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_HOST_HCINTMSK0_NAKMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_NAKMSK_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : ackmsk
 * 
 * ACK Response Received/Transmitted Interrupt Mask (AckMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_ACKMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_ACKMSK_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_ACKMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_ACKMSK_MSB        5
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_ACKMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_ACKMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_ACKMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_ACKMSK_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_ACKMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_ACKMSK_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_HOST_HCINTMSK0_ACKMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_ACKMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_ACKMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_ACKMSK_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_HOST_HCINTMSK0_ACKMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_ACKMSK_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : nyetmsk
 * 
 * NYET Response Received Interrupt Mask (NyetMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_NYETMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_NYETMSK_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_NYETMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_NYETMSK_MSB        6
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_NYETMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_NYETMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_NYETMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_NYETMSK_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_NYETMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_NYETMSK_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_HOST_HCINTMSK0_NYETMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_NYETMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_NYETMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_NYETMSK_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_HOST_HCINTMSK0_NYETMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_NYETMSK_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : xacterrmsk
 * 
 * Transaction Error Mask (XactErrMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_XACTERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_XACTERRMSK_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_XACTERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_XACTERRMSK_MSB        7
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_XACTERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_XACTERRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_XACTERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_XACTERRMSK_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_XACTERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_XACTERRMSK_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_HOST_HCINTMSK0_XACTERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_XACTERRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_XACTERRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_XACTERRMSK_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_HOST_HCINTMSK0_XACTERRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_XACTERRMSK_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : bblerrmsk
 * 
 * Babble Error Mask (BblErrMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_BBLERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_BBLERRMSK_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_BBLERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_BBLERRMSK_MSB        8
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_BBLERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_BBLERRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_BBLERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_BBLERRMSK_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_BBLERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_BBLERRMSK_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_HOST_HCINTMSK0_BBLERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_BBLERRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_BBLERRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_BBLERRMSK_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_HOST_HCINTMSK0_BBLERRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_BBLERRMSK_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : frmovrunmsk
 * 
 * Frame Overrun Mask (FrmOvrunMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK_MSB        9
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK_SET_MSK    0x00000200
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK_CLR_MSK    0xfffffdff
/* The reset value of the ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : datatglerrmsk
 * 
 * Data Toggle Error Mask (DataTglErrMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK_MSB        10
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK_SET_MSK    0x00000400
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK_CLR_MSK    0xfffffbff
/* The reset value of the ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : bnaintrmsk
 * 
 * BNA  (Buffer  Not  Available)  Interrupt  mask  register  (BNAIntrMsk)
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_BNAINTRMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_E_MSK     0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_BNAINTRMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_E_NOMSK   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_MSB        11
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_BNAINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_BNAINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_HOST_HCINTMSK0_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_BNAINTRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_HOST_HCINTMSK0_BNAINTRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : frm_lst_rollintrmsk
 * 
 * Framelist rollover interrupt Mask register(FRM_LST_ROLLIntrMsk)
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description
 * :---------------------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_MSB        13
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_SET(value) (((value) << 13) & 0x00002000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCINTMSK0.
 */
struct ALT_USB_HOST_HCINTMSK0_s
{
    uint32_t  xfercomplmsk        :  1;  /* ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK */
    uint32_t  chhltdmsk           :  1;  /* ALT_USB_HOST_HCINTMSK0_CHHLTDMSK */
    uint32_t  ahberrmsk           :  1;  /* ALT_USB_HOST_HCINTMSK0_AHBERRMSK */
    uint32_t  stallmsk            :  1;  /* ALT_USB_HOST_HCINTMSK0_STALLMSK */
    uint32_t  nakmsk              :  1;  /* ALT_USB_HOST_HCINTMSK0_NAKMSK */
    uint32_t  ackmsk              :  1;  /* ALT_USB_HOST_HCINTMSK0_ACKMSK */
    uint32_t  nyetmsk             :  1;  /* ALT_USB_HOST_HCINTMSK0_NYETMSK */
    uint32_t  xacterrmsk          :  1;  /* ALT_USB_HOST_HCINTMSK0_XACTERRMSK */
    uint32_t  bblerrmsk           :  1;  /* ALT_USB_HOST_HCINTMSK0_BBLERRMSK */
    uint32_t  frmovrunmsk         :  1;  /* ALT_USB_HOST_HCINTMSK0_FRMOVRUNMSK */
    uint32_t  datatglerrmsk       :  1;  /* ALT_USB_HOST_HCINTMSK0_DATATGLERRMSK */
    uint32_t  bnaintrmsk          :  1;  /* ALT_USB_HOST_HCINTMSK0_BNAINTRMSK */
    uint32_t                      :  1;  /* *UNDEFINED* */
    uint32_t  frm_lst_rollintrmsk :  1;  /* ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK */
    uint32_t                      : 18;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HCINTMSK0. */
typedef volatile struct ALT_USB_HOST_HCINTMSK0_s  ALT_USB_HOST_HCINTMSK0_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCINTMSK0 register. */
#define ALT_USB_HOST_HCINTMSK0_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCINTMSK0 register from the beginning of the component. */
#define ALT_USB_HOST_HCINTMSK0_OFST        0x10c
/* The address of the ALT_USB_HOST_HCINTMSK0 register. */
#define ALT_USB_HOST_HCINTMSK0_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCINTMSK0_OFST))

/*
 * Register : hctsiz0
 * 
 * Host Channel 0 Transfer Size Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                  
 * :--------|:-------|:------|:------------------------------
 *  [18:0]  | RW     | 0x0   | ALT_USB_HOST_HCTSIZ0_XFERSIZE
 *  [28:19] | RW     | 0x0   | ALT_USB_HOST_HCTSIZ0_PKTCNT  
 *  [30:29] | RW     | 0x0   | ALT_USB_HOST_HCTSIZ0_PID     
 *  [31]    | RW     | 0x0   | ALT_USB_HOST_HCTSIZ0_DOPNG   
 * 
 */
/*
 * Field : xfersize
 * 
 * Transfer Size (XferSize)
 * 
 * For an OUT, this field is the number of data bytes the host sends
 * 
 * during the transfer.
 * 
 * For an IN, this field is the buffer size that the application has
 * 
 * Reserved For the transfer. The application is expected to
 * 
 * program this field as an integer multiple of the maximum packet
 * 
 * size For IN transactions (periodic and non-periodic).
 * 
 * The width of this counter is specified as Width of Transfer Size
 * 
 * Counters
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ0_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ0_XFERSIZE_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ0_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ0_XFERSIZE_MSB        18
/* The width in bits of the ALT_USB_HOST_HCTSIZ0_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ0_XFERSIZE_WIDTH      19
/* The mask used to set the ALT_USB_HOST_HCTSIZ0_XFERSIZE register field value. */
#define ALT_USB_HOST_HCTSIZ0_XFERSIZE_SET_MSK    0x0007ffff
/* The mask used to clear the ALT_USB_HOST_HCTSIZ0_XFERSIZE register field value. */
#define ALT_USB_HOST_HCTSIZ0_XFERSIZE_CLR_MSK    0xfff80000
/* The reset value of the ALT_USB_HOST_HCTSIZ0_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ0_XFERSIZE_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ0_XFERSIZE field value from a register. */
#define ALT_USB_HOST_HCTSIZ0_XFERSIZE_GET(value) (((value) & 0x0007ffff) >> 0)
/* Produces a ALT_USB_HOST_HCTSIZ0_XFERSIZE register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ0_XFERSIZE_SET(value) (((value) << 0) & 0x0007ffff)

/*
 * Field : pktcnt
 * 
 * Packet Count (PktCnt)
 * 
 * This field is programmed by the application with the expected
 * 
 * number of packets to be transmitted (OUT) or received (IN).
 * 
 * The host decrements this count on every successful
 * 
 * transmission or reception of an OUT/IN packet. Once this count
 * 
 * reaches zero, the application is interrupted to indicate normal
 * 
 * completion.
 * 
 * The width of this counter is specified as Width of Packet
 * 
 * Counters
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ0_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ0_PKTCNT_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ0_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ0_PKTCNT_MSB        28
/* The width in bits of the ALT_USB_HOST_HCTSIZ0_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ0_PKTCNT_WIDTH      10
/* The mask used to set the ALT_USB_HOST_HCTSIZ0_PKTCNT register field value. */
#define ALT_USB_HOST_HCTSIZ0_PKTCNT_SET_MSK    0x1ff80000
/* The mask used to clear the ALT_USB_HOST_HCTSIZ0_PKTCNT register field value. */
#define ALT_USB_HOST_HCTSIZ0_PKTCNT_CLR_MSK    0xe007ffff
/* The reset value of the ALT_USB_HOST_HCTSIZ0_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ0_PKTCNT_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ0_PKTCNT field value from a register. */
#define ALT_USB_HOST_HCTSIZ0_PKTCNT_GET(value) (((value) & 0x1ff80000) >> 19)
/* Produces a ALT_USB_HOST_HCTSIZ0_PKTCNT register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ0_PKTCNT_SET(value) (((value) << 19) & 0x1ff80000)

/*
 * Field : pid
 * 
 * PID (Pid)
 * 
 * The application programs this field with the type of PID to use For
 * 
 * the initial transaction. The host maintains this field For the rest of
 * 
 * the transfer.
 * 
 * 2'b00: DATA0
 * 
 * 2'b01: DATA2
 * 
 * 2'b10: DATA1
 * 
 * 2'b11: MDATA (non-control)/SETUP (control)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                        
 * :---------------------------------|:------|:------------------------------------
 *  ALT_USB_HOST_HCTSIZ0_PID_E_DATA0 | 0x0   | DATA0                              
 *  ALT_USB_HOST_HCTSIZ0_PID_E_DATA2 | 0x1   | DATA2                              
 *  ALT_USB_HOST_HCTSIZ0_PID_E_DATA1 | 0x2   | DATA1                              
 *  ALT_USB_HOST_HCTSIZ0_PID_E_MDATA | 0x3   | MDATA (non-control)/SETUP (control)
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ0_PID
 * 
 * DATA0
 */
#define ALT_USB_HOST_HCTSIZ0_PID_E_DATA0    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ0_PID
 * 
 * DATA2
 */
#define ALT_USB_HOST_HCTSIZ0_PID_E_DATA2    0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ0_PID
 * 
 * DATA1
 */
#define ALT_USB_HOST_HCTSIZ0_PID_E_DATA1    0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ0_PID
 * 
 * MDATA (non-control)/SETUP (control)
 */
#define ALT_USB_HOST_HCTSIZ0_PID_E_MDATA    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ0_PID register field. */
#define ALT_USB_HOST_HCTSIZ0_PID_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ0_PID register field. */
#define ALT_USB_HOST_HCTSIZ0_PID_MSB        30
/* The width in bits of the ALT_USB_HOST_HCTSIZ0_PID register field. */
#define ALT_USB_HOST_HCTSIZ0_PID_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCTSIZ0_PID register field value. */
#define ALT_USB_HOST_HCTSIZ0_PID_SET_MSK    0x60000000
/* The mask used to clear the ALT_USB_HOST_HCTSIZ0_PID register field value. */
#define ALT_USB_HOST_HCTSIZ0_PID_CLR_MSK    0x9fffffff
/* The reset value of the ALT_USB_HOST_HCTSIZ0_PID register field. */
#define ALT_USB_HOST_HCTSIZ0_PID_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ0_PID field value from a register. */
#define ALT_USB_HOST_HCTSIZ0_PID_GET(value) (((value) & 0x60000000) >> 29)
/* Produces a ALT_USB_HOST_HCTSIZ0_PID register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ0_PID_SET(value) (((value) << 29) & 0x60000000)

/*
 * Field : dopng
 * 
 * Do Ping (DoPng)
 * 
 * This bit is used only For OUT transfers.
 * 
 * Setting this field to 1 directs the host to do PING protocol.
 * 
 * Note: Do not Set this bit For IN transfers. If this bit is Set For
 * 
 * for IN transfers it disables the channel.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description     
 * :------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCTSIZ0_DOPNG_E_NOPING | 0x0   | No ping protocol
 *  ALT_USB_HOST_HCTSIZ0_DOPNG_E_PING   | 0x1   | Ping protocol   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ0_DOPNG
 * 
 * No ping protocol
 */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_E_NOPING 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ0_DOPNG
 * 
 * Ping protocol
 */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_E_PING   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ0_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ0_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_MSB        31
/* The width in bits of the ALT_USB_HOST_HCTSIZ0_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCTSIZ0_DOPNG register field value. */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCTSIZ0_DOPNG register field value. */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCTSIZ0_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ0_DOPNG field value from a register. */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCTSIZ0_DOPNG register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCTSIZ0.
 */
struct ALT_USB_HOST_HCTSIZ0_s
{
    uint32_t  xfersize : 19;  /* ALT_USB_HOST_HCTSIZ0_XFERSIZE */
    uint32_t  pktcnt   : 10;  /* ALT_USB_HOST_HCTSIZ0_PKTCNT */
    uint32_t  pid      :  2;  /* ALT_USB_HOST_HCTSIZ0_PID */
    uint32_t  dopng    :  1;  /* ALT_USB_HOST_HCTSIZ0_DOPNG */
};

/* The typedef declaration for register ALT_USB_HOST_HCTSIZ0. */
typedef volatile struct ALT_USB_HOST_HCTSIZ0_s  ALT_USB_HOST_HCTSIZ0_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCTSIZ0 register. */
#define ALT_USB_HOST_HCTSIZ0_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCTSIZ0 register from the beginning of the component. */
#define ALT_USB_HOST_HCTSIZ0_OFST        0x110
/* The address of the ALT_USB_HOST_HCTSIZ0 register. */
#define ALT_USB_HOST_HCTSIZ0_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCTSIZ0_OFST))

/*
 * Register : hcdma0
 * 
 * Host Channel 0 DMA Address Register
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description               
 * :-------|:-------|:------|:---------------------------
 *  [31:0] | RW     | 0x0   | ALT_USB_HOST_HCDMA0_HCDMA0
 * 
 */
/*
 * Field : hcdma0
 * 
 * Buffer DMA Mode:
 * 
 * [31:0] DMA Address (DMAAddr)
 * 
 * This field holds the start address in the external memory from which the data
 * for
 * 
 * the endpoint must be fetched or to which it must be stored. This register is
 * 
 * incremented on every AHB transaction.
 * 
 * Scatter-Gather DMA (DescDMA) Mode:
 * 
 * [31:9] (Non Isoc) Non-Isochronous:
 * 
 * [31:N] (Isoc) Isochronous:
 * 
 * This field holds the start address of the 512 bytes
 * 
 * page.  The first descriptor in the list should be located
 * 
 * in this address. The first descriptor may be or may
 * 
 * not be ready. The core starts processing the list from
 * 
 * the CTD value.
 * 
 * This field holds the address of the 2*(nTD+1) bytes of
 * 
 * locations in which the isochronous descriptors are
 * 
 * present where N is based on nTD as per Table below
 * 
 * [31:N]  Base Address
 * 
 * [N-1:3]  Offset
 * 
 * [2:0]  000
 * 
 * HS ISOC
 * 
 * nTD   N
 * 
 * 7     6
 * 
 * 15    7
 * 
 * 31    8
 * 
 * 63    9
 * 
 * 127  10
 * 
 * 255  11
 * 
 * FS ISOC
 * 
 * nTD N
 * 
 * 1  4
 * 
 * 3  5
 * 
 * 7  6
 * 
 * 15  7
 * 
 * 31  8
 * 
 * 63  9
 * 
 * [N-1:3] (Isoc):
 * 
 * [8:3] (Non Isoc): Current Transfer Desc(CTD):
 * 
 * Non Isochronous:
 * 
 * This value is in terms of number of descriptors. The values can be from 0 to 63.
 * 
 * 0 -  1 descriptor.
 * 
 * 63 - 64 descriptors.
 * 
 * This field indicates the current descriptor processed in the list. This field is
 * updated
 * 
 * both by application and the core. For example, if the application enables the
 * 
 * channel after programming CTD=5, then the core will start processing the 6th
 * 
 * descriptor. The address is obtained by adding a value of (8bytes*5=) 40(decimal)
 * 
 * to DMAAddr.
 * 
 * Isochronous:
 * 
 * CTD for isochronous is based on the current frame/(micro)frame value. Need to be
 * set
 * 
 * to zero by application.Scatter-Gather DMA (DescDMA) Mode:
 * 
 * [31:9] (Non Isoc) Non-Isochronous:
 * 
 * [31:N] (Isoc) Isochronous:
 * 
 * This field holds the start address of the 512 bytes
 * 
 * page.  The first descriptor in the list should be located
 * 
 * in this address. The first descriptor may be or may
 * 
 * not be ready. The core starts processing the list from
 * 
 * the CTD value.
 * 
 * This field holds the address of the 2*(nTD+1) bytes of
 * 
 * locations in which the isochronous descriptors are
 * 
 * present where N is based on nTD as per Table below
 * 
 * [31:N]  Base Address
 * 
 * [N-1:3]  Offset
 * 
 * [2:0]  000
 * 
 * HS ISOC
 * 
 * nTD   N
 * 
 * 7     6
 * 
 * 15    7
 * 
 * 31    8
 * 
 * 63    9
 * 
 * 127  10
 * 
 * 255  11
 * 
 * FS ISOC
 * 
 * nTD N
 * 
 * 1  4
 * 
 * 3  5
 * 
 * 7  6
 * 
 * 15  7
 * 
 * 31  8
 * 
 * 63  9
 * 
 * [N-1:3] (Isoc):
 * 
 * [8:3] (Non Isoc): Current Transfer Desc(CTD):
 * 
 * Non Isochronous:
 * 
 * This value is in terms of number of descriptors. The values can be from 0 to 63.
 * 
 * 0 -  1 descriptor.
 * 
 * 63 - 64 descriptors.
 * 
 * This field indicates the current descriptor processed in the list. This field is
 * updated
 * 
 * both by application and the core. For example, if the application enables the
 * 
 * channel after programming CTD=5, then the core will start processing the 6th
 * 
 * descriptor. The address is obtained by adding a value of (8bytes*5=) 40(decimal)
 * 
 * to DMAAddr.
 * 
 * Isochronous:
 * 
 * CTD for isochronous is based on the current frame/(micro)frame value. Need to be
 * set
 * 
 * to zero by application.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCDMA0_HCDMA0 register field. */
#define ALT_USB_HOST_HCDMA0_HCDMA0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCDMA0_HCDMA0 register field. */
#define ALT_USB_HOST_HCDMA0_HCDMA0_MSB        31
/* The width in bits of the ALT_USB_HOST_HCDMA0_HCDMA0 register field. */
#define ALT_USB_HOST_HCDMA0_HCDMA0_WIDTH      32
/* The mask used to set the ALT_USB_HOST_HCDMA0_HCDMA0 register field value. */
#define ALT_USB_HOST_HCDMA0_HCDMA0_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_HOST_HCDMA0_HCDMA0 register field value. */
#define ALT_USB_HOST_HCDMA0_HCDMA0_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_HOST_HCDMA0_HCDMA0 register field. */
#define ALT_USB_HOST_HCDMA0_HCDMA0_RESET      0x0
/* Extracts the ALT_USB_HOST_HCDMA0_HCDMA0 field value from a register. */
#define ALT_USB_HOST_HCDMA0_HCDMA0_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_HOST_HCDMA0_HCDMA0 register field value suitable for setting the register. */
#define ALT_USB_HOST_HCDMA0_HCDMA0_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCDMA0.
 */
struct ALT_USB_HOST_HCDMA0_s
{
    uint32_t  hcdma0 : 32;  /* ALT_USB_HOST_HCDMA0_HCDMA0 */
};

/* The typedef declaration for register ALT_USB_HOST_HCDMA0. */
typedef volatile struct ALT_USB_HOST_HCDMA0_s  ALT_USB_HOST_HCDMA0_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCDMA0 register. */
#define ALT_USB_HOST_HCDMA0_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCDMA0 register from the beginning of the component. */
#define ALT_USB_HOST_HCDMA0_OFST        0x114
/* The address of the ALT_USB_HOST_HCDMA0 register. */
#define ALT_USB_HOST_HCDMA0_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCDMA0_OFST))

/*
 * Register : hcdmab0
 * 
 * Host Channel 0 DMA Buffer Address Register
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [31:0] | RW     | 0x0   | ALT_USB_HOST_HCDMAB0_HCDMAB0
 * 
 */
/*
 * Field : hcdmab0
 * 
 * Holds the current buffer address.
 * 
 * This register is updated as and when the data transfer for the corresponding end
 * point
 * 
 * is in progress. This register is present only in Scatter/Gather DMA mode.
 * Otherwise this
 * 
 * field is reserved.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCDMAB0_HCDMAB0 register field. */
#define ALT_USB_HOST_HCDMAB0_HCDMAB0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCDMAB0_HCDMAB0 register field. */
#define ALT_USB_HOST_HCDMAB0_HCDMAB0_MSB        31
/* The width in bits of the ALT_USB_HOST_HCDMAB0_HCDMAB0 register field. */
#define ALT_USB_HOST_HCDMAB0_HCDMAB0_WIDTH      32
/* The mask used to set the ALT_USB_HOST_HCDMAB0_HCDMAB0 register field value. */
#define ALT_USB_HOST_HCDMAB0_HCDMAB0_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_HOST_HCDMAB0_HCDMAB0 register field value. */
#define ALT_USB_HOST_HCDMAB0_HCDMAB0_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_HOST_HCDMAB0_HCDMAB0 register field. */
#define ALT_USB_HOST_HCDMAB0_HCDMAB0_RESET      0x0
/* Extracts the ALT_USB_HOST_HCDMAB0_HCDMAB0 field value from a register. */
#define ALT_USB_HOST_HCDMAB0_HCDMAB0_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_HOST_HCDMAB0_HCDMAB0 register field value suitable for setting the register. */
#define ALT_USB_HOST_HCDMAB0_HCDMAB0_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCDMAB0.
 */
struct ALT_USB_HOST_HCDMAB0_s
{
    uint32_t  hcdmab0 : 32;  /* ALT_USB_HOST_HCDMAB0_HCDMAB0 */
};

/* The typedef declaration for register ALT_USB_HOST_HCDMAB0. */
typedef volatile struct ALT_USB_HOST_HCDMAB0_s  ALT_USB_HOST_HCDMAB0_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCDMAB0 register. */
#define ALT_USB_HOST_HCDMAB0_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCDMAB0 register from the beginning of the component. */
#define ALT_USB_HOST_HCDMAB0_OFST        0x11c
/* The address of the ALT_USB_HOST_HCDMAB0 register. */
#define ALT_USB_HOST_HCDMAB0_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCDMAB0_OFST))

/*
 * Register : hcchar1
 * 
 * Host Channel 1 Characteristics Register
 * 
 * Register Layout
 * 
 *  Bits    | Access   | Reset | Description                 
 * :--------|:---------|:------|:-----------------------------
 *  [10:0]  | RW       | 0x0   | ALT_USB_HOST_HCCHAR1_MPS    
 *  [14:11] | RW       | 0x0   | ALT_USB_HOST_HCCHAR1_EPNUM  
 *  [15]    | RW       | 0x0   | ALT_USB_HOST_HCCHAR1_EPDIR  
 *  [16]    | ???      | 0x0   | *UNDEFINED*                 
 *  [17]    | RW       | 0x0   | ALT_USB_HOST_HCCHAR1_LSPDDEV
 *  [19:18] | RW       | 0x0   | ALT_USB_HOST_HCCHAR1_EPTYPE 
 *  [21:20] | RW       | 0x0   | ALT_USB_HOST_HCCHAR1_EC     
 *  [28:22] | RW       | 0x0   | ALT_USB_HOST_HCCHAR1_DEVADDR
 *  [29]    | RW       | 0x0   | ALT_USB_HOST_HCCHAR1_ODDFRM 
 *  [30]    | R-W once | 0x0   | ALT_USB_HOST_HCCHAR1_CHDIS  
 *  [31]    | R-W once | 0x0   | ALT_USB_HOST_HCCHAR1_CHENA  
 * 
 */
/*
 * Field : mps
 * 
 * Maximum Packet Size (MPS)
 * 
 * Indicates the maximum packet size of the associated endpoint.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_MPS register field. */
#define ALT_USB_HOST_HCCHAR1_MPS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_MPS register field. */
#define ALT_USB_HOST_HCCHAR1_MPS_MSB        10
/* The width in bits of the ALT_USB_HOST_HCCHAR1_MPS register field. */
#define ALT_USB_HOST_HCCHAR1_MPS_WIDTH      11
/* The mask used to set the ALT_USB_HOST_HCCHAR1_MPS register field value. */
#define ALT_USB_HOST_HCCHAR1_MPS_SET_MSK    0x000007ff
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_MPS register field value. */
#define ALT_USB_HOST_HCCHAR1_MPS_CLR_MSK    0xfffff800
/* The reset value of the ALT_USB_HOST_HCCHAR1_MPS register field. */
#define ALT_USB_HOST_HCCHAR1_MPS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_MPS field value from a register. */
#define ALT_USB_HOST_HCCHAR1_MPS_GET(value) (((value) & 0x000007ff) >> 0)
/* Produces a ALT_USB_HOST_HCCHAR1_MPS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_MPS_SET(value) (((value) << 0) & 0x000007ff)

/*
 * Field : epnum
 * 
 * Endpoint Number (EPNum)
 * 
 * Indicates the endpoint number on the device serving as the data
 * 
 * source or sink.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description  
 * :-------------------------------------|:------|:--------------
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT0  | 0x0   | End point  0 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT1  | 0x1   | End point  1 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT2  | 0x2   | End point  2 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT3  | 0x3   | End point  3 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT4  | 0x4   | End point  4 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT5  | 0x5   | End point  5 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT6  | 0x6   | End point  6 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT7  | 0x7   | End point  7 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT8  | 0x8   | End point  8 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT9  | 0x9   | End point  9 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT10 | 0xa   | End point  10
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT11 | 0xb   | End point  11
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT12 | 0xc   | End point  12
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT13 | 0xd   | End point  13
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT14 | 0xe   | End point  14
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT15 | 0xf   | End point  15
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  0
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT0     0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  1
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT1     0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  2
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT2     0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  3
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT3     0x3
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  4
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT4     0x4
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  5
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT5     0x5
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  6
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT6     0x6
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  7
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT7     0x7
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  8
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT8     0x8
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  9
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT9     0x9
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  10
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT10    0xa
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  11
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT11    0xb
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  12
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT12    0xc
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  13
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT13    0xd
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  14
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT14    0xe
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  15
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT15    0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR1_EPNUM_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR1_EPNUM_MSB        14
/* The width in bits of the ALT_USB_HOST_HCCHAR1_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR1_EPNUM_WIDTH      4
/* The mask used to set the ALT_USB_HOST_HCCHAR1_EPNUM register field value. */
#define ALT_USB_HOST_HCCHAR1_EPNUM_SET_MSK    0x00007800
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_EPNUM register field value. */
#define ALT_USB_HOST_HCCHAR1_EPNUM_CLR_MSK    0xffff87ff
/* The reset value of the ALT_USB_HOST_HCCHAR1_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR1_EPNUM_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_EPNUM field value from a register. */
#define ALT_USB_HOST_HCCHAR1_EPNUM_GET(value) (((value) & 0x00007800) >> 11)
/* Produces a ALT_USB_HOST_HCCHAR1_EPNUM register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_EPNUM_SET(value) (((value) << 11) & 0x00007800)

/*
 * Field : epdir
 * 
 * Endpoint Direction (EPDir)
 * 
 * Indicates whether the transaction is IN or OUT.
 * 
 * 1'b0: OUT
 * 
 * 1'b1: IN
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description  
 * :---------------------------------|:------|:--------------
 *  ALT_USB_HOST_HCCHAR1_EPDIR_E_OUT | 0x0   | OUT Direction
 *  ALT_USB_HOST_HCCHAR1_EPDIR_E_IN  | 0x1   | IN Direction 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPDIR
 * 
 * OUT Direction
 */
#define ALT_USB_HOST_HCCHAR1_EPDIR_E_OUT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPDIR
 * 
 * IN Direction
 */
#define ALT_USB_HOST_HCCHAR1_EPDIR_E_IN     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR1_EPDIR_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR1_EPDIR_MSB        15
/* The width in bits of the ALT_USB_HOST_HCCHAR1_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR1_EPDIR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR1_EPDIR register field value. */
#define ALT_USB_HOST_HCCHAR1_EPDIR_SET_MSK    0x00008000
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_EPDIR register field value. */
#define ALT_USB_HOST_HCCHAR1_EPDIR_CLR_MSK    0xffff7fff
/* The reset value of the ALT_USB_HOST_HCCHAR1_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR1_EPDIR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_EPDIR field value from a register. */
#define ALT_USB_HOST_HCCHAR1_EPDIR_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_USB_HOST_HCCHAR1_EPDIR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_EPDIR_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : lspddev
 * 
 * Low-Speed Device (LSpdDev)
 * 
 * This field is Set by the application to indicate that this channel is
 * 
 * communicating to a low-speed device.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                            
 * :------------------------------------|:------|:----------------------------------------
 *  ALT_USB_HOST_HCCHAR1_LSPDDEV_E_DISD | 0x0   | Not Communicating with low speed device
 *  ALT_USB_HOST_HCCHAR1_LSPDDEV_E_END  | 0x1   | Communicating with low speed device    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_LSPDDEV
 * 
 * Not Communicating with low speed device
 */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_LSPDDEV
 * 
 * Communicating with low speed device
 */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_MSB        17
/* The width in bits of the ALT_USB_HOST_HCCHAR1_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR1_LSPDDEV register field value. */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_SET_MSK    0x00020000
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_LSPDDEV register field value. */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_CLR_MSK    0xfffdffff
/* The reset value of the ALT_USB_HOST_HCCHAR1_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_LSPDDEV field value from a register. */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_USB_HOST_HCCHAR1_LSPDDEV register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : eptype
 * 
 * Endpoint Type (EPType)
 * 
 * Indicates the transfer type selected.
 * 
 * 2'b00: Control
 * 
 * 2'b01: Isochronous
 * 
 * 2'b10: Bulk
 * 
 * 2'b11: Interrupt
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCCHAR1_EPTYPE_E_CTL    | 0x0   | Control    
 *  ALT_USB_HOST_HCCHAR1_EPTYPE_E_ISOC   | 0x1   | Isochronous
 *  ALT_USB_HOST_HCCHAR1_EPTYPE_E_BULK   | 0x2   | Bulk       
 *  ALT_USB_HOST_HCCHAR1_EPTYPE_E_INTERR | 0x3   | Interrupt  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPTYPE
 * 
 * Control
 */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_E_CTL       0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPTYPE
 * 
 * Isochronous
 */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_E_ISOC      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPTYPE
 * 
 * Bulk
 */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_E_BULK      0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPTYPE
 * 
 * Interrupt
 */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_E_INTERR    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_MSB        19
/* The width in bits of the ALT_USB_HOST_HCCHAR1_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCCHAR1_EPTYPE register field value. */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_SET_MSK    0x000c0000
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_EPTYPE register field value. */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_CLR_MSK    0xfff3ffff
/* The reset value of the ALT_USB_HOST_HCCHAR1_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_EPTYPE field value from a register. */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_GET(value) (((value) & 0x000c0000) >> 18)
/* Produces a ALT_USB_HOST_HCCHAR1_EPTYPE register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_SET(value) (((value) << 18) & 0x000c0000)

/*
 * Field : ec
 * 
 * Multi Count (MC) / Error Count (EC)
 * 
 * When the Split Enable bit of the Host Channel-n Split Control
 * 
 * register (HCSPLTn.SpltEna) is reset (1'b0), this field indicates to
 * 
 * the host the number of transactions that must be executed per
 * 
 * microframe For this periodic endpoint. For non periodic transfers,
 * 
 * this field is used only in DMA mode, and specifies the number
 * 
 * packets to be fetched For this channel before the internal DMA
 * 
 * engine changes arbitration.
 * 
 * 2'b00: Reserved This field yields undefined results.
 * 
 * 2'b01: 1 transaction
 * 
 * 2'b10: 2 transactions to be issued For this endpoint per
 * 
 * microframe
 * 
 * 2'b11: 3 transactions to be issued For this endpoint per
 * 
 * microframe
 * 
 * When HCSPLTn.SpltEna is Set (1'b1), this field indicates the
 * 
 * number of immediate retries to be performed For a periodic split
 * 
 * transactions on transaction errors. This field must be Set to at
 * 
 * least 2'b01.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                  
 * :-------------------------------------|:------|:----------------------------------------------
 *  ALT_USB_HOST_HCCHAR1_EC_E_RSVD       | 0x0   | Reserved This field yields undefined result  
 *  ALT_USB_HOST_HCCHAR1_EC_E_TRANSONE   | 0x1   | 1 transaction                                
 *  ALT_USB_HOST_HCCHAR1_EC_E_TRANSTWO   | 0x2   | 2 transactions to be issued for this endpoint
 * :                                     |       | per microframe                               
 *  ALT_USB_HOST_HCCHAR1_EC_E_TRANSTHREE | 0x3   | 3 transactions to be issued for this endpoint
 * :                                     |       | per microframe                               
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EC
 * 
 * Reserved This field yields undefined result
 */
#define ALT_USB_HOST_HCCHAR1_EC_E_RSVD          0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EC
 * 
 * 1 transaction
 */
#define ALT_USB_HOST_HCCHAR1_EC_E_TRANSONE      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EC
 * 
 * 2 transactions to be issued for this endpoint per microframe
 */
#define ALT_USB_HOST_HCCHAR1_EC_E_TRANSTWO      0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EC
 * 
 * 3 transactions to be issued for this endpoint per microframe
 */
#define ALT_USB_HOST_HCCHAR1_EC_E_TRANSTHREE    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_EC register field. */
#define ALT_USB_HOST_HCCHAR1_EC_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_EC register field. */
#define ALT_USB_HOST_HCCHAR1_EC_MSB        21
/* The width in bits of the ALT_USB_HOST_HCCHAR1_EC register field. */
#define ALT_USB_HOST_HCCHAR1_EC_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCCHAR1_EC register field value. */
#define ALT_USB_HOST_HCCHAR1_EC_SET_MSK    0x00300000
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_EC register field value. */
#define ALT_USB_HOST_HCCHAR1_EC_CLR_MSK    0xffcfffff
/* The reset value of the ALT_USB_HOST_HCCHAR1_EC register field. */
#define ALT_USB_HOST_HCCHAR1_EC_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_EC field value from a register. */
#define ALT_USB_HOST_HCCHAR1_EC_GET(value) (((value) & 0x00300000) >> 20)
/* Produces a ALT_USB_HOST_HCCHAR1_EC register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_EC_SET(value) (((value) << 20) & 0x00300000)

/*
 * Field : devaddr
 * 
 * Device Address (DevAddr)
 * 
 * This field selects the specific device serving as the data source
 * 
 * or sink.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR1_DEVADDR_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR1_DEVADDR_MSB        28
/* The width in bits of the ALT_USB_HOST_HCCHAR1_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR1_DEVADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCCHAR1_DEVADDR register field value. */
#define ALT_USB_HOST_HCCHAR1_DEVADDR_SET_MSK    0x1fc00000
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_DEVADDR register field value. */
#define ALT_USB_HOST_HCCHAR1_DEVADDR_CLR_MSK    0xe03fffff
/* The reset value of the ALT_USB_HOST_HCCHAR1_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR1_DEVADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_DEVADDR field value from a register. */
#define ALT_USB_HOST_HCCHAR1_DEVADDR_GET(value) (((value) & 0x1fc00000) >> 22)
/* Produces a ALT_USB_HOST_HCCHAR1_DEVADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_DEVADDR_SET(value) (((value) << 22) & 0x1fc00000)

/*
 * Field : oddfrm
 * 
 * Odd Frame (OddFrm)
 * 
 * This field is set (reset) by the application to indicate that the OTG host must
 * perform
 * 
 * a transfer in an odd (micro)frame. This field is applicable for only periodic
 * 
 * (isochronous and interrupt) transactions.
 * 
 * 1'b0: Even (micro)frame
 * 
 * 1'b1: Odd (micro)frame
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_ODDFRM register field. */
#define ALT_USB_HOST_HCCHAR1_ODDFRM_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_ODDFRM register field. */
#define ALT_USB_HOST_HCCHAR1_ODDFRM_MSB        29
/* The width in bits of the ALT_USB_HOST_HCCHAR1_ODDFRM register field. */
#define ALT_USB_HOST_HCCHAR1_ODDFRM_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR1_ODDFRM register field value. */
#define ALT_USB_HOST_HCCHAR1_ODDFRM_SET_MSK    0x20000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_ODDFRM register field value. */
#define ALT_USB_HOST_HCCHAR1_ODDFRM_CLR_MSK    0xdfffffff
/* The reset value of the ALT_USB_HOST_HCCHAR1_ODDFRM register field. */
#define ALT_USB_HOST_HCCHAR1_ODDFRM_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_ODDFRM field value from a register. */
#define ALT_USB_HOST_HCCHAR1_ODDFRM_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_USB_HOST_HCCHAR1_ODDFRM register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_ODDFRM_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : chdis
 * 
 * Channel Disable (ChDis)
 * 
 * The application sets this bit to stop transmitting/receiving data
 * 
 * on a channel, even before the transfer For that channel is
 * 
 * complete. The application must wait For the Channel Disabled
 * 
 * interrupt before treating the channel as disabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                
 * :-----------------------------------|:------|:----------------------------
 *  ALT_USB_HOST_HCCHAR1_CHDIS_E_INACT | 0x0   | Transmit/Recieve normal    
 *  ALT_USB_HOST_HCCHAR1_CHDIS_E_ACT   | 0x1   | Stop transmitting/receiving
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_CHDIS
 * 
 * Transmit/Recieve normal
 */
#define ALT_USB_HOST_HCCHAR1_CHDIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_CHDIS
 * 
 * Stop transmitting/receiving
 */
#define ALT_USB_HOST_HCCHAR1_CHDIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR1_CHDIS_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR1_CHDIS_MSB        30
/* The width in bits of the ALT_USB_HOST_HCCHAR1_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR1_CHDIS_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR1_CHDIS register field value. */
#define ALT_USB_HOST_HCCHAR1_CHDIS_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_CHDIS register field value. */
#define ALT_USB_HOST_HCCHAR1_CHDIS_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_HOST_HCCHAR1_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR1_CHDIS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_CHDIS field value from a register. */
#define ALT_USB_HOST_HCCHAR1_CHDIS_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_HOST_HCCHAR1_CHDIS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_CHDIS_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : chena
 * 
 * Channel Enable (ChEna)
 * 
 * When Scatter/Gather mode is enabled
 * 
 * 1'b0: Indicates that the descriptor structure is not yet ready.
 * 
 * 1'b1:  Indicates  that  the  descriptor  structure  and  data  buffer  with
 * 
 * data is setup and this channel can access the descriptor.
 * 
 * When Scatter/Gather mode is disabled
 * 
 * This field is set by the application and cleared by the OTG host.
 * 
 * 1'b0: Channel disabled
 * 
 * 1'b1: Channel enabled
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                                     
 * :-----------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_HOST_HCCHAR1_CHENA_E_INACT | 0x0   | Indicates that the descriptor structure is not  
 * :                                   |       | yet ready                                       
 *  ALT_USB_HOST_HCCHAR1_CHENA_E_ACT   | 0x1   | Indicates  that  the  descriptor  structure  and
 * :                                   |       | data  buffer  with data is setup and this       
 * :                                   |       | channel can access the descriptor               
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_CHENA
 * 
 * Indicates that the descriptor structure is not yet ready
 */
#define ALT_USB_HOST_HCCHAR1_CHENA_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_CHENA
 * 
 * Indicates  that  the  descriptor  structure  and  data  buffer  with data is
 * setup and this channel can access the descriptor
 */
#define ALT_USB_HOST_HCCHAR1_CHENA_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_CHENA register field. */
#define ALT_USB_HOST_HCCHAR1_CHENA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_CHENA register field. */
#define ALT_USB_HOST_HCCHAR1_CHENA_MSB        31
/* The width in bits of the ALT_USB_HOST_HCCHAR1_CHENA register field. */
#define ALT_USB_HOST_HCCHAR1_CHENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR1_CHENA register field value. */
#define ALT_USB_HOST_HCCHAR1_CHENA_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_CHENA register field value. */
#define ALT_USB_HOST_HCCHAR1_CHENA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCCHAR1_CHENA register field. */
#define ALT_USB_HOST_HCCHAR1_CHENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_CHENA field value from a register. */
#define ALT_USB_HOST_HCCHAR1_CHENA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCCHAR1_CHENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_CHENA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCCHAR1.
 */
struct ALT_USB_HOST_HCCHAR1_s
{
    uint32_t  mps     : 11;  /* ALT_USB_HOST_HCCHAR1_MPS */
    uint32_t  epnum   :  4;  /* ALT_USB_HOST_HCCHAR1_EPNUM */
    uint32_t  epdir   :  1;  /* ALT_USB_HOST_HCCHAR1_EPDIR */
    uint32_t          :  1;  /* *UNDEFINED* */
    uint32_t  lspddev :  1;  /* ALT_USB_HOST_HCCHAR1_LSPDDEV */
    uint32_t  eptype  :  2;  /* ALT_USB_HOST_HCCHAR1_EPTYPE */
    uint32_t  ec      :  2;  /* ALT_USB_HOST_HCCHAR1_EC */
    uint32_t  devaddr :  7;  /* ALT_USB_HOST_HCCHAR1_DEVADDR */
    uint32_t  oddfrm  :  1;  /* ALT_USB_HOST_HCCHAR1_ODDFRM */
    uint32_t  chdis   :  1;  /* ALT_USB_HOST_HCCHAR1_CHDIS */
    uint32_t  chena   :  1;  /* ALT_USB_HOST_HCCHAR1_CHENA */
};

/* The typedef declaration for register ALT_USB_HOST_HCCHAR1. */
typedef volatile struct ALT_USB_HOST_HCCHAR1_s  ALT_USB_HOST_HCCHAR1_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCCHAR1 register. */
#define ALT_USB_HOST_HCCHAR1_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCCHAR1 register from the beginning of the component. */
#define ALT_USB_HOST_HCCHAR1_OFST        0x120
/* The address of the ALT_USB_HOST_HCCHAR1 register. */
#define ALT_USB_HOST_HCCHAR1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCCHAR1_OFST))

/*
 * Register : hcsplt1
 * 
 * Host Channel 1 Split Control Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                  
 * :--------|:-------|:------|:------------------------------
 *  [6:0]   | RW     | 0x0   | ALT_USB_HOST_HCSPLT1_PRTADDR 
 *  [13:7]  | RW     | 0x0   | ALT_USB_HOST_HCSPLT1_HUBADDR 
 *  [15:14] | RW     | 0x0   | ALT_USB_HOST_HCSPLT1_XACTPOS 
 *  [16]    | RW     | 0x0   | ALT_USB_HOST_HCSPLT1_COMPSPLT
 *  [30:17] | ???    | 0x0   | *UNDEFINED*                  
 *  [31]    | RW     | 0x0   | ALT_USB_HOST_HCSPLT1_SPLTENA 
 * 
 */
/*
 * Field : prtaddr
 * 
 * Port Address (PrtAddr)
 * 
 * This field is the port number of the recipient transaction
 * 
 * translator.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT1_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT1_PRTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT1_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT1_PRTADDR_MSB        6
/* The width in bits of the ALT_USB_HOST_HCSPLT1_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT1_PRTADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCSPLT1_PRTADDR register field value. */
#define ALT_USB_HOST_HCSPLT1_PRTADDR_SET_MSK    0x0000007f
/* The mask used to clear the ALT_USB_HOST_HCSPLT1_PRTADDR register field value. */
#define ALT_USB_HOST_HCSPLT1_PRTADDR_CLR_MSK    0xffffff80
/* The reset value of the ALT_USB_HOST_HCSPLT1_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT1_PRTADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT1_PRTADDR field value from a register. */
#define ALT_USB_HOST_HCSPLT1_PRTADDR_GET(value) (((value) & 0x0000007f) >> 0)
/* Produces a ALT_USB_HOST_HCSPLT1_PRTADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT1_PRTADDR_SET(value) (((value) << 0) & 0x0000007f)

/*
 * Field : hubaddr
 * 
 * Hub Address (HubAddr)
 * 
 * This field holds the device address of the transaction translator's
 * 
 * hub.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT1_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT1_HUBADDR_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT1_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT1_HUBADDR_MSB        13
/* The width in bits of the ALT_USB_HOST_HCSPLT1_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT1_HUBADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCSPLT1_HUBADDR register field value. */
#define ALT_USB_HOST_HCSPLT1_HUBADDR_SET_MSK    0x00003f80
/* The mask used to clear the ALT_USB_HOST_HCSPLT1_HUBADDR register field value. */
#define ALT_USB_HOST_HCSPLT1_HUBADDR_CLR_MSK    0xffffc07f
/* The reset value of the ALT_USB_HOST_HCSPLT1_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT1_HUBADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT1_HUBADDR field value from a register. */
#define ALT_USB_HOST_HCSPLT1_HUBADDR_GET(value) (((value) & 0x00003f80) >> 7)
/* Produces a ALT_USB_HOST_HCSPLT1_HUBADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT1_HUBADDR_SET(value) (((value) << 7) & 0x00003f80)

/*
 * Field : xactpos
 * 
 * Transaction Position (XactPos)
 * 
 * This field is used to determine whether to send all, first, middle,
 * 
 * or last payloads with each OUT transaction.
 * 
 * 2'b11: All. This is the entire data payload is of this transaction
 * 
 * (which is less than or equal to 188 bytes).
 * 
 * 2'b10: Begin. This is the first data payload of this transaction
 * 
 * (which is larger than 188 bytes).
 * 
 * 2'b00: Mid. This is the middle payload of this transaction
 * 
 * (which is larger than 188 bytes).
 * 
 * 2'b01: End. This is the last payload of this transaction (which
 * 
 * is larger than 188 bytes).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                    
 * :--------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_HOST_HCSPLT1_XACTPOS_E_MIDDLE | 0x0   | Mid. This is the middle payload of this        
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT1_XACTPOS_E_END    | 0x1   | End. This is the last payload of this          
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT1_XACTPOS_E_BEGIN  | 0x2   | Begin. This is the first data payload of this  
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT1_XACTPOS_E_ALL    | 0x3   | All. This is the entire data payload is of this
 * :                                      |       | transaction (which is less than or equal to 188
 * :                                      |       | bytes)                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT1_XACTPOS
 * 
 * Mid. This is the middle payload of this transaction (which is larger than 188
 * bytes)
 */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_E_MIDDLE   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT1_XACTPOS
 * 
 * End. This is the last payload of this transaction (which is larger than 188
 * bytes)
 */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_E_END      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT1_XACTPOS
 * 
 * Begin. This is the first data payload of this transaction (which is larger than
 * 188 bytes)
 */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_E_BEGIN    0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT1_XACTPOS
 * 
 * All. This is the entire data payload is of this transaction (which is less than
 * or equal to 188 bytes)
 */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_E_ALL      0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT1_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT1_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_MSB        15
/* The width in bits of the ALT_USB_HOST_HCSPLT1_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCSPLT1_XACTPOS register field value. */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_SET_MSK    0x0000c000
/* The mask used to clear the ALT_USB_HOST_HCSPLT1_XACTPOS register field value. */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_CLR_MSK    0xffff3fff
/* The reset value of the ALT_USB_HOST_HCSPLT1_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT1_XACTPOS field value from a register. */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_GET(value) (((value) & 0x0000c000) >> 14)
/* Produces a ALT_USB_HOST_HCSPLT1_XACTPOS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_SET(value) (((value) << 14) & 0x0000c000)

/*
 * Field : compsplt
 * 
 * Do Complete Split (CompSplt)
 * 
 * The application sets this field to request the OTG host to perform
 * 
 * a complete split transaction.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description         
 * :----------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCSPLT1_COMPSPLT_E_NOSPLIT | 0x0   | No split transaction
 *  ALT_USB_HOST_HCSPLT1_COMPSPLT_E_SPLIT   | 0x1   | Split transaction   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT1_COMPSPLT
 * 
 * No split transaction
 */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_E_NOSPLIT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT1_COMPSPLT
 * 
 * Split transaction
 */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_E_SPLIT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT1_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT1_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_MSB        16
/* The width in bits of the ALT_USB_HOST_HCSPLT1_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCSPLT1_COMPSPLT register field value. */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_SET_MSK    0x00010000
/* The mask used to clear the ALT_USB_HOST_HCSPLT1_COMPSPLT register field value. */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_CLR_MSK    0xfffeffff
/* The reset value of the ALT_USB_HOST_HCSPLT1_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT1_COMPSPLT field value from a register. */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_USB_HOST_HCSPLT1_COMPSPLT register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : spltena
 * 
 * Split Enable (SpltEna)
 * 
 * The application sets this field to indicate that this channel is
 * 
 * enabled to perform split transactions.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description      
 * :------------------------------------|:------|:------------------
 *  ALT_USB_HOST_HCSPLT1_SPLTENA_E_DISD | 0x0   | Split not enabled
 *  ALT_USB_HOST_HCSPLT1_SPLTENA_E_END  | 0x1   | Split enabled    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT1_SPLTENA
 * 
 * Split not enabled
 */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT1_SPLTENA
 * 
 * Split enabled
 */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT1_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT1_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_MSB        31
/* The width in bits of the ALT_USB_HOST_HCSPLT1_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCSPLT1_SPLTENA register field value. */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCSPLT1_SPLTENA register field value. */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCSPLT1_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT1_SPLTENA field value from a register. */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCSPLT1_SPLTENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCSPLT1.
 */
struct ALT_USB_HOST_HCSPLT1_s
{
    uint32_t  prtaddr  :  7;  /* ALT_USB_HOST_HCSPLT1_PRTADDR */
    uint32_t  hubaddr  :  7;  /* ALT_USB_HOST_HCSPLT1_HUBADDR */
    uint32_t  xactpos  :  2;  /* ALT_USB_HOST_HCSPLT1_XACTPOS */
    uint32_t  compsplt :  1;  /* ALT_USB_HOST_HCSPLT1_COMPSPLT */
    uint32_t           : 14;  /* *UNDEFINED* */
    uint32_t  spltena  :  1;  /* ALT_USB_HOST_HCSPLT1_SPLTENA */
};

/* The typedef declaration for register ALT_USB_HOST_HCSPLT1. */
typedef volatile struct ALT_USB_HOST_HCSPLT1_s  ALT_USB_HOST_HCSPLT1_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCSPLT1 register. */
#define ALT_USB_HOST_HCSPLT1_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCSPLT1 register from the beginning of the component. */
#define ALT_USB_HOST_HCSPLT1_OFST        0x124
/* The address of the ALT_USB_HOST_HCSPLT1 register. */
#define ALT_USB_HOST_HCSPLT1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCSPLT1_OFST))

/*
 * Register : hcint1
 * 
 * Host Channel 1 Interrupt Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                          
 * :--------|:-------|:------|:--------------------------------------
 *  [0]     | RW     | 0x0   | ALT_USB_HOST_HCINT1_XFERCOMPL        
 *  [1]     | RW     | 0x0   | ALT_USB_HOST_HCINT1_CHHLTD           
 *  [2]     | RW     | 0x0   | ALT_USB_HOST_HCINT1_AHBERR           
 *  [3]     | RW     | 0x0   | ALT_USB_HOST_HCINT1_STALL            
 *  [4]     | RW     | 0x0   | ALT_USB_HOST_HCINT1_NAK              
 *  [5]     | RW     | 0x0   | ALT_USB_HOST_HCINT1_ACK              
 *  [6]     | RW     | 0x0   | ALT_USB_HOST_HCINT1_NYET             
 *  [7]     | RW     | 0x0   | ALT_USB_HOST_HCINT1_XACTERR          
 *  [8]     | RW     | 0x0   | ALT_USB_HOST_HCINT1_BBLERR           
 *  [9]     | RW     | 0x0   | ALT_USB_HOST_HCINT1_FRMOVRUN         
 *  [10]    | RW     | 0x0   | ALT_USB_HOST_HCINT1_DATATGLERR       
 *  [11]    | RW     | 0x0   | ALT_USB_HOST_HCINT1_BNAINTR          
 *  [12]    | RW     | 0x0   | ALT_USB_HOST_HCINT1_XCS_XACT_ERR     
 *  [13]    | RW     | 0x0   | ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR
 *  [31:14] | ???    | 0x0   | *UNDEFINED*                          
 * 
 */
/*
 * Field : xfercompl
 * 
 * Transfer Completed (XferCompl)
 * 
 * Transfer completed normally without any errors.This bit can be set only by the
 * core and the application should write 1 to clear it.
 * 
 * For Scatter/Gather DMA mode, it indicates that current descriptor processing got
 * 
 * completed with IOC bit set in its descriptor.
 * 
 * In non Scatter/Gather DMA mode, it indicates that Transfer completed normally
 * without
 * 
 * any errors.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                   
 * :--------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_HOST_HCINT1_XFERCOMPL_E_INACT | 0x0   | No transfer                                   
 *  ALT_USB_HOST_HCINT1_XFERCOMPL_E_ACT   | 0x1   | Transfer completed normally without any errors
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_XFERCOMPL
 * 
 * No transfer
 */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_XFERCOMPL
 * 
 * Transfer completed normally without any errors
 */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_MSB        0
/* The width in bits of the ALT_USB_HOST_HCINT1_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_XFERCOMPL register field value. */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_HOST_HCINT1_XFERCOMPL register field value. */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_HOST_HCINT1_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_XFERCOMPL field value from a register. */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_HOST_HCINT1_XFERCOMPL register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : chhltd
 * 
 * Channel Halted (ChHltd)
 * 
 * In non Scatter/Gather DMA mode, it indicates the transfer completed abnormally
 * either because of any USB transaction error or in response to disable request by
 * the application or because of a completed transfer.
 * 
 * in Scatter/gather DMA mode, this indicates that transfer completed due to any of
 * the following
 * 
 * . EOL being set in descriptor
 * 
 * . AHB error
 * 
 * . Excessive transaction errors
 * 
 * . Babble
 * 
 * . Stall
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description       
 * :-----------------------------------|:------|:-------------------
 *  ALT_USB_HOST_HCINT1_CHHLTD_E_INACT | 0x0   | Channel not halted
 *  ALT_USB_HOST_HCINT1_CHHLTD_E_ACT   | 0x1   | Channel Halted    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_CHHLTD
 * 
 * Channel not halted
 */
#define ALT_USB_HOST_HCINT1_CHHLTD_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_CHHLTD
 * 
 * Channel Halted
 */
#define ALT_USB_HOST_HCINT1_CHHLTD_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_CHHLTD register field. */
#define ALT_USB_HOST_HCINT1_CHHLTD_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_CHHLTD register field. */
#define ALT_USB_HOST_HCINT1_CHHLTD_MSB        1
/* The width in bits of the ALT_USB_HOST_HCINT1_CHHLTD register field. */
#define ALT_USB_HOST_HCINT1_CHHLTD_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_CHHLTD register field value. */
#define ALT_USB_HOST_HCINT1_CHHLTD_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_HOST_HCINT1_CHHLTD register field value. */
#define ALT_USB_HOST_HCINT1_CHHLTD_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_HOST_HCINT1_CHHLTD register field. */
#define ALT_USB_HOST_HCINT1_CHHLTD_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_CHHLTD field value from a register. */
#define ALT_USB_HOST_HCINT1_CHHLTD_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_HOST_HCINT1_CHHLTD register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_CHHLTD_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : ahberr
 * 
 * AHB Error (AHBErr)
 * 
 * This is generated only in Internal DMA mode when there is an
 * 
 * AHB error during AHB read/write. The application can read the
 * 
 * corresponding channel's DMA address register to get the error
 * 
 * address.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                    
 * :-----------------------------------|:------|:--------------------------------
 *  ALT_USB_HOST_HCINT1_AHBERR_E_INACT | 0x0   | No AHB error                   
 *  ALT_USB_HOST_HCINT1_AHBERR_E_ACT   | 0x1   | AHB error during AHB read/write
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_AHBERR
 * 
 * No AHB error
 */
#define ALT_USB_HOST_HCINT1_AHBERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_AHBERR
 * 
 * AHB error during AHB read/write
 */
#define ALT_USB_HOST_HCINT1_AHBERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_AHBERR register field. */
#define ALT_USB_HOST_HCINT1_AHBERR_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_AHBERR register field. */
#define ALT_USB_HOST_HCINT1_AHBERR_MSB        2
/* The width in bits of the ALT_USB_HOST_HCINT1_AHBERR register field. */
#define ALT_USB_HOST_HCINT1_AHBERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_AHBERR register field value. */
#define ALT_USB_HOST_HCINT1_AHBERR_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_HOST_HCINT1_AHBERR register field value. */
#define ALT_USB_HOST_HCINT1_AHBERR_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_HOST_HCINT1_AHBERR register field. */
#define ALT_USB_HOST_HCINT1_AHBERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_AHBERR field value from a register. */
#define ALT_USB_HOST_HCINT1_AHBERR_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_HOST_HCINT1_AHBERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_AHBERR_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : stall
 * 
 * STALL Response Received Interrupt (STALL)
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description       
 * :----------------------------------|:------|:-------------------
 *  ALT_USB_HOST_HCINT1_STALL_E_INACT | 0x0   | No Stall Interrupt
 *  ALT_USB_HOST_HCINT1_STALL_E_ACT   | 0x1   | Stall Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_STALL
 * 
 * No Stall Interrupt
 */
#define ALT_USB_HOST_HCINT1_STALL_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_STALL
 * 
 * Stall Interrupt
 */
#define ALT_USB_HOST_HCINT1_STALL_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_STALL register field. */
#define ALT_USB_HOST_HCINT1_STALL_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_STALL register field. */
#define ALT_USB_HOST_HCINT1_STALL_MSB        3
/* The width in bits of the ALT_USB_HOST_HCINT1_STALL register field. */
#define ALT_USB_HOST_HCINT1_STALL_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_STALL register field value. */
#define ALT_USB_HOST_HCINT1_STALL_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_HOST_HCINT1_STALL register field value. */
#define ALT_USB_HOST_HCINT1_STALL_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_HOST_HCINT1_STALL register field. */
#define ALT_USB_HOST_HCINT1_STALL_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_STALL field value from a register. */
#define ALT_USB_HOST_HCINT1_STALL_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_HOST_HCINT1_STALL register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_STALL_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : nak
 * 
 * NAK Response Received Interrupt (NAK)
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                       
 * :--------------------------------|:------|:-----------------------------------
 *  ALT_USB_HOST_HCINT1_NAK_E_INACT | 0x0   | No NAK Response Received Interrupt
 *  ALT_USB_HOST_HCINT1_NAK_E_ACT   | 0x1   | NAK Response Received Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_NAK
 * 
 * No NAK Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT1_NAK_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_NAK
 * 
 * NAK Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT1_NAK_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_NAK register field. */
#define ALT_USB_HOST_HCINT1_NAK_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_NAK register field. */
#define ALT_USB_HOST_HCINT1_NAK_MSB        4
/* The width in bits of the ALT_USB_HOST_HCINT1_NAK register field. */
#define ALT_USB_HOST_HCINT1_NAK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_NAK register field value. */
#define ALT_USB_HOST_HCINT1_NAK_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_HOST_HCINT1_NAK register field value. */
#define ALT_USB_HOST_HCINT1_NAK_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_HOST_HCINT1_NAK register field. */
#define ALT_USB_HOST_HCINT1_NAK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_NAK field value from a register. */
#define ALT_USB_HOST_HCINT1_NAK_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_HOST_HCINT1_NAK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_NAK_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : ack
 * 
 * ACK Response Received/Transmitted Interrupt (ACK)
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                                   
 * :--------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_HOST_HCINT1_ACK_E_INACT | 0x0   | No ACK Response Received Transmitted Interrupt
 *  ALT_USB_HOST_HCINT1_ACK_E_ACT   | 0x1   | ACK Response Received Transmitted Interrup    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_ACK
 * 
 * No ACK Response Received Transmitted Interrupt
 */
#define ALT_USB_HOST_HCINT1_ACK_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_ACK
 * 
 * ACK Response Received Transmitted Interrup
 */
#define ALT_USB_HOST_HCINT1_ACK_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_ACK register field. */
#define ALT_USB_HOST_HCINT1_ACK_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_ACK register field. */
#define ALT_USB_HOST_HCINT1_ACK_MSB        5
/* The width in bits of the ALT_USB_HOST_HCINT1_ACK register field. */
#define ALT_USB_HOST_HCINT1_ACK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_ACK register field value. */
#define ALT_USB_HOST_HCINT1_ACK_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_HOST_HCINT1_ACK register field value. */
#define ALT_USB_HOST_HCINT1_ACK_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_HOST_HCINT1_ACK register field. */
#define ALT_USB_HOST_HCINT1_ACK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_ACK field value from a register. */
#define ALT_USB_HOST_HCINT1_ACK_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_HOST_HCINT1_ACK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_ACK_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : nyet
 * 
 * NYET Response Received Interrupt (NYET)
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                        
 * :---------------------------------|:------|:------------------------------------
 *  ALT_USB_HOST_HCINT1_NYET_E_INACT | 0x0   | No NYET Response Received Interrupt
 *  ALT_USB_HOST_HCINT1_NYET_E_ACT   | 0x1   | NYET Response Received Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_NYET
 * 
 * No NYET Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT1_NYET_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_NYET
 * 
 * NYET Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT1_NYET_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_NYET register field. */
#define ALT_USB_HOST_HCINT1_NYET_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_NYET register field. */
#define ALT_USB_HOST_HCINT1_NYET_MSB        6
/* The width in bits of the ALT_USB_HOST_HCINT1_NYET register field. */
#define ALT_USB_HOST_HCINT1_NYET_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_NYET register field value. */
#define ALT_USB_HOST_HCINT1_NYET_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_HOST_HCINT1_NYET register field value. */
#define ALT_USB_HOST_HCINT1_NYET_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_HOST_HCINT1_NYET register field. */
#define ALT_USB_HOST_HCINT1_NYET_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_NYET field value from a register. */
#define ALT_USB_HOST_HCINT1_NYET_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_HOST_HCINT1_NYET register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_NYET_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : xacterr
 * 
 * Transaction Error (XactErr)
 * 
 * Indicates one of the following errors occurred on the USB.
 * 
 * CRC check failure
 * 
 * Timeout
 * 
 * Bit stuff error
 * 
 * False EOP
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description         
 * :------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCINT1_XACTERR_E_INACT | 0x0   | No Transaction Error
 *  ALT_USB_HOST_HCINT1_XACTERR_E_ACT   | 0x1   | Transaction Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_XACTERR
 * 
 * No Transaction Error
 */
#define ALT_USB_HOST_HCINT1_XACTERR_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_XACTERR
 * 
 * Transaction Error
 */
#define ALT_USB_HOST_HCINT1_XACTERR_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_XACTERR register field. */
#define ALT_USB_HOST_HCINT1_XACTERR_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_XACTERR register field. */
#define ALT_USB_HOST_HCINT1_XACTERR_MSB        7
/* The width in bits of the ALT_USB_HOST_HCINT1_XACTERR register field. */
#define ALT_USB_HOST_HCINT1_XACTERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_XACTERR register field value. */
#define ALT_USB_HOST_HCINT1_XACTERR_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_HOST_HCINT1_XACTERR register field value. */
#define ALT_USB_HOST_HCINT1_XACTERR_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_HOST_HCINT1_XACTERR register field. */
#define ALT_USB_HOST_HCINT1_XACTERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_XACTERR field value from a register. */
#define ALT_USB_HOST_HCINT1_XACTERR_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_HOST_HCINT1_XACTERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_XACTERR_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : bblerr
 * 
 * Babble Error (BblErr)
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core..This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description    
 * :-----------------------------------|:------|:----------------
 *  ALT_USB_HOST_HCINT1_BBLERR_E_INACT | 0x0   | No Babble Error
 *  ALT_USB_HOST_HCINT1_BBLERR_E_ACT   | 0x1   | Babble Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_BBLERR
 * 
 * No Babble Error
 */
#define ALT_USB_HOST_HCINT1_BBLERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_BBLERR
 * 
 * Babble Error
 */
#define ALT_USB_HOST_HCINT1_BBLERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_BBLERR register field. */
#define ALT_USB_HOST_HCINT1_BBLERR_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_BBLERR register field. */
#define ALT_USB_HOST_HCINT1_BBLERR_MSB        8
/* The width in bits of the ALT_USB_HOST_HCINT1_BBLERR register field. */
#define ALT_USB_HOST_HCINT1_BBLERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_BBLERR register field value. */
#define ALT_USB_HOST_HCINT1_BBLERR_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_HOST_HCINT1_BBLERR register field value. */
#define ALT_USB_HOST_HCINT1_BBLERR_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_HOST_HCINT1_BBLERR register field. */
#define ALT_USB_HOST_HCINT1_BBLERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_BBLERR field value from a register. */
#define ALT_USB_HOST_HCINT1_BBLERR_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_HOST_HCINT1_BBLERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_BBLERR_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : frmovrun
 * 
 * Frame Overrun (FrmOvrun).In Scatter/Gather DMA mode, the interrupt due to this
 * bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description     
 * :-------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCINT1_FRMOVRUN_E_INACT | 0x0   | No Frame Overrun
 *  ALT_USB_HOST_HCINT1_FRMOVRUN_E_ACT   | 0x1   | Frame Overrun   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_FRMOVRUN
 * 
 * No Frame Overrun
 */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_FRMOVRUN
 * 
 * Frame Overrun
 */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_MSB        9
/* The width in bits of the ALT_USB_HOST_HCINT1_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_FRMOVRUN register field value. */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_SET_MSK    0x00000200
/* The mask used to clear the ALT_USB_HOST_HCINT1_FRMOVRUN register field value. */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_CLR_MSK    0xfffffdff
/* The reset value of the ALT_USB_HOST_HCINT1_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_FRMOVRUN field value from a register. */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_USB_HOST_HCINT1_FRMOVRUN register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : datatglerr
 * 
 * Data Toggle Error (DataTglErr).This bit can be set only by the core and the
 * application should write 1 to clear
 * 
 * it.In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description         
 * :---------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCINT1_DATATGLERR_E_INACT | 0x0   | No Data Toggle Error
 *  ALT_USB_HOST_HCINT1_DATATGLERR_E_ACT   | 0x1   | Data Toggle Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_DATATGLERR
 * 
 * No Data Toggle Error
 */
#define ALT_USB_HOST_HCINT1_DATATGLERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_DATATGLERR
 * 
 * Data Toggle Error
 */
#define ALT_USB_HOST_HCINT1_DATATGLERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT1_DATATGLERR_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT1_DATATGLERR_MSB        10
/* The width in bits of the ALT_USB_HOST_HCINT1_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT1_DATATGLERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_DATATGLERR register field value. */
#define ALT_USB_HOST_HCINT1_DATATGLERR_SET_MSK    0x00000400
/* The mask used to clear the ALT_USB_HOST_HCINT1_DATATGLERR register field value. */
#define ALT_USB_HOST_HCINT1_DATATGLERR_CLR_MSK    0xfffffbff
/* The reset value of the ALT_USB_HOST_HCINT1_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT1_DATATGLERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_DATATGLERR field value from a register. */
#define ALT_USB_HOST_HCINT1_DATATGLERR_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_USB_HOST_HCINT1_DATATGLERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_DATATGLERR_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : bnaintr
 * 
 * BNA (Buffer Not Available) Interrupt (BNAIntr)
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled.
 * 
 * The core generates this interrupt when the descriptor accessed
 * 
 * is not ready for the Core to process. BNA will not be generated
 * 
 * for Isochronous channels.
 * 
 * For non Scatter/Gather DMA mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description     
 * :------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCINT1_BNAINTR_E_INACT | 0x0   | No BNA Interrupt
 *  ALT_USB_HOST_HCINT1_BNAINTR_E_ACT   | 0x1   | BNA Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_BNAINTR
 * 
 * No BNA Interrupt
 */
#define ALT_USB_HOST_HCINT1_BNAINTR_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_BNAINTR
 * 
 * BNA Interrupt
 */
#define ALT_USB_HOST_HCINT1_BNAINTR_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_BNAINTR register field. */
#define ALT_USB_HOST_HCINT1_BNAINTR_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_BNAINTR register field. */
#define ALT_USB_HOST_HCINT1_BNAINTR_MSB        11
/* The width in bits of the ALT_USB_HOST_HCINT1_BNAINTR register field. */
#define ALT_USB_HOST_HCINT1_BNAINTR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_BNAINTR register field value. */
#define ALT_USB_HOST_HCINT1_BNAINTR_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_HOST_HCINT1_BNAINTR register field value. */
#define ALT_USB_HOST_HCINT1_BNAINTR_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_HOST_HCINT1_BNAINTR register field. */
#define ALT_USB_HOST_HCINT1_BNAINTR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_BNAINTR field value from a register. */
#define ALT_USB_HOST_HCINT1_BNAINTR_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_HOST_HCINT1_BNAINTR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_BNAINTR_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : xcs_xact_err
 * 
 * Excessive Transaction Error (XCS_XACT_ERR)
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled. The core sets
 * this bit
 * 
 * when 3 consecutive transaction errors occurred on the USB bus. XCS_XACT_ERR will
 * 
 * not be generated for Isochronous channels.
 * 
 * For non Scatter/Gather DMA mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                   
 * :-------------------------------------------|:------|:-------------------------------
 *  ALT_USB_HOST_HCINT1_XCS_XACT_ERR_E_INACT   | 0x0   | No Excessive Transaction Error
 *  ALT_USB_HOST_HCINT1_XCS_XACT_ERR_E_ACVTIVE | 0x1   | Excessive Transaction Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_XCS_XACT_ERR
 * 
 * No Excessive Transaction Error
 */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_XCS_XACT_ERR
 * 
 * Excessive Transaction Error
 */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_E_ACVTIVE  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_MSB        12
/* The width in bits of the ALT_USB_HOST_HCINT1_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_XCS_XACT_ERR register field value. */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_SET_MSK    0x00001000
/* The mask used to clear the ALT_USB_HOST_HCINT1_XCS_XACT_ERR register field value. */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_CLR_MSK    0xffffefff
/* The reset value of the ALT_USB_HOST_HCINT1_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_XCS_XACT_ERR field value from a register. */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_USB_HOST_HCINT1_XCS_XACT_ERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : desc_lst_rollintr
 * 
 * Descriptor rollover interrupt (DESC_LST_ROLLIntr)
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled. The core sets
 * this bit
 * 
 * when the corresponding channel's descriptor list rolls over.
 * 
 * For non Scatter/Gather DMA mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                     
 * :----------------------------------------------|:------|:---------------------------------
 *  ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_E_INACT | 0x0   | No Descriptor rollover interrupt
 *  ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_E_ACT   | 0x1   | Descriptor rollover interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR
 * 
 * No Descriptor rollover interrupt
 */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR
 * 
 * Descriptor rollover interrupt
 */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_MSB        13
/* The width in bits of the ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR register field value. */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR register field value. */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR field value from a register. */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_SET(value) (((value) << 13) & 0x00002000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCINT1.
 */
struct ALT_USB_HOST_HCINT1_s
{
    uint32_t  xfercompl         :  1;  /* ALT_USB_HOST_HCINT1_XFERCOMPL */
    uint32_t  chhltd            :  1;  /* ALT_USB_HOST_HCINT1_CHHLTD */
    uint32_t  ahberr            :  1;  /* ALT_USB_HOST_HCINT1_AHBERR */
    uint32_t  stall             :  1;  /* ALT_USB_HOST_HCINT1_STALL */
    uint32_t  nak               :  1;  /* ALT_USB_HOST_HCINT1_NAK */
    uint32_t  ack               :  1;  /* ALT_USB_HOST_HCINT1_ACK */
    uint32_t  nyet              :  1;  /* ALT_USB_HOST_HCINT1_NYET */
    uint32_t  xacterr           :  1;  /* ALT_USB_HOST_HCINT1_XACTERR */
    uint32_t  bblerr            :  1;  /* ALT_USB_HOST_HCINT1_BBLERR */
    uint32_t  frmovrun          :  1;  /* ALT_USB_HOST_HCINT1_FRMOVRUN */
    uint32_t  datatglerr        :  1;  /* ALT_USB_HOST_HCINT1_DATATGLERR */
    uint32_t  bnaintr           :  1;  /* ALT_USB_HOST_HCINT1_BNAINTR */
    uint32_t  xcs_xact_err      :  1;  /* ALT_USB_HOST_HCINT1_XCS_XACT_ERR */
    uint32_t  desc_lst_rollintr :  1;  /* ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR */
    uint32_t                    : 18;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HCINT1. */
typedef volatile struct ALT_USB_HOST_HCINT1_s  ALT_USB_HOST_HCINT1_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCINT1 register. */
#define ALT_USB_HOST_HCINT1_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCINT1 register from the beginning of the component. */
#define ALT_USB_HOST_HCINT1_OFST        0x128
/* The address of the ALT_USB_HOST_HCINT1 register. */
#define ALT_USB_HOST_HCINT1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCINT1_OFST))

/*
 * Register : hcintmsk1
 * 
 * Host Channel 1 Interrupt Mask Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                               
 * :--------|:-------|:------|:-------------------------------------------
 *  [0]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK       
 *  [1]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK1_CHHLTDMSK          
 *  [2]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK1_AHBERRMSK          
 *  [3]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK1_STALLMSK           
 *  [4]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK1_NAKMSK             
 *  [5]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK1_ACKMSK             
 *  [6]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK1_NYETMSK            
 *  [7]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK1_XACTERRMSK         
 *  [8]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK1_BBLERRMSK          
 *  [9]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK        
 *  [10]    | RW     | 0x0   | ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK      
 *  [11]    | RW     | 0x0   | ALT_USB_HOST_HCINTMSK1_BNAINTRMSK         
 *  [12]    | ???    | 0x0   | *UNDEFINED*                               
 *  [13]    | RW     | 0x0   | ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK
 *  [31:14] | ???    | 0x0   | *UNDEFINED*                               
 * 
 */
/*
 * Field : xfercomplmsk
 * 
 * Transfer Completed Mask (XferComplMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description
 * :--------------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_MSB        0
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : chhltdmsk
 * 
 * Channel Halted Mask (ChHltdMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_CHHLTDMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_CHHLTDMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_MSB        1
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_CHHLTDMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_CHHLTDMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_HOST_HCINTMSK1_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_CHHLTDMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_HOST_HCINTMSK1_CHHLTDMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : ahberrmsk
 * 
 * AHB Error Mask (AHBErrMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK1_AHBERRMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK1_AHBERRMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_AHBERRMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_AHBERRMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_MSB        2
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_AHBERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_AHBERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_HOST_HCINTMSK1_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_AHBERRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_HOST_HCINTMSK1_AHBERRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : stallmsk
 * 
 * STALL Response Received Interrupt Mask (StallMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_STALLMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_STALLMSK_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_STALLMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_STALLMSK_MSB        3
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_STALLMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_STALLMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_STALLMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_STALLMSK_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_STALLMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_STALLMSK_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_HOST_HCINTMSK1_STALLMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_STALLMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_STALLMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_STALLMSK_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_HOST_HCINTMSK1_STALLMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_STALLMSK_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : nakmsk
 * 
 * NAK Response Received Interrupt Mask (NakMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_NAKMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_NAKMSK_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_NAKMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_NAKMSK_MSB        4
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_NAKMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_NAKMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_NAKMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_NAKMSK_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_NAKMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_NAKMSK_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_HOST_HCINTMSK1_NAKMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_NAKMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_NAKMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_NAKMSK_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_HOST_HCINTMSK1_NAKMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_NAKMSK_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : ackmsk
 * 
 * ACK Response Received/Transmitted Interrupt Mask (AckMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_ACKMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_ACKMSK_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_ACKMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_ACKMSK_MSB        5
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_ACKMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_ACKMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_ACKMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_ACKMSK_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_ACKMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_ACKMSK_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_HOST_HCINTMSK1_ACKMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_ACKMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_ACKMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_ACKMSK_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_HOST_HCINTMSK1_ACKMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_ACKMSK_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : nyetmsk
 * 
 * NYET Response Received Interrupt Mask (NyetMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_NYETMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_NYETMSK_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_NYETMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_NYETMSK_MSB        6
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_NYETMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_NYETMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_NYETMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_NYETMSK_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_NYETMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_NYETMSK_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_HOST_HCINTMSK1_NYETMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_NYETMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_NYETMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_NYETMSK_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_HOST_HCINTMSK1_NYETMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_NYETMSK_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : xacterrmsk
 * 
 * Transaction Error Mask (XactErrMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_XACTERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_XACTERRMSK_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_XACTERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_XACTERRMSK_MSB        7
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_XACTERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_XACTERRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_XACTERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_XACTERRMSK_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_XACTERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_XACTERRMSK_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_HOST_HCINTMSK1_XACTERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_XACTERRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_XACTERRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_XACTERRMSK_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_HOST_HCINTMSK1_XACTERRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_XACTERRMSK_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : bblerrmsk
 * 
 * Babble Error Mask (BblErrMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_BBLERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_BBLERRMSK_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_BBLERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_BBLERRMSK_MSB        8
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_BBLERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_BBLERRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_BBLERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_BBLERRMSK_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_BBLERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_BBLERRMSK_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_HOST_HCINTMSK1_BBLERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_BBLERRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_BBLERRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_BBLERRMSK_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_HOST_HCINTMSK1_BBLERRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_BBLERRMSK_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : frmovrunmsk
 * 
 * Frame Overrun Mask (FrmOvrunMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK_MSB        9
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK_SET_MSK    0x00000200
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK_CLR_MSK    0xfffffdff
/* The reset value of the ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : datatglerrmsk
 * 
 * Data Toggle Error Mask (DataTglErrMsk)
 * 
 * In  scatter/gather  DMA  mode  for  host,
 * 
 * interrupts will not be generated due to the corresponding bits set in
 * 
 * HCINTn.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK_MSB        10
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK_SET_MSK    0x00000400
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK_CLR_MSK    0xfffffbff
/* The reset value of the ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : bnaintrmsk
 * 
 * BNA  (Buffer  Not  Available)  Interrupt  mask  register  (BNAIntrMsk)
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_BNAINTRMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_E_MSK     0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_BNAINTRMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_E_NOMSK   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_MSB        11
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_BNAINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_BNAINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_HOST_HCINTMSK1_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_BNAINTRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_HOST_HCINTMSK1_BNAINTRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : frm_lst_rollintrmsk
 * 
 * Framelist rollover interrupt Mask register(FRM_LST_ROLLIntrMsk)
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description
 * :---------------------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_MSB        13
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_SET(value) (((value) << 13) & 0x00002000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCINTMSK1.
 */
struct ALT_USB_HOST_HCINTMSK1_s
{
    uint32_t  xfercomplmsk        :  1;  /* ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK */
    uint32_t  chhltdmsk           :  1;  /* ALT_USB_HOST_HCINTMSK1_CHHLTDMSK */
    uint32_t  ahberrmsk           :  1;  /* ALT_USB_HOST_HCINTMSK1_AHBERRMSK */
    uint32_t  stallmsk            :  1;  /* ALT_USB_HOST_HCINTMSK1_STALLMSK */
    uint32_t  nakmsk              :  1;  /* ALT_USB_HOST_HCINTMSK1_NAKMSK */
    uint32_t  ackmsk              :  1;  /* ALT_USB_HOST_HCINTMSK1_ACKMSK */
    uint32_t  nyetmsk             :  1;  /* ALT_USB_HOST_HCINTMSK1_NYETMSK */
    uint32_t  xacterrmsk          :  1;  /* ALT_USB_HOST_HCINTMSK1_XACTERRMSK */
    uint32_t  bblerrmsk           :  1;  /* ALT_USB_HOST_HCINTMSK1_BBLERRMSK */
    uint32_t  frmovrunmsk         :  1;  /* ALT_USB_HOST_HCINTMSK1_FRMOVRUNMSK */
    uint32_t  datatglerrmsk       :  1;  /* ALT_USB_HOST_HCINTMSK1_DATATGLERRMSK */
    uint32_t  bnaintrmsk          :  1;  /* ALT_USB_HOST_HCINTMSK1_BNAINTRMSK */
    uint32_t                      :  1;  /* *UNDEFINED* */
    uint32_t  frm_lst_rollintrmsk :  1;  /* ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK */
    uint32_t                      : 18;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HCINTMSK1. */
typedef volatile struct ALT_USB_HOST_HCINTMSK1_s  ALT_USB_HOST_HCINTMSK1_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCINTMSK1 register. */
#define ALT_USB_HOST_HCINTMSK1_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCINTMSK1 register from the beginning of the component. */
#define ALT_USB_HOST_HCINTMSK1_OFST        0x12c
/* The address of the ALT_USB_HOST_HCINTMSK1 register. */
#define ALT_USB_HOST_HCINTMSK1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCINTMSK1_OFST))

/*
 * Register : hctsiz1
 * 
 * Host Channel 1 Transfer Size Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                  
 * :--------|:-------|:------|:------------------------------
 *  [18:0]  | RW     | 0x0   | ALT_USB_HOST_HCTSIZ1_XFERSIZE
 *  [28:19] | RW     | 0x0   | ALT_USB_HOST_HCTSIZ1_PKTCNT  
 *  [30:29] | RW     | 0x0   | ALT_USB_HOST_HCTSIZ1_PID     
 *  [31]    | RW     | 0x0   | ALT_USB_HOST_HCTSIZ1_DOPNG   
 * 
 */
/*
 * Field : xfersize
 * 
 * Transfer Size (XferSize)
 * 
 * For an OUT, this field is the number of data bytes the host sends
 * 
 * during the transfer.
 * 
 * For an IN, this field is the buffer size that the application has
 * 
 * Reserved For the transfer. The application is expected to
 * 
 * program this field as an integer multiple of the maximum packet
 * 
 * size For IN transactions (periodic and non-periodic).
 * 
 * The width of this counter is specified as Width of Transfer Size
 * 
 * Counters
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ1_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ1_XFERSIZE_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ1_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ1_XFERSIZE_MSB        18
/* The width in bits of the ALT_USB_HOST_HCTSIZ1_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ1_XFERSIZE_WIDTH      19
/* The mask used to set the ALT_USB_HOST_HCTSIZ1_XFERSIZE register field value. */
#define ALT_USB_HOST_HCTSIZ1_XFERSIZE_SET_MSK    0x0007ffff
/* The mask used to clear the ALT_USB_HOST_HCTSIZ1_XFERSIZE register field value. */
#define ALT_USB_HOST_HCTSIZ1_XFERSIZE_CLR_MSK    0xfff80000
/* The reset value of the ALT_USB_HOST_HCTSIZ1_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ1_XFERSIZE_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ1_XFERSIZE field value from a register. */
#define ALT_USB_HOST_HCTSIZ1_XFERSIZE_GET(value) (((value) & 0x0007ffff) >> 0)
/* Produces a ALT_USB_HOST_HCTSIZ1_XFERSIZE register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ1_XFERSIZE_SET(value) (((value) << 0) & 0x0007ffff)

/*
 * Field : pktcnt
 * 
 * Packet Count (PktCnt)
 * 
 * This field is programmed by the application with the expected
 * 
 * number of packets to be transmitted (OUT) or received (IN).
 * 
 * The host decrements this count on every successful
 * 
 * transmission or reception of an OUT/IN packet. Once this count
 * 
 * reaches zero, the application is interrupted to indicate normal
 * 
 * completion.
 * 
 * The width of this counter is specified as Width of Packet
 * 
 * Counters
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ1_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ1_PKTCNT_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ1_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ1_PKTCNT_MSB        28
/* The width in bits of the ALT_USB_HOST_HCTSIZ1_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ1_PKTCNT_WIDTH      10
/* The mask used to set the ALT_USB_HOST_HCTSIZ1_PKTCNT register field value. */
#define ALT_USB_HOST_HCTSIZ1_PKTCNT_SET_MSK    0x1ff80000
/* The mask used to clear the ALT_USB_HOST_HCTSIZ1_PKTCNT register field value. */
#define ALT_USB_HOST_HCTSIZ1_PKTCNT_CLR_MSK    0xe007ffff
/* The reset value of the ALT_USB_HOST_HCTSIZ1_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ1_PKTCNT_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ1_PKTCNT field value from a register. */
#define ALT_USB_HOST_HCTSIZ1_PKTCNT_GET(value) (((value) & 0x1ff80000) >> 19)
/* Produces a ALT_USB_HOST_HCTSIZ1_PKTCNT register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ1_PKTCNT_SET(value) (((value) << 19) & 0x1ff80000)

/*
 * Field : pid
 * 
 * PID (Pid)
 * 
 * The application programs this field with the type of PID to use For
 * 
 * the initial transaction. The host maintains this field For the rest of
 * 
 * the transfer.
 * 
 * 2'b00: DATA0
 * 
 * 2'b01: DATA2
 * 
 * 2'b10: DATA1
 * 
 * 2'b11: MDATA (non-control)/SETUP (control)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                        
 * :---------------------------------|:------|:------------------------------------
 *  ALT_USB_HOST_HCTSIZ1_PID_E_DATA0 | 0x0   | DATA0                              
 *  ALT_USB_HOST_HCTSIZ1_PID_E_DATA2 | 0x1   | DATA2                              
 *  ALT_USB_HOST_HCTSIZ1_PID_E_DATA1 | 0x2   | DATA1                              
 *  ALT_USB_HOST_HCTSIZ1_PID_E_MDATA | 0x3   | MDATA (non-control)/SETUP (control)
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ1_PID
 * 
 * DATA0
 */
#define ALT_USB_HOST_HCTSIZ1_PID_E_DATA0    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ1_PID
 * 
 * DATA2
 */
#define ALT_USB_HOST_HCTSIZ1_PID_E_DATA2    0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ1_PID
 * 
 * DATA1
 */
#define ALT_USB_HOST_HCTSIZ1_PID_E_DATA1    0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ1_PID
 * 
 * MDATA (non-control)/SETUP (control)
 */
#define ALT_USB_HOST_HCTSIZ1_PID_E_MDATA    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ1_PID register field. */
#define ALT_USB_HOST_HCTSIZ1_PID_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ1_PID register field. */
#define ALT_USB_HOST_HCTSIZ1_PID_MSB        30
/* The width in bits of the ALT_USB_HOST_HCTSIZ1_PID register field. */
#define ALT_USB_HOST_HCTSIZ1_PID_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCTSIZ1_PID register field value. */
#define ALT_USB_HOST_HCTSIZ1_PID_SET_MSK    0x60000000
/* The mask used to clear the ALT_USB_HOST_HCTSIZ1_PID register field value. */
#define ALT_USB_HOST_HCTSIZ1_PID_CLR_MSK    0x9fffffff
/* The reset value of the ALT_USB_HOST_HCTSIZ1_PID register field. */
#define ALT_USB_HOST_HCTSIZ1_PID_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ1_PID field value from a register. */
#define ALT_USB_HOST_HCTSIZ1_PID_GET(value) (((value) & 0x60000000) >> 29)
/* Produces a ALT_USB_HOST_HCTSIZ1_PID register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ1_PID_SET(value) (((value) << 29) & 0x60000000)

/*
 * Field : dopng
 * 
 * Do Ping (DoPng)
 * 
 * This bit is used only For OUT transfers.
 * 
 * Setting this field to 1 directs the host to do PING protocol.
 * 
 * Note: Do not Set this bit For IN transfers. If this bit is Set For
 * 
 * for IN transfers it disables the channel.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description     
 * :------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCTSIZ1_DOPNG_E_NOPING | 0x0   | No ping protocol
 *  ALT_USB_HOST_HCTSIZ1_DOPNG_E_PING   | 0x1   | Ping protocol   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ1_DOPNG
 * 
 * No ping protocol
 */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_E_NOPING 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ1_DOPNG
 * 
 * Ping protocol
 */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_E_PING   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ1_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ1_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_MSB        31
/* The width in bits of the ALT_USB_HOST_HCTSIZ1_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCTSIZ1_DOPNG register field value. */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCTSIZ1_DOPNG register field value. */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCTSIZ1_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ1_DOPNG field value from a register. */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCTSIZ1_DOPNG register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCTSIZ1.
 */
struct ALT_USB_HOST_HCTSIZ1_s
{
    uint32_t  xfersize : 19;  /* ALT_USB_HOST_HCTSIZ1_XFERSIZE */
    uint32_t  pktcnt   : 10;  /* ALT_USB_HOST_HCTSIZ1_PKTCNT */
    uint32_t  pid      :  2;  /* ALT_USB_HOST_HCTSIZ1_PID */
    uint32_t  dopng    :  1;  /* ALT_USB_HOST_HCTSIZ1_DOPNG */
};

/* The typedef declaration for register ALT_USB_HOST_HCTSIZ1. */
typedef volatile struct ALT_USB_HOST_HCTSIZ1_s  ALT_USB_HOST_HCTSIZ1_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCTSIZ1 register. */
#define ALT_USB_HOST_HCTSIZ1_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCTSIZ1 register from the beginning of the component. */
#define ALT_USB_HOST_HCTSIZ1_OFST        0x130
/* The address of the ALT_USB_HOST_HCTSIZ1 register. */
#define ALT_USB_HOST_HCTSIZ1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCTSIZ1_OFST))

/*
 * Register : hcdma1
 * 
 * Host Channel 1 DMA Address Register
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description               
 * :-------|:-------|:------|:---------------------------
 *  [31:0] | RW     | 0x0   | ALT_USB_HOST_HCDMA1_HCDMA1
 * 
 */
/*
 * Field : hcdma1
 * 
 * Buffer DMA Mode:
 * 
 * [31:0] DMA Address (DMAAddr)
 * 
 * This field holds the start address in the external memory from which the data
 * for
 * 
 * the endpoint must be fetched or to which it must be stored. This register is
 * 
 * incremented on every AHB transaction.
 * 
 * Scatter-Gather DMA (DescDMA) Mode:
 * 
 * [31:9] (Non Isoc) Non-Isochronous:
 * 
 * [31:N] (Isoc) Isochronous:
 * 
 * This field holds the start address of the 512 bytes
 * 
 * page.  The first descriptor in the list should be located
 * 
 * in this address. The first descriptor may be or may
 * 
 * not be ready. The core starts processing the list from
 * 
 * the CTD value.
 * 
 * This field holds the address of the 2*(nTD+1) bytes of
 * 
 * locations in which the isochronous descriptors are
 * 
 * present where N is based on nTD as per Table below
 * 
 * [31:N]  Base Address
 * 
 * [N-1:3]  Offset
 * 
 * [2:0]  000
 * 
 * HS ISOC
 * 
 * nTD   N
 * 
 * 7     6
 * 
 * 15    7
 * 
 * 31    8
 * 
 * 63    9
 * 
 * 127  10
 * 
 * 255  11
 * 
 * FS ISOC
 * 
 * nTD N
 * 
 * 1  4
 * 
 * 3  5
 * 
 * 7  6
 * 
 * 15  7
 * 
 * 31  8
 * 
 * 63  9
 * 
 * [N-1:3] (Isoc):
 * 
 * [8:3] (Non Isoc): Current Transfer Desc(CTD):
 * 
 * Non Isochronous:
 * 
 * This value is in terms of number of descriptors. The values can be from 0 to 63.
 * 
 * 0 -  1 descriptor.
 * 
 * 63 - 64 descriptors.
 * 
 * This field indicates the current descriptor processed in the list. This field is
 * updated
 * 
 * both by application and the core. For example, if the application enables the
 * 
 * channel after programming CTD=5, then the core will start processing the 6th
 * 
 * descriptor. The address is obtained by adding a value of (8bytes*5=) 40(decimal)
 * 
 * to DMAAddr.
 * 
 * Isochronous:
 * 
 * CTD for isochronous is based on the current frame/(micro)frame value. Need to be
 * set
 * 
 * to zero by application.Scatter-Gather DMA (DescDMA) Mode:
 * 
 * [31:9] (Non Isoc) Non-Isochronous:
 * 
 * [31:N] (Isoc) Isochronous:
 * 
 * This field holds the start address of the 512 bytes
 * 
 * page.  The first descriptor in the list should be located
 * 
 * in this address. The first descriptor may be or may
 * 
 * not be ready. The core starts processing the list from
 * 
 * the CTD value.
 * 
 * This field holds the address of the 2*(nTD+1) bytes of
 * 
 * locations in which the isochronous descriptors are
 * 
 * present where N is based on nTD as per Table below
 * 
 * [31:N]  Base Address
 * 
 * [N-1:3]  Offset
 * 
 * [2:0]  000
 * 
 * HS ISOC
 * 
 * nTD   N
 * 
 * 7     6
 * 
 * 15    7
 * 
 * 31    8
 * 
 * 63    9
 * 
 * 127  10
 * 
 * 255  11
 * 
 * FS ISOC
 * 
 * nTD N
 * 
 * 1  4
 * 
 * 3  5
 * 
 * 7  6
 * 
 * 15  7
 * 
 * 31  8
 * 
 * 63  9
 * 
 * [N-1:3] (Isoc):
 * 
 * [8:3] (Non Isoc): Current Transfer Desc(CTD):
 * 
 * Non Isochronous:
 * 
 * This value is in terms of number of descriptors. The values can be from 0 to 63.
 * 
 * 0 -  1 descriptor.
 * 
 * 63 - 64 descriptors.
 * 
 * This field indicates the current descriptor processed in the list. This field is
 * updated
 * 
 * both by application and the core. For example, if the application enables the
 * 
 * channel after programming CTD=5, then the core will start processing the 6th
 * 
 * descriptor. The address is obtained by adding a value of (8bytes*5=) 40(decimal)
 * 
 * to DMAAddr.
 * 
 * Isochronous:
 * 
 * CTD for isochronous is based on the current frame/(micro)frame value. Need to be
 * set
 * 
 * to zero by application.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCDMA1_HCDMA1 register field. */
#define ALT_USB_HOST_HCDMA1_HCDMA1_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCDMA1_HCDMA1 register field. */
#define ALT_USB_HOST_HCDMA1_HCDMA1_MSB        31
/* The width in bits of the ALT_USB_HOST_HCDMA1_HCDMA1 register field. */
#define ALT_USB_HOST_HCDMA1_HCDMA1_WIDTH      32
/* The mask used to set the ALT_USB_HOST_HCDMA1_HCDMA1 register field value. */
#define ALT_USB_HOST_HCDMA1_HCDMA1_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_HOST_HCDMA1_HCDMA1 register field value. */
#define ALT_USB_HOST_HCDMA1_HCDMA1_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_HOST_HCDMA1_HCDMA1 register field. */
#define ALT_USB_HOST_HCDMA1_HCDMA1_RESET      0x0
/* Extracts the ALT_USB_HOST_HCDMA1_HCDMA1 field value from a register. */
#define ALT_USB_HOST_HCDMA1_HCDMA1_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_HOST_HCDMA1_HCDMA1 register field value suitable for setting the register. */
#define ALT_USB_HOST_HCDMA1_HCDMA1_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCDMA1.
 */
struct ALT_USB_HOST_HCDMA1_s
{
    uint32_t  hcdma1 : 32;  /* ALT_USB_HOST_HCDMA1_HCDMA1 */
};

/* The typedef declaration for register ALT_USB_HOST_HCDMA1. */
typedef volatile struct ALT_USB_HOST_HCDMA1_s  ALT_USB_HOST_HCDMA1_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCDMA1 register. */
#define ALT_USB_HOST_HCDMA1_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCDMA1 register from the beginning of the component. */
#define ALT_USB_HOST_HCDMA1_OFST        0x134
/* The address of the ALT_USB_HOST_HCDMA1 register. */
#define ALT_USB_HOST_HCDMA1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCDMA1_OFST))

/*
 * Register : hcdmab1
 * 
 * Host Channel 1 DMA Buffer Address Register
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [31:0] | RW     | 0x0   | ALT_USB_HOST_HCDMAB1_HCDMAB1
 * 
 */
/*
 * Field : hcdmab1
 * 
 * Holds the current buffer address.
 * 
 * This register is updated as and when the data transfer for the corresponding end
 * point
 * 
 * is in progress. This register is present only in Scatter/Gather DMA mode.
 * Otherwise this
 * 
 * field is reserved.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCDMAB1_HCDMAB1 register field. */
#define ALT_USB_HOST_HCDMAB1_HCDMAB1_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCDMAB1_HCDMAB1 register field. */
#define ALT_USB_HOST_HCDMAB1_HCDMAB1_MSB        31
/* The width in bits of the ALT_USB_HOST_HCDMAB1_HCDMAB1 register field. */
#define ALT_USB_HOST_HCDMAB1_HCDMAB1_WIDTH      32
/* The mask used to set the ALT_USB_HOST_HCDMAB1_HCDMAB1 register field value. */
#define ALT_USB_HOST_HCDMAB1_HCDMAB1_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_HOST_HCDMAB1_HCDMAB1 register field value. */
#define ALT_USB_HOST_HCDMAB1_HCDMAB1_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_HOST_HCDMAB1_HCDMAB1 register field. */
#define ALT_USB_HOST_HCDMAB1_HCDMAB1_RESET      0x0
/* Extracts the ALT_USB_HOST_HCDMAB1_HCDMAB1 field value from a register. */
#define ALT_USB_HOST_HCDMAB1_HCDMAB1_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_HOST_HCDMAB1_HCDMAB1 register field value suitable for setting the register. */
#define ALT_USB_HOST_HCDMAB1_HCDMAB1_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCDMAB1.
 */
struct ALT_USB_HOST_HCDMAB1_s
{
    uint32_t  hcdmab1 : 32;  /* ALT_USB_HOST_HCDMAB1_HCDMAB1 */
};

/* The typedef declaration for register ALT_USB_HOST_HCDMAB1. */
typedef volatile struct ALT_USB_HOST_HCDMAB1_s  ALT_USB_HOST_HCDMAB1_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCDMAB1 register. */
#define ALT_USB_HOST_HCDMAB1_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCDMAB1 register from the beginning of the component. */
#define ALT_USB_HOST_HCDMAB1_OFST        0x13c
/* The address of the ALT_USB_HOST_HCDMAB1 register. */
#define ALT_USB_HOST_HCDMAB1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCDMAB1_OFST))

/*
 * Register : hcchar2
 * 
 * Host Channel 2 Characteristics Register
 * 
 * Register Layout
 * 
 *  Bits    | Access   | Reset | Description                 
 * :--------|:---------|:------|:-----------------------------
 *  [10:0]  | RW       | 0x0   | ALT_USB_HOST_HCCHAR2_MPS    
 *  [14:11] | RW       | 0x0   | ALT_USB_HOST_HCCHAR2_EPNUM  
 *  [15]    | RW       | 0x0   | ALT_USB_HOST_HCCHAR2_EPDIR  
 *  [16]    | ???      | 0x0   | *UNDEFINED*                 
 *  [17]    | RW       | 0x0   | ALT_USB_HOST_HCCHAR2_LSPDDEV
 *  [19:18] | RW       | 0x0   | ALT_USB_HOST_HCCHAR2_EPTYPE 
 *  [21:20] | RW       | 0x0   | ALT_USB_HOST_HCCHAR2_EC     
 *  [28:22] | RW       | 0x0   | ALT_USB_HOST_HCCHAR2_DEVADDR
 *  [29]    | RW       | 0x0   | ALT_USB_HOST_HCCHAR2_ODDFRM 
 *  [30]    | R-W once | 0x0   | ALT_USB_HOST_HCCHAR2_CHDIS  
 *  [31]    | R-W once | 0x0   | ALT_USB_HOST_HCCHAR2_CHENA  
 * 
 */
/*
 * Field : mps
 * 
 * Maximum Packet Size (MPS)
 * 
 * Indicates the maximum packet size of the associated endpoint.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_MPS register field. */
#define ALT_USB_HOST_HCCHAR2_MPS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_MPS register field. */
#define ALT_USB_HOST_HCCHAR2_MPS_MSB        10
/* The width in bits of the ALT_USB_HOST_HCCHAR2_MPS register field. */
#define ALT_USB_HOST_HCCHAR2_MPS_WIDTH      11
/* The mask used to set the ALT_USB_HOST_HCCHAR2_MPS register field value. */
#define ALT_USB_HOST_HCCHAR2_MPS_SET_MSK    0x000007ff
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_MPS register field value. */
#define ALT_USB_HOST_HCCHAR2_MPS_CLR_MSK    0xfffff800
/* The reset value of the ALT_USB_HOST_HCCHAR2_MPS register field. */
#define ALT_USB_HOST_HCCHAR2_MPS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_MPS field value from a register. */
#define ALT_USB_HOST_HCCHAR2_MPS_GET(value) (((value) & 0x000007ff) >> 0)
/* Produces a ALT_USB_HOST_HCCHAR2_MPS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_MPS_SET(value) (((value) << 0) & 0x000007ff)

/*
 * Field : epnum
 * 
 * Endpoint Number (EPNum)
 * 
 * Indicates the endpoint number on the device serving as the data
 * 
 * source or sink.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description  
 * :-------------------------------------|:------|:--------------
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT0  | 0x0   | End point  0 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT1  | 0x1   | End point  1 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT2  | 0x2   | End point  2 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT3  | 0x3   | End point  3 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT4  | 0x4   | End point  4 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT5  | 0x5   | End point  5 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT6  | 0x6   | End point  6 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT7  | 0x7   | End point  7 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT8  | 0x8   | End point  8 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT9  | 0x9   | End point  9 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT10 | 0xa   | End point  10
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT11 | 0xb   | End point  11
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT12 | 0xc   | End point  12
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT13 | 0xd   | End point  13
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT14 | 0xe   | End point  14
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT15 | 0xf   | End point  15
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  0
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT0     0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  1
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT1     0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  2
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT2     0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  3
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT3     0x3
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  4
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT4     0x4
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  5
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT5     0x5
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  6
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT6     0x6
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  7
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT7     0x7
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  8
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT8     0x8
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  9
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT9     0x9
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  10
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT10    0xa
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  11
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT11    0xb
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  12
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT12    0xc
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  13
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT13    0xd
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  14
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT14    0xe
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  15
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT15    0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR2_EPNUM_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR2_EPNUM_MSB        14
/* The width in bits of the ALT_USB_HOST_HCCHAR2_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR2_EPNUM_WIDTH      4
/* The mask used to set the ALT_USB_HOST_HCCHAR2_EPNUM register field value. */
#define ALT_USB_HOST_HCCHAR2_EPNUM_SET_MSK    0x00007800
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_EPNUM register field value. */
#define ALT_USB_HOST_HCCHAR2_EPNUM_CLR_MSK    0xffff87ff
/* The reset value of the ALT_USB_HOST_HCCHAR2_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR2_EPNUM_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_EPNUM field value from a register. */
#define ALT_USB_HOST_HCCHAR2_EPNUM_GET(value) (((value) & 0x00007800) >> 11)
/* Produces a ALT_USB_HOST_HCCHAR2_EPNUM register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_EPNUM_SET(value) (((value) << 11) & 0x00007800)

/*
 * Field : epdir
 * 
 * Endpoint Direction (EPDir)
 * 
 * Indicates whether the transaction is IN or OUT.
 * 
 * 1'b0: OUT
 * 
 * 1'b1: IN
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description  
 * :---------------------------------|:------|:--------------
 *  ALT_USB_HOST_HCCHAR2_EPDIR_E_OUT | 0x0   | OUT Direction
 *  ALT_USB_HOST_HCCHAR2_EPDIR_E_IN  | 0x1   | IN Direction 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPDIR
 * 
 * OUT Direction
 */
#define ALT_USB_HOST_HCCHAR2_EPDIR_E_OUT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPDIR
 * 
 * IN Direction
 */
#define ALT_USB_HOST_HCCHAR2_EPDIR_E_IN     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR2_EPDIR_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR2_EPDIR_MSB        15
/* The width in bits of the ALT_USB_HOST_HCCHAR2_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR2_EPDIR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR2_EPDIR register field value. */
#define ALT_USB_HOST_HCCHAR2_EPDIR_SET_MSK    0x00008000
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_EPDIR register field value. */
#define ALT_USB_HOST_HCCHAR2_EPDIR_CLR_MSK    0xffff7fff
/* The reset value of the ALT_USB_HOST_HCCHAR2_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR2_EPDIR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_EPDIR field value from a register. */
#define ALT_USB_HOST_HCCHAR2_EPDIR_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_USB_HOST_HCCHAR2_EPDIR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_EPDIR_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : lspddev
 * 
 * Low-Speed Device (LSpdDev)
 * 
 * This field is Set by the application to indicate that this channel is
 * 
 * communicating to a low-speed device.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                            
 * :------------------------------------|:------|:----------------------------------------
 *  ALT_USB_HOST_HCCHAR2_LSPDDEV_E_DISD | 0x0   | Not Communicating with low speed device
 *  ALT_USB_HOST_HCCHAR2_LSPDDEV_E_END  | 0x1   | Communicating with low speed device    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_LSPDDEV
 * 
 * Not Communicating with low speed device
 */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_LSPDDEV
 * 
 * Communicating with low speed device
 */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_MSB        17
/* The width in bits of the ALT_USB_HOST_HCCHAR2_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR2_LSPDDEV register field value. */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_SET_MSK    0x00020000
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_LSPDDEV register field value. */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_CLR_MSK    0xfffdffff
/* The reset value of the ALT_USB_HOST_HCCHAR2_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_LSPDDEV field value from a register. */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_USB_HOST_HCCHAR2_LSPDDEV register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : eptype
 * 
 * Endpoint Type (EPType)
 * 
 * Indicates the transfer type selected.
 * 
 * 2'b00: Control
 * 
 * 2'b01: Isochronous
 * 
 * 2'b10: Bulk
 * 
 * 2'b11: Interrupt
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCCHAR2_EPTYPE_E_CTL    | 0x0   | Control    
 *  ALT_USB_HOST_HCCHAR2_EPTYPE_E_ISOC   | 0x1   | Isochronous
 *  ALT_USB_HOST_HCCHAR2_EPTYPE_E_BULK   | 0x2   | Bulk       
 *  ALT_USB_HOST_HCCHAR2_EPTYPE_E_INTERR | 0x3   | Interrupt  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPTYPE
 * 
 * Control
 */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_E_CTL       0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPTYPE
 * 
 * Isochronous
 */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_E_ISOC      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPTYPE
 * 
 * Bulk
 */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_E_BULK      0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPTYPE
 * 
 * Interrupt
 */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_E_INTERR    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_MSB        19
/* The width in bits of the ALT_USB_HOST_HCCHAR2_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCCHAR2_EPTYPE register field value. */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_SET_MSK    0x000c0000
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_EPTYPE register field value. */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_CLR_MSK    0xfff3ffff
/* The reset value of the ALT_USB_HOST_HCCHAR2_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_EPTYPE field value from a register. */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_GET(value) (((value) & 0x000c0000) >> 18)
/* Produces a ALT_USB_HOST_HCCHAR2_EPTYPE register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_SET(value) (((value) << 18) & 0x000c0000)

/*
 * Field : ec
 * 
 * Multi Count (MC) / Error Count (EC)
 * 
 * When the Split Enable bit of the Host Channel-n Split Control
 * 
 * register (HCSPLTn.SpltEna) is reset (1'b0), this field indicates to
 * 
 * the host the number of transactions that must be executed per
 * 
 * microframe For this periodic endpoint. For non periodic transfers,
 * 
 * this field is used only in DMA mode, and specifies the number
 * 
 * packets to be fetched For this channel before the internal DMA
 * 
 * engine changes arbitration.
 * 
 * 2'b00: Reserved This field yields undefined results.
 * 
 * 2'b01: 1 transaction
 * 
 * 2'b10: 2 transactions to be issued For this endpoint per
 * 
 * microframe
 * 
 * 2'b11: 3 transactions to be issued For this endpoint per
 * 
 * microframe
 * 
 * When HCSPLTn.SpltEna is Set (1'b1), this field indicates the
 * 
 * number of immediate retries to be performed For a periodic split
 * 
 * transactions on transaction errors. This field must be Set to at
 * 
 * least 2'b01.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                  
 * :-------------------------------------|:------|:----------------------------------------------
 *  ALT_USB_HOST_HCCHAR2_EC_E_RSVD       | 0x0   | Reserved This field yields undefined result  
 *  ALT_USB_HOST_HCCHAR2_EC_E_TRANSONE   | 0x1   | 1 transaction                                
 *  ALT_USB_HOST_HCCHAR2_EC_E_TRANSTWO   | 0x2   | 2 transactions to be issued for this endpoint
 * :                                     |       | per microframe                               
 *  ALT_USB_HOST_HCCHAR2_EC_E_TRANSTHREE | 0x3   | 3 transactions to be issued for this endpoint
 * :                                     |       | per microframe                               
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EC
 * 
 * Reserved This field yields undefined result
 */
#define ALT_USB_HOST_HCCHAR2_EC_E_RSVD          0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EC
 * 
 * 1 transaction
 */
#define ALT_USB_HOST_HCCHAR2_EC_E_TRANSONE      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EC
 * 
 * 2 transactions to be issued for this endpoint per microframe
 */
#define ALT_USB_HOST_HCCHAR2_EC_E_TRANSTWO      0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EC
 * 
 * 3 transactions to be issued for this endpoint per microframe
 */
#define ALT_USB_HOST_HCCHAR2_EC_E_TRANSTHREE    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_EC register field. */
#define ALT_USB_HOST_HCCHAR2_EC_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_EC register field. */
#define ALT_USB_HOST_HCCHAR2_EC_MSB        21
/* The width in bits of the ALT_USB_HOST_HCCHAR2_EC register field. */
#define ALT_USB_HOST_HCCHAR2_EC_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCCHAR2_EC register field value. */
#define ALT_USB_HOST_HCCHAR2_EC_SET_MSK    0x00300000
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_EC register field value. */
#define ALT_USB_HOST_HCCHAR2_EC_CLR_MSK    0xffcfffff
/* The reset value of the ALT_USB_HOST_HCCHAR2_EC register field. */
#define ALT_USB_HOST_HCCHAR2_EC_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_EC field value from a register. */
#define ALT_USB_HOST_HCCHAR2_EC_GET(value) (((value) & 0x00300000) >> 20)
/* Produces a ALT_USB_HOST_HCCHAR2_EC register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_EC_SET(value) (((value) << 20) & 0x00300000)

/*
 * Field : devaddr
 * 
 * Device Address (DevAddr)
 * 
 * This field selects the specific device serving as the data source
 * 
 * or sink.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR2_DEVADDR_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR2_DEVADDR_MSB        28
/* The width in bits of the ALT_USB_HOST_HCCHAR2_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR2_DEVADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCCHAR2_DEVADDR register field value. */
#define ALT_USB_HOST_HCCHAR2_DEVADDR_SET_MSK    0x1fc00000
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_DEVADDR register field value. */
#define ALT_USB_HOST_HCCHAR2_DEVADDR_CLR_MSK    0xe03fffff
/* The reset value of the ALT_USB_HOST_HCCHAR2_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR2_DEVADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_DEVADDR field value from a register. */
#define ALT_USB_HOST_HCCHAR2_DEVADDR_GET(value) (((value) & 0x1fc00000) >> 22)
/* Produces a ALT_USB_HOST_HCCHAR2_DEVADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_DEVADDR_SET(value) (((value) << 22) & 0x1fc00000)

/*
 * Field : oddfrm
 * 
 * Odd Frame (OddFrm)
 * 
 * This field is set (reset) by the application to indicate that the OTG host must
 * perform
 * 
 * a transfer in an odd (micro)frame. This field is applicable for only periodic
 * 
 * (isochronous and interrupt) transactions.
 * 
 * 1'b0: Even (micro)frame
 * 
 * 1'b1: Odd (micro)frame
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_ODDFRM register field. */
#define ALT_USB_HOST_HCCHAR2_ODDFRM_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_ODDFRM register field. */
#define ALT_USB_HOST_HCCHAR2_ODDFRM_MSB        29
/* The width in bits of the ALT_USB_HOST_HCCHAR2_ODDFRM register field. */
#define ALT_USB_HOST_HCCHAR2_ODDFRM_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR2_ODDFRM register field value. */
#define ALT_USB_HOST_HCCHAR2_ODDFRM_SET_MSK    0x20000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_ODDFRM register field value. */
#define ALT_USB_HOST_HCCHAR2_ODDFRM_CLR_MSK    0xdfffffff
/* The reset value of the ALT_USB_HOST_HCCHAR2_ODDFRM register field. */
#define ALT_USB_HOST_HCCHAR2_ODDFRM_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_ODDFRM field value from a register. */
#define ALT_USB_HOST_HCCHAR2_ODDFRM_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_USB_HOST_HCCHAR2_ODDFRM register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_ODDFRM_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : chdis
 * 
 * Channel Disable (ChDis)
 * 
 * The application sets this bit to stop transmitting/receiving data
 * 
 * on a channel, even before the transfer For that channel is
 * 
 * complete. The application must wait For the Channel Disabled
 * 
 * interrupt before treating the channel as disabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                
 * :-----------------------------------|:------|:----------------------------
 *  ALT_USB_HOST_HCCHAR2_CHDIS_E_INACT | 0x0   | Transmit/Recieve normal    
 *  ALT_USB_HOST_HCCHAR2_CHDIS_E_ACT   | 0x1   | Stop transmitting/receiving
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_CHDIS
 * 
 * Transmit/Recieve normal
 */
#define ALT_USB_HOST_HCCHAR2_CHDIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_CHDIS
 * 
 * Stop transmitting/receiving
 */
#define ALT_USB_HOST_HCCHAR2_CHDIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR2_CHDIS_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR2_CHDIS_MSB        30
/* The width in bits of the ALT_USB_HOST_HCCHAR2_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR2_CHDIS_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR2_CHDIS register field value. */
#define ALT_USB_HOST_HCCHAR2_CHDIS_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_CHDIS register field value. */
#define ALT_USB_HOST_HCCHAR2_CHDIS_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_HOST_HCCHAR2_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR2_CHDIS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_CHDIS field value from a register. */
#define ALT_USB_HOST_HCCHAR2_CHDIS_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_HOST_HCCHAR2_CHDIS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_CHDIS_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : chena
 * 
 * Channel Enable (ChEna)
 * 
 * When Scatter/Gather mode is enabled
 * 
 * 1'b0: Indicates that the descriptor structure is not yet ready.
 * 
 * 1'b1:  Indicates  that  the  descriptor  structure  and  data  buffer  with
 * 
 * data is setup and this channel can access the descriptor.
 * 
 * When Scatter/Gather mode is disabled
 * 
 * This field is set by the application and cleared by the OTG host.
 * 
 * 1'b0: Channel disabled
 * 
 * 1'b1: Channel enabled
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                                     
 * :-----------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_HOST_HCCHAR2_CHENA_E_INACT | 0x0   | Indicates that the descriptor structure is not  
 * :                                   |       | yet ready                                       
 *  ALT_USB_HOST_HCCHAR2_CHENA_E_ACT   | 0x1   | Indicates  that  the  descriptor  structure  and
 * :                                   |       | data  buffer  with data is setup and this       
 * :                                   |       | channel can access the descriptor               
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_CHENA
 * 
 * Indicates that the descriptor structure is not yet ready
 */
#define ALT_USB_HOST_HCCHAR2_CHENA_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_CHENA
 * 
 * Indicates  that  the  descriptor  structure  and  data  buffer  with data is
 * setup and this channel can access the descriptor
 */
#define ALT_USB_HOST_HCCHAR2_CHENA_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_CHENA register field. */
#define ALT_USB_HOST_HCCHAR2_CHENA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_CHENA register field. */
#define ALT_USB_HOST_HCCHAR2_CHENA_MSB        31
/* The width in bits of the ALT_USB_HOST_HCCHAR2_CHENA register field. */
#define ALT_USB_HOST_HCCHAR2_CHENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR2_CHENA register field value. */
#define ALT_USB_HOST_HCCHAR2_CHENA_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_CHENA register field value. */
#define ALT_USB_HOST_HCCHAR2_CHENA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCCHAR2_CHENA register field. */
#define ALT_USB_HOST_HCCHAR2_CHENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_CHENA field value from a register. */
#define ALT_USB_HOST_HCCHAR2_CHENA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCCHAR2_CHENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_CHENA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCCHAR2.
 */
struct ALT_USB_HOST_HCCHAR2_s
{
    uint32_t  mps     : 11;  /* ALT_USB_HOST_HCCHAR2_MPS */
    uint32_t  epnum   :  4;  /* ALT_USB_HOST_HCCHAR2_EPNUM */
    uint32_t  epdir   :  1;  /* ALT_USB_HOST_HCCHAR2_EPDIR */
    uint32_t          :  1;  /* *UNDEFINED* */
    uint32_t  lspddev :  1;  /* ALT_USB_HOST_HCCHAR2_LSPDDEV */
    uint32_t  eptype  :  2;  /* ALT_USB_HOST_HCCHAR2_EPTYPE */
    uint32_t  ec      :  2;  /* ALT_USB_HOST_HCCHAR2_EC */
    uint32_t  devaddr :  7;  /* ALT_USB_HOST_HCCHAR2_DEVADDR */
    uint32_t  oddfrm  :  1;  /* ALT_USB_HOST_HCCHAR2_ODDFRM */
    uint32_t  chdis   :  1;  /* ALT_USB_HOST_HCCHAR2_CHDIS */
    uint32_t  chena   :  1;  /* ALT_USB_HOST_HCCHAR2_CHENA */
};

/* The typedef declaration for register ALT_USB_HOST_HCCHAR2. */
typedef volatile struct ALT_USB_HOST_HCCHAR2_s  ALT_USB_HOST_HCCHAR2_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCCHAR2 register. */
#define ALT_USB_HOST_HCCHAR2_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCCHAR2 register from the beginning of the component. */
#define ALT_USB_HOST_HCCHAR2_OFST        0x140
/* The address of the ALT_USB_HOST_HCCHAR2 register. */
#define ALT_USB_HOST_HCCHAR2_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCCHAR2_OFST))

/*
 * Register : hcsplt2
 * 
 * Host Channel 2 Split Control Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                  
 * :--------|:-------|:------|:------------------------------
 *  [6:0]   | RW     | 0x0   | ALT_USB_HOST_HCSPLT2_PRTADDR 
 *  [13:7]  | RW     | 0x0   | ALT_USB_HOST_HCSPLT2_HUBADDR 
 *  [15:14] | RW     | 0x0   | ALT_USB_HOST_HCSPLT2_XACTPOS 
 *  [16]    | RW     | 0x0   | ALT_USB_HOST_HCSPLT2_COMPSPLT
 *  [30:17] | ???    | 0x0   | *UNDEFINED*                  
 *  [31]    | RW     | 0x0   | ALT_USB_HOST_HCSPLT2_SPLTENA 
 * 
 */
/*
 * Field : prtaddr
 * 
 * Port Address (PrtAddr)
 * 
 * This field is the port number of the recipient transaction
 * 
 * translator.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT2_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT2_PRTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT2_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT2_PRTADDR_MSB        6
/* The width in bits of the ALT_USB_HOST_HCSPLT2_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT2_PRTADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCSPLT2_PRTADDR register field value. */
#define ALT_USB_HOST_HCSPLT2_PRTADDR_SET_MSK    0x0000007f
/* The mask used to clear the ALT_USB_HOST_HCSPLT2_PRTADDR register field value. */
#define ALT_USB_HOST_HCSPLT2_PRTADDR_CLR_MSK    0xffffff80
/* The reset value of the ALT_USB_HOST_HCSPLT2_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT2_PRTADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT2_PRTADDR field value from a register. */
#define ALT_USB_HOST_HCSPLT2_PRTADDR_GET(value) (((value) & 0x0000007f) >> 0)
/* Produces a ALT_USB_HOST_HCSPLT2_PRTADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT2_PRTADDR_SET(value) (((value) << 0) & 0x0000007f)

/*
 * Field : hubaddr
 * 
 * Hub Address (HubAddr)
 * 
 * This field holds the device address of the transaction translator's
 * 
 * hub.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT2_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT2_HUBADDR_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT2_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT2_HUBADDR_MSB        13
/* The width in bits of the ALT_USB_HOST_HCSPLT2_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT2_HUBADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCSPLT2_HUBADDR register field value. */
#define ALT_USB_HOST_HCSPLT2_HUBADDR_SET_MSK    0x00003f80
/* The mask used to clear the ALT_USB_HOST_HCSPLT2_HUBADDR register field value. */
#define ALT_USB_HOST_HCSPLT2_HUBADDR_CLR_MSK    0xffffc07f
/* The reset value of the ALT_USB_HOST_HCSPLT2_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT2_HUBADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT2_HUBADDR field value from a register. */
#define ALT_USB_HOST_HCSPLT2_HUBADDR_GET(value) (((value) & 0x00003f80) >> 7)
/* Produces a ALT_USB_HOST_HCSPLT2_HUBADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT2_HUBADDR_SET(value) (((value) << 7) & 0x00003f80)

/*
 * Field : xactpos
 * 
 * Transaction Position (XactPos)
 * 
 * This field is used to determine whether to send all, first, middle,
 * 
 * or last payloads with each OUT transaction.
 * 
 * 2'b11: All. This is the entire data payload is of this transaction
 * 
 * (which is less than or equal to 188 bytes).
 * 
 * 2'b10: Begin. This is the first data payload of this transaction
 * 
 * (which is larger than 188 bytes).
 * 
 * 2'b00: Mid. This is the middle payload of this transaction
 * 
 * (which is larger than 188 bytes).
 * 
 * 2'b01: End. This is the last payload of this transaction (which
 * 
 * is larger than 188 bytes).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                    
 * :--------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_HOST_HCSPLT2_XACTPOS_E_MIDDLE | 0x0   | Mid. This is the middle payload of this        
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT2_XACTPOS_E_END    | 0x1   | End. This is the last payload of this          
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT2_XACTPOS_E_BEGIN  | 0x2   | Begin. This is the first data payload of this  
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT2_XACTPOS_E_ALL    | 0x3   | All. This is the entire data payload is of this
 * :                                      |       | transaction (which is less than or equal to 188
 * :                                      |       | bytes)                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT2_XACTPOS
 * 
 * Mid. This is the middle payload of this transaction (which is larger than 188
 * bytes)
 */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_E_MIDDLE   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT2_XACTPOS
 * 
 * End. This is the last payload of this transaction (which is larger than 188
 * bytes)
 */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_E_END      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT2_XACTPOS
 * 
 * Begin. This is the first data payload of this transaction (which is larger than
 * 188 bytes)
 */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_E_BEGIN    0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT2_XACTPOS
 * 
 * All. This is the entire data payload is of this transaction (which is less than
 * or equal to 188 bytes)
 */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_E_ALL      0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT2_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT2_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_MSB        15
/* The width in bits of the ALT_USB_HOST_HCSPLT2_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCSPLT2_XACTPOS register field value. */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_SET_MSK    0x0000c000
/* The mask used to clear the ALT_USB_HOST_HCSPLT2_XACTPOS register field value. */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_CLR_MSK    0xffff3fff
/* The reset value of the ALT_USB_HOST_HCSPLT2_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT2_XACTPOS field value from a register. */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_GET(value) (((value) & 0x0000c000) >> 14)
/* Produces a ALT_USB_HOST_HCSPLT2_XACTPOS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_SET(value) (((value) << 14) & 0x0000c000)

/*
 * Field : compsplt
 * 
 * Do Complete Split (CompSplt)
 * 
 * The application sets this field to request the OTG host to perform
 * 
 * a complete split transaction.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description         
 * :----------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCSPLT2_COMPSPLT_E_NOSPLIT | 0x0   | No split transaction
 *  ALT_USB_HOST_HCSPLT2_COMPSPLT_E_SPLIT   | 0x1   | Split transaction   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT2_COMPSPLT
 * 
 * No split transaction
 */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_E_NOSPLIT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT2_COMPSPLT
 * 
 * Split transaction
 */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_E_SPLIT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT2_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT2_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_MSB        16
/* The width in bits of the ALT_USB_HOST_HCSPLT2_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCSPLT2_COMPSPLT register field value. */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_SET_MSK    0x00010000
/* The mask used to clear the ALT_USB_HOST_HCSPLT2_COMPSPLT register field value. */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_CLR_MSK    0xfffeffff
/* The reset value of the ALT_USB_HOST_HCSPLT2_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT2_COMPSPLT field value from a register. */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_USB_HOST_HCSPLT2_COMPSPLT register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : spltena
 * 
 * Split Enable (SpltEna)
 * 
 * The application sets this field to indicate that this channel is
 * 
 * enabled to perform split transactions.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description      
 * :------------------------------------|:------|:------------------
 *  ALT_USB_HOST_HCSPLT2_SPLTENA_E_DISD | 0x0   | Split not enabled
 *  ALT_USB_HOST_HCSPLT2_SPLTENA_E_END  | 0x1   | Split enabled    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT2_SPLTENA
 * 
 * Split not enabled
 */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT2_SPLTENA
 * 
 * Split enabled
 */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT2_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT2_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_MSB        31
/* The width in bits of the ALT_USB_HOST_HCSPLT2_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCSPLT2_SPLTENA register field value. */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCSPLT2_SPLTENA register field value. */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCSPLT2_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT2_SPLTENA field value from a register. */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCSPLT2_SPLTENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCSPLT2.
 */
struct ALT_USB_HOST_HCSPLT2_s
{
    uint32_t  prtaddr  :  7;  /* ALT_USB_HOST_HCSPLT2_PRTADDR */
    uint32_t  hubaddr  :  7;  /* ALT_USB_HOST_HCSPLT2_HUBADDR */
    uint32_t  xactpos  :  2;  /* ALT_USB_HOST_HCSPLT2_XACTPOS */
    uint32_t  compsplt :  1;  /* ALT_USB_HOST_HCSPLT2_COMPSPLT */
    uint32_t           : 14;  /* *UNDEFINED* */
    uint32_t  spltena  :  1;  /* ALT_USB_HOST_HCSPLT2_SPLTENA */
};

/* The typedef declaration for register ALT_USB_HOST_HCSPLT2. */
typedef volatile struct ALT_USB_HOST_HCSPLT2_s  ALT_USB_HOST_HCSPLT2_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCSPLT2 register. */
#define ALT_USB_HOST_HCSPLT2_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCSPLT2 register from the beginning of the component. */
#define ALT_USB_HOST_HCSPLT2_OFST        0x144
/* The address of the ALT_USB_HOST_HCSPLT2 register. */
#define ALT_USB_HOST_HCSPLT2_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCSPLT2_OFST))

/*
 * Register : hcint2
 * 
 * Host Channel 2 Interrupt Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                          
 * :--------|:-------|:------|:--------------------------------------
 *  [0]     | RW     | 0x0   | ALT_USB_HOST_HCINT2_XFERCOMPL        
 *  [1]     | RW     | 0x0   | ALT_USB_HOST_HCINT2_CHHLTD           
 *  [2]     | RW     | 0x0   | ALT_USB_HOST_HCINT2_AHBERR           
 *  [3]     | RW     | 0x0   | ALT_USB_HOST_HCINT2_STALL            
 *  [4]     | RW     | 0x0   | ALT_USB_HOST_HCINT2_NAK              
 *  [5]     | RW     | 0x0   | ALT_USB_HOST_HCINT2_ACK              
 *  [6]     | RW     | 0x0   | ALT_USB_HOST_HCINT2_NYET             
 *  [7]     | RW     | 0x0   | ALT_USB_HOST_HCINT2_XACTERR          
 *  [8]     | RW     | 0x0   | ALT_USB_HOST_HCINT2_BBLERR           
 *  [9]     | RW     | 0x0   | ALT_USB_HOST_HCINT2_FRMOVRUN         
 *  [10]    | RW     | 0x0   | ALT_USB_HOST_HCINT2_DATATGLERR       
 *  [11]    | RW     | 0x0   | ALT_USB_HOST_HCINT2_BNAINTR          
 *  [12]    | RW     | 0x0   | ALT_USB_HOST_HCINT2_XCS_XACT_ERR     
 *  [13]    | RW     | 0x0   | ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR
 *  [31:14] | ???    | 0x0   | *UNDEFINED*                          
 * 
 */
/*
 * Field : xfercompl
 * 
 * Transfer Completed (XferCompl)
 * 
 * Transfer completed normally without any errors.This bit can be set only by the
 * core and the application should write 1 to clear it.
 * 
 * For Scatter/Gather DMA mode, it indicates that current descriptor processing got
 * 
 * completed with IOC bit set in its descriptor.
 * 
 * In non Scatter/Gather DMA mode, it indicates that Transfer completed normally
 * without
 * 
 * any errors.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                   
 * :--------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_HOST_HCINT2_XFERCOMPL_E_INACT | 0x0   | No transfer                                   
 *  ALT_USB_HOST_HCINT2_XFERCOMPL_E_ACT   | 0x1   | Transfer completed normally without any errors
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_XFERCOMPL
 * 
 * No transfer
 */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_XFERCOMPL
 * 
 * Transfer completed normally without any errors
 */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_MSB        0
/* The width in bits of the ALT_USB_HOST_HCINT2_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_XFERCOMPL register field value. */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_HOST_HCINT2_XFERCOMPL register field value. */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_HOST_HCINT2_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_XFERCOMPL field value from a register. */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_HOST_HCINT2_XFERCOMPL register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : chhltd
 * 
 * Channel Halted (ChHltd)
 * 
 * In non Scatter/Gather DMA mode, it indicates the transfer completed abnormally
 * either because of any USB transaction error or in response to disable request by
 * the application or because of a completed transfer.
 * 
 * in Scatter/gather DMA mode, this indicates that transfer completed due to any of
 * the following
 * 
 * . EOL being set in descriptor
 * 
 * . AHB error
 * 
 * . Excessive transaction errors
 * 
 * . Babble
 * 
 * . Stall
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description       
 * :-----------------------------------|:------|:-------------------
 *  ALT_USB_HOST_HCINT2_CHHLTD_E_INACT | 0x0   | Channel not halted
 *  ALT_USB_HOST_HCINT2_CHHLTD_E_ACT   | 0x1   | Channel Halted    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_CHHLTD
 * 
 * Channel not halted
 */
#define ALT_USB_HOST_HCINT2_CHHLTD_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_CHHLTD
 * 
 * Channel Halted
 */
#define ALT_USB_HOST_HCINT2_CHHLTD_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_CHHLTD register field. */
#define ALT_USB_HOST_HCINT2_CHHLTD_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_CHHLTD register field. */
#define ALT_USB_HOST_HCINT2_CHHLTD_MSB        1
/* The width in bits of the ALT_USB_HOST_HCINT2_CHHLTD register field. */
#define ALT_USB_HOST_HCINT2_CHHLTD_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_CHHLTD register field value. */
#define ALT_USB_HOST_HCINT2_CHHLTD_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_HOST_HCINT2_CHHLTD register field value. */
#define ALT_USB_HOST_HCINT2_CHHLTD_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_HOST_HCINT2_CHHLTD register field. */
#define ALT_USB_HOST_HCINT2_CHHLTD_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_CHHLTD field value from a register. */
#define ALT_USB_HOST_HCINT2_CHHLTD_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_HOST_HCINT2_CHHLTD register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_CHHLTD_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : ahberr
 * 
 * AHB Error (AHBErr)
 * 
 * This is generated only in Internal DMA mode when there is an
 * 
 * AHB error during AHB read/write. The application can read the
 * 
 * corresponding channel's DMA address register to get the error
 * 
 * address.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                    
 * :-----------------------------------|:------|:--------------------------------
 *  ALT_USB_HOST_HCINT2_AHBERR_E_INACT | 0x0   | No AHB error                   
 *  ALT_USB_HOST_HCINT2_AHBERR_E_ACT   | 0x1   | AHB error during AHB read/write
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_AHBERR
 * 
 * No AHB error
 */
#define ALT_USB_HOST_HCINT2_AHBERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_AHBERR
 * 
 * AHB error during AHB read/write
 */
#define ALT_USB_HOST_HCINT2_AHBERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_AHBERR register field. */
#define ALT_USB_HOST_HCINT2_AHBERR_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_AHBERR register field. */
#define ALT_USB_HOST_HCINT2_AHBERR_MSB        2
/* The width in bits of the ALT_USB_HOST_HCINT2_AHBERR register field. */
#define ALT_USB_HOST_HCINT2_AHBERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_AHBERR register field value. */
#define ALT_USB_HOST_HCINT2_AHBERR_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_HOST_HCINT2_AHBERR register field value. */
#define ALT_USB_HOST_HCINT2_AHBERR_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_HOST_HCINT2_AHBERR register field. */
#define ALT_USB_HOST_HCINT2_AHBERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_AHBERR field value from a register. */
#define ALT_USB_HOST_HCINT2_AHBERR_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_HOST_HCINT2_AHBERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_AHBERR_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : stall
 * 
 * STALL Response Received Interrupt (STALL)
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description       
 * :----------------------------------|:------|:-------------------
 *  ALT_USB_HOST_HCINT2_STALL_E_INACT | 0x0   | No Stall Interrupt
 *  ALT_USB_HOST_HCINT2_STALL_E_ACT   | 0x1   | Stall Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_STALL
 * 
 * No Stall Interrupt
 */
#define ALT_USB_HOST_HCINT2_STALL_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_STALL
 * 
 * Stall Interrupt
 */
#define ALT_USB_HOST_HCINT2_STALL_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_STALL register field. */
#define ALT_USB_HOST_HCINT2_STALL_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_STALL register field. */
#define ALT_USB_HOST_HCINT2_STALL_MSB        3
/* The width in bits of the ALT_USB_HOST_HCINT2_STALL register field. */
#define ALT_USB_HOST_HCINT2_STALL_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_STALL register field value. */
#define ALT_USB_HOST_HCINT2_STALL_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_HOST_HCINT2_STALL register field value. */
#define ALT_USB_HOST_HCINT2_STALL_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_HOST_HCINT2_STALL register field. */
#define ALT_USB_HOST_HCINT2_STALL_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_STALL field value from a register. */
#define ALT_USB_HOST_HCINT2_STALL_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_HOST_HCINT2_STALL register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_STALL_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : nak
 * 
 * NAK Response Received Interrupt (NAK)
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                       
 * :--------------------------------|:------|:-----------------------------------
 *  ALT_USB_HOST_HCINT2_NAK_E_INACT | 0x0   | No NAK Response Received Interrupt
 *  ALT_USB_HOST_HCINT2_NAK_E_ACT   | 0x1   | NAK Response Received Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_NAK
 * 
 * No NAK Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT2_NAK_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_NAK
 * 
 * NAK Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT2_NAK_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_NAK register field. */
#define ALT_USB_HOST_HCINT2_NAK_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_NAK register field. */
#define ALT_USB_HOST_HCINT2_NAK_MSB        4
/* The width in bits of the ALT_USB_HOST_HCINT2_NAK register field. */
#define ALT_USB_HOST_HCINT2_NAK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_NAK register field value. */
#define ALT_USB_HOST_HCINT2_NAK_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_HOST_HCINT2_NAK register field value. */
#define ALT_USB_HOST_HCINT2_NAK_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_HOST_HCINT2_NAK register field. */
#define ALT_USB_HOST_HCINT2_NAK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_NAK field value from a register. */
#define ALT_USB_HOST_HCINT2_NAK_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_HOST_HCINT2_NAK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_NAK_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : ack
 * 
 * ACK Response Received/Transmitted Interrupt (ACK)
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                                   
 * :--------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_HOST_HCINT2_ACK_E_INACT | 0x0   | No ACK Response Received Transmitted Interrupt
 *  ALT_USB_HOST_HCINT2_ACK_E_ACT   | 0x1   | ACK Response Received Transmitted Interrup    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_ACK
 * 
 * No ACK Response Received Transmitted Interrupt
 */
#define ALT_USB_HOST_HCINT2_ACK_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_ACK
 * 
 * ACK Response Received Transmitted Interrup
 */
#define ALT_USB_HOST_HCINT2_ACK_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_ACK register field. */
#define ALT_USB_HOST_HCINT2_ACK_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_ACK register field. */
#define ALT_USB_HOST_HCINT2_ACK_MSB        5
/* The width in bits of the ALT_USB_HOST_HCINT2_ACK register field. */
#define ALT_USB_HOST_HCINT2_ACK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_ACK register field value. */
#define ALT_USB_HOST_HCINT2_ACK_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_HOST_HCINT2_ACK register field value. */
#define ALT_USB_HOST_HCINT2_ACK_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_HOST_HCINT2_ACK register field. */
#define ALT_USB_HOST_HCINT2_ACK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_ACK field value from a register. */
#define ALT_USB_HOST_HCINT2_ACK_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_HOST_HCINT2_ACK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_ACK_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : nyet
 * 
 * NYET Response Received Interrupt (NYET)
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                        
 * :---------------------------------|:------|:------------------------------------
 *  ALT_USB_HOST_HCINT2_NYET_E_INACT | 0x0   | No NYET Response Received Interrupt
 *  ALT_USB_HOST_HCINT2_NYET_E_ACT   | 0x1   | NYET Response Received Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_NYET
 * 
 * No NYET Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT2_NYET_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_NYET
 * 
 * NYET Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT2_NYET_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_NYET register field. */
#define ALT_USB_HOST_HCINT2_NYET_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_NYET register field. */
#define ALT_USB_HOST_HCINT2_NYET_MSB        6
/* The width in bits of the ALT_USB_HOST_HCINT2_NYET register field. */
#define ALT_USB_HOST_HCINT2_NYET_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_NYET register field value. */
#define ALT_USB_HOST_HCINT2_NYET_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_HOST_HCINT2_NYET register field value. */
#define ALT_USB_HOST_HCINT2_NYET_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_HOST_HCINT2_NYET register field. */
#define ALT_USB_HOST_HCINT2_NYET_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_NYET field value from a register. */
#define ALT_USB_HOST_HCINT2_NYET_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_HOST_HCINT2_NYET register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_NYET_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : xacterr
 * 
 * Transaction Error (XactErr)
 * 
 * Indicates one of the following errors occurred on the USB.
 * 
 * CRC check failure
 * 
 * Timeout
 * 
 * Bit stuff error
 * 
 * False EOP
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description         
 * :------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCINT2_XACTERR_E_INACT | 0x0   | No Transaction Error
 *  ALT_USB_HOST_HCINT2_XACTERR_E_ACT   | 0x1   | Transaction Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_XACTERR
 * 
 * No Transaction Error
 */
#define ALT_USB_HOST_HCINT2_XACTERR_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_XACTERR
 * 
 * Transaction Error
 */
#define ALT_USB_HOST_HCINT2_XACTERR_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_XACTERR register field. */
#define ALT_USB_HOST_HCINT2_XACTERR_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_XACTERR register field. */
#define ALT_USB_HOST_HCINT2_XACTERR_MSB        7
/* The width in bits of the ALT_USB_HOST_HCINT2_XACTERR register field. */
#define ALT_USB_HOST_HCINT2_XACTERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_XACTERR register field value. */
#define ALT_USB_HOST_HCINT2_XACTERR_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_HOST_HCINT2_XACTERR register field value. */
#define ALT_USB_HOST_HCINT2_XACTERR_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_HOST_HCINT2_XACTERR register field. */
#define ALT_USB_HOST_HCINT2_XACTERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_XACTERR field value from a register. */
#define ALT_USB_HOST_HCINT2_XACTERR_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_HOST_HCINT2_XACTERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_XACTERR_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : bblerr
 * 
 * Babble Error (BblErr)
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core..This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description    
 * :-----------------------------------|:------|:----------------
 *  ALT_USB_HOST_HCINT2_BBLERR_E_INACT | 0x0   | No Babble Error
 *  ALT_USB_HOST_HCINT2_BBLERR_E_ACT   | 0x1   | Babble Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_BBLERR
 * 
 * No Babble Error
 */
#define ALT_USB_HOST_HCINT2_BBLERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_BBLERR
 * 
 * Babble Error
 */
#define ALT_USB_HOST_HCINT2_BBLERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_BBLERR register field. */
#define ALT_USB_HOST_HCINT2_BBLERR_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_BBLERR register field. */
#define ALT_USB_HOST_HCINT2_BBLERR_MSB        8
/* The width in bits of the ALT_USB_HOST_HCINT2_BBLERR register field. */
#define ALT_USB_HOST_HCINT2_BBLERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_BBLERR register field value. */
#define ALT_USB_HOST_HCINT2_BBLERR_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_HOST_HCINT2_BBLERR register field value. */
#define ALT_USB_HOST_HCINT2_BBLERR_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_HOST_HCINT2_BBLERR register field. */
#define ALT_USB_HOST_HCINT2_BBLERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_BBLERR field value from a register. */
#define ALT_USB_HOST_HCINT2_BBLERR_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_HOST_HCINT2_BBLERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_BBLERR_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : frmovrun
 * 
 * Frame Overrun (FrmOvrun).In Scatter/Gather DMA mode, the interrupt due to this
 * bit is masked
 * 
 * in the core.This bit can be set only by the core and the application should
 * write 1 to clear
 * 
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description     
 * :-------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCINT2_FRMOVRUN_E_INACT | 0x0   | No Frame Overrun
 *  ALT_USB_HOST_HCINT2_FRMOVRUN_E_ACT   | 0x1   | Frame Overrun   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_FRMOVRUN
 * 
 * No Frame Overrun
 */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_FRMOVRUN
 * 
 * Frame Overrun
 */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_MSB        9
/* The width in bits of the ALT_USB_HOST_HCINT2_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_FRMOVRUN register field value. */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_SET_MSK    0x00000200
/* The mask used to clear the ALT_USB_HOST_HCINT2_FRMOVRUN register field value. */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_CLR_MSK    0xfffffdff
/* The reset value of the ALT_USB_HOST_HCINT2_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_FRMOVRUN field value from a register. */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_USB_HOST_HCINT2_FRMOVRUN register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : datatglerr
 * 
 * Data Toggle Error (DataTglErr).This bit can be set only by the core and the
 * application should write 1 to clear
 * 
 * it.In Scatter/Gather DMA mode, the interrupt due to this bit is masked
 * 
 * in the core.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description         
 * :---------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCINT2_DATATGLERR_E_INACT | 0x0   | No Data Toggle Error
 *  ALT_USB_HOST_HCINT2_DATATGLERR_E_ACT   | 0x1   | Data Toggle Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_DATATGLERR
 * 
 * No Data Toggle Error
 */
#define ALT_USB_HOST_HCINT2_DATATGLERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_DATATGLERR
 * 
 * Data Toggle Error
 */
#define ALT_USB_HOST_HCINT2_DATATGLERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT2_DATATGLERR_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT2_DATATGLERR_MSB        10
/* The width in bits of the ALT_USB_HOST_HCINT2_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT2_DATATGLERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_DATATGLERR register field value. */
#define ALT_USB_HOST_HCINT2_DATATGLERR_SET_MSK    0x00000400
/* The mask used to clear the ALT_USB_HOST_HCINT2_DATATGLERR register field value. */
#define ALT_USB_HOST_HCINT2_DATATGLERR_CLR_MSK    0xfffffbff
/* The reset value of the ALT_USB_HOST_HCINT2_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT2_DATATGLERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_DATATGLERR field value from a register. */
#define ALT_USB_HOST_HCINT2_DATATGLERR_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_USB_HOST_HCINT2_DATATGLERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_DATATGLERR_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : bnaintr
 * 
 * BNA (Buffer Not Available) Interrupt (BNAIntr)
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled.
 * 
 * The core generates this interrupt when the descriptor accessed
 * 
 * is not ready for the Core to process. BNA will not be generated
 * 
 * for Isochronous channels.
 * 
 * For non Scatter/Gather DMA mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description     
 * :------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCINT2_BNAINTR_E_INACT | 0x0   | No BNA Interrupt
 *  ALT_USB_HOST_HCINT2_BNAINTR_E_ACT   | 0x1   | BNA Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_BNAINTR
 * 
 * No BNA Interrupt
 */
#define ALT_USB_HOST_HCINT2_BNAINTR_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_BNAINTR
 * 
 * BNA Interrupt
 */
#define ALT_USB_HOST_HCINT2_BNAINTR_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_BNAINTR register field. */
#define ALT_USB_HOST_HCINT2_BNAINTR_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_BNAINTR register field. */
#define ALT_USB_HOST_HCINT2_BNAINTR_MSB        11
/* The width in bits of the ALT_USB_HOST_HCINT2_BNAINTR register field. */
#define ALT_USB_HOST_HCINT2_BNAINTR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_BNAINTR register field value. */
#define ALT_USB_HOST_HCINT2_BNAINTR_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_HOST_HCINT2_BNAINTR register field value. */
#define ALT_USB_HOST_HCINT2_BNAINTR_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_HOST_HCINT2_BNAINTR register field. */
#define ALT_USB_HOST_HCINT2_BNAINTR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_BNAINTR field value from a register. */
#define ALT_USB_HOST_HCINT2_BNAINTR_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_HOST_HCINT2_BNAINTR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_BNAINTR_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : xcs_xact_err
 * 
 * Excessive Transaction Error (XCS_XACT_ERR)
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled. The core sets
 * this bit
 * 
 * when 3 consecutive transaction errors occurred on the USB bus. XCS_XACT_ERR will
 * 
 * not be generated for Isochronous channels.
 * 
 * For non Scatter/Gather DMA mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                   
 * :-------------------------------------------|:------|:-------------------------------
 *  ALT_USB_HOST_HCINT2_XCS_XACT_ERR_E_INACT   | 0x0   | No Excessive Transaction Error
 *  ALT_USB_HOST_HCINT2_XCS_XACT_ERR_E_ACVTIVE | 0x1   | Excessive Transaction Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_XCS_XACT_ERR
 * 
 * No Excessive Transaction Error
 */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_XCS_XACT_ERR
 * 
 * Excessive Transaction Error
 */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_E_ACVTIVE  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_MSB        12
/* The width in bits of the ALT_USB_HOST_HCINT2_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_XCS_XACT_ERR register field value. */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_SET_MSK    0x00001000
/* The mask used to clear the ALT_USB_HOST_HCINT2_XCS_XACT_ERR register field value. */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_CLR_MSK    0xffffefff
/* The reset value of the ALT_USB_HOST_HCINT2_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_XCS_XACT_ERR field value from a register. */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_USB_HOST_HCINT2_XCS_XACT_ERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : desc_lst_rollintr
 * 
 * Descriptor rollover interrupt (DESC_LST_ROLLIntr)
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled. The core sets
 * this bit
 * 
 * when the corresponding channel's descriptor list rolls over.
 * 
 * For non Scatter/Gather DMA mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                     
 * :----------------------------------------------|:------|:---------------------------------
 *  ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_E_INACT | 0x0   | No Descriptor rollover interrupt
 *  ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_E_ACT   | 0x1   | Descriptor rollover interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR
 * 
 * No Descriptor rollover interrupt
 */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR
 * 
 * Descriptor rollover interrupt
 */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_MSB        13
/* The width in bits of the ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR register field value. */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR register field value. */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR field value from a register. */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_SET(value) (((value) << 13) & 0x00002000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCINT2.
 */
struct ALT_USB_HOST_HCINT2_s
{
    uint32_t  xfercompl         :  1;  /* ALT_USB_HOST_HCINT2_XFERCOMPL */
    uint32_t  chhltd            :  1;  /* ALT_USB_HOST_HCINT2_CHHLTD */
    uint32_t  ahberr            :  1;  /* ALT_USB_HOST_HCINT2_AHBERR */
    uint32_t  stall             :  1;  /* ALT_USB_HOST_HCINT2_STALL */
    uint32_t  nak               :  1;  /* ALT_USB_HOST_HCINT2_NAK */
    uint32_t  ack               :  1;  /* ALT_USB_HOST_HCINT2_ACK */
    uint32_t  nyet              :  1;  /* ALT_USB_HOST_HCINT2_NYET */
    uint32_t  xacterr           :  1;  /* ALT_USB_HOST_HCINT2_XACTERR */
    uint32_t  bblerr            :  1;  /* ALT_USB_HOST_HCINT2_BBLERR */
    uint32_t  frmovrun          :  1;  /* ALT_USB_HOST_HCINT2_FRMOVRUN */
    uint32_t  datatglerr        :  1;  /* ALT_USB_HOST_HCINT2_DATATGLERR */
    uint32_t  bnaintr           :  1;  /* ALT_USB_HOST_HCINT2_BNAINTR */
    uint32_t  xcs_xact_err      :  1;  /* ALT_USB_HOST_HCINT2_XCS_XACT_ERR */
    uint32_t  desc_lst_rollintr :  1;  /* ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR */
    uint32_t                    : 18;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HCINT2. */
typedef volatile struct ALT_USB_HOST_HCINT2_s  ALT_USB_HOST_HCINT2_t;
#endif  /* __ASSEMBLY__ */

/* The reset value of the ALT_USB_HOST_HCINT2 register. */
#define ALT_USB_HOST_HCINT2_RESET       0x00000000
/* The byte offset of the ALT_USB_HOST_HCINT2 register from the beginning of the component. */
#define ALT_USB_HOST_HCINT2_OFST        0x148
/* The address of the ALT_USB_HOST_HCINT2 register. */
#define ALT_USB_HOST_HCINT2_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCINT2_OFST))

/*
 * Register : hcintmsk2
 * 
 * Host Channel 2 Interrupt Mask Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                               
 * :--------|:-------|:------|:-------------------------------------------
 *  [0]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK       
 *  [1]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK2_CHHLTDMSK          
 *  [2]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK2_AHBERRMSK          
 *  [3]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK2_STALLMSK           
 *  [4]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK2_NAKMSK             
 *  [5]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK2_ACKMSK             
 *  [6]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK2_NYETMSK            
 *  [7]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK2_XACTERRMSK         
 *  [8]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK2_BBLERRMSK          
 *  [9]     | RW     | 0x0   | ALT_USB_HOST_HCINTMSK2_FRMOVRUNMSK        
 *  [10]    | RW     | 0x0   | ALT_USB_HOST_HCINTMSK2_DATATGLERRMSK      
 *  [11]    | RW     | 0x0   | ALT_USB_HOST_HCINTMSK2_BNAINTRMSK         
 *  [12]    | ???    | 0x0   | *UNDEFINED*                               
 *  [13]    | RW     | 0x0   | ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK
 *  [31:14] | ???    | 0x0   | *UNDEFINED*                               
 * 
 */
/*
 * Field : xfercomplmsk
 * 
 * Transfer Completed Mask (XferComplMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description
 * :--------------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_MSB        0
/* The width in bits of the ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK register field value. */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK register field value. */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : chhltdmsk
 * 
 * Channel Halted Mask (ChHltdMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK2_CHHLTDMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK2_CHHLTDMSK_E_NOMSK 