//*******************************************************************************
// file  main.c
//
// attention
// Copyright (C) 2020 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS". 
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
//*******************************************************************************

/***********************************************************************************
 *  includes
 ***********************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include "system.h"
#include "sys/alt_irq.h"
#include "altera_avalon_pio_regs.h"

/***********************************************************************************
 *  re-definitions
 *  ̃ZNV"system.h"Œ`ꂽ萔A
 *    {\[Xt@CŎgp邽߂ɍĒ`̂łB
 *    gp̍ۂ͉E̒萔"system.h"QƂ̏AύXĂgB
 ***********************************************************************************/
#define LED_CSR_ADR      	(LED_BASE)          	// LED ̃AhX
#define DIP_SW_ADR			(SW_BASE)				//DIP SW ̃AhX
#define DIP_SW_MSK			(((1 << SW_DATA_WIDTH) -1)&0x1) //DIP SW ̃rbg}XN
#define KEY_BIT_MSK			((1 << KEY_DATA_WIDTH) -1)	// KEY ̃rbg}XN
#define KEY_CSR_ADR			(KEY_BASE)				// KEY ̃AhX
#define KEY_IRQ_ID        	(KEY_IRQ_INTERRUPT_CONTROLLER_ID)  // KEY ̊荞݃Rg[ID
#define KEY_IRQ_NO        	(KEY_IRQ)               // KEY ̊荞ݔԍ

/***********************************************************************************
 *  definitions (define, enum, typedef, etc..)
 ***********************************************************************************/

/***********************************************************************************
 *  variables
 ***********************************************************************************/

/***********************************************************************************
 *  proto types
 ***********************************************************************************/
void pio_callback();

/***********************************************************************************
 *  main function
 ***********************************************************************************/
int main()
{
	printf("PIO Smaple\n");

	// LED  
	IOWR_ALTERA_AVALON_PIO_DATA(LED_CSR_ADR, 0x00);
	// KEY  Edgecapture NA
	IOWR_ALTERA_AVALON_PIO_EDGE_CAP(KEY_CSR_ADR, 0xf);
	// KEY  IRQ  Enable
	IOWR_ALTERA_AVALON_PIO_IRQ_MASK(KEY_CSR_ADR, KEY_BIT_MSK);
	// KEY ̊荞݃nho^
	alt_ic_isr_register(KEY_IRQ_ID, KEY_IRQ_NO, pio_callback, (void*)KEY_CSR_ADR, 0x0);

	// LED _𕪊
	if((IORD_ALTERA_AVALON_PIO_DATA(DIP_SW_ADR)&(DIP_SW_MSK))==(DIP_SW_MSK))
		// LED ̏_@DIP SW ON
		IOWR_ALTERA_AVALON_PIO_DATA(LED_CSR_ADR, 0xFF);
	else
		// LED ̏_@DIP SW OFF
		IOWR_ALTERA_AVALON_PIO_DATA(LED_CSR_ADR, 0x55);
	// [v
	while(1);
	return 0;
}

/***********************************************************************************
 *  interrupt handler
 ***********************************************************************************/
// PIO input 荞݃nh
void pio_callback(void * context)
{
	int cap;
	// Edge Capture 擾 ꂽ Key 𔻒
	cap = IORD_ALTERA_AVALON_PIO_EDGE_CAP(KEY_CSR_ADR);
	// KEY0  ?
		if(cap & 0x01)
	{
		IOWR_ALTERA_AVALON_PIO_DATA(LED_BASE,0x3);
	}
	// KEY1 ?
	else if(cap & 0x02)
	{
		IOWR_ALTERA_AVALON_PIO_DATA(LED_BASE,0xc);
	}
	// KEY2 ?
	else if(cap & 0x04)
	{
		IOWR_ALTERA_AVALON_PIO_DATA(LED_BASE,0x30);
	}
	// KEY3 ?
	else if(cap & 0x8)
	{
		IOWR_ALTERA_AVALON_PIO_DATA(LED_BASE,0xc0);
	}
	// KEY 𔻒fłȂꍇ
	else{
		IOWR_ALTERA_AVALON_PIO_DATA(LED_CSR_ADR, 0xFF);
	}
	// Edge Capture NA
	IOWR_ALTERA_AVALON_PIO_EDGE_CAP(KEY_CSR_ADR, cap);
}
