/* file GSFI_Access_Sample.c
 *
 * Copyright (C) 2021 MACNICA,Inc. All Rights Reserved.
 *  This software is licensed "AS IS".
 *  Please perform use of this software by a user's own responsibility and expense.
 *  It cannot guarantee in the maker side about the damage which occurred
 *  by the ab-ility not to use or use this software, and all damage that occurred secondarily.
 * Created on: 2021/07/15
 */
/***********************************************************************************
 *  includes
 ***********************************************************************************/
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include "system.h"
#include "sys/alt_flash.h"
#include "io.h"
#include "GSFI_Operation_sample.h"
#include "sys/errno.h"
/***********************************************************************************
 *  re-definitions
 *  ̃ZNV "system.h" Œ`ꂽ萔A
 *    {\[Xt@CŎgp邽߂ɍĒ`̂łB
 *    gp̍ۂ͉E̒萔 "system.h" QƂ̏AύXĂgB
 ***********************************************************************************/
#define SFC_AVL_CSR_BASE           (INTEL_GENERIC_SERIAL_FLASH_INTERFACE_TOP_0_AVL_CSR_BASE)
#define SFC_AVL_CSR_SPAN           (INTEL_GENERIC_SERIAL_FLASH_INTERFACE_TOP_0_AVL_CSR_SPAN)
#define SFC_AVL_MEM_BASE           (INTEL_GENERIC_SERIAL_FLASH_INTERFACE_TOP_0_AVL_MEM_BASE)
#define SFC_AVL_MEM_SPAN           (INTEL_GENERIC_SERIAL_FLASH_INTERFACE_TOP_0_AVL_MEM_SPAN)
/***********************************************************************************
 *  definitions (define)
 *   ftHgԂ̖{\[XR[h́AFlash ROM  0x0000_00000 A1 ZN^[f[^̏s܂B
 *    ĂȂ Flash ROM łB
 *    #define Œ`Ă SEC_BASE_ADDANUM_OF_SEC ̒lύX鎖ŁAs Sector 𒲐邱Ƃł܂B
 *    ݒ肵lZN^[̃x[XAhXłȂꍇZN^[̐ Flash ROM 𒴂ꍇ́ANois II I܂B
 ***********************************************************************************/
#define SEC_BASE_ADD        (0x00000000)  // Erase   Write  Read sZN^[̃x[XAhX
#define NUM_OF_SEC          (1)           // Erase   Write  Read sZN^[
#define IO_MODE             (0)           // 0:Standard, 1:Dual, 2:QUAD
#define CLOCK_RATE          (0x1)         // IP ̃ftHǵA0x10 (f[Hz]/32)łB0x1(f[Hz]/2) ~ 0x10(f[Hz]/32) ܂Őݒł܂B
#define SECTOR_LOOK         (0x0)         // Sector Lock ̐ݒlB0x0 ݒ肵ĂƁALOCK s܂B

#define DATA_LENGTH         (0x00001000)  // f[^TCY ftHg Sub Sector TCY 0x00001000
#define WRITE_DATA          (0x00)        // Write Data
#define PRINT_COLUMNS       (16)          // Print_Data() ŕ\ 1~256
/***********************************************************************************
 *  proto types
 ***********************************************************************************/
int Erase(gsfi_flash_info *flash_info, alt_u32 sector_base_address, alt_u32 num_sector_erase, alt_u32 num_verify_sub_sector);
int Verify(const alt_u8 *read_buf_add, const alt_u8 *verify_buf_add, alt_u32 length);
int Erase_Verify(gsfi_flash_info *flash_info, alt_u32 base_address, alt_u32 length);
void Print_GSFI_Register(gsfi_flash_info *flash_info);
void Print_Read_Status(gsfi_flash_info *flash_info);
void Print_Data(alt_u32 read_offset, const alt_u8 *data, alt_u32 length, alt_u32 columns);
int Check_Settings(gsfi_flash_info *flash_info,alt_u32 start_address, alt_u32 access_number_sector);
/***********************************************************************************
 *  main function
 ***********************************************************************************/
int main()
{
	int i,j;
	int ret_code = 0;

	alt_u32 sector_offset = SEC_BASE_ADD;
	unsigned char *buf_read_data  = NULL;
	unsigned char *buf_write_data = NULL;
	gsfi_flash_info *flash_info   = NULL;

	printf("\nHello from Nios II!\nSource File: GSFI_Access_Sample.c\n\n");

	//Flash ̏i[̈錾܂B
	flash_info = (gsfi_flash_info *)malloc(sizeof(gsfi_flash_info));
	if(flash_info == NULL) {
		printf("Can not allocate memory.\n");
		goto FINISH;
	}
	// Flash Controller  Open ܂BDevice ID ̓ǂݍ݂ɎsAz ID łȂꍇANios II ͏I܂B
	ret_code = flash_info_init(flash_info, SFC_AVL_CSR_BASE, SFC_AVL_MEM_BASE, SFC_AVL_MEM_SPAN, SFC_AVL_CSR_SPAN, IO_MODE, DATA_LENGTH);
	if (ret_code == 0){
		printf("Open flash device.\n");
		printf("Device ID = 0x%x\n",read_device_id(flash_info));
		Print_Read_Status(flash_info);
	}else{
		printf("Can not open flash device : ret_code = %d\n",ret_code);
		Print_Read_Status(flash_info);
		printf("Device ID = 0x%x\n",read_device_id(flash_info));
		goto FINISH;
	}
	//ݒ肵ASEC_BASE_ADD  NUM_OF_SEC  Flash ROM ̎dlɍĂ邩mF܂B
	ret_code = Check_Settings(flash_info, SEC_BASE_ADD, NUM_OF_SEC);
	if(ret_code != 0){
		goto FINISH;
	}
	// Clock Rate ݒ肵܂B
	ret_code = change_clock_rate(flash_info, CLOCK_RATE);
	if(ret_code == CLOCK_RATE){
		printf("Set Clock Rate [fHz]/%d.\n",ret_code*2);
		ret_code = 0;
	}else{
		printf("Can not Set Clock Rate. ret_code = %d\n",ret_code);
		goto FINISH;
	}
	// Protect ̐ݒύX܂BSECTOR_LOOK 𐳂ݒ肷鎖ŁALock o܂B
	ret_code = write_sector_protect(flash_info, SECTOR_LOOK);
	if(ret_code == 0){
		printf("Protect Change OK.\n");
	}else{
		printf("Protect Change Error. ret_code = %d\n\n", ret_code);
		Print_Read_Status(flash_info);
		goto FINISH;
	}
	// IO Mode ݒ肵܂B
	ret_code = change_io_mode(flash_info,flash_info->io_mode);
	if(ret_code == 0){
		printf("Set IO Mode %ld(0:Standard, 1:Dual, 2:QUAD)\n",flash_info->io_mode);
		ret_code = 0;
	}else{
		printf("Can not Set IO Mode. ret_code = %d\n",ret_code);
		goto FINISH;
		Print_Read_Status(flash_info);
	}

	Print_Read_Status(flash_info);
	Print_GSFI_Register(flash_info);

	//f[^obt@[錾܂B
	buf_write_data = (unsigned char *)malloc(flash_info->data_size);
	buf_read_data =  (unsigned char *)malloc(flash_info->data_size);
	if((buf_read_data == NULL) || (buf_write_data == NULL)) {
		printf("Can not allocate memory.\n");
		goto FINISH;
	}
	// Write f[^܂
	for(j = 0; j < flash_info->data_size; j++){
		*(buf_write_data + sizeof(char)*j) = WRITE_DATA + j;
	}

	// Sector ƂɁAErase Aflash_info->data_size (ftHg Sub Sector)  Write,Read,Verify s܂B
	for(i = 0; i < NUM_OF_SEC; i++){
		ret_code = 0;
		alt_u32 read_write_offset = sector_offset;

		printf("\n*******************************************\n");
		printf("\nNumber of Executions = %d [n]\nErase/Write/Read Sector BASE Address = 0x%08lx (Sector Number = %ld)\n\n", i+1, sector_offset,sector_offset / flash_info->sector_size);
		// Sector Erase s܂B4 Verify ̗Lݒł܂B
		ret_code = Erase(flash_info, sector_offset, 1, 1);
		if(ret_code != 0){
			printf("Erase Error = %d \n", ret_code);
			break;
		}
		// flash_info->data_size (ftHg Sub Sector) ɁAWrite Read Verify s܂B
		printf("Start Write Read Verify\n");
		for(j = 0; j < flash_info->sector_size / flash_info->subsector_size; j++){
			//@flash_info->data_size (ftHg Sub Sector)  buf_write_data  Write ܂B
			ret_code = write_memory(flash_info, buf_write_data, read_write_offset, flash_info->data_size);
			// Write ֐삵ARead  Verify s܂B
			if(ret_code == 0){
				printf("Read Address 0x%08lx : ",read_write_offset);
				// flash_info->data_size (ftHg Sub Sector)  Read Af[^ buf_read_data Ɋi[܂B
				ret_code = read_memory(flash_info, buf_read_data, read_write_offset, flash_info->data_size);
				// Read ֐삵AVerify s܂B
				if (ret_code == 0){
					// buf_read_data@ buf_write_data  Verify ܂B
					ret_code = Verify(buf_read_data, buf_write_data, flash_info->data_size);
					if (ret_code != 0){
						Print_Data(read_write_offset, buf_read_data, flash_info->data_size, PRINT_COLUMNS);
						printf("Verify Error = %d \n", ret_code);
						break;
					}
				}else{
					printf("Read Error = %d \n", ret_code);
					break;
				}
				read_write_offset = read_write_offset + flash_info->subsector_size;
			}else{
				printf("Write Error = %d \n", ret_code);
				break;
			}
		}
		// Write Read Verify ɎsĂꍇA1ڂ For 𔲂܂B
		if (ret_code == 0){
			sector_offset = sector_offset + flash_info->sector_size;
			Print_Data(read_write_offset - flash_info->subsector_size, buf_read_data, flash_info->data_size, PRINT_COLUMNS);
			printf("End Write Read Verify\n");
		}else{
			break;
		}
	}
	Print_Read_Status(flash_info);
	// Buffer JāAI܂B
FINISH:
	printf("\n*******************************************\n");
	if(buf_read_data != NULL){
		printf("Free buf_read_data.\n");
		free(buf_read_data);
		buf_read_data = NULL;
	}
	if(buf_write_data != NULL){
		printf("Free buf_write_data.\n");
		free(buf_write_data);
		buf_write_data = NULL;
	}
	if(flash_info != NULL){
		printf("Free flash_info.\n");
		free(flash_info);
		flash_info = NULL;
	}
	printf("Finish Nios II.");
	printf("\n*******************************************\n");

	return 0;
}

/***********************************************************************************
 *  sub function
 ***********************************************************************************/
/***********************************************************************************
 * Print_various_Regster_for_Debug
 *
 * ̊֐́ARead Status ȊO̎v Register  Read ֐łB
 * gp Flash ROM ɂĂ̓T|[gĂȂ Register ܂̂ŁA
 * JX^}CYāAfobOpɎgpĂB
 *
 * Arguments:
 *@- *flash_info: Pointer to Flash Device Structure.
 *
 * Returns:
 * - none
 ***********************************************************************************/
void Print_various_Regster_for_Debug(gsfi_flash_info *flash_info){
	printf("\n");
	printf("READ NONVOLATILE CONFIGURATION REGISTER = 0x%x\n",read_various_register(flash_info, READ_NON_VOLA_CONFIG_CMD, READ_NON_VOLA_CONFIG_BYTES));
	printf("READ VOLATILE CONFIGURATION REGISTER = 0x%x\n",read_various_register(flash_info, READ_VOLA_CONFIG_CMD, READ_VOLA_CONFIG_BYTES));
	printf("READ ENHANCED VOLATILE CONFIGURATION REGISTER = 0x%x\n",read_various_register(flash_info, READ_ENHAN_VOLA_CONFIG_CMD, READ_ENHAN_VOLA_CONFIG_BYTES));
	printf("READ EXTENDED ADDRESS REGISTER = 0x%x\n",read_various_register(flash_info, READ_EXTEN_ADD_REG_CMD, READ_EXTEN_ADD_REG_BYTES));
	printf("READ GENERAL PURPOSE READ REGISTER = 0x%x\n",read_various_register(flash_info, READ_GEN_PURPOSE_REG_CMD, READ_GEN_PURPOSE_REG_BYTES));
	printf("READ SECTOR PROTECTION  = 0x%x\n",read_various_register(flash_info, READ_SEC_PROTECT_CMD, READ_SEC_PROTECT_BYTES));
	printf("READ VOLATILE LOCK BITS = 0x%x\n",read_various_register(flash_info, READ_VOLA_LOCK_BIT_CMD, READ_VOLA_LOCK_BIT_BYTES));
	printf("READ NONVOLATILE LOCK BITS  = 0x%x\n",read_various_register(flash_info, READ_NON_VOLA_LOCK_BIT_CMD, READ_VOLA_LOCK_BIT_BYTES));
	printf("READ GLOBAL FREEZE BIT  = 0x%x\n",read_various_register(flash_info, READ_GLOBAL_FREEZE_BIT_CMD, READ_GLOBAL_FREEZE_BIT_BYTES));
	printf("\n");
}
/***********************************************************************************
 * Print_GSFI_Register
 *
 * ̊֐́AGSFI  Register ݒo͂܂B
 *
 * Arguments:
 *@- *flash_info: Pointer to Flash Device Structure.
 *
 * Returns:
 * - none
 ***********************************************************************************/
void Print_GSFI_Register(gsfi_flash_info *flash_info){

	int i;
	printf("\nPrint GSFI Register.\n");
	for(i=0;i<=13;i++){
		printf("Offset 0x%x : 0x%08x\n",i,IORD(flash_info->gsfi_csr_base,i));
	}
}
/***********************************************************************************
 * Print_Read_Status
 *
 * ̊֐́AFlash ROM  Status  Read ĕ\܂B
 *
 * Arguments:
 *@- *flash_info: Pointer to Flash Device Structure.
 * Returns:
 * - none
 ***********************************************************************************/
void Print_Read_Status(gsfi_flash_info *flash_info){
	printf("Read Status = 0x%x\n", read_status_register(flash_info));
	// Read Flash Status Ȃ@Flash ROM gpĂꍇARgAEgĂ
	printf("Read Flag Status = 0x%x\n", read_flag_status_register(flash_info));
	// Micron Flash ROM x[XɋLڂĂ܂̂ŁAFlash ROM ɂĂ͑ΉĂȂ Register ܂łꍇ܂B
	Print_various_Regster_for_Debug(flash_info);
}
/***********************************************************************************
 * Erase
 *
 * ̊֐́Aw肵 sector_base_address ̃ZN^[C[X܂B
 * num_sector_erase  Erase  Sector wł܂B
 *
 * num_sector_erase  0 ȏ̒lw肵܂B0 ȉ̏ꍇAG[ ɂȂ܂B
 * sector_base_address  num_sector_erase ̒lŁAFlash ROM ̗eʂ𒴂ĂꍇAG[ɂȂ܂B
 *
 * erase_sector() ̒ŁAWIP Check sABusy ܂ Wait ܂B
 * verify_enable L̏ꍇAC[XARead  Verify ܂B
 *
 * Arguments:
 *@- *flash_info: Pointer to Flash Device Structure.
 *@- *read_buf_add: Read Buffer
 *@- sector_base_address: Sector Erase Base Address
 *@- num_sector_erase:@Number of Sectors to Erase
 *@- verify_enable: 1:Enable Verify, not 1:Disable Verify
 *
 * Returns:
 * - 0: Not Error
 * - -5(EIO): Verify Error
 * - -22(EINVAL): Invalid argument Error
 * - counter: WIP Check Timeout
 ***********************************************************************************/
int Erase(gsfi_flash_info *flash_info, alt_u32 sector_base_address, alt_u32 num_sector_erase, alt_u32 verify_enable){
	int ret_code = 0;
	int i,j;
	alt_u32 erase_end_address = sector_base_address +(flash_info->sector_size * num_sector_erase);
	alt_u32 subsector_base_address = sector_base_address;
	if(
			(erase_end_address >= flash_info->gsfi_mem_span)
			|| (num_sector_erase < 0)
			|| (num_sector_erase > flash_info->number_of_sector)
	){
		return -EINVAL;
	}
	printf("Start Erase.\n");
	for(i=0; i < num_sector_erase; i++){
		//Sector Erase s܂B
		printf("Erase Sector Address = 0x%08lx\n",sector_base_address);
		ret_code = erase_sector(flash_info, sector_base_address);
		if(ret_code == 0){
			//4 verify_enable  1 ꍇAVerify s܂B
			if(verify_enable == 1){
				for(j = 0; j < flash_info->sector_size / flash_info->subsector_size; j++){
					ret_code = Erase_Verify(flash_info, subsector_base_address, flash_info->subsector_size);
					if(ret_code != 0){
						return ret_code;
					}
					subsector_base_address = subsector_base_address + flash_info->subsector_size;
				}
			}else{
				printf("Erase was successful. (without Verify)\n");
			}
		}else{
			return ret_code;
		}
		sector_base_address = sector_base_address + flash_info->sector_size;
	}
	printf("End Erase.\n\n");
	return ret_code;
}
/***********************************************************************************
 * Verify
 *
 * ̊֐͈ɓnobt@[̃f[^ Verify ܂B
 *
 * Verify ɎsꍇAsAhX\܂B
 *
 * Arguments:
 *@- *read_buf_add: Read Buffer Pointer
 *@-@*write_buf_add: Write Buffer Pointer
 *@- length:@ Data Length
 *
 * Returns:
 * - 0: Not Error
 * - -5(EIO): Verify Error
 ***********************************************************************************/
int Verify(const alt_u8 *read_buf_add, const alt_u8 *verify_buf_add, alt_u32 length){
	int ret_code = 0;
	int i;

	for(i = 0; i < length; i++){
		if(*read_buf_add++ == *verify_buf_add++){
			ret_code = 0 ;
		}else{
			ret_code = -EIO;
			break;
		}
	}
	if (ret_code == 0){
		printf("Verify was successful.\n");
	}else{
		printf("Verify was Fail.\n");
		printf("Verify Error Offset = 0x%08x\n", i);
		printf("Read Data           = 0x%02x\n", *read_buf_add);
		printf("Verify Source Data  = 0x%02x.\n\n", *verify_buf_add);
		printf("-- Verify Source Data --");
		Print_Data(0, verify_buf_add, i + 1, PRINT_COLUMNS);
		printf("-- Verify Source Data --\n");
	}
	return ret_code;
}

/***********************************************************************************
 * Erase_Verify
 *
 * ̊֐͈ɓn base_address  length ̃f[^ׂ 0xFF  Verify ܂B
 *
 * Verify ɎsꍇAG[R[hԂ܂B
 *
 * Arguments:
 *@- *flash_info: Pointer to Flash Device Structure.
 *@-@*write_buf_add: Write Buffer Pointer
 *@- length:@ Data Length
 *
 * Returns:
 * - 0: Not Error
 * - -5(EIO): Verify Error
 * - -12(ENOMEM):Allocate Memory Error
 * - -22(EINVAL): Invalid argument
 ***********************************************************************************/
int Erase_Verify(gsfi_flash_info *flash_info, alt_u32 base_address, alt_u32 length){
	int ret_code = 0;
	int i;
	unsigned char *buf_read  = NULL;
	buf_read = (unsigned char *)malloc(length);
	if(buf_read == NULL) {
		printf("Can not allocate memory.\n");
		buf_read = NULL;
		return -ENOMEM;
	}
	printf("Verify Address = 0x%08lx : ",base_address);
	ret_code = read_memory(flash_info, buf_read, base_address, length);
	if(ret_code == 0){
		for(i = 0; i < length; i++){
			if(*(buf_read + i) == 0xFF){
				ret_code = 0;
			}else{
				ret_code = -EIO;
				break;
			}
		}
	}
	if (ret_code == 0){
		printf("Erase Verify was successful.\n");
	}else
	if (ret_code == -EIO){
		printf("Erase Verify was Fail = %d \n", ret_code);
		printf("Verify Error Offset = 0x%x\n",i);
	}else{
		printf("Read Error = %d \n", ret_code);
	}

	if(buf_read != NULL) {
		free(buf_read);
		buf_read = NULL;
	}
	return ret_code;
}
/***********************************************************************************
 * Print_Data
 *
 * ̊֐́Aw肵obt@[̃f[^_v܂B
 * columns ̒lŁA\񐔂ύXł܂B
 *
 * Arguments:
 * - read_sector_offset: Offset Info
 * - *data:  Buffer
 * - length: Date Length
 * - columns: \񐔁@0~256
 *
 * Returns:
 * - none
 ***********************************************************************************/
void Print_Data(alt_u32 read_offset, const alt_u8 *data, alt_u32 length, alt_u32 columns){
	int i;
	const alt_u8 *data_buf = data;
	alt_u8 ascii_buf[columns + 1];

	// \鍀ڂ  print_length \
	printf("\n-Address--|");
	for(i = 0; i < columns; i++){
		if(i == (columns-1)){
			printf("%02x",i);
		}else{
			printf("%02x ",i);
		}
	}
	printf("| ASCII\n");
	printf("--------");
	for(i = 0; i <= columns; i++){
		printf("--+");
	}
	for(i = 0; i < columns; i++){
		printf("-");
	}
	printf("\n");

	// length  f[^\
	while((data_buf - data) < length){
		printf("0x%08lx ", read_offset);
		for (i = 0; i < columns; i++) {
			ascii_buf[i] = (unsigned char)((*data_buf < 0x20 || *data_buf >= 0x7f) ? '.': *data_buf);
			printf("%02X ", (int)*data_buf);

			if ((++data_buf - data) >= length) {
				ascii_buf[++i] = '\0';
				for (; i < columns; i++) {
					printf("   ");
				}
				break;
			}
		}
		// IR[hŌɓāAASCII \
		ascii_buf[columns] = '\0';
		printf("%s\n", ascii_buf);
		read_offset = read_offset + columns;
	}
}
/***********************************************************************************
 * Check_Settings
 *
 * ̊֐́A
 * start_address
 * access_number_sector
 * ̒lgp Flash ROM ̎dlɍĂ邩mF܂B
 *
 * Arguments:
 * - *flash_info: Pointer to Flash Device Structure.
 * - start_address: SEC_BASE_ADD : ANZXAFlash ROM ̃X^[gAhX
 * - access_number_sector: NUM_OF_SEC : ANZXZN^[̐
 *
 * Returns:
 * - 0: Not Settings Error
 * - -22(EINVAL):Invalid argument Error
 ***********************************************************************************/
int Check_Settings(gsfi_flash_info *flash_info, alt_u32 start_address, alt_u32 access_number_sector){
	int error = 0;
	unsigned long flash_sector_size 	= flash_info->sector_size;
	unsigned long flash_number_sector 	= flash_info->number_of_sector;

	printf("\nThe Start Sector Address you set = 0x%08lx\n",start_address);
	printf("The Number of Sector you set = %ld\n",access_number_sector);

	// access_number_sector  0 ȂmF܂B
	if(access_number_sector != 0){
		// start_address  Sector Base Address ɂȂĂ邩mF܂B
		if(start_address % flash_sector_size){
			printf("** The Start Sector Address you set is not The Sector Base Address.\n");
			printf("**** Please set the correct the Start Sector Address.\n");
			error = EINVAL;
		}

		// start_address  Flash ROM ̗eʂ𒴂ĂȂmF܂B
		if(start_address > (flash_number_sector - 1)*flash_sector_size){
			printf("** The Start Sector Address you set is over.\n");
			printf("**** Please set the correct the Start Sector Address.\n");
			printf("**** You need set the Start Sector Address within 0x%lx. \n\n",(flash_number_sector - 1)*flash_sector_size);
			error = EINVAL;
		}

		// ݒ肵 access_number_sector  start_address ŏ Sector ȂmF܂B
		if(access_number_sector + (start_address / flash_sector_size) > flash_number_sector){
			printf("** The Number of Sectors you set is over.\n");
			printf("**** Please set the correct the Number of Sectors.\n");
			printf("**** You need set Number of Sector within %ld.\n",flash_number_sector - (start_address / flash_sector_size));
			error = EINVAL;
		}
	}else{
		printf("** The Number of Sectors you set is 0.\n");
		printf("**** You need to set the Number of Sectors to be greater than 0.\n");
		error = EINVAL;
	}

	if(error == 0){
		printf("There are no setting errors.\n");
		printf("\n");
	}else{
		printf("There are setting errors.\n");
	}
	return error;
}
