//*******************************************************************************
// file  zip_file_system_sample.c
//
// attention
// Copyright (C) 2021 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS".
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
//
//   Created 2021/12/09
//*******************************************************************************

/***********************************************************************************
 *  includes
 ***********************************************************************************/
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "system.h"

/***********************************************************************************
 *  re-definitions
 *  ̃ZNV"system.h"Œ`ꂽ萔A
 *    {\[Xt@CŎgp邽߂ɍĒ`̂łB
 *    gp̍ۂ͉E̒萔"system.h"QƂ̏AύXĂgB
 ***********************************************************************************/

/***********************************************************************************
 *  definitions (define, enum, typedef, etc..)
 *  
 ***********************************************************************************/
#define BUFF_SIZE       (4096)
#define PRINT_LENGTH    (16)								// Print_Sector_Data() ŕ\ 1~256
/***********************************************************************************
 *  proto types
 ***********************************************************************************/
void Print_Sector_Data(unsigned long read_offset, unsigned char *data, unsigned long length, int print_length);

int main()
{
	unsigned char *buf_read_data = NULL;
	FILE *fp_in;
	int ret_code = 0;

	printf("Hello from Nios II!\n");
	printf("Zip File System Sample\n");

	printf("allocate memory for buf_read_data\n");
	buf_read_data =  (unsigned char *)malloc(BUFF_SIZE);
	if((buf_read_data == NULL)) {
		printf("Can not allocate memory.\n");
		goto FINISH;
	}

	// Open File System
	printf("Open File System : /mnt/rozipfs/flash_rom/test.bin\n");
	if((fp_in = fopen("/mnt/rozipfs/flash_rom/test.bin", "r")) == NULL){
		printf("Cannot open zip file system : /mnt/rozipfs/flash_rom/test.bin : fp_in=%d",(int)fp_in);
		goto FINISH;
	}
	// Read from File System, Write to buf_read_data
	printf("Read from File System, Write to buf_read_data \n");
	if((ret_code = fread((int*)buf_read_data, BUFF_SIZE, 1, fp_in)) != 1){
		printf("Read error zip file system : /mnt/zipfs/hello : return = %d",ret_code);
		fclose (fp_in);
		goto FINISH;
	}
	// Close File System
	printf("Close File System\n");
	fclose (fp_in);

	printf("\nPrint buf_read_data read from zip file system\n");
	printf("0x%x : Base Address of buf_read_data",(unsigned int) buf_read_data);
	Print_Sector_Data((unsigned long) buf_read_data, buf_read_data, BUFF_SIZE,PRINT_LENGTH);

FINISH:
	printf("\n*******************************************\n");
	if(buf_read_data != NULL){
		printf("Free buf_read_data.\n");
		free(buf_read_data);
		buf_read_data = NULL;
	}
	printf("Finish Nios II.");
	printf("\n*******************************************\n");

	return 0;
}

/***********************************************************************************
 * Print_Sector_Data
 *
 * ̊֐́Aw肵obt@[̃f[^_v܂B
 * print_lentgh ̒lŁA\񐔂ύXł܂B
 *
 * Arguments:
 * - read_offset: Offset Info
 * - *data:  Buffer
 * - length: Date Length
 * - print_length: \񐔁@0~256
 *
 * Returns:
 * - none
 ***********************************************************************************/
void Print_Sector_Data(unsigned long read_offset, unsigned char *data, unsigned long length, int print_length){
	int i;
	unsigned char *data_buf = data, ascii_buf[print_length+1];

	// \鍀ڂ  print_length \
	printf("\n-Address--|");
	for(i = 0; i < print_length; i++){
		if(i == (print_length-1)){
			printf("%02x",i);
		}else{
			printf("%02x ",i);
		}
	}
	printf("| ASCII\n");
	printf("--------");
	for(i = 0; i <= print_length; i++){
		printf("--+");
	}
	for(i = 0; i < print_length; i++){
		printf("-");
	}
	printf("\n");

	// length  f[^\
	while((data_buf - data) < length){
		printf("0x%08lx ", read_offset);
		for (i = 0; i < print_length; i++) {
			ascii_buf[i] = (unsigned char)((*data_buf < 0x20 || *data_buf >= 0x7f) ? '.': *data_buf);
			printf("%02X ", (int)*data_buf);

			if ((++data_buf - data) >= length) {
				ascii_buf[++i] = '\0';
				for (; i < print_length; i++) {
					printf("   ");
				}
				break;
			}
		}
		// IR[hŌ̓āAASCII \
		ascii_buf[print_length] = '\0';
		printf("%s\n", ascii_buf);
		read_offset = read_offset + print_length;
	}
}
