﻿/********************************************************************************//*!
 * @file  sample_app_setting.h
 * @brief  L2 MMU initial setting definition of the HPS and the Board.
 * 
 * @details  L2 MMU initial setting definition of the HPS and the Board.
 * 
 * @note  nothing. 
 * 
 * @attention 
 * Copyright (C) 2013-2019 MACNICA,Inc. All Rights Reserved.\n
 *   This software is licensed "AS IS". 
 *   Please perform use of this software by a user's own responsibility and expense.
 *   It cannot guarantee in the maker side about the damage which occurred by the ab-
 *   ility not to use or use this software, and all damage that occurred secondarily.
 **//*******************************************************************************/

/***********************************************************************************
 *  includes
 ***********************************************************************************/
#include <stdint.h>
#include "hwlib.h"
#include "alt_generalpurpose_io.h"
#include "alt_l2_p310.h"

/***********************************************************************************
 *  externs 
 ***********************************************************************************/

/***********************************************************************************
 *  proto types 
 ***********************************************************************************/

/***********************************************************************************
 *  definitions (define, enum, typedef, etc..) 
 ***********************************************************************************/
// NOTE: To enable debugging output, delete the next line and uncomment the line after.
#define dprintf(...)
// #define dprintf  printf

/* Basic definition*/
#define	__WARN_UNUSED__		__attribute__((unused))

#define	_KB		1024UL
#define	_MB		(1024UL*1024UL)
#define	_GB		(1024UL*1024UL*1024UL)

typedef void (*CALLBACK_FUNKt)(uint32_t, void*);

#define ACP_WINDOW_BASE	(0x80000000)

/******** Definition Memory Region ********/
/*! SDRAM1(Remap Region) ..   PA:0x00000000~0x0FFFFFFF <--> VA: (=PA) */
#define	SDRAM1_PHYSICAL_ADDR		0x00000000
#define	SDRAM1_VIRTUAL_ADDR			SDRAM1_PHYSICAL_ADDR
#define	SDRAM1_SIZE					( 1 * _MB )

/*! SDRAM2(Private Region) .. PA:0x0x00100000~0x1FFFFFFF <--> VA: (=PA) */
#define	SDRAM2_PHYSICAL_ADDR		0x00100000
#define	SDRAM2_VIRTUAL_ADDR			SDRAM2_PHYSICAL_ADDR
#define	SDRAM2_SIZE					( 255 * _MB )

/*! SDRAM3(Common0 Region) .. PA:0x10000000~0x27FFFFFF <--> VA: (=PA) */
#define	SDRAM3_PHYSICAL_ADDR		0x10000000
#define	SDRAM3_VIRTUAL_ADDR			SDRAM3_PHYSICAL_ADDR
#define	SDRAM3_SIZE					( 256 * _MB )

/*! SDRAM4(Common1 Region) .. PA:0x20000000~0x2FFFFFFF <--> VA: (=PA) */
#define	SDRAM4_PHYSICAL_ADDR		0x20000000
#define	SDRAM4_VIRTUAL_ADDR			SDRAM4_PHYSICAL_ADDR
#define	SDRAM4_SIZE					( 256 * _MB )

/*! SDRAM5(Common2 Region) .. PA:0x30000000~0x3FFFFFFF <--> VA: (=PA) */
#define	SDRAM5_PHYSICAL_ADDR		0x30000000
#define	SDRAM5_VIRTUAL_ADDR			SDRAM5_PHYSICAL_ADDR
#define	SDRAM5_SIZE					( 256 * _MB )

/*! ACPWINDOW .. PA:0x80000000~0xBFFFFFFF <--> VA: (=PA) *//* DMA用APIがNGになるので、PA=VAでMMU設定 */
#define	ACPWINDOW_PHYSICAL_ADDR		0x80000000
#define	ACPWINDOW_VIRTUAL_ADDR		ACPWINDOW_PHYSICAL_ADDR
#define	ACPWINDOW_SIZE				(1 * _GB)

/*! HPS2FPGA .. PA:0xC000000~0xFBFFFFFF <--> VA: (=PA) */
#define	HPS2FPGA_PHYSICAL_ADDR		0xC0000000
#define	HPS2FPGA_VIRTUAL_ADDR		HPS2FPGA_PHYSICAL_ADDR
#define	HPS2FPGA_SIZE				( 960 * _MB )

/*! LW_HPS2FPGA .. PA:0xFF200000~0xFF3FFFFF <--> VA: (=PA) */
#define	LW_HPS2FPGA_PHYSICAL_ADDR	0xFF200000
#define	LW_HPS2FPGA_VIRTUAL_ADDR	LW_HPS2FPGA_PHYSICAL_ADDR
#define	LW_HPS2FPGA_SIZE			( 2 * _MB )

/*! PERIPHRALS .. PA:0xFF400000~0xFFEFFFFF <--> VA: (=PA) */
#define	PERIPHRALS_PHYSICAL_ADDR	0xFF400000
#define	PERIPHRALS_VIRTUAL_ADDR		PERIPHRALS_PHYSICAL_ADDR
#define	PERIPHRALS_SIZE				( 11 * _MB )

/*! BOOTROM .. PA:0xFFFD0000~0xFFFDFFFF <--> VA: (=PA) */
#define	BOOTROM_PHYSICAL_ADDR		0xFFFD0000
#define	BOOTROM_VIRTUAL_ADDR		BOOTROM_PHYSICAL_ADDR
#define	BOOTROM_SIZE				( 64 *_KB )

/*! MPUSCU .. PA:0xFFFEC000~0xFFFEDFFF <--> VA: (=PA) */
#define	MPUSCU_PHYSICAL_ADDR		0xFFFEC000
#define	MPUSCU_VIRTUAL_ADDR			MPUSCU_PHYSICAL_ADDR
#define	MPUSCU_SIZE					( 8 * _KB)

/*! MPUL2 .. PA:0xFFFEF000~0xFFFEFFFF <--> VA: (=PA) */
#define	MPUL2_PHYSICAL_ADDR			0xFFFEF000
#define	MPUL2_VIRTUAL_ADDR			MPUL2_PHYSICAL_ADDR
#define	MPUL2_SIZE					( 4 * _KB)

/*! ONCHIPRAM .. PA:0xFFFF0000~0xFFFFFFFF <--> VA: (=PA) */
#define	RAM_PHYSICAL_ADDR			0xFFFF0000
#define	RAM_VIRTUAL_ADDR			RAM_PHYSICAL_ADDR
#define	RAM_SIZE					( 64 *_KB )


/***********************************************************************************
 *  variables
 ***********************************************************************************/
extern uint32_t *mmu_tlb_l1;

/***********************************************************************************
 *  functions 
 ***********************************************************************************/
void sample_mmu_init_and_enable(void);
int cpu0_l2mmu_init(void);


/***********************************************************************************
 * end of file 
 ***********************************************************************************/
