﻿/*******************************************************************************
// file  SysclkTimer.c
//
// attention
// Copyright (C) 2022 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS".
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
*******************************************************************************

***********************************************************************************
*  includes
***********************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include "system.h"
#include "sys/alt_alarm.h"


/***********************************************************************************
 *  re-definitions
 *  ※このセクションは"system.h"で定義された定数を、
 *    本ソースファイル内で使用するために再定義したものです。
 *    ご使用の際は右側の定数を"system.h"を参照の上、変更してお使いください。
 ***********************************************************************************/
#define units	(ALARM_PERIOD_UNITS)
#define conv 	(ALARM_MULT)

/***********************************************************************************
 *  definitions (define, enum, typedef, etc..)
 ***********************************************************************************/
#define count (100000)

/***********************************************************************************
 *  variables
 ***********************************************************************************/
/***********************************************************************************
 *  proto types
 ***********************************************************************************/
void func1();

/***********************************************************************************
 *  main function
 ***********************************************************************************/
int main()
{
	int start_time = 0;
	int end_time = 0;

	printf("Hello from Nios II SystemCLK!\n");

	printf("count Up ( %d ) \n",count);

	//測定対象関数前後の Tick 数を取得。
	start_time = alt_nticks();
	func1();
	end_time = alt_nticks();

	//debug	print
	printf("start %d\n",start_time);
	printf("end %d\n",end_time);
	printf("ticks/sec %d\n",(int)alt_ticks_per_second());
	//debug end

	//所用時間計算
	printf("total time = %d %s \n",(int)((end_time-start_time)/(float)alt_ticks_per_second()/ conv),units);

}

void func1()
{
	int num = 0;
	while(num < count)
	{
		++num;
	}
}
