﻿/*******************************************************************************
// file  WDT.c
//
// attention
// Copyright (C) 2022 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS".
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
*******************************************************************************

 ***********************************************************************************
 *  includes
 ***********************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include "system.h"
#include "sys/alt_alarm.h"
#include "altera_avalon_timer.h"
#include "altera_avalon_timer_regs.h"
#include "altera_avalon_pio_regs.h"

/***********************************************************************************
 *  re-definitions
 *  ※このセクションは"system.h"で定義された定数を、
 *    本ソースファイル内で使用するために再定義したものです。
 *    ご使用の際は右側の定数を"system.h"を参照の上、変更してお使いください。
 ***********************************************************************************/
#define LED_CSR_ADR				(LED_R_BASE)							// LED のアドレス
#define WDT_ADR				    (WDT_BASE)								// WDT Timer のアドレス
#define WDT_BIT_MSK				(WDT_COUNTER_SIZE)						// WDT Timer のビットマスク

/***********************************************************************************
 *  definitions (define, enum, typedef, etc..)
 ***********************************************************************************/
#define LED_BLINK_PERIOD_MS 		(500*1000)
#define KICK_LIMIT (5)

/***********************************************************************************
 *  variables
 ***********************************************************************************/
int kick_count = 0;
int kick_flag_not =0;

/***********************************************************************************
 *  proto types
 ***********************************************************************************/
alt_u32 WDTKick_count(void * context);

/***********************************************************************************
 *  main function
 ***********************************************************************************/
int main()
{
	static alt_alarm WDTKick;
	printf("Hello from Nios II WDT!\n");

	//LEDの消灯
	IOWR_ALTERA_AVALON_PIO_DATA(LED_CSR_ADR, 0x0);
	// WDT の Status レジスターのクリア
	IOWR_ALTERA_AVALON_TIMER_STATUS(WDT_ADR,ALTERA_AVALON_TIMER_STATUS_RUN_MSK);
	// WDT スタート
	IOWR_ALTERA_AVALON_TIMER_CONTROL(WDT_ADR, ALTERA_AVALON_TIMER_CONTROL_START_MSK);
	// アラームの登録
	alt_alarm_start(&WDTKick, (WDT_PERIOD -1) * alt_ticks_per_second(),WDTKick_count,NULL);

	// 無限ループ
	while(1)
	{
		//LEDの点灯
		IOWR_ALTERA_AVALON_PIO_DATA(LED_CSR_ADR, 0x0F);
		usleep(LED_BLINK_PERIOD_MS);
		IOWR_ALTERA_AVALON_PIO_DATA(LED_CSR_ADR, 0xF0);
		usleep(LED_BLINK_PERIOD_MS);

		//指定回数初期化後、ソフトウェアリセット
		if(kick_flag_not == 1){
			printf("Reset soon....\n");
			kick_flag_not =0;
		}
	}
}

// アラームの終了時呼び出される関数
alt_u32 WDTKick_count(void * context)
{
	if (kick_count < KICK_LIMIT)
	{
		//WDTのタイマーをリセット
		IOWR_ALTERA_AVALON_TIMER_PERIODL(WDT_ADR, WDT_BIT_MSK);
		++kick_count;
	}else if(kick_count == KICK_LIMIT){
		kick_flag_not = 1;
	}

	//WDTタイマーから  1s 早くアラームを設定
	return (WDT_PERIOD -1) * alt_ticks_per_second();

}
