﻿/*
 * alarm.c
 *
 *  Created on: 2022/03/11
 *      Author: 12945
 */
/*******************************************************************************
// file  SysclkTimer.c
//
// attention
// Copyright (C) 2022 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS".
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
*******************************************************************************

***********************************************************************************
*  includes
***********************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include "sys/alt_alarm.h"


/***********************************************************************************
 *  re-definitions
 *  ※このセクションは"system.h"で定義された定数を、
 *    本ソースファイル内で使用するために再定義したものです。
 *    ご使用の際は右側の定数を"system.h"を参照の上、変更してお使いください。
 ***********************************************************************************/
/***********************************************************************************
 *  definitions (define, enum, typedef, etc..)
 ***********************************************************************************/
#define LOOPSEC		(5)

/***********************************************************************************
 *  variables
 ***********************************************************************************/
int callback = 0;
int count = 0;

/***********************************************************************************
 *  proto types
 ***********************************************************************************/
alt_u32 tim_callback(void * context);

/***********************************************************************************
 *  main function
 ***********************************************************************************/
int main()
{
	//アラーム登録用の変数
	static alt_alarm alarm;

	printf("Hello from Nios II Alarm!\n");

	// アラームの登録
	alt_alarm_start(&alarm,LOOPSEC * alt_ticks_per_second(),tim_callback,NULL);
	//無限ループ
	while(1)
	{
		if(callback)
		{
			printf("Callback count :%d \nSet Alarm %d s \n", count,LOOPSEC);
			callback =0;
		}
	}
	return 0;
}

// アラームの終了時呼び出される関数
alt_u32 tim_callback(void * context)
{
	count = count + 1;
	callback = 1;

	//戻り値により、次回 Alarm　の周期を設定(LOOPSEC秒)
	return LOOPSEC * alt_ticks_per_second();
}




