﻿/*******************************************************************************
// file  TimestampTimer.c
//
// attention
// Copyright (C) 2022 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS".
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
*******************************************************************************

***********************************************************************************
*  includes
***********************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include "sys/alt_timestamp.h"



/***********************************************************************************
 *  re-definitions
 *  ※このセクションは"system.h"で定義された定数を、
 *    本ソースファイル内で使用するために再定義したものです。
 *    ご使用の際は右側の定数を"system.h"を参照の上、変更してお使いください。
 ***********************************************************************************/

/***********************************************************************************
 *  definitions (define, enum, typedef, etc..)
 ***********************************************************************************/
#define count (100000)
//　ns 変換用変数
#define conv (100000000)

/***********************************************************************************
 *  variables
 ***********************************************************************************/
/***********************************************************************************
 *  proto types
 ***********************************************************************************/
void func1();
/***********************************************************************************
 *  main function
 ***********************************************************************************/
int main()
{
	alt_u32 start_time = 0;
	alt_u32 end_time = 0;


	printf("Hello from Nios II TimeStamp!\n");

	if(alt_timestamp_start() < 0)
	{
		printf("No timestamp device available \n");
	}
	else
	{
		printf("count Up ( %d ) \n",count);

		//測定対象関数前後の内部カウンターを参照
		start_time = alt_timestamp();
		func1();
		end_time = alt_timestamp();

		//debug	print
		printf("start %lu\n",start_time);
		printf("end %lu\n",end_time);
		printf ("ticks/sec = %lu\n",alt_timestamp_freq());
		//debug end

		//所用時間計算
		printf("total time = %d ns \n",(int)((end_time - start_time)/(float)alt_timestamp_freq() * conv));	}
}

void func1()
{
	int num = 0;
	while(num < count)
	{
		++num;
	}

}

