//*******************************************************************************
// file  sample_master_top.v
//
// attention
// Copyright (C) 2018 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS". 
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
//*******************************************************************************
module sample_master_top(
   // General Interface
        input  wire        	clk,               //   clk
        input  wire        	reset_n,           //   reset_n
        
   // Avalon-MM Slave Interface
        output  reg [19:0] 	avmm_address,      //   address
        output  reg [1:0]  	avmm_byteenable,   //   byteenable
        output  reg        	avmm_read,         //   read
        input	wire [15:0] 	avmm_readdata,     //   readdata
        output  reg        	avmm_write,        //   write
        output  reg [15:0] 	avmm_writedata,    //   writedata
        input	wire		avmm_waitreq,
        
   // Conduit Interface
        input  wire        	external_port_in,  	//   export_0 : Counter Reset Input to Binary and Dray Code
        output reg [15:0]	external_port_dout,  //   export_1 : Monitor of Avalon-MM Master Write Data Contents
        output reg [1:0]	external_port_out	 	//   export_2 : State Indicator 2'b00(IDLE) 2'b01(WRITE)  2'b10(READ)
    );
    

    reg	gray_en;
    reg	bin_en;

    reg [19:0] 	addr_val;
      
    
    wire	[15:0]	gray16_writedata;
    wire	[15:0]	bin16_writedata;
    
    reg		[1:0]	m_state;
    parameter	STET_IDLE  = 2'b00,
					STET_WRITE = 2'b01, 
					STET_READ  = 2'b10;
   
 
	 
	 // Binary Counter
	 bin_16counter  bin_16counter_inst(
	.clk	(clk),
	.reset	(~reset_n|external_port_in),
	.enb	(bin_en),
	.b		(bin16_writedata)
	);
	
	 // Gray Code counter
	 gray_16counter gray_16counter_inst(
      	.clk			(clk),
	.en			(gray_en),
	.rst			(~reset_n|external_port_in),
        .counts_out		(gray16_writedata)
   );




	 
    // ALWAYS CONSTRUCT BLOCK

	always @(posedge clk or negedge reset_n) begin
		if (reset_n == 1'b0) begin
			addr_val <= 20'h00000;
		end
		else if(gray16_writedata < 16'h8000) begin
			addr_val <= 20'h00004;
		end
		else
			addr_val <= 20'h00008;
	end

 
    always @(posedge clk or negedge reset_n) begin

    	if (reset_n == 1'b0) begin
    		avmm_address		<= 20'hxxxx;   
			avmm_byteenable		<= 2'bxx;   
			avmm_read			<= 1'b0;      
			avmm_write			<= 1'b0;   
			avmm_writedata		<= 16'hxxxx;
			external_port_dout	<= 16'hzzzz;   
			external_port_out	<= 2'bzz;
			bin_en	<= 1'b0;	
			gray_en	<= 1'b0;	
			external_port_out <= 2'bzz;
    		m_state = STET_IDLE;
    	end
    	else begin
			bin_en	<= 1'b1;
			gray_en	<= 1'b1;	
    		case( m_state )
    		STET_IDLE : begin
    			avmm_address		<= 20'h00000;   
			avmm_byteenable		<= 2'b00;   
			avmm_read			<= 1'b0;      
			avmm_write			<= 1'b0;   
			avmm_writedata		<= 16'h0000;
			external_port_dout	<= 16'h0000;   
			external_port_out	<= 2'b00;
			external_port_out <= STET_IDLE;
			m_state = STET_WRITE;
    		end
    		STET_WRITE : begin
    			if( avmm_waitreq == 1'b0 ) begin
	    			avmm_address		<= addr_val; //20'h00004;
	    			avmm_byteenable		<= 2'b11;
	    			avmm_read			<= 1'b0;
	    			avmm_write			<= 1'b1; 
	    			avmm_writedata		<= gray16_writedata;
	    			external_port_dout	<= gray16_writedata;
	    			external_port_out	<= 2'b01;
				external_port_out <= STET_WRITE;
				m_state =STET_READ;
    			end
    		end
    		STET_READ : begin
   			if( avmm_waitreq == 1'b0 ) begin
	    			avmm_address		<= addr_val; //20'h00004;
	    			avmm_byteenable		<= 2'b11;
	    			avmm_read			<= 1'b1;
	    			avmm_write			<= 1'b0; 
	    			external_port_dout	<= avmm_readdata;
	    			external_port_out	<= 2'b01;
				external_port_out <= STET_READ;
				m_state =STET_WRITE;
    			end
    		end
    		endcase
    	end
    end
    
    


endmodule