//*******************************************************************************
// file  sample_slave_top.v
//
// attention
// Copyright (C) 2018 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS". 
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
//*******************************************************************************
//--------------------------------------------------------
//
// Description : Direct Form FIR
//
// Limitation  : 37 taps 
//
// --------------------------------------------------------
module sample_slave_top 
#(
	parameter	G_TAP_NUM = 37,
	parameter	G_M = G_TAP_NUM-1
)
(
	// General Interface
        input  wire        clk,               //   clk
        input  wire        reset_n,           //   reset_n
        
   // Avalon-MM Slave Interface
        input  wire [19:0] avms_address,      //   address
        input  wire [1:0]  avms_byteenable,   //   byteenable
        input  wire        avms_read,         //   read
        output wire [15:0] avms_readdata,     //   readdata
        input  wire        avms_write,        //   write
        input  wire [15:0] avms_writedata,    //   writedata
        
   // Conduit Interface
        input  wire        external_port_in,  //   export_0 : External Reset Input to D-FF & FIR
        output reg [1:0]	external_port_out	 //   export_1 : Indicator  2'b01(D-FF Mode)  2'b10(FIR Mode) 2'b00(Idle)
    );
    
    reg	dff_en;
    reg	fir_en;

    reg	internal_reset;
      
    wire	[15:0]	dff16_writedata;
    wire	[15:0] 	dff16_readdata;
    
    wire	[15:0]	fir37_writedata;
    wire	[15:0] 	fir37_readdata;

    reg         [15:0]  ff_readdata;
    reg         [15:0]  ff2_readdata;
	 
	 
	 // COMPONENT INSTANTIATIONS
	 // D-FF Component
    dff16	dff16_inst(
    .clk		(clk),
    .reset	(external_port_in|internal_reset|~reset_n),
	 .enb		(dff_en),
    .a		(dff16_writedata),
    .b		(dff16_readdata)
	 );
    
	 // FIR Component
    tap37_fir		#(
	.M				(G_M),			// (TAP_NUM -1)
	.TAP_NUM		(G_TAP_NUM)		// 37
	)	tap37_fir_inst(
    .clk			(clk),
    .reset_n	(~external_port_in|~internal_reset|reset_n),
	 .enb			(fir_en),
    .data_in	(fir37_writedata),
    .data_out	(fir37_readdata)
	 );
	 
	 
	 
    // ALWAYS CONSTRUCT BLOCK
    always @(posedge clk or negedge reset_n) begin
    	if (reset_n == 1'b0)
			external_port_out <=  2'b00;
		else
			if (avms_address == 20'b00000000000000000000) begin
				dff_en <=  1'b0;	// Reset (Byte Address 0x00)
				fir_en <=  1'b0;
				external_port_out <= 2'b00;
				internal_reset <= 1'b1;
			end
			else if (avms_address == 20'b00000000000000000100) begin
				dff_en <=  1'b1;	// D-FF Enable (Byte Address 0x04)
				fir_en <=  1'b0;
				external_port_out <= 2'b01;
				internal_reset <= 1'b0;
			end
			else if(avms_address == 20'b00000000000000001000) begin
				dff_en <=  1'b0;
				fir_en <=  1'b1;	// FIR Enable (Byte Address 0x08)
				external_port_out <= 2'b10;
				internal_reset <= 1'b0;
			end
			else begin
				dff_en <=  1'b0;	// Idle
				fir_en <=  1'b0;
				external_port_out <= 2'b00;
				internal_reset <= 1'b0;
			end
    end

    always @(posedge clk or negedge reset_n) begin
    	if (reset_n == 1'b0) begin
		ff_readdata <=  16'b0000000000000000;
    end
    else if(dff_en == 1'b1 && avms_read == 1'b1 && avms_byteenable == 2'b11) begin
		ff_readdata <=  dff16_readdata;
		ff2_readdata <=  ff_readdata;
    end
    else if(fir_en == 1'b1 && avms_read == 1'b1 && avms_byteenable == 2'b11) begin
		ff2_readdata <=  fir37_readdata;
    end
    else begin
		ff_readdata <=  16'bxxxxxxxxxxxxxxxx;
    end
    end
	 
    						
	// CONTINOUS ASSIGNMENT
 	assign dff16_writedata = (dff_en ==  1'b1 && avms_write == 1'b1 && avms_byteenable == 2'b11)? avms_writedata
								: 16'bxxxxxxxxxxxxxxxx;
	assign fir37_writedata = avms_writedata;

	assign avms_readdata = ff2_readdata;
  						


endmodule