//*******************************************************************************
// file  sample_slave_top_tb.v
//
// attention
// Copyright (C) 2018 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS". 
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
//*******************************************************************************
`timescale 1 ns / 100 ps
module	sample_slave_top_tb;

reg tb_clk;
reg tb_reset_n;

reg tb_ext_rst_i;
wire [1:0]	tb_ext_montr_o;

reg	[19:0]	tb_avms_addr_i;
reg	[1:0]	tb_avm_be_i;
reg			tb_re_i;
wire [15:0]	tb_rdata_o;
reg			tb_we_i;
reg [15:0]	tb_wdata_i;



sample_slave_top#(
	.G_TAP_NUM (37),
	.G_M (36)
) sample_slave_top_inst(
	// General Interface
        .clk			(tb_clk),               //   clk
        .reset_n		(tb_reset_n),           //   reset_n
        
   // Avalon-MM Slave Interface
        .avms_address		(tb_avms_addr_i),      //   address
        .avms_byteenable	(tb_avm_be_i),   //   byteenable
        .avms_read			(tb_re_i),         //   read
        .avms_readdata		(tb_rdata_o),     //   readdata
        .avms_write			(tb_we_i),        //   write
        .avms_writedata		(tb_wdata_i),    //   writedata
        
   // Conduit Interface
        .external_port_in	(tb_ext_rst_i),  //   export_0 : External Reset Input to D-FF & FIR
        .external_port_out	(tb_ext_montr_o)	 //   export_1 : Indicator  2'b01(D-FF Mode)  2'b10(FIR Mode) 2'b00(Idle)
    );



always begin
  tb_clk = 1'b1;
  #10 tb_clk = 1'b0;
  #10;
end

always @( posedge tb_clk or negedge tb_reset_n ) begin
	if (tb_we_i == 1'b1) begin
		tb_wdata_i = tb_wdata_i +1;
		end
	else begin
		tb_wdata_i = tb_wdata_i;
	end
end



initial begin
	tb_reset_n	=	1'b0; 
	tb_avms_addr_i = 20'h00000; // address 0x00000
	tb_avm_be_i = 2'b00;
	tb_re_i = 1'b0;
	tb_we_i = 1'b0;
	tb_wdata_i = 16'h0000;
	tb_ext_rst_i = 1'b0;

	#1000;
	tb_reset_n	=	1'b1;
	#200;
	
	#100 tb_avms_addr_i = 20'h00004; // address 0x00004
	#20 	tb_re_i = 1'b0;
		tb_we_i = 1'b1;
		tb_avm_be_i = 2'b11;
	#20	tb_re_i = 1'b1;
		
	#3000;
	#20	tb_re_i = 1'b0;
	#100    tb_re_i = 1'b1;

	#1000;
	#20	tb_re_i = 1'b0;
	#100 tb_avms_addr_i = 20'h00008; // address 0x00008
	#740	tb_re_i = 1'b1;
	
	#3000;
	#100 tb_ext_rst_i = 1'b1;
	#500 tb_ext_rst_i = 1'b0;

	#3000;
	tb_avms_addr_i = 20'h00000; // address 0x00000
end

endmodule