//*******************************************************************************
// file  sample_st_src_top_tb.v
//
// attention
// Copyright (C) 2018 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS". 
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
//*******************************************************************************
`timescale 1 ns / 100 ps
module	sample_st_src_top_tb;

reg tb_clk;
reg tb_reset_n;
reg tb_ext_rst_i;


reg				tb_ready_i;
wire			tb_avst_src_valid_o;
wire	[15:0]	tb_avst_src_data_o;
wire			tb_avst_src_sop_o;
wire			tb_avst_src_eop_o;


reg 		tb_ext_montr_i;
wire [15:0]	tb_ext_montr_d_o;
wire [1:0]	tb_ext_montr_o;

    
sample_st_src_top	sample_st_src_top_inst(
   // General Interface
        .clk	(tb_clk),               //   clk
        .reset_n	(tb_reset_n),           //   reset_n
        
   // Avalon-ST Source Interface
        .avst_src_ready	(tb_ready_i),		// ready
        .avst_src_valid	(tb_avst_src_valid_o),        //   valid
        .avst_src_data	(tb_avst_src_data_o),    //   data
        .avst_src_sop	(tb_avst_src_sop_o),        //   Start Of Packet
        .avst_src_eop	(tb_avst_src_eop_o),        //   End Of Packet
        
   // Conduit Interface
        .external_port_in	(tb_ext_montr_i),  	//   export_0 : Counter Reset Input to Binary and Dray Code
        .external_port_dout	(tb_ext_montr_d_o),  //   export_1 : Monitor of Avalon-MM Master Write Data Contents
        .external_port_out	(tb_ext_montr_o)	 	//   export_2 : State Indicator 2'b00(IDLE) 2'b01(WRITE)  2'b10(READ)
    );


always begin
  tb_clk = 1'b1;
  #10 tb_clk = 1'b0; 
  #10;
end


initial begin
	tb_reset_n	=	1'b0; 
	tb_ready_i = 1'b0;
	#500	tb_ready_i = 1'b1;
	#1000;
	tb_reset_n	=	1'b1; 
	#100 tb_ext_montr_i = 1'b0;
	
	#3000;
	#100 tb_ready_i = 1'b0;
	#9000;
	#100 tb_ready_i = 1'b1;
	#600
	#100 tb_ready_i = 1'b1;

end

endmodule