//*******************************************************************************
// file  sample_st_sink_top_tb.v
//
// attention
// Copyright (C) 2018 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS". 
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
//*******************************************************************************
`timescale 1 ns / 100 ps
module sample_st_sink_top_tb (
	);
	
	reg 			tb_clk;
	reg 			tb_reset_n;

	wire	[15:0]	tb_export_o;

	wire			tb_st_snk_ready_o;
	reg				tb_st_snk_valid_i;
	reg		[15:0]	tb_st_snk_data_i;
	reg				tb_st_snk_sop_i;
	reg				tb_st_snk_eop_i;

	sample_st_sink_top sample_st_sink_top_inst (
		.clk                     (tb_clk),
		.reset_n                 (tb_reset_n),
		.external_port_dout      (tb_export_o),
		.avst_sink_ready         (tb_st_snk_ready_o),
		.avst_sink_valid         (tb_st_snk_valid_i),
		.avst_sink_data          (tb_st_snk_data_i),
		.avst_sink_sop 			 (tb_st_snk_sop_i),
		.avst_sink_eop   		 (tb_st_snk_eop_i)
	);

always begin
  tb_clk = 1'b1;
  #10 tb_clk = 1'b0; 
  #10;
end

initial begin
	tb_reset_n = 1'b0;
	tb_st_snk_valid_i = 1'b0;
	tb_st_snk_sop_i = 1'b0;
	tb_st_snk_eop_i = 1'b0;
	tb_st_snk_data_i = 16'h0000;
	#1000	tb_reset_n = 1'b1;
	#500	tb_st_snk_sop_i = 1'b1;
		tb_st_snk_data_i = 16'h0001;
		tb_st_snk_valid_i = 1'b1;

	#20	tb_st_snk_sop_i = 1'b0;
		tb_st_snk_data_i = 16'h0002;
	#20	tb_st_snk_data_i = 16'h0003;
	#20	tb_st_snk_data_i = 16'h0004;
	#20	tb_st_snk_data_i = 16'h0005;
	#20	tb_st_snk_data_i = 16'h0006;
	#20	tb_st_snk_data_i = 16'h0007;
	#20	tb_st_snk_data_i = 16'h0008;
	#20	tb_st_snk_data_i = 16'h0009;
	#20	tb_st_snk_data_i = 16'h000a;
	#20	tb_st_snk_data_i = 16'h000b;
	#20	tb_st_snk_data_i = 16'h000c;
	#20	tb_st_snk_data_i = 16'h000d;
		tb_st_snk_eop_i = 1'b1;
	#20	tb_st_snk_eop_i = 1'b0;
		tb_st_snk_data_i = 16'h0000;
		tb_st_snk_valid_i = 1'b0;
end

endmodule
