//*******************************************************************************
// file  bin_16counter.v
//
// attention
// Copyright (C) 2018 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS". 
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
//*******************************************************************************
module	bin_16counter(
	input	wire					clk,
	input	wire					reset,
	input	wire					enb,
	output wire	[15:0]		b
);

reg [15:0] bin_cnt;

always @( posedge clk or posedge reset ) begin
	if (reset == 1'b1) begin
		bin_cnt		<= 16'h0000;
		end
	else if(enb == 1'b1) begin
		bin_cnt		<= bin_cnt + 1;
		end
	else begin
		bin_cnt		<= 16'h0000;
		end
end

assign b = bin_cnt;

endmodule