// Note Common & combined signal connection
// combine 2 (or more Av-ST stream) to 1 stream
// assuming this version, all parallel channels have simultaneous valid signals (with common ready singal)
// 	[all or nothing]
// So this module only check valid signal incomplete same
// Future version may be changed as following:
// assuming same size and rate packets may have a few latency difference
//   adjusting only by back pressure (no buffer)

module combine_src_vrhs
#(
	parameter PARA_NUM = 2 // 2: EVEN, ODD
)
(
	input	[PARA_NUM-1:0] p_src_valid,
	output	[PARA_NUM-1:0] p_src_ready,
	output	error_aon_valid,

	output	src_valid, // "serial" "combined" valid
	input	src_ready //, "serial" "combined" ready
);

// assign src_valid = (&p_src_valid);	// only all parallel source are valid can be "valid"
assign src_valid = p_src_valid[0];	// only all parallel source are valid can be "valid"
assign error_aon_valid = (&p_src_valid) ? 1'b0 : (|p_src_valid) ; // check all or noting ( 1: error)

assign p_src_ready = {PARA_NUM{ src_ready }};
// assign p_src_ready = {PARA_NUM{ (src_ready & src_valid) }};
		// To SYNCRONIZE, only "ready and all valid can be redy
		// This function may generate "backpressure" and cause stall

endmodule
