// fft_ii_0_example_design.v
// Generated using ACDS version 18.1 625

// Modified: attached user tested design dual_fft

`timescale 1 ps / 1 ps
module fft_ii_0_example_design #(
	parameter SELECT_DUALFFT_OUTPUT = 1
)(
		input  wire        core_clk_clk,              //    core_clk.clk
		input  wire        core_rst_reset_n,          //    core_rst.reset_n
		input  wire        core_sink_valid,           //   core_sink.valid
		output wire        core_sink_ready,           //            .ready
		input  wire [1:0]  core_sink_error,           //            .error
		input  wire        core_sink_startofpacket,   //            .startofpacket
		input  wire        core_sink_endofpacket,     //            .endofpacket
		input  wire [45:0] core_sink_data,            //            .data
		output wire        core_source_valid,         // core_source.valid
		input  wire        core_source_ready,         //            .ready
		output wire [1:0]  core_source_error,         //            .error
		output wire        core_source_startofpacket, //            .startofpacket
		output wire        core_source_endofpacket,   //            .endofpacket
		output wire [70:0] core_source_data           //            .data
	);

	wire  [28:0] core_source_imag; // port fragment
	wire  [28:0] core_source_real; // port fragment
	wire  [12:0] core_fftpts_out;  // port fragment

// additional wires to select output
		wire        org_source_valid;         // core_source.valid
		wire        org_source_ready;         //            .ready
		wire [1:0]  org_source_error;         //            .error
		wire        org_source_startofpacket; //            .startofpacket
		wire        org_source_endofpacket;   //            .endofpacket
		wire [70:0] org_source_data;           //            .data
		wire  [28:0] org_source_imag; // port fragment
		wire  [28:0] org_source_real; // port fragment
		wire  [12:0] org_fftpts_out;  // port fragment
		wire        dff_source_valid;         // core_source.valid
		wire        dff_source_ready;         //            .ready
		wire [1:0]  dff_source_error;         //            .error
		wire        dff_source_startofpacket; //            .startofpacket
		wire        dff_source_endofpacket;   //            .endofpacket
		wire [70:0] dff_source_data;           //            .data
		wire  [28:0] dff_source_imag; // port fragment
		wire  [28:0] dff_source_real; // port fragment
		wire  [12:0] dff_fftpts_out;  // port fragment
//
// compare result
		wire	compare;
		wire	signed [28:0] diff_real;
		wire	signed [28:0] diff_imag;


	fft_ii_0_example_design_altera_fft_ii_181_ymxmb4i core (
		.clk          (core_clk_clk),              //    clk.clk
		.reset_n      (core_rst_reset_n),          //    rst.reset_n
		.sink_valid   (core_sink_valid),           //   sink.valid
		.sink_ready   (core_sink_ready),           //       .ready
		.sink_error   (core_sink_error),           //       .error
		.sink_sop     (core_sink_startofpacket),   //       .startofpacket
		.sink_eop     (core_sink_endofpacket),     //       .endofpacket
		.sink_real    (core_sink_data[45:30]),     //       .data
		.sink_imag    (core_sink_data[29:14]),     //       .data
		.fftpts_in    (core_sink_data[13:1]),      //       .data
		.inverse      (core_sink_data[0]),         //       .data
		.source_valid (org_source_valid), // (core_source_valid),         // source.valid
		.source_ready (org_source_ready), // (core_source_ready),         //       .ready
		.source_error (org_source_error), //(core_source_error),         //       .error
		.source_sop   (org_source_startofpacket), //(core_source_startofpacket), //       .startofpacket
		.source_eop   (org_source_endofpacket), //(core_source_endofpacket),   //       .endofpacket
		.source_real  (org_source_real[28:0]), // (core_source_real[28:0]),    //       .data
		.source_imag  (org_source_imag[28:0]), // (core_source_imag[28:0]),    //       .data
		.fftpts_out   (org_fftpts_out[12:0]) // (core_fftpts_out[12:0])      //       .data
	);

	assign core_source_data = { core_source_real[28:0], core_source_imag[28:0], core_fftpts_out[12:0] };

// 　user additional part

	assign org_source_data = { org_source_real[28:0], org_source_imag[28:0], org_fftpts_out[12:0] };
	assign dff_source_data = { dff_source_real[28:0], dff_source_imag[28:0], dff_fftpts_out[12:0] };

	dual_fft inst_dual_fft (
		.clk          (core_clk_clk),              //    clk.clk
		.reset_n      (core_rst_reset_n),          //    rst.reset_n
		.sink_valid   (core_sink_valid),           //   sink.valid
		.sink_ready   (), // (core_sink_ready),           //       .ready
		.sink_error   (core_sink_error),           //       .error
		.sink_sop     (core_sink_startofpacket),   //       .startofpacket
		.sink_eop     (core_sink_endofpacket),     //       .endofpacket
		.sink_real    (core_sink_data[45:30]),     //       .data
		.sink_imag    (core_sink_data[29:14]),     //       .data
		.fftpts_in    (core_sink_data[13:1]),      //       .data
		.inverse      (core_sink_data[0]),         //       .data
		.source_valid (dff_source_valid), // (core_source_valid),         // source.valid
		.source_ready (dff_source_ready), // (core_source_ready),         //       .ready
		.source_error (dff_source_error), //(core_source_error),         //       .error
		.source_sop   (dff_source_startofpacket), //(core_source_startofpacket), //       .startofpacket
		.source_eop   (dff_source_endofpacket), //(core_source_endofpacket),   //       .endofpacket
		.source_real  (dff_source_real[28:0]), // (core_source_real[28:0]),    //       .data
		.source_imag  (dff_source_imag[28:0]), // (core_source_imag[28:0]),    //       .data
		.fftpts_out   (dff_fftpts_out[12:0]) // (core_fftpts_out[12:0])      //       .data
	);
	
compare_ffts #(29) // data size (real/imag of data)
	U_COMPARE (
		.clk          (core_clk_clk),              //    clk.clk
		.reset_n      (core_rst_reset_n),          //    rst.reset_n
		.org_valdata(org_source_valid&org_source_ready),
		.org_avst_packs({org_source_startofpacket,org_source_endofpacket,
					org_source_real[28:0],org_source_imag[28:0]}), // sop, eop, data(real, imag)
		.dff_valdata(dff_source_valid&dff_source_ready),
		.dff_avst_packs({dff_source_startofpacket,dff_source_endofpacket,
					dff_source_real[28:0],dff_source_imag[28:0]}), // sop, eop, data(real, imag)
		.compare(compare),
		.diff_real(diff_real),
		.diff_imag(diff_imag),
		.error() //,
);

	// output selection switch
		assign core_source_valid = (SELECT_DUALFFT_OUTPUT) ? dff_source_valid : org_source_valid ; // core_source.valid
		assign org_source_ready = (SELECT_DUALFFT_OUTPUT) ? 1'b1 : core_source_ready ;
		assign dff_source_ready = (SELECT_DUALFFT_OUTPUT) ? core_source_ready : 1'b1 ;
		assign core_source_error = (SELECT_DUALFFT_OUTPUT) ? dff_source_error : org_source_error ; //            .error
		assign core_source_startofpacket = (SELECT_DUALFFT_OUTPUT) ? dff_source_startofpacket : org_source_startofpacket ;
		assign core_source_endofpacket = (SELECT_DUALFFT_OUTPUT) ? dff_source_endofpacket : org_source_endofpacket ;
		assign core_source_data = (SELECT_DUALFFT_OUTPUT) ? dff_source_data : org_source_data ; //            .data

endmodule
