// Read wrapper for twiddle rom
// registered output version (latency increase by 1)

module readtwdl
#(
	parameter DATAWIDTH = 36,
	parameter ADDRWIDTH = 11 //, 2^11=2048
)
(
	input clk,
	input reset_n,

	input sclr,
	input read,
	output [DATAWIDTH-1:0] data //,
);
	reg [ADDRWIDTH-1:0] addrcnt;
	reg [DATAWIDTH-1:0] dout_reg;
	wire [DATAWIDTH-1:0] rom_dout;

always @(posedge clk or negedge reset_n)
	if( ~reset_n ) addrcnt <= {ADDRWIDTH{1'b0}};
	else if( sclr ) addrcnt <= {ADDRWIDTH{1'b0}};
	else if( read ) addrcnt <=  addrcnt + 1;
//

TWROM4096HALF U_TWROM(
		.address(addrcnt) , //  rom_input.address
		.clock(clk),   //           .clk
		.q(rom_dout) // (data)        // rom_output.dataout
	);

always @(posedge clk or negedge reset_n)
	if( ~reset_n ) dout_reg <= {DATAWIDTH{1'b0}};
	// NO NEED TO SCLR <BUG> // else if( sclr ) dout_reg <= {DATAWIDTH{1'b0}};
	else 	dout_reg <=  rom_dout;
//
assign data = dout_reg;

endmodule