// Simple DELAY , parameterized DATAWIDTH and LATENCY
module DELAY
#(
	parameter DATAWIDTH = 32,
	parameter LATENCY = 6 //,
)
(
	input clk,
	input reset_n,

	input [DATAWIDTH-1:0] din,
	output [DATAWIDTH-1:0] dout //,
);

	reg [DATAWIDTH-1:0] buf_data [1:LATENCY];

	// VALID buffer array
	reg	valid_buf [1:LATENCY];
	
	// connection wire for gen loop
	wire [DATAWIDTH-1:0] in_data [0:LATENCY];

	genvar i;

	assign in_data[0]	=  din ;
	
	generate for(i = 1; i <= LATENCY; i = i + 1) begin: GEN_LOOP
		always @(posedge clk or negedge reset_n)
			if( ~reset_n ) buf_data[i] <= {(DATAWIDTH){1'b0}};
			else // no condition shift
				buf_data[i] <= in_data[i-1] ;
		assign  in_data[i] = buf_data[i] ;
	end
	endgenerate

assign	dout = in_data[LATENCY];

endmodule