// splitter for valid-ready handshake 
// only handshake signals
// combinational logic version (latency=0)

module split_snk_vrhs
(
	// I/O for single snk side
	input snk_valid,
	output snk_ready,

	// I/O for splitted side (Name keeping "snk")
	// even "ev"
	output snk_val_ev,
	input snk_rdy_ev,
	
	// odd "od"
	output snk_val_od,
	input snk_rdy_od // ,
);

	assign { snk_val_ev, snk_val_od } = {2{snk_valid}};
	assign snk_ready = snk_rdy_ev & snk_rdy_od ;

endmodule
