/*******************************************************************************
 *  Interrupt_Latency_Counter.c
 *
 * attention
 * Copyright (C) 2021 MACNICA,Inc. All Rights Reserved.\n
 *   This software is licensed "AS IS".
 *   Please perform use of this software by a user's own responsibility and expense.
 *   It cannot guarantee in the maker side about the damage which occurred by the ab-
 *   ility not to use or use this software, and all damage that occurred secondarily.
 ********************************************************************************/

/***********************************************************************************
 *  includes
 ***********************************************************************************/
#include "Interrupt_Latency_Counter.h"
#include <stdio.h>

/***********************************************************************************
 * ILC_IRQ_Report
 *
 * ̊֐́APlatform Designer Őݒ肵 IRQ M ILC JE^[l\܂
 *
 * Arguments:
 * - ilc_base : ILC  BASE Address
 *
 * Returns:
 * - none
 ***********************************************************************************/
void ILC_IRQ_Report(void* ilc_base){

	int 	irq_num;
	int 	irq_num_msk;
	alt_u32 irq_set_num;
	alt_u32 control_reg;
	alt_u32 clock_freq_hertz;
	alt_u64 irq_clock;

	// \̏܂
	const char* separator =
			"+---------------+-----------+---------------+\n";
	const char* column_header =
			"| IRQ           | Time (sec)|  Time (clocks)|\n";

	// Control Register ̏ǂݎALɂĂ IRQ vZ܂
	control_reg = IORD(ilc_base, ILC_CONT_REG);
	irq_set_num = (control_reg & ILC_CONT_IRQ_NUM_MASK) >> 2;

	// ILC ̓gǂݎ܂
	clock_freq_hertz = IORD(ilc_base, ILC_FREQ_REG);

	// Report ̖̂Ɛݒ肵 IRQ \܂
	printf("--Interrupt Latency Counter Report--\n");
	printf(" IRQ Num : %d \n",irq_set_num);
	printf("%s",separator);
	printf("%s",column_header);
	printf("%s",separator);

	// ݒ肵 IRQ@ for 񂵂܂
	for (irq_num = 0; irq_num < irq_set_num; irq_num++)
	{
		// Y IRQ ԍ Bit Vtg܂
		irq_num_msk = 1 << irq_num;
		// Y IRQ ԍ Read Data Valid Registers  High ɂȂĂAf[^ǂݎ܂BLow ɂȂĂA0 ܂
		if(IORD(ilc_base,ILC_VALID_REG) & irq_num_msk){
			irq_clock = IORD(ilc_base,irq_num);
		}else{
			irq_clock = 0;
		}
		printf("| IRQ %-10d",irq_num);
		printf("|%11.8f",(((double) irq_clock)) / clock_freq_hertz);
		printf("|%15lld",irq_clock);
		printf("|\n%s",separator);
	}
	printf("\n");
}
