/*******************************************************************************
 *  Interrupt_Latency_Counter.h
 *
 * attention
 * Copyright (C) 2021 MACNICA,Inc. All Rights Reserved.\n
 *   This software is licensed "AS IS".
 *   Please perform use of this software by a user's own responsibility and expense.
 *   It cannot guarantee in the maker side about the damage which occurred by the ab-
 *   ility not to use or use this software, and all damage that occurred secondarily.
 ********************************************************************************/



#ifndef INTERRUPT_LATENCY_COUNTER_H_
#define INTERRUPT_LATENCY_COUNTER_H_
/***********************************************************************************
 *  includes
 ***********************************************************************************/
#include "alt_types.h"
#include "io.h"

/***********************************************************************************
 *  definitions (define, enum, typedef, etc..)
 ***********************************************************************************/
#define ILC_CONT_REG			(0x00000020)		// ILC Control Registers
#define ILC_CONT_ENABLE_DATA	(0x00000001)		// ILC Control Registers Enable Bit Data
#define ILC_CONT_DISABLE_DATA	(0x00000000)		// ILC Control Registers Disable Bit Data
#define ILC_CONT_IRQ_NUM_MASK	(0x000000FC)		// ILC Control Registers IRQ Port Count Mask [7:2]
#define ILC_CONT_IRQ_NUM_BIT	(2)					// ILC Control Registers IRQ Port Count Bit Number [2]
#define ILC_FREQ_REG			(0x00000021)		// ILC Frequency Registers
#define ILC_STOP_REG			(0x00000022)		// ILC Counter Stop Register
#define ILC_VALID_REG			(0x00000023)		// ILC Read Data Valid Registers
#define ILC_IRQ_ACT_REG			(0x00000024)		// ILC IRQ Active Registers

/***********************************************************************************
 *  proto types
 ***********************************************************************************/
void ILC_IRQ_Report(void* ilc_base);



#endif /* INTERRUPT_LATENCY_COUNTER_H_ */
