/*******************************************************************************
 *  file  Performance_Counter_and_ILC_Sample.c
 *
 * attention
 * Copyright (C) 2021 MACNICA,Inc. All Rights Reserved.\n
 *  This software is licensed "AS IS".
 *  Please perform use of this software by a user's own responsibility and expense.
 *  It cannot guarantee in the maker side about the damage which occurred by the ab-
 *  ility not to use or use this software, and all damage that occurred secondarily.
 ********************************************************************************/

/***********************************************************************************
 *  includes
 ***********************************************************************************/
#include <stdio.h>
#include <string.h>
#include <io.h>
#include "system.h"
#include "sys/alt_irq.h"
#include "altera_avalon_pio_regs.h"
#include "altera_avalon_performance_counter.h"
#include "Interrupt_Latency_Counter.h"

/***********************************************************************************
 *  re-definitions
 *  ̃ZNV"system.h"Œ`ꂽ萔A
 *    {\[Xt@CŎgp邽߂ɍĒ`̂łB
 *    gp̍ۂ͉E̒萔"system.h"QƂ̏AύXĂgB
 ***********************************************************************************/
#define LED_CSR_ADR      	(LED_BASE)          					// LED ̃AhX

#define KEY_BIT_MSK			((1 << KEY_DATA_WIDTH) -1)				// KEY ̃rbg}XN
#define KEY_CSR_ADR			(KEY_BASE)								// KEY ̃AhX
#define KEY_IRQ_ID        	(KEY_IRQ_INTERRUPT_CONTROLLER_ID)  		// KEY ̊荞݃Rg[ID
#define KEY_IRQ_NO        	(KEY_IRQ)               				// KEY ̊荞ݔԍ

#define PERF_COUNT_ADR     	(PERFORMANCE_COUNTER_BASE)				// ptH[}XJE^̃AhX
#define PERF_SECTIONS		(PERFORMANCE_COUNTER_HOW_MANY_SECTIONS)	// ptH[}XJE^̃ZNV

#define ILC_ADR				(INTERRUPT_LATENCY_COUNTER_BASE)		// ILC ̃AhX

/***********************************************************************************
 *  definitions (define, enum, typedef, etc..)
 ***********************************************************************************/
#define LOOP_NUM 				(5)					// for ̉񐔁BftHg 5
#define USLEEP_TIME				(1000000)			// usleep()Ɏw肷lBftHg 1000000 = 1s

/***********************************************************************************
 *  proto types
 ***********************************************************************************/
void PIO_Call_Back();

/***********************************************************************************
 *  main function
 ***********************************************************************************/
int main()
{
	int i;
	printf("Nios II Start\n");

	// ILC ̃Zbg
	IOWR(ILC_ADR,ILC_CONT_REG,ILC_CONT_DISABLE_DATA);
	// ILC ON
	IOWR(ILC_ADR,ILC_CONT_REG,ILC_CONT_ENABLE_DATA);

	// ptH[}XJE^̃Zbg
	PERF_RESET(PERF_COUNT_ADR);
	// ptH[}XJE^̋N
	PERF_START_MEASURING(PERF_COUNT_ADR);

	// ZNV 1 vJn
	PERF_BEGIN(PERF_COUNT_ADR, 1);
	{
		// KEY  IRQ  Enable
		IOWR_ALTERA_AVALON_PIO_IRQ_MASK(KEY_CSR_ADR, KEY_BIT_MSK);
		// LED  
		IOWR_ALTERA_AVALON_PIO_DATA(LED_CSR_ADR, 0x00);
		// KEY  Edgecapture NA
		IOWR_ALTERA_AVALON_PIO_EDGE_CAP(KEY_CSR_ADR, 0xf);
		// KEY ̊荞݃nho^
		alt_ic_isr_register(KEY_IRQ_ID, KEY_IRQ_NO, PIO_Call_Back, (void*)KEY_CSR_ADR, 0x0);
		// LED _
		IOWR_ALTERA_AVALON_PIO_DATA(LED_CSR_ADR, 0xFF);
	}
	// ZNV 1 v
	PERF_END(PERF_COUNT_ADR, 1);

	// ZNV 2 vJn
	PERF_BEGIN(PERF_COUNT_ADR, 2);
	{
		usleep(USLEEP_TIME);
	}
	// ZNV 2 v
	PERF_END(PERF_COUNT_ADR, 2);

	// for [vŁA񑪒
	for(i = 0; i < LOOP_NUM; i++){
		// ZNV 3 vJn
		PERF_BEGIN(PERF_COUNT_ADR, 3);
		{
			IOWR_ALTERA_AVALON_PIO_DATA(LED_CSR_ADR, 0xAA);
			usleep(USLEEP_TIME);
			IOWR_ALTERA_AVALON_PIO_DATA(LED_CSR_ADR, 0x55);
			usleep(USLEEP_TIME);
		}
		// ZNV 3 v
		PERF_END(PERF_COUNT_ADR, 3);
	}
	// Performnce Counter ʂ|[g
	perf_print_formatted_report(
			(void*)PERF_COUNT_ADR,	// ptH[}XJE^CSRAhX
			alt_get_cpu_freq(),		// Nios II̓g(=ptH[}XJE^)
			(PERF_SECTIONS-1),		// ZNV|Cg̐
			"Init",					// R\[o͂ۂ̃ZNV
			"usleep 1s",
			"For Loop",
			"KEY IRQ",
			"Unused",
			"Unused"
	);

	// ILC 茋ʃ|[g
	ILC_IRQ_Report((void*)ILC_ADR);

	// ILC I
	IOWR(ILC_ADR,ILC_CONT_REG,ILC_CONT_DISABLE_DATA);

	printf("Nios II Finish\n");
	return 0;
}

/***********************************************************************************
 *  interrupt handler
 ***********************************************************************************/
// PIO input 荞݃nh
void PIO_Call_Back(void * context)
{
	// ZNV 4 vJn
	PERF_BEGIN(PERF_COUNT_ADR, 4);
	{
		int cap;
		// Edge Capture 擾 ꂽ Key 𔻒
		cap = IORD_ALTERA_AVALON_PIO_EDGE_CAP(KEY_CSR_ADR);
		// KEY0  ?
		if(cap & 0x01)
		{
			IOWR_ALTERA_AVALON_PIO_DATA(LED_BASE,0x3);
		}
		// KEY1 ?
		else if(cap & 0x02)
		{
			IOWR_ALTERA_AVALON_PIO_DATA(LED_BASE,0xc);
		}
		// KEY2 ?
		else if(cap & 0x04)
		{
			IOWR_ALTERA_AVALON_PIO_DATA(LED_BASE,0x30);
		}
		// KEY3 ?
		else if(cap & 0x8)
		{
			IOWR_ALTERA_AVALON_PIO_DATA(LED_BASE,0xc0);
		}
		// KEY 𔻒fłȂꍇ
		else{
			IOWR_ALTERA_AVALON_PIO_DATA(LED_CSR_ADR, 0xFF);
		}
		// Edge Capture NA
		IOWR_ALTERA_AVALON_PIO_EDGE_CAP(KEY_CSR_ADR, cap);
	}
	// ZNV 4v
	PERF_END(PERF_COUNT_ADR, 4);
}
