// simple_system_tb.v

// Generated using ACDS version 17.0 595

//`timescale 1 ps / 1 ps
`timescale 1 ns / 100 ps
module simple_system_tb (
	);

	wire    simple_system_inst_clk_bfm_clk_clk;             // simple_system_inst_clk_bfm:clk -> [simple_system_inst:clk_clk, simple_system_inst_reset_bfm:clk]
	wire    simple_system_inst_pio_1_clk_bfm_clk_clk;       // simple_system_inst_pio_1_clk_bfm:clk -> [simple_system_inst:pio_1_clk_clk, simple_system_inst_pio_1_reset_bfm:clk]
	wire    simple_system_inst_pio_1_reset_bfm_reset_reset; // simple_system_inst_pio_1_reset_bfm:reset -> simple_system_inst:pio_1_reset_reset_n
	wire    simple_system_inst_reset_bfm_reset_reset;       // simple_system_inst_reset_bfm:reset -> simple_system_inst:reset_reset_n
	
	
	// Control Signals of Avalon Master added by user
	reg		[19:0]	avmm_addr;
	reg		[1:0]	avmm_be;
	reg				avmm_rd;
	reg				avmm_we;
	reg		[15:0]	avmm_wdata;
	wire	[15:0]	avmm_rdata;
	wire			avmm_waitreq;
	
	// Monitor Signal of PIO_0 added by user
	wire	[7:0]	pio_0_out;
	
	
	
	// Control Signals of PIO_1 added by user
	reg		[1:0]	pio_1_addr;
	reg				pio_1_we_n;
	reg		[31:0]	pio_1_wdata;
	reg				pio_1_cs;
	wire	[31:0]	pio_1_rdata;
	wire	[15:0]	pio_1_out;
	
	

	simple_system simple_system_inst (
		.clk_clk              (simple_system_inst_clk_bfm_clk_clk),             //         clk.clk
		.expt_avmm_address    (avmm_addr),                                               //   expt_avmm.address
		.expt_avmm_byteenable (avmm_be),                                               //            .byteenable
		.expt_avmm_read       (avmm_rd),                                               //            .read
		.expt_avmm_readdata   (avmm_rdata),                                               //            .readdata
		.expt_avmm_write      (avmm_we),                                               //            .write
		.expt_avmm_writedata  (avmm_wdata),                                               //            .writedata
		.expt_avmm_waitreq    (avmm_waitreq),                                               //            .waitreq
		.pio_0_expt_export    (pio_0_out),                                               //  pio_0_expt.export
		.pio_1_clk_clk        (simple_system_inst_pio_1_clk_bfm_clk_clk),       //   pio_1_clk.clk
		.pio_1_expt_export    (pio_1_out),                                               //  pio_1_expt.export
		.pio_1_reset_reset_n  (simple_system_inst_pio_1_reset_bfm_reset_reset), // pio_1_reset.reset_n
		.pio_1_s1_address     (pio_1_addr),                                               //    pio_1_s1.address
		.pio_1_s1_write_n     (pio_1_we_n),                                               //            .write_n
		.pio_1_s1_writedata   (pio_1_wdata),                                               //            .writedata
		.pio_1_s1_chipselect  (pio_1_cs),                                               //            .chipselect
		.pio_1_s1_readdata    (pio_1_rdata),                                               //            .readdata
		.reset_reset_n        (simple_system_inst_reset_bfm_reset_reset)        //       reset.reset_n
	);

	altera_avalon_clock_source #(
		.CLOCK_RATE (50000000),
		.CLOCK_UNIT (1)
	) simple_system_inst_clk_bfm (
		.clk (simple_system_inst_clk_bfm_clk_clk)  // clk.clk
	);

	altera_avalon_clock_source #(
		.CLOCK_RATE (50000000),
		.CLOCK_UNIT (1)
	) simple_system_inst_pio_1_clk_bfm (
		.clk (simple_system_inst_pio_1_clk_bfm_clk_clk)  // clk.clk
	);

	altera_avalon_reset_source #(
		.ASSERT_HIGH_RESET    (0),
		.INITIAL_RESET_CYCLES (50)
	) simple_system_inst_pio_1_reset_bfm (
		.reset (simple_system_inst_pio_1_reset_bfm_reset_reset), // reset.reset_n
		.clk   (simple_system_inst_pio_1_clk_bfm_clk_clk)        //   clk.clk
	);

	altera_avalon_reset_source #(
		.ASSERT_HIGH_RESET    (0),
		.INITIAL_RESET_CYCLES (50)
	) simple_system_inst_reset_bfm (
		.reset (simple_system_inst_reset_bfm_reset_reset), // reset.reset_n
		.clk   (simple_system_inst_clk_bfm_clk_clk)        //   clk.clk
	);
	
	
	initial begin
	
	// Initialize for PIO_1
	pio_1_addr = 2'b00;
	pio_1_we_n = 1'b1;
	pio_1_cs   = 1'b0;
	pio_1_wdata = 32'hxxxxxxxx;
	
	// Initialize for Avalon-MM master
	avmm_addr = 20'h01000;
	avmm_be  = 2'b00;
	avmm_rd  = 1'b0;
	avmm_we  = 1'b0;
	avmm_wdata = 16'hxxxx;
	
		
	#1000;	
	// Reset De-assert
	avmm_wdata = 16'h7abc;
	avmm_be  = 2'b11;
	
	
	pio_1_wdata = 32'h00001234;
	pio_1_cs   = 1'b1;
	
	
	#500
	avmm_we  = 1'b1;
	
	pio_1_we_n = 1'b0;
	
	#3000;
	pio_1_cs   = 1'b1;
	
	#500
	avmm_addr = 20'h00000;
	avmm_wdata = 16'h3456;
	
	#100
	avmm_we  = 1'b0;
	
	#500
	avmm_rd  = 1'b1;
	
	
	
	
	
	
	#3000;
	
	
	end

endmodule
