//*******************************************************************************
// file  sample_master_wrapper.v
//
// attention
// Copyright (C) 2018 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS". 
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
//*******************************************************************************
module sample_master_wrapper(
   // General Interface
        input  wire        	clk,               //   clk
        input  wire        	reset_n,           //   reset_n
        
   // Avalon-MM Slave Interface
        output  wire [19:0] 	avmm_address,      //   address
        output  wire [1:0]  	avmm_byteenable,   //   byteenable
        output  wire        	avmm_read,         //   read
        input	wire [15:0] 	avmm_readdata,     //   readdata
        output  wire        	avmm_write,        //   write
        output  wire [15:0] 	avmm_writedata,    //   writedata
        input	wire				avmm_waitreq,
        
   // Conduit Interface
        input  wire [19:0] 	expt_avmm_address,      //   address for export	 
        input wire [1:0]  	expt_avmm_byteenable,   //   byteenable for export
        input 	wire        	expt_avmm_read,         //   read
        output	wire [15:0] 	expt_avmm_readdata,     //   readdata for export
        input  wire        	expt_avmm_write,        //   write for export
        input  wire [15:0] 	expt_avmm_writedata,    //   writedata for export
        output	wire				expt_avmm_waitreq

    );
    

assign	avmm_address = expt_avmm_address;
assign	avmm_byteenable = expt_avmm_byteenable;
assign	avmm_read = expt_avmm_read;
assign	expt_avmm_readdata = avmm_readdata;
assign	avmm_write = expt_avmm_write;
assign	avmm_writedata = expt_avmm_writedata;
assign	expt_avmm_waitreq = avmm_waitreq;


endmodule