//*******************************************************************************
// file  SFC_Access_sample.c
//
// attention
// Copyright (C) 2021 MACNICA,Inc. All Rights Reserved.\n
//   This software is licensed "AS IS".
//   Please perform use of this software by a user's own responsibility and expense.
//   It cannot guarantee in the maker side about the damage which occurred by the ab-
//   ility not to use or use this software, and all damage that occurred secondarily.
//
// Update 2021 April
//   Add Print Silicon ID
//   Add define "READ_ERASE_ONLY".
//    You can change whether the Erase Write Read function is executed or not with this define
//   Fixed Check_Settings() to work with 512 and above devices
//*******************************************************************************
/***********************************************************************************
 *  includes
 ***********************************************************************************/
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include "system.h"
#include "sys/alt_flash.h"
#include "io.h"
/***********************************************************************************
 *  re-definitions
 *  ̃ZNV"system.h"Œ`ꂽ萔A
 *    {\[Xt@CŎgp邽߂ɍĒ`̂łB
 *    gp̍ۂ͉E̒萔"system.h"QƂ̏AύXĂgB
 ***********************************************************************************/
#define SFC_AVL_MEM_NAME 				(ASFC_II_AVL_MEM_NAME)
#define SFC_AVL_CSR_BASE 				(ASFC_II_AVL_CSR_BASE)
#define SFC_AVL_CSR_SECTOR_SIZE 		(ASFC_II_AVL_CSR_SECTOR_SIZE)
#define SFC_AVL_CSR_SUBSECTOR_SIZE 		(ASFC_II_AVL_CSR_SUBSECTOR_SIZE)
#define SFC_AVL_CSR_NUMBER_OF_SECTORS 	(ASFC_II_AVL_CSR_NUMBER_OF_SECTORS)
#define SFC_AVL_MEM_SPAN 				(ASFC_II_AVL_MEM_SPAN)
//#define PIO_LED_BASE 					(LED_BASE)
/***********************************************************************************
 *  definitions (define, enum, typedef, etc..)
 *   ftHgԂ̖{\[XR[h́AFlash ROM  0x0000_00000 A1 ZN^[f[^̏s܂B
 *    Ă͂Ȃ̈悪 Flash ROM łB
 *    Define Œ`Ă SEC_BASE_ADDANUM_OF_SEC ̒lύX鎖ŁAs Sector 𒲐邱Ƃł܂B
 *    ݒ肵lZN^[̃x[XAhXłȂꍇZN^[̐ Flash ROM 𒴂ꍇ́ANois II I܂B
 ***********************************************************************************/
#define SEC_BASE_ADD 		(0x00000000) 			 			// Erase   Write  Read sZN^[̃x[XAhX
#define NUM_OF_SEC 			(1)//(SFC_AVL_CSR_NUMBER_OF_SECTORS)// Erase   Write  Read sZN^[
#define SECTOR_LOOK 		(0x0)								// Sector Lock ̐ݒlB0x0 ݒ肵ĂƁALOCK s܂B
#define BUFF_SIZE 			(SFC_AVL_CSR_SUBSECTOR_SIZE)		// f[^TCY
#define WRITE_DATA			(0x00)								// Write Data
#define PRINT_LENGTH		(16)								// Print_Sector_Data() ŕ\ 1~256

#define EPCQ_OR_EPCQA 		(1) 								// Read Flag Status ݒ EPCQ = 1 , EPCQA = 0
#define PRINT_LAST_DATA		(0)									// 1 ɂƁAZN^[̍Ō̃f[^\Ȃ珈i݂܂B
#define PRINT_VERIFY_DATA	(1)									// 1 ɂƁAVerify Error ƂȂf[^\܂B

#define PROTECT_CHANGE_ONLY (0)									// 1 ɂƁARead Status ̃`FbN Protect Change ̂ݎs܂BErase Write Read ͎s܂B
#define READ_ERASE_ONLY		(0)									// ݒlɂāAErase Write Read ֐̎sLς܂B
// 0 :Erase Write Read s, 1 :Erase Read sŁAVerify pɁ@ WRITE_DATA  0xFF Œ, 2 :Read sB
#define BULK_ERASE_ON		(0)									// 1 ɂƁASector Erase ɂȂABulk Erase sĂAWrite ܂B
// EPCQ512-L  EPQC1024-L  Bulk Erase T|[gĂ܂B

/***********************************************************************************
 *  variables
 ***********************************************************************************/

/***********************************************************************************
 *  proto types
 ***********************************************************************************/
void Print_Read_Status(unsigned long flash_csr_base);
void Print_Sector_Data(unsigned long read_sector_offset, unsigned char *data, unsigned long length, int print_length);
int Check_Settings(unsigned long start_address, unsigned long access_number_sector, unsigned long flash_mem_span, unsigned long flash_sector_size, unsigned long flash_number_sector);
int Change_Protection(alt_flash_dev *flash_info, unsigned long flash_csr_base, unsigned long sector_lock_id);
int Erase(alt_flash_dev *flash_info, void *read_buf_add, unsigned long flash_csr_base, int block_offset, int length);
int Write_Block(alt_flash_dev *flash_info, unsigned long flash_csr_base, int sector_offset, int data_offset, const void *buf_add, int length);
int Read_Verify(alt_flash_dev *flash_info, int read_offset, unsigned long write_offset, void *read_buf_add, const void *write_buf_add, int length);


/***********************************************************************************
 *  main function
 ***********************************************************************************/
int main()
{
	unsigned char buf_read_data[BUFF_SIZE];
	unsigned char buf_write_data[BUFF_SIZE];

	int i,j;
	int ret_code = 0;
	int sector_offset = SEC_BASE_ADD;
	alt_flash_fd* fd;


	printf("\nHello from Nios II!\n");
	printf("!!!!! Please use a Flash ROM that can be rewritten. !!!!!\n");
	//IOWR(PIO_LED_BASE, 0, 0xFF);


	//ݒ肵ASEC_BASE_ADD  NUM_OF_SEC dlɍĂ邩mF܂BԈĂꍇ Nios II ͏I܂B
	ret_code = Check_Settings(SEC_BASE_ADD, NUM_OF_SEC, SFC_AVL_MEM_SPAN, SFC_AVL_CSR_SECTOR_SIZE, SFC_AVL_CSR_NUMBER_OF_SECTORS);
	if(ret_code != 0){
		printf("Finish Nios II");
		return 0;
	}

	// Write f[^܂
	for(i = 0; i < BUFF_SIZE; i++){
#if !(READ_ERASE_ONLY == 1)
		buf_write_data[i] = WRITE_DATA+i;
#else
		buf_write_data[i] = 0xFF;
#endif
	}

	printf("Silicon ID = 0x%x\n",IORD_32DIRECT(SFC_AVL_CSR_BASE, 0x8));
	//IORD_ALTERA_QSPI_CONTROLLER2_RDID(SFC_AVL_CSR_BASE);

	// Flash Controller  Open ܂BsƁANios II ͏I܂B
	fd = alt_flash_open_dev(SFC_AVL_MEM_NAME);
	if (fd != NULL){
		printf("Open flash device\n");
		Print_Read_Status(SFC_AVL_CSR_BASE);
	}else{
		printf("Can not open flash device : fd = %d\n",fd);
		Print_Read_Status(SFC_AVL_CSR_BASE);
		alt_flash_close_dev(fd);
		printf("Finish Nios II");
		return 0;
	}
	// Protect ܂BSECTOR_LOOK 𐳂ݒ肷鎖ŁALock o܂B֐̎sɎs Nios II ͏I܂B
	ret_code = Change_Protection(fd, SFC_AVL_CSR_BASE, SECTOR_LOOK);
	if(ret_code != 0){
		alt_flash_close_dev(fd);
		printf("Finish Nios II");
		return 0;
	}

#if !PROTECT_CHANGE_ONLY
#if BULK_ERASE_ON
#if (READ_ERASE_ONLY == 1)||(READ_ERASE_ONLY==0)

	// Bulk Erase s܂BErase ɎsƁANios II ͏I܂B
	ret_code = Erase(fd, buf_read_data, SFC_AVL_CSR_BASE, sector_offset, BUFF_SIZE);
	if(ret_code != 0){
		alt_flash_close_dev(fd);
		printf("Finish Nios II");
		return 0;
	}
#endif
#endif
	// Sector ƂɁAErase ASub Sector  Write,Read,Verify ܂B
	for(i = 0; i < NUM_OF_SEC; i++){
		ret_code = 0;
		int write_offset = sector_offset;
		int read_offset = sector_offset;

		printf("\n*******************************************\n");
		printf("\nNumber of Writes= %d [n]\nWrite Offset = 0x%x (Sector Number = %d)\n\n", i, sector_offset,sector_offset / SFC_AVL_CSR_SECTOR_SIZE);

#if !BULK_ERASE_ON
#if (READ_ERASE_ONLY == 1)||(READ_ERASE_ONLY==0)
		// Sector Erase s܂BErase ɎsƁANios II ͏I܂B
		ret_code = Erase(fd, buf_read_data, SFC_AVL_CSR_BASE, sector_offset, BUFF_SIZE);
		if(ret_code != 0){
			alt_flash_close_dev(fd);
			printf("Finish Nios II");
			return 0;
		}
#endif
#endif
		// Sub Sector ɁAWrite AVerify ɐmF܂B Write ֐̎sɎs Verify ɎśANios II ͏I܂B
		// PRINT_VERIFY_DATA@LɂĂꍇAVerify ɎsɃf[^_v܂B
		// PRINT_LAST_DATA LɂĂꍇASector ̍Ō̃f[^_vȂ珈i݂܂B
		printf("Memory Test Start\n");
		for(j = 0; j < SFC_AVL_CSR_SECTOR_SIZE / SFC_AVL_CSR_SUBSECTOR_SIZE; j++){
#if (READ_ERASE_ONLY == 0)
			//Sub Sector  Write ܂B
			ret_code = Write_Block(fd, SFC_AVL_CSR_BASE, sector_offset, write_offset, buf_write_data, BUFF_SIZE);
#endif
			// Write ֐삵ARead  Verify s܂B
			if(ret_code == 0){
				ret_code=Read_Verify(fd, read_offset, write_offset, buf_read_data, buf_write_data, BUFF_SIZE);
				if (ret_code != 0){
#if PRINT_VERIFY_DATA
					Print_Sector_Data(read_offset, buf_read_data, BUFF_SIZE, PRINT_LENGTH);
#endif
					alt_flash_close_dev(fd);
					printf("Verify Error\nFinish Nios II");
					return 0;
				}
				read_offset = read_offset + SFC_AVL_CSR_SUBSECTOR_SIZE;
				write_offset = write_offset + SFC_AVL_CSR_SUBSECTOR_SIZE;
			}
			else {
				printf("Write Error = %d \n", ret_code);
				alt_flash_close_dev(fd);
				printf("Finish Nios II");
				return 0;
			}
		}
		sector_offset = sector_offset + SFC_AVL_CSR_SECTOR_SIZE;
		//IOWR(PIO_LED_BASE, 0, i);

#if PRINT_LAST_DATA
		Print_Sector_Data(read_offset - SFC_AVL_CSR_SUBSECTOR_SIZE, buf_read_data, BUFF_SIZE, PRINT_LENGTH);
#endif
	}
#endif
	alt_flash_close_dev(fd);
	printf("\n*******************************************\n");
	printf("Finish Erase Write Read");
	printf("\n*******************************************\n");
	printf("Finish Nios II");
	return 0;
}

/***********************************************************************************
 *  sub function
 ***********************************************************************************/

/***********************************************************************************
 * Print_Read_Status
 *
 * ̊֐́AFlash ROM  Status  Read ĕ\܂B
 * #define EPCQ_OR_EPCQA ̐ݒɂāAeς܂B
 *
 * Arguments:
 * - flash_csr_base: SFC_AVL_CSR_BASE : Flash Controller CSR Base Address
 *
 * Returns:
 * - none
 ***********************************************************************************/
void Print_Read_Status(unsigned long flash_csr_base){
#if EPCQ_OR_EPCQA
	//for EPCQ
	printf("Read Status = 0x%x\nRead Flag Status = 0x%x \n\n", IORD_32DIRECT(flash_csr_base,0x0), IORD(flash_csr_base, 0x7));
#else
	//for EPCQA
	printf("Read Status = 0x%x\n\n", IORD_32DIRECT(flash_csr_base,0x0));
#endif
}
/***********************************************************************************
 * Print_Sector_Data
 *
 * ̊֐́Aw肵obt@[̃f[^_v܂B
 * print_lentgh ̒lŁA\񐔂ύXł܂B
 *
 * Arguments:
 * - read_sector_offset: Offset Info
 * - *data:  Buffer
 * - length: Date Length
 * - print_length: \񐔁@0~256
 *
 * Returns:
 * - none
 ***********************************************************************************/
void Print_Sector_Data(unsigned long read_sector_offset, unsigned char *data, unsigned long length, int print_length){
	int i;
	unsigned char *data_buf = data, ascii_buf[print_length+1];

	// \鍀ڂ  print_length \
	printf("\n-Address--|");
	for(i = 0; i < print_length; i++){
		if(i == (print_length-1)){
			printf("%02x",i);
		}else{
			printf("%02x ",i);
		}
	}
	printf("| ASCII\n");
	printf("--------");
	for(i = 0; i <= print_length; i++){
			printf("--+");
	}
	for(i = 0; i < print_length; i++){
		printf("-");
	}
	printf("\n");

	// length  f[^\
	while((data_buf - data) < length){
		printf("0x%08lx ", read_sector_offset);
		for (i = 0; i < print_length; i++) {
			ascii_buf[i] = (unsigned char)((*data_buf < 0x20 || *data_buf >= 0x7f) ? '.': *data_buf);
			printf("%02X ", (int)*data_buf);

			if ((++data_buf - data) >= length) {
				ascii_buf[++i] = '\0';
				for (; i < print_length; i++) {
					printf("   ");
				}
				break;
			}
		}
		// IR[hŌ̓āAASCII \
		ascii_buf[print_length] = '\0';
		printf("%s\n", ascii_buf);
		read_sector_offset = read_sector_offset + print_length;
	}
}
/***********************************************************************************
 * Check_Settings
 *
 * ̊֐́A
 * start_address
 * access_number_sector
 * ̒lgp Flash ROM ̎dlɍĂ邩mF܂B
 *
 * Arguments:
 * - start_address: SEC_BASE_ADD : ANZXAFlash ROM ̃X^[gAhX
 * - access_number_sector: NUM_OF_SEC : ANZXZN^[̐
 * - flash_mem_span: SFC_AVL_MEM_SPAN : Flash ROM ̃TCY
 * - flash_sector_size: SFC_AVL_CSR_SECTOR_SIZE : Flash ROM ̃ZN^[TCY
 * - flash_number_sector: SFC_AVL_CSR_NUMBER_OF_SECTORS : Flash ROM ̃ZN^[TCY
 *
 * Returns:
 * - 0: Not Settings Error
 * - 1: Error
 ***********************************************************************************/
int Check_Settings(unsigned long start_address, unsigned long access_number_sector, unsigned long flash_mem_span, unsigned long flash_sector_size, unsigned long flash_number_sector){
	signed long error = 0;
	printf("The Start Sector Address you set = 0x%lx\n",start_address);
	printf("The Number of Sector you set = %ld\n",access_number_sector);
	// write_number_sector  0 ȂmF܂B
	if(access_number_sector != 0){
		// start_address AFlash ROM ̃AhXl𒴂ĂȂmF܂B
		if(start_address > flash_mem_span){
			printf("** The Start Sector Address you set is over.\n");
			error = 1;
		}
		// start_address  Sector Base Address ɂȂĂ邩mF܂B
		if(start_address % flash_sector_size){
			printf("** The Start Sector Address you set is not The Sector Base Address.\n");
			printf("**** Please Set the correct the Start Sector Address.\n");
			error = 1;
		}
		// ݒ肵 write_number_sector  start_address ŏ Sector ȂmF܂B
		if(access_number_sector + (start_address / flash_sector_size) > flash_number_sector){
			printf("** The Number of Sectors you set is over.\n");
			printf("**** Please Set the correct the Number of Sectors.\n");
			printf("**** You need to set the Number of Sectors to within %ld. \n",SFC_AVL_CSR_NUMBER_OF_SECTORS - (start_address / flash_sector_size));
			error = 1;
		}
	}else{
		printf("** The Number of Sectors you have set is 0.\n");
		printf("**** You need to set the Number of Sectors to be greater than 0\n");
		error = 1;
	}

	if(error == 0){
		printf("There are no setting errors.\n");
		printf("\n");
	}else{
		printf("There are setting errors. \n");
	}
	return error;
}
/***********************************************************************************
 * Change_Protection
 *
 * ̊֐́A
 * sector_lock_id
 * ̒lɁAFlash ROM  Protect ̐ݒs܂B
 *
 * Arguments:
 *@- *flash_info: Pointer to EPCQ flash device structure.
 *@- flash_csr_base: SFC_AVL_CSR_BASE : Flash Controller CSR Base Address
 *@- sector_lock_id: Block protection bits in Flash ROM ==> Bit4 | Bit3 | Bit2 | Bit1 | Bit0
 *                                                           TB  | BP3  | BP2  | BP1  | BP0
 *
 * Returns:
 * - 0: Not Error
 * - not 0: Error
 *
 ***********************************************************************************/
int Change_Protection(alt_flash_dev *flash_info, unsigned long flash_csr_base, unsigned long sector_lock_id){
	int ret_code = 0;
	// write enable command
	IOWR_32DIRECT(flash_csr_base, 0xC, 0x4);
	//IOWR(flash_csr_base,0x3,0x4);

	// Protect Change
	ret_code = alt_lock_flash(flash_info, sector_lock_id);

	if(ret_code == 0){
		printf("Protect Change OK\n");
		Print_Read_Status(flash_csr_base);
	}else{
		printf("Protect Change Error = %d \n", ret_code);
	}
	return ret_code;
}
/***********************************************************************************
 * Erase
 *
 * ̊֐́Aw肵 ZN^[x[XAhX̃ZN^[C[X܂B
 *
 * #define BULK_ERASE_ON
 * ̒lA1 ̏ꍇ́ABulk Erase s܂B
 * WIP Check sABusy ܂ Wait ܂B
 * C[X Read Status ̏Ԃ\܂B
 * ŌɁAC[XɐĂ邩ARead  Verify ܂B
 *
 * Arguments:
 *@- *flash_info: Pointer to EPCQ flash device structure.
 *@- *read_buf_add: Read obt@[
 *@- flash_csr_base: SFC_AVL_CSR_BASE : Flash Controller CSR Base Address
 *@- block_offset: C[XZN^[̃x[XAhX
 *@- length:@f[^̒
 *
 * Returns:
 * - 0: Not Error
 * - not 0: Error
 ***********************************************************************************/
int Erase(alt_flash_dev *flash_info, void *read_buf_add, unsigned long flash_csr_base, int block_offset, int length){
	int ret_code = 0;
	int i;
	unsigned char buf_erase[length];

	// Erase f[^܂
	for(i = 0; i < length; i++){
		buf_erase[i] = 0xFF;
	}

	// Erase
#if !BULK_ERASE_ON
	//Sector Erase s܂B
	//Sector Erase ́AROM  Busy ɂȂ̂ŁAWIP Check  Non Busy ɂȂ܂ő҂܂B
	printf("Erase Sector = 0x%x\n",block_offset);
	ret_code = alt_erase_flash_block(flash_info, block_offset, length);
#endif
#if BULK_ERASE_ON
	printf("Bulk Erase\n");
	//Bulk Erase s܂B
	//Bulk Erase ́AROM  Busy ɂȂ̂ŁAWIP Check  Non Busy ɂȂ܂ő҂܂B
	// write enable command
	IOWR_32DIRECT(flash_csr_base, 0xC, 0x4);
	// Bulk Erase Command
	IOWR_32DIRECT(flash_csr_base, 0xC, 0x1);
#endif
	printf("//**** After Erase ****//\n");
	Print_Read_Status(flash_csr_base);

	// WIP Check
	while(IORD_32DIRECT(flash_csr_base, 0x0) & 0x00000001);
	printf("//**** After WIP Check ****//\n");
	Print_Read_Status(flash_csr_base);

	if(ret_code == 0){
		printf("Erase Check\n");
		ret_code=Read_Verify(flash_info, block_offset, block_offset, read_buf_add, buf_erase, length);
		if(ret_code == 0){
			printf("Erase OK, Data is 0xFF\n\n");
		}else{
			printf("Erase Error = %d\nData is not 0xFF\n",ret_code);
#if PRINT_VERIFY_DATA
					Print_Sector_Data(block_offset, read_buf_add, length, PRINT_LENGTH);
#endif
		}
	}else{
		printf("Erase Error = %d \n", ret_code);
	}


	return ret_code;
}
/***********************************************************************************
 * Write_Block
 *
 * ̊֐́AZN^[x[XAhXƂ̃ZN^[ɂAhXw肵āAw肵 Write obt@[̃f[^݂܂B
 * ZN^[܂݂ɂ͑ΉĂ܂B
 *
 * WIP Check sABusy ܂ Wait ܂B
 *
 * Arguments:
 *@- *flash_info: Pointer to EPCQ flash device structure.
 *@- flash_csr_base: SFC_AVL_CSR_BASE : Flash Controller CSR Base Address
 *@- sector_offset: Write ZN^[̃x[XAhX
 *@- data_offset: Write ZN^[̃AhX
 *@-@*buf_add: Write f[^̃AhX
 *@- length:@Write f[^̒
 *
 * Returns:
 * - 0: Not Error
 * - not 0: Error
 ***********************************************************************************/
int Write_Block(alt_flash_dev *flash_info, unsigned long flash_csr_base, int sector_offset, int data_offset, const void *buf_add, int length){
	int ret_code = 0;
	//Sub Sector  Write ܂B
	//Sector Write ́AROM  Busy ɂȂ̂ŁAWIP Check  Non Busy ɂȂ܂ő҂܂B
	ret_code = alt_write_flash_block(flash_info, sector_offset, data_offset, buf_add, length);
	while(IORD_32DIRECT(flash_csr_base, 0x0) & 0x00000001);
	return ret_code;
}
/***********************************************************************************
 * Read_Verify
 *
 * ̊֐́Aw肵AhXɂf[^w肵 Read obt@[Ɋi[ ܂B
 * ǂݏof[^Ǝw肵 Write obt@[r Verify ܂B
 * Verify ɐǂ\āAG[ɂȂꍇ́A0 ȊO̒lԂ܂B
 *
 * WIP Check sABusy ܂ Wait ܂B
 *  *
 * Arguments:
 *@- *flash_info: Pointer to EPCQ flash device structure.
 *@- read_offset: Read AhX
 *@- write_Offset: Write AhX
 *@- *read_buf_add: Read obt@[̃AhX
 *@-@*write_buf_add: Write obt@[̃AhX
 *@- length:@ f[^̒
 *
 * Returns:
 * - 0: Not Error
 * - not 0: Error
 ***********************************************************************************/

int Read_Verify(alt_flash_dev *flash_info, int read_offset, unsigned long write_offset, void *read_buf_add, const void *write_buf_add, int length){
	int ret_code = 0;
	// w肵AhX̃f[^ǂݏo܂B
	ret_code = alt_read_flash(flash_info, read_offset, read_buf_add, length);
	if(ret_code == 0){
		// ǂݏof[^Ə񂾃f[^_v܂BG[̏ꍇA 0 ȊO̒lԂ܂B
		ret_code = memcmp(write_buf_add, read_buf_add, length);
		if (ret_code == 0){
			printf("Write Offset 0x%08lx : Read Offset 0x%08x : Verify was successful\n",write_offset, read_offset);
		}else{
			printf("Write Offset 0x%08lx : Read Offset 0x%08x : Verify was Error = %d \n",write_offset, read_offset, ret_code);
		}
	}else{
		printf("Read Error = %d \n", ret_code);
	}
	return ret_code;
}
